/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import org.apache.commons.text.translate.NumericEntityUnescaper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NumericEntityUnescaperTest {
    @Test
    public void testCreatesNumericEntityUnescaperOne() {
        NumericEntityUnescaper.OPTION[] numericEntityUnescaperOPTIONArray = new NumericEntityUnescaper.OPTION[]{};
        NumericEntityUnescaper numericEntityUnescaper = new NumericEntityUnescaper(numericEntityUnescaperOPTIONArray);
        Assertions.assertEquals((Object)"2|y|O7y`&#uVWj", (Object)numericEntityUnescaper.translate((CharSequence)"2|y|O7y`&#uVWj"));
    }

    @Test
    public void testCreatesNumericEntityUnescaperTwo() {
        NumericEntityUnescaper.OPTION[] numericEntityUnescaperOPTIONArray = new NumericEntityUnescaper.OPTION[]{};
        NumericEntityUnescaper numericEntityUnescaper = new NumericEntityUnescaper(numericEntityUnescaperOPTIONArray);
        Assertions.assertEquals((Object)"Ws2v8|O=7NR&#cB", (Object)numericEntityUnescaper.translate((CharSequence)"Ws2v8|O=7NR&#cB"));
    }

    @Test
    public void testOutOfBounds() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        Assertions.assertEquals((Object)"Test &", (Object)neu.translate((CharSequence)"Test &"), (String)"Failed to ignore when last character is &");
        Assertions.assertEquals((Object)"Test &#", (Object)neu.translate((CharSequence)"Test &#"), (String)"Failed to ignore when last character is &");
        Assertions.assertEquals((Object)"Test &#x", (Object)neu.translate((CharSequence)"Test &#x"), (String)"Failed to ignore when last character is &");
        Assertions.assertEquals((Object)"Test &#X", (Object)neu.translate((CharSequence)"Test &#X"), (String)"Failed to ignore when last character is &");
    }

    @Test
    public void testSupplementaryUnescaping() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        String input = "&#68642;";
        String expected = "\ud803\udc22";
        String result = neu.translate((CharSequence)"&#68642;");
        Assertions.assertEquals((Object)"\ud803\udc22", (Object)result, (String)"Failed to unescape numeric entities supplementary characters");
    }

    @Test
    public void testUnfinishedEntity() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[]{NumericEntityUnescaper.OPTION.semiColonOptional});
        String input = "Test &#x30 not test";
        String expected = "Test 0 not test";
        String result = neu.translate((CharSequence)input);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Failed to support unfinished entities (i.e. missing semicolon)");
        neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        expected = input = "Test &#x30 not test";
        result = neu.translate((CharSequence)input);
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Failed to ignore unfinished entities (i.e. missing semicolon)");
        neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[]{NumericEntityUnescaper.OPTION.errorIfNoSemiColon});
        input = "Test &#x30 not test";
        try {
            result = neu.translate((CharSequence)input);
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

