/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import java.util.Vector;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.watson.ElementDelta;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.IDeltaFilter;
import org.eclipse.core.internal.watson.IElementComparator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ElementTreeDelta {
    protected IElementComparator comparator;
    protected DeltaDataTree deltaTree;
    protected ElementTree elementTree;
    protected ElementTree parent;
    protected IPath rootPath;

    ElementTreeDelta(ElementTree parent, ElementTree elementTree, IElementComparator comparator) {
        this.initialize(parent, elementTree, comparator);
        this.deltaTree = elementTree.getDataTree().compareWith(parent.getDataTree(), comparator).asReverseComparisonTree(comparator);
        this.rootPath = Path.ROOT;
    }

    ElementTreeDelta(ElementTree parent, ElementTree elementTree, IElementComparator comparator, IPath path) {
        this.initialize(parent, elementTree, comparator);
        this.deltaTree = parent.getDataTree().compareWith(elementTree.getDataTree(), comparator, path);
        this.rootPath = path;
    }

    public void destroy() {
        this.comparator = null;
        this.deltaTree = null;
        this.elementTree = null;
        this.parent = null;
        this.rootPath = null;
    }

    protected ElementDelta[] getAffectedElements(IPath parentID, IDeltaFilter filter) {
        IPath parentKey = parentID == null ? this.deltaTree.rootKey() : parentID;
        Vector<ElementDelta> v = new Vector<ElementDelta>();
        IPath[] childKeys = this.deltaTree.getChildren(parentKey);
        int i = 0;
        while (i < childKeys.length) {
            IPath key = childKeys[i];
            NodeComparison nodeComparison = (NodeComparison)this.deltaTree.getData(key);
            int userComparison = nodeComparison.getUserComparison();
            if (filter.includeElement(userComparison)) {
                v.addElement(new ElementDelta(this, this.rootPath.append(key), key, nodeComparison));
            }
            ++i;
        }
        Object[] result = new ElementDelta[v.size()];
        v.copyInto(result);
        return result;
    }

    DeltaDataTree getDeltaTree() {
        return this.deltaTree;
    }

    public ElementDelta getElementDelta(IPath key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        try {
            NodeComparison nodeComparison = (NodeComparison)this.deltaTree.getData(key);
            return new ElementDelta(this, this.rootPath.append(key), key, nodeComparison);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return null;
        }
    }

    public ElementTree getElementTree() {
        return this.elementTree;
    }

    public ElementTree getParent() {
        return this.parent;
    }

    protected boolean hasAffectedElements(IPath parentID, IDeltaFilter filter) {
        IPath parentKey = parentID == null ? this.deltaTree.rootKey() : parentID;
        IPath[] childKeys = this.deltaTree.getChildren(parentKey);
        int i = 0;
        while (i < childKeys.length) {
            NodeComparison nodeComparison = (NodeComparison)this.deltaTree.getData(childKeys[i]);
            if (filter.includeElement(nodeComparison.getUserComparison())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void initialize(ElementTree parent, ElementTree elementTree, IElementComparator comparator) {
        parent.immutable();
        elementTree.immutable();
        this.parent = parent;
        this.elementTree = elementTree;
        this.comparator = comparator;
    }
}

