/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.verifier;

import org.aspectj.apache.bcel.Repository;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.verifier.VerificationResult;
import org.aspectj.apache.bcel.verifier.Verifier;
import org.aspectj.apache.bcel.verifier.VerifierFactory;
import org.aspectj.apache.bcel.verifier.VerifierFactoryObserver;

public class TransitiveHull
implements VerifierFactoryObserver {
    private int indent = 0;

    private TransitiveHull() {
    }

    @Override
    public void update(String classname) {
        System.gc();
        int i = 0;
        while (i < this.indent) {
            System.out.print(" ");
            ++i;
        }
        System.out.println(classname);
        ++this.indent;
        Verifier v = VerifierFactory.getVerifier(classname);
        VerificationResult vr = v.doPass1();
        if (vr != VerificationResult.VR_OK) {
            System.out.println("Pass 1:\n" + vr);
        }
        if ((vr = v.doPass2()) != VerificationResult.VR_OK) {
            System.out.println("Pass 2:\n" + vr);
        }
        if (vr == VerificationResult.VR_OK) {
            JavaClass jc = Repository.lookupClass((String)v.getClassName());
            int i2 = 0;
            while (i2 < jc.getMethods().length) {
                vr = v.doPass3a(i2);
                if (vr != VerificationResult.VR_OK) {
                    System.out.println(String.valueOf(v.getClassName()) + ", Pass 3a, method " + i2 + " ['" + jc.getMethods()[i2] + "']:\n" + vr);
                }
                if ((vr = v.doPass3b(i2)) != VerificationResult.VR_OK) {
                    System.out.println(String.valueOf(v.getClassName()) + ", Pass 3b, method " + i2 + " ['" + jc.getMethods()[i2] + "']:\n" + vr);
                }
                ++i2;
            }
        }
        --this.indent;
    }

    public static void main(String[] args) {
        int dotclasspos;
        if (args.length != 1) {
            System.out.println("Need exactly one argument: The root class to verify.");
            System.exit(1);
        }
        if ((dotclasspos = args[0].lastIndexOf(".class")) != -1) {
            args[0] = args[0].substring(0, dotclasspos);
        }
        args[0] = args[0].replace('/', '.');
        TransitiveHull th = new TransitiveHull();
        VerifierFactory.attach(th);
        VerifierFactory.getVerifier(args[0]);
        VerifierFactory.detach(th);
    }
}

