#
# Color... task rc._forcecolor=on gives control character escape 
# sequences that do colorization in xterm... convert them to 
# RGB values and use them...
#
# $Id: color.tcl,v 1.30 2011/02/17 11:25:48 rader Exp $
#

# 16 color foregrounds...
set c82rgb(30) "000000"; set c82rgb(31) "cd0000"; set c82rgb(32) "00cd00"; set c82rgb(33) "cdcd00";
set c82rgb(34) "0000ee"; set c82rgb(35) "cd00cd"; set c82rgb(36) "00cdcd"; set c82rgb(37) "ffffff";

# 16 color backgrounds...
set c82rgb(40) "000000"; set c82rgb(41) "cd0000"; set c82rgb(42) "00cd00"; set c82rgb(43) "cdcd00";
set c82rgb(44) "0000ee"; set c82rgb(45) "cd00cd"; set c82rgb(46) "00cdcd"; set c82rgb(47) "ffffff";

# 16 color bright backgrounds...
set c82rgb(100) "000000"; set c82rgb(101) "ff0000"; set c82rgb(102) "00ff00"; set c82rgb(103) "ffff00";
set c82rgb(104) "0000ff"; set c82rgb(105) "ff00ff"; set c82rgb(106) "00ffff"; set c82rgb(107) "ffffff";

# 256 color system colors...
set c2562rgb(0)  "000000"; set c2562rgb(1)  "cd0000"; set c2562rgb(2)  "00cd00"; set c2562rgb(3)  "cdcd00";
set c2562rgb(4)  "0000ee"; set c2562rgb(5)  "cd00cd"; set c2562rgb(6)  "00cdcd"; set c2562rgb(7)  "e5e5e5";
set c2562rgb(8)  "7f7f7f"; set c2562rgb(9)  "ff0000"; set c2562rgb(10) "00ff00"; set c2562rgb(11) "ffff00";
set c2562rgb(12) "5c5cff"; set c2562rgb(13) "ff00ff"; set c2562rgb(14) "00ffff"; set c2562rgb(15) "ffffff";

# 256 color rgb colors...
for {set g 0} {$g < 6} {incr g} { for {set r 0} {$r < 6} {incr r} { for {set b 0} {$b < 6} {incr b} {
  set index [expr 16 + $r*36 + $g*6 + $b]
  set rh [format "%.2x" [expr $r * 51]] 
  set gh [format "%.2x" [expr $g * 51]]
  set bh [format "%.2x" [expr $b * 51]]
  set c2562rgb($index) "$rh$gh$bh"
}}}

# 256 color gray ramp...
for {set g 0} {$g < 24} {incr g} {
  set index [expr $g + 232]
  set h [format "%.2x" [expr $g * 10 + 8]]
  set c2562rgb($index) "$h$h$h"
}

###############################################################################
# Strip xterm control characters so plain text
# can be parsed...

proc StripControlChars { l } { 
  regsub -all {\x1b.*?m} $l "" l
  return $l
}

###############################################################################
# Brighten a #RRGGBB color...

proc IncreaseSaturation { color delta } {
  if { ! [scan $color "#%2x%2x%2x" r g b] } { return $color }
  incr r $delta; incr g $delta; incr b $delta
  if { $r > 255 } { set r 255 }
  if { $g > 255 } { set g 255 }
  if { $b > 255 } { set b 255 }
  set acolor [format "#%.2x%.2x%.2x" $r $g $b]
  return $acolor
}

###############################################################################
# Wrapper around splitting on the xterm control 
# character, parsing it and doing inserts...

proc ColorizedInsert { type line } {
  global debug cols selection_bg selection_fg_brightness 
  global display_mode cur_task_cmd

  if { $display_mode == "undo" } { set type "text" }  ;# FIXME a hack until undo can be scrollable
  if { [regexp {^burn} $cur_task_cmd] } { set type "text" }  ;# FIXME a hack until burndown has a cursor

  if { $type == "selection-bar" && $display_mode == "report" } {
 
    # normal selection bar: brightened fg on selection_bg...
    if { $debug } { puts "ColorizedInsert: normal selection bar" }
    set line_info [ParseString $line]
    set fg [lindex $line_info 0]
    set fg [IncreaseSaturation $fg $selection_fg_brightness]
    set ul [lindex $line_info 2]
    set bold [lindex $line_info 3]
    set tag [GetTag $fg $selection_bg $ul $bold]
    set lraw [StripControlChars $line]
    set width [expr $cols - 2]
    set str [format "%-${width}s" "$lraw"]
    .t.lb insert end " "
    .t.lb insert end "$str" $tag
    .t.lb insert end " "

  } elseif { $type == "selection-bar" } {

    # aux report selection bar: brightened fg with > <...
    if { $debug } { puts "ColorizedInsert: aux report selection bar" }
    set c 1
    set str "NOPREVSTR"
    .t.lb insert end ">"
    set ptag ""
    foreach tok [split $line "\x1b"] {
      if { $str == "" } {
        # prev ctrl seq usually belongs to THIS tok...
        if { ! [regexp {^sum} $cur_task_cmd] } { 
          set tok "$ptok$tok"
        }
      }
      set tok_info [ParseString $tok]
      set fg [lindex $tok_info 0]
      set fg [IncreaseSaturation $fg $selection_fg_brightness]
      set bg [lindex $tok_info 1]
      set ul [lindex $tok_info 2]
      set bold [lindex $tok_info 3]
      set str [lindex $tok_info 4]
      set tag [GetTag $fg $bg $ul $bold]
      .t.lb insert end "$str" $tag
      set c [expr $c + [string length $str]]
      set ptok $tok
      if { $str != "" } {  
        # save color tag for padding...
        set ptag $tag
      }
    }
    set width [expr $cols - 2] ;# first & last 
    set pad [expr $cols - $c]
    set s ""
    for { set i 1 } { $i < $pad } {incr i } { set s "$s " } 
    if { ! [regexp {^cal} $cur_task_cmd] && 
         ! [regexp {^col} $cur_task_cmd] && 
         ! [regexp {^ghistory} $cur_task_cmd] && 
         ! [regexp {^history} $cur_task_cmd] && 
         ! [regexp {^proj} $cur_task_cmd] &&
         ! [regexp {^sum} $cur_task_cmd] && 
         ! [regexp {^ta} $cur_task_cmd] } {
      .t.lb insert end $s $ptag
    } elseif { ! [regexp {^proj} $cur_task_cmd] &&
               ! [regexp {^sum} $cur_task_cmd] &&
               ! [regexp {^history} $cur_task_cmd] &&
               ! [regexp {^ta} $cur_task_cmd] } { 
      .t.lb insert end $s
    }
    .t.lb insert end "<"

  } else { 

    # normal colorization...
    if { $debug } { puts "ColorizedInsert: normal insert" }
    .t.lb insert end " "
    set c 1
    set str "NOPREVSTR"
    set ptag ""
    foreach tok [split $line "\x1b"] {
      if { $str == "" } {
        # prev ctrl seq usually belongs to THIS tok...
        if { ! [regexp {^sum} $cur_task_cmd] } { 
          set tok "$ptok$tok"
        }
      }
      set tok_info [ParseString $tok]
      set fg [lindex $tok_info 0]
      set bg [lindex $tok_info 1]
      set ul [lindex $tok_info 2]
      set bold [lindex $tok_info 3]
      set str [lindex $tok_info 4]
      set tag [GetTag $fg $bg $ul $bold]
      .t.lb insert end "$str" $tag
      set c [expr $c + [string length $str]]
      set ptok $tok
      if { $str != "" } {  
        # save color tag for padding...
        set ptag $tag
      }

    }
    if { ! [regexp {^burn} $cur_task_cmd] &&
         ! [regexp {^cal} $cur_task_cmd] && 
         ! [regexp {^col} $cur_task_cmd] && 
         ! [regexp {^history} $cur_task_cmd] && 
         ! [regexp {^ghistory} $cur_task_cmd] &&
         ! [regexp {^sum} $cur_task_cmd] &&
         $display_mode != "undo" } { 
      set width [expr $cols - 2] ;# first & last 
      set pad [expr $cols - $c]
      set s ""
      for { set i 1 } { $i < $pad } {incr i } { set s "$s " } 
      .t.lb insert end $s $ptag
    }
    .t.lb insert end " "
  }
  .t.lb insert end "\n";
}

###############################################################################
# Maintain a hash of color tags that point to their tag names, 
# create the tags on demand and return the correct one...

proc GetTag { fg bg ul bold } {
  global ctag_table debug

  set key "fg $fg bg $bg $ul $bold"
  set val [array names ctag_table $key]
  if { $val == "" } {
    set n [expr [array size ctag_table] + 1]
    set ctag "ctag$n"
    if { $bold } { 
      .t.lb tag configure $ctag -font bold_font -foreground "$fg" -background "$bg" -underline $ul
    } else { 
      .t.lb tag configure $ctag -foreground "$fg" -background "$bg" -underline $ul
    }
    set ctag_table($key) $ctag
    if { $debug } { puts "GetTag: created $ctag -fg $fg -bg $bg -ul $ul" }
  } else {
    set ctag $ctag_table($key)
  }
  return $ctag
}

###############################################################################
# Parse a string into fg/bg/string truple...

proc ParseString { str } {
  global color c82rgb c2562rgb
  global color_fg color_bg debug

  set fg $color_fg
  set bg $color_bg
  set bold 0
  set ul 0

  regsub -all {\[0m} $str "" str
  #puts "ParseString IN \"$str\""

  if { [regexp {\[38;5;([0-9]+)m} $str junk index] } {
    if { $index > -1 && $index < 256 } {
      set fg "\#$c2562rgb($index)"
    } else {
      if { $debug } { puts "256-foreground-color terminal escape sequence index $index out of bounds" }
    }
  }
  regsub -all {\[38;5;[0-9]+m} $str "" str

  if { [regexp {\[48;5;([0-9]+)m} $str junk index] } {
    if { $index > -1 && $index < 256 } {
      set bg "\#$c2562rgb($index)"
    } else {
      if { $debug } { puts "256-foreground-color terminal escape sequence index $index out of bounds" }
    }
  }
  regsub -all {\[48;5;[0-9]+m} $str "" str

  # remove bold...
  if { [regexp {\[1;} $str] } { 
    regsub -all {\[1;} $str "\[" str
    set bold 1
  }

  if { [regexp {\[([0-9]+);([0-9]+)m} $str junk i j] } {
    set found 0
    if { $i > 29 && $i < 38 } { 
      set fg "\#$c82rgb($i)" 
      set found 1
    } 
    if { $j > 39 && $j < 48 } { 
      set bg "\#$c82rgb($j)" 
      set found 1
    } 
    if { $i == 30 } { 
      set bg "\#$c82rgb($j)" 
      set found 1
    }
    if { $i == 4 } { 
      set ul 1 
      set found 1
    }
    if { $debug && ! $found } { 
      if { $debug } { puts "16-color terminal escape sequence for fg/bg indexes $i & $j out of bounds" }
    }
  } elseif { [regexp {\[([0-9]+)m} $str junk index] } {
    if { $index > 29 && $index < 38 } {
      set fg "\#$c82rgb($index)"
    } elseif { $index > 39 && $index < 48 } {
      set bg "\#$c82rgb($index)"
    } elseif { $index == 4 } {
      set ul 1
    } else { 
      if { $debug } { puts "16-color terminal escape sequence for attr index $index out of bounds" }
    }
  }

  regsub -all {^\[.*?m} $str "" str
  #puts "ParseString OUT \"$str\" $fg $bg $ul $bold"
  return [list $fg $bg $ul $bold $str]
}

###############################################################################
# Parse underlining...  parse underining attribute into two lines w/ dashes...

proc ParseUnderlining { in } {
  global debug
  set h1 $in
  regsub -all {\x1b.*?m} $h1 "" h1
  set i 1
  set h2 ""
  foreach tok [split $in "\x1b"] {
    set str $tok
    regsub -all {\[.*?m} $str "" str
    if { [regexp {^\[4m} $tok ] } {
      regsub -all {.} $str "-" str
      set h2 "$h2$str"
    } else {
      regsub -all {.} $str " " str
      set h2 "$h2$str"
    }
    incr i
  }
  if { $debug } { puts "Header1: $h1"; puts "Header2: $h2"; }
  return [list $h1 $h2]
}

###############################################################################
# Display dashes as overstrike tags to header looks really nice (no gaps)...

proc InsertOverstrike { str } {
  .t.lb insert end " " ctag_header
  foreach c [split $str ""] {
    if { $c == " " } { 
      .t.lb insert end " "
    } else { 
      .t.lb insert end " " tag_overstrike
    }
  }
  .t.lb insert end "\n"
}

