#
# Help screen goodness...
#
# $Id: help.tcl,v 1.17 2011/02/17 15:21:39 rader Exp $
#

proc HelpScreen { } {
  global task_id cur_task_cmd win_start win_cur
  global pre_help_task_cmd pre_help_win_cur pre_help_win_start pre_help_display_mode
  global header body color_body display_mode
  global help_view help_filter rc
  global rows cols
  global alt_prefix alt_suffix

  set new_header(1) "Type  Command         Description"
  set new_header(2) "----  --------------  -----------"
  set start [string length $new_header(2)]
  set c [expr $cols - $start - 2]
  for { set i 0 } { $i < $c } {incr i } { set new_header(2) "$new_header(2)-" }

set cmds "cmd   a DESCRIPTION   add task
cmd   A               annotate task
cmd   b ID            dependent (blocked)
rpt   B               display blocked report 
cmd   c DESCRIPTION   change DESCRIPTION 
cmd   C ID            dependent (child)
cmd   d               mark task done
cmd   D DATE          set the due-date to DATE
cmd   f KEYWORDS      filter KEYWORDS (tcl/tk regex, really)
nav   g REGEX         \"grep\" tcl/tk REGEX
nav   G               go to last line
nav   1G              go to line 1
nav   NG              go to line N
cmd   h               set priority H
nav   H               go to window top (high)
info  i               display task info
nav   j               task down
nav   k               task up
cmd   l               set priority L
nav   L               go to window bottom (low)
cmd   m               set priority M
nav   M               go to window middle
cmd   n               set priority none
cmd   N STRING        denotate annotations matching STRING
cmd   o DESCRIPTION   create task with DESCRIPTION and mark done (log)
rpt   O               display overdue report
cmd   p PROJECT       set PROJECT
rpt   P               display projects report
cmd   q               quit current report, return to default report
rpt   R               display recurring report
cmd   s               start/stop task
rpt   S               display summary report
cmd   t TAG           set TAG
rpt   T               display tags report
cmd   u               undo last change
cmd   w               set wait
rpt   W               display waiting report
cmd   x               exit current report, return to default report
cmd   X               delete task
cmd   ZZ              exit vittk
cmd   :s/OLD/NEW/     substitute OLD for NEW in description
cmd   :N COMMAND      run COMMAND on task N
info  :N              info on task N
rpt   :active         display active report
rpt   :burndown       display burndown report
rpt   :calendar       display calendar
rpt   :ghistory       display ghistory
rpt   :history        display history
rpt   :completed      display completed report
help  :help           display help
help  :help fkey      display function key bindings
help  :help help      display help about help
help  :help rpt       display reporting commands
help  :help nav       display screen navigation commands
help  :help KEYWORD   display help filtered KEYWORD 
rpt   :stats          display stastistics
rpt   :summary        display project status
cmd   :quit           exit vittk
info   \\n             display task info
nav   ^b              page up
nav   ^f              page down
cli   ^h              erase character
cli   ^u              erase line
cli   ^w              erase word
nav   ArrowUp         task up
nav   ArrowDown       task down
nav   PgDn            page down
nav   PgUp            page up"

  set i 1
  foreach l [split $cmds "\n"] { 
    if { [regexp -nocase $help_filter $l] } { 
      if { [expr $i % 2] } {
        set new_body($i) $l
      } else {
        set new_body($i) "${alt_prefix}${l}${alt_suffix}"
      }
      incr i
    }
  }
  for { set j 1 } { $j  < 13 } { incr j } {
    if { $rc(bind.f$j) != "" } {
      set k $rc(bind.f$j)
      if { $j < 10 } { 
        set s "fkey  F$j              $rc(bind.f$j)"
      } else {
        set s "fkey  F$j             $rc(bind.f$j)"
      }
      if { [regexp -nocase $help_filter $s] } {
        if { [expr $i % 2] } {
          set new_body($i) $s
        } else {
          set new_body($i) "${alt_prefix}${s}${alt_suffix}"
        }
        incr i
      }
    }
  }
  if { $i < 2 } { 
    Bell
    Feedback "help $help_filter ... no matches"
    return
  }

  if { [array exists header] } { array unset header }
  array set header [array get new_header]
  array unset new_header
  if { [array exists body] } { array unset body }
  array set body [array get new_body]
  array set color_body [array get new_body]
  array unset new_body

  set help_view "help $help_filter"
  set pre_help_display_mode $display_mode
  set pre_help_task_cmd $cur_task_cmd
  set pre_help_win_start $win_start
  set pre_help_win_cur $win_cur
  set win_cur 1
  set win_start 1
  set display_mode "help"
  Refresh "help"
}

