#
# Resize...
#
# $Id: resize.tcl,v 1.6 2011/01/23 15:45:04 rader Exp $
#

###############################################################################
# Set timers for doing throttled resize...

proc Resize { } {
  global height width 
  global last_resize_event resize_thres

  # not a resize...
  set h [winfo height .t.lb]
  set w [winfo width .t.lb]
  if { $h == $height && $w == $width } { return }

  # schedule it for the future...
  set last_resize_event [clock clicks -milliseconds]
  after $resize_thres DoResize
}

###############################################################################
# Actually do resize...

proc DoResize { } {
  global task_args rows cols win_size 
  global last_resize_event resize_thres 
  global task_args first_resize
  global font_width font_height line_padding

  # my window manager sends a resize at startup-time...
  if { $first_resize } { 
    set first_resize 0
    return
  }

  # throttle to once per N ms...
  set now [clock clicks -milliseconds]
  set elapsed [expr $now - $last_resize_event]
  if { $elapsed < $resize_thres } { return }

  # adjust...
  set h [winfo height .t.lb]
  set w [winfo width .t.lb]
  set rows [expr $h / ($font_height + $line_padding + $line_padding)]
  set cols [expr $w / $font_width]
  set win_size [expr $rows - 6]
  set dw [expr $cols - 2]
  regsub { rc.defaultwidth=[0-9]+ } $task_args " rc.defaultwidth=$dw " task_args

  #puts "Size is ${w}x${h} pixels"
  #puts "Geometry is ${cols}x${rows} characters"
  #puts "Font geometry is ${font_width}x${font_height} pixels"

  # refresh...
  Refresh "new-report"
}

