/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.sudo.SudoCommandProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelProcess;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.io.SuperUserStatus;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00112\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010'H\u0007J/\u0010(\u001a\u00020)2\u000b\u0010*\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00182\u000b\u0010+\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00182\u000b\u0010,\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0018H\u0007J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0007J\u0018\u0010-\u001a\u00020\u00112\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u00020\u0011H\u0007J\u0012\u00104\u001a\u0004\u0018\u00010\u00112\u0006\u0010/\u001a\u000200H\u0007J\u001c\u00105\u001a\u0004\u0018\u00010\u00112\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109H\u0007J\u001d\u0010:\u001a\u00020;2\u0006\u0010/\u001a\u0002002\u000b\u0010<\u001a\u00070\u0011\u00a2\u0006\u0002\b=H\u0007J\u001d\u0010>\u001a\u0002002\u0006\u0010/\u001a\u0002002\u000b\u0010<\u001a\u00070\u0011\u00a2\u0006\u0002\b=H\u0007J\u001d\u0010?\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u000b\u0010<\u001a\u00070\u0011\u00a2\u0006\u0002\b=H\u0007J\u001a\u0010@\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00182\u0006\u0010A\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\bBJ\u0010\u0010C\u001a\u00020\u00112\u0006\u0010A\u001a\u00020\u0011H\u0007J\b\u0010D\u001a\u00020\u0006H\u0007J'\u0010E\u001a\r\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u00180F2\n\b\u0001\u0010G\u001a\u0004\u0018\u00010\u00112\u0006\u0010H\u001a\u00020\u0011H\u0007J\u0010\u0010I\u001a\u00020J2\u0006\u0010/\u001a\u000200H\u0007J\b\u0010K\u001a\u00020\u0006H\u0002J\u0010\u0010L\u001a\u00020J2\u0006\u0010/\u001a\u000200H\u0007J\u001e\u0010M\u001a\u00020;*\u00020N2\u0006\u0010O\u001a\u00020P2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0007R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R'\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R!\u0010\r\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0017\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\u001bR\u001f\u0010\u001c\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u0003\u001a\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u00118GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b \u0010\u0003\u001a\u0004\b!\u0010\u001b\u00a8\u0006S"}, d2={"Lcom/intellij/execution/util/ExecUtil;", "", "<init>", "()V", "hasGnomeTerminal", "Ljava/util/function/Supplier;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "hasKdeTerminal", "getHasKdeTerminal$annotations", "hasUrxvt", "getHasUrxvt$annotations", "hasXTerm", "hasSetsid", "getHasSetsid$annotations", "NICE_PATH", "", "hasNice", "getHasNice", "()Z", "hasNice$delegate", "Lkotlin/Lazy;", "osascriptPath", "Lcom/intellij/openapi/util/NlsSafe;", "getOsascriptPath$annotations", "getOsascriptPath", "()Ljava/lang/String;", "openCommandPath", "getOpenCommandPath$annotations", "getOpenCommandPath", "windowsShellName", "getWindowsShellName$annotations", "getWindowsShellName", "loadTemplate", "loader", "Ljava/lang/ClassLoader;", "templateName", "variables", "", "createTempExecutableScript", "Ljava/io/File;", "prefix", "suffix", "content", "execAndGetOutput", "Lcom/intellij/execution/process/ProcessOutput;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "timeoutInMilliseconds", "", "stdin", "execAndReadLine", "readFirstLine", "stream", "Ljava/io/InputStream;", "cs", "Ljava/nio/charset/Charset;", "sudo", "Ljava/lang/Process;", "prompt", "Lorg/jetbrains/annotations/Nls;", "sudoCommand", "sudoAndGetOutput", "escapeAppleScriptArgument", "arg", "escapeAppleScriptArgument$intellij_platform_ide_util_io", "escapeUnixShellArgument", "hasTerminalApp", "getTerminalCommand", "", "title", "command", "setupLowPriorityExecution", "", "canRunLowPriority", "setupNoTtyExecution", "startProcessBlockingUsingEel", "Lcom/intellij/platform/eel/EelExecApi;", "builder", "Ljava/lang/ProcessBuilder;", "pty", "Lcom/intellij/execution/process/LocalPtyOptions;", "intellij.platform.ide.util.io"})
@SourceDebugExtension(value={"SMAP\nExecUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecUtil.kt\ncom/intellij/execution/util/ExecUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1#2:287\n*E\n"})
public final class ExecUtil {
    @NotNull
    public static final ExecUtil INSTANCE = new ExecUtil();
    @NotNull
    private static final Supplier<Boolean> hasGnomeTerminal;
    @NotNull
    private static final Supplier<Boolean> hasKdeTerminal;
    @NotNull
    private static final Supplier<Boolean> hasUrxvt;
    @NotNull
    private static final Supplier<Boolean> hasXTerm;
    @NotNull
    private static final Supplier<Boolean> hasSetsid;
    @NotNull
    private static final String NICE_PATH = "/usr/bin/nice";
    @NotNull
    private static final Lazy hasNice$delegate;

    private ExecUtil() {
    }

    private static /* synthetic */ void getHasKdeTerminal$annotations() {
    }

    private static /* synthetic */ void getHasUrxvt$annotations() {
    }

    private static /* synthetic */ void getHasSetsid$annotations() {
    }

    private final boolean getHasNice() {
        Lazy lazy = hasNice$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public static final String getOsascriptPath() {
        return "/usr/bin/osascript";
    }

    @JvmStatic
    public static /* synthetic */ void getOsascriptPath$annotations() {
    }

    @NotNull
    public static final String getOpenCommandPath() {
        return "/usr/bin/open";
    }

    @JvmStatic
    public static /* synthetic */ void getOpenCommandPath$annotations() {
    }

    @Deprecated(message="Inline this property", level=DeprecationLevel.ERROR)
    @NotNull
    public static final String getWindowsShellName() {
        String string = CommandLineUtil.getWinShellName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWinShellName(...)");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getWindowsShellName$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        String string;
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        InputStream inputStream = loader.getResourceAsStream(templateName);
        if (inputStream == null) {
            throw new IOException("Template '" + templateName + "' not found by " + loader);
        }
        InputStream stream = inputStream;
        Object object2 = stream;
        Object object3 = null;
        try {
            InputStream object4 = (InputStream)object2;
            boolean bl = false;
            byte[] byArray = object4.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            string = StringsKt.decodeToString((byte[])byArray);
        }
        catch (Throwable bl) {
            object3 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        String template = string;
        object2 = variables;
        if (object2 == null || object2.isEmpty()) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template);
        for (Map.Entry entry : variables.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            int pos = buffer.indexOf(name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), value);
        }
        String string2 = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final File createTempExecutableScript(@NotNull String prefix, @NotNull String suffix, @NotNull String content) throws IOException, ExecutionException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File tempDir = new File(PathManager.getTempPath());
        File file = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File tempFile = file;
        byte[] byArray = content.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        FileUtil.writeToFile((File)tempFile, (byte[])byArray);
        if (!tempFile.setExecutable(true, true)) {
            Object[] objectArray = new Object[]{tempFile};
            throw new ExecutionException(IdeUtilIoBundle.message("dialog.message.failed.to.make.temp.file.executable", objectArray));
        }
        return tempFile;
    }

    @JvmStatic
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @JvmStatic
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine, int timeoutInMilliseconds) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess(timeoutInMilliseconds);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @JvmStatic
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static final String execAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String stdin) {
        CapturingProcessHandler capturingProcessHandler;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
        CapturingProcessHandler $this$execAndGetOutput_u24lambda_u242 = capturingProcessHandler = new CapturingProcessHandler(commandLine);
        boolean bl = false;
        $this$execAndGetOutput_u24lambda_u242.addProcessListener((ProcessListener)new ProcessAdapter($this$execAndGetOutput_u24lambda_u242, commandLine, stdin){
            final /* synthetic */ CapturingProcessHandler $this_apply;
            final /* synthetic */ GeneralCommandLine $commandLine;
            final /* synthetic */ String $stdin;
            {
                this.$this_apply = $receiver;
                this.$commandLine = $commandLine;
                this.$stdin = $stdin;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                OutputStream outputStream = this.$this_apply.getProcessInput();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getProcessInput(...)");
                Closeable closeable = outputStream;
                Charset charset = this.$commandLine.getCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
                Object object = charset;
                closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
                object = this.$stdin;
                Throwable throwable = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                    boolean bl = false;
                    it.write((String)object);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
        String string = capturingProcessHandler.runProcess().getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return string;
    }

    @JvmStatic
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static final String execAndReadLine(@NotNull GeneralCommandLine commandLine) {
        String string;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        try {
            InputStream inputStream = commandLine.createProcess().getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            string = ExecUtil.readFirstLine(inputStream, commandLine.getCharset());
        }
        catch (ExecutionException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @ApiStatus.Internal
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static final String readFirstLine(@NotNull InputStream stream, @Nullable Charset cs) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        try {
            String string;
            object = new BufferedReader(cs == null ? new InputStreamReader(stream) : new InputStreamReader(stream, cs));
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                string = it.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string;
        }
        catch (IOException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            object = null;
        }
        return object;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Process sudo(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Process process = ExecUtil.sudoCommand(commandLine, prompt).createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
        return process;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        if (SuperUserStatus.isSuperUser()) {
            return commandLine;
        }
        GeneralCommandLine generalCommandLine = SudoCommandProvider.Companion.getInstance().sudoCommand(commandLine, prompt);
        if (generalCommandLine == null) {
            throw new UnsupportedOperationException("Cannot `sudo` on this system - no suitable utils found");
        }
        GeneralCommandLine sudoCommandLine = generalCommandLine;
        GeneralCommandLine generalCommandLine2 = sudoCommandLine.withWorkingDirectory(commandLine.getWorkingDirectory()).withEnvironment(commandLine.getEnvironment()).withParentEnvironmentType(commandLine.getParentEnvironmentType()).withRedirectErrorStream(commandLine.isRedirectErrorStream());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withRedirectErrorStream(...)");
        return generalCommandLine2;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final ProcessOutput sudoAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws IOException, ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return ExecUtil.execAndGetOutput(ExecUtil.sudoCommand(commandLine, prompt));
    }

    @NotNull
    public final String escapeAppleScriptArgument$intellij_platform_ide_util_io(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return Intrinsics.areEqual((Object)arg, (Object)"&&") ? "\"" + arg + "\"" : "quoted form of \"" + StringsKt.replace$default((String)StringsKt.replace$default((String)arg, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null) + "\"";
    }

    @Deprecated(message="It is an oversimplified quoting. Prefer CommandLineUtil.posixQuote instead.", replaceWith=@ReplaceWith(expression="CommandLineUtil.posixQuote(arg)", imports={"com.intellij.execution.CommandLineUtil.posixQuote"}), level=DeprecationLevel.ERROR)
    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final String escapeUnixShellArgument(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return "'" + StringsKt.replace$default((String)arg, (String)"'", (String)"'\"'\"'", (boolean)false, (int)4, null) + "'";
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final boolean hasTerminalApp() {
        return SystemInfoRt.isWindows || SystemInfoRt.isMac || hasKdeTerminal.get() != false || hasGnomeTerminal.get() != false || hasUrxvt.get() != false || hasXTerm.get() != false;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final List<String> getTerminalCommand(@Nls(capitalization=Nls.Capitalization.Title) @Nullable String title, @NotNull String command) {
        List list;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (SystemInfoRt.isWindows) {
            Object[] objectArray = new String[5];
            objectArray[0] = CommandLineUtil.getWinShellName();
            objectArray[1] = "/c";
            objectArray[2] = "start";
            String string = title;
            if (string == null || (string = StringsKt.replace$default((String)string, (char)'\"', (char)'\'', (boolean)false, (int)4, null)) == null) {
                string = "";
            }
            objectArray[3] = GeneralCommandLine.inescapableQuote(string);
            objectArray[4] = command;
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (SystemInfoRt.isMac) {
            String string = title;
            String prefix = string != null ? "\"echo -n \" & " + INSTANCE.escapeAppleScriptArgument$intellij_platform_ide_util_io("\\0033]0;" + string + "\\007") + " & \" ; \" & " : "";
            String script = prefix + "\"clear ; exec \" & " + INSTANCE.escapeAppleScriptArgument$intellij_platform_ide_util_io(command);
            Object[] objectArray = new String[3];
            objectArray[0] = INSTANCE.getOsascriptPath();
            objectArray[1] = "-e";
            objectArray[2] = StringsKt.trimMargin$default((String)("\n          |tell application \"Terminal\"\n          |  activate\n          |  do script " + script + "\n          |end tell\n          "), null, (int)1, null);
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (hasKdeTerminal.get().booleanValue()) {
            if (title != null) {
                Object[] objectArray = new String[]{"konsole", "-p", "tabtitle=\"" + StringsKt.replace$default((String)title, (char)'\"', (char)'\'', (boolean)false, (int)4, null) + "\"", "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                Object[] objectArray = new String[]{"konsole", "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        } else if (hasGnomeTerminal.get().booleanValue()) {
            if (title != null) {
                Object[] objectArray = new String[]{"gnome-terminal", "-t", title, "-x", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                Object[] objectArray = new String[]{"gnome-terminal", "-x", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        } else if (hasUrxvt.get().booleanValue()) {
            if (title != null) {
                Object[] objectArray = new String[]{"urxvt", "-title", title, "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                Object[] objectArray = new String[]{"urxvt", "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        } else if (hasXTerm.get().booleanValue()) {
            if (title != null) {
                Object[] objectArray = new String[]{"xterm", "-T", title, "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                Object[] objectArray = new String[]{"xterm", "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfoRt.OS_NAME + "/" + System.getenv("XDG_CURRENT_DESKTOP"));
        }
        return list;
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void setupLowPriorityExecution(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        if (INSTANCE.canRunLowPriority()) {
            String string = commandLine.getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
            String executablePath = string;
            if (SystemInfoRt.isWindows) {
                commandLine.withExePath(CommandLineUtil.getWinShellName());
                String[] stringArray = new String[]{"/c", "start", "/b", "/low", "/wait", GeneralCommandLine.inescapableQuote(""), executablePath};
                commandLine.getParametersList().prependAll(stringArray);
            } else {
                commandLine.withExePath(NICE_PATH);
                String[] stringArray = new String[]{"-n", "10", executablePath};
                commandLine.getParametersList().prependAll(stringArray);
            }
        }
    }

    private final boolean canRunLowPriority() {
        return Registry.Companion.is("ide.allow.low.priority.process") && (SystemInfoRt.isWindows || this.getHasNice());
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void setupNoTtyExecution(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        if (SystemInfoRt.isLinux && hasSetsid.get().booleanValue()) {
            String string = commandLine.getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
            String executablePath = string;
            commandLine.withExePath("setsid");
            String[] stringArray = new String[]{executablePath};
            commandLine.getParametersList().prependAll(stringArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Process startProcessBlockingUsingEel(@NotNull EelExecApi $this$startProcessBlockingUsingEel, @NotNull ProcessBuilder builder, @Nullable LocalPtyOptions pty) {
        EelExecApi.Pty pty2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$startProcessBlockingUsingEel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        List<String> args = builder.command();
        Intrinsics.checkNotNull(args);
        String exe = (String)CollectionsKt.first(args);
        boolean bl = false;
        Object object2 = $this$startProcessBlockingUsingEel;
        try {
            EelExecApi $this$startProcessBlockingUsingEel_u24lambda_u245_u24lambda_u244 = object2;
            boolean bl2 = false;
            Path path = Path.of(exe, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            object = Result.constructor-impl((Object)EelNioBridgeServiceKt.asEelPath((Path)path).toString());
        }
        catch (Throwable bl2) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object2 = object;
        String string = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (string == null) {
            string = exe;
        }
        String exe2 = string;
        List<String> rest = args.subList(1, args.size());
        Map<String, String> env = builder.environment();
        Comparable<File> comparable = builder.directory();
        EelPath workingDir = comparable != null && (comparable = comparable.toPath()) != null ? EelNioBridgeServiceKt.asEelPath((Path)comparable) : null;
        Intrinsics.checkNotNull((Object)exe2);
        EelExecApi.ExecuteProcessOptions.Builder builder2 = EelExecApi.ExecuteProcessOptions.Companion.Builder(exe2).args(rest).workingDirectory(workingDir);
        Intrinsics.checkNotNull(env);
        EelExecApi.ExecuteProcessOptions.Builder builder3 = builder2.env(env);
        LocalPtyOptions localPtyOptions = pty;
        if (localPtyOptions != null) {
            void $this$startProcessBlockingUsingEel_u24lambda_u246;
            LocalPtyOptions bl2 = localPtyOptions;
            EelExecApi.ExecuteProcessOptions.Builder builder4 = builder3;
            boolean bl3 = false;
            pty2 = new EelExecApi.Pty($this$startProcessBlockingUsingEel_u24lambda_u246.getInitialColumns(), $this$startProcessBlockingUsingEel_u24lambda_u246.getInitialRows(), !$this$startProcessBlockingUsingEel_u24lambda_u246.getConsoleMode());
            builder3 = builder4;
        } else {
            pty2 = null;
        }
        EelExecApi.ExecuteProcessOptions.Builder options = builder3.ptyOrStdErrSettings((EelExecApi.PtyOrStdErrSettings)pty2);
        return (Process)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Process>, Object>($this$startProcessBlockingUsingEel, options, null){
            int label;
            final /* synthetic */ EelExecApi $this_startProcessBlockingUsingEel;
            final /* synthetic */ EelExecApi.ExecuteProcessOptions.Builder $options;
            {
                this.$this_startProcessBlockingUsingEel = $receiver;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$this_startProcessBlockingUsingEel.execute(this.$options.build(), (Continuation)this);
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        $this$getOrThrow_u24default$iv = (EelResult)v0;
                        $i$f$getOrThrow = false;
                        $this$getOr$iv$iv = $this$getOrThrow_u24default$iv;
                        $i$f$getOr = false;
                        var6_7 = $this$getOr$iv$iv;
                        if (!(var6_7 instanceof EelResult.Ok)) {
                            if (var6_7 instanceof EelResult.Error) {
                                it$iv = (EelResult.Error)$this$getOr$iv$iv;
                                $i$a$-getOr-EelResultKt$getOrThrow$2$iv = false;
                                var9_10 = it$iv.getError();
                                $i$a$-getOrThrow-EelResultKt$getOrThrow$1 = false;
                                it = var9_10;
                                throw it instanceof Throwable != false ? (Throwable)it : (Throwable)new RuntimeException(String.valueOf(it));
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        return ((EelProcess)((EelResult.Ok)$this$getOr$iv$iv).getValue()).convertToJavaProcess();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Process> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final boolean hasNice_delegate$lambda$0() {
        return Files.exists(Path.of(NICE_PATH, new String[0]), new LinkOption[0]);
    }

    static {
        Supplier supplier = PathExecLazyValue.create((String)"gnome-terminal");
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"create(...)");
        hasGnomeTerminal = supplier;
        Supplier supplier2 = PathExecLazyValue.create((String)"konsole");
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"create(...)");
        hasKdeTerminal = supplier2;
        Supplier supplier3 = PathExecLazyValue.create((String)"urxvt");
        Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"create(...)");
        hasUrxvt = supplier3;
        Supplier supplier4 = PathExecLazyValue.create((String)"xterm");
        Intrinsics.checkNotNullExpressionValue((Object)supplier4, (String)"create(...)");
        hasXTerm = supplier4;
        Supplier supplier5 = PathExecLazyValue.create((String)"setsid");
        Intrinsics.checkNotNullExpressionValue((Object)supplier5, (String)"create(...)");
        hasSetsid = supplier5;
        hasNice$delegate = LazyKt.lazy(ExecUtil::hasNice_delegate$lambda$0);
    }
}

