/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.vcs.commit.CommitChangeListDialogWorkflow;
import com.intellij.vcs.commit.CommitSessionInfo;
import com.intellij.vcs.commit.Committer;
import com.intellij.vcs.commit.CommitterResultHandler;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandler;
import com.intellij.vcs.commit.VcsCommitter;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.integrate.AlienCommitter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/svn/integrate/AlienCommitWorkflow;", "Lcom/intellij/vcs/commit/CommitChangeListDialogWorkflow;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "<init>", "(Lcom/intellij/openapi/vcs/AbstractVcs;)V", "getVcs", "()Lcom/intellij/openapi/vcs/AbstractVcs;", "isDefaultCommitEnabled", "", "()Z", "isPartialCommitEnabled", "canExecute", "sessionInfo", "Lcom/intellij/vcs/commit/CommitSessionInfo;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "performCommit", "", "intellij.vcs.svn"})
public final class AlienCommitWorkflow
extends CommitChangeListDialogWorkflow {
    @NotNull
    private final AbstractVcs vcs;
    private final boolean isDefaultCommitEnabled;
    private final boolean isPartialCommitEnabled;

    public AlienCommitWorkflow(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Project project = vcs.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project);
        this.vcs = vcs;
        this.updateVcses(SetsKt.setOf((Object)this.vcs));
        this.isDefaultCommitEnabled = true;
    }

    @NotNull
    public final AbstractVcs getVcs() {
        return this.vcs;
    }

    public boolean isDefaultCommitEnabled() {
        return this.isDefaultCommitEnabled;
    }

    public boolean isPartialCommitEnabled() {
        return this.isPartialCommitEnabled;
    }

    public boolean canExecute(@NotNull CommitSessionInfo sessionInfo, @NotNull Collection<? extends Change> changes) {
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        return sessionInfo.isVcsCommit();
    }

    protected void performCommit(@NotNull CommitSessionInfo sessionInfo) {
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        AlienCommitter committer = new AlienCommitter(this.vcs, this.getCommitState().getChanges(), this.getCommitState().getCommitMessage(), this.getCommitContext());
        this.addCommonResultHandlers(sessionInfo, (Committer)committer);
        committer.addResultHandler((CommitterResultHandler)new ShowNotificationCommitResultHandler((VcsCommitter)committer));
        String string = CommitChangeListDialog.DIALOG_TITLE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DIALOG_TITLE");
        committer.runCommit(string, false);
    }
}

