/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.AlreadyClosedException;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SafeStatementPointer;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqliteDb;
import org.jetbrains.sqlite.SqlitePreparedStatement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\t\u0010\u001a\u001a\u00020\u0007H\u0086\u0002J\u0006\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\fJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\fJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\fJ\u000e\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020\fJ\u000e\u0010%\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\fJ\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001d\u001a\u00020\fJ\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010+\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010\u001d\u001a\u00020\fH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\t\u00a8\u0006-"}, d2={"Lorg/jetbrains/sqlite/SqliteResultSet;", "", "statement", "Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "<init>", "(Lorg/jetbrains/sqlite/SqlitePreparedStatement;)V", "value", "", "isOpen", "()Z", "setOpen$intellij_platform_sqlite", "(Z)V", "", "row", "getRow", "()I", "pastLastRow", "lastColumn", "close", "", "db", "Lorg/jetbrains/sqlite/NativeDB;", "close$intellij_platform_sqlite", "isClosed", "markColumn", "column", "next", "wasNull", "getBoolean", "zeroBasedColumnIndex", "getBytes", "", "col", "getDouble", "", "getFloat", "", "getInt", "getLong", "", "getString", "", "safeGetColumnType", "safeGetDoubleCol", "safeGetColumnText", "intellij.platform.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqliteResultSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteResultSet.kt\norg/jetbrains/sqlite/SqliteResultSet\n+ 2 SafeStatementPointer.kt\norg/jetbrains/sqlite/SafeStatementPointer\n+ 3 SqliteConnection.kt\norg/jetbrains/sqlite/SqliteConnection\n*L\n1#1,162:1\n39#2:163\n40#2,2:170\n52#2:178\n53#2,2:185\n39#2:187\n40#2,2:194\n39#2:202\n40#2,2:209\n52#2:217\n53#2,2:224\n67#3,6:164\n67#3,6:172\n67#3,6:179\n67#3,6:188\n67#3,6:196\n67#3,6:203\n67#3,6:211\n67#3,6:218\n*S KotlinDebug\n*F\n+ 1 SqliteResultSet.kt\norg/jetbrains/sqlite/SqliteResultSet\n*L\n60#1:163\n60#1:170,2\n120#1:178\n120#1:185,2\n132#1:187\n132#1:194,2\n148#1:202\n148#1:209,2\n160#1:217\n160#1:224,2\n60#1:164,6\n69#1:172,6\n120#1:179,6\n132#1:188,6\n138#1:196,6\n148#1:203,6\n152#1:211,6\n160#1:218,6\n*E\n"})
public final class SqliteResultSet {
    @NotNull
    private final SqlitePreparedStatement<?> statement;
    private boolean isOpen;
    private int row;
    private boolean pastLastRow;
    private int lastColumn;

    public SqliteResultSet(@NotNull SqlitePreparedStatement<?> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        this.statement = statement;
    }

    public final boolean isOpen() {
        return this.isOpen;
    }

    public final void setOpen$intellij_platform_sqlite(boolean bl) {
        this.isOpen = bl;
    }

    public final int getRow() {
        return this.row;
    }

    public final void close$intellij_platform_sqlite(@NotNull NativeDB db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.row = 0;
        this.pastLastRow = false;
        this.lastColumn = -1;
        if (this.isOpen && !this.statement.pointer.isClosed()) {
            SafeStatementPointer pointer = this.statement.pointer;
            if (!pointer.isClosed()) {
                db.reset(pointer.pointer);
            }
            this.isOpen = false;
        }
    }

    public final boolean isClosed() {
        return !this.isOpen;
    }

    private final int markColumn(int column) {
        this.lastColumn = column;
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean next() {
        int n;
        if (!this.isOpen || this.pastLastRow) {
            return false;
        }
        this.lastColumn = -1;
        if (this.row == 0) {
            int n2 = this.row;
            this.row = n2 + 1;
            return true;
        }
        Object this_$iv = this.statement.pointer;
        boolean $i$f$safeRunInt = false;
        SqliteConnection this_$iv$iv = SafeStatementPointer.access$getConnection$p((SafeStatementPointer)this_$iv);
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Object object = SqliteConnection.access$getLock$p(this_$iv$iv);
        object.lock();
        try {
            void p1;
            boolean bl = false;
            NativeDB db$iv = SqliteConnection.access$getDb(this_$iv$iv);
            boolean bl2 = false;
            ((SafeStatementPointer)this_$iv).ensureOpen();
            long l = ((SafeStatementPointer)this_$iv).pointer;
            NativeDB p0 = db$iv;
            boolean bl3 = false;
            n = p0.step((long)p1);
        }
        finally {
            object.unlock();
        }
        int statusCode = n;
        return switch (statusCode) {
            case 101 -> {
                this.pastLastRow = true;
                yield false;
            }
            case 100 -> {
                int this_$iv = this.row;
                this.row = this_$iv + 1;
                yield true;
            }
            default -> {
                this_$iv = this.statement.connection;
                boolean $i$f$useDb$intellij_platform_sqlite = false;
                if (SqliteConnection.access$getDbRef$p((SqliteConnection)this_$iv).get() == null) {
                    throw new AlreadyClosedException();
                }
                Lock var4_6 = SqliteConnection.access$getLock$p((SqliteConnection)this_$iv);
                var4_6.lock();
                try {
                    boolean $i$a$-withLock-SqliteConnection$useDb$1$iv = false;
                    NativeDB db = SqliteConnection.access$getDb((SqliteConnection)this_$iv);
                    boolean $i$a$-useDb$intellij_platform_sqlite-SqliteResultSet$next$1 = false;
                    object = SqliteDb.newException$default(db, statusCode, null, 2, null);
                }
                finally {
                    var4_6.unlock();
                }
                throw (Throwable)object;
            }
        };
    }

    public final boolean wasNull() {
        return this.safeGetColumnType(this.lastColumn) == 5;
    }

    public final boolean getBoolean(int zeroBasedColumnIndex) {
        return this.getInt(zeroBasedColumnIndex) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final byte[] getBytes(int col) {
        byte[] byArray;
        SafeStatementPointer this_$iv = this.statement.pointer;
        boolean $i$f$safeRun = false;
        SqliteConnection this_$iv$iv = SafeStatementPointer.access$getConnection$p(this_$iv);
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv$iv);
        lock.lock();
        try {
            void pointer;
            boolean bl = false;
            NativeDB db$iv = SqliteConnection.access$getDb(this_$iv$iv);
            boolean bl2 = false;
            this_$iv.ensureOpen();
            long l = this_$iv.pointer;
            SqliteDb db = db$iv;
            boolean bl3 = false;
            byArray = db.column_blob((long)pointer, this.markColumn(col));
        }
        finally {
            lock.unlock();
        }
        return byArray;
    }

    public final double getDouble(int col) {
        return this.safeGetColumnType(this.markColumn(col)) == 5 ? 0.0 : this.safeGetDoubleCol(col);
    }

    public final float getFloat(int col) {
        return this.safeGetColumnType(this.markColumn(col)) == 5 ? 0.0f : (float)this.safeGetDoubleCol(col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int getInt(int zeroBasedColumnIndex) {
        int n;
        SafeStatementPointer this_$iv = this.statement.pointer;
        boolean $i$f$safeRunInt = false;
        SqliteConnection this_$iv$iv = SafeStatementPointer.access$getConnection$p(this_$iv);
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv$iv);
        lock.lock();
        try {
            void pointer;
            boolean bl = false;
            NativeDB db$iv = SqliteConnection.access$getDb(this_$iv$iv);
            boolean bl2 = false;
            this_$iv.ensureOpen();
            long l = this_$iv.pointer;
            NativeDB db = db$iv;
            boolean bl3 = false;
            n = db.column_int((long)pointer, this.markColumn(zeroBasedColumnIndex));
        }
        finally {
            lock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLong(int zeroBasedColumnIndex) {
        SqliteConnection this_$iv = this.statement.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            NativeDB db = SqliteConnection.access$getDb(this_$iv);
            boolean bl2 = false;
            SafeStatementPointer pointer = this.statement.pointer;
            pointer.ensureOpen();
            long l = db.column_long(pointer.pointer, this.markColumn(zeroBasedColumnIndex));
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    public final String getString(int zeroBasedColumnIndex) {
        return this.safeGetColumnText(zeroBasedColumnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int safeGetColumnType(int zeroBasedColumnIndex) {
        int n;
        SafeStatementPointer this_$iv = this.statement.pointer;
        boolean $i$f$safeRunInt = false;
        SqliteConnection this_$iv$iv = SafeStatementPointer.access$getConnection$p(this_$iv);
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv$iv);
        lock.lock();
        try {
            void ptr;
            boolean bl = false;
            NativeDB db$iv = SqliteConnection.access$getDb(this_$iv$iv);
            boolean bl2 = false;
            this_$iv.ensureOpen();
            long l = this_$iv.pointer;
            NativeDB db = db$iv;
            boolean bl3 = false;
            n = db.column_type((long)ptr, zeroBasedColumnIndex);
        }
        finally {
            lock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final double safeGetDoubleCol(int zeroBasedColumnIndex) {
        SqliteConnection this_$iv = this.statement.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            NativeDB db = SqliteConnection.access$getDb(this_$iv);
            boolean bl2 = false;
            SafeStatementPointer pointer = this.statement.pointer;
            pointer.ensureOpen();
            double d = db.column_double(pointer.pointer, this.markColumn(zeroBasedColumnIndex));
            return d;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String safeGetColumnText(int zeroBasedColumnIndex) {
        String string;
        SafeStatementPointer this_$iv = this.statement.pointer;
        boolean $i$f$safeRun = false;
        SqliteConnection this_$iv$iv = SafeStatementPointer.access$getConnection$p(this_$iv);
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv$iv);
        lock.lock();
        try {
            void pointer;
            boolean bl = false;
            NativeDB db$iv = SqliteConnection.access$getDb(this_$iv$iv);
            boolean bl2 = false;
            this_$iv.ensureOpen();
            long l = this_$iv.pointer;
            SqliteDb db = db$iv;
            boolean bl3 = false;
            string = db.column_text((long)pointer, this.markColumn(zeroBasedColumnIndex));
        }
        finally {
            lock.unlock();
        }
        return string;
    }
}

