/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.CreateResolvingFunctionNode;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JobCallback;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.AsyncContext;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;

public class PromiseResolveThenableNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private CreateResolvingFunctionNode createResolvingFunctions;
    @Node.Child
    private JSFunctionCallNode callResolveNode;
    @Node.Child
    private JSFunctionCallNode callRejectNode;
    @Node.Child
    private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

    protected PromiseResolveThenableNode(JSContext context2) {
        this.context = context2;
        this.createResolvingFunctions = CreateResolvingFunctionNode.create(context2);
        this.callResolveNode = JSFunctionCallNode.createCall();
    }

    public static PromiseResolveThenableNode create(JSContext context2) {
        return new PromiseResolveThenableNode(context2);
    }

    public Object executePromiseConstructor(JSPromiseObject promise, Object executor) {
        Pair<JSDynamicObject, JSDynamicObject> resolvingFunctions = this.createResolvingFunctions.execute(promise);
        JSDynamicObject resolve = resolvingFunctions.getFirst();
        JSDynamicObject reject2 = resolvingFunctions.getSecond();
        try {
            return this.callResolveNode.executeCall(JSArguments.create(Undefined.instance, executor, resolve, reject2));
        }
        catch (AbstractTruffleException ex) {
            return this.callReject(reject2, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JSPromiseObject promiseToResolve, Object thenable, JobCallback then) {
        Object object;
        Pair<JSDynamicObject, JSDynamicObject> resolvingFunctions = this.createResolvingFunctions.execute(promiseToResolve);
        JSDynamicObject resolve = resolvingFunctions.getFirst();
        JSDynamicObject reject2 = resolvingFunctions.getSecond();
        JSAgent agent = this.getRealm().getAgent();
        AsyncContext previousContextMapping = agent.asyncContextSwap(then.asyncContextSnapshot());
        this.context.notifyPromiseHook(2, promiseToResolve);
        try {
            object = this.callResolveNode.executeCall(JSArguments.create(thenable, then.callback(), resolve, reject2));
            this.context.notifyPromiseHook(3, promiseToResolve);
            agent.asyncContextSwap(previousContextMapping);
        }
        catch (Throwable throwable) {
            try {
                this.context.notifyPromiseHook(3, promiseToResolve);
                agent.asyncContextSwap(previousContextMapping);
                throw throwable;
            }
            catch (AbstractTruffleException ex) {
                return this.callReject(reject2, ex);
            }
        }
        return object;
    }

    private Object callReject(JSDynamicObject reject2, AbstractTruffleException exception) {
        if (this.getErrorObjectNode == null || this.callRejectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
            this.callRejectNode = this.insert(JSFunctionCallNode.createCall());
        }
        Object error = this.getErrorObjectNode.execute(exception);
        return this.callRejectNode.executeCall(JSArguments.create(Undefined.instance, reject2, error));
    }
}

