/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.dump.mysql;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.MysqlConfigurationBase;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.dump.mysql.MysqldumpArguments;
import com.intellij.database.cli.dump.mysql.MysqldumpArgumentsGroup;
import com.intellij.database.cli.dump.mysql.MysqldumpCliArguments;
import com.intellij.database.cli.dump.mysql.MysqldumpDialogValidator;
import com.intellij.database.cli.restore.mysql.MysqlCliArguments;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqldumpConfiguration
extends MysqlConfigurationBase {
    public static final MysqldumpConfiguration INSTANCE = new MysqldumpConfiguration();

    private MysqldumpConfiguration() {
        super(MysqldumpArgumentsGroup.values(), MysqldumpArguments.RESULT_FILE, "MYSQL_PROPERTIES", "mysqldump");
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        String path = super.getDefaultSearchPath();
        return path == null ? null : path + File.separator + "mysqldump";
    }

    @Override
    @NotNull
    public CliConfiguration.CliSubstitutor getSubstitutor() {
        return new CliConfigurationBase.CliSubstitutorBase(this, List.of(TIMESTAMP_PLACEHOLDER, DATA_SOURCE_PLACEHOLDER, new CliConfigurationBase.DatabasePlaceholder(MysqlCliArguments.DATABASE)));
    }

    @Override
    @NotNull
    protected StringCliArgument getPathArgument() {
        StringCliArgument stringCliArgument = MysqldumpCliArguments.PATH;
        if (stringCliArgument == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(0);
        }
        return stringCliArgument;
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(1);
        }
        List<String> result2 = super.tweakAutocompletion(variants);
        ContainerUtil.removeAll(result2, (Object[])new String[]{"--databases="});
        result2.addAll(ContainerUtil.filter((Object[])MysqldumpArguments.DATABASES, s -> !s.endsWith("=")));
        List<String> list = result2;
        if (list == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public String sanitizeArguments(@NotNull Collection<DbElement> elements, @NotNull String text2) {
        List tables;
        if (elements == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(4);
        }
        List databases = ContainerUtil.filter(elements, DasUtil.byClass(DbNamespaceImpl.class));
        String sanitized = super.sanitizeArguments(elements, text2);
        List<CliLexeme> lexemes = MysqldumpConfiguration.removeAll(DbCliUtil.rawLexemes(sanitized), MysqldumpArguments.ALL_DATABASES);
        if (ContainerUtil.getFirstItem(elements) instanceof DbDataSource) {
            lexemes = MysqldumpConfiguration.removeAll(lexemes, "--tables");
            lexemes = MysqldumpConfiguration.removeAll(lexemes, MysqldumpArguments.DATABASES);
            lexemes = MysqldumpConfiguration.addAll(lexemes, sanitized, DbCliUtil.extractNonParameterizable(MysqldumpArguments.ALL_DATABASES));
            return MysqldumpConfiguration.getCommand(lexemes);
        }
        if (databases.size() > 1) {
            lexemes = MysqldumpConfiguration.removeAll(lexemes, "--tables");
            lexemes = MysqldumpConfiguration.removeAll(lexemes, MysqldumpArguments.DATABASES);
            lexemes = MysqldumpConfiguration.addAll(lexemes, sanitized, DbCliUtil.extractNonParameterizable(MysqldumpArguments.DATABASES));
        }
        if (!(tables = ContainerUtil.filter(elements, DasUtil.byClass(DbTable.class))).isEmpty() && ContainerUtil.find(lexemes, DbCliUtil.lexemeFinder(MysqldumpArguments.DATABASES)) != null) {
            lexemes = MysqldumpConfiguration.removeAll(lexemes, "--tables");
            lexemes = MysqldumpConfiguration.addAll(lexemes, sanitized, "--tables");
        }
        return MysqldumpConfiguration.getCommand(lexemes);
    }

    @NotNull
    private static String getCommand(List<CliLexeme> lexemes) {
        String string = StringUtil.join(lexemes, CliLexeme::getText, (String)"");
        if (string == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = super.getObjectsPreparer().mapAppend((Function<DbElement, DbElement>)((Function)e -> (DbElement)DasUtil.getParentOfKind(e, ObjectKind.SCHEMA, false))).mapAppend((Function<DbElement, DbElement>)((Function)e -> (DbElement)DasUtil.getParentOfKind(e, ObjectKind.DATABASE, false))).onlyIfMoreThanOnce(DasUtil.byKind(ObjectKind.DATABASE)).filter(ObjectKind.DATABASE).finish().endIf().onlyIfMoreThanOnce(DasUtil.byKind(ObjectKind.SCHEMA)).filter(ObjectKind.SCHEMA).finish().endIf().finish();
        if (databaseObjectsPreparer == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(6);
        }
        return databaseObjectsPreparer;
    }

    @Override
    @NotNull
    public CliConfiguration.Operation getOperation() {
        CliConfiguration.Operation operation = CliConfiguration.Operation.DUMP;
        if (operation == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(7);
        }
        return operation;
    }

    @Override
    @NotNull
    public CliDialogValidator getValidator() {
        return new MysqldumpDialogValidator();
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List list = ContainerUtil.concat(Arrays.asList("-T", "w", "-r", "-S"), super.getParameterizableArguments());
        if (list == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public String getPartOfValidationOut() {
        return "mysqldump";
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        Map<String, String> map2 = super.getInfoMap();
        MysqldumpConfiguration.put(map2, "Add DROP DATABASE statements", "--add-drop-database");
        MysqldumpConfiguration.put(map2, "Add DROP TABLE statements", "--add-drop-table");
        MysqldumpConfiguration.put(map2, "Add DROP TRIGGER statements", "--add-drop-trigger");
        MysqldumpConfiguration.put(map2, "Add LOCK/UNLOCK TABLES statements", "--add-locks");
        MysqldumpConfiguration.put(map2, "Dump all databases", MysqldumpArguments.ALL_DATABASES);
        MysqldumpConfiguration.put(map2, "Add statements for NDBCLUSTER table", MysqldumpArguments.ALL_TABLESPACES);
        MysqldumpConfiguration.put(map2, "Permit keywords column names", "--allow-keywords");
        MysqldumpConfiguration.put(map2, "For dump produced with --dump-slave", "--apply-slave-statements");
        MysqldumpConfiguration.put(map2, "Directory with character sets", MysqldumpArguments.CHAR_SETS_DIR);
        MysqldumpConfiguration.put(map2, "Produce more compact output", "--compact");
        MysqldumpConfiguration.put(map2, "Produce more other databases compatible output", MysqldumpArguments.COMPATIBLE);
        MysqldumpConfiguration.put(map2, "Inserts with column names", MysqldumpArguments.INSERTS_WITH_COLUMNS);
        MysqldumpConfiguration.put(map2, "The shared-memory name to use", MysqldumpArguments.SHARED_MEMORY_NAME);
        MysqldumpConfiguration.put(map2, "Sets default_character_set", "--set-charset");
        MysqldumpConfiguration.put(map2, "CREATE TABLE statements with options", MysqldumpArguments.CREATE_OPTIONS);
        MysqldumpConfiguration.put(map2, "Dump several databases", MysqldumpArguments.DATABASES);
        MysqldumpConfiguration.put(map2, "Use charset_name as the default character set", MysqldumpArguments.DEFAULT_CHAR_SET);
        MysqldumpConfiguration.put(map2, "Second options file", MysqldumpArguments.DEFAULT_EXTRA_FILE);
        MysqldumpConfiguration.put(map2, "INSERT DELAYED statements", "--delayed-insert");
        MysqldumpConfiguration.put(map2, "PURGE BINARY LOGS statement after dump", "--delete-master-logs");
        MysqldumpConfiguration.put(map2, "Disable keys before insert", MysqldumpArguments.DISABLE_KEYS);
        MysqldumpConfiguration.put(map2, "Comment with date at the end of the dump", "--dump-date");
        MysqldumpConfiguration.put(map2, "Uses a replication slave server", MysqldumpArguments.DUMP_SLAVE);
        MysqldumpConfiguration.put(map2, "Include Event Scheduler events", MysqldumpArguments.EVENTS);
        MysqldumpConfiguration.put(map2, "Multiple-row inserts", MysqldumpArguments.EXTENDED_INSERTS);
        MysqldumpConfiguration.put(map2, "Fields enclose string", MysqldumpArguments.FIELDS_ENCLOSED_BY);
        MysqldumpConfiguration.put(map2, "Fields escape string", MysqldumpArguments.FIELDS_ESCAPED_BY);
        MysqldumpConfiguration.put(map2, "Optionally fields enclose string", MysqldumpArguments.FIELDS_OPT_ENCLOSED_BY);
        MysqldumpConfiguration.put(map2, "Fields separator", MysqldumpArguments.FIELDS_TERMINATED_BY);
        MysqldumpConfiguration.put(map2, "Lock all tables (Deprecated)", "--first-slave");
        MysqldumpConfiguration.put(map2, "Flush server log files before dump", MysqldumpArguments.FLUSH_LOGS);
        MysqldumpConfiguration.put(map2, "Add a FLUSH PRIVILEGES statement", "--flush-privileges");
        MysqldumpConfiguration.put(map2, "Hexadecimal notation for blobs", "--hex-blob");
        MysqldumpConfiguration.put(map2, "For the CHANGE MASTER TO statement in a slave dump", "--include-master-host-port");
        MysqldumpConfiguration.put(map2, "Do not dump the given table", MysqldumpArguments.IGNORE_TABLE);
        MysqldumpConfiguration.put(map2, "INSERT IGNORE statements", MysqldumpArguments.INSERT_IGNORE);
        MysqldumpConfiguration.put(map2, "Line separator", MysqldumpArguments.LINES_TERMINATED_BY);
        MysqldumpConfiguration.put(map2, "Lock all tables", MysqldumpArguments.LOCK_ALL_TABLES);
        MysqldumpConfiguration.put(map2, "Lock all tables to be dumped", MysqldumpArguments.LOCK_TABLES);
        MysqldumpConfiguration.put(map2, "Log warnings and errors", MysqldumpArguments.LOG_ERROR);
        MysqldumpConfiguration.put(map2, "Dump a master replication server", MysqldumpArguments.MASTER_DATA);
        MysqldumpConfiguration.put(map2, "Turn off autocommit and add COMMIT statements", "--no-autocommit");
        MysqldumpConfiguration.put(map2, "Suppress the CREATE DATABASE statements", MysqldumpArguments.NO_CREATE_DB);
        MysqldumpConfiguration.put(map2, "Do not write CREATE TABLE statements", MysqldumpArguments.NO_CREATE_INFO);
        MysqldumpConfiguration.put(map2, "Do not dump table contents", MysqldumpArguments.NO_DATA);
        MysqldumpConfiguration.put(map2, "Write SET NAMES default_character_set to the output", MysqldumpArguments.NO_SET_NAMES);
        MysqldumpConfiguration.put(map2, "Exclude CREATE LOGFILE GROUP and CREATE TABLESPACE", MysqldumpArguments.NO_TABLESPACES);
        MysqldumpConfiguration.put(map2, "Shortcut for default options", "--opt");
        MysqldumpConfiguration.put(map2, "Sort rows by its primary key or first unique index", "--order-by-primary");
        MysqldumpConfiguration.put(map2, "Connect to the server using a named pipe (Windows)", MysqldumpArguments.PIPE);
        MysqldumpConfiguration.put(map2, "Quote identifiers", MysqldumpArguments.QUOTE_NAMES);
        MysqldumpConfiguration.put(map2, "REPLACE statements", "--replace");
        MysqldumpConfiguration.put(map2, "Direct output to the named file", MysqldumpArguments.RESULT_FILE);
        MysqldumpConfiguration.put(map2, "Include stored routines", MysqldumpArguments.ROUTINES);
        MysqldumpConfiguration.put(map2, "Set REPEATABLE READ isolation mode", "--single-transaction");
        MysqldumpConfiguration.put(map2, "Write host, program and server version", "--skip-comments");
        MysqldumpConfiguration.put(map2, "Dump only selected by WHERE condition rows", MysqldumpArguments.WHERE);
        MysqldumpConfiguration.put(map2, "Disable --opt option", "--skip-opt");
        MysqldumpConfiguration.put(map2, "Directory for tab-separated files", MysqldumpArguments.TAB);
        MysqldumpConfiguration.put(map2, "Override --databases option", "--tables");
        MysqldumpConfiguration.put(map2, "Include triggers", "--triggers");
        MysqldumpConfiguration.put(map2, "Set connection time zone to UTC", "--tz-utc");
        MysqldumpConfiguration.put(map2, "Add 'SET @@GLOBAL.GTID_PURGED' to the output", MysqldumpArguments.SET_GTID_PURGED);
        MysqldumpConfiguration.put(map2, "Disable --add-drop-table", MysqldumpArguments.SKIP_ADD_DROP_TABLE);
        MysqldumpConfiguration.put(map2, "Disable --add-locks", MysqldumpArguments.SKIP_ADD_LOCKS);
        MysqldumpConfiguration.put(map2, "Disable --create-options", MysqldumpArguments.SKIP_CREATE_OPTIONS);
        MysqldumpConfiguration.put(map2, "Disable --disable-keys", MysqldumpArguments.SKIP_DISABLE_KEYS);
        MysqldumpConfiguration.put(map2, "Disable --dump-date", MysqldumpArguments.SKIP_DUMP_DATE);
        MysqldumpConfiguration.put(map2, "Disable --extended-inserts", MysqldumpArguments.SKIP_EXTENDED_INSERTS);
        MysqldumpConfiguration.put(map2, "Disable --lock-tables", MysqldumpArguments.SKIP_LOCK_TABLES);
        MysqldumpConfiguration.put(map2, "Disable --quote-names", MysqldumpArguments.SKIP_QUOTE_NAMES);
        MysqldumpConfiguration.put(map2, "Disable --set-charset", MysqldumpArguments.SKIP_SET_CHARSET);
        MysqldumpConfiguration.put(map2, "Disable --triggers", MysqldumpArguments.SKIP_TRIGGERS);
        MysqldumpConfiguration.put(map2, "Disable --tz-utc", MysqldumpArguments.SKIP_TZ_UTC);
        MysqldumpConfiguration.put(map2, "Error numbers to be ignored", MysqldumpArguments.IGNORE_ERROR);
        Map<String, String> map3 = map2;
        if (map3 == null) {
            MysqldumpConfiguration.$$$reportNull$$$0(9);
        }
        return map3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/dump/mysql/MysqldumpConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathArgument";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/dump/mysql/MysqldumpConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakAutocompletion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsPreparer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizableArguments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tweakAutocompletion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

