/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelEntityStorage;
import com.intellij.database.model.ModelEntityStoragePersistentBackend;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.sql.database.SqlDataSourceImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDataSourceTextStorage
implements ModelTextStorage {
    private final SqlDataSourceImpl myDataSource;

    SqlDataSourceTextStorage(@NotNull SqlDataSourceImpl dataSource) {
        if (dataSource == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(0);
        }
        this.myDataSource = dataSource;
    }

    @Override
    public void save(@NotNull BasicSourceAware element, @Nullable CompositeText sourceText) {
        if (element == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void queueDelete(@NotNull BasicElement element) {
        if (element == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void clear() {
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware element) {
        if (element == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(3);
        }
        return (CompositeText)ReadAction.compute(() -> {
            DasObject src = this.myDataSource.fromModel(element);
            if (src == null) {
                return null;
            }
            if (src instanceof BasicSourceAware) {
                return ((BasicSourceAware)src).getSourceText();
            }
            SqlObjectBuilder builder = SqlObjectBuilder.EP.forDbms(DbImplUtilCore.getDbms(element));
            final BasicModElement tgt = (BasicModElement)element.getMetaObject().newDataObject();
            class Ctx
            extends SqlObjectBuilder.Context
            implements SqlObjectBuilder.ContextWithSource {
                CompositeText res = null;

                Ctx() {
                }

                @Override
                public void writeSource(@NotNull BasicModSourceAware object, @Nullable CompositeText src) {
                    if (object == null) {
                        Ctx.$$$reportNull$$$0(0);
                    }
                    if (object == tgt) {
                        this.res = src;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/sql/database/SqlDataSourceTextStorage$1Ctx", "writeSource"));
                }
            }
            Ctx context = new Ctx();
            builder.build(tgt, src, context);
            return context.res;
        });
    }

    @Override
    @Nullable
    public Long getVersion(@NotNull BasicElement element) {
        if (element == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public void setVersion(@NotNull BasicElement element, @Nullable Long version) {
        if (element == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(5);
        }
    }

    @Override
    public void writeSession(@NotNull BasicModModel model, @NotNull Runnable runnable) {
        if (model == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(7);
        }
        runnable.run();
    }

    @Override
    public void flushQueues() {
    }

    @Override
    public void handleRename(@NotNull BasicElement e, @NotNull ObjectNamePart oldName) {
        if (e == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(8);
        }
        if (oldName == null) {
            SqlDataSourceTextStorage.$$$reportNull$$$0(9);
        }
    }

    @Override
    public ModelEntityStorage.Backend createEntityStorage() {
        final ModelEntityStoragePersistentBackend backend = DbSrcModelStorage.createPersistentBackend(this.myDataSource.getProject(), this.myDataSource.getUniqueId());
        if (backend == null) {
            return ModelEntityStorage.NO_OP;
        }
        ProgressManager.checkCanceled();
        Disposer.register((Disposable)this.myDataSource.getProject().getMessageBus(), (Disposable)backend);
        this.myDataSource.getProject().getMessageBus().connect((Disposable)backend).subscribe(DataSourceManager.TOPIC, (Object)new DataSourceManager.Listener(){

            @Override
            public <T extends RawDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
                if (manager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (SqlDataSourceTextStorage.this.myDataSource == dataSource) {
                    backend.close();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "manager";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSource";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/database/SqlDataSourceTextStorage$1";
                objectArray[2] = "dataSourceRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return backend;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/database/SqlDataSourceTextStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "queueDelete";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSession";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

