/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JsonRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            JsonRainbowVisitor.$$$reportNull$$$0(0);
        }
        return file instanceof JsonFile;
    }

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            JsonRainbowVisitor.$$$reportNull$$$0(1);
        }
        if (element instanceof JsonProperty) {
            JsonPointerPosition position;
            PsiFile file = element.getContainingFile();
            String fileName = file.getName();
            if (Holder.blacklist.containsKey(fileName) && (position = JsonOriginalPsiWalker.INSTANCE.findPosition(element, false)) != null && Holder.blacklist.get(fileName).contains(position.toJsonPointer())) {
                return;
            }
            String name = ((JsonProperty)element).getName();
            this.addInfo(this.getInfo((PsiElement)file, (PsiElement)((JsonProperty)element).getNameElement(), name, JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY));
            JsonValue value = ((JsonProperty)element).getValue();
            if (value instanceof JsonObject) {
                this.addInfo(this.getInfo((PsiElement)file, value.getFirstChild(), name, JsonSyntaxHighlighterFactory.JSON_BRACES));
                this.addInfo(this.getInfo((PsiElement)file, value.getLastChild(), name, JsonSyntaxHighlighterFactory.JSON_BRACES));
            } else if (value instanceof JsonArray) {
                this.addInfo(this.getInfo((PsiElement)file, value.getFirstChild(), name, JsonSyntaxHighlighterFactory.JSON_BRACKETS));
                this.addInfo(this.getInfo((PsiElement)file, value.getLastChild(), name, JsonSyntaxHighlighterFactory.JSON_BRACKETS));
                for (JsonValue jsonValue : ((JsonArray)value).getValueList()) {
                    this.addSimpleValueInfo(name, file, jsonValue);
                }
            } else {
                this.addSimpleValueInfo(name, file, value);
            }
        }
    }

    private void addSimpleValueInfo(String name, PsiFile file, JsonValue value) {
        if (value instanceof JsonStringLiteral) {
            this.addInfo(this.getInfo((PsiElement)file, (PsiElement)value, name, JsonSyntaxHighlighterFactory.JSON_STRING));
        } else if (value instanceof JsonNumberLiteral) {
            this.addInfo(this.getInfo((PsiElement)file, (PsiElement)value, name, JsonSyntaxHighlighterFactory.JSON_NUMBER));
        } else if (value instanceof JsonLiteral) {
            this.addInfo(this.getInfo((PsiElement)file, (PsiElement)value, name, JsonSyntaxHighlighterFactory.JSON_KEYWORD));
        }
    }

    @NotNull
    public HighlightVisitor clone() {
        return new JsonRainbowVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/highlighting/JsonRainbowVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suitableForFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Holder {
        private static final Map<String, Set<String>> blacklist = Holder.createBlacklist();

        private Holder() {
        }

        private static Map<String, Set<String>> createBlacklist() {
            HashMap<String, Set<String>> blacklist = new HashMap<String, Set<String>>();
            blacklist.put("package.json", Set.of("/dependencies", "/devDependencies", "/peerDependencies", "/scripts", "/directories", "/optionalDependencies"));
            return blacklist;
        }
    }
}

