/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.concurrencyVisualizer.tool;

import com.intellij.python.concurrencyVisualizer.PythonConcurrencyVisualizerBundle;
import com.intellij.python.concurrencyVisualizer.model.ConcurrencyGraphModel;
import com.intellij.python.concurrencyVisualizer.model.ConcurrencyGraphPresentationModel;
import com.intellij.python.concurrencyVisualizer.model.ConcurrencyTable;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyGraphSettings;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyStat;
import com.intellij.python.concurrencyVisualizer.tool.panels.ConcurrencyToolWindowPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class ConcurrencyTableUtil {
    private static void setTableSettings(JBTable table) {
        table.setRowHeight(ConcurrencyGraphSettings.TABLE_ROW_HEIGHT);
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        table.setSelectionMode(0);
    }

    @NotNull
    public static JPanel createTables(@NotNull ConcurrencyGraphModel graphModel, @NotNull ConcurrencyGraphPresentationModel presentationModel, @NotNull ConcurrencyToolWindowPanel toolWindow) {
        if (graphModel == null) {
            ConcurrencyTableUtil.$$$reportNull$$$0(0);
        }
        if (presentationModel == null) {
            ConcurrencyTableUtil.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            ConcurrencyTableUtil.$$$reportNull$$$0(2);
        }
        JPanel tablePanel = new JPanel(new BorderLayout());
        JBTable namesTable = new JBTable((TableModel)new FixedTableModel(graphModel));
        toolWindow.setFixedTable((JTable)namesTable);
        ConcurrencyTableUtil.setTableSettings(namesTable);
        ConcurrencyGraphSettings.customizeVisualSettings(namesTable.getRowHeight());
        JScrollPane namesScrollPane = ScrollPaneFactory.createScrollPane((Component)namesTable);
        namesScrollPane.setPreferredSize(new Dimension(ConcurrencyGraphSettings.NAMES_PANEL_INITIAL_WIDTH, toolWindow.getHeight()));
        namesScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, JBColor.border()));
        tablePanel.add((Component)namesScrollPane, "Before");
        toolWindow.setNamesTable((JTable)namesTable);
        ConcurrencyTable graphTable = new ConcurrencyTable(presentationModel, new ScrollableTableModel(graphModel), toolWindow);
        ConcurrencyTableUtil.setTableSettings(graphTable);
        graphTable.setAutoResizeMode(0);
        graphTable.setSelectionModel(namesTable.getSelectionModel());
        JScrollPane graphScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)graphTable));
        graphScrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JBColor.border()));
        graphScrollPane.getVerticalScrollBar().setModel(namesScrollPane.getVerticalScrollBar().getModel());
        toolWindow.setTableScrollPane(graphScrollPane);
        tablePanel.add((Component)graphScrollPane, "Center");
        JBTable statTable = new JBTable((TableModel)new StatTableModel(graphModel));
        ConcurrencyTableUtil.setTableSettings(statTable);
        statTable.setSelectionModel(graphTable.getSelectionModel());
        toolWindow.setStatTable((JTable)statTable);
        JScrollPane statScrollPane = ScrollPaneFactory.createScrollPane((Component)statTable);
        statScrollPane.setPreferredSize(new Dimension(ConcurrencyGraphSettings.STAT_PANEL_WIDTH, toolWindow.getHeight()));
        statScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, JBColor.border()));
        statScrollPane.getVerticalScrollBar().setModel(graphScrollPane.getVerticalScrollBar().getModel());
        tablePanel.add((Component)statScrollPane, "After");
        JPanel jPanel = tablePanel;
        if (jPanel == null) {
            ConcurrencyTableUtil.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/concurrencyVisualizer/tool/ConcurrencyTableUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/concurrencyVisualizer/tool/ConcurrencyTableUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTables";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class FixedTableModel
    extends AbstractTableModel {
        private final ConcurrencyGraphModel myGraphModel;

        FixedTableModel(ConcurrencyGraphModel graphModel) {
            this.myGraphModel = graphModel;
        }

        @Override
        public int getRowCount() {
            return this.myGraphModel.getMaxThread();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return PythonConcurrencyVisualizerBundle.message("concurrency.diagram.window.name.column", new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myGraphModel.getThreadNameByNumber(rowIndex);
        }
    }

    private static class ScrollableTableModel
    extends AbstractTableModel {
        private final ConcurrencyGraphModel myGraphModel;

        ScrollableTableModel(ConcurrencyGraphModel graphModel) {
            this.myGraphModel = graphModel;
        }

        @Override
        public int getRowCount() {
            return this.myGraphModel.getMaxThread();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return " ";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return GraphCell.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return new GraphCell();
        }
    }

    private static class StatTableModel
    extends AbstractTableModel {
        private final ConcurrencyGraphModel myGraphModel;

        StatTableModel(ConcurrencyGraphModel graphModel) {
            this.myGraphModel = graphModel;
        }

        @Override
        public int getRowCount() {
            return this.myGraphModel.getMaxThread();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return PythonConcurrencyVisualizerBundle.message("concurrency.diagram.window.waiting.time.column", new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            long percents;
            double waitTime;
            String threadId = this.myGraphModel.getThreadIdByIndex(rowIndex);
            if (threadId == null) {
                waitTime = 0.0;
                percents = 0L;
            } else {
                ConcurrencyStat threadStatistics = this.myGraphModel.getStatisticsByThreadId(threadId);
                waitTime = (double)threadStatistics.getWaitTime() / 1000000.0;
                percents = threadStatistics.getWorkTime() > 0L ? threadStatistics.getWaitTime() * 100L / threadStatistics.getWorkTime() : 0L;
            }
            return String.format("%.2f (%d%%)", waitTime, percents);
        }
    }

    public static class GraphCell {
    }
}

