/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.NestedTableGridPagingModel;
import com.intellij.database.run.actions.ChangePageSizeAction;
import com.intellij.database.run.actions.CountRowsAction;
import com.intellij.database.run.actions.SetCustomPageSizeAction;
import com.intellij.database.run.actions.SetDefaultPageSizeAction;
import com.intellij.database.run.ui.FloatingPagingManager;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.actions.AlignedIconWithTextAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangePageSizeActionGroup
extends DefaultActionGroup
implements CustomComponentAction,
DumbAware {
    private static final List<Integer> DEFAULT_PAGE_SIZES = Arrays.asList(10, 100, 500, 1000);
    private static final Key<Integer> PAGE_SIZE_KEY = new Key("DATA_GRID_PAGE_SIZE_KEY");
    private static final Key<Boolean> SHOW_COUNT_ALL_ACTION_KEY = new Key("DATA_GRID_SHOW_COUNT_ALL_ACTION_KEY");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public ChangePageSizeActionGroup() {
        this.setPopup(true);
        this.setActions(DEFAULT_PAGE_SIZES, false);
    }

    private void setActions(List<Integer> sizes, boolean isSinglePage) {
        this.removeAll();
        if (isSinglePage) {
            this.add((AnAction)new MyCountRowsAction());
        }
        this.addSeparator(DataGridBundle.message((String)"separator.page.size", (Object[])new Object[0]));
        for (Integer pageSize : sizes) {
            this.add((AnAction)new ChangePageSizeAction(pageSize));
        }
        this.add((AnAction)new ChangePageSizeAction(-1));
        this.add((AnAction)new SetCustomPageSizeAction());
        this.add((AnAction)new Separator());
        this.add((AnAction)new SetDefaultPageSizeAction());
    }

    public void update(@NotNull AnActionEvent e) {
        NestedTableGridPagingModel nestedPageModel;
        DataGrid grid;
        if (e == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(1);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null || grid.getDataHookup() instanceof DocumentDataHookUp) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GridPagingModel gridPagingModel = grid.getDataHookup().getPageModel();
        if (gridPagingModel instanceof NestedTableGridPagingModel && (nestedPageModel = (NestedTableGridPagingModel)gridPagingModel).isStatic()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (FloatingPagingManager.adjustAction(e) == FloatingPagingManager.AdjustmentResult.HIDDEN) {
            return;
        }
        ChangePageSizeActionState state = ChangePageSizeActionGroup.getActionState(grid);
        if (GridUtil.hidePageActions(grid, e.getPlace())) {
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            this.updatePresentation(state, e.getPresentation(), GridUtil.getSettings(grid));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(2);
        }
        Component component = (Component)e.getPresentation().getClientProperty(COMPONENT_KEY);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this, e.getDataContext(), null, true, null);
        if (component == null) {
            DataGridUIUtil.showPopup((JBPopup)popup, null, e);
            return;
        }
        popup.showUnderneathOf(component);
    }

    @NotNull
    static String format(long num) {
        String string = String.format("%,d", num);
        if (string == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(4);
        }
        if (place == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(5);
        }
        return ChangePageSizeActionGroup.createCustomComponentForResultViewToolbar((AnAction)this, presentation, place);
    }

    @NotNull
    public static JComponent createCustomComponentForResultViewToolbar(@NotNull AnAction action, @NotNull Presentation presentation, @NotNull String place) {
        if (action == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(6);
        }
        if (presentation == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(7);
        }
        if (place == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(8);
        }
        ActionButtonWithText c = new ActionButtonWithText(action, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            public Insets getInsets() {
                return new JBInsets(0, 0, 0, 0);
            }
        };
        JComponent jComponent = AlignedIconWithTextAction.align((JComponent)c);
        if (jComponent == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(9);
        }
        return jComponent;
    }

    private void updatePresentation(ChangePageSizeActionState state, Presentation presentation, @Nullable DataGridSettings settings) {
        ChangePageSizeActionState oldState = ChangePageSizeActionGroup.getActionState(presentation);
        if (oldState.equals(state)) {
            return;
        }
        presentation.setText(state.text);
        presentation.setDescription(state.description);
        presentation.setEnabled(state.enabled);
        presentation.putClientProperty(PAGE_SIZE_KEY, (Object)state.pageSize);
        presentation.putClientProperty(SHOW_COUNT_ALL_ACTION_KEY, (Object)state.showCountAllAction);
        JComponent component = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (component != null) {
            component.setToolTipText(state.tooltip);
            component.repaint();
        }
        ArrayList<Integer> pageSizes = new ArrayList<Integer>(DEFAULT_PAGE_SIZES);
        pageSizes.add(GridUtilCore.getPageSize((DataGridSettings)settings));
        if (state.pageSize > 0) {
            pageSizes.add(state.pageSize * 2);
            int halfSize = state.pageSize / 2;
            if (halfSize > 0) {
                pageSizes.add(halfSize);
            }
            ContainerUtil.removeAll(pageSizes, (Object[])new Integer[]{state.pageSize});
        }
        ContainerUtil.removeDuplicates(pageSizes);
        ContainerUtil.sort(pageSizes);
        this.setActions(pageSizes, state.showCountAllAction);
    }

    @NotNull
    private static ChangePageSizeActionState getActionState(@NotNull Presentation presentation) {
        Boolean showCountAllAction;
        if (presentation == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(10);
        }
        JComponent component = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        String text = presentation.getText();
        String description = presentation.getDescription();
        String tooltip = component != null ? component.getToolTipText() : null;
        boolean loading = presentation.isEnabled();
        Integer pageSize = (Integer)presentation.getClientProperty(PAGE_SIZE_KEY);
        if (pageSize == null) {
            pageSize = -2;
        }
        if ((showCountAllAction = (Boolean)presentation.getClientProperty(SHOW_COUNT_ALL_ACTION_KEY)) == null) {
            showCountAllAction = false;
        }
        return new ChangePageSizeActionState(text, description, tooltip, loading, pageSize, showCountAllAction);
    }

    @NotNull
    private static ChangePageSizeActionState getActionState(@NotNull DataGrid grid) {
        boolean isSinglePage;
        if (grid == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(11);
        }
        GridPagingModel pageModel = grid.getDataHookup().getPageModel();
        int pageStartIdx = pageModel.getPageStart();
        int pageEndIdx = pageModel.getPageEnd();
        long totalRowCount = pageModel.getTotalRowCount();
        boolean rowsWereDeleted = totalRowCount < (long)pageEndIdx;
        boolean bl = isSinglePage = pageModel.isFirstPage() && pageModel.isLastPage() && !rowsWereDeleted;
        String text = isSinglePage ? ChangePageSizeActionGroup.format(totalRowCount) + " " + (totalRowCount == 1L ? DataGridBundle.message((String)"action.Console.TableResult.ChangePageSize.row", (Object[])new Object[0]) : DataGridBundle.message((String)"action.Console.TableResult.ChangePageSize.rows", (Object[])new Object[0])) : (pageEndIdx == 0 ? "0 " + DataGridBundle.message((String)"action.Console.TableResult.ChangePageSize.rows", (Object[])new Object[0]) : ChangePageSizeActionGroup.format(pageStartIdx) + "-" + ChangePageSizeActionGroup.format(pageEndIdx));
        boolean querying = grid.getDataHookup().getBusyCount() > 0;
        boolean enabled = !querying && grid.isReady();
        String description = DataGridBundle.message((String)"group.Console.TableResult.ChangePageSize.description", (Object[])new Object[0]);
        String tooltip = DataGridBundle.message((String)"group.Console.TableResult.ChangePageSize.description", (Object[])new Object[0]);
        if (!enabled) {
            String unavailableText;
            description = unavailableText = querying ? DataGridBundle.message((String)"action.Console.TableResult.ChangePageSize.querying", (Object[])new Object[0]) : "";
            tooltip = unavailableText;
        }
        boolean showCountRowsAction = isSinglePage && pageModel.isTotalRowCountUpdateable() && !querying && grid.isReady();
        return new ChangePageSizeActionState(text, description, tooltip, enabled, pageModel.getPageSize(), showCountRowsAction);
    }

    private static void updateIsTotalRowCountUpdateable(@NotNull DataGrid grid) {
        if (grid == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(12);
        }
        grid.getDataHookup().getLoader().updateIsTotalRowCountUpdateable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChangePageSizeActionGroup";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChangePageSizeActionGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponentForResultViewToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponentForResultViewToolbar";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActionState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateIsTotalRowCountUpdateable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    private static class MyCountRowsAction
    extends DumbAwareAction {
        MyCountRowsAction() {
            super(DataGridBundle.message((String)"action.CountRows.text", (Object[])new Object[0]), DataGridBundle.message((String)"action.CountRows.description", (Object[])new Object[0]), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            if (e == null) {
                MyCountRowsAction.$$$reportNull$$$0(0);
            }
            if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            ChangePageSizeActionGroup.updateIsTotalRowCountUpdateable(grid);
            GridPagingModel pageModel = grid.getDataHookup().getPageModel();
            if (!pageModel.isTotalRowCountUpdateable()) {
                return;
            }
            CountRowsAction.countRows(grid);
            ChangePageSizeActionGroup.updateIsTotalRowCountUpdateable(grid);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ChangePageSizeActionGroup$MyCountRowsAction", "actionPerformed"));
        }
    }

    private static class ChangePageSizeActionState {
        final @NlsActions.ActionText String text;
        final @NlsActions.ActionDescription String description;
        final @NlsContexts.Tooltip String tooltip;
        final boolean enabled;
        final int pageSize;
        final boolean showCountAllAction;

        ChangePageSizeActionState(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, @NlsContexts.Tooltip String tooltip, boolean enabled, int pageSize, boolean showCountAllAction) {
            this.text = text;
            this.description = description;
            this.tooltip = tooltip;
            this.enabled = enabled;
            this.pageSize = pageSize;
            this.showCountAllAction = showCountAllAction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangePageSizeActionState state = (ChangePageSizeActionState)o;
            return this.enabled == state.enabled && this.pageSize == state.pageSize && Objects.equals(this.text, state.text) && Objects.equals(this.description, state.description) && Objects.equals(this.tooltip, state.tooltip);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.description, this.tooltip, this.enabled, this.pageSize);
        }
    }
}

