/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.graphics.PathSegmentKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.PathSegmentIterator;
import org.jetbrains.skia.PathVerb;
import org.jetbrains.skia.Point;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0016H\u0096\u0002J\t\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J\u0018\u0010\u0018\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/graphics/SkiaPathIterator;", "Landroidx/compose/ui/graphics/PathIterator;", "path", "Landroidx/compose/ui/graphics/Path;", "conicEvaluation", "Landroidx/compose/ui/graphics/PathIterator$ConicEvaluation;", "tolerance", "", "(Landroidx/compose/ui/graphics/Path;Landroidx/compose/ui/graphics/PathIterator$ConicEvaluation;F)V", "getConicEvaluation", "()Landroidx/compose/ui/graphics/PathIterator$ConicEvaluation;", "iterator", "Lorg/jetbrains/skia/PathSegmentIterator;", "getPath", "()Landroidx/compose/ui/graphics/Path;", "skiaPath", "Lorg/jetbrains/skia/Path;", "getTolerance", "()F", "calculateSize", "", "includeConvertedConics", "", "hasNext", "next", "Landroidx/compose/ui/graphics/PathSegment;", "Landroidx/compose/ui/graphics/PathSegment$Type;", "points", "", "offset", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nSkiaPathIterator.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaPathIterator.skiko.kt\nandroidx/compose/ui/graphics/SkiaPathIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
final class SkiaPathIterator
implements PathIterator {
    @NotNull
    private final Path path;
    @NotNull
    private final PathIterator.ConicEvaluation conicEvaluation;
    private final float tolerance;
    @NotNull
    private final org.jetbrains.skia.Path skiaPath;
    @NotNull
    private final PathSegmentIterator iterator;

    public SkiaPathIterator(@NotNull Path path, @NotNull PathIterator.ConicEvaluation conicEvaluation, float tolerance) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)conicEvaluation), (String)"conicEvaluation");
        this.path = path;
        this.conicEvaluation = conicEvaluation;
        this.tolerance = tolerance;
        this.skiaPath = SkiaBackedPath_skikoKt.asSkiaPath(this.getPath());
        this.iterator = this.skiaPath.iterator();
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public PathIterator.ConicEvaluation getConicEvaluation() {
        return this.conicEvaluation;
    }

    @Override
    public float getTolerance() {
        return this.tolerance;
    }

    @Override
    public int calculateSize(boolean includeConvertedConics) {
        return this.skiaPath.getVerbsCount();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    @NotNull
    public PathSegment.Type next(@NotNull float[] points, int offset2) {
        PathSegment.Type type2;
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        if (!(points.length - offset2 >= 8)) {
            boolean bl = false;
            String string = "The points array must contain at least 8 floats";
            throw new IllegalStateException(string.toString());
        }
        if (!this.hasNext()) {
            return PathSegment.Type.Done;
        }
        org.jetbrains.skia.PathSegment segment = this.iterator.next();
        if (segment == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getVerb().ordinal()]) {
            case 1: {
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                points[offset2] = point.getX();
                Point point2 = segment.getP0();
                Intrinsics.checkNotNull((Object)point2);
                points[offset2 + 1] = point2.getY();
                type2 = PathSegment.Type.Move;
                break;
            }
            case 2: {
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                points[offset2] = point.getX();
                Point point3 = segment.getP0();
                Intrinsics.checkNotNull((Object)point3);
                points[offset2 + 1] = point3.getY();
                Point point4 = segment.getP1();
                Intrinsics.checkNotNull((Object)point4);
                points[offset2 + 2] = point4.getX();
                Point point5 = segment.getP1();
                Intrinsics.checkNotNull((Object)point5);
                points[offset2 + 3] = point5.getY();
                type2 = PathSegment.Type.Line;
                break;
            }
            case 3: {
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                points[offset2] = point.getX();
                Point point6 = segment.getP0();
                Intrinsics.checkNotNull((Object)point6);
                points[offset2 + 1] = point6.getY();
                Point point7 = segment.getP1();
                Intrinsics.checkNotNull((Object)point7);
                points[offset2 + 2] = point7.getX();
                Point point8 = segment.getP1();
                Intrinsics.checkNotNull((Object)point8);
                points[offset2 + 3] = point8.getY();
                Point point9 = segment.getP2();
                Intrinsics.checkNotNull((Object)point9);
                points[offset2 + 4] = point9.getX();
                Point point10 = segment.getP2();
                Intrinsics.checkNotNull((Object)point10);
                points[offset2 + 5] = point10.getY();
                type2 = PathSegment.Type.Quadratic;
                break;
            }
            case 4: {
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                points[offset2] = point.getX();
                Point point11 = segment.getP0();
                Intrinsics.checkNotNull((Object)point11);
                points[offset2 + 1] = point11.getY();
                Point point12 = segment.getP1();
                Intrinsics.checkNotNull((Object)point12);
                points[offset2 + 2] = point12.getX();
                Point point13 = segment.getP1();
                Intrinsics.checkNotNull((Object)point13);
                points[offset2 + 3] = point13.getY();
                Point point14 = segment.getP2();
                Intrinsics.checkNotNull((Object)point14);
                points[offset2 + 4] = point14.getX();
                Point point15 = segment.getP2();
                Intrinsics.checkNotNull((Object)point15);
                points[offset2 + 5] = point15.getY();
                points[offset2 + 6] = segment.getConicWeight();
                points[offset2 + 7] = segment.getConicWeight();
                type2 = PathSegment.Type.Conic;
                break;
            }
            case 5: {
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                points[offset2] = point.getX();
                Point point16 = segment.getP0();
                Intrinsics.checkNotNull((Object)point16);
                points[offset2 + 1] = point16.getY();
                Point point17 = segment.getP1();
                Intrinsics.checkNotNull((Object)point17);
                points[offset2 + 2] = point17.getX();
                Point point18 = segment.getP1();
                Intrinsics.checkNotNull((Object)point18);
                points[offset2 + 3] = point18.getY();
                Point point19 = segment.getP2();
                Intrinsics.checkNotNull((Object)point19);
                points[offset2 + 4] = point19.getX();
                Point point20 = segment.getP2();
                Intrinsics.checkNotNull((Object)point20);
                points[offset2 + 5] = point20.getY();
                Point point21 = segment.getP3();
                Intrinsics.checkNotNull((Object)point21);
                points[offset2 + 6] = point21.getX();
                Point point22 = segment.getP3();
                Intrinsics.checkNotNull((Object)point22);
                points[offset2 + 7] = point22.getY();
                type2 = PathSegment.Type.Cubic;
                break;
            }
            case 6: {
                type2 = PathSegment.Type.Close;
                break;
            }
            case 7: {
                type2 = PathSegment.Type.Done;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type2;
    }

    @Override
    @NotNull
    public PathSegment next() {
        PathSegment pathSegment;
        if (!this.hasNext()) {
            return PathSegmentKt.getDoneSegment();
        }
        org.jetbrains.skia.PathSegment segment = this.iterator.next();
        if (segment == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getVerb().ordinal()]) {
            case 1: {
                float[] fArray = new float[2];
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point2 = segment.getP0();
                Intrinsics.checkNotNull((Object)point2);
                fArray[1] = point2.getY();
                PathSegment pathSegment2 = new PathSegment(PathSegment.Type.Move, fArray, 0.0f);
                pathSegment = pathSegment2;
                break;
            }
            case 2: {
                float[] fArray = new float[4];
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point3 = segment.getP0();
                Intrinsics.checkNotNull((Object)point3);
                fArray[1] = point3.getY();
                Point point4 = segment.getP1();
                Intrinsics.checkNotNull((Object)point4);
                fArray[2] = point4.getX();
                Point point5 = segment.getP1();
                Intrinsics.checkNotNull((Object)point5);
                fArray[3] = point5.getY();
                PathSegment pathSegment3 = new PathSegment(PathSegment.Type.Line, fArray, 0.0f);
                pathSegment = pathSegment3;
                break;
            }
            case 3: {
                float[] fArray = new float[6];
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point6 = segment.getP0();
                Intrinsics.checkNotNull((Object)point6);
                fArray[1] = point6.getY();
                Point point7 = segment.getP1();
                Intrinsics.checkNotNull((Object)point7);
                fArray[2] = point7.getX();
                Point point8 = segment.getP1();
                Intrinsics.checkNotNull((Object)point8);
                fArray[3] = point8.getY();
                Point point9 = segment.getP2();
                Intrinsics.checkNotNull((Object)point9);
                fArray[4] = point9.getX();
                Point point10 = segment.getP2();
                Intrinsics.checkNotNull((Object)point10);
                fArray[5] = point10.getY();
                PathSegment pathSegment4 = new PathSegment(PathSegment.Type.Quadratic, fArray, 0.0f);
                pathSegment = pathSegment4;
                break;
            }
            case 4: {
                float[] fArray = new float[6];
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point11 = segment.getP0();
                Intrinsics.checkNotNull((Object)point11);
                fArray[1] = point11.getY();
                Point point12 = segment.getP1();
                Intrinsics.checkNotNull((Object)point12);
                fArray[2] = point12.getX();
                Point point13 = segment.getP1();
                Intrinsics.checkNotNull((Object)point13);
                fArray[3] = point13.getY();
                Point point14 = segment.getP2();
                Intrinsics.checkNotNull((Object)point14);
                fArray[4] = point14.getX();
                Point point15 = segment.getP2();
                Intrinsics.checkNotNull((Object)point15);
                fArray[5] = point15.getY();
                PathSegment pathSegment5 = new PathSegment(PathSegment.Type.Quadratic, fArray, segment.getConicWeight());
                pathSegment = pathSegment5;
                break;
            }
            case 5: {
                float[] fArray = new float[8];
                Point point = segment.getP0();
                Intrinsics.checkNotNull((Object)point);
                fArray[0] = point.getX();
                Point point16 = segment.getP0();
                Intrinsics.checkNotNull((Object)point16);
                fArray[1] = point16.getY();
                Point point17 = segment.getP1();
                Intrinsics.checkNotNull((Object)point17);
                fArray[2] = point17.getX();
                Point point18 = segment.getP1();
                Intrinsics.checkNotNull((Object)point18);
                fArray[3] = point18.getY();
                Point point19 = segment.getP2();
                Intrinsics.checkNotNull((Object)point19);
                fArray[4] = point19.getX();
                Point point20 = segment.getP2();
                Intrinsics.checkNotNull((Object)point20);
                fArray[5] = point20.getY();
                Point point21 = segment.getP3();
                Intrinsics.checkNotNull((Object)point21);
                fArray[6] = point21.getX();
                Point point22 = segment.getP3();
                Intrinsics.checkNotNull((Object)point22);
                fArray[7] = point22.getY();
                PathSegment pathSegment6 = new PathSegment(PathSegment.Type.Cubic, fArray, 0.0f);
                pathSegment = pathSegment6;
                break;
            }
            case 6: {
                pathSegment = PathSegmentKt.getCloseSegment();
                break;
            }
            case 7: {
                pathSegment = PathSegmentKt.getDoneSegment();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pathSegment;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathVerb.values().length];
            try {
                nArray[PathVerb.MOVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.QUAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.CONIC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.CUBIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.CLOSE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathVerb.DONE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

