/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

public class ComposeFileReferenceResolver {
    public static final ComposeFileReferenceResolver SERVICES = new ComposeFileReferenceResolver("services");
    public static final ComposeFileReferenceResolver NETWORKS = new ComposeFileReferenceResolver("networks");
    public static final ComposeFileReferenceResolver VOLUMES = new ComposeFileReferenceResolver("volumes");
    public static final ComposeFileReferenceResolver CONFIGS = new ComposeFileReferenceResolver("configs");
    public static final ComposeFileReferenceResolver SECRETS = new ComposeFileReferenceResolver("secrets");
    private final String myDeclarationsMappingName;

    public static ComposeFileReferenceResolver[] allReferenceResolvers() {
        return new ComposeFileReferenceResolver[]{SERVICES, NETWORKS, VOLUMES, CONFIGS, SECRETS};
    }

    public ComposeFileReferenceResolver(@NotNull @NonNls String declarationsMappingName) {
        if (declarationsMappingName == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(0);
        }
        this.myDeclarationsMappingName = declarationsMappingName;
    }

    String getDeclarationsMappingName() {
        return this.myDeclarationsMappingName;
    }

    boolean isPotentialReferenceTarget(@NotNull YAMLKeyValue keyValue) {
        YAMLDocument document;
        if (keyValue == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(1);
        }
        if ((document = (YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)keyValue, YAMLDocument.class)) == null) {
            return false;
        }
        return ComposeFileReferenceResolver.findTopLevelMappingByName(document, this.myDeclarationsMappingName).map(mapping -> mapping == keyValue.getParentMapping()).orElse(false);
    }

    @NotNull
    public Optional<YAMLKeyValue> resolveByName(@Nullable PsiFile psiFile, @NotNull String lookupName) {
        if (lookupName == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(2);
        }
        Optional<YAMLKeyValue> optional = Optional.ofNullable(psiFile).map(file -> (YAMLFile)ObjectUtils.tryCast((Object)file, YAMLFile.class)).map(file -> (YAMLDocument)ContainerUtil.getFirstItem((List)file.getDocuments())).flatMap(doc -> this.resolveByName((YAMLDocument)doc, lookupName));
        if (optional == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(3);
        }
        return optional;
    }

    public Collection<YAMLKeyValue> resolveAll(@Nullable PsiFile psiFile) {
        return Optional.ofNullable(psiFile).map(file -> (YAMLFile)ObjectUtils.tryCast((Object)file, YAMLFile.class)).map(file -> (YAMLDocument)ContainerUtil.getFirstItem((List)file.getDocuments())).map(doc -> this.listAllCandidates((YAMLDocument)doc)).orElse(Collections.emptyList());
    }

    @NotNull
    public Optional<YAMLKeyValue> resolveByName(@Nullable YAMLDocument document, @NotNull String lookupName) {
        if (lookupName == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(4);
        }
        Optional<YAMLKeyValue> optional = this.listAllCandidates(document).stream().filter(kv -> lookupName.equals(kv.getKeyText().trim())).findAny();
        if (optional == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(5);
        }
        return optional;
    }

    @NotNull
    public Collection<YAMLKeyValue> listAllCandidates(@Nullable YAMLDocument document) {
        Optional<YAMLMapping> declarationsContainer = ComposeFileReferenceResolver.findTopLevelMappingByName(document, this.myDeclarationsMappingName);
        Collection collection = declarationsContainer.map(YAMLMapping::getKeyValues).orElse(Collections.emptyList());
        if (collection == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public List<LookupElementBuilder> createValueLookups(@NotNull PsiElement context) {
        if (context == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(7);
        }
        List<LookupElementBuilder> list2 = this.createValueLookups((YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)context, YAMLDocument.class), ComposeFileReferenceResolver.SKIP_ANCESTOR(context));
        if (list2 == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public List<LookupElementBuilder> createValueLookups(@Nullable YAMLDocument document, @NotNull Predicate<? super YAMLKeyValue> filter2) {
        if (filter2 == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(9);
        }
        List<LookupElementBuilder> list2 = this.listAllCandidates(document).stream().filter(filter2).map(this::createValueLookup).filter(Objects::nonNull).collect(Collectors.toList());
        if (list2 == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public static Predicate<YAMLKeyValue> SKIP_ANCESTOR(@NotNull PsiElement context) {
        if (context == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(11);
        }
        return kv -> !PsiTreeUtil.isAncestor((PsiElement)kv, (PsiElement)context, (boolean)true);
    }

    @Nullable
    protected LookupElementBuilder createValueLookup(@NotNull YAMLKeyValue keyValue) {
        if (keyValue == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(12);
        }
        return LookupElementBuilder.create((String)keyValue.getKeyText().trim());
    }

    @NotNull
    private static Optional<YAMLMapping> findTopLevelMappingByName(@Nullable YAMLDocument document, @NotNull String nodeName) {
        if (nodeName == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(13);
        }
        Optional<YAMLMapping> optional = Optional.ofNullable(document).map(YAMLDocument::getTopLevelValue).filter(YAMLMapping.class::isInstance).map(YAMLMapping.class::cast).map(map2 -> map2.getKeyValueByKey(nodeName)).map(YAMLKeyValue::getValue).filter(YAMLMapping.class::isInstance).map(YAMLMapping.class::cast);
        if (optional == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(14);
        }
        return optional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 8, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationsMappingName";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/composeFile/ComposeFileReferenceResolver";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileReferenceResolver";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveByName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllCandidates";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueLookups";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopLevelMappingByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPotentialReferenceTarget";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveByName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createValueLookups";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "SKIP_ANCESTOR";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createValueLookup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelMappingByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 8, 10, 14 -> new IllegalStateException(string);
        };
    }
}

