/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.configuration;

import com.intellij.DynamicBundle;
import com.intellij.docker.remote.DockerCliPresentationUtil;
import com.intellij.docker.remote.DockerCliTextField;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerInterpreterContainerSettingsEditorDialog;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DockerContainerCliSettingsEditor<T extends LocatableConfigurationBase<?>>
extends SettingsEditor<T> {
    private JPanel myMainPanel;
    private DockerCliTextField myCliField;
    @NotNull
    private final Function<T, RemoteServer<?>> myRemoteServerGetter;
    @NotNull
    private DockerContainerSettings myCurrentSettings;
    private RemoteServer<?> myCurrentServer;

    public DockerContainerCliSettingsEditor(@NotNull Project project, @NotNull Function<T, RemoteServer<?>> remoteServerGetter) {
        if (project == null) {
            DockerContainerCliSettingsEditor.$$$reportNull$$$0(0);
        }
        if (remoteServerGetter == null) {
            DockerContainerCliSettingsEditor.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myCurrentSettings = DockerContainerSettings.defaultSettings(project, 2);
        this.myRemoteServerGetter = remoteServerGetter;
        this.myCliField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerContainerCliSettingsEditor.this.showContainerSettingsEditor();
            }
        });
    }

    private void showContainerSettingsEditor() {
        DockerInterpreterContainerSettingsEditorDialog dialog2 = new DockerInterpreterContainerSettingsEditorDialog(this.myCurrentServer, this.myCurrentSettings);
        if (dialog2.showAndGet()) {
            List<String> options = DockerCliPresentationUtil.toCliPresentationOptions(this.myCurrentSettings);
            this.myCliField.setText(StringUtil.join(options, (String)" "));
            this.myCliField.setSplittedText(options);
        }
    }

    protected void resetEditorFrom(@NotNull T s) {
        DockerContainerSettings data2;
        if (s == null) {
            DockerContainerCliSettingsEditor.$$$reportNull$$$0(2);
        }
        this.myCurrentSettings = (data2 = (DockerContainerSettings)s.getCopyableUserData(DockerContainerSettings.KEY)) == null ? DockerContainerSettings.defaultSettings(s.getProject(), 2) : data2.clone();
        this.myCurrentServer = this.myRemoteServerGetter.apply(s);
        List<String> options = DockerCliPresentationUtil.toCliPresentationOptions(this.myCurrentSettings);
        this.myCliField.setText(StringUtil.join(options, (String)" "));
        this.myCliField.setSplittedText(options);
    }

    protected void applyEditorTo(@NotNull T s) {
        if (s == null) {
            DockerContainerCliSettingsEditor.$$$reportNull$$$0(3);
        }
        s.putCopyableUserData(DockerContainerSettings.KEY, (Object)this.myCurrentSettings);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DockerContainerCliSettingsEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        DockerCliTextField dockerCliTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerContainerCliSettingsEditor.class).getString("docker.container.settings.label.text"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCliField = dockerCliTextField = new DockerCliTextField();
        dockerCliTextField.setEditable(false);
        jPanel.add((Component)((Object)dockerCliTextField), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteServerGetter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/configuration/DockerContainerCliSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/configuration/DockerContainerCliSettingsEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

