/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.utils.PluginInfo;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001d\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001d\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0018H\u0007J\u001c\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bJ\u0010\u0010\u001c\u001a\u00020\r2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00102\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u000e\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010J\u0011\u0010%\u001a\u00020\u0005*\u00020\u0005H\u0000\u00a2\u0006\u0002\b&J\f\u0010'\u001a\u00020\u0005*\u00020\u0005H\u0007J\u0011\u0010%\u001a\u00020\u0010*\u00020\u0010H\u0000\u00a2\u0006\u0002\b&J\f\u0010'\u001a\u00020\u0010*\u00020\u0010H\u0007J\f\u0010,\u001a\u00020**\u00020*H\u0002Je\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.*\u00020/2K\u00100\u001aG\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0013\u0012\u00110*\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(5\u0012\u0013\u0012\u00110*\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(6\u0012\u0004\u0012\u0002H.01H\u0082\b\u00a2\u0006\u0002\u00107J\f\u00108\u001a\u00020\u0005*\u00020*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010+\u00a8\u00069"}, d2={"Lcom/intellij/internal/statistic/utils/StatisticsUtil;", "", "<init>", "()V", "kilo", "", "mega", "addPluginInfoTo", "", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "data", "", "", "roundToPowerOfTwo", "value", "", "roundToHighestDigit", "roundToUpperBound", "bounds", "", "roundToUpperBoundInternal", "roundToUpperBoundInternal$intellij_platform_statistics", "roundToUpperBoundInternalTest", "", "getCountingStepName", "steps", "", "getCurrentHourInUTC", "calendar", "Ljava/util/Calendar;", "getTimestampDateInUTC", "timestamp", "humanize", "number", "roundDuration", "durationMs", "roundLogarithmic", "roundLogarithmic$intellij_platform_statistics", "roundLogarithmicTest", "roundValues", "", "", "[Ljava/lang/Double;", "roundMantis", "decomposed10", "T", "", "processor", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "sign", "m", "base", "(Ljava/lang/Number;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "intLog10", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nStatisticsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsUtil.kt\ncom/intellij/internal/statistic/utils/StatisticsUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,285:1\n276#1,4:286\n276#1,4:290\n13402#2,2:294\n*S KotlinDebug\n*F\n+ 1 StatisticsUtil.kt\ncom/intellij/internal/statistic/utils/StatisticsUtil\n*L\n248#1:286,4\n255#1:290,4\n266#1:294,2\n*E\n"})
public final class StatisticsUtil {
    @NotNull
    public static final StatisticsUtil INSTANCE = new StatisticsUtil();
    private static final int kilo = 1000;
    private static final int mega = 1000000;
    @NotNull
    private static final Double[] roundValues;

    private StatisticsUtil() {
    }

    @JvmStatic
    public static final void addPluginInfoTo(@NotNull PluginInfo info, @NotNull Map<String, Object> data) {
        String version;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        data.put("plugin_type", info.getType().name());
        if (!info.getType().isSafeToReport()) {
            return;
        }
        String id = info.getId();
        CharSequence charSequence2 = id;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            data.put("plugin", id);
        }
        if (!((charSequence = (CharSequence)(version = info.getVersion())) == null || charSequence.length() == 0)) {
            data.put("plugin_version", version);
        }
    }

    @JvmStatic
    public static final int roundToPowerOfTwo(int value) {
        if (value == 0) {
            return 0;
        }
        int abs = Math.abs(value);
        if (abs == 1) {
            return value;
        }
        int nextPowerOfTwo = Integer.highestOneBit(abs - 1) << 1;
        if (nextPowerOfTwo < 0) {
            if (value > 0) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        return Integer.signum(value) * nextPowerOfTwo;
    }

    @JvmStatic
    public static final long roundToPowerOfTwo(long value) {
        if (value == 0L) {
            return 0L;
        }
        long abs = Math.abs(value);
        if (abs == 1L) {
            return value;
        }
        long nextPowerOfTwo = Long.highestOneBit(abs - 1L) << 1;
        if (nextPowerOfTwo < 0L) {
            if (value > 0L) {
                return Long.MAX_VALUE;
            }
            return Long.MIN_VALUE;
        }
        return (long)Long.signum(value) * nextPowerOfTwo;
    }

    @JvmStatic
    public static final int roundToHighestDigit(int value) {
        int abs;
        if (value == 0) {
            return 0;
        }
        int n = abs = value != Integer.MIN_VALUE ? Math.abs(value) : Integer.MAX_VALUE;
        if (abs <= 4) {
            return Integer.signum(value) * 1;
        }
        if (abs <= 10) {
            return Integer.signum(value) * 10;
        }
        float firstDigit = abs;
        int tenPowX = 1;
        while (firstDigit > 10.0f) {
            firstDigit /= (float)10;
            tenPowX *= 10;
        }
        return Integer.signum(value) * (MathKt.roundToInt((float)firstDigit) * tenPowX);
    }

    @JvmStatic
    public static final long roundToHighestDigit(long value) {
        long abs;
        if (value == 0L) {
            return 0L;
        }
        long l = abs = value != Long.MIN_VALUE ? Math.abs(value) : Long.MAX_VALUE;
        if (abs <= 4L) {
            return (long)Long.signum(value) * 1L;
        }
        if (abs <= 10L) {
            return (long)Long.signum(value) * 10L;
        }
        double firstDigit = abs;
        long tenPowX = 1L;
        while (firstDigit > 10.0) {
            firstDigit /= (double)10L;
            tenPowX *= 10L;
        }
        return (long)Long.signum(value) * (MathKt.roundToLong((double)firstDigit) * tenPowX);
    }

    @JvmStatic
    @Deprecated(message="Use com.intellij.internal.statistic.eventLog.events.EventFields.BoundedInt instead", replaceWith=@ReplaceWith(expression="roundToUpperBoundInternal", imports={}))
    @ApiStatus.ScheduledForRemoval
    public static final int roundToUpperBound(int value, @NotNull int[] bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return StatisticsUtil.roundToUpperBoundInternal$intellij_platform_statistics(value, bounds);
    }

    @JvmStatic
    public static final int roundToUpperBoundInternal$intellij_platform_statistics(int value, @NotNull int[] bounds) {
        int revertedIndex;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        int insertIndex = ArraysKt.binarySearch((int[])bounds, (int)value, (int)0, (int)bounds.length);
        return insertIndex >= 0 ? bounds[insertIndex] : ((revertedIndex = -(insertIndex + 1)) < bounds.length ? bounds[revertedIndex] : ArraysKt.last((int[])bounds));
    }

    @TestOnly
    public final int roundToUpperBoundInternalTest(int value, @NotNull int[] bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return StatisticsUtil.roundToUpperBoundInternal$intellij_platform_statistics(value, bounds);
    }

    @JvmStatic
    public static final long roundToUpperBoundInternal$intellij_platform_statistics(long value, @NotNull long[] bounds) {
        int revertedIndex;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        int insertIndex = ArraysKt.binarySearch((long[])bounds, (long)value, (int)0, (int)bounds.length);
        return insertIndex >= 0 ? bounds[insertIndex] : ((revertedIndex = -(insertIndex + 1)) < bounds.length ? bounds[revertedIndex] : ArraysKt.last((long[])bounds));
    }

    @TestOnly
    public final long roundToUpperBoundInternalTest(long value, @NotNull long[] bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return StatisticsUtil.roundToUpperBoundInternal$intellij_platform_statistics(value, bounds);
    }

    @NotNull
    public final String getCountingStepName(int value, @NotNull List<Integer> steps) {
        int stepIndex;
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        if (steps.isEmpty()) {
            return String.valueOf(value);
        }
        if (value < ((Number)steps.get(0)).intValue()) {
            return "<" + steps.get(0);
        }
        for (stepIndex = 0; stepIndex < steps.size() - 1 && value >= ((Number)steps.get(stepIndex + 1)).intValue(); ++stepIndex) {
        }
        int step = ((Number)steps.get(stepIndex)).intValue();
        boolean addPlus = stepIndex == steps.size() - 1 || ((Number)steps.get(stepIndex + 1)).intValue() != step + 1;
        return this.humanize(step) + (addPlus ? "+" : "");
    }

    @NotNull
    public final String getCurrentHourInUTC(@NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        calendar.set(1, RangesKt.coerceIn((int)calendar.get(1), (int)2000, (int)2099));
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHH", Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String string = format.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static /* synthetic */ String getCurrentHourInUTC$default(StatisticsUtil statisticsUtil, Calendar calendar, int n, Object object) {
        if ((n & 1) != 0) {
            calendar = Calendar.getInstance(Locale.ENGLISH);
        }
        return statisticsUtil.getCurrentHourInUTC(calendar);
    }

    @NotNull
    public final String getTimestampDateInUTC(long timestamp, @NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        calendar.setTimeInMillis(timestamp);
        calendar.set(1, RangesKt.coerceIn((int)calendar.get(1), (int)2000, (int)2099));
        SimpleDateFormat format = new SimpleDateFormat("yyMMdd", Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String string = format.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static /* synthetic */ String getTimestampDateInUTC$default(StatisticsUtil statisticsUtil, long l, Calendar calendar, int n, Object object) {
        if ((n & 2) != 0) {
            calendar = Calendar.getInstance(Locale.ENGLISH);
        }
        return statisticsUtil.getTimestampDateInUTC(l, calendar);
    }

    private final String humanize(int number) {
        if (number == 0) {
            return "0";
        }
        int m = number / 1000000;
        int k = number % 1000000 / 1000;
        int r = number % 1000;
        Object ms = m > 0 ? m + "M" : "";
        Object ks = k > 0 ? k + "K" : "";
        String rs = r > 0 ? String.valueOf(r) : "";
        return (String)ms + (String)ks + rs;
    }

    public final long roundDuration(long durationMs) {
        if (durationMs >= 100L || durationMs < 0L) {
            return durationMs / (long)100 * (long)100;
        }
        return durationMs >= 50L ? 50L : 0L;
    }

    /*
     * WARNING - void declaration
     */
    public final int roundLogarithmic$intellij_platform_statistics(int $this$roundLogarithmic) {
        void base;
        void m;
        double base$iv;
        void this_$iv;
        StatisticsUtil statisticsUtil = this;
        int $this$decomposed10$iv = $this$roundLogarithmic;
        boolean $i$f$decomposed10 = false;
        double v$iv = $this$decomposed10$iv;
        int lg$iv = super.intLog10(v$iv);
        double d = base$iv = Math.pow(10.0, lg$iv);
        double d2 = Math.abs(v$iv) / base$iv;
        int s = (int)Math.signum(v$iv);
        boolean bl = false;
        return s * (int)INSTANCE.roundMantis((double)m) * MathKt.roundToInt((double)base);
    }

    @TestOnly
    public final int roundLogarithmicTest(int $this$roundLogarithmicTest) {
        return this.roundLogarithmic$intellij_platform_statistics($this$roundLogarithmicTest);
    }

    /*
     * WARNING - void declaration
     */
    public final long roundLogarithmic$intellij_platform_statistics(long $this$roundLogarithmic) {
        void base;
        void m;
        double base$iv;
        void this_$iv;
        StatisticsUtil statisticsUtil = this;
        long $this$decomposed10$iv = $this$roundLogarithmic;
        boolean $i$f$decomposed10 = false;
        double v$iv = $this$decomposed10$iv;
        int lg$iv = super.intLog10(v$iv);
        double d = base$iv = Math.pow(10.0, lg$iv);
        double d2 = Math.abs(v$iv) / base$iv;
        int s = (int)Math.signum(v$iv);
        boolean bl = false;
        return (long)s * (long)INSTANCE.roundMantis((double)m) * MathKt.roundToLong((double)base);
    }

    @TestOnly
    public final long roundLogarithmicTest(long $this$roundLogarithmicTest) {
        return this.roundLogarithmic$intellij_platform_statistics($this$roundLogarithmicTest);
    }

    private final double roundMantis(double $this$roundMantis) {
        double prev = 0.0;
        Double[] $this$forEach$iv = roundValues;
        boolean $i$f$forEach = false;
        for (Double element$iv : $this$forEach$iv) {
            double it = ((Number)element$iv).doubleValue();
            boolean bl = false;
            if ($this$roundMantis < (it + prev) / 2.0) {
                return prev;
            }
            prev = it;
        }
        return 10.0;
    }

    private final <T> T decomposed10(Number $this$decomposed10, Function3<? super Integer, ? super Double, ? super Double, ? extends T> processor) {
        boolean $i$f$decomposed10 = false;
        double v = $this$decomposed10.doubleValue();
        int lg = this.intLog10(v);
        double base = Math.pow(10.0, lg);
        return (T)processor.invoke((Object)((int)Math.signum(v)), (Object)(Math.abs(v) / base), (Object)base);
    }

    private final int intLog10(double $this$intLog10) {
        double it = Math.abs($this$intLog10);
        boolean bl = false;
        return it < 10.0 ? 0 : (int)MathKt.truncate((double)Math.log10(it));
    }

    static {
        Double[] doubleArray = new Double[]{1.0, 2.0, 5.0, 10.0};
        roundValues = doubleArray;
    }
}

