/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.url;

import com.intellij.microservices.ui.MicroservicesUIIcons;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.flat.EndpointsToolWindowFactoryKt;
import com.intellij.microservices.ui.flat.EndpointsView;
import com.intellij.microservices.url.inlay.UrlPathInlayAction;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/microservices/ui/url/ShowModuleEndpointsUrlInlayAction;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayAction;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "actionPerformed", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "urlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "mouseEvent", "Ljava/awt/event/MouseEvent;", "isAvailable", "", "urlPathInlayHint", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHint;", "intellij.microservices.ui"})
public final class ShowModuleEndpointsUrlInlayAction
implements UrlPathInlayAction {
    @NotNull
    public Icon getIcon() {
        Icon icon = MicroservicesUIIcons.EndpointsAction;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"EndpointsAction");
        return icon;
    }

    @NotNull
    public String getName() {
        return MicroservicesUiBundle.message("action.show.module.endpoints", new Object[0]);
    }

    public void actionPerformed(@NotNull PsiFile file, @NotNull Editor editor, @NotNull UrlPathContext urlPathContext, @NotNull MouseEvent mouseEvent) {
        block1: {
            ToolWindow toolWindow;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
            if (module == null) {
                return;
            }
            Module module2 = module;
            MicroservicesUsageCollector.INSTANCE.getURL_INLAY_ACTION_TRIGGERED_EVENT().log(project2, (Object)"open_endpoints");
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(project2).getToolWindow("Endpoints");
            if (toolWindow2 == null) break block1;
            toolWindow2.show(() -> ShowModuleEndpointsUrlInlayAction.actionPerformed$lambda$0(project2, module2));
        }
    }

    public boolean isAvailable(@NotNull PsiFile file, @NotNull UrlPathInlayHint urlPathInlayHint) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)urlPathInlayHint, (String)"urlPathInlayHint");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return EndpointsToolWindowFactoryKt.isEndpointsToolwindowAvailable(project) && ModuleUtilCore.findModuleForFile((PsiFile)file) != null;
    }

    private static final void actionPerformed$lambda$0(Project $project, Module $module) {
        block0: {
            EndpointsView view;
            EndpointsView endpointsView = view = EndpointsToolWindowFactoryKt.getActiveEndpointsView($project);
            if (endpointsView == null) break block0;
            endpointsView.showEndpoints($module);
        }
    }
}

