/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.impl.DiffTitleWithDetailsCustomizers;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.vcsUtil.VcsUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffRequestProducer;", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "patch", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "<init>", "(Lcom/intellij/openapi/diff/impl/patch/FilePatch;)V", "getName", "", "Lorg/jetbrains/annotations/Nls;", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "process", "Lcom/intellij/diff/requests/DiffRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.vcs.impl"})
final class PatchDiffRequestProducer
implements ChangeDiffRequestChain.Producer {
    @NotNull
    private final FilePatch patch;

    public PatchDiffRequestProducer(@NotNull FilePatch patch) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        this.patch = patch;
    }

    @NotNull
    public String getName() {
        String string = this.patch.getAfterName();
        if (string == null && (string = this.patch.getBeforeName()) == null) {
            string = "patch";
        }
        return string;
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = VcsUtil.getFilePath((String)this.getName(), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return filePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        if (this.patch.getBeforeName() == null && this.patch.getAfterName() == null) {
            FileStatus fileStatus = FileStatus.MERGED_WITH_CONFLICTS;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"MERGED_WITH_CONFLICTS");
            return fileStatus;
        }
        if (this.patch.getBeforeName() == null) {
            FileStatus fileStatus = FileStatus.ADDED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"ADDED");
            return fileStatus;
        }
        if (this.patch.getAfterName() == null) {
            FileStatus fileStatus = FileStatus.DELETED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"DELETED");
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.MODIFIED;
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"MODIFIED");
        return fileStatus;
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (this.patch instanceof TextFilePatch) {
            PatchDiffRequest patchDiffRequest = new PatchDiffRequest((TextFilePatch)this.patch, null, ((TextFilePatch)this.patch).getBeforeName(), ((TextFilePatch)this.patch).getAfterName());
            DiffRequest diffRequest = DiffUtil.addTitleCustomizers((DiffRequest)patchDiffRequest, DiffTitleWithDetailsCustomizers.getTitleCustomizers(patchDiffRequest.getPatch().getBeforeName(), patchDiffRequest.getPatch().getAfterName()));
            Intrinsics.checkNotNullExpressionValue((Object)diffRequest, (String)"addTitleCustomizers(...)");
            return diffRequest;
        }
        if (this.patch instanceof BinaryFilePatch) {
            return (DiffRequest)new MessageDiffRequest(VcsBundle.message((String)"patch.is.binary.text", (Object[])new Object[0]));
        }
        throw new IllegalStateException("Unknown patch type: " + this.patch);
    }
}

