/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.reference;

import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.microservices.url.references.UrlPathReferenceInjector;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.StringEntry;
import com.intellij.swagger.core.reference.SwUrlReferenceProviderKt;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "SwYamlKeyUrlReferenceProvider", "SwYamlValueUrlReferenceProvider", "SwAbstractJsonUrlReferenceProvider", "SwJsonValueUrlReferenceProvider", "SwJsonKeyUrlReferenceProvider", "Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwAbstractJsonUrlReferenceProvider;", "Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwYamlKeyUrlReferenceProvider;", "Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwYamlValueUrlReferenceProvider;", "intellij.swagger.core"})
public abstract class SwUrlReferenceProvider
extends PsiReferenceProvider {
    private SwUrlReferenceProvider() {
    }

    public /* synthetic */ SwUrlReferenceProvider(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwAbstractJsonUrlReferenceProvider;", "Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider;", "buildAbsoluteUrl", "", "<init>", "(Z)V", "retrievalFun", "Lkotlin/Function1;", "Lcom/intellij/json/psi/JsonStringLiteral;", "Lcom/intellij/psi/util/PartiallyKnownString;", "getRetrievalFun", "()Lkotlin/jvm/functions/Function1;", "jsonInjector", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "getJsonInjector", "()Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.swagger.core"})
    public static abstract class SwAbstractJsonUrlReferenceProvider
    extends SwUrlReferenceProvider {
        private final boolean buildAbsoluteUrl;
        @NotNull
        private final Function1<JsonStringLiteral, PartiallyKnownString> retrievalFun;

        public SwAbstractJsonUrlReferenceProvider(boolean buildAbsoluteUrl) {
            super(null);
            this.buildAbsoluteUrl = buildAbsoluteUrl;
            this.retrievalFun = SwAbstractJsonUrlReferenceProvider::retrievalFun$lambda$0;
        }

        @NotNull
        protected final Function1<JsonStringLiteral, PartiallyKnownString> getRetrievalFun() {
            return this.retrievalFun;
        }

        @NotNull
        public abstract UrlPathReferenceInjector<JsonStringLiteral> getJsonInjector();

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiReference[] psiReferenceArray;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (element instanceof JsonStringLiteral) {
                psiReferenceArray = this.buildAbsoluteUrl ? this.getJsonInjector().buildFullUrlReference((Object)element, element) : this.getJsonInjector().buildReferences((Object)element).forPsiElement(element);
            } else {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
                Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            }
            return psiReferenceArray;
        }

        private static final PartiallyKnownString retrievalFun$lambda$0(JsonStringLiteral context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String string = context.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            PsiElement psiElement = (PsiElement)context;
            TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)context));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
            return new PartiallyKnownString(string, psiElement, textRange);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwJsonKeyUrlReferenceProvider;", "Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwAbstractJsonUrlReferenceProvider;", "<init>", "()V", "jsonInjector", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "Lcom/intellij/json/psi/JsonStringLiteral;", "getJsonInjector", "()Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "intellij.swagger.core"})
    public static final class SwJsonKeyUrlReferenceProvider
    extends SwAbstractJsonUrlReferenceProvider {
        @NotNull
        private final UrlPathReferenceInjector<JsonStringLiteral> jsonInjector = UrlPathReferenceInjector.Companion.forPartialStringFrom(this.getRetrievalFun()).withDefaultRootContextProviderFactory(SwUrlReferenceProviderKt.access$getBasePathAwareRootContextProviderFactory$p());

        public SwJsonKeyUrlReferenceProvider() {
            super(false);
        }

        @Override
        @NotNull
        public UrlPathReferenceInjector<JsonStringLiteral> getJsonInjector() {
            return this.jsonInjector;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwJsonValueUrlReferenceProvider;", "Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwAbstractJsonUrlReferenceProvider;", "buildAbsoluteUrl", "", "<init>", "(Z)V", "jsonInjector", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "Lcom/intellij/json/psi/JsonStringLiteral;", "getJsonInjector", "()Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "intellij.swagger.core"})
    public static final class SwJsonValueUrlReferenceProvider
    extends SwAbstractJsonUrlReferenceProvider {
        @NotNull
        private final UrlPathReferenceInjector<JsonStringLiteral> jsonInjector = UrlPathReferenceInjector.Companion.forPartialStringFrom(this.getRetrievalFun()).withDefaultRootContextProviderFactory(SwUrlReferenceProviderKt.access$getNoBasePathRootContextProviderFactory$p());

        public SwJsonValueUrlReferenceProvider(boolean buildAbsoluteUrl) {
            super(buildAbsoluteUrl);
        }

        @Override
        @NotNull
        public UrlPathReferenceInjector<JsonStringLiteral> getJsonInjector() {
            return this.jsonInjector;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwYamlKeyUrlReferenceProvider;", "Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider;", "<init>", "()V", "retrievalFun", "Lkotlin/Function1;", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "Lcom/intellij/psi/util/PartiallyKnownString;", "customHostAligner", "Lcom/intellij/psi/util/StringEntry;", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/TextRange;", "yamlInjector", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.swagger.core"})
    public static final class SwYamlKeyUrlReferenceProvider
    extends SwUrlReferenceProvider {
        @NotNull
        private final Function1<YAMLKeyValue, PartiallyKnownString> retrievalFun = SwYamlKeyUrlReferenceProvider::retrievalFun$lambda$0;
        @NotNull
        private final Function1<StringEntry, Pair<PsiElement, TextRange>> customHostAligner = SwYamlKeyUrlReferenceProvider::customHostAligner$lambda$1;
        @NotNull
        private final UrlPathReferenceInjector<YAMLKeyValue> yamlInjector = UrlPathReferenceInjector.Companion.forPartialStringFrom(this.retrievalFun).withDefaultRootContextProviderFactory(SwUrlReferenceProviderKt.access$getBasePathAwareRootContextProviderFactory$p()).withCustomHostAligner(this.customHostAligner);

        public SwYamlKeyUrlReferenceProvider() {
            super(null);
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiReference[] psiReferenceArray;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getKey() != null) {
                psiReferenceArray = this.yamlInjector.buildReferences((Object)element).forPsiElement(element);
            } else {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
                Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            }
            return psiReferenceArray;
        }

        private static final PartiallyKnownString retrievalFun$lambda$0(YAMLKeyValue context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PsiElement psiElement = context.getKey();
            if (psiElement == null) {
                return null;
            }
            PsiElement sourcePsi = psiElement;
            String string = context.getKeyText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyText(...)");
            TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)context));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
            return new PartiallyKnownString(string, sourcePsi, textRange);
        }

        private static final Pair customHostAligner$lambda$1(StringEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            PsiElement psiElement = entry.getSourcePsi();
            if (psiElement == null) {
                return null;
            }
            PsiElement sourcePsi = psiElement;
            PsiElement parent = sourcePsi.getParent();
            return parent instanceof ContributedReferenceHost ? TuplesKt.to((Object)parent, (Object)entry.getRange().shiftRight(sourcePsi.getStartOffsetInParent())) : null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider$SwYamlValueUrlReferenceProvider;", "Lcom/intellij/swagger/core/reference/SwUrlReferenceProvider;", "buildAbsoluteUrl", "", "<init>", "(Z)V", "retrievalFun", "Lkotlin/Function1;", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "Lcom/intellij/psi/util/PartiallyKnownString;", "yamlInjector", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.swagger.core"})
    public static final class SwYamlValueUrlReferenceProvider
    extends SwUrlReferenceProvider {
        private final boolean buildAbsoluteUrl;
        @NotNull
        private final Function1<YAMLScalar, PartiallyKnownString> retrievalFun;
        @NotNull
        private final UrlPathReferenceInjector<YAMLScalar> yamlInjector;

        public SwYamlValueUrlReferenceProvider(boolean buildAbsoluteUrl) {
            super(null);
            this.buildAbsoluteUrl = buildAbsoluteUrl;
            this.retrievalFun = SwYamlValueUrlReferenceProvider::retrievalFun$lambda$0;
            this.yamlInjector = UrlPathReferenceInjector.Companion.forPartialStringFrom(this.retrievalFun).withDefaultRootContextProviderFactory(SwUrlReferenceProviderKt.access$getNoBasePathRootContextProviderFactory$p());
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiReference[] psiReferenceArray;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (element instanceof YAMLScalar) {
                psiReferenceArray = this.buildAbsoluteUrl ? this.yamlInjector.buildFullUrlReference((Object)element, element) : this.yamlInjector.buildReferences((Object)element).forPsiElement(element);
            } else {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
                Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            }
            return psiReferenceArray;
        }

        private static final PartiallyKnownString retrievalFun$lambda$0(YAMLScalar context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String string = context.getTextValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
            PsiElement psiElement = (PsiElement)context;
            TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)context));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
            return new PartiallyKnownString(string, psiElement, textRange);
        }
    }
}

