/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdContextElement;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.backend.TerminalPortForwardingManager;
import com.intellij.terminal.backend.TerminalSessionPersistedTab;
import com.intellij.terminal.backend.TerminalSessionStartResult;
import com.intellij.terminal.backend.TerminalSessionsManager;
import com.intellij.terminal.backend.TerminalTabsManager;
import com.intellij.terminal.backend.TerminalTabsStorage;
import com.intellij.terminal.session.TerminalCloseEvent;
import com.intellij.terminal.session.TerminalOutputEvent;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalStateChangedEvent;
import com.intellij.util.CoroutinesKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.block.reworked.session.TerminalSessionTab;
import org.jetbrains.plugins.terminal.block.reworked.session.rpc.TerminalPortForwardingId;
import org.jetbrains.plugins.terminal.block.reworked.session.rpc.TerminalSessionId;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002JD\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2.\u0010&\u001a*\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0(\u0012\u0006\u0012\u0004\u0018\u00010\u00010'H\u0082@\u00a2\u0006\u0002\u0010)J\f\u0010*\u001a\u00020+*\u00020\u000bH\u0002J\f\u0010,\u001a\u00020\u000b*\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/terminal/backend/TerminalTabsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "tabsMap", "", "", "Lorg/jetbrains/plugins/terminal/block/reworked/session/TerminalSessionTab;", "tabsLock", "Lkotlinx/coroutines/sync/Mutex;", "tabIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getTerminalTabs", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createNewTerminalTab", "startTerminalSessionForTab", "tabId", "options", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "(ILorg/jetbrains/plugins/terminal/ShellStartupOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeTerminalTab", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renameTerminalTab", "newName", "", "isUserDefinedName", "", "(ILjava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trackWorkingDirectory", "tab", "updateTabsAndStore", "T", "action", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toPersistedTab", "Lcom/intellij/terminal/backend/TerminalSessionPersistedTab;", "toSessionTab", "Companion", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nTerminalTabsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTabsManager.kt\ncom/intellij/terminal/backend/TerminalTabsManager\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n116#2,10:201\n116#2,7:211\n124#2,2:222\n1557#3:218\n1628#3,3:219\n*S KotlinDebug\n*F\n+ 1 TerminalTabsManager.kt\ncom/intellij/terminal/backend/TerminalTabsManager\n*L\n38#1:201,10\n162#1:211,7\n162#1:222,2\n167#1:218\n167#1:219,3\n*E\n"})
public final class TerminalTabsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Map<Integer, TerminalSessionTab> tabsMap;
    @NotNull
    private final Mutex tabsLock;
    @NotNull
    private final AtomicInteger tabIdCounter;

    public TerminalTabsManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.tabsMap = new LinkedHashMap();
        this.tabsLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.tabIdCounter = new AtomicInteger(0);
        List<TerminalSessionPersistedTab> storedTabs = TerminalTabsStorage.Companion.getInstance(this.project).getStoredTabs();
        for (TerminalSessionPersistedTab tab : storedTabs) {
            TerminalSessionTab sessionTab = this.toSessionTab(tab);
            this.tabsMap.put(sessionTab.getId(), sessionTab);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object getTerminalTabs(@NotNull Continuation<? super List<TerminalSessionTab>> $completion) {
        if (!($completion instanceof getTerminalTabs.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalTabsManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getTerminalTabs((Continuation<? super List<TerminalSessionTab>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.tabsLock;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (TerminalTabsManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-TerminalTabsManager$getTerminalTabs$2 = false;
                    var6_11 = CollectionsKt.toList((Iterable)this.tabsMap.values());
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var6_11;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createNewTerminalTab(@NotNull Continuation<? super TerminalSessionTab> $completion) {
        if (!($completion instanceof createNewTerminalTab.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalTabsManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createNewTerminalTab((Continuation<? super TerminalSessionTab>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                newTab = new TerminalSessionTab(this.tabIdCounter.getAndIncrement(), null, false, null, null, null, null);
                $continuation.L$0 = newTab;
                $continuation.label = 1;
                v0 = this.updateTabsAndStore((Function2<? super Map<Integer, TerminalSessionTab>, ? super Continuation<? super T>, ? extends Object>)((Function2)new Function2<Map<Integer, TerminalSessionTab>, Continuation<? super Unit>, Object>(newTab, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ TerminalSessionTab $newTab;
                    {
                        this.$newTab = $newTab;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Map tabs = (Map)this.L$0;
                                tabs.put(Boxing.boxInt((int)this.$newTab.getId()), this.$newTab);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(Map<Integer, TerminalSessionTab> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super T>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                newTab = (TerminalSessionTab)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                return newTab;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object startTerminalSessionForTab(int tabId, @NotNull ShellStartupOptions options, @NotNull Continuation<? super TerminalSessionTab> $completion) {
        return this.updateTabsAndStore((Function2)new Function2<Map<Integer, TerminalSessionTab>, Continuation<? super TerminalSessionTab>, Object>(tabId, this, options, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ int $tabId;
            final /* synthetic */ TerminalTabsManager this$0;
            final /* synthetic */ ShellStartupOptions $options;
            {
                this.$tabId = $tabId;
                this.this$0 = $receiver;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        tabs = (Map)this.L$0;
                        v0 = (TerminalSessionTab)tabs.get(Boxing.boxInt((int)this.$tabId));
                        if (v0 == null) {
                            throw new IllegalStateException(("No TerminalSessionTab with ID: " + this.$tabId).toString());
                        }
                        tab = v0;
                        existingSessionId = tab.getSessionId();
                        if (existingSessionId != null) {
                            return tab;
                        }
                        clientId = ClientId.Companion.getLocalId();
                        scope = CoroutineScopeKt.childScope$default((CoroutineScope)TerminalTabsManager.access$getCoroutineScope$p(this.this$0), (String)("TerminalSession#" + this.$tabId), (CoroutineContext)((CoroutineContext)new ClientIdContextElement(clientId)), (boolean)false, (int)4, null);
                        this.L$0 = tabs;
                        this.L$1 = tab;
                        this.L$2 = scope;
                        this.label = 1;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)new ClientIdContextElement(clientId)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TerminalSessionStartResult>, Object>(this.$options, this.this$0, scope, null){
                            int label;
                            final /* synthetic */ ShellStartupOptions $options;
                            final /* synthetic */ TerminalTabsManager this$0;
                            final /* synthetic */ CoroutineScope $scope;
                            {
                                this.$options = $options;
                                this.this$0 = $receiver;
                                this.$scope = $scope;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        return TerminalSessionsManager.Companion.getInstance().startSession(this.$options, TerminalTabsManager.access$getProject$p(this.this$0), this.$scope);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super TerminalSessionStartResult> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl29
                    }
                    case 1: {
                        scope = (CoroutineScope)this.L$2;
                        tab = (TerminalSessionTab)this.L$1;
                        tabs = (Map)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        result = (TerminalSessionStartResult)v1;
                        this.L$0 = tabs;
                        this.L$1 = tab;
                        this.L$2 = scope;
                        this.L$3 = result;
                        this.label = 2;
                        v2 = TerminalPortForwardingManager.Companion.getInstance(TerminalTabsManager.access$getProject$p(this.this$0)).setupPortForwarding(result.getTtyConnector(), CoroutineScopeKt.childScope$default((CoroutineScope)scope, (String)"PortForwarding", null, (boolean)false, (int)6, null), (Continuation<? super TerminalPortForwardingId>)((Continuation)this));
                        if (v2 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl46
                    }
                    case 2: {
                        result = (TerminalSessionStartResult)this.L$3;
                        scope = (CoroutineScope)this.L$2;
                        tab = (TerminalSessionTab)this.L$1;
                        tabs = (Map)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl46:
                        // 2 sources

                        portForwardingId = (TerminalPortForwardingId)v2;
                        updatedTab = TerminalSessionTab.copy$default(tab, 0, null, false, result.getConfiguredOptions().getShellCommand(), result.getConfiguredOptions().getWorkingDirectory(), result.getSessionId(), portForwardingId, 7, null);
                        tabs.put(Boxing.boxInt((int)this.$tabId), updatedTab);
                        TerminalTabsManager.access$trackWorkingDirectory(this.this$0, updatedTab, CoroutineScopeKt.childScope$default((CoroutineScope)scope, (String)"Working directory tracking", null, (boolean)false, (int)6, null));
                        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)scope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$tabId, null){
                            int label;
                            final /* synthetic */ TerminalTabsManager this$0;
                            final /* synthetic */ int $tabId;
                            {
                                this.this$0 = $receiver;
                                this.$tabId = $tabId;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = TerminalTabsManager.access$updateTabsAndStore(this.this$0, (Function2)new Function2<Map<Integer, TerminalSessionTab>, Continuation<? super Unit>, Object>(this.$tabId, null){
                                            int label;
                                            /* synthetic */ Object L$0;
                                            final /* synthetic */ int $tabId;
                                            {
                                                this.$tabId = $tabId;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        Map tabs = (Map)this.L$0;
                                                        tabs.remove(Boxing.boxInt((int)this.$tabId));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                var3_3.L$0 = value;
                                                return (Continuation)var3_3;
                                            }

                                            public final Object invoke(Map<Integer, TerminalSessionTab> p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        return updatedTab;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Map<Integer, TerminalSessionTab> p1, Continuation<? super TerminalSessionTab> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object closeTerminalTab(int tabId, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.updateTabsAndStore((Function2)new Function2<Map<Integer, TerminalSessionTab>, Continuation<? super Unit>, Object>(tabId, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ int $tabId;
            {
                this.$tabId = $tabId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block9: {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            tabs = (Map)this.L$0;
                            v0 = (TerminalSessionTab)tabs.get(Boxing.boxInt((int)this.$tabId));
                            if (v0 == null) {
                                return Unit.INSTANCE;
                            }
                            tab = v0;
                            sessionId = tab.getSessionId();
                            if (sessionId == null) break;
                            session = TerminalSessionsManager.Companion.getInstance().getSession(sessionId);
                            if (session == null) {
                                return Unit.INSTANCE;
                            }
                            this.label = 1;
                            v1 = session.getInputChannel((Continuation)this);
                            if (v1 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl23
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            this.label = 2;
                            v2 = ((SendChannel)v1).send((Object)new TerminalCloseEvent(), (Continuation)this);
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            break block9;
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            break block9;
                        }
                    }
                    tabs.remove(Boxing.boxInt((int)this.$tabId));
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Map<Integer, TerminalSessionTab> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object renameTerminalTab(int tabId, @NotNull String newName, boolean isUserDefinedName, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.updateTabsAndStore((Function2)new Function2<Map<Integer, TerminalSessionTab>, Continuation<? super Unit>, Object>(tabId, newName, isUserDefinedName, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ int $tabId;
            final /* synthetic */ String $newName;
            final /* synthetic */ boolean $isUserDefinedName;
            {
                this.$tabId = $tabId;
                this.$newName = $newName;
                this.$isUserDefinedName = $isUserDefinedName;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Map tabs = (Map)this.L$0;
                        TerminalSessionTab terminalSessionTab = (TerminalSessionTab)tabs.get(Boxing.boxInt((int)this.$tabId));
                        if (terminalSessionTab == null) {
                            return Unit.INSTANCE;
                        }
                        TerminalSessionTab tab = terminalSessionTab;
                        TerminalSessionTab updatedTab = TerminalSessionTab.copy$default(tab, 0, this.$newName, this.$isUserDefinedName, null, null, null, null, 121, null);
                        tabs.put(Boxing.boxInt((int)this.$tabId), updatedTab);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Map<Integer, TerminalSessionTab> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void trackWorkingDirectory(TerminalSessionTab tab, CoroutineScope coroutineScope) {
        TerminalSessionId terminalSessionId = tab.getSessionId();
        if (terminalSessionId == null) {
            throw new IllegalStateException(("This method should be called only for tabs with started sessions: " + tab).toString());
        }
        TerminalSessionId sessionId = terminalSessionId;
        TerminalSession terminalSession = TerminalSessionsManager.Companion.getInstance().getSession(sessionId);
        if (terminalSession == null) {
            throw new IllegalStateException(("No session for tab " + tab).toString());
        }
        TerminalSession session2 = terminalSession;
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session2, tab, this, null){
            int label;
            final /* synthetic */ TerminalSession $session;
            final /* synthetic */ TerminalSessionTab $tab;
            final /* synthetic */ TerminalTabsManager this$0;
            {
                this.$session = $session;
                this.$tab = $tab;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$session.getOutputFlow((Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        outputFlow = (Flow)v0;
                        currentDirectory = new Ref.ObjectRef();
                        currentDirectory.element = this.$tab.getWorkingDirectory();
                        this.label = 2;
                        v1 = outputFlow.collect(new FlowCollector((Ref.ObjectRef<String>)currentDirectory, this.this$0, this.$tab){
                            final /* synthetic */ Ref.ObjectRef<String> $currentDirectory;
                            final /* synthetic */ TerminalTabsManager this$0;
                            final /* synthetic */ TerminalSessionTab $tab;
                            {
                                this.$currentDirectory = $currentDirectory;
                                this.this$0 = $receiver;
                                this.$tab = $tab;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object emit(List<? extends TerminalOutputEvent> var1_1, Continuation<? super Unit> $completion) {
                                if (!($completion instanceof trackWorkingDirectory.emit.1)) ** GOTO lbl-1000
                                var6_3 = $completion;
                                if ((var6_3.label & -2147483648) != 0) {
                                    var6_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, $completion){
                                        Object L$0;
                                        Object L$1;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ trackWorkingDirectory.1<T> this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var3_6 = events.iterator();
lbl13:
                                        // 4 sources

                                        while (var3_6.hasNext()) {
                                            event = (TerminalOutputEvent)var3_6.next();
                                            if (!(event instanceof TerminalStateChangedEvent) || Intrinsics.areEqual((Object)((TerminalStateChangedEvent)event).getState().getCurrentDirectory(), (Object)this.$currentDirectory.element)) continue;
                                            this.$currentDirectory.element = ((TerminalStateChangedEvent)event).getState().getCurrentDirectory();
                                            $continuation.L$0 = this;
                                            $continuation.L$1 = var3_6;
                                            $continuation.label = 1;
                                            v0 = TerminalTabsManager.access$updateTabsAndStore(this.this$0, (Function2)new Function2<Map<Integer, TerminalSessionTab>, Continuation<? super Unit>, Object>(this.$tab, this.$currentDirectory, null){
                                                int label;
                                                /* synthetic */ Object L$0;
                                                final /* synthetic */ TerminalSessionTab $tab;
                                                final /* synthetic */ Ref.ObjectRef<String> $currentDirectory;
                                                {
                                                    this.$tab = $tab;
                                                    this.$currentDirectory = $currentDirectory;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object object) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)object);
                                                            Map tabs = (Map)this.L$0;
                                                            TerminalSessionTab terminalSessionTab = (TerminalSessionTab)tabs.get(Boxing.boxInt((int)this.$tab.getId()));
                                                            if (terminalSessionTab == null || (terminalSessionTab = TerminalSessionTab.copy$default(terminalSessionTab, 0, null, false, null, (String)this.$currentDirectory.element, null, null, 111, null)) == null) {
                                                                return Unit.INSTANCE;
                                                            }
                                                            TerminalSessionTab updatedTab = terminalSessionTab;
                                                            tabs.put(Boxing.boxInt((int)this.$tab.getId()), updatedTab);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                    var3_3.L$0 = value;
                                                    return (Continuation)var3_3;
                                                }

                                                public final Object invoke(Map<Integer, TerminalSessionTab> p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }, (Continuation)$continuation);
                                            if (v0 != var7_5) continue;
                                            return var7_5;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        var3_6 = (Iterator<E>)$continuation.L$1;
                                        this = $continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl13
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final <T> Object updateTabsAndStore(Function2<? super Map<Integer, TerminalSessionTab>, ? super Continuation<? super T>, ? extends Object> var1_1, Continuation<? super T> $completion) {
        if (!($completion instanceof updateTabsAndStore.1)) ** GOTO lbl-1000
        var23_3 = $completion;
        if ((var23_3.label & -2147483648) != 0) {
            var23_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalTabsManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalTabsManager.access$updateTabsAndStore(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.tabsLock;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = action;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, $continuation);
                if (v0 == var24_5) {
                    return var24_5;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                action = (Function2)$continuation.L$1;
                this = (TerminalTabsManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 3 sources

                $i$a$-withLock$default-TerminalTabsManager$updateTabsAndStore$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = action.invoke(this.tabsMap, $continuation);
                ** if (v1 != var24_5) goto lbl44
lbl43:
                // 1 sources

                return var24_5;
lbl44:
                // 1 sources

                ** GOTO lbl56
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-TerminalTabsManager$updateTabsAndStore$2 = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (TerminalTabsManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl56:
                    // 2 sources

                    var7_10 = v1;
                    $this$map$iv = this.tabsMap.values();
                    $i$f$map = false;
                    var10_15 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var15_25 = (TerminalSessionTab)item$iv$iv;
                        var16_27 = destination$iv$iv;
                        $i$a$-map-TerminalTabsManager$updateTabsAndStore$2$persistedTabs$1 = false;
                        var16_27.add(this.toPersistedTab((TerminalSessionTab)it));
                    }
                    ** GOTO lbl86
                    {
                        catch (Throwable var18_32) {
                            $this$map$iv = this.tabsMap.values();
                            $i$f$map = false;
                            destination$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                $i$a$-map-TerminalTabsManager$updateTabsAndStore$2$persistedTabs$1 = (TerminalSessionTab)item$iv$iv;
                                var16_28 = destination$iv$iv;
                                $i$a$-map-TerminalTabsManager$updateTabsAndStore$2$persistedTabs$1 = false;
                                var16_28.add(this.toPersistedTab((TerminalSessionTab)it));
                            }
                            persistedTabs = (List)destination$iv$iv;
                            TerminalTabsStorage.Companion.getInstance(this.project).updateStoredTabs(persistedTabs);
                            throw var18_32;
                        }
                    }
lbl86:
                    // 1 sources

                    persistedTabs = (List)destination$iv$iv;
                    TerminalTabsStorage.Companion.getInstance(this.project).updateStoredTabs(persistedTabs);
                    var20_34 = var7_10;
                }
                catch (Throwable var21_35) {
                    throw var21_35;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var20_34;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final TerminalSessionPersistedTab toPersistedTab(TerminalSessionTab $this$toPersistedTab) {
        return new TerminalSessionPersistedTab($this$toPersistedTab.getName(), $this$toPersistedTab.isUserDefinedName(), $this$toPersistedTab.getShellCommand(), $this$toPersistedTab.getWorkingDirectory());
    }

    private final TerminalSessionTab toSessionTab(TerminalSessionPersistedTab $this$toSessionTab) {
        return new TerminalSessionTab(this.tabIdCounter.getAndIncrement(), $this$toSessionTab.getName(), $this$toSessionTab.isUserDefinedName(), $this$toSessionTab.getShellCommand(), $this$toSessionTab.getWorkingDirectory(), null, null);
    }

    @JvmStatic
    @NotNull
    public static final TerminalTabsManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(TerminalTabsManager $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ Project access$getProject$p(TerminalTabsManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$trackWorkingDirectory(TerminalTabsManager $this, TerminalSessionTab tab, CoroutineScope coroutineScope) {
        $this.trackWorkingDirectory(tab, coroutineScope);
    }

    public static final /* synthetic */ Object access$updateTabsAndStore(TerminalTabsManager $this, Function2 action, Continuation $completion) {
        return $this.updateTabsAndStore(action, $completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/terminal/backend/TerminalTabsManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/terminal/backend/TerminalTabsManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.terminal.backend"})
    @SourceDebugExtension(value={"SMAP\nTerminalTabsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTabsManager.kt\ncom/intellij/terminal/backend/TerminalTabsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,200:1\n31#2,2:201\n*S KotlinDebug\n*F\n+ 1 TerminalTabsManager.kt\ncom/intellij/terminal/backend/TerminalTabsManager$Companion\n*L\n197#1:201,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalTabsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TerminalTabsManager> serviceClass$iv = TerminalTabsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TerminalTabsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

