/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 j2\u00020\u0001:\u0004ghijB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tJ\u0016\u0010?\u001a\u00020@2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tJ\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\tJ\u001e\u0010D\u001a\u00020<2\u0006\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020HJ\u001e\u0010I\u001a\u00020<2\u0006\u0010J\u001a\u00020\t2\u0006\u0010K\u001a\u00020\t2\u0006\u0010G\u001a\u00020HJ\u001a\u0010L\u001a\u00020.2\b\b\u0002\u0010M\u001a\u00020\t2\b\b\u0002\u0010N\u001a\u00020\tJ(\u0010O\u001a\u00020.2\u0006\u0010P\u001a\u00020\t2\u0006\u0010Q\u001a\u00020\t2\u0006\u0010M\u001a\u00020\t2\u0006\u0010N\u001a\u00020\tH\u0002J\u0006\u0010R\u001a\u00020<J\u0006\u0010S\u001a\u00020<J%\u0010T\u001a\u0002HU\"\u0004\b\u0000\u0010U2\f\u0010V\u001a\b\u0012\u0004\u0012\u0002HU0WH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010XJ\u0016\u0010`\u001a\u00020<2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dJ\u001a\u0010e\u001a\u00020<2\u0006\u0010a\u001a\u00020[2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010dJ\u001a\u0010f\u001a\u00020<2\u0006\u0010a\u001a\u00020_2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010dR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0015\"\u0004\b\u001f\u0010\u0017R$\u0010 \u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\u0017R$\u0010#\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010)\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010/\u001a\u00020.2\u0006\u0010\u000e\u001a\u00020.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R$\u00104\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0015\"\u0004\b6\u0010\u0017R\u0011\u00107\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u000bR\u0011\u00109\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u000bR\u001a\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010]R\u0014\u0010^\u001a\b\u0012\u0004\u0012\u00020_0ZX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006k"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;)V", "getTextBuffer$intellij_terminal", "()Lcom/jediterm/terminal/model/TerminalTextBuffer;", "width", "", "getWidth", "()I", "height", "getHeight", "value", "cursorX", "getCursorX", "cursorY", "getCursorY", "", "isCommandRunning", "()Z", "setCommandRunning", "(Z)V", "Lcom/jediterm/terminal/CursorShape;", "cursorShape", "getCursorShape", "()Lcom/jediterm/terminal/CursorShape;", "setCursorShape", "(Lcom/jediterm/terminal/CursorShape;)V", "isCursorVisible", "setCursorVisible", "isBracketedPasteMode", "setBracketedPasteMode", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "mouseMode", "getMouseMode", "()Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "setMouseMode", "(Lcom/jediterm/terminal/emulator/mouse/MouseMode;)V", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "mouseFormat", "getMouseFormat", "()Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "setMouseFormat", "(Lcom/jediterm/terminal/emulator/mouse/MouseFormat;)V", "", "windowTitle", "getWindowTitle", "()Ljava/lang/String;", "setWindowTitle", "(Ljava/lang/String;)V", "useAlternateBuffer", "getUseAlternateBuffer", "setUseAlternateBuffer", "historyLinesCount", "getHistoryLinesCount", "screenLinesCount", "getScreenLinesCount", "setCursor", "", "x", "y", "charAt", "", "getLine", "Lcom/jediterm/terminal/model/TerminalLine;", "index", "processHistoryAndScreenLines", "scrollOrigin", "maxLinesToProcess", "consumer", "Lcom/jediterm/terminal/StyledTextConsumer;", "processScreenLines", "yStart", "count", "getAllText", "updatedCursorX", "updatedCursorY", "getLinesText", "fromLine", "toLine", "lockContent", "unlockContent", "withContentLock", "T", "callable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "terminalListeners", "", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$TerminalListener;", "getTerminalListeners$intellij_terminal", "()Ljava/util/List;", "cursorListeners", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$CursorListener;", "addContentListener", "listener", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$ContentListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addTerminalListener", "addCursorListener", "ContentListener", "TerminalListener", "CursorListener", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1863#2,2:235\n1863#2,2:237\n1863#2,2:239\n1863#2,2:241\n1863#2,2:243\n1863#2,2:245\n1863#2,2:247\n1863#2,2:249\n1863#2,2:251\n*S KotlinDebug\n*F\n+ 1 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n*L\n41#1:235,2\n50#1:237,2\n58#1:239,2\n66#1:241,2\n74#1:243,2\n82#1:245,2\n90#1:247,2\n98#1:249,2\n112#1:251,2\n*E\n"})
public final class TerminalModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalTextBuffer textBuffer;
    private volatile int cursorX;
    private volatile int cursorY;
    private boolean isCommandRunning;
    @Nullable
    private volatile CursorShape cursorShape;
    private boolean isCursorVisible;
    private boolean isBracketedPasteMode;
    @NotNull
    private MouseMode mouseMode;
    @NotNull
    private MouseFormat mouseFormat;
    @NotNull
    private String windowTitle;
    private boolean useAlternateBuffer;
    @NotNull
    private final List<TerminalListener> terminalListeners;
    @NotNull
    private final List<CursorListener> cursorListeners;
    public static final int MIN_WIDTH = 5;
    public static final int MIN_HEIGHT = 2;

    public TerminalModel(@NotNull TerminalTextBuffer textBuffer) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        this.textBuffer = textBuffer;
        this.isCursorVisible = true;
        this.mouseMode = MouseMode.MOUSE_REPORTING_NONE;
        this.mouseFormat = MouseFormat.MOUSE_FORMAT_XTERM;
        this.windowTitle = "Terminal";
        this.useAlternateBuffer = this.textBuffer.isUsingAlternateBuffer();
        this.terminalListeners = new CopyOnWriteArrayList();
        this.cursorListeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public final TerminalTextBuffer getTextBuffer$intellij_terminal() {
        return this.textBuffer;
    }

    public final int getWidth() {
        return this.textBuffer.getWidth();
    }

    public final int getHeight() {
        return this.textBuffer.getHeight();
    }

    public final int getCursorX() {
        return this.cursorX;
    }

    public final int getCursorY() {
        return this.cursorY;
    }

    public final boolean isCommandRunning() {
        return this.isCommandRunning;
    }

    public final void setCommandRunning(boolean value) {
        if (value != this.isCommandRunning) {
            this.isCommandRunning = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onCommandRunningChanged(value);
            }
        }
    }

    @Nullable
    public final CursorShape getCursorShape() {
        return this.cursorShape;
    }

    public final void setCursorShape(@Nullable CursorShape value) {
        if (value != this.cursorShape) {
            this.cursorShape = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onShapeChanged(value);
            }
        }
    }

    public final boolean isCursorVisible() {
        return this.isCursorVisible;
    }

    public final void setCursorVisible(boolean value) {
        if (value != this.isCursorVisible) {
            this.isCursorVisible = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onVisibilityChanged(value);
            }
        }
    }

    public final boolean isBracketedPasteMode() {
        return this.isBracketedPasteMode;
    }

    public final void setBracketedPasteMode(boolean value) {
        if (value != this.isBracketedPasteMode) {
            this.isBracketedPasteMode = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onBracketedPasteModeChanged(value);
            }
        }
    }

    @NotNull
    public final MouseMode getMouseMode() {
        return this.mouseMode;
    }

    public final void setMouseMode(@NotNull MouseMode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value != this.mouseMode) {
            this.mouseMode = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onMouseModeChanged(value);
            }
        }
    }

    @NotNull
    public final MouseFormat getMouseFormat() {
        return this.mouseFormat;
    }

    public final void setMouseFormat(@NotNull MouseFormat value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value != this.mouseFormat) {
            this.mouseFormat = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onMouseFormatChanged(value);
            }
        }
    }

    @NotNull
    public final String getWindowTitle() {
        return this.windowTitle;
    }

    public final void setWindowTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)value, (Object)this.windowTitle)) {
            this.windowTitle = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onWindowTitleChanged(value);
            }
        }
    }

    public final boolean getUseAlternateBuffer() {
        return this.useAlternateBuffer;
    }

    public final void setUseAlternateBuffer(boolean value) {
        if (this.useAlternateBuffer != value) {
            this.useAlternateBuffer = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onAlternateBufferChanged(value);
            }
        }
    }

    public final int getHistoryLinesCount() {
        return this.textBuffer.getHistoryLinesCount();
    }

    public final int getScreenLinesCount() {
        return this.textBuffer.getScreenLinesCount();
    }

    public final void setCursor(int x, int y) {
        if (x != this.cursorX || y != this.cursorY) {
            this.cursorX = x;
            this.cursorY = y;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onPositionChanged(x, y);
            }
        }
    }

    public final char charAt(int x, int y) {
        return this.textBuffer.getCharAt(x, y);
    }

    @NotNull
    public final TerminalLine getLine(int index) {
        return this.textBuffer.getLine(index);
    }

    public final void processHistoryAndScreenLines(int scrollOrigin, int maxLinesToProcess, @NotNull StyledTextConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        this.textBuffer.processHistoryAndScreenLines(scrollOrigin, maxLinesToProcess, consumer2);
    }

    public final void processScreenLines(int yStart, int count, @NotNull StyledTextConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        this.textBuffer.processScreenLines(yStart, count, consumer2);
    }

    @NotNull
    public final String getAllText(int updatedCursorX, int updatedCursorY) {
        return this.getLinesText(-this.getHistoryLinesCount(), this.getScreenLinesCount(), updatedCursorX, updatedCursorY);
    }

    public static /* synthetic */ String getAllText$default(TerminalModel terminalModel, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = terminalModel.cursorX;
        }
        if ((n3 & 2) != 0) {
            n2 = terminalModel.cursorY;
        }
        return terminalModel.getAllText(n, n2);
    }

    private final String getLinesText(int fromLine, int toLine, int updatedCursorX, int updatedCursorY) {
        String string;
        StringBuilder builder = new StringBuilder();
        for (int ind = fromLine; ind < toLine; ++ind) {
            String text;
            Intrinsics.checkNotNullExpressionValue((Object)this.getLine(ind).getText(), (String)"getText(...)");
            if (ind == updatedCursorY - 1) {
                String string2 = text.substring(0, Math.min(updatedCursorX, text.length()));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                text = string2;
            }
            builder.append(text);
            if (!(((CharSequence)text).length() > 0)) continue;
            builder.append('\n');
        }
        if (((CharSequence)builder).length() > 0) {
            string = ((Object)StringsKt.dropLast((CharSequence)builder, (int)1)).toString();
        } else {
            String string3 = builder.toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        }
        return string;
    }

    public final void lockContent() {
        this.textBuffer.lock();
    }

    public final void unlockContent() {
        this.textBuffer.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withContentLock(@NotNull Function0<? extends T> callable) {
        Object object;
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        boolean $i$f$withContentLock = false;
        this.lockContent();
        try {
            object = callable.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.unlockContent();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    @NotNull
    public final List<TerminalListener> getTerminalListeners$intellij_terminal() {
        return this.terminalListeners;
    }

    public final void addContentListener(@NotNull ContentListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtilKt.addModelListener(this.textBuffer, parentDisposable, () -> TerminalModel.addContentListener$lambda$9(listener2));
    }

    public final void addTerminalListener(@NotNull TerminalListener listener2, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.terminalListeners.add(listener2);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> TerminalModel.addTerminalListener$lambda$10(this, listener2));
        }
    }

    public static /* synthetic */ void addTerminalListener$default(TerminalModel terminalModel, TerminalListener terminalListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalModel.addTerminalListener(terminalListener, disposable);
    }

    public final void addCursorListener(@NotNull CursorListener listener2, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.cursorListeners.add(listener2);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> TerminalModel.addCursorListener$lambda$11(this, listener2));
        }
    }

    public static /* synthetic */ void addCursorListener$default(TerminalModel terminalModel, CursorListener cursorListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalModel.addCursorListener(cursorListener, disposable);
    }

    private static final void addContentListener$lambda$9(ContentListener $listener) {
        $listener.onContentChanged();
    }

    private static final void addTerminalListener$lambda$10(TerminalModel this$0, TerminalListener $listener) {
        this$0.terminalListeners.remove($listener);
    }

    private static final void addCursorListener$lambda$11(TerminalModel this$0, CursorListener $listener) {
        this$0.cursorListeners.remove($listener);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$Companion;", "", "<init>", "()V", "MIN_WIDTH", "", "MIN_HEIGHT", "clearAllAndMoveCursorToTopLeftCorner", "", "terminal", "Lcom/jediterm/terminal/Terminal;", "clearAllAndMoveCursorToTopLeftCorner$intellij_terminal", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final void clearAllAndMoveCursorToTopLeftCorner$intellij_terminal(@NotNull Terminal terminal) {
            Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
            terminal.eraseInDisplay(3);
            terminal.cursorPosition(1, 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$ContentListener;", "", "onContentChanged", "", "intellij.terminal"})
    public static interface ContentListener {
        default public void onContentChanged() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0012\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$CursorListener;", "", "onPositionChanged", "", "cursorX", "", "cursorY", "onShapeChanged", "shape", "Lcom/jediterm/terminal/CursorShape;", "onVisibilityChanged", "visible", "", "onMouseModeChanged", "mode", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "onMouseFormatChanged", "format", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "intellij.terminal"})
    public static interface CursorListener {
        default public void onPositionChanged(int cursorX, int cursorY) {
        }

        default public void onShapeChanged(@Nullable CursorShape shape) {
        }

        default public void onVisibilityChanged(boolean visible) {
        }

        default public void onMouseModeChanged(@NotNull MouseMode mode) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        }

        default public void onMouseFormatChanged(@NotNull MouseFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\fH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$TerminalListener;", "", "onSizeChanged", "", "width", "", "height", "onWindowTitleChanged", "title", "", "onCommandRunningChanged", "isRunning", "", "onAlternateBufferChanged", "enabled", "onBracketedPasteModeChanged", "bracketed", "intellij.terminal"})
    public static interface TerminalListener {
        default public void onSizeChanged(int width, int height) {
        }

        default public void onWindowTitleChanged(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        }

        default public void onCommandRunningChanged(boolean isRunning) {
        }

        default public void onAlternateBufferChanged(boolean enabled) {
        }

        default public void onBracketedPasteModeChanged(boolean bracketed) {
        }
    }
}

