/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.common.collect.ConcurrentHashMultiset;
import com.intellij.javascript.nodejs.packageJson.InstalledDependenciesChangeListener;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateListener;
import com.intellij.javascript.nodejs.packageJson.UpdateDependenciesActionListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0001J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\u001a\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\bJ\u0012\u0010\"\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0012\u0010#\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\bJ\u001c\u0010'\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020)H\u0007J\b\u0010*\u001a\u00020\u0015H\u0002J\b\u0010+\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&\u00a8\u0006."}, d2={"Lcom/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "runningUpdateActionCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "runningNamedUpdateActions", "Lcom/google/common/collect/ConcurrentHashMultiset;", "", "updateActionListeners", "", "Lcom/intellij/javascript/nodejs/packageJson/UpdateDependenciesActionListener;", "installedDependenciesChangeListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/intellij/javascript/nodejs/packageJson/InstalledDependenciesChangeListener;", "installedDependenciesChangeListenerCount", "installedDependenciesVfsListenerRef", "Ljava/util/concurrent/atomic/AtomicReference;", "installedDependencyChangedAlarm", "Lcom/intellij/util/Alarm;", "addUpdateActionListener", "", "listener", "removeUpdateActionListener", "addInstalledDependenciesChangeListener", "disposable", "addVfsListenerIfNeeded", "removeVfsListener", "dispose", "updateActionStarted", "Ljava/lang/Runnable;", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "taskName", "fireOnUpdateActionStarted", "fireOnUpdateActionFinished", "isUpdateActionRunning", "", "()Z", "externalUpdateStarted", "addListener", "Lcom/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateListener;", "onInstalledDependencyChanged", "fireInstalledDependencyChanged", "Companion", "InstalledDependenciesVfsListener", "intellij.javascript.impl"})
public final class PackageJsonDependenciesExternalUpdateManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger runningUpdateActionCount = new AtomicInteger(0);
    @NotNull
    private final ConcurrentHashMultiset<String> runningNamedUpdateActions;
    @NotNull
    private final List<UpdateDependenciesActionListener> updateActionListeners;
    @NotNull
    private final DisposableWrapperList<InstalledDependenciesChangeListener> installedDependenciesChangeListeners;
    @NotNull
    private final AtomicInteger installedDependenciesChangeListenerCount;
    @NotNull
    private final AtomicReference<Disposable> installedDependenciesVfsListenerRef;
    @NotNull
    private final Alarm installedDependencyChangedAlarm;

    public PackageJsonDependenciesExternalUpdateManager() {
        ConcurrentHashMultiset concurrentHashMultiset = ConcurrentHashMultiset.create();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentHashMultiset, (String)"create(...)");
        this.runningNamedUpdateActions = concurrentHashMultiset;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.updateActionListeners = list;
        this.installedDependenciesChangeListeners = new DisposableWrapperList();
        this.installedDependenciesChangeListenerCount = new AtomicInteger(0);
        this.installedDependenciesVfsListenerRef = new AtomicReference();
        this.installedDependencyChangedAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public final void addUpdateActionListener(@NotNull UpdateDependenciesActionListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.updateActionListeners.add(listener2);
    }

    public final void removeUpdateActionListener(@NotNull UpdateDependenciesActionListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.updateActionListeners.remove(listener2);
    }

    public final void addInstalledDependenciesChangeListener(@NotNull InstalledDependenciesChangeListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.installedDependenciesChangeListeners.add((Object)listener2, disposable);
        this.installedDependenciesChangeListenerCount.incrementAndGet();
        this.addVfsListenerIfNeeded();
        Disposer.register((Disposable)disposable, () -> PackageJsonDependenciesExternalUpdateManager.addInstalledDependenciesChangeListener$lambda$0(this));
    }

    private final void addVfsListenerIfNeeded() {
        InstalledDependenciesVfsListener listener2;
        if (this.installedDependenciesChangeListenerCount.get() > 0 && this.installedDependenciesVfsListenerRef.compareAndSet(null, listener2 = new InstalledDependenciesVfsListener())) {
            VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)listener2, (Disposable)listener2);
        }
    }

    private final void removeVfsListener() {
        block0: {
            Disposable disposable = this.installedDependenciesVfsListenerRef.getAndSet(null);
            if (disposable == null) break block0;
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
    }

    public void dispose() {
        this.removeVfsListener();
    }

    @NotNull
    public final Runnable updateActionStarted(@Nullable VirtualFile packageJson, @Nullable String taskName) {
        this.runningUpdateActionCount.incrementAndGet();
        if (taskName != null) {
            this.runningNamedUpdateActions.add((Object)taskName);
        }
        this.fireOnUpdateActionStarted(packageJson);
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        Runnable runnable = ConcurrencyUtil.once(() -> PackageJsonDependenciesExternalUpdateManager.updateActionStarted$lambda$2(this, taskName, alarm, packageJson));
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"once(...)");
        Runnable done = runnable;
        alarm.addRequest(done, TimeUnit.MINUTES.toMillis(5L));
        return done;
    }

    private final void fireOnUpdateActionStarted(VirtualFile packageJson) {
        for (UpdateDependenciesActionListener listener2 : this.updateActionListeners) {
            listener2.updateActionStarted(packageJson);
        }
    }

    private final void fireOnUpdateActionFinished(VirtualFile packageJson) {
        for (UpdateDependenciesActionListener listener2 : this.updateActionListeners) {
            listener2.updateActionFinished(packageJson);
        }
    }

    public final boolean isUpdateActionRunning() {
        return this.runningUpdateActionCount.get() > 0;
    }

    public final boolean isUpdateActionRunning(@NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        return this.runningNamedUpdateActions.contains((Object)taskName);
    }

    @Deprecated(message="Use `updateActionStarted` instead", replaceWith=@ReplaceWith(expression="updateActionStarted(packageJson, taskName)", imports={}))
    @NotNull
    public final Runnable externalUpdateStarted(@Nullable VirtualFile packageJson, @Nullable String taskName) {
        return this.updateActionStarted(packageJson, taskName);
    }

    @Deprecated(message="Use `updateActionStarted` instead", replaceWith=@ReplaceWith(expression="updateActionStarted(packageJson, taskName)", imports={}))
    public final void addListener(@NotNull PackageJsonDependenciesExternalUpdateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.updateActionListeners.add(new UpdateDependenciesActionListener(listener2){
            final /* synthetic */ PackageJsonDependenciesExternalUpdateListener $listener;
            {
                this.$listener = $listener;
            }

            public void updateActionStarted(VirtualFile packageJson) {
                this.$listener.externalUpdateStarted(packageJson);
            }

            public void updateActionFinished(VirtualFile packageJson) {
                this.$listener.externalUpdateFinished(packageJson);
            }
        });
    }

    private final void onInstalledDependencyChanged() {
        this.installedDependencyChangedAlarm.cancelAllRequests();
        this.installedDependencyChangedAlarm.addRequest(() -> PackageJsonDependenciesExternalUpdateManager.onInstalledDependencyChanged$lambda$3(this), 1000);
    }

    private final void fireInstalledDependencyChanged() {
        Iterator iterator = this.installedDependenciesChangeListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            InstalledDependenciesChangeListener listener2 = (InstalledDependenciesChangeListener)iterator2.next();
            listener2.installedDependenciesChanged();
        }
    }

    private static final void addInstalledDependenciesChangeListener$lambda$0(PackageJsonDependenciesExternalUpdateManager this$0) {
        if (this$0.installedDependenciesChangeListenerCount.decrementAndGet() == 0) {
            this$0.removeVfsListener();
            this$0.addVfsListenerIfNeeded();
        }
    }

    private static final void updateActionStarted$lambda$2(PackageJsonDependenciesExternalUpdateManager this$0, String $taskName, Alarm $alarm, VirtualFile $packageJson) {
        this$0.runningUpdateActionCount.decrementAndGet();
        if ($taskName != null) {
            this$0.runningNamedUpdateActions.remove((Object)$taskName);
        }
        Disposer.dispose((Disposable)((Disposable)$alarm));
        this$0.fireOnUpdateActionFinished($packageJson);
    }

    private static final void onInstalledDependencyChanged$lambda$3(PackageJsonDependenciesExternalUpdateManager this$0) {
        this$0.fireInstalledDependencyChanged();
    }

    @JvmStatic
    @NotNull
    public static final PackageJsonDependenciesExternalUpdateManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nPackageJsonDependenciesExternalUpdateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonDependenciesExternalUpdateManager.kt\ncom/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,199:1\n31#2,2:200\n*S KotlinDebug\n*F\n+ 1 PackageJsonDependenciesExternalUpdateManager.kt\ncom/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager$Companion\n*L\n150#1:200,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PackageJsonDependenciesExternalUpdateManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PackageJsonDependenciesExternalUpdateManager> serviceClass$iv = PackageJsonDependenciesExternalUpdateManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PackageJsonDependenciesExternalUpdateManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager$InstalledDependenciesVfsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager;)V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "checkIfInsideDependencies", "", "parentDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOrDirName", "", "isDependencyRoot", "dispose", "", "intellij.javascript.impl"})
    private final class InstalledDependenciesVfsListener
    implements AsyncFileListener,
    Disposable {
        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                boolean found;
                boolean bl;
                VFileEvent vFileEvent2 = vFileEvent;
                if (vFileEvent2 instanceof VFileCreateEvent) {
                    VirtualFile virtualFile = ((VFileCreateEvent)vFileEvent).getParent();
                    String string = ((VFileCreateEvent)vFileEvent).getChildName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChildName(...)");
                    bl = this.checkIfInsideDependencies(virtualFile, string);
                } else if (vFileEvent2 instanceof VFileDeleteEvent) {
                    VirtualFile virtualFile = ((VFileDeleteEvent)vFileEvent).getFile().getParent();
                    String string = ((VFileDeleteEvent)vFileEvent).getFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    bl = this.checkIfInsideDependencies(virtualFile, string);
                } else {
                    bl = false;
                }
                if (!(found = bl)) continue;
                PackageJsonDependenciesExternalUpdateManager.this.onInstalledDependencyChanged();
                break;
            }
            return null;
        }

        private final boolean checkIfInsideDependencies(VirtualFile parentDir, String fileOrDirName) {
            if (parentDir == null) {
                return false;
            }
            if (this.isDependencyRoot(fileOrDirName)) {
                return true;
            }
            VirtualFile dir = parentDir;
            for (int index = 0; index < 3; ++index) {
                if (dir == null) continue;
                String string = dir.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (this.isDependencyRoot(string)) {
                    return true;
                }
                dir = dir.getParent();
            }
            return false;
        }

        private final boolean isDependencyRoot(String fileOrDirName) {
            return Intrinsics.areEqual((Object)"node_modules", (Object)fileOrDirName) || Intrinsics.areEqual((Object)".yarn", (Object)fileOrDirName);
        }

        public void dispose() {
        }
    }
}

