/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.detection;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testing.detection.JsTestFileIndexData;
import com.intellij.javascript.testing.detection.JsTestFileIndexDataKt;
import com.intellij.javascript.testing.detection.JsTestFrameworkApiDesign;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0012H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001d\u00c0\u0006\u0001"}, d2={"Lcom/intellij/javascript/testing/detection/JsTestFrameworkDetector;", "", "frameworkName", "", "getFrameworkName", "()Ljava/lang/String;", "frameworkApiDesign", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkApiDesign;", "getFrameworkApiDesign", "()Lcom/intellij/javascript/testing/detection/JsTestFrameworkApiDesign;", "hasSupportSnapshotTestIntegrations", "", "findFileBasedIndexData", "Lcom/intellij/javascript/testing/detection/JsTestFileIndexData;", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "findTestFilesInIndexesBySelector", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "testSelector", "Lcom/intellij/javascript/testFramework/JsTestSelector;", "checkIsProbablyTestFile", "findTestsStructure", "Lcom/intellij/javascript/testFramework/AbstractTestFileStructure;", "hasTestsInFile", "hasTestsUnderDirectory", "directory", "intellij.javascript.impl"})
public interface JsTestFrameworkDetector {
    @NotNull
    public String getFrameworkName();

    @NotNull
    public JsTestFrameworkApiDesign getFrameworkApiDesign();

    default public boolean hasSupportSnapshotTestIntegrations() {
        return false;
    }

    @NotNull
    default public JsTestFileIndexData findFileBasedIndexData(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return JsTestFileIndexDataKt.emptyJsTestFileIndexData();
    }

    @NotNull
    default public List<VirtualFile> findTestFilesInIndexesBySelector(@NotNull Project project, @NotNull JsTestSelector testSelector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testSelector, (String)"testSelector");
        return CollectionsKt.emptyList();
    }

    default public boolean checkIsProbablyTestFile(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return false;
    }

    @Nullable
    default public AbstractTestFileStructure findTestsStructure(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return null;
    }

    default public boolean hasTestsInFile(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        AbstractTestFileStructure abstractTestFileStructure = this.findTestsStructure(jsFile);
        return abstractTestFileStructure != null ? !abstractTestFileStructure.isEmpty() : false;
    }

    default public boolean hasTestsUnderDirectory(@NotNull Project project, @NotNull VirtualFile directory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return false;
    }
}

