/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest.coverage;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.LineSeparator;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0003\u000f\u0010\u0011B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/testing/vitest/coverage/VitestInstallMissingDependencyFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/openapi/project/DumbAware;", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "InstallDependencyHyperlinkInfo", "TextModifier", "Companion", "intellij.javascript.impl"})
public final class VitestInstallMissingDependencyFilter
implements Filter,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile packageJson;
    @NotNull
    private final ExecutionEnvironment environment;
    @NotNull
    private static final String PREFIX = " MISSING DEP  Can not find dependency '";
    @NotNull
    private static final String INSTALL_LINK = "Install and re-run";
    @NotNull
    private static final String ADDED_SUFFIX = " (Install and re-run)";

    public VitestInstallMissingDependencyFilter(@NotNull VirtualFile packageJson, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.packageJson = packageJson;
        this.environment = environment;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        int linkStartInd;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String missingDependency = VitestInstallMissingDependencyFilter.Companion.findMissingDependency(line, true);
        if (missingDependency != null && (linkStartInd = StringsKt.lastIndexOf$default((CharSequence)line, (String)INSTALL_LINK, (int)0, (boolean)false, (int)6, null)) > 0) {
            int offset = entireLength - line.length();
            return new Filter.Result(offset + linkStartInd, offset + linkStartInd + 18, (HyperlinkInfo)new InstallDependencyHyperlinkInfo(this.packageJson, missingDependency, (Function0<Unit>)((Function0)() -> VitestInstallMissingDependencyFilter.applyFilter$lambda$0(this))));
        }
        return null;
    }

    private static final Unit applyFilter$lambda$0(VitestInstallMissingDependencyFilter this$0) {
        ExecutionUtil.restart((ExecutionEnvironment)this$0.environment);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/testing/vitest/coverage/VitestInstallMissingDependencyFilter$Companion;", "", "<init>", "()V", "PREFIX", "", "INSTALL_LINK", "ADDED_SUFFIX", "findMissingDependency", "line", "expectInstallLink", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String findMissingDependency(String line, boolean expectInstallLink) {
            int closingQuoteInd;
            if (StringsKt.startsWith$default((String)line, (String)VitestInstallMissingDependencyFilter.PREFIX, (boolean)false, (int)2, null) && (closingQuoteInd = StringsKt.indexOf$default((CharSequence)line, (char)'\'', (int)39, (boolean)false, (int)4, null)) > 0) {
                String string = line.substring(39, closingQuoteInd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String dependencyName = string;
                if (NodePackageUtil.validateNpmPackageName(dependencyName) == null) {
                    int nextIndex = closingQuoteInd + 1;
                    if (expectInstallLink) {
                        if (StringsKt.regionMatches((String)line, (int)nextIndex, (String)VitestInstallMissingDependencyFilter.ADDED_SUFFIX, (int)0, (int)21, (boolean)false)) {
                            nextIndex += 21;
                        } else {
                            return null;
                        }
                    }
                    String string2 = line.substring(nextIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    if (StringsKt.isBlank((CharSequence)string2)) {
                        return dependencyName;
                    }
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/testing/vitest/coverage/VitestInstallMissingDependencyFilter$InstallDependencyHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "dependencyName", "", "onSuccessCallback", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "navigate", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
    public static final class InstallDependencyHyperlinkInfo
    implements HyperlinkInfo {
        @NotNull
        private final VirtualFile packageJson;
        @NotNull
        private final String dependencyName;
        @NotNull
        private final Function0<Unit> onSuccessCallback;

        public InstallDependencyHyperlinkInfo(@NotNull VirtualFile packageJson, @NotNull String dependencyName, @NotNull Function0<Unit> onSuccessCallback) {
            Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            Intrinsics.checkNotNullParameter(onSuccessCallback, (String)"onSuccessCallback");
            this.packageJson = packageJson;
            this.dependencyName = dependencyName;
            this.onSuccessCallback = onSuccessCallback;
        }

        public void navigate(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(this.packageJson);
            if (psiFile != null && this.packageJson.isValid()) {
                new InstallNodeModuleQuickFix(new InstallNodeModuleQuickFix.ModuleElement(this, project){
                    final /* synthetic */ InstallDependencyHyperlinkInfo this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                    }

                    public String getModuleName() {
                        return InstallDependencyHyperlinkInfo.access$getDependencyName$p(this.this$0);
                    }

                    public Project getProject() {
                        return this.$project;
                    }
                }, false, true, CollectionsKt.listOf((Object)this.packageJson)).setOnSuccessCallback(() -> InstallDependencyHyperlinkInfo.navigate$lambda$0(this.onSuccessCallback)).invokeAction(project, psiFile, this.packageJson);
            }
        }

        private static final void navigate$lambda$0(Function0 $tmp0) {
            $tmp0.invoke();
        }

        public static final /* synthetic */ String access$getDependencyName$p(InstallDependencyHyperlinkInfo $this) {
            return $this.dependencyName;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/testing/vitest/coverage/VitestInstallMissingDependencyFilter$TextModifier;", "", "<init>", "()V", "prevText", "", "Lcom/intellij/execution/process/ProcessOutputType;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "_foundMissingDependencies", "", "", "foundMissingDependencies", "", "getFoundMissingDependencies", "()Ljava/util/Set;", "processText", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "insertAt", "textInd", "", "strToInsert", "intellij.javascript.impl"})
    public static final class TextModifier {
        @NotNull
        private final Map<ProcessOutputType, StringBuilder> prevText;
        @NotNull
        private final Set<String> _foundMissingDependencies;

        public TextModifier() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ProcessOutputType.STDERR, (Object)new StringBuilder()), TuplesKt.to((Object)ProcessOutputType.STDOUT, (Object)new StringBuilder())};
            this.prevText = new ConcurrentHashMap(MapsKt.mapOf((Pair[])pairArray));
            Set set = Collections.synchronizedSet(new LinkedHashSet());
            Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
            this._foundMissingDependencies = set;
        }

        @NotNull
        public final Set<String> getFoundMissingDependencies() {
            return this._foundMissingDependencies;
        }

        @NotNull
        public final String processText(@NotNull String text, @NotNull Key<?> outputType) {
            StringBuilder builder2;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            String result2 = text;
            if (outputType instanceof ProcessOutputType && (builder2 = this.prevText.get(((ProcessOutputType)outputType).getBaseOutputType())) != null) {
                builder2.append(text);
                String string = LineSeparator.LF.getSeparatorString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparatorString(...)");
                if (StringsKt.endsWith$default((String)text, (String)string, (boolean)false, (int)2, null)) {
                    int closingQuoteInd;
                    String string2 = builder2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String line = string2;
                    builder2.setLength(0);
                    String missingDependency = Companion.findMissingDependency(line, false);
                    if (missingDependency != null && (closingQuoteInd = StringsKt.lastIndexOf$default((CharSequence)text, (char)'\'', (int)0, (boolean)false, (int)6, null)) > 0) {
                        result2 = this.insertAt(text, closingQuoteInd + 1, VitestInstallMissingDependencyFilter.ADDED_SUFFIX);
                        this._foundMissingDependencies.add(missingDependency);
                    }
                }
            }
            return result2;
        }

        private final String insertAt(String text, int textInd, String strToInsert) {
            String string = text.substring(0, textInd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = text.substring(textInd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string + strToInsert + string2;
        }
    }
}

