/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a/\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a/\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a.\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f\u00a8\u0006\u0010"}, d2={"beforeRefactoring", "", "project", "Lcom/intellij/openapi/project/Project;", "id", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Lcom/intellij/psi/PsiElement;)V", "afterRefactoring", "invokeWithRefactoringEvent", "refactoringId", "beforeDataElement", "computable", "Lcom/intellij/openapi/util/Computable;", "intellij.javascript.impl"})
public final class UtilKt {
    public static final void beforeRefactoring(@NotNull Project project, @NotNull String id, PsiElement ... elements) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        RefactoringEventData beforeData = new RefactoringEventData();
        PsiElement element = (PsiElement)ArraysKt.singleOrNull((Object[])elements);
        if (element != null) {
            beforeData.addElement(element);
        } else {
            beforeData.addElements(elements);
        }
        MessageBus messageBus = project.getMessageBus();
        Topic topic = RefactoringEventListener.REFACTORING_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"REFACTORING_EVENT_TOPIC");
        ((RefactoringEventListener)messageBus.syncPublisher(topic)).refactoringStarted(id, beforeData);
    }

    public static final void afterRefactoring(@NotNull Project project, @NotNull String id, PsiElement ... elements) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        RefactoringEventData afterData = new RefactoringEventData();
        PsiElement element = (PsiElement)ArraysKt.singleOrNull((Object[])elements);
        if (element != null) {
            afterData.addElement(element);
        } else {
            afterData.addElements(elements);
        }
        MessageBus messageBus = project.getMessageBus();
        Topic topic = RefactoringEventListener.REFACTORING_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"REFACTORING_EVENT_TOPIC");
        ((RefactoringEventListener)messageBus.syncPublisher(topic)).refactoringDone(id, afterData);
    }

    @Nullable
    public static final PsiElement invokeWithRefactoringEvent(@NotNull Project project, @NotNull String refactoringId, @NotNull PsiElement beforeDataElement, @NotNull Computable<PsiElement> computable) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)refactoringId, (String)"refactoringId");
        Intrinsics.checkNotNullParameter((Object)beforeDataElement, (String)"beforeDataElement");
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        PsiElement[] psiElementArray = new PsiElement[]{beforeDataElement};
        UtilKt.beforeRefactoring(project, refactoringId, psiElementArray);
        JSRefactoringUtil.registerRefactoringUndo(project, refactoringId);
        PsiElement psiElement2 = (PsiElement)computable.compute();
        if (psiElement2 != null) {
            PsiElement psiElement3;
            PsiElement $this$invokeWithRefactoringEvent_u24lambda_u240 = psiElement3 = psiElement2;
            boolean bl = false;
            PsiElement[] psiElementArray2 = new PsiElement[]{$this$invokeWithRefactoringEvent_u24lambda_u240};
            UtilKt.afterRefactoring(project, refactoringId, psiElementArray2);
            psiElement = psiElement3;
        } else {
            psiElement = null;
        }
        return psiElement;
    }
}

