"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Error = void 0;
var react_1 = __importDefault(require("react"));
var constants_1 = require("../../constants");
var renderErrors = function (errors) {
    if (!errors) {
        return null;
    }
    return errors
        .map(function (singleError, index) {
        var _a, _b, _c, _d, _e;
        if (!(singleError === null || singleError === void 0 ? void 0 : singleError.title)) {
            return null;
        }
        return (react_1.default.createElement("div", { key: index, className: "flex gap-2" },
            ((_b = (_a = singleError === null || singleError === void 0 ? void 0 : singleError.location) === null || _a === void 0 ? void 0 : _a.startLine) !== null && _b !== void 0 ? _b : (_c = singleError === null || singleError === void 0 ? void 0 : singleError.location) === null || _c === void 0 ? void 0 : _c.startOffset) && (react_1.default.createElement("span", null, "line ".concat(((_d = singleError === null || singleError === void 0 ? void 0 : singleError.location) === null || _d === void 0 ? void 0 : _d.startLine) + ((_e = singleError === null || singleError === void 0 ? void 0 : singleError.location) === null || _e === void 0 ? void 0 : _e.startOffset), ":"))),
            react_1.default.createElement("code", { className: "whitespace-pre-wrap break-all ml-2" }, singleError.title)));
    })
        .filter(Boolean);
};
var Error = function (_a) {
    var error = _a.error;
    if (!error) {
        return null;
    }
    var title = error.title, validationErrors = error.validationErrors;
    return (react_1.default.createElement("div", { className: "panel-item" },
        react_1.default.createElement("div", { className: "panel-item--center p-8" },
            react_1.default.createElement("section", { className: "shadow rounded bg-gray-200 border-red-500 border-l-8" },
                react_1.default.createElement("h2", { className: "p-2" }, title ? "".concat(constants_1.ERROR_TEXT, ": ").concat(title) : constants_1.ERROR_TEXT),
                (validationErrors === null || validationErrors === void 0 ? void 0 : validationErrors.length) ? (react_1.default.createElement("div", { className: "bg-gray-800 text-white text-xs p-2" },
                    react_1.default.createElement("pre", null, renderErrors(validationErrors)))) : null)),
        react_1.default.createElement("div", { className: "panel-item--right" })));
};
exports.Error = Error;
//# sourceMappingURL=Error.js.map