from collections.abc import Callable, Iterator
from re import Match
from typing import Any

from django.core.files.base import File
from django.core.files.storage import FileSystemStorage, Storage
from django.utils._os import _PathCompatible
from django.utils.functional import LazyObject
from typing_extensions import TypeAlias

_PostProcessT: TypeAlias = Iterator[tuple[str, str, bool] | tuple[str, None, RuntimeError]]

class StaticFilesStorage(FileSystemStorage):
    def __init__(
        self, location: _PathCompatible | None = None, base_url: str | None = None, *args: Any, **kwargs: Any
    ) -> None: ...
    def path(self, name: _PathCompatible) -> str: ...

class HashedFilesMixin:
    default_template: str
    max_post_process_passes: int
    support_js_module_import_aggregation: bool
    patterns: Any
    hashed_files: Any
    keep_intermediate_files: bool
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def file_hash(self, name: str, content: File | None = None) -> str | None: ...
    def hashed_name(self, name: str, content: File | None = None, filename: str | None = None) -> str: ...
    def url(self, name: str, force: bool = False) -> str: ...
    def url_converter(
        self, name: str, hashed_files: dict[str, Any], template: str | None = None
    ) -> Callable[[Match], str]: ...
    def post_process(self, paths: dict[str, Any], dry_run: bool = False, **options: Any) -> _PostProcessT: ...
    def clean_name(self, name: str) -> str: ...
    def hash_key(self, name: str) -> str: ...
    def stored_name(self, name: str) -> str: ...

class ManifestFilesMixin(HashedFilesMixin):
    manifest_version: str
    manifest_name: str
    manifest_strict: bool
    keep_intermediate_files: bool
    manifest_storage: Storage | None
    hashed_files: dict[str, str]
    manifest_hash: str
    def __init__(self, *args: Any, manifest_storage: Storage | None = None, **kwargs: Any) -> None: ...
    def read_manifest(self) -> str: ...
    def load_manifest(self) -> dict[str, Any]: ...
    def save_manifest(self) -> None: ...
    def post_process(self, *args: Any, **kwargs: Any) -> _PostProcessT: ...
    def stored_name(self, name: str) -> str: ...

class ManifestStaticFilesStorage(ManifestFilesMixin, StaticFilesStorage): ...  # type: ignore[misc]
class ConfiguredStorage(LazyObject): ...

staticfiles_storage: Storage
