dnl
dnl checking for AEX
dnl
AC_DEFUN([AC_CHECK_AEX], [
    AC_ARG_ENABLE([aex],
                  AC_HELP_STRING([--enable-aex],
                                 [enable support for Apple Airport Express (AEX)]),
                  [enable_aex=$enableval], [enable_aex=no])

    if test x"$enable_aex" = xyes; then
        PKG_CHECK_MODULES(AVAHI, [avahi-client >= 0.6], [have_avahi=yes], [have_avahi=no])
        if test x"$have_avahi" = xyes; then
            AC_DEFINE([HAVE_AEX],,[Define this if you want oxine to use AEX.])
            AC_DEFINE([HAVE_AVAHI],,[Define this if you have the AVAHI client library installed.])
            have_aex=yes
        else
            AC_MSG_WARN([])
            AC_MSG_WARN([Please install the AVAHI client library (libavahi-client) if you wish to use])
            AC_MSG_WARN([automatic discovery of Apple Airport Express.])
            AC_MSG_WARN([])
            have_aex=no
        fi
    fi
])
