
/*
 * Copyright (C) 2007 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: aex.h 2217 2007-06-07 20:27:06Z mschwerin $
 *
 */

#ifndef HAVE_AEX_H
#define HAVE_AEX_H

#include "oxine.h"
#include "types.h"

#ifdef HAVE_AEX

#ifndef HAVE_AVAHI
#error "AVAHI must be installed to use AEX stuff!"
#endif /* HAVE_AVAHI */

typedef struct {
    /// The name of the airport express as returned by AHAVI.
    char *name;

    /// The title of this airport express.
    char *title;

    /// The network address of this airport express.
    char *address;

    /// The port under which the airport express offers it's service.
    uint16_t port;
} aex_t;


bool aex_monitor_start (void);
bool aex_monitor_free (void);

aex_t *aex_first (void);
aex_t *aex_next (aex_t * aex);

void aex_monitor_lock (void);
void aex_monitor_unlock (void);

#endif /* HAVE_AEX */
#endif /* HAVE_AEX_H */
