
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk_editbox.h 2044 2007-05-15 13:01:50Z mschwerin $
 *
 */

#ifndef HAVE_OTK_EDITBOX_H
#define HAVE_OTK_EDITBOX_H
#ifdef __cplusplus
extern "C" {
#endif

typedef void (*otk_editbox_cb_t) (void *user_data, char *text);

otk_widget_t *otk_editbox_new (otk_t * otk, int x, int y, int w, int h,
                               int max_length, 
                               otk_editbox_cb_t change_cb, 
                               void *change_cb_data,
                               otk_editbox_cb_t activate_cb, 
                               void *activate_cb_data);

void otk_editbox_set_text (otk_widget_t * editbox, const char *text);

char *otk_editbox_get_text (otk_widget_t * editbox);

void otk_editbox_is_password (otk_widget_t * editbox, bool is_password);


#ifdef __cplusplus
}
#endif
#endif /* HAVE_OTK_EDITBOX_H */
