
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: scheduler.h 1593 2006-11-27 16:38:12Z mschwerin $
 *
 */

#ifndef HAVE_SCHEDULER_H
#define HAVE_SCHEDULER_H
#ifdef __cplusplus
extern "C" {
#endif


/// Starts the scheduler thread.
void start_scheduler (void);


/// Stops the scheduler thread.
void stop_scheduler (void);


/// Schedules a job.
/**
 * @param delay_ms              Wait for the specified number of ms before
 *                              executing the <code>cb</code>.
 * @param cb                    The callback function to execute.
 * @param cb_data               User defined data that is passed to
 *                              <code>cb</code> when executing the job.
 * @return                      The ID of the scheduled job or -1 if the job
 *                              could not be scheduled.
 */
int schedule_job (int delay_ms, void (*cb) (void *data), void *cb_data);


/// Cancels a job.
/**
 * @param job_id                The ID that was returned by
 *                              <code>schedule_job</code>.
 */
void cancel_job (int job_id);


/// Locks the job execution mutex.
/**
 * As long as this mutex is locked no jobs can be executed.
 */
void lock_job_mutex (void);


/// Unlocks the job execution mutex.
/**
 * As long as this mutex is locked no jobs can be executed.
 */
void unlock_job_mutex (void);


#ifdef __cplusplus
}
#endif
#endif /* HAVE_SCHEDULER_H */
