// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package discoveryengine provides access to the Discovery Engine API.
//
// For product documentation, see: https://cloud.google.com/generative-ai-app-builder/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/discoveryengine/v1beta"
//	...
//	ctx := context.Background()
//	discoveryengineService, err := discoveryengine.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package discoveryengine // import "google.golang.org/api/discoveryengine/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "discoveryengine:v1beta"
const apiName = "discoveryengine"
const apiVersion = "v1beta"
const basePath = "https://discoveryengine.googleapis.com/"
const basePathTemplate = "https://discoveryengine.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://discoveryengine.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Collections = NewProjectsLocationsCollectionsService(s)
	rs.DataStores = NewProjectsLocationsDataStoresService(s)
	rs.Evaluations = NewProjectsLocationsEvaluationsService(s)
	rs.GroundingConfigs = NewProjectsLocationsGroundingConfigsService(s)
	rs.IdentityMappingStores = NewProjectsLocationsIdentityMappingStoresService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.RankingConfigs = NewProjectsLocationsRankingConfigsService(s)
	rs.SampleQuerySets = NewProjectsLocationsSampleQuerySetsService(s)
	rs.UserEvents = NewProjectsLocationsUserEventsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Collections *ProjectsLocationsCollectionsService

	DataStores *ProjectsLocationsDataStoresService

	Evaluations *ProjectsLocationsEvaluationsService

	GroundingConfigs *ProjectsLocationsGroundingConfigsService

	IdentityMappingStores *ProjectsLocationsIdentityMappingStoresService

	Operations *ProjectsLocationsOperationsService

	RankingConfigs *ProjectsLocationsRankingConfigsService

	SampleQuerySets *ProjectsLocationsSampleQuerySetsService

	UserEvents *ProjectsLocationsUserEventsService
}

func NewProjectsLocationsCollectionsService(s *Service) *ProjectsLocationsCollectionsService {
	rs := &ProjectsLocationsCollectionsService{s: s}
	rs.DataConnector = NewProjectsLocationsCollectionsDataConnectorService(s)
	rs.DataStores = NewProjectsLocationsCollectionsDataStoresService(s)
	rs.Engines = NewProjectsLocationsCollectionsEnginesService(s)
	rs.Operations = NewProjectsLocationsCollectionsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsService struct {
	s *Service

	DataConnector *ProjectsLocationsCollectionsDataConnectorService

	DataStores *ProjectsLocationsCollectionsDataStoresService

	Engines *ProjectsLocationsCollectionsEnginesService

	Operations *ProjectsLocationsCollectionsOperationsService
}

func NewProjectsLocationsCollectionsDataConnectorService(s *Service) *ProjectsLocationsCollectionsDataConnectorService {
	rs := &ProjectsLocationsCollectionsDataConnectorService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataConnectorOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataConnectorService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataConnectorOperationsService
}

func NewProjectsLocationsCollectionsDataConnectorOperationsService(s *Service) *ProjectsLocationsCollectionsDataConnectorOperationsService {
	rs := &ProjectsLocationsCollectionsDataConnectorOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataConnectorOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresService(s *Service) *ProjectsLocationsCollectionsDataStoresService {
	rs := &ProjectsLocationsCollectionsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsCollectionsDataStoresBranchesService(s)
	rs.CompletionConfig = NewProjectsLocationsCollectionsDataStoresCompletionConfigService(s)
	rs.CompletionSuggestions = NewProjectsLocationsCollectionsDataStoresCompletionSuggestionsService(s)
	rs.Controls = NewProjectsLocationsCollectionsDataStoresControlsService(s)
	rs.Conversations = NewProjectsLocationsCollectionsDataStoresConversationsService(s)
	rs.CustomModels = NewProjectsLocationsCollectionsDataStoresCustomModelsService(s)
	rs.Models = NewProjectsLocationsCollectionsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresOperationsService(s)
	rs.Schemas = NewProjectsLocationsCollectionsDataStoresSchemasService(s)
	rs.ServingConfigs = NewProjectsLocationsCollectionsDataStoresServingConfigsService(s)
	rs.Sessions = NewProjectsLocationsCollectionsDataStoresSessionsService(s)
	rs.SiteSearchEngine = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineService(s)
	rs.SuggestionDenyListEntries = NewProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService(s)
	rs.UserEvents = NewProjectsLocationsCollectionsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsCollectionsDataStoresBranchesService

	CompletionConfig *ProjectsLocationsCollectionsDataStoresCompletionConfigService

	CompletionSuggestions *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService

	Controls *ProjectsLocationsCollectionsDataStoresControlsService

	Conversations *ProjectsLocationsCollectionsDataStoresConversationsService

	CustomModels *ProjectsLocationsCollectionsDataStoresCustomModelsService

	Models *ProjectsLocationsCollectionsDataStoresModelsService

	Operations *ProjectsLocationsCollectionsDataStoresOperationsService

	Schemas *ProjectsLocationsCollectionsDataStoresSchemasService

	ServingConfigs *ProjectsLocationsCollectionsDataStoresServingConfigsService

	Sessions *ProjectsLocationsCollectionsDataStoresSessionsService

	SiteSearchEngine *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService

	SuggestionDenyListEntries *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService

	UserEvents *ProjectsLocationsCollectionsDataStoresUserEventsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsCollectionsDataStoresBranchesOperationsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresCompletionConfigService(s *Service) *ProjectsLocationsCollectionsDataStoresCompletionConfigService {
	rs := &ProjectsLocationsCollectionsDataStoresCompletionConfigService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresCompletionConfigService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresCompletionSuggestionsService(s *Service) *ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService {
	rs := &ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresCompletionSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresControlsService(s *Service) *ProjectsLocationsCollectionsDataStoresControlsService {
	rs := &ProjectsLocationsCollectionsDataStoresControlsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresControlsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresConversationsService(s *Service) *ProjectsLocationsCollectionsDataStoresConversationsService {
	rs := &ProjectsLocationsCollectionsDataStoresConversationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresConversationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresCustomModelsService(s *Service) *ProjectsLocationsCollectionsDataStoresCustomModelsService {
	rs := &ProjectsLocationsCollectionsDataStoresCustomModelsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresCustomModelsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresModelsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresModelsOperationsService
}

func NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSchemasService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSchemasOperationsService
}

func NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresServingConfigsService(s *Service) *ProjectsLocationsCollectionsDataStoresServingConfigsService {
	rs := &ProjectsLocationsCollectionsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSessionsService(s *Service) *ProjectsLocationsCollectionsDataStoresSessionsService {
	rs := &ProjectsLocationsCollectionsDataStoresSessionsService{s: s}
	rs.Answers = NewProjectsLocationsCollectionsDataStoresSessionsAnswersService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSessionsService struct {
	s *Service

	Answers *ProjectsLocationsCollectionsDataStoresSessionsAnswersService
}

func NewProjectsLocationsCollectionsDataStoresSessionsAnswersService(s *Service) *ProjectsLocationsCollectionsDataStoresSessionsAnswersService {
	rs := &ProjectsLocationsCollectionsDataStoresSessionsAnswersService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSessionsAnswersService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService(s)
	rs.Sitemaps = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService(s)
	rs.TargetSites = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService

	Sitemaps *ProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService

	TargetSites *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineSitemapsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService(s *Service) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService {
	rs := &ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresUserEventsService(s *Service) *ProjectsLocationsCollectionsDataStoresUserEventsService {
	rs := &ProjectsLocationsCollectionsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesService(s *Service) *ProjectsLocationsCollectionsEnginesService {
	rs := &ProjectsLocationsCollectionsEnginesService{s: s}
	rs.CompletionConfig = NewProjectsLocationsCollectionsEnginesCompletionConfigService(s)
	rs.Controls = NewProjectsLocationsCollectionsEnginesControlsService(s)
	rs.Conversations = NewProjectsLocationsCollectionsEnginesConversationsService(s)
	rs.Operations = NewProjectsLocationsCollectionsEnginesOperationsService(s)
	rs.ServingConfigs = NewProjectsLocationsCollectionsEnginesServingConfigsService(s)
	rs.Sessions = NewProjectsLocationsCollectionsEnginesSessionsService(s)
	return rs
}

type ProjectsLocationsCollectionsEnginesService struct {
	s *Service

	CompletionConfig *ProjectsLocationsCollectionsEnginesCompletionConfigService

	Controls *ProjectsLocationsCollectionsEnginesControlsService

	Conversations *ProjectsLocationsCollectionsEnginesConversationsService

	Operations *ProjectsLocationsCollectionsEnginesOperationsService

	ServingConfigs *ProjectsLocationsCollectionsEnginesServingConfigsService

	Sessions *ProjectsLocationsCollectionsEnginesSessionsService
}

func NewProjectsLocationsCollectionsEnginesCompletionConfigService(s *Service) *ProjectsLocationsCollectionsEnginesCompletionConfigService {
	rs := &ProjectsLocationsCollectionsEnginesCompletionConfigService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesCompletionConfigService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesControlsService(s *Service) *ProjectsLocationsCollectionsEnginesControlsService {
	rs := &ProjectsLocationsCollectionsEnginesControlsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesControlsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesConversationsService(s *Service) *ProjectsLocationsCollectionsEnginesConversationsService {
	rs := &ProjectsLocationsCollectionsEnginesConversationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesConversationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesOperationsService(s *Service) *ProjectsLocationsCollectionsEnginesOperationsService {
	rs := &ProjectsLocationsCollectionsEnginesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesServingConfigsService(s *Service) *ProjectsLocationsCollectionsEnginesServingConfigsService {
	rs := &ProjectsLocationsCollectionsEnginesServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesSessionsService(s *Service) *ProjectsLocationsCollectionsEnginesSessionsService {
	rs := &ProjectsLocationsCollectionsEnginesSessionsService{s: s}
	rs.Answers = NewProjectsLocationsCollectionsEnginesSessionsAnswersService(s)
	return rs
}

type ProjectsLocationsCollectionsEnginesSessionsService struct {
	s *Service

	Answers *ProjectsLocationsCollectionsEnginesSessionsAnswersService
}

func NewProjectsLocationsCollectionsEnginesSessionsAnswersService(s *Service) *ProjectsLocationsCollectionsEnginesSessionsAnswersService {
	rs := &ProjectsLocationsCollectionsEnginesSessionsAnswersService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesSessionsAnswersService struct {
	s *Service
}

func NewProjectsLocationsCollectionsOperationsService(s *Service) *ProjectsLocationsCollectionsOperationsService {
	rs := &ProjectsLocationsCollectionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresService(s *Service) *ProjectsLocationsDataStoresService {
	rs := &ProjectsLocationsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsDataStoresBranchesService(s)
	rs.CompletionConfig = NewProjectsLocationsDataStoresCompletionConfigService(s)
	rs.CompletionSuggestions = NewProjectsLocationsDataStoresCompletionSuggestionsService(s)
	rs.Controls = NewProjectsLocationsDataStoresControlsService(s)
	rs.Conversations = NewProjectsLocationsDataStoresConversationsService(s)
	rs.Models = NewProjectsLocationsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsDataStoresOperationsService(s)
	rs.Schemas = NewProjectsLocationsDataStoresSchemasService(s)
	rs.ServingConfigs = NewProjectsLocationsDataStoresServingConfigsService(s)
	rs.Sessions = NewProjectsLocationsDataStoresSessionsService(s)
	rs.SiteSearchEngine = NewProjectsLocationsDataStoresSiteSearchEngineService(s)
	rs.SuggestionDenyListEntries = NewProjectsLocationsDataStoresSuggestionDenyListEntriesService(s)
	rs.UserEvents = NewProjectsLocationsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsDataStoresBranchesService

	CompletionConfig *ProjectsLocationsDataStoresCompletionConfigService

	CompletionSuggestions *ProjectsLocationsDataStoresCompletionSuggestionsService

	Controls *ProjectsLocationsDataStoresControlsService

	Conversations *ProjectsLocationsDataStoresConversationsService

	Models *ProjectsLocationsDataStoresModelsService

	Operations *ProjectsLocationsDataStoresOperationsService

	Schemas *ProjectsLocationsDataStoresSchemasService

	ServingConfigs *ProjectsLocationsDataStoresServingConfigsService

	Sessions *ProjectsLocationsDataStoresSessionsService

	SiteSearchEngine *ProjectsLocationsDataStoresSiteSearchEngineService

	SuggestionDenyListEntries *ProjectsLocationsDataStoresSuggestionDenyListEntriesService

	UserEvents *ProjectsLocationsDataStoresUserEventsService
}

func NewProjectsLocationsDataStoresBranchesService(s *Service) *ProjectsLocationsDataStoresBranchesService {
	rs := &ProjectsLocationsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsDataStoresBranchesOperationsService
}

func NewProjectsLocationsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresCompletionConfigService(s *Service) *ProjectsLocationsDataStoresCompletionConfigService {
	rs := &ProjectsLocationsDataStoresCompletionConfigService{s: s}
	return rs
}

type ProjectsLocationsDataStoresCompletionConfigService struct {
	s *Service
}

func NewProjectsLocationsDataStoresCompletionSuggestionsService(s *Service) *ProjectsLocationsDataStoresCompletionSuggestionsService {
	rs := &ProjectsLocationsDataStoresCompletionSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresCompletionSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresControlsService(s *Service) *ProjectsLocationsDataStoresControlsService {
	rs := &ProjectsLocationsDataStoresControlsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresControlsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresConversationsService(s *Service) *ProjectsLocationsDataStoresConversationsService {
	rs := &ProjectsLocationsDataStoresConversationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresConversationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresModelsService(s *Service) *ProjectsLocationsDataStoresModelsService {
	rs := &ProjectsLocationsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsDataStoresModelsOperationsService
}

func NewProjectsLocationsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresOperationsService(s *Service) *ProjectsLocationsDataStoresOperationsService {
	rs := &ProjectsLocationsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSchemasService(s *Service) *ProjectsLocationsDataStoresSchemasService {
	rs := &ProjectsLocationsDataStoresSchemasService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSchemasService struct {
	s *Service
}

func NewProjectsLocationsDataStoresServingConfigsService(s *Service) *ProjectsLocationsDataStoresServingConfigsService {
	rs := &ProjectsLocationsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSessionsService(s *Service) *ProjectsLocationsDataStoresSessionsService {
	rs := &ProjectsLocationsDataStoresSessionsService{s: s}
	rs.Answers = NewProjectsLocationsDataStoresSessionsAnswersService(s)
	return rs
}

type ProjectsLocationsDataStoresSessionsService struct {
	s *Service

	Answers *ProjectsLocationsDataStoresSessionsAnswersService
}

func NewProjectsLocationsDataStoresSessionsAnswersService(s *Service) *ProjectsLocationsDataStoresSessionsAnswersService {
	rs := &ProjectsLocationsDataStoresSessionsAnswersService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSessionsAnswersService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSiteSearchEngineService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineService{s: s}
	rs.Sitemaps = NewProjectsLocationsDataStoresSiteSearchEngineSitemapsService(s)
	rs.TargetSites = NewProjectsLocationsDataStoresSiteSearchEngineTargetSitesService(s)
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineService struct {
	s *Service

	Sitemaps *ProjectsLocationsDataStoresSiteSearchEngineSitemapsService

	TargetSites *ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService
}

func NewProjectsLocationsDataStoresSiteSearchEngineSitemapsService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineSitemapsService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineSitemapsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineSitemapsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSiteSearchEngineTargetSitesService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSuggestionDenyListEntriesService(s *Service) *ProjectsLocationsDataStoresSuggestionDenyListEntriesService {
	rs := &ProjectsLocationsDataStoresSuggestionDenyListEntriesService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSuggestionDenyListEntriesService struct {
	s *Service
}

func NewProjectsLocationsDataStoresUserEventsService(s *Service) *ProjectsLocationsDataStoresUserEventsService {
	rs := &ProjectsLocationsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsEvaluationsService(s *Service) *ProjectsLocationsEvaluationsService {
	rs := &ProjectsLocationsEvaluationsService{s: s}
	rs.Operations = NewProjectsLocationsEvaluationsOperationsService(s)
	return rs
}

type ProjectsLocationsEvaluationsService struct {
	s *Service

	Operations *ProjectsLocationsEvaluationsOperationsService
}

func NewProjectsLocationsEvaluationsOperationsService(s *Service) *ProjectsLocationsEvaluationsOperationsService {
	rs := &ProjectsLocationsEvaluationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsEvaluationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsGroundingConfigsService(s *Service) *ProjectsLocationsGroundingConfigsService {
	rs := &ProjectsLocationsGroundingConfigsService{s: s}
	return rs
}

type ProjectsLocationsGroundingConfigsService struct {
	s *Service
}

func NewProjectsLocationsIdentityMappingStoresService(s *Service) *ProjectsLocationsIdentityMappingStoresService {
	rs := &ProjectsLocationsIdentityMappingStoresService{s: s}
	rs.Operations = NewProjectsLocationsIdentityMappingStoresOperationsService(s)
	return rs
}

type ProjectsLocationsIdentityMappingStoresService struct {
	s *Service

	Operations *ProjectsLocationsIdentityMappingStoresOperationsService
}

func NewProjectsLocationsIdentityMappingStoresOperationsService(s *Service) *ProjectsLocationsIdentityMappingStoresOperationsService {
	rs := &ProjectsLocationsIdentityMappingStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsIdentityMappingStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsRankingConfigsService(s *Service) *ProjectsLocationsRankingConfigsService {
	rs := &ProjectsLocationsRankingConfigsService{s: s}
	return rs
}

type ProjectsLocationsRankingConfigsService struct {
	s *Service
}

func NewProjectsLocationsSampleQuerySetsService(s *Service) *ProjectsLocationsSampleQuerySetsService {
	rs := &ProjectsLocationsSampleQuerySetsService{s: s}
	rs.Operations = NewProjectsLocationsSampleQuerySetsOperationsService(s)
	rs.SampleQueries = NewProjectsLocationsSampleQuerySetsSampleQueriesService(s)
	return rs
}

type ProjectsLocationsSampleQuerySetsService struct {
	s *Service

	Operations *ProjectsLocationsSampleQuerySetsOperationsService

	SampleQueries *ProjectsLocationsSampleQuerySetsSampleQueriesService
}

func NewProjectsLocationsSampleQuerySetsOperationsService(s *Service) *ProjectsLocationsSampleQuerySetsOperationsService {
	rs := &ProjectsLocationsSampleQuerySetsOperationsService{s: s}
	return rs
}

type ProjectsLocationsSampleQuerySetsOperationsService struct {
	s *Service
}

func NewProjectsLocationsSampleQuerySetsSampleQueriesService(s *Service) *ProjectsLocationsSampleQuerySetsSampleQueriesService {
	rs := &ProjectsLocationsSampleQuerySetsSampleQueriesService{s: s}
	return rs
}

type ProjectsLocationsSampleQuerySetsSampleQueriesService struct {
	s *Service
}

func NewProjectsLocationsUserEventsService(s *Service) *ProjectsLocationsUserEventsService {
	rs := &ProjectsLocationsUserEventsService{s: s}
	return rs
}

type ProjectsLocationsUserEventsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// GoogleApiDistribution: `Distribution` contains summary statistics for a
// population of values. It optionally contains a histogram representing the
// distribution of those values across a set of buckets. The summary statistics
// are the count, mean, sum of the squared deviation from the mean, the
// minimum, and the maximum of the set of population of values. The histogram
// is based on a sequence of buckets and gives a count of values that fall into
// each bucket. The boundaries of the buckets are given either explicitly or by
// formulas for buckets of fixed or exponentially increasing widths. Although
// it is not forbidden, it is generally a bad idea to include non-finite values
// (infinities or NaNs) in the population of values, as this will render the
// `mean` and `sum_of_squared_deviation` fields meaningless.
type GoogleApiDistribution struct {
	// BucketCounts: The number of values in each bucket of the histogram, as
	// described in `bucket_options`. If the distribution does not have a
	// histogram, then omit this field. If there is a histogram, then the sum of
	// the values in `bucket_counts` must equal the value in the `count` field of
	// the distribution. If present, `bucket_counts` should contain N values, where
	// N is the number of buckets specified in `bucket_options`. If you supply
	// fewer than N values, the remaining values are assumed to be 0. The order of
	// the values in `bucket_counts` follows the bucket numbering schemes described
	// for the three bucket types. The first value must be the count for the
	// underflow bucket (number 0). The next N-2 values are the counts for the
	// finite buckets (number 1 through N-2). The N'th value in `bucket_counts` is
	// the count for the overflow bucket (number N-1).
	BucketCounts googleapi.Int64s `json:"bucketCounts,omitempty"`
	// BucketOptions: Defines the histogram bucket boundaries. If the distribution
	// does not contain a histogram, then omit this field.
	BucketOptions *GoogleApiDistributionBucketOptions `json:"bucketOptions,omitempty"`
	// Count: The number of values in the population. Must be non-negative. This
	// value must equal the sum of the values in `bucket_counts` if a histogram is
	// provided.
	Count int64 `json:"count,omitempty,string"`
	// Exemplars: Must be in increasing order of `value` field.
	Exemplars []*GoogleApiDistributionExemplar `json:"exemplars,omitempty"`
	// Mean: The arithmetic mean of the values in the population. If `count` is
	// zero then this field must be zero.
	Mean float64 `json:"mean,omitempty"`
	// Range: If specified, contains the range of the population values. The field
	// must not be present if the `count` is zero.
	Range *GoogleApiDistributionRange `json:"range,omitempty"`
	// SumOfSquaredDeviation: The sum of squared deviations from the mean of the
	// values in the population. For values x_i this is: Sumi=1..n ((x_i - mean)^2)
	// Knuth, "The Art of Computer Programming", Vol. 2, page 232, 3rd edition
	// describes Welford's method for accumulating this sum in one pass. If `count`
	// is zero then this field must be zero.
	SumOfSquaredDeviation float64 `json:"sumOfSquaredDeviation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketCounts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketCounts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistribution) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistribution
	var s1 struct {
		Mean                  gensupport.JSONFloat64 `json:"mean"`
		SumOfSquaredDeviation gensupport.JSONFloat64 `json:"sumOfSquaredDeviation"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Mean = float64(s1.Mean)
	s.SumOfSquaredDeviation = float64(s1.SumOfSquaredDeviation)
	return nil
}

// GoogleApiDistributionBucketOptions: `BucketOptions` describes the bucket
// boundaries used to create a histogram for the distribution. The buckets can
// be in a linear sequence, an exponential sequence, or each bucket can be
// specified explicitly. `BucketOptions` does not include the number of values
// in each bucket. A bucket has an inclusive lower bound and exclusive upper
// bound for the values that are counted for that bucket. The upper bound of a
// bucket must be strictly greater than the lower bound. The sequence of N
// buckets for a distribution consists of an underflow bucket (number 0), zero
// or more finite buckets (number 1 through N - 2) and an overflow bucket
// (number N - 1). The buckets are contiguous: the lower bound of bucket i (i >
// 0) is the same as the upper bound of bucket i - 1. The buckets span the
// whole range of finite values: lower bound of the underflow bucket is
// -infinity and the upper bound of the overflow bucket is +infinity. The
// finite buckets are so-called because both bounds are finite.
type GoogleApiDistributionBucketOptions struct {
	// ExplicitBuckets: The explicit buckets.
	ExplicitBuckets *GoogleApiDistributionBucketOptionsExplicit `json:"explicitBuckets,omitempty"`
	// ExponentialBuckets: The exponential buckets.
	ExponentialBuckets *GoogleApiDistributionBucketOptionsExponential `json:"exponentialBuckets,omitempty"`
	// LinearBuckets: The linear bucket.
	LinearBuckets *GoogleApiDistributionBucketOptionsLinear `json:"linearBuckets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExplicitBuckets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExplicitBuckets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionBucketOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionBucketOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiDistributionBucketOptionsExplicit: Specifies a set of buckets with
// arbitrary widths. There are `size(bounds) + 1` (= N) buckets. Bucket `i` has
// the following boundaries: Upper bound (0 <= i < N-1): bounds[i] Lower bound
// (1 <= i < N); bounds[i - 1] The `bounds` field must contain at least one
// element. If `bounds` has only one element, then there are no finite buckets,
// and that single element is the common boundary of the overflow and underflow
// buckets.
type GoogleApiDistributionBucketOptionsExplicit struct {
	// Bounds: The values must be monotonically increasing.
	Bounds []float64 `json:"bounds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bounds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bounds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionBucketOptionsExplicit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionBucketOptionsExplicit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionBucketOptionsExplicit) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionBucketOptionsExplicit
	var s1 struct {
		Bounds []gensupport.JSONFloat64 `json:"bounds"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Bounds = make([]float64, len(s1.Bounds))
	for i := range s1.Bounds {
		s.Bounds[i] = float64(s1.Bounds[i])
	}
	return nil
}

// GoogleApiDistributionBucketOptionsExponential: Specifies an exponential
// sequence of buckets that have a width that is proportional to the value of
// the lower bound. Each bucket represents a constant relative uncertainty on a
// specific value in the bucket. There are `num_finite_buckets + 2` (= N)
// buckets. Bucket `i` has the following boundaries: Upper bound (0 <= i <
// N-1): scale * (growth_factor ^ i). Lower bound (1 <= i < N): scale *
// (growth_factor ^ (i - 1)).
type GoogleApiDistributionBucketOptionsExponential struct {
	// GrowthFactor: Must be greater than 1.
	GrowthFactor float64 `json:"growthFactor,omitempty"`
	// NumFiniteBuckets: Must be greater than 0.
	NumFiniteBuckets int64 `json:"numFiniteBuckets,omitempty"`
	// Scale: Must be greater than 0.
	Scale float64 `json:"scale,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GrowthFactor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GrowthFactor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionBucketOptionsExponential) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionBucketOptionsExponential
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionBucketOptionsExponential) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionBucketOptionsExponential
	var s1 struct {
		GrowthFactor gensupport.JSONFloat64 `json:"growthFactor"`
		Scale        gensupport.JSONFloat64 `json:"scale"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GrowthFactor = float64(s1.GrowthFactor)
	s.Scale = float64(s1.Scale)
	return nil
}

// GoogleApiDistributionBucketOptionsLinear: Specifies a linear sequence of
// buckets that all have the same width (except overflow and underflow). Each
// bucket represents a constant absolute uncertainty on the specific value in
// the bucket. There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has
// the following boundaries: Upper bound (0 <= i < N-1): offset + (width * i).
// Lower bound (1 <= i < N): offset + (width * (i - 1)).
type GoogleApiDistributionBucketOptionsLinear struct {
	// NumFiniteBuckets: Must be greater than 0.
	NumFiniteBuckets int64 `json:"numFiniteBuckets,omitempty"`
	// Offset: Lower bound of the first bucket.
	Offset float64 `json:"offset,omitempty"`
	// Width: Must be greater than 0.
	Width float64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumFiniteBuckets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumFiniteBuckets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionBucketOptionsLinear) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionBucketOptionsLinear
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionBucketOptionsLinear) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionBucketOptionsLinear
	var s1 struct {
		Offset gensupport.JSONFloat64 `json:"offset"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Offset = float64(s1.Offset)
	s.Width = float64(s1.Width)
	return nil
}

// GoogleApiDistributionExemplar: Exemplars are example points that may be used
// to annotate aggregated distribution values. They are metadata that gives
// information about a particular value added to a Distribution bucket, such as
// a trace ID that was active when a value was added. They may contain further
// information, such as a example values and timestamps, origin, etc.
type GoogleApiDistributionExemplar struct {
	// Attachments: Contextual information about the example value. Examples are:
	// Trace: type.googleapis.com/google.monitoring.v3.SpanContext Literal string:
	// type.googleapis.com/google.protobuf.StringValue Labels dropped during
	// aggregation: type.googleapis.com/google.monitoring.v3.DroppedLabels There
	// may be only a single attachment of any given message type in a single
	// exemplar, and this is enforced by the system.
	Attachments []googleapi.RawMessage `json:"attachments,omitempty"`
	// Timestamp: The observation (sampling) time of the above value.
	Timestamp string `json:"timestamp,omitempty"`
	// Value: Value of the exemplar point. This value determines to which bucket
	// the exemplar belongs.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attachments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attachments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionExemplar) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionExemplar
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionExemplar) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionExemplar
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// GoogleApiDistributionRange: The range of the population values.
type GoogleApiDistributionRange struct {
	// Max: The maximum of the population values.
	Max float64 `json:"max,omitempty"`
	// Min: The minimum of the population values.
	Min float64 `json:"min,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Max") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Max") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiDistributionRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiDistributionRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleApiDistributionRange) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleApiDistributionRange
	var s1 struct {
		Max gensupport.JSONFloat64 `json:"max"`
		Min gensupport.JSONFloat64 `json:"min"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Max = float64(s1.Max)
	s.Min = float64(s1.Min)
	return nil
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It should
// only be used for payload formats that can't be represented as JSON, such as
// raw binary or an HTML page. This message can be used both in streaming and
// non-streaming API methods in the request as well as the response. It can be
// used as a top-level request field, which is convenient if one wants to
// extract parameters from either the URL or HTTP template into the request
// fields and also want access to the raw HTTP body. Example: message
// GetResourceRequest { // A unique request id. string request_id = 1; // The
// raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; }
// service ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns
// (google.protobuf.Empty); } Example with streaming methods: service
// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream
// google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
// (stream google.api.HttpBody); } Use of this type only changes how the
// request and response bodies are handled, all other features will continue to
// work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the content type
	// of the body.
	ContentType string `json:"contentType,omitempty"`
	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`
	// Extensions: Application specific response metadata. Must be set in the first
	// response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiMetric: A specific metric, identified by specifying values for all
// of the labels of a `MetricDescriptor`.
type GoogleApiMetric struct {
	// Labels: The set of label values that uniquely identify this metric. All
	// labels listed in the `MetricDescriptor` must be assigned values.
	Labels map[string]string `json:"labels,omitempty"`
	// Type: An existing metric type, see google.api.MetricDescriptor. For example,
	// `custom.googleapis.com/invoice/paid/amount`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiMonitoredResource: An object representing a resource that can be
// used for monitoring, logging, billing, or other purposes. Examples include
// virtual machine instances, databases, and storage devices such as disks. The
// `type` field identifies a MonitoredResourceDescriptor object that describes
// the resource's schema. Information in the `labels` field identifies the
// actual resource and its attributes according to the schema. For example, a
// particular Compute Engine VM instance could be represented by the following
// object, because the MonitoredResourceDescriptor for "gce_instance" has
// labels "project_id", "instance_id" and "zone": { "type":
// "gce_instance", "labels": { "project_id": "my-project", "instance_id":
// "12345678901234", "zone": "us-central1-a" }}
type GoogleApiMonitoredResource struct {
	// Labels: Required. Values for all of the labels listed in the associated
	// monitored resource descriptor. For example, Compute Engine VM instances use
	// the labels "project_id", "instance_id", and "zone".
	Labels map[string]string `json:"labels,omitempty"`
	// Type: Required. The monitored resource type. This field must match the
	// `type` field of a MonitoredResourceDescriptor object. For example, the type
	// of a Compute Engine VM instance is `gce_instance`. Some descriptors include
	// the service name in the type; for example, the type of a Datastream stream
	// is `datastream.googleapis.com/Stream`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiMonitoredResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiMonitoredResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiMonitoredResourceMetadata: Auxiliary metadata for a
// MonitoredResource object. MonitoredResource objects contain the minimum set
// of information to uniquely identify a monitored resource instance. There is
// some other useful auxiliary metadata. Monitoring and Logging use an
// ingestion pipeline to extract metadata for cloud resources of all types, and
// store the metadata in this message.
type GoogleApiMonitoredResourceMetadata struct {
	// SystemLabels: Output only. Values for predefined system metadata labels.
	// System labels are a kind of metadata extracted by Google, including
	// "machine_image", "vpc", "subnet_id", "security_group", "name", etc. System
	// label values can be only strings, Boolean values, or a list of strings. For
	// example: { "name": "my-test-instance", "security_group": ["a", "b", "c"],
	// "spot_instance": false }
	SystemLabels googleapi.RawMessage `json:"systemLabels,omitempty"`
	// UserLabels: Output only. A map of user-defined metadata labels.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SystemLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SystemLabels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiMonitoredResourceMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiMonitoredResourceMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorContext: A description of the context
// in which an error occurred.
type GoogleCloudDiscoveryengineLoggingErrorContext struct {
	// HttpRequest: The HTTP request which was processed when the error was
	// triggered.
	HttpRequest *GoogleCloudDiscoveryengineLoggingHttpRequestContext `json:"httpRequest,omitempty"`
	// ReportLocation: The location in the source code where the decision was made
	// to report the error, usually the place where it was logged.
	ReportLocation *GoogleCloudDiscoveryengineLoggingSourceLocation `json:"reportLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HttpRequest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpRequest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorLog: An error log which is reported to
// the Error Reporting system.
type GoogleCloudDiscoveryengineLoggingErrorLog struct {
	// Context: A description of the context in which the error occurred.
	Context *GoogleCloudDiscoveryengineLoggingErrorContext `json:"context,omitempty"`
	// ImportPayload: The error payload that is populated on LRO import APIs.
	ImportPayload *GoogleCloudDiscoveryengineLoggingImportErrorContext `json:"importPayload,omitempty"`
	// Message: A message describing the error.
	Message string `json:"message,omitempty"`
	// RequestPayload: The API request payload, represented as a protocol buffer.
	// Most API request types are supported—for example: *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.DocumentService.Cre
	// ateDocumentRequest` *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.UserEventService.Wr
	// iteUserEventRequest`
	RequestPayload googleapi.RawMessage `json:"requestPayload,omitempty"`
	// ResponsePayload: The API response payload, represented as a protocol buffer.
	// This is used to log some "soft errors", where the response is valid but we
	// consider there are some quality issues like unjoined events. The following
	// API responses are supported, and no PII is included: *
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend` *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.WriteUserEvent` *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.CollectUserEvent`
	ResponsePayload googleapi.RawMessage `json:"responsePayload,omitempty"`
	// ServiceContext: The service context in which this error has occurred.
	ServiceContext *GoogleCloudDiscoveryengineLoggingServiceContext `json:"serviceContext,omitempty"`
	// Status: The RPC status associated with the error log.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingErrorLog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorLog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingHttpRequestContext: HTTP request data that
// is related to a reported error.
type GoogleCloudDiscoveryengineLoggingHttpRequestContext struct {
	// ResponseStatusCode: The HTTP response status code for the request.
	ResponseStatusCode int64 `json:"responseStatusCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResponseStatusCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResponseStatusCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingHttpRequestContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingHttpRequestContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingImportErrorContext: The error payload that
// is populated on LRO import APIs, including the following: *
// `google.cloud.discoveryengine.v1alpha.DocumentService.ImportDocuments` *
// `google.cloud.discoveryengine.v1alpha.UserEventService.ImportUserEvents`
type GoogleCloudDiscoveryengineLoggingImportErrorContext struct {
	// Document: The detailed content which caused the error on importing a
	// document.
	Document string `json:"document,omitempty"`
	// GcsPath: Google Cloud Storage file path of the import source. Can be set for
	// batch operation error.
	GcsPath string `json:"gcsPath,omitempty"`
	// LineNumber: Line number of the content in file. Should be empty for
	// permission or batch operation error.
	LineNumber string `json:"lineNumber,omitempty"`
	// Operation: The operation resource name of the LRO.
	Operation string `json:"operation,omitempty"`
	// UserEvent: The detailed content which caused the error on importing a user
	// event.
	UserEvent string `json:"userEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingImportErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingImportErrorContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingServiceContext: Describes a running service
// that sends errors.
type GoogleCloudDiscoveryengineLoggingServiceContext struct {
	// Service: An identifier of the service—for example,
	// `discoveryengine.googleapis.com`.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingServiceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingServiceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingSourceLocation: Indicates a location in the
// source code of the service for which errors are reported.
type GoogleCloudDiscoveryengineLoggingSourceLocation struct {
	// FunctionName: Human-readable name of a function or method—for example,
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend`.
	FunctionName string `json:"functionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FunctionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FunctionName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineLoggingSourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingSourceLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig: Configuration data for
// advance site search.
type GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig struct {
}

// GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.BatchCreateTargetSites
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse: Response message
// for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1TargetSite `json:"targetSites,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CmekConfig: Configurations used to enable CMEK
// data encryption with Cloud KMS keys.
type GoogleCloudDiscoveryengineV1CmekConfig struct {
	// IsDefault: Output only. The default CmekConfig for the Customer.
	IsDefault bool `json:"isDefault,omitempty"`
	// KmsKey: Kms key resource name which will be used to encrypt resources
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId
	// }`.
	KmsKey string `json:"kmsKey,omitempty"`
	// KmsKeyVersion: Kms key version resource name which will be used to encrypt
	// resources `/cryptoKeyVersions/{keyVersion}`.
	KmsKeyVersion string `json:"kmsKeyVersion,omitempty"`
	// LastRotationTimestampMicros: Output only. The timestamp of the last key
	// rotation.
	LastRotationTimestampMicros int64 `json:"lastRotationTimestampMicros,omitempty,string"`
	// Name: Required. Name of the CmekConfig, of the form
	// `projects/{project}/locations/{location}/cmekConfig` or
	// `projects/{project}/locations/{location}/cmekConfigs/{cmekConfig}`.
	Name string `json:"name,omitempty"`
	// State: Output only. State of the CmekConfig.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The CmekConfig state is unknown.
	//   "CREATING" - The CmekConfig is creating.
	//   "ACTIVE" - The CmekConfig can be used with DataStores.
	//   "KEY_ISSUE" - The CmekConfig is unavailable, most likely due to the KMS
	// Key being revoked.
	//   "DELETING" - The CmekConfig is deleting.
	//   "UNUSABLE" - The CmekConfig is not usable, most likely due to some
	// internal issue.
	//   "ACTIVE_ROTATING" - The KMS key version is being rotated.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsDefault") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDefault") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CmekConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CmekConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Condition: Defines circumstances to be checked
// before allowing a behavior
type GoogleCloudDiscoveryengineV1Condition struct {
	// ActiveTimeRange: Range of time(s) specifying when condition is active.
	// Maximum of 10 time ranges.
	ActiveTimeRange []*GoogleCloudDiscoveryengineV1ConditionTimeRange `json:"activeTimeRange,omitempty"`
	// QueryRegex: Optional. Query regex to match the whole search query. Cannot be
	// set when Condition.query_terms is set. This is currently supporting
	// promotion use case.
	QueryRegex string `json:"queryRegex,omitempty"`
	// QueryTerms: Search only A list of terms to match the query on. Cannot be set
	// when Condition.query_regex is set. Maximum of 10 query terms.
	QueryTerms []*GoogleCloudDiscoveryengineV1ConditionQueryTerm `json:"queryTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Condition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Condition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConditionQueryTerm: Matcher for search request
// query
type GoogleCloudDiscoveryengineV1ConditionQueryTerm struct {
	// FullMatch: Whether the search query needs to exactly match the query term.
	FullMatch bool `json:"fullMatch,omitempty"`
	// Value: The specific query value to match against Must be lowercase, must be
	// UTF-8. Can have at most 3 space separated terms if full_match is true.
	// Cannot be an empty string. Maximum length of 5000 characters.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConditionQueryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConditionQueryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ConditionTimeRange: Used for time-dependent
// conditions.
type GoogleCloudDiscoveryengineV1ConditionTimeRange struct {
	// EndTime: End of time range. Range is inclusive. Must be in the future.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time range. Range is inclusive.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ConditionTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ConditionTimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Control: Defines a conditioned behavior to
// employ during serving. Must be attached to a ServingConfig to be considered
// at serving time. Permitted actions dependent on `SolutionType`.
type GoogleCloudDiscoveryengineV1Control struct {
	// AssociatedServingConfigIds: Output only. List of all ServingConfig IDs this
	// control is attached to. May take up to 10 minutes to update after changes.
	AssociatedServingConfigIds []string `json:"associatedServingConfigIds,omitempty"`
	// BoostAction: Defines a boost-type control
	BoostAction *GoogleCloudDiscoveryengineV1ControlBoostAction `json:"boostAction,omitempty"`
	// Conditions: Determines when the associated action will trigger. Omit to
	// always apply the action. Currently only a single condition may be specified.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Conditions []*GoogleCloudDiscoveryengineV1Condition `json:"conditions,omitempty"`
	// DisplayName: Required. Human readable name. The identifier used in UI views.
	// Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an
	// INVALID ARGUMENT error is thrown.
	DisplayName string `json:"displayName,omitempty"`
	// FilterAction: Defines a filter-type control Currently not supported by
	// Recommendation
	FilterAction *GoogleCloudDiscoveryengineV1ControlFilterAction `json:"filterAction,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/dataStore/*/controls/*`
	Name string `json:"name,omitempty"`
	// PromoteAction: Promote certain links based on predefined trigger queries.
	// This now only supports basic site search.
	PromoteAction *GoogleCloudDiscoveryengineV1ControlPromoteAction `json:"promoteAction,omitempty"`
	// RedirectAction: Defines a redirect-type control.
	RedirectAction *GoogleCloudDiscoveryengineV1ControlRedirectAction `json:"redirectAction,omitempty"`
	// SolutionType: Required. Immutable. What solution the control belongs to.
	// Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT
	// error is thrown.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsAction: Treats a group of terms as synonyms of one another.
	SynonymsAction *GoogleCloudDiscoveryengineV1ControlSynonymsAction `json:"synonymsAction,omitempty"`
	// UseCases: Specifies the use case for the control. Affects what condition
	// fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only
	// allow one use case per control. Must be set when solution_type is
	// SolutionType.SOLUTION_TYPE_SEARCH.
	//
	// Possible values:
	//   "SEARCH_USE_CASE_UNSPECIFIED" - Value used when unset. Will not occur in
	// CSS.
	//   "SEARCH_USE_CASE_SEARCH" - Search use case. Expects the traffic has a
	// non-empty query.
	//   "SEARCH_USE_CASE_BROWSE" - Browse use case. Expects the traffic has an
	// empty query.
	UseCases []string `json:"useCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssociatedServingConfigIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedServingConfigIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Control) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Control
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlBoostAction: Adjusts order of products in
// returned list.
type GoogleCloudDiscoveryengineV1ControlBoostAction struct {
	// Boost: Required. Strength of the boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0 (No-op).
	Boost float64 `json:"boost,omitempty"`
	// DataStore: Required. Specifies which data store's documents can be boosted
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. Specifies which products to apply the boost to. If no
	// filter is provided all products will be boosted (No-op). Syntax
	// documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum
	// length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlBoostAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlBoostAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1ControlBoostAction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1ControlBoostAction
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1ControlFilterAction: Specified which products
// may be included in results. Uses same filter as boost.
type GoogleCloudDiscoveryengineV1ControlFilterAction struct {
	// DataStore: Required. Specifies which data store's documents can be filtered
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. A filter to apply on the matching condition results.
	// Required Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000
	// characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlFilterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlFilterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlPromoteAction: Promote certain links
// based on some trigger queries. Example: Promote shoe store link when
// searching for `shoe` keyword. The link can be outside of associated data
// store.
type GoogleCloudDiscoveryengineV1ControlPromoteAction struct {
	// DataStore: Required. Data store with which this promotion is attached to.
	DataStore string `json:"dataStore,omitempty"`
	// SearchLinkPromotion: Required. Promotion attached to this action.
	SearchLinkPromotion *GoogleCloudDiscoveryengineV1SearchLinkPromotion `json:"searchLinkPromotion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlPromoteAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlPromoteAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlRedirectAction: Redirects a shopper to
// the provided URI.
type GoogleCloudDiscoveryengineV1ControlRedirectAction struct {
	// RedirectUri: Required. The URI to which the shopper will be redirected.
	// Required. URI must have length equal or less than 2000 characters. Otherwise
	// an INVALID ARGUMENT error is thrown.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlRedirectAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ControlSynonymsAction: Creates a set of terms
// that will act as synonyms of one another. Example: "happy" will also be
// considered as "glad", "glad" will also be considered as "happy".
type GoogleCloudDiscoveryengineV1ControlSynonymsAction struct {
	// Synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must
	// specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ControlSynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ControlSynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateDataStoreMetadata: Metadata related to the
// progress of the DataStoreService.CreateDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateEngineMetadata: Metadata related to the
// progress of the EngineService.CreateEngine operation. This will be returned
// by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateSchemaMetadata: Metadata for Create Schema
// LRO.
type GoogleCloudDiscoveryengineV1CreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata: Metadata related to
// the progress of the SiteSearchEngineService.CreateTargetSite operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataStore: DataStore captures global settings
// and configs at the DataStore level.
type GoogleCloudDiscoveryengineV1DataStore struct {
	// AdvancedSiteSearchConfig: Optional. Configuration for advanced site search.
	AdvancedSiteSearchConfig *GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig `json:"advancedSiteSearchConfig,omitempty"`
	// BillingEstimation: Output only. Data size estimation for billing.
	BillingEstimation *GoogleCloudDiscoveryengineV1DataStoreBillingEstimation `json:"billingEstimation,omitempty"`
	// CmekConfig: Output only. CMEK-related information for the DataStore.
	CmekConfig *GoogleCloudDiscoveryengineV1CmekConfig `json:"cmekConfig,omitempty"`
	// ContentConfig: Immutable. The content config of the data store. If this
	// field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
	//
	// Possible values:
	//   "CONTENT_CONFIG_UNSPECIFIED" - Default value.
	//   "NO_CONTENT" - Only contains documents without any Document.content.
	//   "CONTENT_REQUIRED" - Only contains documents with Document.content.
	//   "PUBLIC_WEBSITE" - The data store is used for public website search.
	//   "GOOGLE_WORKSPACE" - The data store is used for workspace search. Details
	// of workspace data store are specified in the WorkspaceConfig.
	ContentConfig string `json:"contentConfig,omitempty"`
	// CreateTime: Output only. Timestamp the DataStore was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultSchemaId: Output only. The id of the default Schema asscociated to
	// this data store.
	DefaultSchemaId string `json:"defaultSchemaId,omitempty"`
	// DisplayName: Required. The data store display name. This field must be a
	// UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentProcessingConfig: Configuration for Document understanding and
	// enrichment.
	DocumentProcessingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfig `json:"documentProcessingConfig,omitempty"`
	// IndustryVertical: Immutable. The industry vertical that the data store
	// registers.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// KmsKeyName: Input only. The KMS key to be used to protect this DataStore at
	// creation time. Must be set for requests that need to comply with CMEK Org
	// Policy protections. If this field is set and processed successfully, the
	// DataStore will be protected by the KMS key, as indicated in the cmek_config
	// field.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// Name: Immutable. The full resource name of the data store. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. This field must be a UTF-8 encoded string with a length
	// limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ServingConfigDataStore: Optional. Stores serving config at DataStore level.
	ServingConfigDataStore *GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore `json:"servingConfigDataStore,omitempty"`
	// SolutionTypes: The solutions that the data store enrolls. Available
	// solutions for each industry_vertical: * `MEDIA`:
	// `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`:
	// `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be
	// enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionTypes []string `json:"solutionTypes,omitempty"`
	// StartingSchema: The start schema to use for this DataStore when provisioning
	// it. If unset, a default vertical specialized schema will be used. This field
	// is only used by CreateDataStore API, and will be ignored if used in other
	// APIs. This field will be omitted from all API responses including
	// CreateDataStore API. To retrieve a schema of a DataStore, use
	// SchemaService.GetSchema API instead. The provided schema will be validated
	// against certain rules on schema. Learn more from this doc
	// (https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
	StartingSchema *GoogleCloudDiscoveryengineV1Schema `json:"startingSchema,omitempty"`
	// WorkspaceConfig: Config to store data store type configuration for workspace
	// data. This must be set when DataStore.content_config is set as
	// DataStore.ContentConfig.GOOGLE_WORKSPACE.
	WorkspaceConfig *GoogleCloudDiscoveryengineV1WorkspaceConfig `json:"workspaceConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSiteSearchConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSiteSearchConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataStoreBillingEstimation: Estimation of data
// size per data store.
type GoogleCloudDiscoveryengineV1DataStoreBillingEstimation struct {
	// StructuredDataSize: Data size for structured data in terms of bytes.
	StructuredDataSize int64 `json:"structuredDataSize,omitempty,string"`
	// StructuredDataUpdateTime: Last updated timestamp for structured data.
	StructuredDataUpdateTime string `json:"structuredDataUpdateTime,omitempty"`
	// UnstructuredDataSize: Data size for unstructured data in terms of bytes.
	UnstructuredDataSize int64 `json:"unstructuredDataSize,omitempty,string"`
	// UnstructuredDataUpdateTime: Last updated timestamp for unstructured data.
	UnstructuredDataUpdateTime string `json:"unstructuredDataUpdateTime,omitempty"`
	// WebsiteDataSize: Data size for websites in terms of bytes.
	WebsiteDataSize int64 `json:"websiteDataSize,omitempty,string"`
	// WebsiteDataUpdateTime: Last updated timestamp for websites.
	WebsiteDataUpdateTime string `json:"websiteDataUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StructuredDataSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StructuredDataSize") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataStoreBillingEstimation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataStoreBillingEstimation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore: Stores
// information regarding the serving configurations at DataStore level.
type GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore struct {
	// DisabledForServing: If set true, the DataStore will not be available for
	// serving search requests.
	DisabledForServing bool `json:"disabledForServing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisabledForServing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisabledForServing") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata: Metadata related to the
// progress of the DataStoreService.DeleteDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteEngineMetadata: Metadata related to the
// progress of the EngineService.DeleteEngine operation. This will be returned
// by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteSchemaMetadata: Metadata for DeleteSchema
// LRO.
type GoogleCloudDiscoveryengineV1DeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata: Metadata related to
// the progress of the SiteSearchEngineService.DeleteTargetSite operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfig: A singleton resource
// of DataStore. If it's empty when DataStore is created and DataStore is set
// to DataStore.ContentConfig.CONTENT_REQUIRED, the default parser will default
// to digital parser.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfig struct {
	// ChunkingConfig: Whether chunking mode is enabled.
	ChunkingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig `json:"chunkingConfig,omitempty"`
	// DefaultParsingConfig: Configurations for default Document parser. If not
	// specified, we will configure it as default DigitalParsingConfig, and the
	// default parsing config will be applied to all file types for Document
	// parsing.
	DefaultParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig `json:"defaultParsingConfig,omitempty"`
	// Name: The full resource name of the Document Processing Config. Format:
	// `projects/*/locations/*/collections/*/dataStores/*/documentProcessingConfig`.
	Name string `json:"name,omitempty"`
	// ParsingConfigOverrides: Map from file type to override the default parsing
	// configuration based on the file type. Supported keys: * `pdf`: Override
	// parsing config for PDF files, either digital parsing, ocr parsing or layout
	// parsing is supported. * `html`: Override parsing config for HTML files, only
	// digital parsing and layout parsing are supported. * `docx`: Override parsing
	// config for DOCX files, only digital parsing and layout parsing are
	// supported. * `pptx`: Override parsing config for PPTX files, only digital
	// parsing and layout parsing are supported. * `xlsm`: Override parsing config
	// for XLSM files, only digital parsing and layout parsing are supported. *
	// `xlsx`: Override parsing config for XLSX files, only digital parsing and
	// layout parsing are supported.
	ParsingConfigOverrides map[string]GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig `json:"parsingConfigOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig:
// Configuration for chunking config.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig struct {
	// LayoutBasedChunkingConfig: Configuration for the layout based chunking.
	LayoutBasedChunkingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig `json:"layoutBasedChunkingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LayoutBasedChunkingConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LayoutBasedChunkingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBased
// ChunkingConfig: Configuration for the layout based chunking.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig struct {
	// ChunkSize: The token size limit for each chunk. Supported values: 100-500
	// (inclusive). Default value: 500.
	ChunkSize int64 `json:"chunkSize,omitempty"`
	// IncludeAncestorHeadings: Whether to include appending different levels of
	// headings to chunks from the middle of the document to prevent context loss.
	// Default value: False.
	IncludeAncestorHeadings bool `json:"includeAncestorHeadings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig: Related
// configurations applied to a specific type of document parser.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig struct {
	// DigitalParsingConfig: Configurations applied to digital parser.
	DigitalParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsingConfig `json:"digitalParsingConfig,omitempty"`
	// LayoutParsingConfig: Configurations applied to layout parser.
	LayoutParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig `json:"layoutParsingConfig,omitempty"`
	// OcrParsingConfig: Configurations applied to OCR parser. Currently it only
	// applies to PDFs.
	OcrParsingConfig *GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig `json:"ocrParsingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DigitalParsingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DigitalParsingConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsi
// ngConfig: The digital parsing configurations for documents.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsin
// gConfig: The layout parsing configurations for documents.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingCo
// nfig: The OCR parsing configurations for documents.
type GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig struct {
	// EnhancedDocumentElements: [DEPRECATED] This field is deprecated. To use the
	// additional enhanced document elements processing, please switch to
	// `layout_parsing_config`.
	EnhancedDocumentElements []string `json:"enhancedDocumentElements,omitempty"`
	// UseNativeText: If true, will use native text instead of OCR text on pages
	// containing native text.
	UseNativeText bool `json:"useNativeText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnhancedDocumentElements")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnhancedDocumentElements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1Engine: Metadata that describes the training and
// serving parameters of an Engine.
type GoogleCloudDiscoveryengineV1Engine struct {
	// ChatEngineConfig: Configurations for the Chat Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineConfig *GoogleCloudDiscoveryengineV1EngineChatEngineConfig `json:"chatEngineConfig,omitempty"`
	// ChatEngineMetadata: Output only. Additional information of the Chat Engine.
	// Only applicable if solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineMetadata *GoogleCloudDiscoveryengineV1EngineChatEngineMetadata `json:"chatEngineMetadata,omitempty"`
	// CommonConfig: Common config spec that specifies the metadata of the engine.
	CommonConfig *GoogleCloudDiscoveryengineV1EngineCommonConfig `json:"commonConfig,omitempty"`
	// CreateTime: Output only. Timestamp the Recommendation Engine was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataStoreIds: The data stores associated with this engine. For
	// SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they
	// can only associate with at most one data store. If solution_type is
	// SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be
	// associated here. Note that when used in CreateEngineRequest, one DataStore
	// id must be provided as the system will use it for necessary initializations.
	DataStoreIds []string `json:"dataStoreIds,omitempty"`
	// DisableAnalytics: Optional. Whether to disable analytics for searches
	// performed on this engine.
	DisableAnalytics bool `json:"disableAnalytics,omitempty"`
	// DisplayName: Required. The display name of the engine. Should be human
	// readable. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// IndustryVertical: The industry vertical that the engine registers. The
	// restriction of the Engine industry vertical is based on DataStore: Vertical
	// on Engine has to match vertical of the DataStore linked to the engine.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// Name: Immutable. The fully qualified resource name of the engine. This field
	// must be a UTF-8 encoded string with a length limit of 1024 characters.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}` engine should be 1-63 characters, and valid characters are /a-z0-9*/.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	Name string `json:"name,omitempty"`
	// SearchEngineConfig: Configurations for the Search Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_SEARCH.
	SearchEngineConfig *GoogleCloudDiscoveryengineV1EngineSearchEngineConfig `json:"searchEngineConfig,omitempty"`
	// SolutionType: Required. The solutions of the engine.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Engine was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChatEngineConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChatEngineConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Engine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Engine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineChatEngineConfig: Configurations for a
// Chat Engine.
type GoogleCloudDiscoveryengineV1EngineChatEngineConfig struct {
	// AgentCreationConfig: The configurationt generate the Dialogflow agent that
	// is associated to this Engine. Note that these configurations are one-time
	// consumed by and passed to Dialogflow service. It means they cannot be
	// retrieved using EngineService.GetEngine or EngineService.ListEngines API
	// after engine creation.
	AgentCreationConfig *GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig `json:"agentCreationConfig,omitempty"`
	// DialogflowAgentToLink: The resource name of an exist Dialogflow agent to
	// link to this Chat Engine. Customers can either provide
	// `agent_creation_config` to create agent or provide an agent name that links
	// the agent with the Chat engine. Format: `projects//locations//agents/`. Note
	// that the `dialogflow_agent_to_link` are one-time consumed by and passed to
	// Dialogflow service. It means they cannot be retrieved using
	// EngineService.GetEngine or EngineService.ListEngines API after engine
	// creation. Use ChatEngineMetadata.dialogflow_agent for actual agent
	// association after Engine is created.
	DialogflowAgentToLink string `json:"dialogflowAgentToLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCreationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCreationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineChatEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineChatEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig:
// Configurations for generating a Dialogflow agent. Note that these
// configurations are one-time consumed by and passed to Dialogflow service. It
// means they cannot be retrieved using EngineService.GetEngine or
// EngineService.ListEngines API after engine creation.
type GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig struct {
	// Business: Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `json:"business,omitempty"`
	// DefaultLanguageCode: Required. The default language of the agent as a
	// language tag. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// Location: Agent location for Agent creation, supported values: global/us/eu.
	// If not provided, us Engine will create Agent using us-central-1 by default;
	// eu Engine will create Agent using eu-west-1 by default.
	Location string `json:"location,omitempty"`
	// TimeZone: Required. The time zone of the agent from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Business") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Business") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineChatEngineMetadata: Additional information
// of a Chat Engine. Fields in this message are output only.
type GoogleCloudDiscoveryengineV1EngineChatEngineMetadata struct {
	// DialogflowAgent: The resource name of a Dialogflow agent, that this Chat
	// Engine refers to. Format: `projects//locations//agents/`.
	DialogflowAgent string `json:"dialogflowAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowAgent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineChatEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineChatEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineCommonConfig: Common configurations for an
// Engine.
type GoogleCloudDiscoveryengineV1EngineCommonConfig struct {
	// CompanyName: The name of the company, business or entity that is associated
	// with the engine. Setting this may help improve LLM related features.
	CompanyName string `json:"companyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompanyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompanyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineCommonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineCommonConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1EngineSearchEngineConfig: Configurations for a
// Search Engine.
type GoogleCloudDiscoveryengineV1EngineSearchEngineConfig struct {
	// SearchAddOns: The add-on that this search engine enables.
	//
	// Possible values:
	//   "SEARCH_ADD_ON_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_ADD_ON_LLM" - Large language model add-on.
	SearchAddOns []string `json:"searchAddOns,omitempty"`
	// SearchTier: The search feature tier of this engine. Different tiers might
	// have different pricing. To learn more, check the pricing documentation.
	// Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
	//
	// Possible values:
	//   "SEARCH_TIER_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_TIER_STANDARD" - Standard tier.
	//   "SEARCH_TIER_ENTERPRISE" - Enterprise tier.
	SearchTier string `json:"searchTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchAddOns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchAddOns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1EngineSearchEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1EngineSearchEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata: Metadata
// related to the progress of the ImportCompletionSuggestions operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of CompletionSuggestions that failed to be imported.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of CompletionSuggestions successfully imported.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse: Response of
// the CompletionService.ImportCompletionSuggestions method. If the long
// running operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse struct {
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsMetadata: Metadata related to the
// progress of the ImportDocuments operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: Total count of entries that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsResponse: Response of the
// ImportDocumentsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudDiscoveryengineV1ImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportErrorConfig: Configuration of destination
// for Import related errors.
type GoogleCloudDiscoveryengineV1ImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors are written to sharded files
	// in this directory, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportErrorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the ImportSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse:
// Response message for CompletionService.ImportSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// FailedEntriesCount: Count of deny list entries that failed to be imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`
	// ImportedEntriesCount: Count of deny list entries successfully imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsMetadata: Metadata related to
// the progress of the Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudDiscoveryengineV1ImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// JoinedEventsCount: Count of user events imported with complete existing
	// Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Project: Metadata and configurations for a
// Google Cloud project in the service.
type GoogleCloudDiscoveryengineV1Project struct {
	// CreateTime: Output only. The timestamp when this project is created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. Full resource name of the project, for example
	// `projects/{project}`. Note that when making requests, project number and
	// project id are both acceptable, but the server will always respond in
	// project number.
	Name string `json:"name,omitempty"`
	// ProvisionCompletionTime: Output only. The timestamp when this project is
	// successfully provisioned. Empty value means this project is still
	// provisioning and is not ready for use.
	ProvisionCompletionTime string `json:"provisionCompletionTime,omitempty"`
	// ServiceTermsMap: Output only. A map of terms of services. The key is the
	// `id` of ServiceTerms.
	ServiceTermsMap map[string]GoogleCloudDiscoveryengineV1ProjectServiceTerms `json:"serviceTermsMap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Project) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Project
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProjectServiceTerms: Metadata about the terms of
// service.
type GoogleCloudDiscoveryengineV1ProjectServiceTerms struct {
	// AcceptTime: The last time when the project agreed to the terms of service.
	AcceptTime string `json:"acceptTime,omitempty"`
	// DeclineTime: The last time when the project declined or revoked the
	// agreement to terms of service.
	DeclineTime string `json:"declineTime,omitempty"`
	// Id: The unique identifier of this terms of service. Available terms: *
	// `GA_DATA_USE_TERMS`: Terms for data use
	// (https://cloud.google.com/retail/data-use-terms). When using this as `id`,
	// the acceptable version to provide is `2022-11-23`.
	Id string `json:"id,omitempty"`
	// State: Whether the project has accepted/rejected the service terms or it is
	// still pending.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value of the enum. This value is not
	// actually used.
	//   "TERMS_ACCEPTED" - The project has given consent to the terms of service.
	//   "TERMS_PENDING" - The project is pending to review and accept the terms of
	// service.
	//   "TERMS_DECLINED" - The project has declined or revoked the agreement to
	// terms of service.
	State string `json:"state,omitempty"`
	// Version: The version string of the terms of service. For acceptable values,
	// see the comments for id above.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ProjectServiceTerms) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ProjectServiceTerms
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ProvisionProjectMetadata: Metadata associated
// with a project provision operation.
type GoogleCloudDiscoveryengineV1ProvisionProjectMetadata struct {
}

// GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata: Metadata
// related to the progress of the PurgeCompletionSuggestions operation. This is
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse: Response
// message for CompletionService.PurgeCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeSucceeded: Whether the completion suggestions were successfully purged.
	PurgeSucceeded bool `json:"purgeSucceeded,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata: Metadata related to the
// progress of the PurgeDocuments operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// IgnoredCount: Count of entries that were ignored as entries were not found.
	IgnoredCount int64 `json:"ignoredCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsResponse: Response message for
// DocumentService.PurgeDocuments method. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of document names that will be deleted. Only populated
	// if `force` is set to false. A max of 100 names will be returned and the
	// names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata: Metadata
// related to the progress of the PurgeSuggestionDenyListEntries operation.
// This is returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse: Response
// message for CompletionService.PurgeSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Schema: Defines the structure and layout of a
// type of document data.
type GoogleCloudDiscoveryengineV1Schema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`
	// Name: Immutable. The full resource name of the schema, in the format of
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/schemas/{schema}`. This field must be a UTF-8 encoded string
	// with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JsonSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1Schema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Schema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchLinkPromotion: Promotion proto includes
// uri and other helping information to display the promotion.
type GoogleCloudDiscoveryengineV1SearchLinkPromotion struct {
	// Description: Optional. The Promotion description. Maximum length: 200
	// characters.
	Description string `json:"description,omitempty"`
	// Enabled: Optional. The enabled promotion will be returned for any serving
	// configs associated with the parent of the control this promotion is attached
	// to. This flag is used for basic site search only.
	Enabled bool `json:"enabled,omitempty"`
	// ImageUri: Optional. The promotion thumbnail image url.
	ImageUri string `json:"imageUri,omitempty"`
	// Title: Required. The title of the promotion. Maximum length: 160 characters.
	Title string `json:"title,omitempty"`
	// Uri: Required. The URL for the page the user wants to promote.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchLinkPromotion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchLinkPromotion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec: A specification
// for configuring the behavior of content search.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec struct {
	// ChunkSpec: Specifies the chunk spec to be returned from the search response.
	// Only available if the SearchRequest.ContentSearchSpec.search_result_mode is
	// set to CHUNKS
	ChunkSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec `json:"chunkSpec,omitempty"`
	// ExtractiveContentSpec: If there is no extractive_content_spec provided,
	// there will be no extractive answer in the search response.
	ExtractiveContentSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec `json:"extractiveContentSpec,omitempty"`
	// SearchResultMode: Specifies the search result mode. If unspecified, the
	// search result mode defaults to `DOCUMENTS`.
	//
	// Possible values:
	//   "SEARCH_RESULT_MODE_UNSPECIFIED" - Default value.
	//   "DOCUMENTS" - Returns documents in the search result.
	//   "CHUNKS" - Returns chunks in the search result. Only available if the
	// DocumentProcessingConfig.chunking_config is specified.
	SearchResultMode string `json:"searchResultMode,omitempty"`
	// SnippetSpec: If `snippetSpec` is not specified, snippets are not included in
	// the search response.
	SnippetSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec `json:"snippetSpec,omitempty"`
	// SummarySpec: If `summarySpec` is not specified, summaries are not included
	// in the search response.
	SummarySpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec:
// Specifies the chunk spec to be returned from the search response. Only
// available if the SearchRequest.ContentSearchSpec.search_result_mode is set
// to CHUNKS
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec struct {
	// NumNextChunks: The number of next chunks to be returned of the current
	// chunk. The maximum allowed value is 3. If not specified, no next chunks will
	// be returned.
	NumNextChunks int64 `json:"numNextChunks,omitempty"`
	// NumPreviousChunks: The number of previous chunks to be returned of the
	// current chunk. The maximum allowed value is 3. If not specified, no previous
	// chunks will be returned.
	NumPreviousChunks int64 `json:"numPreviousChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumNextChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumNextChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSp
// ec: A specification for configuring the extractive content in a search
// response.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec struct {
	// MaxExtractiveAnswerCount: The maximum number of extractive answers returned
	// in each search result. An extractive answer is a verbatim answer extracted
	// from the original document, which provides a precise and contextually
	// relevant answer to the search query. If the number of matching answers is
	// less than the `max_extractive_answer_count`, return all of the answers.
	// Otherwise, return the `max_extractive_answer_count`. At most five answers
	// are returned for each SearchResult.
	MaxExtractiveAnswerCount int64 `json:"maxExtractiveAnswerCount,omitempty"`
	// MaxExtractiveSegmentCount: The max number of extractive segments returned in
	// each search result. Only applied if the DataStore is set to
	// DataStore.ContentConfig.CONTENT_REQUIRED or DataStore.solution_types is
	// SOLUTION_TYPE_CHAT. An extractive segment is a text segment extracted from
	// the original document that is relevant to the search query, and, in general,
	// more verbose than an extractive answer. The segment could then be used as
	// input for LLMs to generate summaries and answers. If the number of matching
	// segments is less than `max_extractive_segment_count`, return all of the
	// segments. Otherwise, return the `max_extractive_segment_count`.
	MaxExtractiveSegmentCount int64 `json:"maxExtractiveSegmentCount,omitempty"`
	// NumNextSegments: Return at most `num_next_segments` segments after each
	// selected segments.
	NumNextSegments int64 `json:"numNextSegments,omitempty"`
	// NumPreviousSegments: Specifies whether to also include the adjacent from
	// each selected segments. Return at most `num_previous_segments` segments
	// before each selected segments.
	NumPreviousSegments int64 `json:"numPreviousSegments,omitempty"`
	// ReturnExtractiveSegmentScore: Specifies whether to return the confidence
	// score from the extractive segments in each search result. This feature is
	// available only for new or allowlisted data stores. To allowlist your data
	// store, contact your Customer Engineer. The default value is `false`.
	ReturnExtractiveSegmentScore bool `json:"returnExtractiveSegmentScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxExtractiveAnswerCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxExtractiveAnswerCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec: A
// specification for configuring snippets in a search response.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec struct {
	// MaxSnippetCount: [DEPRECATED] This field is deprecated. To control snippet
	// return, use `return_snippet` field. For backwards compatibility, we will
	// return snippet if max_snippet_count > 0.
	MaxSnippetCount int64 `json:"maxSnippetCount,omitempty"`
	// ReferenceOnly: [DEPRECATED] This field is deprecated and will have no affect
	// on the snippet.
	ReferenceOnly bool `json:"referenceOnly,omitempty"`
	// ReturnSnippet: If `true`, then return snippet. If no snippet can be
	// generated, we return "No snippet is available for this page." A
	// `snippet_status` with `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be
	// returned.
	ReturnSnippet bool `json:"returnSnippet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxSnippetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxSnippetCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec: A
// specification for configuring a summary returned in a search response.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec struct {
	// IgnoreAdversarialQuery: Specifies whether to filter out adversarial queries.
	// The default value is `false`. Google employs search-query classification to
	// detect adversarial queries. No summary is returned if the search query is
	// classified as an adversarial query. For example, a user might ask a question
	// regarding negative comments about the company or submit a query designed to
	// generate unsafe, policy-violating output. If this field is set to `true`, we
	// skip generating summaries for adversarial queries and return fallback
	// messages instead.
	IgnoreAdversarialQuery bool `json:"ignoreAdversarialQuery,omitempty"`
	// IgnoreJailBreakingQuery: Optional. Specifies whether to filter out
	// jail-breaking queries. The default value is `false`. Google employs
	// search-query classification to detect jail-breaking queries. No summary is
	// returned if the search query is classified as a jail-breaking query. A user
	// might add instructions to the query to change the tone, style, language,
	// content of the answer, or ask the model to act as a different entity, e.g.
	// "Reply in the tone of a competing company's CEO". If this field is set to
	// `true`, we skip generating summaries for jail-breaking queries and return
	// fallback messages instead.
	IgnoreJailBreakingQuery bool `json:"ignoreJailBreakingQuery,omitempty"`
	// IgnoreLowRelevantContent: Specifies whether to filter out queries that have
	// low relevance. The default value is `false`. If this field is set to
	// `false`, all search results are used regardless of relevance to generate
	// answers. If set to `true`, only queries with high relevance search results
	// will generate answers.
	IgnoreLowRelevantContent bool `json:"ignoreLowRelevantContent,omitempty"`
	// IgnoreNonSummarySeekingQuery: Specifies whether to filter out queries that
	// are not summary-seeking. The default value is `false`. Google employs
	// search-query classification to detect summary-seeking queries. No summary is
	// returned if the search query is classified as a non-summary seeking query.
	// For example, `why is the sky blue` and `Who is the best soccer player in the
	// world?` are summary-seeking queries, but `SFO airport` and `world cup 2026`
	// are not. They are most likely navigational queries. If this field is set to
	// `true`, we skip generating summaries for non-summary seeking queries and
	// return fallback messages instead.
	IgnoreNonSummarySeekingQuery bool `json:"ignoreNonSummarySeekingQuery,omitempty"`
	// IncludeCitations: Specifies whether to include citations in the summary. The
	// default value is `false`. When this field is set to `true`, summaries
	// include in-line citation numbers. Example summary including citations:
	// BigQuery is Google Cloud's fully managed and completely serverless
	// enterprise data warehouse [1]. BigQuery supports all data types, works
	// across clouds, and has built-in machine learning and business intelligence,
	// all within a unified platform [2, 3]. The citation numbers refer to the
	// returned search results and are 1-indexed. For example, [1] means that the
	// sentence is attributed to the first search result. [2, 3] means that the
	// sentence is attributed to both the second and third search results.
	IncludeCitations bool `json:"includeCitations,omitempty"`
	// LanguageCode: Language code for Summary. Use language tags defined by BCP47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an
	// experimental feature.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelPromptSpec: If specified, the spec will be used to modify the prompt
	// provided to the LLM.
	ModelPromptSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec `json:"modelPromptSpec,omitempty"`
	// ModelSpec: If specified, the spec will be used to modify the model
	// specification provided to the LLM.
	ModelSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec `json:"modelSpec,omitempty"`
	// SummaryResultCount: The number of top results to generate the summary from.
	// If the number of results returned is less than `summaryResultCount`, the
	// summary is generated from all of the results. At most 10 results for
	// documents mode, or 50 for chunks mode, can be used to generate a summary.
	// The chunks mode is used when
	// SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
	SummaryResultCount int64 `json:"summaryResultCount,omitempty"`
	// UseSemanticChunks: If true, answer will be generated from most relevant
	// chunks from top search results. This feature will improve summary quality.
	// Note that with this feature enabled, not all top search results will be
	// referenced and included in the reference list, so the citation source index
	// only points to the search results listed in the reference list.
	UseSemanticChunks bool `json:"useSemanticChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPro
// mptSpec: Specification of the prompt to use with the model.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec struct {
	// Preamble: Text at the beginning of the prompt that instructs the assistant.
	// Examples are available in the user guide.
	Preamble string `json:"preamble,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Preamble") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Preamble") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpe
// c: Specification of the model.
type GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec struct {
	// Version: The model version used to generate the summary. Supported values
	// are: * `stable`: string. Default value when no value is specified. Uses a
	// generally available, fine-tuned model. For more information, see Answer
	// generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	// * `preview`: string. (Public preview) Uses a preview model. For more
	// information, see Answer generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ServingConfig: Configures metadata that is used
// to generate serving time results (e.g. search results or recommendation
// predictions). The ServingConfig is passed in the search and predict request
// and generates results.
type GoogleCloudDiscoveryengineV1ServingConfig struct {
	// BoostControlIds: Boost controls to use in serving path. All triggered boost
	// controls will be applied. Boost controls must be in the same data store as
	// the serving config. Maximum of 20 boost controls.
	BoostControlIds []string `json:"boostControlIds,omitempty"`
	// CreateTime: Output only. ServingConfig created timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The human readable serving config display name. Used
	// in Discovery UI. This field must be a UTF-8 encoded string with a length
	// limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DissociateControlIds: Condition do not associate specifications. If multiple
	// do not associate conditions match, all matching do not associate controls in
	// the list will execute. Order does not matter. Maximum number of
	// specifications is 100. Can only be set if SolutionType is
	// SOLUTION_TYPE_SEARCH.
	DissociateControlIds []string `json:"dissociateControlIds,omitempty"`
	// DiversityLevel: How much diversity to use in recommendation model results
	// e.g. `medium-diversity` or `high-diversity`. Currently supported values: *
	// `no-diversity` * `low-diversity` * `medium-diversity` * `high-diversity` *
	// `auto-diversity` If not specified, we choose default based on recommendation
	// model type. Default value: `no-diversity`. Can only be set if SolutionType
	// is SOLUTION_TYPE_RECOMMENDATION.
	DiversityLevel string `json:"diversityLevel,omitempty"`
	// FilterControlIds: Filter controls to use in serving path. All triggered
	// filter controls will be applied. Filter controls must be in the same data
	// store as the serving config. Maximum of 20 filter controls.
	FilterControlIds []string `json:"filterControlIds,omitempty"`
	// GenericConfig: The GenericConfig of the serving configuration.
	GenericConfig *GoogleCloudDiscoveryengineV1ServingConfigGenericConfig `json:"genericConfig,omitempty"`
	// IgnoreControlIds: Condition ignore specifications. If multiple ignore
	// conditions match, all matching ignore controls in the list will execute.
	// Order does not matter. Maximum number of specifications is 100.
	IgnoreControlIds []string `json:"ignoreControlIds,omitempty"`
	// MediaConfig: The MediaConfig of the serving configuration.
	MediaConfig *GoogleCloudDiscoveryengineV1ServingConfigMediaConfig `json:"mediaConfig,omitempty"`
	// ModelId: The id of the model to use at serving time. Currently only
	// RecommendationModels are supported. Can be changed but only to a compatible
	// model (e.g. others-you-may-like CTR to others-you-may-like CVR). Required
	// when SolutionType is SOLUTION_TYPE_RECOMMENDATION.
	ModelId string `json:"modelId,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/{location}/collections/{collection_id}/engines/
	// {engine_id}/servingConfigs/{serving_config_id}`
	Name string `json:"name,omitempty"`
	// OnewaySynonymsControlIds: Condition oneway synonyms specifications. If
	// multiple oneway synonyms conditions match, all matching oneway synonyms
	// controls in the list will execute. Maximum number of specifications is 100.
	// Can only be set if SolutionType is SOLUTION_TYPE_SEARCH.
	OnewaySynonymsControlIds []string `json:"onewaySynonymsControlIds,omitempty"`
	// PromoteControlIds: Condition promote specifications. Maximum number of
	// specifications is 100.
	PromoteControlIds []string `json:"promoteControlIds,omitempty"`
	// RankingExpression: The ranking expression controls the customized ranking on
	// retrieval documents. To leverage this, document embedding is required. The
	// ranking expression setting in ServingConfig applies to all search requests
	// served by the serving config. However, if SearchRequest.ranking_expression
	// is specified, it overrides the ServingConfig ranking expression. The ranking
	// expression is a single function or multiple functions that are joined by
	// "+". * ranking_expression = function, { " + ", function }; Supported
	// functions: * double * relevance_score * double *
	// dotProduct(embedding_field_path) Function variables: * `relevance_score`:
	// pre-defined keywords, used for measure relevance between query and document.
	// * `embedding_field_path`: the document embedding field used with query
	// embedding vector. * `dotProduct`: embedding function between
	// embedding_field_path and query embedding vector. Example ranking expression:
	// If document has an embedding field doc_embedding, the ranking expression
	// could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
	RankingExpression string `json:"rankingExpression,omitempty"`
	// RedirectControlIds: IDs of the redirect controls. Only the first triggered
	// redirect action is applied, even if multiple apply. Maximum number of
	// specifications is 100. Can only be set if SolutionType is
	// SOLUTION_TYPE_SEARCH.
	RedirectControlIds []string `json:"redirectControlIds,omitempty"`
	// ReplacementControlIds: Condition replacement specifications. Applied
	// according to the order in the list. A previously replaced term can not be
	// re-replaced. Maximum number of specifications is 100. Can only be set if
	// SolutionType is SOLUTION_TYPE_SEARCH.
	ReplacementControlIds []string `json:"replacementControlIds,omitempty"`
	// SolutionType: Required. Immutable. Specifies the solution type that a
	// serving config can be associated with.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsControlIds: Condition synonyms specifications. If multiple synonyms
	// conditions match, all matching synonyms controls in the list will execute.
	// Maximum number of specifications is 100. Can only be set if SolutionType is
	// SOLUTION_TYPE_SEARCH.
	SynonymsControlIds []string `json:"synonymsControlIds,omitempty"`
	// UpdateTime: Output only. ServingConfig updated timestamp.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostControlIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostControlIds") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ServingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ServingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ServingConfigGenericConfig: Specifies the
// configurations needed for Generic Discovery.Currently we support: *
// `content_search_spec`: configuration for generic content search.
type GoogleCloudDiscoveryengineV1ServingConfigGenericConfig struct {
	// ContentSearchSpec: Specifies the expected behavior of content search. Only
	// valid for content-search enabled data store.
	ContentSearchSpec *GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec `json:"contentSearchSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentSearchSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentSearchSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ServingConfigGenericConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ServingConfigGenericConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ServingConfigMediaConfig: Specifies the
// configurations needed for Media Discovery. Currently we support: *
// `demote_content_watched`: Threshold for watched content demotion. Customers
// can specify if using watched content demotion or use viewed detail page.
// Using the content watched demotion, customers need to specify the watched
// minutes or percentage exceeds the threshold, the content will be demoted in
// the recommendation result. * `promote_fresh_content`: cutoff days for fresh
// content promotion. Customers can specify if using content freshness
// promotion. If the content was published within the cutoff days, the content
// will be promoted in the recommendation result. Can only be set if
// SolutionType is SOLUTION_TYPE_RECOMMENDATION.
type GoogleCloudDiscoveryengineV1ServingConfigMediaConfig struct {
	// ContentFreshnessCutoffDays: Specifies the content freshness used for
	// recommendation result. Contents will be demoted if contents were published
	// for more than content freshness cutoff days.
	ContentFreshnessCutoffDays int64 `json:"contentFreshnessCutoffDays,omitempty"`
	// ContentWatchedPercentageThreshold: Specifies the content watched percentage
	// threshold for demotion. Threshold value must be between [0, 1.0] inclusive.
	ContentWatchedPercentageThreshold float64 `json:"contentWatchedPercentageThreshold,omitempty"`
	// ContentWatchedSecondsThreshold: Specifies the content watched minutes
	// threshold for demotion.
	ContentWatchedSecondsThreshold float64 `json:"contentWatchedSecondsThreshold,omitempty"`
	// DemoteContentWatchedPastDays: Optional. Specifies the number of days to look
	// back for demoting watched content. If set to zero or unset, defaults to the
	// maximum of 365 days.
	DemoteContentWatchedPastDays int64 `json:"demoteContentWatchedPastDays,omitempty"`
	// DemotionEventType: Specifies the event type used for demoting recommendation
	// result. Currently supported values: * `view-item`: Item viewed. *
	// `media-play`: Start/resume watching a video, playing a song, etc. *
	// `media-complete`: Finished or stopped midway through a video, song, etc. If
	// unset, watch history demotion will not be applied. Content freshness
	// demotion will still be applied.
	DemotionEventType string `json:"demotionEventType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentFreshnessCutoffDays")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentFreshnessCutoffDays") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1ServingConfigMediaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ServingConfigMediaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1ServingConfigMediaConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1ServingConfigMediaConfig
	var s1 struct {
		ContentWatchedPercentageThreshold gensupport.JSONFloat64 `json:"contentWatchedPercentageThreshold"`
		ContentWatchedSecondsThreshold    gensupport.JSONFloat64 `json:"contentWatchedSecondsThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ContentWatchedPercentageThreshold = float64(s1.ContentWatchedPercentageThreshold)
	s.ContentWatchedSecondsThreshold = float64(s1.ContentWatchedSecondsThreshold)
	return nil
}

// GoogleCloudDiscoveryengineV1SiteVerificationInfo: Verification information
// for target sites in advanced site search.
type GoogleCloudDiscoveryengineV1SiteVerificationInfo struct {
	// SiteVerificationState: Site verification state indicating the ownership and
	// validity.
	//
	// Possible values:
	//   "SITE_VERIFICATION_STATE_UNSPECIFIED" - Defaults to VERIFIED.
	//   "VERIFIED" - Site ownership verified.
	//   "UNVERIFIED" - Site ownership pending verification or verification failed.
	//   "EXEMPTED" - Site exempt from verification, e.g., a public website that
	// opens to all.
	SiteVerificationState string `json:"siteVerificationState,omitempty"`
	// VerifyTime: Latest site verification time.
	VerifyTime string `json:"verifyTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SiteVerificationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SiteVerificationState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1SiteVerificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1SiteVerificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TargetSite: A target site for the
// SiteSearchEngine.
type GoogleCloudDiscoveryengineV1TargetSite struct {
	// ExactMatch: Input only. If set to false, a uri_pattern is generated to
	// include all pages whose address contains the provided_uri_pattern. If set to
	// true, an uri_pattern is generated to try to be an exact match of the
	// provided_uri_pattern or just the specific page if the provided_uri_pattern
	// is a specific one. provided_uri_pattern is always normalized to generate the
	// URI pattern to be used by the search engine.
	ExactMatch bool `json:"exactMatch,omitempty"`
	// FailureReason: Output only. Failure reason.
	FailureReason *GoogleCloudDiscoveryengineV1TargetSiteFailureReason `json:"failureReason,omitempty"`
	// GeneratedUriPattern: Output only. This is system-generated based on the
	// provided_uri_pattern.
	GeneratedUriPattern string `json:"generatedUriPattern,omitempty"`
	// IndexingStatus: Output only. Indexing status.
	//
	// Possible values:
	//   "INDEXING_STATUS_UNSPECIFIED" - Defaults to SUCCEEDED.
	//   "PENDING" - The target site is in the update queue and will be picked up
	// by indexing pipeline.
	//   "FAILED" - The target site fails to be indexed.
	//   "SUCCEEDED" - The target site has been indexed.
	//   "DELETING" - The previously indexed target site has been marked to be
	// deleted. This is a transitioning state which will resulted in either: 1.
	// target site deleted if unindexing is successful; 2. state reverts to
	// SUCCEEDED if the unindexing fails.
	IndexingStatus string `json:"indexingStatus,omitempty"`
	// Name: Output only. The fully qualified resource name of the target site.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/siteSearchEngine/targetSites/{target_site}` The
	// `target_site_id` is system-generated.
	Name string `json:"name,omitempty"`
	// ProvidedUriPattern: Required. Input only. The user provided URI pattern from
	// which the `generated_uri_pattern` is generated.
	ProvidedUriPattern string `json:"providedUriPattern,omitempty"`
	// RootDomainUri: Output only. Root domain of the provided_uri_pattern.
	RootDomainUri string `json:"rootDomainUri,omitempty"`
	// SiteVerificationInfo: Output only. Site ownership and validity verification
	// status.
	SiteVerificationInfo *GoogleCloudDiscoveryengineV1SiteVerificationInfo `json:"siteVerificationInfo,omitempty"`
	// Type: The type of the target site, e.g., whether the site is to be included
	// or excluded.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - This value is unused. In this case, server behavior
	// defaults to Type.INCLUDE.
	//   "INCLUDE" - Include the target site.
	//   "EXCLUDE" - Exclude the target site.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The target site's last updated time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TargetSite) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TargetSite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TargetSiteFailureReason: Site search indexing
// failure reasons.
type GoogleCloudDiscoveryengineV1TargetSiteFailureReason struct {
	// QuotaFailure: Failed due to insufficient quota.
	QuotaFailure *GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure `json:"quotaFailure,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuotaFailure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuotaFailure") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TargetSiteFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TargetSiteFailureReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure: Failed due
// to insufficient quota.
type GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure struct {
	// TotalRequiredQuota: This number is an estimation on how much total quota
	// this project needs to successfully complete indexing.
	TotalRequiredQuota int64 `json:"totalRequiredQuota,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TotalRequiredQuota") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalRequiredQuota") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TrainCustomModelMetadata: Metadata related to
// the progress of the TrainCustomModel operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1TrainCustomModelMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TrainCustomModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TrainCustomModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1TrainCustomModelResponse: Response of the
// TrainCustomModelRequest. This message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1TrainCustomModelResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the data.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// Metrics: The metrics of the trained model.
	Metrics map[string]float64 `json:"metrics,omitempty"`
	// ModelName: Fully qualified name of the CustomTuningModel.
	ModelName string `json:"modelName,omitempty"`
	// ModelStatus: The trained model status. Possible values are: * **bad-data**:
	// The training data quality is bad. * **no-improvement**: Tuning didn't
	// improve performance. Won't deploy. * **in-progress**: Model training job
	// creation is in progress. * **training**: Model is actively training. *
	// **evaluating**: The model is evaluating trained metrics. * **indexing**: The
	// model trained metrics are indexing. * **ready**: The model is ready for
	// serving.
	ModelStatus string `json:"modelStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1TrainCustomModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1TrainCustomModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UpdateCmekConfigMetadata: Metadata related to
// the progress of the CmekConfigService.UpdateCmekConfig operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1UpdateCmekConfigMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UpdateCmekConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UpdateCmekConfigMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UpdateSchemaMetadata: Metadata for UpdateSchema
// LRO.
type GoogleCloudDiscoveryengineV1UpdateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UpdateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UpdateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata: Metadata related to
// the progress of the SiteSearchEngineService.UpdateTargetSite operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1WorkspaceConfig: Config to store data store type
// configuration for workspace data
type GoogleCloudDiscoveryengineV1WorkspaceConfig struct {
	// DasherCustomerId: Obfuscated Dasher customer ID.
	DasherCustomerId string `json:"dasherCustomerId,omitempty"`
	// SuperAdminEmailAddress: Optional. The super admin email address for the
	// workspace that will be used for access token generation. For now we only use
	// it for Native Google Drive connector data ingestion.
	SuperAdminEmailAddress string `json:"superAdminEmailAddress,omitempty"`
	// SuperAdminServiceAccount: Optional. The super admin service account for the
	// workspace that will be used for access token generation. For now we only use
	// it for Native Google Drive connector data ingestion.
	SuperAdminServiceAccount string `json:"superAdminServiceAccount,omitempty"`
	// Type: The Google Workspace data source.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Defaults to an unspecified Workspace type.
	//   "GOOGLE_DRIVE" - Workspace Data Store contains Drive data
	//   "GOOGLE_MAIL" - Workspace Data Store contains Mail data
	//   "GOOGLE_SITES" - Workspace Data Store contains Sites data
	//   "GOOGLE_CALENDAR" - Workspace Data Store contains Calendar data
	//   "GOOGLE_CHAT" - Workspace Data Store contains Chat data
	//   "GOOGLE_GROUPS" - Workspace Data Store contains Groups data
	//   "GOOGLE_KEEP" - Workspace Data Store contains Keep data
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DasherCustomerId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DasherCustomerId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1WorkspaceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1WorkspaceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAclConfig: Access Control Configuration.
type GoogleCloudDiscoveryengineV1alphaAclConfig struct {
	// IdpConfig: Identity provider config.
	IdpConfig *GoogleCloudDiscoveryengineV1alphaIdpConfig `json:"idpConfig,omitempty"`
	// Name: Immutable. The full resource name of the acl configuration. Format:
	// `projects/{project}/locations/{location}/aclConfig`. This field must be a
	// UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdpConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdpConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAclConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAclConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig: Configuration
// data for advance site search.
type GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig struct {
	// DisableAutomaticRefresh: If set true, automatic refresh is disabled for the
	// DataStore.
	DisableAutomaticRefresh bool `json:"disableAutomaticRefresh,omitempty"`
	// DisableInitialIndex: If set true, initial indexing is disabled for the
	// DataStore.
	DisableInitialIndex bool `json:"disableInitialIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableAutomaticRefresh") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableAutomaticRefresh") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswer: Defines an answer.
type GoogleCloudDiscoveryengineV1alphaAnswer struct {
	// AnswerSkippedReasons: Additional answer-skipped reasons. This provides the
	// reason for ignored cases. If nothing is skipped, this field is not set.
	//
	// Possible values:
	//   "ANSWER_SKIPPED_REASON_UNSPECIFIED" - Default value. The answer skipped
	// reason is not specified.
	//   "ADVERSARIAL_QUERY_IGNORED" - The adversarial query ignored case.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED" - The non-answer seeking query ignored
	// case Google skips the answer if the query is chit chat.
	//   "OUT_OF_DOMAIN_QUERY_IGNORED" - The out-of-domain query ignored case.
	// Google skips the answer if there are no high-relevance search results.
	//   "POTENTIAL_POLICY_VIOLATION" - The potential policy violation case. Google
	// skips the answer if there is a potential policy violation detected. This
	// includes content that may be violent or toxic.
	//   "NO_RELEVANT_CONTENT" - The no relevant content case. Google skips the
	// answer if there is no relevant content in the retrieved search results.
	//   "JAIL_BREAKING_QUERY_IGNORED" - The jail-breaking query ignored case. For
	// example, "Reply in the tone of a competing company's CEO". Google skips the
	// answer if the query is classified as a jail-breaking query.
	//   "CUSTOMER_POLICY_VIOLATION" - The customer policy violation case. Google
	// skips the summary if there is a customer policy violation detected. The
	// policy is defined by the customer.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED_V2" - The non-answer seeking query
	// ignored case. Google skips the answer if the query doesn't have clear
	// intent.
	//   "LOW_GROUNDED_ANSWER" - The low-grounded answer case. Google skips the
	// answer if a well grounded answer was unable to be generated.
	AnswerSkippedReasons []string `json:"answerSkippedReasons,omitempty"`
	// AnswerText: The textual answer.
	AnswerText string `json:"answerText,omitempty"`
	// Citations: Citations.
	Citations []*GoogleCloudDiscoveryengineV1alphaAnswerCitation `json:"citations,omitempty"`
	// CompleteTime: Output only. Answer completed timestamp.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. Answer creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// GroundingScore: A score in the range of [0, 1] describing how grounded the
	// answer is by the reference chunks.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// GroundingSupports: Optional. Grounding supports.
	GroundingSupports []*GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport `json:"groundingSupports,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*/answers/*`
	Name string `json:"name,omitempty"`
	// QueryUnderstandingInfo: Query understanding information.
	QueryUnderstandingInfo *GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo `json:"queryUnderstandingInfo,omitempty"`
	// References: References.
	References []*GoogleCloudDiscoveryengineV1alphaAnswerReference `json:"references,omitempty"`
	// RelatedQuestions: Suggested related questions.
	RelatedQuestions []string `json:"relatedQuestions,omitempty"`
	// State: The state of the answer generation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Answer generation is currently in progress.
	//   "FAILED" - Answer generation currently failed.
	//   "SUCCEEDED" - Answer generation has succeeded.
	//   "STREAMING" - Answer generation is currently in progress.
	State string `json:"state,omitempty"`
	// Steps: Answer generation steps.
	Steps []*GoogleCloudDiscoveryengineV1alphaAnswerStep `json:"steps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerSkippedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSkippedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswer
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerCitation: Citation info for a
// segment.
type GoogleCloudDiscoveryengineV1alphaAnswerCitation struct {
	// EndIndex: End of the attributed segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// Sources: Citation sources for the attributed segment.
	Sources []*GoogleCloudDiscoveryengineV1alphaAnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Index indicates the start of the segment, measured in bytes
	// (UTF-8 unicode).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerCitationSource: Citation source.
type GoogleCloudDiscoveryengineV1alphaAnswerCitationSource struct {
	// ReferenceId: ID of the citation source.
	ReferenceId string `json:"referenceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferenceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerCitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerCitationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport: Grounding support
// for a claim in `answer_text`.
type GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport struct {
	// EndIndex: Required. End of the claim, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// GroundingCheckRequired: Indicates that this claim required grounding check.
	// When the system decided this claim didn't require attribution/grounding
	// check, this field is set to false. In that case, no grounding check was done
	// for the claim and therefore `grounding_score`, `sources` is not returned.
	GroundingCheckRequired bool `json:"groundingCheckRequired,omitempty"`
	// GroundingScore: A score in the range of [0, 1] describing how grounded is a
	// specific claim by the references. Higher value means that the claim is
	// better supported by the reference chunks.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// Sources: Optional. Citation sources for the claim.
	Sources []*GoogleCloudDiscoveryengineV1alphaAnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Required. Index indicates the start of the claim, measured in
	// bytes (UTF-8 unicode).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo: Query
// understanding information.
type GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo struct {
	// QueryClassificationInfo: Query classification information.
	QueryClassificationInfo []*GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo `json:"queryClassificationInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryClassificationInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryClassificationInfo") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificat
// ionInfo: Query classification information.
type GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo struct {
	// Positive: Classification output.
	Positive bool `json:"positive,omitempty"`
	// Type: Query classification type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified query classification type.
	//   "ADVERSARIAL_QUERY" - Adversarial query classification type.
	//   "NON_ANSWER_SEEKING_QUERY" - Non-answer-seeking query classification type,
	// for chit chat.
	//   "JAIL_BREAKING_QUERY" - Jail-breaking query classification type.
	//   "NON_ANSWER_SEEKING_QUERY_V2" - Non-answer-seeking query classification
	// type, for no clear intent.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Positive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Positive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReference: Reference.
type GoogleCloudDiscoveryengineV1alphaAnswerReference struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo `json:"chunkInfo,omitempty"`
	// StructuredDocumentInfo: Structured document information.
	StructuredDocumentInfo *GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo `json:"structuredDocumentInfo,omitempty"`
	// UnstructuredDocumentInfo: Unstructured document information.
	UnstructuredDocumentInfo *GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo `json:"unstructuredDocumentInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo: Chunk
// information.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Document metadata.
	DocumentMetadata *GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata `json:"documentMetadata,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata:
// Document metadata.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo:
// Structured search information.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: Structured search data.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo:
// Unstructured document information.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo struct {
	// ChunkContents: List of cited chunk contents derived from document content.
	ChunkContents []*GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent `json:"chunkContents,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunk
// Content: Chunk content.
type GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent struct {
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerStep: Step information.
type GoogleCloudDiscoveryengineV1alphaAnswerStep struct {
	// Actions: Actions.
	Actions []*GoogleCloudDiscoveryengineV1alphaAnswerStepAction `json:"actions,omitempty"`
	// Description: The description of the step.
	Description string `json:"description,omitempty"`
	// State: The state of the step.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Step is currently in progress.
	//   "FAILED" - Step currently failed.
	//   "SUCCEEDED" - Step has succeeded.
	State string `json:"state,omitempty"`
	// Thought: The thought of the step.
	Thought string `json:"thought,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepAction: Action.
type GoogleCloudDiscoveryengineV1alphaAnswerStepAction struct {
	// Observation: Observation.
	Observation *GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation `json:"observation,omitempty"`
	// SearchAction: Search action.
	SearchAction *GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction `json:"searchAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Observation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Observation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation: Observation.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation struct {
	// SearchResults: Search results observed by the search action, it can be
	// snippets info or chunk info, depending on the citation type set by the user.
	SearchResults []*GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult `json:"searchResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult struct {
	// ChunkInfo: If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
	// populate chunk info.
	ChunkInfo []*GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo `json:"chunkInfo,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// SnippetInfo: If citation_type is DOCUMENT_LEVEL_CITATION, populate document
	// level snippets.
	SnippetInfo []*GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo `json:"snippetInfo,omitempty"`
	// StructData: Data representation. The structured JSON data for the document.
	// It's populated from the struct data from the Document, or the Chunk in
	// search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunk
// Info: Chunk information.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnipp
// etInfo: Snippet information.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo struct {
	// Snippet: Snippet content.
	Snippet string `json:"snippet,omitempty"`
	// SnippetStatus: Status of the snippet defined by the search team.
	SnippetStatus string `json:"snippetStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippet") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction: Search
// action.
type GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction struct {
	// Query: The query to search.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.BatchCreateTargetSites operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse: Response
// message for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1alphaTargetSite `json:"targetSites,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCmekConfig: Configurations used to enable
// CMEK data encryption with Cloud KMS keys.
type GoogleCloudDiscoveryengineV1alphaCmekConfig struct {
	// IsDefault: Output only. The default CmekConfig for the Customer.
	IsDefault bool `json:"isDefault,omitempty"`
	// KmsKey: Kms key resource name which will be used to encrypt resources
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId
	// }`.
	KmsKey string `json:"kmsKey,omitempty"`
	// KmsKeyVersion: Kms key version resource name which will be used to encrypt
	// resources `/cryptoKeyVersions/{keyVersion}`.
	KmsKeyVersion string `json:"kmsKeyVersion,omitempty"`
	// LastRotationTimestampMicros: Output only. The timestamp of the last key
	// rotation.
	LastRotationTimestampMicros int64 `json:"lastRotationTimestampMicros,omitempty,string"`
	// Name: Required. Name of the CmekConfig, of the form
	// `projects/{project}/locations/{location}/cmekConfig` or
	// `projects/{project}/locations/{location}/cmekConfigs/{cmekConfig}`.
	Name string `json:"name,omitempty"`
	// State: Output only. State of the CmekConfig.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The CmekConfig state is unknown.
	//   "CREATING" - The CmekConfig is creating.
	//   "ACTIVE" - The CmekConfig can be used with DataStores.
	//   "KEY_ISSUE" - The CmekConfig is unavailable, most likely due to the KMS
	// Key being revoked.
	//   "DELETING" - The CmekConfig is deleting.
	//   "UNUSABLE" - The CmekConfig is not usable, most likely due to some
	// internal issue.
	//   "ACTIVE_ROTATING" - The KMS key version is being rotated.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsDefault") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDefault") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCmekConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCmekConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCondition: Defines circumstances to be
// checked before allowing a behavior
type GoogleCloudDiscoveryengineV1alphaCondition struct {
	// ActiveTimeRange: Range of time(s) specifying when condition is active.
	// Maximum of 10 time ranges.
	ActiveTimeRange []*GoogleCloudDiscoveryengineV1alphaConditionTimeRange `json:"activeTimeRange,omitempty"`
	// QueryRegex: Optional. Query regex to match the whole search query. Cannot be
	// set when Condition.query_terms is set. This is currently supporting
	// promotion use case.
	QueryRegex string `json:"queryRegex,omitempty"`
	// QueryTerms: Search only A list of terms to match the query on. Cannot be set
	// when Condition.query_regex is set. Maximum of 10 query terms.
	QueryTerms []*GoogleCloudDiscoveryengineV1alphaConditionQueryTerm `json:"queryTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConditionQueryTerm: Matcher for search
// request query
type GoogleCloudDiscoveryengineV1alphaConditionQueryTerm struct {
	// FullMatch: Whether the search query needs to exactly match the query term.
	FullMatch bool `json:"fullMatch,omitempty"`
	// Value: The specific query value to match against Must be lowercase, must be
	// UTF-8. Can have at most 3 space separated terms if full_match is true.
	// Cannot be an empty string. Maximum length of 5000 characters.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaConditionQueryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConditionQueryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConditionTimeRange: Used for time-dependent
// conditions.
type GoogleCloudDiscoveryengineV1alphaConditionTimeRange struct {
	// EndTime: End of time range. Range is inclusive. Must be in the future.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time range. Range is inclusive.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaConditionTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConditionTimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControl: Defines a conditioned behavior to
// employ during serving. Must be attached to a ServingConfig to be considered
// at serving time. Permitted actions dependent on `SolutionType`.
type GoogleCloudDiscoveryengineV1alphaControl struct {
	// AssociatedServingConfigIds: Output only. List of all ServingConfig IDs this
	// control is attached to. May take up to 10 minutes to update after changes.
	AssociatedServingConfigIds []string `json:"associatedServingConfigIds,omitempty"`
	// BoostAction: Defines a boost-type control
	BoostAction *GoogleCloudDiscoveryengineV1alphaControlBoostAction `json:"boostAction,omitempty"`
	// Conditions: Determines when the associated action will trigger. Omit to
	// always apply the action. Currently only a single condition may be specified.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Conditions []*GoogleCloudDiscoveryengineV1alphaCondition `json:"conditions,omitempty"`
	// DisplayName: Required. Human readable name. The identifier used in UI views.
	// Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an
	// INVALID ARGUMENT error is thrown.
	DisplayName string `json:"displayName,omitempty"`
	// FilterAction: Defines a filter-type control Currently not supported by
	// Recommendation
	FilterAction *GoogleCloudDiscoveryengineV1alphaControlFilterAction `json:"filterAction,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/dataStore/*/controls/*`
	Name string `json:"name,omitempty"`
	// PromoteAction: Promote certain links based on predefined trigger queries.
	// This now only supports basic site search.
	PromoteAction *GoogleCloudDiscoveryengineV1alphaControlPromoteAction `json:"promoteAction,omitempty"`
	// RedirectAction: Defines a redirect-type control.
	RedirectAction *GoogleCloudDiscoveryengineV1alphaControlRedirectAction `json:"redirectAction,omitempty"`
	// SolutionType: Required. Immutable. What solution the control belongs to.
	// Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT
	// error is thrown.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsAction: Treats a group of terms as synonyms of one another.
	SynonymsAction *GoogleCloudDiscoveryengineV1alphaControlSynonymsAction `json:"synonymsAction,omitempty"`
	// UseCases: Specifies the use case for the control. Affects what condition
	// fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only
	// allow one use case per control. Must be set when solution_type is
	// SolutionType.SOLUTION_TYPE_SEARCH.
	//
	// Possible values:
	//   "SEARCH_USE_CASE_UNSPECIFIED" - Value used when unset. Will not occur in
	// CSS.
	//   "SEARCH_USE_CASE_SEARCH" - Search use case. Expects the traffic has a
	// non-empty query.
	//   "SEARCH_USE_CASE_BROWSE" - Browse use case. Expects the traffic has an
	// empty query.
	UseCases []string `json:"useCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssociatedServingConfigIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedServingConfigIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControl) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlBoostAction: Adjusts order of
// products in returned list.
type GoogleCloudDiscoveryengineV1alphaControlBoostAction struct {
	// Boost: Required. Strength of the boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0 (No-op).
	Boost float64 `json:"boost,omitempty"`
	// DataStore: Required. Specifies which data store's documents can be boosted
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. Specifies which products to apply the boost to. If no
	// filter is provided all products will be boosted (No-op). Syntax
	// documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum
	// length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlBoostAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlBoostAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaControlBoostAction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlBoostAction
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaControlFilterAction: Specified which
// products may be included in results. Uses same filter as boost.
type GoogleCloudDiscoveryengineV1alphaControlFilterAction struct {
	// DataStore: Required. Specifies which data store's documents can be filtered
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. A filter to apply on the matching condition results.
	// Required Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000
	// characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlFilterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlFilterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlPromoteAction: Promote certain links
// based on some trigger queries. Example: Promote shoe store link when
// searching for `shoe` keyword. The link can be outside of associated data
// store.
type GoogleCloudDiscoveryengineV1alphaControlPromoteAction struct {
	// DataStore: Required. Data store with which this promotion is attached to.
	DataStore string `json:"dataStore,omitempty"`
	// SearchLinkPromotion: Required. Promotion attached to this action.
	SearchLinkPromotion *GoogleCloudDiscoveryengineV1alphaSearchLinkPromotion `json:"searchLinkPromotion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlPromoteAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlPromoteAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlRedirectAction: Redirects a shopper
// to the provided URI.
type GoogleCloudDiscoveryengineV1alphaControlRedirectAction struct {
	// RedirectUri: Required. The URI to which the shopper will be redirected.
	// Required. URI must have length equal or less than 2000 characters. Otherwise
	// an INVALID ARGUMENT error is thrown.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlRedirectAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaControlSynonymsAction: Creates a set of
// terms that will act as synonyms of one another. Example: "happy" will also
// be considered as "glad", "glad" will also be considered as "happy".
type GoogleCloudDiscoveryengineV1alphaControlSynonymsAction struct {
	// Synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must
	// specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaControlSynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaControlSynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries: The historical crawl
// rate timeseries data, used for monitoring.
type GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries struct {
	// QpsTimeSeries: The QPS of the crawl rate.
	QpsTimeSeries *GoogleMonitoringV3TimeSeries `json:"qpsTimeSeries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QpsTimeSeries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QpsTimeSeries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata: Metadata related
// to the progress of the DataStoreService.CreateDataStore operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata: Metadata related to
// the progress of the EngineService.CreateEngine operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateEvaluationMetadata: Metadata for
// EvaluationService.CreateEvaluation method.
type GoogleCloudDiscoveryengineV1alphaCreateEvaluationMetadata struct {
}

// GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata: Metadata for Create
// Schema LRO.
type GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateSitemapMetadata: Metadata related to
// the progress of the SiteSearchEngineService.CreateSitemap operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateSitemapMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.CreateTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec: Defines custom fine
// tuning spec.
type GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec struct {
	// EnableSearchAdaptor: Whether or not to enable and include custom fine tuned
	// search adaptor model.
	EnableSearchAdaptor bool `json:"enableSearchAdaptor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSearchAdaptor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSearchAdaptor") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDataStore: DataStore captures global
// settings and configs at the DataStore level.
type GoogleCloudDiscoveryengineV1alphaDataStore struct {
	// AclEnabled: Immutable. Whether data in the DataStore has ACL information. If
	// set to `true`, the source data must have ACL. ACL will be ingested when data
	// is ingested by DocumentService.ImportDocuments methods. When ACL is enabled
	// for the DataStore, Document can't be accessed by calling
	// DocumentService.GetDocument or DocumentService.ListDocuments. Currently ACL
	// is only supported in `GENERIC` industry vertical with non-`PUBLIC_WEBSITE`
	// content config.
	AclEnabled bool `json:"aclEnabled,omitempty"`
	// AdvancedSiteSearchConfig: Optional. Configuration for advanced site search.
	AdvancedSiteSearchConfig *GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig `json:"advancedSiteSearchConfig,omitempty"`
	// BillingEstimation: Output only. Data size estimation for billing.
	BillingEstimation *GoogleCloudDiscoveryengineV1alphaDataStoreBillingEstimation `json:"billingEstimation,omitempty"`
	// CmekConfig: Output only. CMEK-related information for the DataStore.
	CmekConfig *GoogleCloudDiscoveryengineV1alphaCmekConfig `json:"cmekConfig,omitempty"`
	// ContentConfig: Immutable. The content config of the data store. If this
	// field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
	//
	// Possible values:
	//   "CONTENT_CONFIG_UNSPECIFIED" - Default value.
	//   "NO_CONTENT" - Only contains documents without any Document.content.
	//   "CONTENT_REQUIRED" - Only contains documents with Document.content.
	//   "PUBLIC_WEBSITE" - The data store is used for public website search.
	//   "GOOGLE_WORKSPACE" - The data store is used for workspace search. Details
	// of workspace data store are specified in the WorkspaceConfig.
	ContentConfig string `json:"contentConfig,omitempty"`
	// CreateTime: Output only. Timestamp the DataStore was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultSchemaId: Output only. The id of the default Schema asscociated to
	// this data store.
	DefaultSchemaId string `json:"defaultSchemaId,omitempty"`
	// DisplayName: Required. The data store display name. This field must be a
	// UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentProcessingConfig: Configuration for Document understanding and
	// enrichment.
	DocumentProcessingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig `json:"documentProcessingConfig,omitempty"`
	// IdpConfig: Output only. Data store level identity provider config.
	IdpConfig *GoogleCloudDiscoveryengineV1alphaIdpConfig `json:"idpConfig,omitempty"`
	// IndustryVertical: Immutable. The industry vertical that the data store
	// registers.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// KmsKeyName: Input only. The KMS key to be used to protect this DataStore at
	// creation time. Must be set for requests that need to comply with CMEK Org
	// Policy protections. If this field is set and processed successfully, the
	// DataStore will be protected by the KMS key, as indicated in the cmek_config
	// field.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// LanguageInfo: Language info for DataStore.
	LanguageInfo *GoogleCloudDiscoveryengineV1alphaLanguageInfo `json:"languageInfo,omitempty"`
	// Name: Immutable. The full resource name of the data store. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. This field must be a UTF-8 encoded string with a length
	// limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// NaturalLanguageQueryUnderstandingConfig: Optional. Configuration for Natural
	// Language Query Understanding.
	NaturalLanguageQueryUnderstandingConfig *GoogleCloudDiscoveryengineV1alphaNaturalLanguageQueryUnderstandingConfig `json:"naturalLanguageQueryUnderstandingConfig,omitempty"`
	// ServingConfigDataStore: Optional. Stores serving config at DataStore level.
	ServingConfigDataStore *GoogleCloudDiscoveryengineV1alphaDataStoreServingConfigDataStore `json:"servingConfigDataStore,omitempty"`
	// SolutionTypes: The solutions that the data store enrolls. Available
	// solutions for each industry_vertical: * `MEDIA`:
	// `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`:
	// `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be
	// enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionTypes []string `json:"solutionTypes,omitempty"`
	// StartingSchema: The start schema to use for this DataStore when provisioning
	// it. If unset, a default vertical specialized schema will be used. This field
	// is only used by CreateDataStore API, and will be ignored if used in other
	// APIs. This field will be omitted from all API responses including
	// CreateDataStore API. To retrieve a schema of a DataStore, use
	// SchemaService.GetSchema API instead. The provided schema will be validated
	// against certain rules on schema. Learn more from this doc
	// (https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
	StartingSchema *GoogleCloudDiscoveryengineV1alphaSchema `json:"startingSchema,omitempty"`
	// WorkspaceConfig: Config to store data store type configuration for workspace
	// data. This must be set when DataStore.content_config is set as
	// DataStore.ContentConfig.GOOGLE_WORKSPACE.
	WorkspaceConfig *GoogleCloudDiscoveryengineV1alphaWorkspaceConfig `json:"workspaceConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AclEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AclEnabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDataStoreBillingEstimation: Estimation of
// data size per data store.
type GoogleCloudDiscoveryengineV1alphaDataStoreBillingEstimation struct {
	// StructuredDataSize: Data size for structured data in terms of bytes.
	StructuredDataSize int64 `json:"structuredDataSize,omitempty,string"`
	// StructuredDataUpdateTime: Last updated timestamp for structured data.
	StructuredDataUpdateTime string `json:"structuredDataUpdateTime,omitempty"`
	// UnstructuredDataSize: Data size for unstructured data in terms of bytes.
	UnstructuredDataSize int64 `json:"unstructuredDataSize,omitempty,string"`
	// UnstructuredDataUpdateTime: Last updated timestamp for unstructured data.
	UnstructuredDataUpdateTime string `json:"unstructuredDataUpdateTime,omitempty"`
	// WebsiteDataSize: Data size for websites in terms of bytes.
	WebsiteDataSize int64 `json:"websiteDataSize,omitempty,string"`
	// WebsiteDataUpdateTime: Last updated timestamp for websites.
	WebsiteDataUpdateTime string `json:"websiteDataUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StructuredDataSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StructuredDataSize") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDataStoreBillingEstimation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDataStoreBillingEstimation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDataStoreServingConfigDataStore: Stores
// information regarding the serving configurations at DataStore level.
type GoogleCloudDiscoveryengineV1alphaDataStoreServingConfigDataStore struct {
	// DisabledForServing: If set true, the DataStore will not be available for
	// serving search requests.
	DisabledForServing bool `json:"disabledForServing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisabledForServing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisabledForServing") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDataStoreServingConfigDataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDataStoreServingConfigDataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDedicatedCrawlRateTimeSeries: The
// historical dedicated crawl rate timeseries data, used for monitoring.
// Dedicated crawl is used by Vertex AI to crawl the user's website when
// dedicate crawl is set.
type GoogleCloudDiscoveryengineV1alphaDedicatedCrawlRateTimeSeries struct {
	// AutoRefreshCrawlRate: Vertex AI's dedicated crawl rate time series of
	// auto-refresh, which is the crawl rate of Google-CloudVertexBot when dedicate
	// crawl is set, and the crawl rate is for best effort use cases like
	// refreshing urls periodically.
	AutoRefreshCrawlRate *GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries `json:"autoRefreshCrawlRate,omitempty"`
	// UserTriggeredCrawlRate: Vertex AI's dedicated crawl rate time series of user
	// triggered crawl, which is the crawl rate of Google-CloudVertexBot when
	// dedicate crawl is set, and user triggered crawl rate is for deterministic
	// use cases like crawling urls or sitemaps specified by users.
	UserTriggeredCrawlRate *GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries `json:"userTriggeredCrawlRate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoRefreshCrawlRate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoRefreshCrawlRate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDedicatedCrawlRateTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDedicatedCrawlRateTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata: Metadata related
// to the progress of the DataStoreService.DeleteDataStore operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata: Metadata related to
// the progress of the EngineService.DeleteEngine operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata: Metadata for
// DeleteSchema LRO.
type GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteSessionRequest: Request for
// DeleteSession method.
type GoogleCloudDiscoveryengineV1alphaDeleteSessionRequest struct {
	// Name: Required. The resource name of the Session to delete. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store_id}/sessions/{session_id}`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteSessionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteSessionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteSitemapMetadata: Metadata related to
// the progress of the SiteSearchEngineService.DeleteSitemap operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDeleteSitemapMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.DeleteTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig: A singleton
// resource of DataStore. If it's empty when DataStore is created and DataStore
// is set to DataStore.ContentConfig.CONTENT_REQUIRED, the default parser will
// default to digital parser.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig struct {
	// ChunkingConfig: Whether chunking mode is enabled.
	ChunkingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig `json:"chunkingConfig,omitempty"`
	// DefaultParsingConfig: Configurations for default Document parser. If not
	// specified, we will configure it as default DigitalParsingConfig, and the
	// default parsing config will be applied to all file types for Document
	// parsing.
	DefaultParsingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig `json:"defaultParsingConfig,omitempty"`
	// Name: The full resource name of the Document Processing Config. Format:
	// `projects/*/locations/*/collections/*/dataStores/*/documentProcessingConfig`.
	Name string `json:"name,omitempty"`
	// ParsingConfigOverrides: Map from file type to override the default parsing
	// configuration based on the file type. Supported keys: * `pdf`: Override
	// parsing config for PDF files, either digital parsing, ocr parsing or layout
	// parsing is supported. * `html`: Override parsing config for HTML files, only
	// digital parsing and layout parsing are supported. * `docx`: Override parsing
	// config for DOCX files, only digital parsing and layout parsing are
	// supported. * `pptx`: Override parsing config for PPTX files, only digital
	// parsing and layout parsing are supported. * `xlsm`: Override parsing config
	// for XLSM files, only digital parsing and layout parsing are supported. *
	// `xlsx`: Override parsing config for XLSX files, only digital parsing and
	// layout parsing are supported.
	ParsingConfigOverrides map[string]GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig `json:"parsingConfigOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig:
// Configuration for chunking config.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig struct {
	// LayoutBasedChunkingConfig: Configuration for the layout based chunking.
	LayoutBasedChunkingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig `json:"layoutBasedChunkingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LayoutBasedChunkingConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LayoutBasedChunkingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayout
// BasedChunkingConfig: Configuration for the layout based chunking.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig struct {
	// ChunkSize: The token size limit for each chunk. Supported values: 100-500
	// (inclusive). Default value: 500.
	ChunkSize int64 `json:"chunkSize,omitempty"`
	// IncludeAncestorHeadings: Whether to include appending different levels of
	// headings to chunks from the middle of the document to prevent context loss.
	// Default value: False.
	IncludeAncestorHeadings bool `json:"includeAncestorHeadings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig:
// Related configurations applied to a specific type of document parser.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig struct {
	// DigitalParsingConfig: Configurations applied to digital parser.
	DigitalParsingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigDigitalParsingConfig `json:"digitalParsingConfig,omitempty"`
	// LayoutParsingConfig: Configurations applied to layout parser.
	LayoutParsingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigLayoutParsingConfig `json:"layoutParsingConfig,omitempty"`
	// OcrParsingConfig: Configurations applied to OCR parser. Currently it only
	// applies to PDFs.
	OcrParsingConfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig `json:"ocrParsingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DigitalParsingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DigitalParsingConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigDigital
// ParsingConfig: The digital parsing configurations for documents.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigDigitalParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigLayoutP
// arsingConfig: The layout parsing configurations for documents.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigLayoutParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrPars
// ingConfig: The OCR parsing configurations for documents.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig struct {
	// EnhancedDocumentElements: [DEPRECATED] This field is deprecated. To use the
	// additional enhanced document elements processing, please switch to
	// `layout_parsing_config`.
	EnhancedDocumentElements []string `json:"enhancedDocumentElements,omitempty"`
	// UseNativeText: If true, will use native text instead of OCR text on pages
	// containing native text.
	UseNativeText bool `json:"useNativeText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnhancedDocumentElements")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnhancedDocumentElements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaEngine: Metadata that describes the
// training and serving parameters of an Engine.
type GoogleCloudDiscoveryengineV1alphaEngine struct {
	// ChatEngineConfig: Configurations for the Chat Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineConfig *GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig `json:"chatEngineConfig,omitempty"`
	// ChatEngineMetadata: Output only. Additional information of the Chat Engine.
	// Only applicable if solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineMetadata *GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata `json:"chatEngineMetadata,omitempty"`
	// CommonConfig: Common config spec that specifies the metadata of the engine.
	CommonConfig *GoogleCloudDiscoveryengineV1alphaEngineCommonConfig `json:"commonConfig,omitempty"`
	// CreateTime: Output only. Timestamp the Recommendation Engine was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataStoreIds: The data stores associated with this engine. For
	// SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they
	// can only associate with at most one data store. If solution_type is
	// SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be
	// associated here. Note that when used in CreateEngineRequest, one DataStore
	// id must be provided as the system will use it for necessary initializations.
	DataStoreIds []string `json:"dataStoreIds,omitempty"`
	// DisableAnalytics: Optional. Whether to disable analytics for searches
	// performed on this engine.
	DisableAnalytics bool `json:"disableAnalytics,omitempty"`
	// DisplayName: Required. The display name of the engine. Should be human
	// readable. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// IndustryVertical: The industry vertical that the engine registers. The
	// restriction of the Engine industry vertical is based on DataStore: Vertical
	// on Engine has to match vertical of the DataStore linked to the engine.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// MediaRecommendationEngineConfig: Configurations for the Media Engine. Only
	// applicable on the data stores with solution_type
	// SOLUTION_TYPE_RECOMMENDATION and IndustryVertical.MEDIA vertical.
	MediaRecommendationEngineConfig *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig `json:"mediaRecommendationEngineConfig,omitempty"`
	// Name: Immutable. The fully qualified resource name of the engine. This field
	// must be a UTF-8 encoded string with a length limit of 1024 characters.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}` engine should be 1-63 characters, and valid characters are /a-z0-9*/.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	Name string `json:"name,omitempty"`
	// RecommendationMetadata: Output only. Additional information of a
	// recommendation engine. Only applicable if solution_type is
	// SOLUTION_TYPE_RECOMMENDATION.
	RecommendationMetadata *GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata `json:"recommendationMetadata,omitempty"`
	// SearchEngineConfig: Configurations for the Search Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_SEARCH.
	SearchEngineConfig *GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig `json:"searchEngineConfig,omitempty"`
	// SimilarDocumentsConfig: Additional config specs for a `similar-items`
	// engine.
	SimilarDocumentsConfig *GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig `json:"similarDocumentsConfig,omitempty"`
	// SolutionType: Required. The solutions of the engine.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Engine was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChatEngineConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChatEngineConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig: Configurations for
// a Chat Engine.
type GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig struct {
	// AgentCreationConfig: The configurationt generate the Dialogflow agent that
	// is associated to this Engine. Note that these configurations are one-time
	// consumed by and passed to Dialogflow service. It means they cannot be
	// retrieved using EngineService.GetEngine or EngineService.ListEngines API
	// after engine creation.
	AgentCreationConfig *GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig `json:"agentCreationConfig,omitempty"`
	// DialogflowAgentToLink: The resource name of an exist Dialogflow agent to
	// link to this Chat Engine. Customers can either provide
	// `agent_creation_config` to create agent or provide an agent name that links
	// the agent with the Chat engine. Format: `projects//locations//agents/`. Note
	// that the `dialogflow_agent_to_link` are one-time consumed by and passed to
	// Dialogflow service. It means they cannot be retrieved using
	// EngineService.GetEngine or EngineService.ListEngines API after engine
	// creation. Use ChatEngineMetadata.dialogflow_agent for actual agent
	// association after Engine is created.
	DialogflowAgentToLink string `json:"dialogflowAgentToLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCreationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCreationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig:
// Configurations for generating a Dialogflow agent. Note that these
// configurations are one-time consumed by and passed to Dialogflow service. It
// means they cannot be retrieved using EngineService.GetEngine or
// EngineService.ListEngines API after engine creation.
type GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig struct {
	// Business: Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `json:"business,omitempty"`
	// DefaultLanguageCode: Required. The default language of the agent as a
	// language tag. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// Location: Agent location for Agent creation, supported values: global/us/eu.
	// If not provided, us Engine will create Agent using us-central-1 by default;
	// eu Engine will create Agent using eu-west-1 by default.
	Location string `json:"location,omitempty"`
	// TimeZone: Required. The time zone of the agent from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Business") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Business") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata: Additional
// information of a Chat Engine. Fields in this message are output only.
type GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata struct {
	// DialogflowAgent: The resource name of a Dialogflow agent, that this Chat
	// Engine refers to. Format: `projects//locations//agents/`.
	DialogflowAgent string `json:"dialogflowAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowAgent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineCommonConfig: Common configurations
// for an Engine.
type GoogleCloudDiscoveryengineV1alphaEngineCommonConfig struct {
	// CompanyName: The name of the company, business or entity that is associated
	// with the engine. Setting this may help improve LLM related features.
	CompanyName string `json:"companyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompanyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompanyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineCommonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineCommonConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig:
// Additional config specs for a Media Recommendation engine.
type GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig struct {
	// OptimizationObjective: The optimization objective. e.g., `cvr`. This field
	// together with optimization_objective describe engine metadata to use to
	// control engine training and serving. Currently supported values: `ctr`,
	// `cvr`. If not specified, we choose default based on engine type. Default
	// depends on type of recommendation: `recommended-for-you` => `ctr`
	// `others-you-may-like` => `ctr`
	OptimizationObjective string `json:"optimizationObjective,omitempty"`
	// OptimizationObjectiveConfig: Name and value of the custom threshold for cvr
	// optimization_objective. For target_field `watch-time`, target_field_value
	// must be an integer value indicating the media progress time in seconds
	// between (0, 86400] (excludes 0, includes 86400) (e.g., 90). For target_field
	// `watch-percentage`, the target_field_value must be a valid float value
	// between (0, 1.0] (excludes 0, includes 1.0) (e.g., 0.5).
	OptimizationObjectiveConfig *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig `json:"optimizationObjectiveConfig,omitempty"`
	// TrainingState: The training state that the engine is in (e.g. `TRAINING` or
	// `PAUSED`). Since part of the cost of running the service is frequency of
	// training - this can be used to determine when to train engine in order to
	// control cost. If not specified: the default value for `CreateEngine` method
	// is `TRAINING`. The default value for `UpdateEngine` method is to keep the
	// state the same as before.
	//
	// Possible values:
	//   "TRAINING_STATE_UNSPECIFIED" - Unspecified training state.
	//   "PAUSED" - The engine training is paused.
	//   "TRAINING" - The engine is training.
	TrainingState string `json:"trainingState,omitempty"`
	// Type: Required. The type of engine. e.g., `recommended-for-you`. This field
	// together with optimization_objective describe engine metadata to use to
	// control engine training and serving. Currently supported values:
	// `recommended-for-you`, `others-you-may-like`, `more-like-this`,
	// `most-popular-items`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OptimizationObjective") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OptimizationObjective") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimiz
// ationObjectiveConfig: Custom threshold for `cvr` optimization_objective.
type GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig struct {
	// TargetField: Required. The name of the field to target. Currently supported
	// values: `watch-percentage`, `watch-time`.
	TargetField string `json:"targetField,omitempty"`
	// TargetFieldValueFloat: Required. The threshold to be applied to the target
	// (e.g., 0.5).
	TargetFieldValueFloat float64 `json:"targetFieldValueFloat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetField") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig
	var s1 struct {
		TargetFieldValueFloat gensupport.JSONFloat64 `json:"targetFieldValueFloat"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TargetFieldValueFloat = float64(s1.TargetFieldValueFloat)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata: Additional
// information of a recommendation engine.
type GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata struct {
	// DataState: Output only. The state of data requirements for this engine:
	// `DATA_OK` and `DATA_ERROR`. Engine cannot be trained if the data is in
	// `DATA_ERROR` state. Engine can have `DATA_ERROR` state even if serving state
	// is `ACTIVE`: engines were trained successfully before, but cannot be
	// refreshed because the underlying engine no longer has sufficient data for
	// training.
	//
	// Possible values:
	//   "DATA_STATE_UNSPECIFIED" - Unspecified default value, should never be
	// explicitly set.
	//   "DATA_OK" - The engine has sufficient training data.
	//   "DATA_ERROR" - The engine does not have sufficient training data. Error
	// messages can be queried via Stackdriver.
	DataState string `json:"dataState,omitempty"`
	// LastTuneTime: Output only. The timestamp when the latest successful tune
	// finished. Only applicable on Media Recommendation engines.
	LastTuneTime string `json:"lastTuneTime,omitempty"`
	// ServingState: Output only. The serving state of the engine: `ACTIVE`,
	// `NOT_ACTIVE`.
	//
	// Possible values:
	//   "SERVING_STATE_UNSPECIFIED" - Unspecified serving state.
	//   "INACTIVE" - The engine is not serving.
	//   "ACTIVE" - The engine is serving and can be queried.
	//   "TUNED" - The engine is trained on tuned hyperparameters and can be
	// queried.
	ServingState string `json:"servingState,omitempty"`
	// TuningOperation: Output only. The latest tune operation id associated with
	// the engine. Only applicable on Media Recommendation engines. If present,
	// this operation id can be used to determine if there is an ongoing tune for
	// this engine. To check the operation status, send the GetOperation request
	// with this operation id in the engine resource format. If no tuning has
	// happened for this engine, the string is empty.
	TuningOperation string `json:"tuningOperation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig: Configurations
// for a Search Engine.
type GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig struct {
	// SearchAddOns: The add-on that this search engine enables.
	//
	// Possible values:
	//   "SEARCH_ADD_ON_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_ADD_ON_LLM" - Large language model add-on.
	SearchAddOns []string `json:"searchAddOns,omitempty"`
	// SearchTier: The search feature tier of this engine. Different tiers might
	// have different pricing. To learn more, check the pricing documentation.
	// Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
	//
	// Possible values:
	//   "SEARCH_TIER_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_TIER_STANDARD" - Standard tier.
	//   "SEARCH_TIER_ENTERPRISE" - Enterprise tier.
	SearchTier string `json:"searchTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchAddOns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchAddOns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig:
// Additional config specs for a `similar-items` engine.
type GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig struct {
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata: Metadata related
// to the progress of the EstimateDataSize operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse: Response of the
// EstimateDataSize request. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse struct {
	// DataSizeBytes: Data size in terms of bytes.
	DataSizeBytes int64 `json:"dataSizeBytes,omitempty,string"`
	// DocumentCount: Total number of documents.
	DocumentCount int64 `json:"documentCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DataSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSizeBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEvaluation: An evaluation is a single
// execution (or run) of an evaluation process. It encapsulates the state of
// the evaluation and the resulting data.
type GoogleCloudDiscoveryengineV1alphaEvaluation struct {
	// CreateTime: Output only. Timestamp the Evaluation was created at.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. Timestamp the Evaluation was completed at.
	EndTime string `json:"endTime,omitempty"`
	// Error: Output only. The error that occurred during evaluation. Only
	// populated when the evaluation's state is FAILED.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// ErrorSamples: Output only. A sample of errors encountered while processing
	// the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// EvaluationSpec: Required. The specification of the evaluation.
	EvaluationSpec *GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpec `json:"evaluationSpec,omitempty"`
	// Name: Identifier. The full resource name of the Evaluation, in the format of
	// `projects/{project}/locations/{location}/evaluations/{evaluation}`. This
	// field must be a UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// QualityMetrics: Output only. The metrics produced by the evaluation,
	// averaged across all SampleQuerys in the SampleQuerySet. Only populated when
	// the evaluation's state is SUCCEEDED.
	QualityMetrics *GoogleCloudDiscoveryengineV1alphaQualityMetrics `json:"qualityMetrics,omitempty"`
	// State: Output only. The state of the evaluation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The evaluation is unspecified.
	//   "PENDING" - The service is preparing to run the evaluation.
	//   "RUNNING" - The evaluation is in progress.
	//   "SUCCEEDED" - The evaluation completed successfully.
	//   "FAILED" - The evaluation failed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEvaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpec: Describes the
// specification of the evaluation.
type GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpec struct {
	// QuerySetSpec: Required. The specification of the query set.
	QuerySetSpec *GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpecQuerySetSpec `json:"querySetSpec,omitempty"`
	// SearchRequest: Required. The search request that is used to perform the
	// evaluation. Only the following fields within SearchRequest are supported; if
	// any other fields are provided, an UNSUPPORTED error will be returned: *
	// SearchRequest.serving_config * SearchRequest.branch *
	// SearchRequest.canonical_filter * SearchRequest.query_expansion_spec *
	// SearchRequest.spell_correction_spec * SearchRequest.content_search_spec *
	// SearchRequest.user_pseudo_id
	SearchRequest *GoogleCloudDiscoveryengineV1alphaSearchRequest `json:"searchRequest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuerySetSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuerySetSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpecQuerySetSpec:
// Describes the specification of the query set.
type GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpecQuerySetSpec struct {
	// SampleQuerySet: Required. The full resource name of the SampleQuerySet used
	// for the evaluation, in the format of
	// `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
	SampleQuerySet string `json:"sampleQuerySet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SampleQuerySet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SampleQuerySet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpecQuerySetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpecQuerySetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaFetchSitemapsResponse: Response message for
// SiteSearchEngineService.FetchSitemaps method.
type GoogleCloudDiscoveryengineV1alphaFetchSitemapsResponse struct {
	// SitemapsMetadata: List of Sitemaps fetched.
	SitemapsMetadata []*GoogleCloudDiscoveryengineV1alphaFetchSitemapsResponseSitemapMetadata `json:"sitemapsMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SitemapsMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SitemapsMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaFetchSitemapsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaFetchSitemapsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaFetchSitemapsResponseSitemapMetadata:
// Contains a Sitemap and its metadata.
type GoogleCloudDiscoveryengineV1alphaFetchSitemapsResponseSitemapMetadata struct {
	// Sitemap: The Sitemap.
	Sitemap *GoogleCloudDiscoveryengineV1alphaSitemap `json:"sitemap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Sitemap") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Sitemap") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaFetchSitemapsResponseSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaFetchSitemapsResponseSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaFieldConfig: Configurations for fields of a
// schema. For example, configuring a field is indexable, or searchable.
type GoogleCloudDiscoveryengineV1alphaFieldConfig struct {
	// AdvancedSiteSearchDataSources: If this field is set, only the corresponding
	// source will be indexed for this field. Otherwise, the values from different
	// sources are merged. Assuming a page with `` in meta tag, and `` in page map:
	// if this enum is set to METATAGS, we will only index ``; if this enum is not
	// set, we will merge them and index ``.
	//
	// Possible values:
	//   "ADVANCED_SITE_SEARCH_DATA_SOURCE_UNSPECIFIED" - Value used when unset.
	//   "METATAGS" - Retrieve value from meta tag.
	//   "PAGEMAP" - Retrieve value from page map.
	//   "URI_PATTERN_MAPPING" - Retrieve value from the attributes set by
	// SiteSearchEngineService.SetUriPatternDocumentData API.
	//   "SCHEMA_ORG" - Retrieve value from schema.org data.
	AdvancedSiteSearchDataSources []string `json:"advancedSiteSearchDataSources,omitempty"`
	// CompletableOption: If completable_option is COMPLETABLE_ENABLED, field
	// values are directly used and returned as suggestions for Autocomplete in
	// CompletionService.CompleteQuery. If completable_option is unset, the server
	// behavior defaults to COMPLETABLE_DISABLED for fields that support setting
	// completable options, which are just `string` fields. For those fields that
	// do not support setting completable options, the server will skip completable
	// option setting, and setting completable_option for those fields will throw
	// `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "COMPLETABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "COMPLETABLE_ENABLED" - Completable option enabled for a schema field.
	//   "COMPLETABLE_DISABLED" - Completable option disabled for a schema field.
	CompletableOption string `json:"completableOption,omitempty"`
	// DynamicFacetableOption: If dynamic_facetable_option is
	// DYNAMIC_FACETABLE_ENABLED, field values are available for dynamic facet.
	// Could only be DYNAMIC_FACETABLE_DISABLED if FieldConfig.indexable_option is
	// INDEXABLE_DISABLED. Otherwise, an `INVALID_ARGUMENT` error will be returned.
	// If dynamic_facetable_option is unset, the server behavior defaults to
	// DYNAMIC_FACETABLE_DISABLED for fields that support setting dynamic facetable
	// options. For those fields that do not support setting dynamic facetable
	// options, such as `object` and `boolean`, the server will skip dynamic
	// facetable option setting, and setting dynamic_facetable_option for those
	// fields will throw `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "DYNAMIC_FACETABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "DYNAMIC_FACETABLE_ENABLED" - Dynamic facetable option enabled for a
	// schema field.
	//   "DYNAMIC_FACETABLE_DISABLED" - Dynamic facetable option disabled for a
	// schema field.
	DynamicFacetableOption string `json:"dynamicFacetableOption,omitempty"`
	// FieldPath: Required. Field path of the schema field. For example: `title`,
	// `description`, `release_info.release_year`.
	FieldPath string `json:"fieldPath,omitempty"`
	// FieldType: Output only. Raw type of the field.
	//
	// Possible values:
	//   "FIELD_TYPE_UNSPECIFIED" - Field type is unspecified.
	//   "OBJECT" - Field value type is Object.
	//   "STRING" - Field value type is String.
	//   "NUMBER" - Field value type is Number.
	//   "INTEGER" - Field value type is Integer.
	//   "BOOLEAN" - Field value type is Boolean.
	//   "GEOLOCATION" - Field value type is Geolocation. Geolocation is expressed
	// as an object with the following keys: * `id`: a string representing the
	// location id * `longitude`: a number representing the longitude coordinate of
	// the location * `latitude`: a number repesenting the latitude coordinate of
	// the location * `address`: a string representing the full address of the
	// location `latitude` and `longitude` must always be provided together. At
	// least one of a) `address` or b) `latitude`-`longitude` pair must be
	// provided.
	//   "DATETIME" - Field value type is Datetime. Datetime can be expressed as
	// either: * a number representing milliseconds-since-the-epoch * a string
	// representing milliseconds-since-the-epoch. e.g. "1420070400001" * a string
	// representing the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date or
	// date and time. e.g. "2015-01-01" or "2015-01-01T12:10:30Z"
	FieldType string `json:"fieldType,omitempty"`
	// IndexableOption: If indexable_option is INDEXABLE_ENABLED, field values are
	// indexed so that it can be filtered or faceted in SearchService.Search. If
	// indexable_option is unset, the server behavior defaults to
	// INDEXABLE_DISABLED for fields that support setting indexable options. For
	// those fields that do not support setting indexable options, such as `object`
	// and `boolean` and key properties, the server will skip indexable_option
	// setting, and setting indexable_option for those fields will throw
	// `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "INDEXABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "INDEXABLE_ENABLED" - Indexable option enabled for a schema field.
	//   "INDEXABLE_DISABLED" - Indexable option disabled for a schema field.
	IndexableOption string `json:"indexableOption,omitempty"`
	// KeyPropertyType: Output only. Type of the key property that this field is
	// mapped to. Empty string if this is not annotated as mapped to a key
	// property. Example types are `title`, `description`. Full list is defined by
	// `keyPropertyMapping` in the schema field annotation. If the schema field has
	// a `KeyPropertyMapping` annotation, `indexable_option` and
	// `searchable_option` of this field cannot be modified.
	KeyPropertyType string `json:"keyPropertyType,omitempty"`
	// MetatagName: Optional. The metatag name found in the HTML page. If user
	// defines this field, the value of this metatag name will be used to extract
	// metatag. If the user does not define this field, the FieldConfig.field_path
	// will be used to extract metatag.
	MetatagName string `json:"metatagName,omitempty"`
	// RecsFilterableOption: If recs_filterable_option is FILTERABLE_ENABLED, field
	// values are filterable by filter expression in
	// RecommendationService.Recommend. If FILTERABLE_ENABLED but the field type is
	// numerical, field values are not filterable by text queries in
	// RecommendationService.Recommend. Only textual fields are supported. If
	// recs_filterable_option is unset, the default setting is FILTERABLE_DISABLED
	// for fields that support setting filterable options. When a field set to
	// [FILTERABLE_DISABLED] is filtered, a warning is generated and an empty
	// result is returned.
	//
	// Possible values:
	//   "FILTERABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "FILTERABLE_ENABLED" - Filterable option enabled for a schema field.
	//   "FILTERABLE_DISABLED" - Filterable option disabled for a schema field.
	RecsFilterableOption string `json:"recsFilterableOption,omitempty"`
	// RetrievableOption: If retrievable_option is RETRIEVABLE_ENABLED, field
	// values are included in the search results. If retrievable_option is unset,
	// the server behavior defaults to RETRIEVABLE_DISABLED for fields that support
	// setting retrievable options. For those fields that do not support setting
	// retrievable options, such as `object` and `boolean`, the server will skip
	// retrievable option setting, and setting retrievable_option for those fields
	// will throw `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "RETRIEVABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "RETRIEVABLE_ENABLED" - Retrievable option enabled for a schema field.
	//   "RETRIEVABLE_DISABLED" - Retrievable option disabled for a schema field.
	RetrievableOption string `json:"retrievableOption,omitempty"`
	// SchemaOrgPaths: Field paths for indexing custom attribute from schema.org
	// data. More details of schema.org and its defined types can be found at
	// schema.org (https://schema.org). It is only used on advanced site search
	// schema. Currently only support full path from root. The full path to a field
	// is constructed by concatenating field names, starting from `_root`, with a
	// period `.` as the delimiter. Examples: * Publish date of the root:
	// _root.datePublished * Publish date of the reviews:
	// _root.review.datePublished
	SchemaOrgPaths []string `json:"schemaOrgPaths,omitempty"`
	// SearchableOption: If searchable_option is SEARCHABLE_ENABLED, field values
	// are searchable by text queries in SearchService.Search. If
	// SEARCHABLE_ENABLED but field type is numerical, field values will not be
	// searchable by text queries in SearchService.Search, as there are no text
	// values associated to numerical fields. If searchable_option is unset, the
	// server behavior defaults to SEARCHABLE_DISABLED for fields that support
	// setting searchable options. Only `string` fields that have no key property
	// mapping support setting searchable_option. For those fields that do not
	// support setting searchable options, the server will skip searchable option
	// setting, and setting searchable_option for those fields will throw
	// `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "SEARCHABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "SEARCHABLE_ENABLED" - Searchable option enabled for a schema field.
	//   "SEARCHABLE_DISABLED" - Searchable option disabled for a schema field.
	SearchableOption string `json:"searchableOption,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AdvancedSiteSearchDataSources") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSiteSearchDataSources")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaFieldConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaFieldConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaGetSessionRequest: Request for GetSession
// method.
type GoogleCloudDiscoveryengineV1alphaGetSessionRequest struct {
	// IncludeAnswerDetails: Optional. If set to true, the full session including
	// all answer details will be returned.
	IncludeAnswerDetails bool `json:"includeAnswerDetails,omitempty"`
	// Name: Required. The resource name of the Session to get. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store_id}/sessions/{session_id}`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeAnswerDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeAnswerDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaGetSessionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaGetSessionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaGetUriPatternDocumentDataResponse: Response
// message for SiteSearchEngineService.GetUriPatternDocumentData method.
type GoogleCloudDiscoveryengineV1alphaGetUriPatternDocumentDataResponse struct {
	// DocumentDataMap: Document data keyed by URI pattern. For example:
	// document_data_map = { "www.url1.com/*": { "Categories": ["category1",
	// "category2"] }, "www.url2.com/*": { "Categories": ["category3"] } }
	DocumentDataMap map[string]googleapi.RawMessage `json:"documentDataMap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentDataMap") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentDataMap") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaGetUriPatternDocumentDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaGetUriPatternDocumentDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaIdpConfig: Identity Provider Config.
type GoogleCloudDiscoveryengineV1alphaIdpConfig struct {
	// ExternalIdpConfig: External Identity provider config.
	ExternalIdpConfig *GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig `json:"externalIdpConfig,omitempty"`
	// IdpType: Identity provider type configured.
	//
	// Possible values:
	//   "IDP_TYPE_UNSPECIFIED" - Default value. ACL search not enabled.
	//   "GSUITE" - Google 1P provider.
	//   "THIRD_PARTY" - Third party provider.
	IdpType string `json:"idpType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExternalIdpConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalIdpConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaIdpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaIdpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig: Third party IDP
// Config.
type GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig struct {
	// WorkforcePoolName: Workforce pool name. Example:
	// "locations/global/workforcePools/pool_id"
	WorkforcePoolName string `json:"workforcePoolName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WorkforcePoolName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WorkforcePoolName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsMetadata:
// Metadata related to the progress of the ImportCompletionSuggestions
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of CompletionSuggestions that failed to be imported.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of CompletionSuggestions successfully imported.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsResponse:
// Response of the CompletionService.ImportCompletionSuggestions method. If the
// long running operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsResponse struct {
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata: Metadata related
// to the progress of the ImportDocuments operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: Total count of entries that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse: Response of the
// ImportDocumentsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1alphaImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors are written to sharded files
	// in this directory, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportErrorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSampleQueriesMetadata: Metadata
// related to the progress of the ImportSampleQueries operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportSampleQueriesMetadata struct {
	// CreateTime: ImportSampleQueries operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of SampleQuerys that failed to be imported.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of SampleQuerys successfully imported.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: Total count of SampleQuerys that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// UpdateTime: ImportSampleQueries operation last update time. If the operation
	// is done, this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportSampleQueriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSampleQueriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSampleQueriesResponse: Response of
// the SampleQueryService.ImportSampleQueries method. If the long running
// operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type GoogleCloudDiscoveryengineV1alphaImportSampleQueriesResponse struct {
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportSampleQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSampleQueriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the ImportSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse:
// Response message for CompletionService.ImportSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// FailedEntriesCount: Count of deny list entries that failed to be imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`
	// ImportedEntriesCount: Count of deny list entries successfully imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata: Metadata related
// to the progress of the Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// JoinedEventsCount: Count of user events imported with complete existing
	// Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaInterval: A floating point interval.
type GoogleCloudDiscoveryengineV1alphaInterval struct {
	// ExclusiveMaximum: Exclusive upper bound.
	ExclusiveMaximum float64 `json:"exclusiveMaximum,omitempty"`
	// ExclusiveMinimum: Exclusive lower bound.
	ExclusiveMinimum float64 `json:"exclusiveMinimum,omitempty"`
	// Maximum: Inclusive upper bound.
	Maximum float64 `json:"maximum,omitempty"`
	// Minimum: Inclusive lower bound.
	Minimum float64 `json:"minimum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExclusiveMaximum") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExclusiveMaximum") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaInterval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaInterval
	var s1 struct {
		ExclusiveMaximum gensupport.JSONFloat64 `json:"exclusiveMaximum"`
		ExclusiveMinimum gensupport.JSONFloat64 `json:"exclusiveMinimum"`
		Maximum          gensupport.JSONFloat64 `json:"maximum"`
		Minimum          gensupport.JSONFloat64 `json:"minimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExclusiveMaximum = float64(s1.ExclusiveMaximum)
	s.ExclusiveMinimum = float64(s1.ExclusiveMinimum)
	s.Maximum = float64(s1.Maximum)
	s.Minimum = float64(s1.Minimum)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaLanguageInfo: Language info for DataStore.
type GoogleCloudDiscoveryengineV1alphaLanguageInfo struct {
	// Language: Output only. Language part of normalized_language_code. E.g.:
	// `en-US` -> `en`, `zh-Hans-HK` -> `zh`, `en` -> `en`.
	Language string `json:"language,omitempty"`
	// LanguageCode: The language code for the DataStore.
	LanguageCode string `json:"languageCode,omitempty"`
	// NormalizedLanguageCode: Output only. This is the normalized form of
	// language_code. E.g.: language_code of `en-GB`, `en_GB`, `en-UK` or `en-gb`
	// will have normalized_language_code of `en-GB`.
	NormalizedLanguageCode string `json:"normalizedLanguageCode,omitempty"`
	// Region: Output only. Region part of normalized_language_code, if present.
	// E.g.: `en-US` -> `US`, `zh-Hans-HK` -> `HK`, `en` -> ``.
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Language") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Language") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaLanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaLanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaListSessionsRequest: Request for
// ListSessions method.
type GoogleCloudDiscoveryengineV1alphaListSessionsRequest struct {
	// Filter: A filter to apply on the list results. The supported features are:
	// user_pseudo_id, state. Example: "user_pseudo_id = some_id"
	Filter string `json:"filter,omitempty"`
	// OrderBy: A comma-separated list of fields to order by, sorted in ascending
	// order. Use "desc" after a field name for descending. Supported fields: *
	// `update_time` * `create_time` * `session_name` * `is_pinned` Example: *
	// "update_time desc" * "create_time" * "is_pinned desc,update_time desc": list
	// sessions by is_pinned first, then by update_time.
	OrderBy string `json:"orderBy,omitempty"`
	// PageSize: Maximum number of results to return. If unspecified, defaults to
	// 50. Max allowed value is 1000.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token, received from a previous `ListSessions` call.
	// Provide this to retrieve the subsequent page.
	PageToken string `json:"pageToken,omitempty"`
	// Parent: Required. The data store resource name. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store_id}`
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaListSessionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaListSessionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaListSessionsResponse: Response for
// ListSessions method.
type GoogleCloudDiscoveryengineV1alphaListSessionsResponse struct {
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Sessions: All the Sessions for a given data store.
	Sessions []*GoogleCloudDiscoveryengineV1alphaSession `json:"sessions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaListSessionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaListSessionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaNaturalLanguageQueryUnderstandingConfig:
// Configuration for Natural Language Query Understanding.
type GoogleCloudDiscoveryengineV1alphaNaturalLanguageQueryUnderstandingConfig struct {
	// Mode: Mode of Natural Language Query Understanding. If this field is unset,
	// the behavior defaults to
	// NaturalLanguageQueryUnderstandingConfig.Mode.DISABLED.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value.
	//   "DISABLED" - Natural Language Query Understanding is disabled.
	//   "ENABLED" - Natural Language Query Understanding is enabled.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaNaturalLanguageQueryUnderstandingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaNaturalLanguageQueryUnderstandingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaObtainCrawlRateResponse: Response message
// for CrawlRateManagementService.ObtainCrawlRate method. The response contains
// organcic or dedicated crawl rate time series data for monitoring, depending
// on whether dedicated crawl rate is set.
type GoogleCloudDiscoveryengineV1alphaObtainCrawlRateResponse struct {
	// DedicatedCrawlRateTimeSeries: The historical dedicated crawl rate timeseries
	// data, used for monitoring.
	DedicatedCrawlRateTimeSeries *GoogleCloudDiscoveryengineV1alphaDedicatedCrawlRateTimeSeries `json:"dedicatedCrawlRateTimeSeries,omitempty"`
	// Error: Errors from service when handling the request.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// OrganicCrawlRateTimeSeries: The historical organic crawl rate timeseries
	// data, used for monitoring.
	OrganicCrawlRateTimeSeries *GoogleCloudDiscoveryengineV1alphaOrganicCrawlRateTimeSeries `json:"organicCrawlRateTimeSeries,omitempty"`
	// State: Output only. The state of the response.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state is unspecified.
	//   "SUCCEEDED" - The state is successful.
	//   "FAILED" - The state is failed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DedicatedCrawlRateTimeSeries") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DedicatedCrawlRateTimeSeries") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaObtainCrawlRateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaObtainCrawlRateResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaOrganicCrawlRateTimeSeries: The historical
// organic crawl rate timeseries data, used for monitoring. Organic crawl is
// auto-determined by Google to crawl the user's website when dedicate crawl is
// not set. Crawl rate is the QPS of crawl request Google sends to the user's
// website.
type GoogleCloudDiscoveryengineV1alphaOrganicCrawlRateTimeSeries struct {
	// GoogleOrganicCrawlRate: Google's organic crawl rate time series, which is
	// the sum of all googlebots' crawl rate. Please refer to
	// https://developers.google.com/search/docs/crawling-indexing/overview-google-crawlers
	// for more details about googlebots.
	GoogleOrganicCrawlRate *GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries `json:"googleOrganicCrawlRate,omitempty"`
	// VertexAiOrganicCrawlRate: Vertex AI's organic crawl rate time series, which
	// is the crawl rate of Google-CloudVertexBot when dedicate crawl is not set.
	// Please refer to
	// https://developers.google.com/search/docs/crawling-indexing/google-common-crawlers#google-cloudvertexbot
	// for more details about Google-CloudVertexBot.
	VertexAiOrganicCrawlRate *GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries `json:"vertexAiOrganicCrawlRate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GoogleOrganicCrawlRate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoogleOrganicCrawlRate") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaOrganicCrawlRateTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaOrganicCrawlRateTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaProject: Metadata and configurations for a
// Google Cloud project in the service.
type GoogleCloudDiscoveryengineV1alphaProject struct {
	// CreateTime: Output only. The timestamp when this project is created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. Full resource name of the project, for example
	// `projects/{project}`. Note that when making requests, project number and
	// project id are both acceptable, but the server will always respond in
	// project number.
	Name string `json:"name,omitempty"`
	// ProvisionCompletionTime: Output only. The timestamp when this project is
	// successfully provisioned. Empty value means this project is still
	// provisioning and is not ready for use.
	ProvisionCompletionTime string `json:"provisionCompletionTime,omitempty"`
	// ServiceTermsMap: Output only. A map of terms of services. The key is the
	// `id` of ServiceTerms.
	ServiceTermsMap map[string]GoogleCloudDiscoveryengineV1alphaProjectServiceTerms `json:"serviceTermsMap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaProject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaProject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaProjectServiceTerms: Metadata about the
// terms of service.
type GoogleCloudDiscoveryengineV1alphaProjectServiceTerms struct {
	// AcceptTime: The last time when the project agreed to the terms of service.
	AcceptTime string `json:"acceptTime,omitempty"`
	// DeclineTime: The last time when the project declined or revoked the
	// agreement to terms of service.
	DeclineTime string `json:"declineTime,omitempty"`
	// Id: The unique identifier of this terms of service. Available terms: *
	// `GA_DATA_USE_TERMS`: Terms for data use
	// (https://cloud.google.com/retail/data-use-terms). When using this as `id`,
	// the acceptable version to provide is `2022-11-23`.
	Id string `json:"id,omitempty"`
	// State: Whether the project has accepted/rejected the service terms or it is
	// still pending.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value of the enum. This value is not
	// actually used.
	//   "TERMS_ACCEPTED" - The project has given consent to the terms of service.
	//   "TERMS_PENDING" - The project is pending to review and accept the terms of
	// service.
	//   "TERMS_DECLINED" - The project has declined or revoked the agreement to
	// terms of service.
	State string `json:"state,omitempty"`
	// Version: The version string of the terms of service. For acceptable values,
	// see the comments for id above.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaProjectServiceTerms) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaProjectServiceTerms
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaProvisionProjectMetadata: Metadata
// associated with a project provision operation.
type GoogleCloudDiscoveryengineV1alphaProvisionProjectMetadata struct {
}

// GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsMetadata:
// Metadata related to the progress of the PurgeCompletionSuggestions
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsResponse:
// Response message for CompletionService.PurgeCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeSucceeded: Whether the completion suggestions were successfully purged.
	PurgeSucceeded bool `json:"purgeSucceeded,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata: Metadata related to
// the progress of the PurgeDocuments operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// IgnoredCount: Count of entries that were ignored as entries were not found.
	IgnoredCount int64 `json:"ignoredCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse: Response message
// for DocumentService.PurgeDocuments method. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of document names that will be deleted. Only populated
	// if `force` is set to false. A max of 100 names will be returned and the
	// names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the PurgeSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse:
// Response message for CompletionService.PurgeSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata: Metadata related
// to the progress of the PurgeUserEvents operation. This will be returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully done,
// then this message is returned by the google.longrunning.Operations.response
// field.
type GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse struct {
	// PurgeCount: The total count of events purged as a result of the operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaQualityMetrics: Describes the metrics
// produced by the evaluation.
type GoogleCloudDiscoveryengineV1alphaQualityMetrics struct {
	// DocNdcg: Normalized discounted cumulative gain (NDCG) per document, at
	// various top-k cutoff levels. NDCG measures the ranking quality, giving
	// higher relevance to top results. Example (top-3): Suppose SampleQuery with
	// three retrieved documents (D1, D2, D3) and binary relevance judgements (1
	// for relevant, 0 for not relevant): Retrieved: [D3 (0), D1 (1), D2 (1)]
	// Ideal: [D1 (1), D2 (1), D3 (0)] Calculate NDCG@3 for each SampleQuery: *
	// DCG@3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13 * Ideal DCG@3:
	// 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63 * NDCG@3: 1.13/1.63 = 0.693
	DocNdcg *GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics `json:"docNdcg,omitempty"`
	// DocPrecision: Precision per document, at various top-k cutoff levels.
	// Precision is the fraction of retrieved documents that are relevant. Example
	// (top-5): * For a single SampleQuery, If 4 out of 5 retrieved documents in
	// the top-5 are relevant, precision@5 = 4/5 = 0.8
	DocPrecision *GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics `json:"docPrecision,omitempty"`
	// DocRecall: Recall per document, at various top-k cutoff levels. Recall is
	// the fraction of relevant documents retrieved out of all relevant documents.
	// Example (top-5): * For a single SampleQuery, If 3 out of 5 relevant
	// documents are retrieved in the top-5, recall@5 = 3/5 = 0.6
	DocRecall *GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics `json:"docRecall,omitempty"`
	// PageNdcg: Normalized discounted cumulative gain (NDCG) per page, at various
	// top-k cutoff levels. NDCG measures the ranking quality, giving higher
	// relevance to top results. Example (top-3): Suppose SampleQuery with three
	// retrieved pages (P1, P2, P3) and binary relevance judgements (1 for
	// relevant, 0 for not relevant): Retrieved: [P3 (0), P1 (1), P2 (1)] Ideal:
	// [P1 (1), P2 (1), P3 (0)] Calculate NDCG@3 for SampleQuery: * DCG@3:
	// 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13 * Ideal DCG@3: 1/log2(1+1) +
	// 1/log2(2+1) + 0/log2(3+1) = 1.63 * NDCG@3: 1.13/1.63 = 0.693
	PageNdcg *GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics `json:"pageNdcg,omitempty"`
	// PageRecall: Recall per page, at various top-k cutoff levels. Recall is the
	// fraction of relevant pages retrieved out of all relevant pages. Example
	// (top-5): * For a single SampleQuery, if 3 out of 5 relevant pages are
	// retrieved in the top-5, recall@5 = 3/5 = 0.6
	PageRecall *GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics `json:"pageRecall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocNdcg") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocNdcg") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaQualityMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaQualityMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics: Stores the
// metric values at specific top-k levels.
type GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics struct {
	// Top1: The top-1 value.
	Top1 float64 `json:"top1,omitempty"`
	// Top10: The top-10 value.
	Top10 float64 `json:"top10,omitempty"`
	// Top3: The top-3 value.
	Top3 float64 `json:"top3,omitempty"`
	// Top5: The top-5 value.
	Top5 float64 `json:"top5,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Top1") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Top1") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics
	var s1 struct {
		Top1  gensupport.JSONFloat64 `json:"top1"`
		Top10 gensupport.JSONFloat64 `json:"top10"`
		Top3  gensupport.JSONFloat64 `json:"top3"`
		Top5  gensupport.JSONFloat64 `json:"top5"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Top1 = float64(s1.Top1)
	s.Top10 = float64(s1.Top10)
	s.Top3 = float64(s1.Top3)
	s.Top5 = float64(s1.Top5)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaQuery: Defines a user inputed query.
type GoogleCloudDiscoveryengineV1alphaQuery struct {
	// QueryId: Unique Id for the query.
	QueryId string `json:"queryId,omitempty"`
	// Text: Plain text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata: Metadata related to
// the progress of the SiteSearchEngineService.RecrawlUris operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// InvalidUris: Unique URIs in the request that have invalid format. Sample
	// limited to 1000.
	InvalidUris []string `json:"invalidUris,omitempty"`
	// InvalidUrisCount: Total number of unique URIs in the request that have
	// invalid format.
	InvalidUrisCount int64 `json:"invalidUrisCount,omitempty"`
	// PendingCount: Total number of URIs that have yet to be crawled.
	PendingCount int64 `json:"pendingCount,omitempty"`
	// QuotaExceededCount: Total number of URIs that were rejected due to
	// insufficient indexing resources.
	QuotaExceededCount int64 `json:"quotaExceededCount,omitempty"`
	// SuccessCount: Total number of URIs that have been crawled so far.
	SuccessCount int64 `json:"successCount,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// UrisNotMatchingTargetSites: Unique URIs in the request that don't match any
	// TargetSite in the DataStore, only match TargetSites that haven't been fully
	// indexed, or match a TargetSite with type EXCLUDE. Sample limited to 1000.
	UrisNotMatchingTargetSites []string `json:"urisNotMatchingTargetSites,omitempty"`
	// UrisNotMatchingTargetSitesCount: Total number of URIs that don't match any
	// TargetSites.
	UrisNotMatchingTargetSitesCount int64 `json:"urisNotMatchingTargetSitesCount,omitempty"`
	// ValidUrisCount: Total number of unique URIs in the request that are not in
	// invalid_uris.
	ValidUrisCount int64 `json:"validUrisCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse: Response message for
// SiteSearchEngineService.RecrawlUris method.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse struct {
	// FailedUris: URIs that were not crawled before the LRO terminated.
	FailedUris []string `json:"failedUris,omitempty"`
	// FailureSamples: Details for a sample of up to 10 `failed_uris`.
	FailureSamples []*GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo `json:"failureSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo: Details
// about why a particular URI failed to be crawled. Each FailureInfo contains
// one FailureReason per CorpusType.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo struct {
	// FailureReasons: List of failure reasons by corpus type (e.g. desktop,
	// mobile).
	FailureReasons []*GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason `json:"failureReasons,omitempty"`
	// Uri: URI that failed to be crawled.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailureReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailureReasons") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason:
//
//	Details about why crawling failed for a particular CorpusType, e.g.,
//
// DESKTOP and MOBILE crawling may fail for different reasons.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason struct {
	// CorpusType: DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
	//
	// Possible values:
	//   "CORPUS_TYPE_UNSPECIFIED" - Default value.
	//   "DESKTOP" - Denotes a crawling attempt for the desktop version of a page.
	//   "MOBILE" - Denotes a crawling attempt for the mobile version of a page.
	CorpusType string `json:"corpusType,omitempty"`
	// ErrorMessage: Reason why the URI was not crawled.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorpusType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorpusType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSchema: Defines the structure and layout of
// a type of document data.
type GoogleCloudDiscoveryengineV1alphaSchema struct {
	// FieldConfigs: Output only. Configurations for fields of the schema.
	FieldConfigs []*GoogleCloudDiscoveryengineV1alphaFieldConfig `json:"fieldConfigs,omitempty"`
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`
	// Name: Immutable. The full resource name of the schema, in the format of
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/schemas/{schema}`. This field must be a UTF-8 encoded string
	// with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchLinkPromotion: Promotion proto
// includes uri and other helping information to display the promotion.
type GoogleCloudDiscoveryengineV1alphaSearchLinkPromotion struct {
	// Description: Optional. The Promotion description. Maximum length: 200
	// characters.
	Description string `json:"description,omitempty"`
	// Enabled: Optional. The enabled promotion will be returned for any serving
	// configs associated with the parent of the control this promotion is attached
	// to. This flag is used for basic site search only.
	Enabled bool `json:"enabled,omitempty"`
	// ImageUri: Optional. The promotion thumbnail image url.
	ImageUri string `json:"imageUri,omitempty"`
	// Title: Required. The title of the promotion. Maximum length: 160 characters.
	Title string `json:"title,omitempty"`
	// Uri: Required. The URL for the page the user wants to promote.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchLinkPromotion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchLinkPromotion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequest: Request message for
// SearchService.Search method.
type GoogleCloudDiscoveryengineV1alphaSearchRequest struct {
	// BoostSpec: Boost specification to boost certain documents. For more
	// information on boosting, see Boosting
	// (https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
	BoostSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// Branch: The branch resource name, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/defaul
	// t_data_store/branches/0`. Use `default_branch` as the branch ID or leave
	// this field empty, to search documents under the default branch.
	Branch string `json:"branch,omitempty"`
	// CanonicalFilter: The default filter that is applied when a user performs a
	// search without checking any filters on the search page. The filter applied
	// to every search request when quality improvement such as query expansion is
	// needed. In the case a query does not have a sufficient amount of results
	// this filter will be used to determine whether or not to enable the query
	// expansion flow. The original filter will still be used for the query
	// expanded search. This field is strongly recommended to achieve high search
	// quality. For more information about filter syntax, see SearchRequest.filter.
	CanonicalFilter string `json:"canonicalFilter,omitempty"`
	// ContentSearchSpec: A specification for configuring the behavior of content
	// search.
	ContentSearchSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec `json:"contentSearchSpec,omitempty"`
	// CustomFineTuningSpec: Custom fine tuning configs. If set, it has higher
	// priority than the configs set in ServingConfig.custom_fine_tuning_spec.
	CustomFineTuningSpec *GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec `json:"customFineTuningSpec,omitempty"`
	// DataStoreSpecs: Specs defining DataStores to filter on in a search call and
	// configurations for those data stores. This is only considered for Engines
	// with multiple data stores. For engines with a single data store, the specs
	// directly under SearchRequest should be used.
	DataStoreSpecs []*GoogleCloudDiscoveryengineV1alphaSearchRequestDataStoreSpec `json:"dataStoreSpecs,omitempty"`
	// EmbeddingSpec: Uses the provided embedding to do additional semantic
	// document retrieval. The retrieval is based on the dot product of
	// SearchRequest.EmbeddingSpec.EmbeddingVector.vector and the document
	// embedding that is provided in
	// SearchRequest.EmbeddingSpec.EmbeddingVector.field_path. If
	// SearchRequest.EmbeddingSpec.EmbeddingVector.field_path is not provided, it
	// will use ServingConfig.EmbeddingConfig.field_path.
	EmbeddingSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec `json:"embeddingSpec,omitempty"`
	// FacetSpecs: Facet specifications for faceted search. If empty, no facets are
	// returned. A maximum of 100 values are allowed. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	FacetSpecs []*GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec `json:"facetSpecs,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customer might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// ImageQuery: Raw image query.
	ImageQuery *GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery `json:"imageQuery,omitempty"`
	// LanguageCode: The BCP-47 language code, such as "en-US" or "sr-Latn". For
	// more information, see Standard fields
	// (https://cloud.google.com/apis/design/standard_fields). This field helps to
	// better interpret the query. If a value isn't specified, the query language
	// code is automatically detected, which may not be accurate.
	LanguageCode string `json:"languageCode,omitempty"`
	// NaturalLanguageQueryUnderstandingSpec: If
	// `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
	// natural language query understanding will be done.
	NaturalLanguageQueryUnderstandingSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestNaturalLanguageQueryUnderstandingSpec `json:"naturalLanguageQueryUnderstandingSpec,omitempty"`
	// Offset: A 0-indexed integer that specifies the current offset (that is,
	// starting result location, amongst the Documents deemed by the API as
	// relevant) in search results. This field is only considered if page_token is
	// unset. If this field is negative, an `INVALID_ARGUMENT` is returned.
	Offset int64 `json:"offset,omitempty"`
	// OneBoxPageSize: The maximum number of results to return for OneBox. This
	// applies to each OneBox type individually. Default number is 10.
	OneBoxPageSize int64 `json:"oneBoxPageSize,omitempty"`
	// OrderBy: The order in which documents are returned. Documents can be ordered
	// by a field in an Document object. Leave it unset if ordered by relevance.
	// `order_by` expression is case-sensitive. For more information on ordering
	// the website search results, see Order web search results
	// (https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
	// For more information on ordering the healthcare search results, see Order
	// healthcare search results
	// (https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
	// If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// PageSize: Maximum number of Documents to return. The maximum allowed value
	// depends on the data type. Values above the maximum value are coerced to the
	// maximum value. * Websites with basic indexing: Default `10`, Maximum `25`. *
	// Websites with advanced indexing: Default `25`, Maximum `50`. * Other:
	// Default `50`, Maximum `100`. If this field is negative, an
	// `INVALID_ARGUMENT` is returned.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token received from a previous SearchService.Search call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to SearchService.Search must match the call that
	// provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
	PageToken string `json:"pageToken,omitempty"`
	// Params: Additional search parameters. For public website search only,
	// supported values are: * `user_country_code`: string. Default empty. If set
	// to non-empty, results are restricted or boosted based on the location
	// provided. For example, `user_country_code: "au" For available codes see
	// Country Codes
	// (https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
	// * `search_type`: double. Default empty. Enables non-webpage searching
	// depending on the value. The only valid non-default value is 1, which enables
	// image searching. For example, `search_type: 1`
	Params googleapi.RawMessage `json:"params,omitempty"`
	// PersonalizationSpec: The specification for personalization. Notice that if
	// both ServingConfig.personalization_spec and
	// SearchRequest.personalization_spec are set,
	// SearchRequest.personalization_spec overrides
	// ServingConfig.personalization_spec.
	PersonalizationSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestPersonalizationSpec `json:"personalizationSpec,omitempty"`
	// Query: Raw search query.
	Query string `json:"query,omitempty"`
	// QueryExpansionSpec: The query expansion specification that specifies the
	// conditions under which query expansion occurs.
	QueryExpansionSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec `json:"queryExpansionSpec,omitempty"`
	// RankingExpression: The ranking expression controls the customized ranking on
	// retrieval documents. This overrides ServingConfig.ranking_expression. The
	// ranking expression is a single function or multiple functions that are
	// joined by "+". * ranking_expression = function, { " + ", function };
	// Supported functions: * double * relevance_score * double *
	// dotProduct(embedding_field_path) Function variables: * `relevance_score`:
	// pre-defined keywords, used for measure relevance between query and document.
	// * `embedding_field_path`: the document embedding field used with query
	// embedding vector. * `dotProduct`: embedding function between
	// embedding_field_path and query embedding vector. Example ranking expression:
	// If document has an embedding field doc_embedding, the ranking expression
	// could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
	RankingExpression string `json:"rankingExpression,omitempty"`
	// RegionCode: The Unicode country/region code (CLDR) of a location, such as
	// "US" and "419". For more information, see Standard fields
	// (https://cloud.google.com/apis/design/standard_fields). If set, then results
	// will be boosted based on the region_code provided.
	RegionCode string `json:"regionCode,omitempty"`
	// RelevanceThreshold: The relevance threshold of the search results. Default
	// to Google defined threshold, leveraging a balance of precision and recall to
	// deliver both highly accurate results and comprehensive coverage of relevant
	// information.
	//
	// Possible values:
	//   "RELEVANCE_THRESHOLD_UNSPECIFIED" - Default value. In this case, server
	// behavior defaults to Google defined threshold.
	//   "LOWEST" - Lowest relevance threshold.
	//   "LOW" - Low relevance threshold.
	//   "MEDIUM" - Medium relevance threshold.
	//   "HIGH" - High relevance threshold.
	RelevanceThreshold string `json:"relevanceThreshold,omitempty"`
	// SafeSearch: Whether to turn on safe search. This is only supported for
	// website search.
	SafeSearch bool `json:"safeSearch,omitempty"`
	// SearchAsYouTypeSpec: Search as you type configuration. Only supported for
	// the IndustryVertical.MEDIA vertical.
	SearchAsYouTypeSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestSearchAsYouTypeSpec `json:"searchAsYouTypeSpec,omitempty"`
	// ServingConfig: Required. The resource name of the Search serving config,
	// such as
	// `projects/*/locations/global/collections/default_collection/engines/*/serving
	// Configs/default_serving_config`, or
	// `projects/*/locations/global/collections/default_collection/dataStores/defaul
	// t_data_store/servingConfigs/default_serving_config`. This field is used to
	// identify the serving configuration name, set of models used to make the
	// search.
	ServingConfig string `json:"servingConfig,omitempty"`
	// Session: The session resource name. Optional. Session allows users to do
	// multi-turn /search API calls or coordination between /search API calls and
	// /answer API calls. Example #1 (multi-turn /search API calls): 1. Call
	// /search API with the auto-session mode (see below). 2. Call /search API with
	// the session ID generated in the first call. Here, the previous search query
	// gets considered in query standing. I.e., if the first query is "How did
	// Alphabet do in 2022?" and the current query is "How about 2023?", the
	// current query will be interpreted as "How did Alphabet do in 2023?". Example
	// #2 (coordination between /search API calls and /answer API calls): 1. Call
	// /search API with the auto-session mode (see below). 2. Call /answer API with
	// the session ID generated in the first call. Here, the answer generation
	// happens in the context of the search results from the first search call.
	// Auto-session mode: when `projects/.../sessions/-` is used, a new session
	// gets automatically created. Otherwise, users can use the create-session API
	// to create a session manually. Multi-turn Search feature is currently at
	// private GA stage. Please use v1alpha or v1beta version instead before we
	// launch this feature to public GA. Or ask for allowlisting through Google
	// Support team.
	Session string `json:"session,omitempty"`
	// SessionSpec: Session specification. Can be used only when `session` is set.
	SessionSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestSessionSpec `json:"sessionSpec,omitempty"`
	// SpellCorrectionSpec: The spell correction specification that specifies the
	// mode under which spell correction takes effect.
	SpellCorrectionSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec `json:"spellCorrectionSpec,omitempty"`
	// UserInfo: Information about the end user. Highly recommended for analytics.
	// UserInfo.user_agent is used to deduce `device_type` for analytics.
	UserInfo *GoogleCloudDiscoveryengineV1alphaUserInfo `json:"userInfo,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// UserPseudoId: A unique identifier for tracking visitors. For example, this
	// could be implemented with an HTTP cookie, which should be able to uniquely
	// identify a visitor on a single device. This unique identifier should not
	// change if the visitor logs in or out of the website. This field should NOT
	// have a fixed value such as `unknown_visitor`. This should be the same
	// identifier as UserEvent.user_pseudo_id and
	// CompleteQueryRequest.user_pseudo_id The field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec: Boost specification
// to boost certain documents.
type GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec struct {
	// ConditionBoostSpecs: Condition boost specifications. If a document matches
	// multiple conditions in the specifictions, boost scores from these
	// specifications are all applied and combined in a non-linear way. Maximum
	// number of specifications is 20.
	ConditionBoostSpecs []*GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec:
// Boost applies to documents which match a condition.
type GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec struct {
	// Boost: Strength of the condition boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0. Setting to 1.0 gives the document a
	// big promotion. However, it does not necessarily mean that the boosted
	// document will be the top result at all times, nor that other documents will
	// be excluded. Results could still be shown even when none of them matches the
	// condition. And results that are significantly more relevant to the search
	// query can still trump your heavily favored but irrelevant documents. Setting
	// to -1.0 gives the document a big demotion. However, results that are deeply
	// relevant might still be shown. The document will have an upstream battle to
	// get a fairly high ranking, but it is not blocked out completely. Setting to
	// 0.0 means no boost applied. The boosting condition is ignored. Only one of
	// the (condition, boost) combination or the boost_control_spec below are set.
	// If both are set then the global boost is ignored and the more fine-grained
	// boost_control_spec is applied.
	Boost float64 `json:"boost,omitempty"`
	// BoostControlSpec: Complex specification for custom ranking based on customer
	// defined attribute value.
	BoostControlSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec `json:"boostControlSpec,omitempty"`
	// Condition: An expression which specifies a boost condition. The syntax and
	// supported fields are the same as a filter expression. See
	// SearchRequest.filter for detail syntax and limitations. Examples: * To boost
	// documents with document ID "doc_1" or "doc_2", and color "Red" or "Blue":
	// `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoos
// tControlSpec: Specification for custom ranking based on customer specified
// attribute value. It provides more controls for customized ranking than the
// simple (condition, boost) combination above.
type GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec struct {
	// AttributeType: The attribute type to be used to determine the boost amount.
	// The attribute value can be derived from the field value of the specified
	// field_name. In the case of numerical it is straightforward i.e.
	// attribute_value = numerical_field_value. In the case of freshness however,
	// attribute_value = (time.now() - datetime_field_value).
	//
	// Possible values:
	//   "ATTRIBUTE_TYPE_UNSPECIFIED" - Unspecified AttributeType.
	//   "NUMERICAL" - The value of the numerical field will be used to dynamically
	// update the boost amount. In this case, the attribute_value (the x value) of
	// the control point will be the actual value of the numerical field for which
	// the boost_amount is specified.
	//   "FRESHNESS" - For the freshness use case the attribute value will be the
	// duration between the current time and the date in the datetime field
	// specified. The value must be formatted as an XSD `dayTimeDuration` value (a
	// restricted subset of an ISO 8601 duration value). The pattern for this is:
	// `nDnM]`. For example, `5D`, `3DT12H30M`, `T24H`.
	AttributeType string `json:"attributeType,omitempty"`
	// ControlPoints: The control points used to define the curve. The monotonic
	// function (defined through the interpolation_type above) passes through the
	// control points listed here.
	ControlPoints []*GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint `json:"controlPoints,omitempty"`
	// FieldName: The name of the field whose value will be used to determine the
	// boost amount.
	FieldName string `json:"fieldName,omitempty"`
	// InterpolationType: The interpolation type to be applied to connect the
	// control points listed below.
	//
	// Possible values:
	//   "INTERPOLATION_TYPE_UNSPECIFIED" - Interpolation type is unspecified. In
	// this case, it defaults to Linear.
	//   "LINEAR" - Piecewise linear interpolation will be applied.
	InterpolationType string `json:"interpolationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoos
// tControlSpecControlPoint: The control points used to define the curve. The
// curve defined through these control points can only be monotonically
// increasing or decreasing(constant values are acceptable).
type GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint struct {
	// AttributeValue: Can be one of: 1. The numerical field value. 2. The duration
	// spec for freshness: The value must be formatted as an XSD `dayTimeDuration`
	// value (a restricted subset of an ISO 8601 duration value). The pattern for
	// this is: `nDnM]`.
	AttributeValue string `json:"attributeValue,omitempty"`
	// BoostAmount: The value between -1 to 1 by which to boost the score if the
	// attribute_value evaluates to the value specified above.
	BoostAmount float64 `json:"boostAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	var s1 struct {
		BoostAmount gensupport.JSONFloat64 `json:"boostAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostAmount = float64(s1.BoostAmount)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec: A
// specification for configuring the behavior of content search.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec struct {
	// ChunkSpec: Specifies the chunk spec to be returned from the search response.
	// Only available if the SearchRequest.ContentSearchSpec.search_result_mode is
	// set to CHUNKS
	ChunkSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecChunkSpec `json:"chunkSpec,omitempty"`
	// ExtractiveContentSpec: If there is no extractive_content_spec provided,
	// there will be no extractive answer in the search response.
	ExtractiveContentSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec `json:"extractiveContentSpec,omitempty"`
	// SearchResultMode: Specifies the search result mode. If unspecified, the
	// search result mode defaults to `DOCUMENTS`.
	//
	// Possible values:
	//   "SEARCH_RESULT_MODE_UNSPECIFIED" - Default value.
	//   "DOCUMENTS" - Returns documents in the search result.
	//   "CHUNKS" - Returns chunks in the search result. Only available if the
	// DocumentProcessingConfig.chunking_config is specified.
	SearchResultMode string `json:"searchResultMode,omitempty"`
	// SnippetSpec: If `snippetSpec` is not specified, snippets are not included in
	// the search response.
	SnippetSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec `json:"snippetSpec,omitempty"`
	// SummarySpec: If `summarySpec` is not specified, summaries are not included
	// in the search response.
	SummarySpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecChunkSpec:
// Specifies the chunk spec to be returned from the search response. Only
// available if the SearchRequest.ContentSearchSpec.search_result_mode is set
// to CHUNKS
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecChunkSpec struct {
	// NumNextChunks: The number of next chunks to be returned of the current
	// chunk. The maximum allowed value is 3. If not specified, no next chunks will
	// be returned.
	NumNextChunks int64 `json:"numNextChunks,omitempty"`
	// NumPreviousChunks: The number of previous chunks to be returned of the
	// current chunk. The maximum allowed value is 3. If not specified, no previous
	// chunks will be returned.
	NumPreviousChunks int64 `json:"numPreviousChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumNextChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumNextChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecChunkSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecChunkSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveCont
// entSpec: A specification for configuring the extractive content in a search
// response.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec struct {
	// MaxExtractiveAnswerCount: The maximum number of extractive answers returned
	// in each search result. An extractive answer is a verbatim answer extracted
	// from the original document, which provides a precise and contextually
	// relevant answer to the search query. If the number of matching answers is
	// less than the `max_extractive_answer_count`, return all of the answers.
	// Otherwise, return the `max_extractive_answer_count`. At most five answers
	// are returned for each SearchResult.
	MaxExtractiveAnswerCount int64 `json:"maxExtractiveAnswerCount,omitempty"`
	// MaxExtractiveSegmentCount: The max number of extractive segments returned in
	// each search result. Only applied if the DataStore is set to
	// DataStore.ContentConfig.CONTENT_REQUIRED or DataStore.solution_types is
	// SOLUTION_TYPE_CHAT. An extractive segment is a text segment extracted from
	// the original document that is relevant to the search query, and, in general,
	// more verbose than an extractive answer. The segment could then be used as
	// input for LLMs to generate summaries and answers. If the number of matching
	// segments is less than `max_extractive_segment_count`, return all of the
	// segments. Otherwise, return the `max_extractive_segment_count`.
	MaxExtractiveSegmentCount int64 `json:"maxExtractiveSegmentCount,omitempty"`
	// NumNextSegments: Return at most `num_next_segments` segments after each
	// selected segments.
	NumNextSegments int64 `json:"numNextSegments,omitempty"`
	// NumPreviousSegments: Specifies whether to also include the adjacent from
	// each selected segments. Return at most `num_previous_segments` segments
	// before each selected segments.
	NumPreviousSegments int64 `json:"numPreviousSegments,omitempty"`
	// ReturnExtractiveSegmentScore: Specifies whether to return the confidence
	// score from the extractive segments in each search result. This feature is
	// available only for new or allowlisted data stores. To allowlist your data
	// store, contact your Customer Engineer. The default value is `false`.
	ReturnExtractiveSegmentScore bool `json:"returnExtractiveSegmentScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxExtractiveAnswerCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxExtractiveAnswerCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec:
// A specification for configuring snippets in a search response.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec struct {
	// MaxSnippetCount: [DEPRECATED] This field is deprecated. To control snippet
	// return, use `return_snippet` field. For backwards compatibility, we will
	// return snippet if max_snippet_count > 0.
	MaxSnippetCount int64 `json:"maxSnippetCount,omitempty"`
	// ReferenceOnly: [DEPRECATED] This field is deprecated and will have no affect
	// on the snippet.
	ReferenceOnly bool `json:"referenceOnly,omitempty"`
	// ReturnSnippet: If `true`, then return snippet. If no snippet can be
	// generated, we return "No snippet is available for this page." A
	// `snippet_status` with `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be
	// returned.
	ReturnSnippet bool `json:"returnSnippet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxSnippetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxSnippetCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec:
// A specification for configuring a summary returned in a search response.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec struct {
	// IgnoreAdversarialQuery: Specifies whether to filter out adversarial queries.
	// The default value is `false`. Google employs search-query classification to
	// detect adversarial queries. No summary is returned if the search query is
	// classified as an adversarial query. For example, a user might ask a question
	// regarding negative comments about the company or submit a query designed to
	// generate unsafe, policy-violating output. If this field is set to `true`, we
	// skip generating summaries for adversarial queries and return fallback
	// messages instead.
	IgnoreAdversarialQuery bool `json:"ignoreAdversarialQuery,omitempty"`
	// IgnoreJailBreakingQuery: Optional. Specifies whether to filter out
	// jail-breaking queries. The default value is `false`. Google employs
	// search-query classification to detect jail-breaking queries. No summary is
	// returned if the search query is classified as a jail-breaking query. A user
	// might add instructions to the query to change the tone, style, language,
	// content of the answer, or ask the model to act as a different entity, e.g.
	// "Reply in the tone of a competing company's CEO". If this field is set to
	// `true`, we skip generating summaries for jail-breaking queries and return
	// fallback messages instead.
	IgnoreJailBreakingQuery bool `json:"ignoreJailBreakingQuery,omitempty"`
	// IgnoreLowRelevantContent: Specifies whether to filter out queries that have
	// low relevance. The default value is `false`. If this field is set to
	// `false`, all search results are used regardless of relevance to generate
	// answers. If set to `true`, only queries with high relevance search results
	// will generate answers.
	IgnoreLowRelevantContent bool `json:"ignoreLowRelevantContent,omitempty"`
	// IgnoreNonSummarySeekingQuery: Specifies whether to filter out queries that
	// are not summary-seeking. The default value is `false`. Google employs
	// search-query classification to detect summary-seeking queries. No summary is
	// returned if the search query is classified as a non-summary seeking query.
	// For example, `why is the sky blue` and `Who is the best soccer player in the
	// world?` are summary-seeking queries, but `SFO airport` and `world cup 2026`
	// are not. They are most likely navigational queries. If this field is set to
	// `true`, we skip generating summaries for non-summary seeking queries and
	// return fallback messages instead.
	IgnoreNonSummarySeekingQuery bool `json:"ignoreNonSummarySeekingQuery,omitempty"`
	// IncludeCitations: Specifies whether to include citations in the summary. The
	// default value is `false`. When this field is set to `true`, summaries
	// include in-line citation numbers. Example summary including citations:
	// BigQuery is Google Cloud's fully managed and completely serverless
	// enterprise data warehouse [1]. BigQuery supports all data types, works
	// across clouds, and has built-in machine learning and business intelligence,
	// all within a unified platform [2, 3]. The citation numbers refer to the
	// returned search results and are 1-indexed. For example, [1] means that the
	// sentence is attributed to the first search result. [2, 3] means that the
	// sentence is attributed to both the second and third search results.
	IncludeCitations bool `json:"includeCitations,omitempty"`
	// LanguageCode: Language code for Summary. Use language tags defined by BCP47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an
	// experimental feature.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelPromptSpec: If specified, the spec will be used to modify the prompt
	// provided to the LLM.
	ModelPromptSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec `json:"modelPromptSpec,omitempty"`
	// ModelSpec: If specified, the spec will be used to modify the model
	// specification provided to the LLM.
	ModelSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec `json:"modelSpec,omitempty"`
	// SummaryResultCount: The number of top results to generate the summary from.
	// If the number of results returned is less than `summaryResultCount`, the
	// summary is generated from all of the results. At most 10 results for
	// documents mode, or 50 for chunks mode, can be used to generate a summary.
	// The chunks mode is used when
	// SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
	SummaryResultCount int64 `json:"summaryResultCount,omitempty"`
	// UseSemanticChunks: If true, answer will be generated from most relevant
	// chunks from top search results. This feature will improve summary quality.
	// Note that with this feature enabled, not all top search results will be
	// referenced and included in the reference list, so the citation source index
	// only points to the search results listed in the reference list.
	UseSemanticChunks bool `json:"useSemanticChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecMod
// elPromptSpec: Specification of the prompt to use with the model.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec struct {
	// Preamble: Text at the beginning of the prompt that instructs the assistant.
	// Examples are available in the user guide.
	Preamble string `json:"preamble,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Preamble") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Preamble") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecMod
// elSpec: Specification of the model.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec struct {
	// Version: The model version used to generate the summary. Supported values
	// are: * `stable`: string. Default value when no value is specified. Uses a
	// generally available, fine-tuned model. For more information, see Answer
	// generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	// * `preview`: string. (Public preview) Uses a preview model. For more
	// information, see Answer generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestDataStoreSpec: A struct to
// define data stores to filter on in a search call and configurations for
// those data stores. Otherwise, an `INVALID_ARGUMENT` error is returned.
type GoogleCloudDiscoveryengineV1alphaSearchRequestDataStoreSpec struct {
	// BoostSpec: Optional. Boost specification to boost certain documents. For
	// more information on boosting, see Boosting
	// (https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
	BoostSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// DataStore: Required. Full resource name of DataStore, such as
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`.
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Optional. Filter specification to filter documents in the data store
	// specified by data_store field. For more information on filtering, see
	// Filtering
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestDataStoreSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestDataStoreSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec: The
// specification that uses customized query embedding vector to do semantic
// document retrieval.
type GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec struct {
	// EmbeddingVectors: The embedding vector used for retrieval. Limit to 1.
	EmbeddingVectors []*GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector `json:"embeddingVectors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmbeddingVectors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmbeddingVectors") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector:
// Embedding vector.
type GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector struct {
	// FieldPath: Embedding field path in schema.
	FieldPath string `json:"fieldPath,omitempty"`
	// Vector: Query embedding vector.
	Vector []float64 `json:"vector,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector
	var s1 struct {
		Vector []gensupport.JSONFloat64 `json:"vector"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Vector = make([]float64, len(s1.Vector))
	for i := range s1.Vector {
		s.Vector[i] = float64(s1.Vector[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec: A facet
// specification to perform faceted search.
type GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec struct {
	// EnableDynamicPosition: Enables dynamic position for this facet. If set to
	// true, the position of this facet among all facets in the response is
	// determined automatically. If dynamic facets are enabled, it is ordered
	// together. If set to false, the position of this facet in the response is the
	// same as in the request, and it is ranked before the facets with dynamic
	// position enable and all dynamic facets. For example, you may always want to
	// have rating facet returned in the response, but it's not necessarily to
	// always display the rating facet at the top. In that case, you can set
	// enable_dynamic_position to true so that the position of rating facet in
	// response is determined automatically. Another example, assuming you have the
	// following facets in the request: * "rating", enable_dynamic_position = true
	// * "price", enable_dynamic_position = false * "brands",
	// enable_dynamic_position = false And also you have a dynamic facets enabled,
	// which generates a facet `gender`. Then the final order of the facets in the
	// response can be ("price", "brands", "rating", "gender") or ("price",
	// "brands", "gender", "rating") depends on how API orders "gender" and
	// "rating" facets. However, notice that "price" and "brands" are always ranked
	// at first and second position because their enable_dynamic_position is false.
	EnableDynamicPosition bool `json:"enableDynamicPosition,omitempty"`
	// ExcludedFilterKeys: List of keys to exclude when faceting. By default,
	// FacetKey.key is not excluded from the filter unless it is listed in this
	// field. Listing a facet key in this field allows its values to appear as
	// facet results, even when they are filtered out of search results. Using this
	// field does not affect what search results are returned. For example, suppose
	// there are 100 documents with the color facet "Red" and 200 documents with
	// the color facet "Blue". A query containing the filter "color:ANY("Red")" and
	// having "color" as FacetKey.key would by default return only "Red" documents
	// in the search results, and also return "Red" with count 100 as the only
	// color facet. Although there are also blue documents available, "Blue" would
	// not be shown as an available facet value. If "color" is listed in
	// "excludedFilterKeys", then the query returns the facet values "Red" with
	// count 100 and "Blue" with count 200, because the "color" key is now excluded
	// from the filter. Because this field doesn't affect search results, the
	// search results are still correctly filtered to return only "Red" documents.
	// A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error
	// is returned.
	ExcludedFilterKeys []string `json:"excludedFilterKeys,omitempty"`
	// FacetKey: Required. The facet key specification.
	FacetKey *GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey `json:"facetKey,omitempty"`
	// Limit: Maximum facet values that are returned for this facet. If
	// unspecified, defaults to 20. The maximum allowed value is 300. Values above
	// 300 are coerced to 300. For aggregation in healthcare search, when the
	// [FacetKey.key] is "healthcare_aggregation_key", the limit will be overridden
	// to 10,000 internally, regardless of the value set here. If this field is
	// negative, an `INVALID_ARGUMENT` is returned.
	Limit int64 `json:"limit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableDynamicPosition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableDynamicPosition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey: Specifies
// how a facet is computed.
type GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey struct {
	// CaseInsensitive: True to make facet keys case insensitive when getting
	// faceting values with prefixes or contains; false otherwise.
	CaseInsensitive bool `json:"caseInsensitive,omitempty"`
	// Contains: Only get facet values that contain the given strings. For example,
	// suppose "category" has three values "Action > 2022", "Action > 2021" and
	// "Sci-Fi > 2022". If set "contains" to "2022", the "category" facet only
	// contains "Action > 2022" and "Sci-Fi > 2022". Only supported on textual
	// fields. Maximum is 10.
	Contains []string `json:"contains,omitempty"`
	// Intervals: Set only if values should be bucketed into intervals. Must be set
	// for facets with numerical values. Must not be set for facet with text
	// values. Maximum number of intervals is 30.
	Intervals []*GoogleCloudDiscoveryengineV1alphaInterval `json:"intervals,omitempty"`
	// Key: Required. Supported textual and numerical facet keys in Document
	// object, over which the facet values are computed. Facet key is
	// case-sensitive.
	Key string `json:"key,omitempty"`
	// OrderBy: The order in which documents are returned. Allowed values are: *
	// "count desc", which means order by SearchResponse.Facet.values.count
	// descending. * "value desc", which means order by
	// SearchResponse.Facet.values.value descending. Only applies to textual
	// facets. If not set, textual values are sorted in natural order
	// (https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are
	// sorted in the order given by FacetSpec.FacetKey.intervals.
	OrderBy string `json:"orderBy,omitempty"`
	// Prefixes: Only get facet values that start with the given string prefix. For
	// example, suppose "category" has three values "Action > 2022", "Action >
	// 2021" and "Sci-Fi > 2022". If set "prefixes" to "Action", the "category"
	// facet only contains "Action > 2022" and "Action > 2021". Only supported on
	// textual fields. Maximum is 10.
	Prefixes []string `json:"prefixes,omitempty"`
	// RestrictedValues: Only get facet for the given restricted values. Only
	// supported on textual fields. For example, suppose "category" has three
	// values "Action > 2022", "Action > 2021" and "Sci-Fi > 2022". If set
	// "restricted_values" to "Action > 2022", the "category" facet only contains
	// "Action > 2022". Only supported on textual fields. Maximum is 10.
	RestrictedValues []string `json:"restrictedValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseInsensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseInsensitive") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery: Specifies the
// image query input.
type GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery struct {
	// ImageBytes: Base64 encoded image bytes. Supported image formats: JPEG, PNG,
	// and BMP.
	ImageBytes string `json:"imageBytes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestNaturalLanguageQueryUnderstandi
// ngSpec: Specification to enable natural language understanding capabilities
// for search requests.
type GoogleCloudDiscoveryengineV1alphaSearchRequestNaturalLanguageQueryUnderstandingSpec struct {
	// FilterExtractionCondition: The condition under which filter extraction
	// should occur. Default to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disables NL filter extraction.
	//   "ENABLED" - Enables NL filter extraction.
	FilterExtractionCondition string `json:"filterExtractionCondition,omitempty"`
	// GeoSearchQueryDetectionFieldNames: Field names used for location-based
	// filtering, where geolocation filters are detected in natural language search
	// queries. Only valid when the FilterExtractionCondition is set to `ENABLED`.
	// If this field is set, it overrides the field names set in
	// ServingConfig.geo_search_query_detection_field_names.
	GeoSearchQueryDetectionFieldNames []string `json:"geoSearchQueryDetectionFieldNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilterExtractionCondition")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilterExtractionCondition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestNaturalLanguageQueryUnderstandingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestNaturalLanguageQueryUnderstandingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestPersonalizationSpec: The
// specification for personalization.
type GoogleCloudDiscoveryengineV1alphaSearchRequestPersonalizationSpec struct {
	// Mode: The personalization mode of the search request. Defaults to Mode.AUTO.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value. In this case, server behavior defaults
	// to Mode.AUTO.
	//   "AUTO" - Personalization is enabled if data quality requirements are met.
	//   "DISABLED" - Disable personalization.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestPersonalizationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestPersonalizationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec:
// Specification to determine under which conditions query expansion should
// occur.
type GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec struct {
	// Condition: The condition under which query expansion should occur. Default
	// to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Unspecified query expansion condition. In this
	// case, server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disabled query expansion. Only the exact search query is
	// used, even if SearchResponse.total_size is zero.
	//   "AUTO" - Automatic query expansion built by the Search API.
	Condition string `json:"condition,omitempty"`
	// PinUnexpandedResults: Whether to pin unexpanded results. If this field is
	// set to true, unexpanded products are always at the top of the search
	// results, followed by the expanded results.
	PinUnexpandedResults bool `json:"pinUnexpandedResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestSearchAsYouTypeSpec:
// Specification for search as you type in search requests.
type GoogleCloudDiscoveryengineV1alphaSearchRequestSearchAsYouTypeSpec struct {
	// Condition: The condition under which search as you type should occur.
	// Default to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disables Search As You Type.
	//   "ENABLED" - Enables Search As You Type.
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestSearchAsYouTypeSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestSearchAsYouTypeSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestSessionSpec: Session
// specification. Multi-turn Search feature is currently at private GA stage.
// Please use v1alpha or v1beta version instead before we launch this feature
// to public GA. Or ask for allowlisting through Google Support team.
type GoogleCloudDiscoveryengineV1alphaSearchRequestSessionSpec struct {
	// QueryId: If set, the search result gets stored to the "turn" specified by
	// this query ID. Example: Let's say the session looks like this: session {
	// name: ".../sessions/xxx" turns { query { text: "What is foo?" query_id:
	// ".../questions/yyy" } answer: "Foo is ..." } turns { query { text: "How
	// about bar then?" query_id: ".../questions/zzz" } } } The user can call
	// /search API with a request like this: session: ".../sessions/xxx"
	// session_spec { query_id: ".../questions/zzz" } Then, the API stores the
	// search result, associated with the last turn. The stored search result can
	// be used by a subsequent /answer API call (with the session ID and the query
	// ID specified). Also, it is possible to call /search and /answer in parallel
	// with the same session ID & query ID.
	QueryId string `json:"queryId,omitempty"`
	// SearchResultPersistenceCount: The number of top search results to persist.
	// The persisted search results can be used for the subsequent /answer api
	// call. This field is simliar to the `summary_result_count` field in
	// SearchRequest.ContentSearchSpec.SummarySpec.summary_result_count. At most 10
	// results for documents mode, or 50 for chunks mode.
	SearchResultPersistenceCount int64 `json:"searchResultPersistenceCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestSessionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestSessionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec: The
// specification for query spell correction.
type GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec struct {
	// Mode: The mode under which spell correction replaces the original search
	// query. Defaults to Mode.AUTO.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified spell correction mode. In this case,
	// server behavior defaults to Mode.AUTO.
	//   "SUGGESTION_ONLY" - Search API tries to find a spelling suggestion. If a
	// suggestion is found, it is put in the SearchResponse.corrected_query. The
	// spelling suggestion won't be used as the search query.
	//   "AUTO" - Automatic spell correction built by the Search API. Search will
	// be based on the corrected query if found.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSession: External session proto definition.
type GoogleCloudDiscoveryengineV1alphaSession struct {
	// DisplayName: Optional. The display name of the session. This field is used
	// to identify the session in the UI. By default, the display name is the first
	// turn query text in the session.
	DisplayName string `json:"displayName,omitempty"`
	// EndTime: Output only. The time the session finished.
	EndTime string `json:"endTime,omitempty"`
	// IsPinned: Optional. Whether the session is pinned, pinned session will be
	// displayed on the top of the session list.
	IsPinned bool `json:"isPinned,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*`
	Name string `json:"name,omitempty"`
	// StartTime: Output only. The time the session started.
	StartTime string `json:"startTime,omitempty"`
	// State: The state of the session.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is unspecified.
	//   "IN_PROGRESS" - The session is currently open.
	State string `json:"state,omitempty"`
	// Turns: Turns.
	Turns []*GoogleCloudDiscoveryengineV1alphaSessionTurn `json:"turns,omitempty"`
	// UserPseudoId: A unique identifier for tracking users.
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSession) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSession
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSessionTurn: Represents a turn, including a
// query from the user and a answer from service.
type GoogleCloudDiscoveryengineV1alphaSessionTurn struct {
	// Answer: The resource name of the answer to the user query. Only set if the
	// answer generation (/answer API call) happened in this turn.
	Answer string `json:"answer,omitempty"`
	// DetailedAnswer: Output only. In ConversationalSearchService.GetSession API,
	// if GetSessionRequest.include_answer_details is set to true, this field will
	// be populated when getting answer query session.
	DetailedAnswer *GoogleCloudDiscoveryengineV1alphaAnswer `json:"detailedAnswer,omitempty"`
	// Query: The user query.
	Query *GoogleCloudDiscoveryengineV1alphaQuery `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSessionTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSessionTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSetUriPatternDocumentDataMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.SetUriPatternDocumentData operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaSetUriPatternDocumentDataMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSetUriPatternDocumentDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSetUriPatternDocumentDataMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSetUriPatternDocumentDataResponse: Response
// message for SiteSearchEngineService.SetUriPatternDocumentData method.
type GoogleCloudDiscoveryengineV1alphaSetUriPatternDocumentDataResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo: Verification
// information for target sites in advanced site search.
type GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo struct {
	// SiteVerificationState: Site verification state indicating the ownership and
	// validity.
	//
	// Possible values:
	//   "SITE_VERIFICATION_STATE_UNSPECIFIED" - Defaults to VERIFIED.
	//   "VERIFIED" - Site ownership verified.
	//   "UNVERIFIED" - Site ownership pending verification or verification failed.
	//   "EXEMPTED" - Site exempt from verification, e.g., a public website that
	// opens to all.
	SiteVerificationState string `json:"siteVerificationState,omitempty"`
	// VerifyTime: Latest site verification time.
	VerifyTime string `json:"verifyTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SiteVerificationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SiteVerificationState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSitemap: A sitemap for the
// SiteSearchEngine.
type GoogleCloudDiscoveryengineV1alphaSitemap struct {
	// CreateTime: Output only. The sitemap's creation time.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. The fully qualified resource name of the sitemap.
	// `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/sitemaps/
	// *` The `sitemap_id` suffix is system-generated.
	Name string `json:"name,omitempty"`
	// Uri: Public URI for the sitemap, e.g. `www.example.com/sitemap.xml`.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaSitemap) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSitemap
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTargetSite: A target site for the
// SiteSearchEngine.
type GoogleCloudDiscoveryengineV1alphaTargetSite struct {
	// ExactMatch: Input only. If set to false, a uri_pattern is generated to
	// include all pages whose address contains the provided_uri_pattern. If set to
	// true, an uri_pattern is generated to try to be an exact match of the
	// provided_uri_pattern or just the specific page if the provided_uri_pattern
	// is a specific one. provided_uri_pattern is always normalized to generate the
	// URI pattern to be used by the search engine.
	ExactMatch bool `json:"exactMatch,omitempty"`
	// FailureReason: Output only. Failure reason.
	FailureReason *GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason `json:"failureReason,omitempty"`
	// GeneratedUriPattern: Output only. This is system-generated based on the
	// provided_uri_pattern.
	GeneratedUriPattern string `json:"generatedUriPattern,omitempty"`
	// IndexingStatus: Output only. Indexing status.
	//
	// Possible values:
	//   "INDEXING_STATUS_UNSPECIFIED" - Defaults to SUCCEEDED.
	//   "PENDING" - The target site is in the update queue and will be picked up
	// by indexing pipeline.
	//   "FAILED" - The target site fails to be indexed.
	//   "SUCCEEDED" - The target site has been indexed.
	//   "DELETING" - The previously indexed target site has been marked to be
	// deleted. This is a transitioning state which will resulted in either: 1.
	// target site deleted if unindexing is successful; 2. state reverts to
	// SUCCEEDED if the unindexing fails.
	IndexingStatus string `json:"indexingStatus,omitempty"`
	// Name: Output only. The fully qualified resource name of the target site.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/siteSearchEngine/targetSites/{target_site}` The
	// `target_site_id` is system-generated.
	Name string `json:"name,omitempty"`
	// ProvidedUriPattern: Required. Input only. The user provided URI pattern from
	// which the `generated_uri_pattern` is generated.
	ProvidedUriPattern string `json:"providedUriPattern,omitempty"`
	// RootDomainUri: Output only. Root domain of the provided_uri_pattern.
	RootDomainUri string `json:"rootDomainUri,omitempty"`
	// SiteVerificationInfo: Output only. Site ownership and validity verification
	// status.
	SiteVerificationInfo *GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo `json:"siteVerificationInfo,omitempty"`
	// Type: The type of the target site, e.g., whether the site is to be included
	// or excluded.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - This value is unused. In this case, server behavior
	// defaults to Type.INCLUDE.
	//   "INCLUDE" - Include the target site.
	//   "EXCLUDE" - Exclude the target site.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The target site's last updated time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTargetSite) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTargetSite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason: Site search
// indexing failure reasons.
type GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason struct {
	// QuotaFailure: Failed due to insufficient quota.
	QuotaFailure *GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure `json:"quotaFailure,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuotaFailure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuotaFailure") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure: Failed
// due to insufficient quota.
type GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure struct {
	// TotalRequiredQuota: This number is an estimation on how much total quota
	// this project needs to successfully complete indexing.
	TotalRequiredQuota int64 `json:"totalRequiredQuota,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TotalRequiredQuota") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalRequiredQuota") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata: Metadata related
// to the progress of the TrainCustomModel operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse: Response of the
// TrainCustomModelRequest. This message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the data.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// Metrics: The metrics of the trained model.
	Metrics map[string]float64 `json:"metrics,omitempty"`
	// ModelName: Fully qualified name of the CustomTuningModel.
	ModelName string `json:"modelName,omitempty"`
	// ModelStatus: The trained model status. Possible values are: * **bad-data**:
	// The training data quality is bad. * **no-improvement**: Tuning didn't
	// improve performance. Won't deploy. * **in-progress**: Model training job
	// creation is in progress. * **training**: Model is actively training. *
	// **evaluating**: The model is evaluating trained metrics. * **indexing**: The
	// model trained metrics are indexing. * **ready**: The model is ready for
	// serving.
	ModelStatus string `json:"modelStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata: Metadata associated
// with a tune operation.
type GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata struct {
	// Engine: Required. The resource name of the engine that this tune applies to.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/engines/
	// {engine_id}`
	Engine string `json:"engine,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Engine") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engine") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTuneEngineResponse: Response associated
// with a tune operation.
type GoogleCloudDiscoveryengineV1alphaTuneEngineResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaUpdateCmekConfigMetadata: Metadata related
// to the progress of the CmekConfigService.UpdateCmekConfig operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaUpdateCmekConfigMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaUpdateCmekConfigMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUpdateCmekConfigMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata: Metadata for
// UpdateSchema LRO.
type GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaUpdateSessionRequest: Request for
// UpdateSession method.
type GoogleCloudDiscoveryengineV1alphaUpdateSessionRequest struct {
	// Session: Required. The Session to update.
	Session *GoogleCloudDiscoveryengineV1alphaSession `json:"session,omitempty"`
	// UpdateMask: Indicates which fields in the provided Session to update. The
	// following are NOT supported: * Session.name If not set or empty, all
	// supported fields are updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Session") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Session") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaUpdateSessionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUpdateSessionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.UpdateTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaUserInfo: Information of an end user.
type GoogleCloudDiscoveryengineV1alphaUserInfo struct {
	// UserAgent: User agent as included in the HTTP header. The field must be a
	// UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned. This should not be set when using the
	// client side event reporting with GTM or JavaScript tag in
	// UserEventService.CollectUserEvent or if UserEvent.direct_user_request is
	// set.
	UserAgent string `json:"userAgent,omitempty"`
	// UserId: Highly recommended for logged-in users. Unique identifier for
	// logged-in user, such as a user name. Don't set for anonymous users. Always
	// use a hashed value for this ID. Don't set the field to the same fixed ID for
	// different users. This mixes the event history of those users together, which
	// results in degraded model quality. The field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserAgent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaUserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWorkspaceConfig: Config to store data store
// type configuration for workspace data
type GoogleCloudDiscoveryengineV1alphaWorkspaceConfig struct {
	// DasherCustomerId: Obfuscated Dasher customer ID.
	DasherCustomerId string `json:"dasherCustomerId,omitempty"`
	// SuperAdminEmailAddress: Optional. The super admin email address for the
	// workspace that will be used for access token generation. For now we only use
	// it for Native Google Drive connector data ingestion.
	SuperAdminEmailAddress string `json:"superAdminEmailAddress,omitempty"`
	// SuperAdminServiceAccount: Optional. The super admin service account for the
	// workspace that will be used for access token generation. For now we only use
	// it for Native Google Drive connector data ingestion.
	SuperAdminServiceAccount string `json:"superAdminServiceAccount,omitempty"`
	// Type: The Google Workspace data source.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Defaults to an unspecified Workspace type.
	//   "GOOGLE_DRIVE" - Workspace Data Store contains Drive data
	//   "GOOGLE_MAIL" - Workspace Data Store contains Mail data
	//   "GOOGLE_SITES" - Workspace Data Store contains Sites data
	//   "GOOGLE_CALENDAR" - Workspace Data Store contains Calendar data
	//   "GOOGLE_CHAT" - Workspace Data Store contains Chat data
	//   "GOOGLE_GROUPS" - Workspace Data Store contains Groups data
	//   "GOOGLE_KEEP" - Workspace Data Store contains Keep data
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DasherCustomerId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DasherCustomerId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1alphaWorkspaceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWorkspaceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequest: Request
// message for CompletionService.AdvancedCompleteQuery method. .
type GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequest struct {
	// BoostSpec: Optional. Specification to boost suggestions matching the
	// condition.
	BoostSpec *GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpec `json:"boostSpec,omitempty"`
	// IncludeTailSuggestions: Indicates if tail suggestions should be returned if
	// there are no suggestions that match the full query. Even if set to true, if
	// there are suggestions that match the full query, those are returned and no
	// tail suggestions are returned.
	IncludeTailSuggestions bool `json:"includeTailSuggestions,omitempty"`
	// Query: Required. The typeahead input used to fetch suggestions. Maximum
	// length is 128 characters. The query can not be empty for most of the
	// suggestion types. If it is empty, an `INVALID_ARGUMENT` error is returned.
	// The exception is when the suggestion_types contains only the type
	// `RECENT_SEARCH`, the query can be an empty string. The is called "zero
	// prefix" feature, which returns user's recently searched queries given the
	// empty query.
	Query string `json:"query,omitempty"`
	// QueryModel: Specifies the autocomplete data model. This overrides any model
	// specified in the Configuration > Autocomplete section of the Cloud console.
	// Currently supported values: * `document` - Using suggestions generated from
	// user-imported documents. * `search-history` - Using suggestions generated
	// from the past history of SearchService.Search API calls. Do not use it when
	// there is no traffic for Search API. * `user-event` - Using suggestions
	// generated from user-imported search events. * `document-completable` - Using
	// suggestions taken directly from user-imported document fields marked as
	// completable. Default values: * `document` is the default model for regular
	// dataStores. * `search-history` is the default model for site search
	// dataStores.
	QueryModel string `json:"queryModel,omitempty"`
	// SuggestionTypes: Optional. Suggestion types to return. If empty or
	// unspecified, query suggestions are returned. Only one suggestion type is
	// supported at the moment.
	//
	// Possible values:
	//   "SUGGESTION_TYPE_UNSPECIFIED" - Default value.
	//   "QUERY" - Returns query suggestions.
	//   "PEOPLE" - Returns people suggestions.
	//   "CONTENT" - Returns content suggestions.
	//   "RECENT_SEARCH" - Returns recent search suggestions.
	//   "GOOGLE_WORKSPACE" - Returns Google Workspace suggestions.
	SuggestionTypes []string `json:"suggestionTypes,omitempty"`
	// UserInfo: Optional. Information about the end user. This should be the same
	// identifier information as UserEvent.user_info and SearchRequest.user_info.
	UserInfo *GoogleCloudDiscoveryengineV1betaUserInfo `json:"userInfo,omitempty"`
	// UserPseudoId: A unique identifier for tracking visitors. For example, this
	// could be implemented with an HTTP cookie, which should be able to uniquely
	// identify a visitor on a single device. This unique identifier should not
	// change if the visitor logs in or out of the website. This field should NOT
	// have a fixed value such as `unknown_visitor`. This should be the same
	// identifier as UserEvent.user_pseudo_id and SearchRequest.user_pseudo_id. The
	// field must be a UTF-8 encoded string with a length limit of 128
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpec:
// Specification to boost suggestions based on the condtion of the suggestion.
type GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpec struct {
	// ConditionBoostSpecs: Condition boost specifications. If a suggestion matches
	// multiple conditions in the specifictions, boost values from these
	// specifications are all applied and combined in a non-linear way. Maximum
	// number of specifications is 20. Note: Currently only support language
	// condition boost.
	ConditionBoostSpecs []*GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpecConditio
// nBoostSpec: Boost applies to suggestions which match a condition.
type GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpecConditionBoostSpec struct {
	// Boost: Strength of the boost, which should be in [-1, 1]. Negative boost
	// means demotion. Default is 0.0. Setting to 1.0 gives the suggestions a big
	// promotion. However, it does not necessarily mean that the top result will be
	// a boosted suggestion. Setting to -1.0 gives the suggestions a big demotion.
	// However, other suggestions that are relevant might still be shown. Setting
	// to 0.0 means no boost applied. The boosting condition is ignored.
	Boost float64 `json:"boost,omitempty"`
	// Condition: An expression which specifies a boost condition. The syntax is
	// the same as filter expression syntax
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
	// Currently, the only supported condition is a list of BCP-47 lang codes.
	// Example: * To boost suggestions in languages `en` or `fr`: `(lang_code:
	// ANY("en", "fr"))`
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryRequestBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponse: Response
// message for CompletionService.AdvancedCompleteQuery method.
type GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponse struct {
	// ContentSuggestions: Results of the matched content suggestions. The result
	// list is ordered and the first result is the top suggestion.
	ContentSuggestions []*GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseContentSuggestion `json:"contentSuggestions,omitempty"`
	// PeopleSuggestions: Results of the matched people suggestions. The result
	// list is ordered and the first result is the top suggestion.
	PeopleSuggestions []*GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponsePersonSuggestion `json:"peopleSuggestions,omitempty"`
	// QuerySuggestions: Results of the matched query suggestions. The result list
	// is ordered and the first result is a top suggestion.
	QuerySuggestions []*GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseQuerySuggestion `json:"querySuggestions,omitempty"`
	// RecentSearchSuggestions: Results of the matched "recent search" suggestions.
	// The result list is ordered and the first result is the top suggestion.
	RecentSearchSuggestions []*GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseRecentSearchSuggestion `json:"recentSearchSuggestions,omitempty"`
	// TailMatchTriggered: True if the returned suggestions are all tail
	// suggestions. For tail matching to be triggered, include_tail_suggestions in
	// the request must be true and there must be no suggestions that match the
	// full query.
	TailMatchTriggered bool `json:"tailMatchTriggered,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseContentSuggestio
// n: Suggestions as content.
type GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseContentSuggestion struct {
	// ContentType: The type of the content suggestion.
	//
	// Possible values:
	//   "CONTENT_TYPE_UNSPECIFIED" - Default value.
	//   "GOOGLE_WORKSPACE" - The suggestion is from a Google Workspace source.
	//   "THIRD_PARTY" - The suggestion is from a third party source.
	ContentType string `json:"contentType,omitempty"`
	// DataStore: The name of the dataStore that this suggestion belongs to.
	DataStore string `json:"dataStore,omitempty"`
	// Document: The document data snippet in the suggestion. Only a subset of
	// fields will be populated.
	Document *GoogleCloudDiscoveryengineV1betaDocument `json:"document,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseContentSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseContentSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponsePersonSuggestion
// : Suggestions as people.
type GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponsePersonSuggestion struct {
	// DataStore: The name of the dataStore that this suggestion belongs to.
	DataStore string `json:"dataStore,omitempty"`
	// Document: The document data snippet in the suggestion. Only a subset of
	// fields is populated.
	Document *GoogleCloudDiscoveryengineV1betaDocument `json:"document,omitempty"`
	// PersonType: The type of the person.
	//
	// Possible values:
	//   "PERSON_TYPE_UNSPECIFIED" - Default value.
	//   "CLOUD_IDENTITY" - The suggestion is from a GOOGLE_IDENTITY source.
	//   "THIRD_PARTY_IDENTITY" - The suggestion is from a THIRD_PARTY_IDENTITY
	// source.
	PersonType string `json:"personType,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponsePersonSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponsePersonSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseQuerySuggestion:
//
//	Suggestions as search queries.
type GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseQuerySuggestion struct {
	// CompletableFieldPaths: The unique document field paths that serve as the
	// source of this suggestion if it was generated from completable fields. This
	// field is only populated for the document-completable model.
	CompletableFieldPaths []string `json:"completableFieldPaths,omitempty"`
	// DataStore: The name of the dataStore that this suggestion belongs to.
	DataStore []string `json:"dataStore,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletableFieldPaths") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletableFieldPaths") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseQuerySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseQuerySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseRecentSearchSugg
// estion: Suggestions from recent search history.
type GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseRecentSearchSuggestion struct {
	// RecentSearchTime: The time when this recent rearch happened.
	RecentSearchTime string `json:"recentSearchTime,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RecentSearchTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RecentSearchTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseRecentSearchSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAdvancedCompleteQueryResponseRecentSearchSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAdvancedSiteSearchConfig: Configuration data
// for advance site search.
type GoogleCloudDiscoveryengineV1betaAdvancedSiteSearchConfig struct {
}

// GoogleCloudDiscoveryengineV1betaAlloyDbSource: AlloyDB source import data
// from.
type GoogleCloudDiscoveryengineV1betaAlloyDbSource struct {
	// ClusterId: Required. The AlloyDB cluster to copy the data from with a length
	// limit of 256 characters.
	ClusterId string `json:"clusterId,omitempty"`
	// DatabaseId: Required. The AlloyDB database to copy the data from with a
	// length limit of 256 characters.
	DatabaseId string `json:"databaseId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the AlloyDB export to a specific Cloud Storage directory. Ensure that the
	// AlloyDB service account has the necessary Cloud Storage Admin permissions to
	// access the specified Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// LocationId: Required. The AlloyDB location to copy the data from with a
	// length limit of 256 characters.
	LocationId string `json:"locationId,omitempty"`
	// ProjectId: The project ID that contains the AlloyDB source. Has a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The AlloyDB table to copy the data from with a length
	// limit of 256 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAlloyDbSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAlloyDbSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswer: Defines an answer.
type GoogleCloudDiscoveryengineV1betaAnswer struct {
	// AnswerSkippedReasons: Additional answer-skipped reasons. This provides the
	// reason for ignored cases. If nothing is skipped, this field is not set.
	//
	// Possible values:
	//   "ANSWER_SKIPPED_REASON_UNSPECIFIED" - Default value. The answer skipped
	// reason is not specified.
	//   "ADVERSARIAL_QUERY_IGNORED" - The adversarial query ignored case.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED" - The non-answer seeking query ignored
	// case Google skips the answer if the query is chit chat.
	//   "OUT_OF_DOMAIN_QUERY_IGNORED" - The out-of-domain query ignored case.
	// Google skips the answer if there are no high-relevance search results.
	//   "POTENTIAL_POLICY_VIOLATION" - The potential policy violation case. Google
	// skips the answer if there is a potential policy violation detected. This
	// includes content that may be violent or toxic.
	//   "NO_RELEVANT_CONTENT" - The no relevant content case. Google skips the
	// answer if there is no relevant content in the retrieved search results.
	//   "JAIL_BREAKING_QUERY_IGNORED" - The jail-breaking query ignored case. For
	// example, "Reply in the tone of a competing company's CEO". Google skips the
	// answer if the query is classified as a jail-breaking query.
	//   "CUSTOMER_POLICY_VIOLATION" - The customer policy violation case. Google
	// skips the summary if there is a customer policy violation detected. The
	// policy is defined by the customer.
	//   "NON_ANSWER_SEEKING_QUERY_IGNORED_V2" - The non-answer seeking query
	// ignored case. Google skips the answer if the query doesn't have clear
	// intent.
	//   "LOW_GROUNDED_ANSWER" - The low-grounded answer case. Google skips the
	// answer if a well grounded answer was unable to be generated.
	AnswerSkippedReasons []string `json:"answerSkippedReasons,omitempty"`
	// AnswerText: The textual answer.
	AnswerText string `json:"answerText,omitempty"`
	// Citations: Citations.
	Citations []*GoogleCloudDiscoveryengineV1betaAnswerCitation `json:"citations,omitempty"`
	// CompleteTime: Output only. Answer completed timestamp.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. Answer creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// GroundingScore: A score in the range of [0, 1] describing how grounded the
	// answer is by the reference chunks.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// GroundingSupports: Optional. Grounding supports.
	GroundingSupports []*GoogleCloudDiscoveryengineV1betaAnswerGroundingSupport `json:"groundingSupports,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine
	// }/sessions/*/answers/*`
	Name string `json:"name,omitempty"`
	// QueryUnderstandingInfo: Query understanding information.
	QueryUnderstandingInfo *GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfo `json:"queryUnderstandingInfo,omitempty"`
	// References: References.
	References []*GoogleCloudDiscoveryengineV1betaAnswerReference `json:"references,omitempty"`
	// RelatedQuestions: Suggested related questions.
	RelatedQuestions []string `json:"relatedQuestions,omitempty"`
	// State: The state of the answer generation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Answer generation is currently in progress.
	//   "FAILED" - Answer generation currently failed.
	//   "SUCCEEDED" - Answer generation has succeeded.
	//   "STREAMING" - Answer generation is currently in progress.
	State string `json:"state,omitempty"`
	// Steps: Answer generation steps.
	Steps []*GoogleCloudDiscoveryengineV1betaAnswerStep `json:"steps,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnswerSkippedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSkippedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswer
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1betaAnswerCitation: Citation info for a segment.
type GoogleCloudDiscoveryengineV1betaAnswerCitation struct {
	// EndIndex: End of the attributed segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// Sources: Citation sources for the attributed segment.
	Sources []*GoogleCloudDiscoveryengineV1betaAnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Index indicates the start of the segment, measured in bytes
	// (UTF-8 unicode).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerCitation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerCitationSource: Citation source.
type GoogleCloudDiscoveryengineV1betaAnswerCitationSource struct {
	// ReferenceId: ID of the citation source.
	ReferenceId string `json:"referenceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferenceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerCitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerCitationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerGroundingSupport: Grounding support
// for a claim in `answer_text`.
type GoogleCloudDiscoveryengineV1betaAnswerGroundingSupport struct {
	// EndIndex: Required. End of the claim, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// GroundingCheckRequired: Indicates that this claim required grounding check.
	// When the system decided this claim didn't require attribution/grounding
	// check, this field is set to false. In that case, no grounding check was done
	// for the claim and therefore `grounding_score`, `sources` is not returned.
	GroundingCheckRequired bool `json:"groundingCheckRequired,omitempty"`
	// GroundingScore: A score in the range of [0, 1] describing how grounded is a
	// specific claim by the references. Higher value means that the claim is
	// better supported by the reference chunks.
	GroundingScore float64 `json:"groundingScore,omitempty"`
	// Sources: Optional. Citation sources for the claim.
	Sources []*GoogleCloudDiscoveryengineV1betaAnswerCitationSource `json:"sources,omitempty"`
	// StartIndex: Required. Index indicates the start of the claim, measured in
	// bytes (UTF-8 unicode).
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerGroundingSupport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerGroundingSupport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaAnswerGroundingSupport) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerGroundingSupport
	var s1 struct {
		GroundingScore gensupport.JSONFloat64 `json:"groundingScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GroundingScore = float64(s1.GroundingScore)
	return nil
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequest: Request message for
// ConversationalSearchService.AnswerQuery method.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequest struct {
	// AnswerGenerationSpec: Answer generation specification.
	AnswerGenerationSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpec `json:"answerGenerationSpec,omitempty"`
	// AsynchronousMode: Deprecated: This field is deprecated. Streaming Answer API
	// will be supported. Asynchronous mode control. If enabled, the response will
	// be returned with answer/session resource name without final answer. The API
	// users need to do the polling to get the latest status of answer/session by
	// calling ConversationalSearchService.GetAnswer or
	// ConversationalSearchService.GetSession method.
	AsynchronousMode bool `json:"asynchronousMode,omitempty"`
	// GroundingSpec: Optional. Grounding specification.
	GroundingSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestGroundingSpec `json:"groundingSpec,omitempty"`
	// Query: Required. Current user query.
	Query *GoogleCloudDiscoveryengineV1betaQuery `json:"query,omitempty"`
	// QueryUnderstandingSpec: Query understanding specification.
	QueryUnderstandingSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpec `json:"queryUnderstandingSpec,omitempty"`
	// RelatedQuestionsSpec: Related questions specification.
	RelatedQuestionsSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestRelatedQuestionsSpec `json:"relatedQuestionsSpec,omitempty"`
	// SafetySpec: Model specification.
	SafetySpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSafetySpec `json:"safetySpec,omitempty"`
	// SearchSpec: Search specification.
	SearchSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpec `json:"searchSpec,omitempty"`
	// Session: The session resource name. Not required. When session field is not
	// set, the API is in sessionless mode. We support auto session mode: users can
	// use the wildcard symbol `-` as session ID. A new ID will be automatically
	// generated and assigned.
	Session string `json:"session,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// UserPseudoId: A unique identifier for tracking visitors. For example, this
	// could be implemented with an HTTP cookie, which should be able to uniquely
	// identify a visitor on a single device. This unique identifier should not
	// change if the visitor logs in or out of the website. This field should NOT
	// have a fixed value such as `unknown_visitor`. The field must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerGenerationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerGenerationSpec") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpec:
// Answer generation specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpec struct {
	// AnswerLanguageCode: Language code for Answer. Use language tags defined by
	// BCP47 (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an
	// experimental feature.
	AnswerLanguageCode string `json:"answerLanguageCode,omitempty"`
	// IgnoreAdversarialQuery: Specifies whether to filter out adversarial queries.
	// The default value is `false`. Google employs search-query classification to
	// detect adversarial queries. No answer is returned if the search query is
	// classified as an adversarial query. For example, a user might ask a question
	// regarding negative comments about the company or submit a query designed to
	// generate unsafe, policy-violating output. If this field is set to `true`, we
	// skip generating answers for adversarial queries and return fallback messages
	// instead.
	IgnoreAdversarialQuery bool `json:"ignoreAdversarialQuery,omitempty"`
	// IgnoreJailBreakingQuery: Optional. Specifies whether to filter out
	// jail-breaking queries. The default value is `false`. Google employs
	// search-query classification to detect jail-breaking queries. No summary is
	// returned if the search query is classified as a jail-breaking query. A user
	// might add instructions to the query to change the tone, style, language,
	// content of the answer, or ask the model to act as a different entity, e.g.
	// "Reply in the tone of a competing company's CEO". If this field is set to
	// `true`, we skip generating summaries for jail-breaking queries and return
	// fallback messages instead.
	IgnoreJailBreakingQuery bool `json:"ignoreJailBreakingQuery,omitempty"`
	// IgnoreLowRelevantContent: Specifies whether to filter out queries that have
	// low relevance. If this field is set to `false`, all search results are used
	// regardless of relevance to generate answers. If set to `true` or unset, the
	// behavior will be determined automatically by the service.
	IgnoreLowRelevantContent bool `json:"ignoreLowRelevantContent,omitempty"`
	// IgnoreNonAnswerSeekingQuery: Specifies whether to filter out queries that
	// are not answer-seeking. The default value is `false`. Google employs
	// search-query classification to detect answer-seeking queries. No answer is
	// returned if the search query is classified as a non-answer seeking query. If
	// this field is set to `true`, we skip generating answers for non-answer
	// seeking queries and return fallback messages instead.
	IgnoreNonAnswerSeekingQuery bool `json:"ignoreNonAnswerSeekingQuery,omitempty"`
	// IncludeCitations: Specifies whether to include citation metadata in the
	// answer. The default value is `false`.
	IncludeCitations bool `json:"includeCitations,omitempty"`
	// ModelSpec: Answer generation model specification.
	ModelSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecModelSpec `json:"modelSpec,omitempty"`
	// PromptSpec: Answer generation prompt specification.
	PromptSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecPromptSpec `json:"promptSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerLanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerLanguageCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecModelSp
// ec: Answer Generation Model specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecModelSpec struct {
	// ModelVersion: Model version. If not set, it will use the default stable
	// model. Allowed values are: stable, preview.
	ModelVersion string `json:"modelVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecPromptS
// pec: Answer generation prompt specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecPromptSpec struct {
	// Preamble: Customized preamble.
	Preamble string `json:"preamble,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Preamble") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Preamble") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecPromptSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestAnswerGenerationSpecPromptSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestGroundingSpec: Grounding
// specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestGroundingSpec struct {
	// FilteringLevel: Optional. Specifies whether to enable the filtering based on
	// grounding score and at what level.
	//
	// Possible values:
	//   "FILTERING_LEVEL_UNSPECIFIED" - Default is no filter
	//   "FILTERING_LEVEL_LOW" - Filter answers based on a low threshold.
	//   "FILTERING_LEVEL_HIGH" - Filter answers based on a high threshold.
	FilteringLevel string `json:"filteringLevel,omitempty"`
	// IncludeGroundingSupports: Optional. Specifies whether to include
	// grounding_supports in the answer. The default value is `false`. When this
	// field is set to `true`, returned answer will have `grounding_score` and will
	// contain GroundingSupports for each claim.
	IncludeGroundingSupports bool `json:"includeGroundingSupports,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilteringLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilteringLevel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestGroundingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestGroundingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpec:
// Query understanding specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpec struct {
	// QueryClassificationSpec: Query classification specification.
	QueryClassificationSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec `json:"queryClassificationSpec,omitempty"`
	// QueryRephraserSpec: Query rephraser specification.
	QueryRephraserSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec `json:"queryRephraserSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryClassificationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryClassificationSpec") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQuery
// ClassificationSpec: Query classification specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec struct {
	// Types: Enabled query classification types.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified query classification type.
	//   "ADVERSARIAL_QUERY" - Adversarial query classification type.
	//   "NON_ANSWER_SEEKING_QUERY" - Non-answer-seeking query classification type,
	// for chit chat.
	//   "JAIL_BREAKING_QUERY" - Jail-breaking query classification type.
	//   "NON_ANSWER_SEEKING_QUERY_V2" - Non-answer-seeking query classification
	// type, for no clear intent.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Types") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Types") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQuery
// RephraserSpec: Query rephraser specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec struct {
	// Disable: Disable query rephraser.
	Disable bool `json:"disable,omitempty"`
	// MaxRephraseSteps: Max rephrase steps. The max number is 5 steps. If not set
	// or set to < 1, it will be set to 1 by default.
	MaxRephraseSteps int64 `json:"maxRephraseSteps,omitempty"`
	// ModelSpec: Optional. Query Rephraser Model specification.
	ModelSpec *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec `json:"modelSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQuery
// RephraserSpecModelSpec: Query Rephraser Model specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec struct {
	// ModelType: Optional. Enabled query rephraser model type. If not set, it will
	// use LARGE by default.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Unspecified model type.
	//   "SMALL" - Small query rephraser model. Gemini 1.0 XS model.
	//   "LARGE" - Large query rephraser model. Gemini 1.0 Pro model.
	ModelType string `json:"modelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestRelatedQuestionsSpec:
// Related questions specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestRelatedQuestionsSpec struct {
	// Enable: Enable related questions feature if true.
	Enable bool `json:"enable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestRelatedQuestionsSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestRelatedQuestionsSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSafetySpec: Safety
// specification. There are two use cases: 1. when only safety_spec.enable is
// set, the BLOCK_LOW_AND_ABOVE threshold will be applied for all categories.
// 2. when safety_spec.enable is set and some safety_settings are set, only
// specified safety_settings are applied.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSafetySpec struct {
	// Enable: Enable the safety filtering on the answer response. It is false by
	// default.
	Enable bool `json:"enable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSafetySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSafetySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpec: Search
// specification.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpec struct {
	// SearchParams: Search parameters.
	SearchParams *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchParams `json:"searchParams,omitempty"`
	// SearchResultList: Search result list.
	SearchResultList *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultList `json:"searchResultList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchParams") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchParams:
// Search parameters.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchParams struct {
	// BoostSpec: Boost specification to boost certain documents in search results
	// which may affect the answer query response. For more information on
	// boosting, see Boosting (https://cloud.google.com/retail/docs/boosting#boost)
	BoostSpec *GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// DataStoreSpecs: Specs defining dataStores to filter on in a search call and
	// configurations for those dataStores. This is only considered for engines
	// with multiple dataStores use case. For single dataStore within an engine,
	// they should use the specs at the top level.
	DataStoreSpecs []*GoogleCloudDiscoveryengineV1betaSearchRequestDataStoreSpec `json:"dataStoreSpecs,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. This will be used to filter
	// search results which may affect the Answer response. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customers might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// MaxReturnResults: Number of search results to return. The default value is
	// 10.
	MaxReturnResults int64 `json:"maxReturnResults,omitempty"`
	// NaturalLanguageQueryUnderstandingSpec: Optional. Specification to enable
	// natural language understanding capabilities for search requests.
	NaturalLanguageQueryUnderstandingSpec *GoogleCloudDiscoveryengineV1betaSearchRequestNaturalLanguageQueryUnderstandingSpec `json:"naturalLanguageQueryUnderstandingSpec,omitempty"`
	// OrderBy: The order in which documents are returned. Documents can be ordered
	// by a field in an Document object. Leave it unset if ordered by relevance.
	// `order_by` expression is case-sensitive. For more information on ordering,
	// see Ordering (https://cloud.google.com/retail/docs/filter-and-order#order)
	// If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// SearchResultMode: Specifies the search result mode. If unspecified, the
	// search result mode defaults to `DOCUMENTS`. See parse and chunk documents
	// (https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
	//
	// Possible values:
	//   "SEARCH_RESULT_MODE_UNSPECIFIED" - Default value.
	//   "DOCUMENTS" - Returns documents in the search result.
	//   "CHUNKS" - Returns chunks in the search result. Only available if the
	// DocumentProcessingConfig.chunking_config is specified.
	SearchResultMode string `json:"searchResultMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultList:
//
//	Search result list.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultList struct {
	// SearchResults: Search results.
	SearchResults []*GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResult `json:"searchResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListS
// earchResult: Search result.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResult struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo `json:"chunkInfo,omitempty"`
	// UnstructuredDocumentInfo: Unstructured document information.
	UnstructuredDocumentInfo *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo `json:"unstructuredDocumentInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListS
// earchResultChunkInfo: Chunk information.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Metadata of the document from the current chunk.
	DocumentMetadata *GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata `json:"documentMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListS
// earchResultChunkInfoDocumentMetadata: Document metadata contains the
// information of the document of the current chunk.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata struct {
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: Uri of the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListS
// earchResultUnstructuredDocumentInfo: Unstructured document information.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// DocumentContexts: List of document contexts. The content will be used for
	// Answer Generation. This is supposed to be the main content of the document
	// that can be long and comprehensive.
	DocumentContexts []*GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext `json:"documentContexts,omitempty"`
	// ExtractiveAnswers: Deprecated: This field is deprecated and will have no
	// effect on the Answer generation. Please use document_contexts and
	// extractive_segments fields. List of extractive answers.
	ExtractiveAnswers []*GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer `json:"extractiveAnswers,omitempty"`
	// ExtractiveSegments: List of extractive segments.
	ExtractiveSegments []*GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment `json:"extractiveSegments,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListS
// earchResultUnstructuredDocumentInfoDocumentContext: Document context.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext struct {
	// Content: Document content to be used for answer generation.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListS
// earchResultUnstructuredDocumentInfoExtractiveAnswer: Extractive answer.
// Guide
// (https://cloud.google.com/generative-ai-app-builder/docs/snippets#get-answers)
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer struct {
	// Content: Extractive answer content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListS
// earchResultUnstructuredDocumentInfoExtractiveSegment: Extractive segment.
// Guide
// (https://cloud.google.com/generative-ai-app-builder/docs/snippets#extractive-segments)
// Answer generation will only use it if document_contexts is empty. This is
// supposed to be shorter snippets.
type GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment struct {
	// Content: Extractive segment content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryResponse: Response message for
// ConversationalSearchService.AnswerQuery method.
type GoogleCloudDiscoveryengineV1betaAnswerQueryResponse struct {
	// Answer: Answer resource object. If
	// AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec.max_rephrase_ste
	// ps is greater than 1, use Answer.name to fetch answer information using
	// ConversationalSearchService.GetAnswer API.
	Answer *GoogleCloudDiscoveryengineV1betaAnswer `json:"answer,omitempty"`
	// AnswerQueryToken: A global unique ID used for logging.
	AnswerQueryToken string `json:"answerQueryToken,omitempty"`
	// Session: Session resource object. It will be only available when session
	// field is set and valid in the AnswerQueryRequest request.
	Session *GoogleCloudDiscoveryengineV1betaSession `json:"session,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfo: Query
// understanding information.
type GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfo struct {
	// QueryClassificationInfo: Query classification information.
	QueryClassificationInfo []*GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfoQueryClassificationInfo `json:"queryClassificationInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryClassificationInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryClassificationInfo") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfoQueryClassificati
// onInfo: Query classification information.
type GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfoQueryClassificationInfo struct {
	// Positive: Classification output.
	Positive bool `json:"positive,omitempty"`
	// Type: Query classification type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified query classification type.
	//   "ADVERSARIAL_QUERY" - Adversarial query classification type.
	//   "NON_ANSWER_SEEKING_QUERY" - Non-answer-seeking query classification type,
	// for chit chat.
	//   "JAIL_BREAKING_QUERY" - Jail-breaking query classification type.
	//   "NON_ANSWER_SEEKING_QUERY_V2" - Non-answer-seeking query classification
	// type, for no clear intent.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Positive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Positive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfoQueryClassificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerQueryUnderstandingInfoQueryClassificationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerReference: Reference.
type GoogleCloudDiscoveryengineV1betaAnswerReference struct {
	// ChunkInfo: Chunk information.
	ChunkInfo *GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfo `json:"chunkInfo,omitempty"`
	// StructuredDocumentInfo: Structured document information.
	StructuredDocumentInfo *GoogleCloudDiscoveryengineV1betaAnswerReferenceStructuredDocumentInfo `json:"structuredDocumentInfo,omitempty"`
	// UnstructuredDocumentInfo: Unstructured document information.
	UnstructuredDocumentInfo *GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfo `json:"unstructuredDocumentInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfo: Chunk information.
type GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// DocumentMetadata: Document metadata.
	DocumentMetadata *GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfoDocumentMetadata `json:"documentMetadata,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfoDocumentMetadata:
// Document metadata.
type GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfoDocumentMetadata struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfoDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerReferenceChunkInfoDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerReferenceStructuredDocumentInfo:
// Structured search information.
type GoogleCloudDiscoveryengineV1betaAnswerReferenceStructuredDocumentInfo struct {
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: Structured search data.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerReferenceStructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerReferenceStructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfo:
// Unstructured document information.
type GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfo struct {
	// ChunkContents: List of cited chunk contents derived from document content.
	ChunkContents []*GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfoChunkContent `json:"chunkContents,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// StructData: The structured JSON metadata for the document. It is populated
	// from the struct data from the Chunk in search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfoChunkC
// ontent: Chunk content.
type GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfoChunkContent struct {
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// PageIdentifier: Page identifier.
	PageIdentifier string `json:"pageIdentifier,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfoChunkContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfoChunkContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfoChunkContent) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerReferenceUnstructuredDocumentInfoChunkContent
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1betaAnswerStep: Step information.
type GoogleCloudDiscoveryengineV1betaAnswerStep struct {
	// Actions: Actions.
	Actions []*GoogleCloudDiscoveryengineV1betaAnswerStepAction `json:"actions,omitempty"`
	// Description: The description of the step.
	Description string `json:"description,omitempty"`
	// State: The state of the step.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Step is currently in progress.
	//   "FAILED" - Step currently failed.
	//   "SUCCEEDED" - Step has succeeded.
	State string `json:"state,omitempty"`
	// Thought: The thought of the step.
	Thought string `json:"thought,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerStepAction: Action.
type GoogleCloudDiscoveryengineV1betaAnswerStepAction struct {
	// Observation: Observation.
	Observation *GoogleCloudDiscoveryengineV1betaAnswerStepActionObservation `json:"observation,omitempty"`
	// SearchAction: Search action.
	SearchAction *GoogleCloudDiscoveryengineV1betaAnswerStepActionSearchAction `json:"searchAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Observation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Observation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerStepAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerStepAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerStepActionObservation: Observation.
type GoogleCloudDiscoveryengineV1betaAnswerStepActionObservation struct {
	// SearchResults: Search results observed by the search action, it can be
	// snippets info or chunk info, depending on the citation type set by the user.
	SearchResults []*GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResult `json:"searchResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerStepActionObservation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerStepActionObservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResult struct {
	// ChunkInfo: If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
	// populate chunk info.
	ChunkInfo []*GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultChunkInfo `json:"chunkInfo,omitempty"`
	// Document: Document resource name.
	Document string `json:"document,omitempty"`
	// SnippetInfo: If citation_type is DOCUMENT_LEVEL_CITATION, populate document
	// level snippets.
	SnippetInfo []*GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultSnippetInfo `json:"snippetInfo,omitempty"`
	// StructData: Data representation. The structured JSON data for the document.
	// It's populated from the struct data from the Document, or the Chunk in
	// search result.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title.
	Title string `json:"title,omitempty"`
	// Uri: URI for the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultChunkI
// nfo: Chunk information.
type GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultChunkInfo struct {
	// Chunk: Chunk resource name.
	Chunk string `json:"chunk,omitempty"`
	// Content: Chunk textual content.
	Content string `json:"content,omitempty"`
	// RelevanceScore: The relevance of the chunk for a given query. Values range
	// from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is
	// for informational purpose only. It may change for the same query and chunk
	// at any time due to a model retraining or change in implementation.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultChunkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultChunkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultChunkInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultChunkInfo
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultSnippe
// tInfo: Snippet information.
type GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultSnippetInfo struct {
	// Snippet: Snippet content.
	Snippet string `json:"snippet,omitempty"`
	// SnippetStatus: Status of the snippet defined by the search team.
	SnippetStatus string `json:"snippetStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippet") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultSnippetInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerStepActionObservationSearchResultSnippetInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaAnswerStepActionSearchAction: Search action.
type GoogleCloudDiscoveryengineV1betaAnswerStepActionSearchAction struct {
	// Query: The query to search.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaAnswerStepActionSearchAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaAnswerStepActionSearchAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBatchCreateTargetSiteMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.BatchCreateTargetSites operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaBatchCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBatchCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBatchCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesRequest: Request
// message for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesRequest struct {
	// Requests: Required. The request message specifying the resources to create.
	// A maximum of 20 TargetSites can be created in a batch.
	Requests []*GoogleCloudDiscoveryengineV1betaCreateTargetSiteRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesResponse: Response
// message for SiteSearchEngineService.BatchCreateTargetSites method.
type GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1betaTargetSite `json:"targetSites,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSites") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponse: Response
// message for DocumentService.BatchGetDocumentsMetadata method.
type GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponse struct {
	// DocumentsMetadata: The metadata of the Documents.
	DocumentsMetadata []*GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMetadata `json:"documentsMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DocumentsMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentsMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMeta
// data: The metadata of a Document.
type GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMetadata struct {
	// DataIngestionSource: The data ingestion source of the Document. Allowed
	// values are: * `batch`: Data ingested via Batch API, e.g., ImportDocuments. *
	// `streaming` Data ingested via Streaming API, e.g., FHIR streaming.
	DataIngestionSource string `json:"dataIngestionSource,omitempty"`
	// LastRefreshedTime: The timestamp of the last time the Document was last
	// indexed.
	LastRefreshedTime string `json:"lastRefreshedTime,omitempty"`
	// MatcherValue: The value of the matcher that was used to match the Document.
	MatcherValue *GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue `json:"matcherValue,omitempty"`
	// State: The state of the document.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Should never be set.
	//   "INDEXED" - The Document is indexed.
	//   "NOT_IN_TARGET_SITE" - The Document is not indexed because its URI is not
	// in the TargetSite.
	//   "NOT_IN_INDEX" - The Document is not indexed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataIngestionSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataIngestionSource") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMeta
// dataMatcherValue: The value of the matcher that was used to match the
// Document.
type GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue struct {
	// FhirResource: Format:
	// projects/{project}/locations/{location}/datasets/{dataset}/fhirStores/{fhir_s
	// tore}/fhir/{resource_type}/{fhir_resource_id}
	FhirResource string `json:"fhirResource,omitempty"`
	// Uri: If match by URI, the URI of the Document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FhirResource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirResource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBatchVerifyTargetSitesRequest: Request
// message for SiteSearchEngineService.BatchVerifyTargetSites method.
type GoogleCloudDiscoveryengineV1betaBatchVerifyTargetSitesRequest struct {
}

// GoogleCloudDiscoveryengineV1betaBigQuerySource: BigQuery source import data
// from.
type GoogleCloudDiscoveryengineV1betaBigQuerySource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for user event imports: * `user_event` (default): One
	// UserEvent per row. Supported values for document imports: * `document`
	// (default): One Document format per row. Each document must have a valid
	// Document.id and one of Document.json_data or Document.struct_data. *
	// `custom`: One custom data per row in arbitrary format that conforms to the
	// defined Schema of the data store. This can only be used by the GENERIC Data
	// Store vertical.
	DataSchema string `json:"dataSchema,omitempty"`
	// DatasetId: Required. The BigQuery data set to copy the data from with a
	// length limit of 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the BigQuery export to a specific Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// PartitionDate: BigQuery time partitioned table's _PARTITIONDATE in
	// YYYY-MM-DD format.
	PartitionDate *GoogleTypeDate `json:"partitionDate,omitempty"`
	// ProjectId: The project ID or the project number that contains the BigQuery
	// source. Has a length limit of 128 characters. If not specified, inherits the
	// project ID from the parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The BigQuery table to copy the data from with a length
	// limit of 1,024 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBigQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBigtableOptions: The Bigtable Options object
// that contains information to support the import.
type GoogleCloudDiscoveryengineV1betaBigtableOptions struct {
	// Families: The mapping from family names to an object that contains column
	// families level information for the given column family. If a family is not
	// present in this map it will be ignored.
	Families map[string]GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumnFamily `json:"families,omitempty"`
	// KeyFieldName: The field name used for saving row key value in the document.
	// The name has to match the pattern `a-zA-Z0-9*`.
	KeyFieldName string `json:"keyFieldName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Families") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Families") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBigtableOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBigtableOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumn: The column of
// the Bigtable.
type GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumn struct {
	// Encoding: The encoding mode of the values when the type is not `STRING`.
	// Acceptable encoding values are: * `TEXT`: indicates values are alphanumeric
	// text strings. * `BINARY`: indicates values are encoded using `HBase
	// Bytes.toBytes` family of functions. This can be overridden for a specific
	// column by listing that column in `columns` and specifying an encoding for
	// it.
	//
	// Possible values:
	//   "ENCODING_UNSPECIFIED" - The encoding is unspecified.
	//   "TEXT" - Text encoding.
	//   "BINARY" - Binary encoding.
	Encoding string `json:"encoding,omitempty"`
	// FieldName: The field name to use for this column in the document. The name
	// has to match the pattern `a-zA-Z0-9*`. If not set, it is parsed from the
	// qualifier bytes with best effort. However, due to different naming patterns,
	// field name collisions could happen, where parsing behavior is undefined.
	FieldName string `json:"fieldName,omitempty"`
	// Qualifier: Required. Qualifier of the column. If it cannot be decoded with
	// utf-8, use a base-64 encoded string instead.
	Qualifier string `json:"qualifier,omitempty"`
	// Type: The type of values in this column family. The values are expected to
	// be encoded using `HBase Bytes.toBytes` function when the encoding value is
	// set to `BINARY`.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified.
	//   "STRING" - String type.
	//   "NUMBER" - Numerical type.
	//   "INTEGER" - Integer type.
	//   "VAR_INTEGER" - Variable length integer type.
	//   "BIG_NUMERIC" - BigDecimal type.
	//   "BOOLEAN" - Boolean type.
	//   "JSON" - JSON type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Encoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Encoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumnFamily: The
// column family of the Bigtable.
type GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumnFamily struct {
	// Columns: The list of objects that contains column level information for each
	// column. If a column is not present in this list it will be ignored.
	Columns []*GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumn `json:"columns,omitempty"`
	// Encoding: The encoding mode of the values when the type is not STRING.
	// Acceptable encoding values are: * `TEXT`: indicates values are alphanumeric
	// text strings. * `BINARY`: indicates values are encoded using `HBase
	// Bytes.toBytes` family of functions. This can be overridden for a specific
	// column by listing that column in `columns` and specifying an encoding for
	// it.
	//
	// Possible values:
	//   "ENCODING_UNSPECIFIED" - The encoding is unspecified.
	//   "TEXT" - Text encoding.
	//   "BINARY" - Binary encoding.
	Encoding string `json:"encoding,omitempty"`
	// FieldName: The field name to use for this column family in the document. The
	// name has to match the pattern `a-zA-Z0-9*`. If not set, it is parsed from
	// the family name with best effort. However, due to different naming patterns,
	// field name collisions could happen, where parsing behavior is undefined.
	FieldName string `json:"fieldName,omitempty"`
	// Type: The type of values in this column family. The values are expected to
	// be encoded using `HBase Bytes.toBytes` function when the encoding value is
	// set to `BINARY`.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unspecified.
	//   "STRING" - String type.
	//   "NUMBER" - Numerical type.
	//   "INTEGER" - Integer type.
	//   "VAR_INTEGER" - Variable length integer type.
	//   "BIG_NUMERIC" - BigDecimal type.
	//   "BOOLEAN" - Boolean type.
	//   "JSON" - JSON type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumnFamily) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBigtableOptionsBigtableColumnFamily
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBigtableSource: The Cloud Bigtable source
// for importing data.
type GoogleCloudDiscoveryengineV1betaBigtableSource struct {
	// BigtableOptions: Required. Bigtable options that contains information needed
	// when parsing data into typed structures. For example, column type
	// annotations.
	BigtableOptions *GoogleCloudDiscoveryengineV1betaBigtableOptions `json:"bigtableOptions,omitempty"`
	// InstanceId: Required. The instance ID of the Cloud Bigtable that needs to be
	// imported.
	InstanceId string `json:"instanceId,omitempty"`
	// ProjectId: The project ID that contains the Bigtable source. Has a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The table ID of the Cloud Bigtable that needs to be
	// imported.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigtableOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigtableOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaBigtableSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBigtableSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCheckGroundingRequest: Request message for
// GroundedGenerationService.CheckGrounding method.
type GoogleCloudDiscoveryengineV1betaCheckGroundingRequest struct {
	// AnswerCandidate: Answer candidate to check. It can have a maximum length of
	// 4096 tokens.
	AnswerCandidate string `json:"answerCandidate,omitempty"`
	// Facts: List of facts for the grounding check. We support up to 200 facts.
	Facts []*GoogleCloudDiscoveryengineV1betaGroundingFact `json:"facts,omitempty"`
	// GroundingSpec: Configuration of the grounding check.
	GroundingSpec *GoogleCloudDiscoveryengineV1betaCheckGroundingSpec `json:"groundingSpec,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerCandidate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerCandidate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCheckGroundingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCheckGroundingRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCheckGroundingResponse: Response message for
// the GroundedGenerationService.CheckGrounding method.
type GoogleCloudDiscoveryengineV1betaCheckGroundingResponse struct {
	// CitedChunks: List of facts cited across all claims in the answer candidate.
	// These are derived from the facts supplied in the request.
	CitedChunks []*GoogleCloudDiscoveryengineV1betaFactChunk `json:"citedChunks,omitempty"`
	// CitedFacts: List of facts cited across all claims in the answer candidate.
	// These are derived from the facts supplied in the request.
	CitedFacts []*GoogleCloudDiscoveryengineV1betaCheckGroundingResponseCheckGroundingFactChunk `json:"citedFacts,omitempty"`
	// Claims: Claim texts and citation info across all claims in the answer
	// candidate.
	Claims []*GoogleCloudDiscoveryengineV1betaCheckGroundingResponseClaim `json:"claims,omitempty"`
	// SupportScore: The support score for the input answer candidate. Higher the
	// score, higher is the fraction of claims that are supported by the provided
	// facts. This is always set when a response is returned.
	SupportScore float64 `json:"supportScore,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CitedChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitedChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCheckGroundingResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCheckGroundingResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaCheckGroundingResponse) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaCheckGroundingResponse
	var s1 struct {
		SupportScore gensupport.JSONFloat64 `json:"supportScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SupportScore = float64(s1.SupportScore)
	return nil
}

// GoogleCloudDiscoveryengineV1betaCheckGroundingResponseCheckGroundingFactChunk
// : Fact chunk for grounding check.
type GoogleCloudDiscoveryengineV1betaCheckGroundingResponseCheckGroundingFactChunk struct {
	// ChunkText: Text content of the fact chunk. Can be at most 10K characters
	// long.
	ChunkText string `json:"chunkText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCheckGroundingResponseCheckGroundingFactChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCheckGroundingResponseCheckGroundingFactChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCheckGroundingResponseClaim: Text and
// citation info for a claim in the answer candidate.
type GoogleCloudDiscoveryengineV1betaCheckGroundingResponseClaim struct {
	// CitationIndices: A list of indices (into 'cited_chunks') specifying the
	// citations associated with the claim. For instance [1,3,4] means that
	// cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
	// supporting for the claim. A citation to a fact indicates that the claim is
	// supported by the fact.
	CitationIndices []int64 `json:"citationIndices,omitempty"`
	// ClaimText: Text for the claim in the answer candidate. Always provided
	// regardless of whether citations or anti-citations are found.
	ClaimText string `json:"claimText,omitempty"`
	// EndPos: Position indicating the end of the claim in the answer candidate,
	// exclusive.
	EndPos int64 `json:"endPos,omitempty"`
	// GroundingCheckRequired: Indicates that this claim required grounding check.
	// When the system decided this claim doesn't require attribution/grounding
	// check, this field will be set to false. In that case, no grounding check was
	// done for the claim and therefore citation_indices should not be returned.
	GroundingCheckRequired bool `json:"groundingCheckRequired,omitempty"`
	// StartPos: Position indicating the start of the claim in the answer
	// candidate, measured in bytes.
	StartPos int64 `json:"startPos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationIndices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationIndices") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCheckGroundingResponseClaim) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCheckGroundingResponseClaim
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCheckGroundingSpec: Specification for the
// grounding check.
type GoogleCloudDiscoveryengineV1betaCheckGroundingSpec struct {
	// CitationThreshold: The threshold (in [0,1]) used for determining whether a
	// fact must be cited for a claim in the answer candidate. Choosing a higher
	// threshold will lead to fewer but very strong citations, while choosing a
	// lower threshold may lead to more but somewhat weaker citations. If unset,
	// the threshold will default to 0.6.
	CitationThreshold float64 `json:"citationThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCheckGroundingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCheckGroundingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaCheckGroundingSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaCheckGroundingSpec
	var s1 struct {
		CitationThreshold gensupport.JSONFloat64 `json:"citationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CitationThreshold = float64(s1.CitationThreshold)
	return nil
}

// GoogleCloudDiscoveryengineV1betaChunk: Chunk captures all raw metadata
// information of items to be recommended or searched in the chunk mode.
type GoogleCloudDiscoveryengineV1betaChunk struct {
	// ChunkMetadata: Output only. Metadata of the current chunk.
	ChunkMetadata *GoogleCloudDiscoveryengineV1betaChunkChunkMetadata `json:"chunkMetadata,omitempty"`
	// Content: Content is a string from a document (parsed content).
	Content string `json:"content,omitempty"`
	// DerivedStructData: Output only. This field is OUTPUT_ONLY. It contains
	// derived data that are not in the original input document.
	DerivedStructData googleapi.RawMessage `json:"derivedStructData,omitempty"`
	// DocumentMetadata: Metadata of the document from the current chunk.
	DocumentMetadata *GoogleCloudDiscoveryengineV1betaChunkDocumentMetadata `json:"documentMetadata,omitempty"`
	// Id: Unique chunk ID of the current chunk.
	Id string `json:"id,omitempty"`
	// Name: The full resource name of the chunk. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
	// This field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `json:"name,omitempty"`
	// PageSpan: Page span of the chunk.
	PageSpan *GoogleCloudDiscoveryengineV1betaChunkPageSpan `json:"pageSpan,omitempty"`
	// RelevanceScore: Output only. Represents the relevance score based on
	// similarity. Higher score indicates higher chunk relevance. The score is in
	// range [-1.0, 1.0]. Only populated on SearchResponse.
	RelevanceScore float64 `json:"relevanceScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkMetadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaChunk) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaChunk
	var s1 struct {
		RelevanceScore gensupport.JSONFloat64 `json:"relevanceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RelevanceScore = float64(s1.RelevanceScore)
	return nil
}

// GoogleCloudDiscoveryengineV1betaChunkChunkMetadata: Metadata of the current
// chunk. This field is only populated on SearchService.Search API.
type GoogleCloudDiscoveryengineV1betaChunkChunkMetadata struct {
	// NextChunks: The next chunks of the current chunk. The number is controlled
	// by SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks. This field is
	// only populated on SearchService.Search API.
	NextChunks []*GoogleCloudDiscoveryengineV1betaChunk `json:"nextChunks,omitempty"`
	// PreviousChunks: The previous chunks of the current chunk. The number is
	// controlled by SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks.
	// This field is only populated on SearchService.Search API.
	PreviousChunks []*GoogleCloudDiscoveryengineV1betaChunk `json:"previousChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NextChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaChunkChunkMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaChunkChunkMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaChunkDocumentMetadata: Document metadata
// contains the information of the document of the current chunk.
type GoogleCloudDiscoveryengineV1betaChunkDocumentMetadata struct {
	// StructData: Data representation. The structured JSON data for the document.
	// It should conform to the registered Schema or an `INVALID_ARGUMENT` error is
	// thrown.
	StructData googleapi.RawMessage `json:"structData,omitempty"`
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: Uri of the document.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StructData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StructData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaChunkDocumentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaChunkDocumentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaChunkPageSpan: Page span of the chunk.
type GoogleCloudDiscoveryengineV1betaChunkPageSpan struct {
	// PageEnd: The end page of the chunk.
	PageEnd int64 `json:"pageEnd,omitempty"`
	// PageStart: The start page of the chunk.
	PageStart int64 `json:"pageStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageEnd") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageEnd") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaChunkPageSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaChunkPageSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCloudSqlSource: Cloud SQL source import data
// from.
type GoogleCloudDiscoveryengineV1betaCloudSqlSource struct {
	// DatabaseId: Required. The Cloud SQL database to copy the data from with a
	// length limit of 256 characters.
	DatabaseId string `json:"databaseId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the Cloud SQL export to a specific Cloud Storage directory. Ensure that the
	// Cloud SQL service account has the necessary Cloud Storage Admin permissions
	// to access the specified Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// InstanceId: Required. The Cloud SQL instance to copy the data from with a
	// length limit of 256 characters.
	InstanceId string `json:"instanceId,omitempty"`
	// Offload: Option for serverless export. Enabling this option will incur
	// additional cost. More info can be found here
	// (https://cloud.google.com/sql/pricing#serverless).
	Offload bool `json:"offload,omitempty"`
	// ProjectId: The project ID that contains the Cloud SQL source. Has a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The Cloud SQL table to copy the data from with a length
	// limit of 256 characters.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCloudSqlSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCloudSqlSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCmekConfig: Configurations used to enable
// CMEK data encryption with Cloud KMS keys.
type GoogleCloudDiscoveryengineV1betaCmekConfig struct {
	// IsDefault: Output only. The default CmekConfig for the Customer.
	IsDefault bool `json:"isDefault,omitempty"`
	// KmsKey: Kms key resource name which will be used to encrypt resources
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId
	// }`.
	KmsKey string `json:"kmsKey,omitempty"`
	// KmsKeyVersion: Kms key version resource name which will be used to encrypt
	// resources `/cryptoKeyVersions/{keyVersion}`.
	KmsKeyVersion string `json:"kmsKeyVersion,omitempty"`
	// LastRotationTimestampMicros: Output only. The timestamp of the last key
	// rotation.
	LastRotationTimestampMicros int64 `json:"lastRotationTimestampMicros,omitempty,string"`
	// Name: Required. Name of the CmekConfig, of the form
	// `projects/{project}/locations/{location}/cmekConfig` or
	// `projects/{project}/locations/{location}/cmekConfigs/{cmekConfig}`.
	Name string `json:"name,omitempty"`
	// State: Output only. State of the CmekConfig.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The CmekConfig state is unknown.
	//   "CREATING" - The CmekConfig is creating.
	//   "ACTIVE" - The CmekConfig can be used with DataStores.
	//   "KEY_ISSUE" - The CmekConfig is unavailable, most likely due to the KMS
	// Key being revoked.
	//   "DELETING" - The CmekConfig is deleting.
	//   "UNUSABLE" - The CmekConfig is not usable, most likely due to some
	// internal issue.
	//   "ACTIVE_ROTATING" - The KMS key version is being rotated.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsDefault") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDefault") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCmekConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCmekConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCompleteQueryResponse: Response message for
// CompletionService.CompleteQuery method.
type GoogleCloudDiscoveryengineV1betaCompleteQueryResponse struct {
	// QuerySuggestions: Results of the matched query suggestions. The result list
	// is ordered and the first result is a top suggestion.
	QuerySuggestions []*GoogleCloudDiscoveryengineV1betaCompleteQueryResponseQuerySuggestion `json:"querySuggestions,omitempty"`
	// TailMatchTriggered: True if the returned suggestions are all tail
	// suggestions. For tail matching to be triggered, include_tail_suggestions in
	// the request must be true and there must be no suggestions that match the
	// full query.
	TailMatchTriggered bool `json:"tailMatchTriggered,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "QuerySuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuerySuggestions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCompleteQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCompleteQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCompleteQueryResponseQuerySuggestion:
// Suggestions as search queries.
type GoogleCloudDiscoveryengineV1betaCompleteQueryResponseQuerySuggestion struct {
	// CompletableFieldPaths: The unique document field paths that serve as the
	// source of this suggestion if it was generated from completable fields. This
	// field is only populated for the document-completable model.
	CompletableFieldPaths []string `json:"completableFieldPaths,omitempty"`
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletableFieldPaths") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletableFieldPaths") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCompleteQueryResponseQuerySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCompleteQueryResponseQuerySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCompletionInfo: Detailed completion
// information including completion attribution token and clicked completion
// info.
type GoogleCloudDiscoveryengineV1betaCompletionInfo struct {
	// SelectedPosition: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion position, starting from 0.
	SelectedPosition int64 `json:"selectedPosition,omitempty"`
	// SelectedSuggestion: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion.
	SelectedSuggestion string `json:"selectedSuggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SelectedPosition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SelectedPosition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCompletionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCompletionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCompletionSuggestion: Autocomplete
// suggestions that are imported from Customer.
type GoogleCloudDiscoveryengineV1betaCompletionSuggestion struct {
	// AlternativePhrases: Alternative matching phrases for this suggestion.
	AlternativePhrases []string `json:"alternativePhrases,omitempty"`
	// Frequency: Frequency of this suggestion. Will be used to rank suggestions
	// when score is not available.
	Frequency int64 `json:"frequency,omitempty,string"`
	// GlobalScore: Global score of this suggestion. Control how this suggestion
	// would be scored / ranked.
	GlobalScore float64 `json:"globalScore,omitempty"`
	// GroupId: If two suggestions have the same groupId, they will not be returned
	// together. Instead the one ranked higher will be returned. This can be used
	// to deduplicate semantically identical suggestions.
	GroupId string `json:"groupId,omitempty"`
	// GroupScore: The score of this suggestion within its group.
	GroupScore float64 `json:"groupScore,omitempty"`
	// LanguageCode: BCP-47 language code of this suggestion.
	LanguageCode string `json:"languageCode,omitempty"`
	// Suggestion: Required. The suggestion text.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternativePhrases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternativePhrases") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCompletionSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCompletionSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaCompletionSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaCompletionSuggestion
	var s1 struct {
		GlobalScore gensupport.JSONFloat64 `json:"globalScore"`
		GroupScore  gensupport.JSONFloat64 `json:"groupScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GlobalScore = float64(s1.GlobalScore)
	s.GroupScore = float64(s1.GroupScore)
	return nil
}

// GoogleCloudDiscoveryengineV1betaCondition: Defines circumstances to be
// checked before allowing a behavior
type GoogleCloudDiscoveryengineV1betaCondition struct {
	// ActiveTimeRange: Range of time(s) specifying when condition is active.
	// Maximum of 10 time ranges.
	ActiveTimeRange []*GoogleCloudDiscoveryengineV1betaConditionTimeRange `json:"activeTimeRange,omitempty"`
	// QueryRegex: Optional. Query regex to match the whole search query. Cannot be
	// set when Condition.query_terms is set. This is currently supporting
	// promotion use case.
	QueryRegex string `json:"queryRegex,omitempty"`
	// QueryTerms: Search only A list of terms to match the query on. Cannot be set
	// when Condition.query_regex is set. Maximum of 10 query terms.
	QueryTerms []*GoogleCloudDiscoveryengineV1betaConditionQueryTerm `json:"queryTerms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaConditionQueryTerm: Matcher for search
// request query
type GoogleCloudDiscoveryengineV1betaConditionQueryTerm struct {
	// FullMatch: Whether the search query needs to exactly match the query term.
	FullMatch bool `json:"fullMatch,omitempty"`
	// Value: The specific query value to match against Must be lowercase, must be
	// UTF-8. Can have at most 3 space separated terms if full_match is true.
	// Cannot be an empty string. Maximum length of 5000 characters.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaConditionQueryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaConditionQueryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaConditionTimeRange: Used for time-dependent
// conditions.
type GoogleCloudDiscoveryengineV1betaConditionTimeRange struct {
	// EndTime: End of time range. Range is inclusive. Must be in the future.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time range. Range is inclusive.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaConditionTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaConditionTimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaControl: Defines a conditioned behavior to
// employ during serving. Must be attached to a ServingConfig to be considered
// at serving time. Permitted actions dependent on `SolutionType`.
type GoogleCloudDiscoveryengineV1betaControl struct {
	// AssociatedServingConfigIds: Output only. List of all ServingConfig IDs this
	// control is attached to. May take up to 10 minutes to update after changes.
	AssociatedServingConfigIds []string `json:"associatedServingConfigIds,omitempty"`
	// BoostAction: Defines a boost-type control
	BoostAction *GoogleCloudDiscoveryengineV1betaControlBoostAction `json:"boostAction,omitempty"`
	// Conditions: Determines when the associated action will trigger. Omit to
	// always apply the action. Currently only a single condition may be specified.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Conditions []*GoogleCloudDiscoveryengineV1betaCondition `json:"conditions,omitempty"`
	// DisplayName: Required. Human readable name. The identifier used in UI views.
	// Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an
	// INVALID ARGUMENT error is thrown.
	DisplayName string `json:"displayName,omitempty"`
	// FilterAction: Defines a filter-type control Currently not supported by
	// Recommendation
	FilterAction *GoogleCloudDiscoveryengineV1betaControlFilterAction `json:"filterAction,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/*/locations/global/dataStore/*/controls/*`
	Name string `json:"name,omitempty"`
	// PromoteAction: Promote certain links based on predefined trigger queries.
	// This now only supports basic site search.
	PromoteAction *GoogleCloudDiscoveryengineV1betaControlPromoteAction `json:"promoteAction,omitempty"`
	// RedirectAction: Defines a redirect-type control.
	RedirectAction *GoogleCloudDiscoveryengineV1betaControlRedirectAction `json:"redirectAction,omitempty"`
	// SolutionType: Required. Immutable. What solution the control belongs to.
	// Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT
	// error is thrown.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// SynonymsAction: Treats a group of terms as synonyms of one another.
	SynonymsAction *GoogleCloudDiscoveryengineV1betaControlSynonymsAction `json:"synonymsAction,omitempty"`
	// UseCases: Specifies the use case for the control. Affects what condition
	// fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only
	// allow one use case per control. Must be set when solution_type is
	// SolutionType.SOLUTION_TYPE_SEARCH.
	//
	// Possible values:
	//   "SEARCH_USE_CASE_UNSPECIFIED" - Value used when unset. Will not occur in
	// CSS.
	//   "SEARCH_USE_CASE_SEARCH" - Search use case. Expects the traffic has a
	// non-empty query.
	//   "SEARCH_USE_CASE_BROWSE" - Browse use case. Expects the traffic has an
	// empty query.
	UseCases []string `json:"useCases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssociatedServingConfigIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedServingConfigIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControl) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaControlBoostAction: Adjusts order of
// products in returned list.
type GoogleCloudDiscoveryengineV1betaControlBoostAction struct {
	// Boost: Required. Strength of the boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0 (No-op).
	Boost float64 `json:"boost,omitempty"`
	// DataStore: Required. Specifies which data store's documents can be boosted
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. Specifies which products to apply the boost to. If no
	// filter is provided all products will be boosted (No-op). Syntax
	// documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum
	// length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControlBoostAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlBoostAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaControlBoostAction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlBoostAction
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1betaControlFilterAction: Specified which
// products may be included in results. Uses same filter as boost.
type GoogleCloudDiscoveryengineV1betaControlFilterAction struct {
	// DataStore: Required. Specifies which data store's documents can be filtered
	// by this control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/defau
	// lt_data_store
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Required. A filter to apply on the matching condition results.
	// Required Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000
	// characters. Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControlFilterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlFilterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaControlPromoteAction: Promote certain links
// based on some trigger queries. Example: Promote shoe store link when
// searching for `shoe` keyword. The link can be outside of associated data
// store.
type GoogleCloudDiscoveryengineV1betaControlPromoteAction struct {
	// DataStore: Required. Data store with which this promotion is attached to.
	DataStore string `json:"dataStore,omitempty"`
	// SearchLinkPromotion: Required. Promotion attached to this action.
	SearchLinkPromotion *GoogleCloudDiscoveryengineV1betaSearchLinkPromotion `json:"searchLinkPromotion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControlPromoteAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlPromoteAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaControlRedirectAction: Redirects a shopper
// to the provided URI.
type GoogleCloudDiscoveryengineV1betaControlRedirectAction struct {
	// RedirectUri: Required. The URI to which the shopper will be redirected.
	// Required. URI must have length equal or less than 2000 characters. Otherwise
	// an INVALID ARGUMENT error is thrown.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RedirectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RedirectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControlRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlRedirectAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaControlSynonymsAction: Creates a set of
// terms that will act as synonyms of one another. Example: "happy" will also
// be considered as "glad", "glad" will also be considered as "happy".
type GoogleCloudDiscoveryengineV1betaControlSynonymsAction struct {
	// Synonyms: Defines a set of synonyms. Can specify up to 100 synonyms. Must
	// specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaControlSynonymsAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaControlSynonymsAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaConversation: External conversation proto
// definition.
type GoogleCloudDiscoveryengineV1betaConversation struct {
	// EndTime: Output only. The time the conversation finished.
	EndTime string `json:"endTime,omitempty"`
	// Messages: Conversation messages.
	Messages []*GoogleCloudDiscoveryengineV1betaConversationMessage `json:"messages,omitempty"`
	// Name: Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/dataStore/*/con
	// versations/*` or
	// `projects/{project}/locations/global/collections/{collection}/engines/*/conve
	// rsations/*`.
	Name string `json:"name,omitempty"`
	// StartTime: Output only. The time the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// State: The state of the Conversation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Conversation is currently open.
	//   "COMPLETED" - Conversation has been completed.
	State string `json:"state,omitempty"`
	// UserPseudoId: A unique identifier for tracking users.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaConversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaConversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaConversationContext: Defines context of the
// conversation
type GoogleCloudDiscoveryengineV1betaConversationContext struct {
	// ActiveDocument: The current active document the user opened. It contains the
	// document resource reference.
	ActiveDocument string `json:"activeDocument,omitempty"`
	// ContextDocuments: The current list of documents the user is seeing. It
	// contains the document resource references.
	ContextDocuments []string `json:"contextDocuments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaConversationContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaConversationContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaConversationMessage: Defines a conversation
// message.
type GoogleCloudDiscoveryengineV1betaConversationMessage struct {
	// CreateTime: Output only. Message creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// Reply: Search reply.
	Reply *GoogleCloudDiscoveryengineV1betaReply `json:"reply,omitempty"`
	// UserInput: User text input.
	UserInput *GoogleCloudDiscoveryengineV1betaTextInput `json:"userInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaConversationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaConversationMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaConverseConversationRequest: Request message
// for ConversationalSearchService.ConverseConversation method.
type GoogleCloudDiscoveryengineV1betaConverseConversationRequest struct {
	// BoostSpec: Boost specification to boost certain documents in search results
	// which may affect the converse response. For more information on boosting,
	// see Boosting (https://cloud.google.com/retail/docs/boosting#boost)
	BoostSpec *GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// Conversation: The conversation to be used by auto session only. The name
	// field will be ignored as we automatically assign new name for the
	// conversation in auto session.
	Conversation *GoogleCloudDiscoveryengineV1betaConversation `json:"conversation,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. This will be used to filter
	// search results which may affect the summary response. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customer might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// Query: Required. Current user input.
	Query *GoogleCloudDiscoveryengineV1betaTextInput `json:"query,omitempty"`
	// SafeSearch: Whether to turn on safe search.
	SafeSearch bool `json:"safeSearch,omitempty"`
	// ServingConfig: The resource name of the Serving Config to use. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store_id}/servingConfigs/{serving_config_id}` If this is not set, the
	// default serving config will be used.
	ServingConfig string `json:"servingConfig,omitempty"`
	// SummarySpec: A specification for configuring the summary returned in the
	// response.
	SummarySpec *GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaConverseConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaConverseConversationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaConverseConversationResponse: Response
// message for ConversationalSearchService.ConverseConversation method.
type GoogleCloudDiscoveryengineV1betaConverseConversationResponse struct {
	// Conversation: Updated conversation including the answer.
	Conversation *GoogleCloudDiscoveryengineV1betaConversation `json:"conversation,omitempty"`
	// RelatedQuestions: Suggested related questions.
	RelatedQuestions []string `json:"relatedQuestions,omitempty"`
	// Reply: Answer to the current query.
	Reply *GoogleCloudDiscoveryengineV1betaReply `json:"reply,omitempty"`
	// SearchResults: Search Results.
	SearchResults []*GoogleCloudDiscoveryengineV1betaSearchResponseSearchResult `json:"searchResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaConverseConversationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaConverseConversationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateDataStoreMetadata: Metadata related to
// the progress of the DataStoreService.CreateDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaCreateDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateEngineMetadata: Metadata related to
// the progress of the EngineService.CreateEngine operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaCreateEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateEvaluationMetadata: Metadata for
// EvaluationService.CreateEvaluation method.
type GoogleCloudDiscoveryengineV1betaCreateEvaluationMetadata struct {
}

// GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata: Metadata for Create
// Schema LRO.
type GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateSitemapMetadata: Metadata related to
// the progress of the SiteSearchEngineService.CreateSitemap operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaCreateSitemapMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.CreateTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateTargetSiteRequest: Request message for
// SiteSearchEngineService.CreateTargetSite method.
type GoogleCloudDiscoveryengineV1betaCreateTargetSiteRequest struct {
	// Parent: Required. Parent resource name of TargetSite, such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/siteSearchEngine`.
	Parent string `json:"parent,omitempty"`
	// TargetSite: Required. The TargetSite to create.
	TargetSite *GoogleCloudDiscoveryengineV1betaTargetSite `json:"targetSite,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCreateTargetSiteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateTargetSiteRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCustomAttribute: A custom attribute that is
// not explicitly modeled in a resource, e.g. UserEvent.
type GoogleCloudDiscoveryengineV1betaCustomAttribute struct {
	// Numbers: The numerical values of this custom attribute. For example, `[2.3,
	// 15.4]` when the key is "lengths_cm". Exactly one of CustomAttribute.text or
	// CustomAttribute.numbers should be set. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	Numbers []float64 `json:"numbers,omitempty"`
	// Text: The textual values of this custom attribute. For example, `["yellow",
	// "green"]` when the key is "color". Empty string is not allowed. Otherwise,
	// an `INVALID_ARGUMENT` error is returned. Exactly one of CustomAttribute.text
	// or CustomAttribute.numbers should be set. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Numbers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Numbers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCustomAttribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaCustomAttribute) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaCustomAttribute
	var s1 struct {
		Numbers []gensupport.JSONFloat64 `json:"numbers"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Numbers = make([]float64, len(s1.Numbers))
	for i := range s1.Numbers {
		s.Numbers[i] = float64(s1.Numbers[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1betaCustomTuningModel: Metadata that describes a
// custom tuned model.
type GoogleCloudDiscoveryengineV1betaCustomTuningModel struct {
	// CreateTime: Deprecated: Timestamp the Model was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The display name of the model.
	DisplayName string `json:"displayName,omitempty"`
	// ErrorMessage: Currently this is only populated if the model state is
	// `INPUT_VALIDATION_FAILED`.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// Metrics: The metrics of the trained model.
	Metrics map[string]float64 `json:"metrics,omitempty"`
	// ModelState: The state that the model is in (e.g.`TRAINING` or
	// `TRAINING_FAILED`).
	//
	// Possible values:
	//   "MODEL_STATE_UNSPECIFIED" - Default value.
	//   "TRAINING_PAUSED" - The model is in a paused training state.
	//   "TRAINING" - The model is currently training.
	//   "TRAINING_COMPLETE" - The model has successfully completed training.
	//   "READY_FOR_SERVING" - The model is ready for serving.
	//   "TRAINING_FAILED" - The model training failed.
	//   "NO_IMPROVEMENT" - The model training finished successfully but metrics
	// did not improve.
	//   "INPUT_VALIDATION_FAILED" - Input data validation failed. Model training
	// didn't start.
	ModelState string `json:"modelState,omitempty"`
	// ModelVersion: The version of the model.
	ModelVersion int64 `json:"modelVersion,omitempty,string"`
	// Name: Required. The fully qualified resource name of the model. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/customTuningModels/{custom_tuning_model}`. Model must be an
	// alpha-numerical string with limit of 40 characters.
	Name string `json:"name,omitempty"`
	// TrainingStartTime: Timestamp the model training was initiated.
	TrainingStartTime string `json:"trainingStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaCustomTuningModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCustomTuningModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDataStore: DataStore captures global
// settings and configs at the DataStore level.
type GoogleCloudDiscoveryengineV1betaDataStore struct {
	// AdvancedSiteSearchConfig: Optional. Configuration for advanced site search.
	AdvancedSiteSearchConfig *GoogleCloudDiscoveryengineV1betaAdvancedSiteSearchConfig `json:"advancedSiteSearchConfig,omitempty"`
	// BillingEstimation: Output only. Data size estimation for billing.
	BillingEstimation *GoogleCloudDiscoveryengineV1betaDataStoreBillingEstimation `json:"billingEstimation,omitempty"`
	// CmekConfig: Output only. CMEK-related information for the DataStore.
	CmekConfig *GoogleCloudDiscoveryengineV1betaCmekConfig `json:"cmekConfig,omitempty"`
	// ContentConfig: Immutable. The content config of the data store. If this
	// field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
	//
	// Possible values:
	//   "CONTENT_CONFIG_UNSPECIFIED" - Default value.
	//   "NO_CONTENT" - Only contains documents without any Document.content.
	//   "CONTENT_REQUIRED" - Only contains documents with Document.content.
	//   "PUBLIC_WEBSITE" - The data store is used for public website search.
	//   "GOOGLE_WORKSPACE" - The data store is used for workspace search. Details
	// of workspace data store are specified in the WorkspaceConfig.
	ContentConfig string `json:"contentConfig,omitempty"`
	// CreateTime: Output only. Timestamp the DataStore was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DefaultSchemaId: Output only. The id of the default Schema asscociated to
	// this data store.
	DefaultSchemaId string `json:"defaultSchemaId,omitempty"`
	// DisplayName: Required. The data store display name. This field must be a
	// UTF-8 encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentProcessingConfig: Configuration for Document understanding and
	// enrichment.
	DocumentProcessingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig `json:"documentProcessingConfig,omitempty"`
	// IndustryVertical: Immutable. The industry vertical that the data store
	// registers.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// KmsKeyName: Input only. The KMS key to be used to protect this DataStore at
	// creation time. Must be set for requests that need to comply with CMEK Org
	// Policy protections. If this field is set and processed successfully, the
	// DataStore will be protected by the KMS key, as indicated in the cmek_config
	// field.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// LanguageInfo: Language info for DataStore.
	LanguageInfo *GoogleCloudDiscoveryengineV1betaLanguageInfo `json:"languageInfo,omitempty"`
	// Name: Immutable. The full resource name of the data store. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`. This field must be a UTF-8 encoded string with a length
	// limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// NaturalLanguageQueryUnderstandingConfig: Optional. Configuration for Natural
	// Language Query Understanding.
	NaturalLanguageQueryUnderstandingConfig *GoogleCloudDiscoveryengineV1betaNaturalLanguageQueryUnderstandingConfig `json:"naturalLanguageQueryUnderstandingConfig,omitempty"`
	// ServingConfigDataStore: Optional. Stores serving config at DataStore level.
	ServingConfigDataStore *GoogleCloudDiscoveryengineV1betaDataStoreServingConfigDataStore `json:"servingConfigDataStore,omitempty"`
	// SolutionTypes: The solutions that the data store enrolls. Available
	// solutions for each industry_vertical: * `MEDIA`:
	// `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`:
	// `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be
	// enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionTypes []string `json:"solutionTypes,omitempty"`
	// StartingSchema: The start schema to use for this DataStore when provisioning
	// it. If unset, a default vertical specialized schema will be used. This field
	// is only used by CreateDataStore API, and will be ignored if used in other
	// APIs. This field will be omitted from all API responses including
	// CreateDataStore API. To retrieve a schema of a DataStore, use
	// SchemaService.GetSchema API instead. The provided schema will be validated
	// against certain rules on schema. Learn more from this doc
	// (https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
	StartingSchema *GoogleCloudDiscoveryengineV1betaSchema `json:"startingSchema,omitempty"`
	// WorkspaceConfig: Config to store data store type configuration for workspace
	// data. This must be set when DataStore.content_config is set as
	// DataStore.ContentConfig.GOOGLE_WORKSPACE.
	WorkspaceConfig *GoogleCloudDiscoveryengineV1betaWorkspaceConfig `json:"workspaceConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSiteSearchConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSiteSearchConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDataStoreBillingEstimation: Estimation of
// data size per data store.
type GoogleCloudDiscoveryengineV1betaDataStoreBillingEstimation struct {
	// StructuredDataSize: Data size for structured data in terms of bytes.
	StructuredDataSize int64 `json:"structuredDataSize,omitempty,string"`
	// StructuredDataUpdateTime: Last updated timestamp for structured data.
	StructuredDataUpdateTime string `json:"structuredDataUpdateTime,omitempty"`
	// UnstructuredDataSize: Data size for unstructured data in terms of bytes.
	UnstructuredDataSize int64 `json:"unstructuredDataSize,omitempty,string"`
	// UnstructuredDataUpdateTime: Last updated timestamp for unstructured data.
	UnstructuredDataUpdateTime string `json:"unstructuredDataUpdateTime,omitempty"`
	// WebsiteDataSize: Data size for websites in terms of bytes.
	WebsiteDataSize int64 `json:"websiteDataSize,omitempty,string"`
	// WebsiteDataUpdateTime: Last updated timestamp for websites.
	WebsiteDataUpdateTime string `json:"websiteDataUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StructuredDataSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StructuredDataSize") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDataStoreBillingEstimation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDataStoreBillingEstimation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDataStoreServingConfigDataStore: Stores
// information regarding the serving configurations at DataStore level.
type GoogleCloudDiscoveryengineV1betaDataStoreServingConfigDataStore struct {
	// DisabledForServing: If set true, the DataStore will not be available for
	// serving search requests.
	DisabledForServing bool `json:"disabledForServing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisabledForServing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisabledForServing") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDataStoreServingConfigDataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDataStoreServingConfigDataStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteDataStoreMetadata: Metadata related to
// the progress of the DataStoreService.DeleteDataStore operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaDeleteDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDeleteDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteDataStoreMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteEngineMetadata: Metadata related to
// the progress of the EngineService.DeleteEngine operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaDeleteEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDeleteEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata: Metadata for
// DeleteSchema LRO.
type GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteSitemapMetadata: Metadata related to
// the progress of the SiteSearchEngineService.DeleteSitemap operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaDeleteSitemapMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDeleteSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteTargetSiteMetadata: Metadata related
// to the progress of the SiteSearchEngineService.DeleteTargetSite operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaDeleteTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDeleteTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteTargetSiteMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchRequest: Request
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchRequest struct {
}

// GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1betaDocument: Document captures all raw metadata
// information of items to be recommended or searched.
type GoogleCloudDiscoveryengineV1betaDocument struct {
	// Content: The unstructured data linked to this document. Content must be set
	// if this document is under a `CONTENT_REQUIRED` data store.
	Content *GoogleCloudDiscoveryengineV1betaDocumentContent `json:"content,omitempty"`
	// DerivedStructData: Output only. This field is OUTPUT_ONLY. It contains
	// derived data that are not in the original input document.
	DerivedStructData googleapi.RawMessage `json:"derivedStructData,omitempty"`
	// Id: Immutable. The identifier of the document. Id should conform to RFC-1034
	// (https://tools.ietf.org/html/rfc1034) standard with a length limit of 63
	// characters.
	Id string `json:"id,omitempty"`
	// IndexStatus: Output only. The index status of the document. * If document is
	// indexed successfully, the index_time field is populated. * Otherwise, if
	// document is not indexed due to errors, the error_samples field is populated.
	// * Otherwise, index_status is unset.
	IndexStatus *GoogleCloudDiscoveryengineV1betaDocumentIndexStatus `json:"indexStatus,omitempty"`
	// IndexTime: Output only. The last time the document was indexed. If this
	// field is set, the document could be returned in search results. This field
	// is OUTPUT_ONLY. If this field is not populated, it means the document has
	// never been indexed.
	IndexTime string `json:"indexTime,omitempty"`
	// JsonData: The JSON string representation of the document. It should conform
	// to the registered Schema or an `INVALID_ARGUMENT` error is thrown.
	JsonData string `json:"jsonData,omitempty"`
	// Name: Immutable. The full resource name of the document. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/branches/{branch}/documents/{document_id}`. This field must be
	// a UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// ParentDocumentId: The identifier of the parent document. Currently supports
	// at most two level document hierarchy. Id should conform to RFC-1034
	// (https://tools.ietf.org/html/rfc1034) standard with a length limit of 63
	// characters.
	ParentDocumentId string `json:"parentDocumentId,omitempty"`
	// SchemaId: The identifier of the schema located in the same data store.
	SchemaId string `json:"schemaId,omitempty"`
	// StructData: The structured JSON data for the document. It should conform to
	// the registered Schema or an `INVALID_ARGUMENT` error is thrown.
	StructData googleapi.RawMessage `json:"structData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentContent: Unstructured data linked to
// this document.
type GoogleCloudDiscoveryengineV1betaDocumentContent struct {
	// MimeType: The MIME type of the content. Supported types: * `application/pdf`
	// (PDF, only native PDFs are supported for now) * `text/html` (HTML) *
	// `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
	// (DOCX) *
	// `application/vnd.openxmlformats-officedocument.presentationml.presentation`
	// (PPTX) * `text/plain` (TXT) See
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `json:"mimeType,omitempty"`
	// RawBytes: The content represented as a stream of bytes. The maximum length
	// is 1,000,000 bytes (1 MB / ~0.95 MiB). Note: As with all `bytes` fields,
	// this field is represented as pure binary in Protocol Buffers and
	// base64-encoded string in JSON. For example, `abc123!?$*&()'-=@~` should be
	// represented as `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	RawBytes string `json:"rawBytes,omitempty"`
	// Uri: The URI of the content. Only Cloud Storage URIs (e.g.
	// `gs://bucket-name/path/to/file`) are supported. The maximum file size is 2.5
	// MB for text-based formats, 200 MB for other formats.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentIndexStatus: Index status of the
// document.
type GoogleCloudDiscoveryengineV1betaDocumentIndexStatus struct {
	// ErrorSamples: A sample of errors encountered while indexing the document. If
	// this field is populated, the document is not indexed due to errors.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// IndexTime: The time when the document was indexed. If this field is
	// populated, it means the document has been indexed.
	IndexTime string `json:"indexTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentIndexStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentIndexStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentInfo: Detailed document information
// associated with a user event.
type GoogleCloudDiscoveryengineV1betaDocumentInfo struct {
	// ConversionValue: Optional. The conversion value associated with this
	// Document. Must be set if UserEvent.event_type is "conversion". For example,
	// a value of 1000 signifies that 1000 seconds were spent viewing a Document
	// for the `watch` conversion type.
	ConversionValue float64 `json:"conversionValue,omitempty"`
	// Id: The Document resource ID.
	Id string `json:"id,omitempty"`
	// Joined: Output only. Whether the referenced Document can be found in the
	// data store.
	Joined bool `json:"joined,omitempty"`
	// Name: The Document resource full name, of the form:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}/branches/{branch_id}/documents/{document_id}`
	Name string `json:"name,omitempty"`
	// PromotionIds: The promotion IDs associated with this Document. Currently,
	// this field is restricted to at most one ID.
	PromotionIds []string `json:"promotionIds,omitempty"`
	// Quantity: Quantity of the Document associated with the user event. Defaults
	// to 1. For example, this field is 2 if two quantities of the same Document
	// are involved in a `add-to-cart` event. Required for events of the following
	// event types: * `add-to-cart` * `purchase`
	Quantity int64 `json:"quantity,omitempty"`
	// Uri: The Document URI - only allowed for website data stores.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversionValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversionValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaDocumentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentInfo
	var s1 struct {
		ConversionValue gensupport.JSONFloat64 `json:"conversionValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConversionValue = float64(s1.ConversionValue)
	return nil
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig: A singleton
// resource of DataStore. If it's empty when DataStore is created and DataStore
// is set to DataStore.ContentConfig.CONTENT_REQUIRED, the default parser will
// default to digital parser.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig struct {
	// ChunkingConfig: Whether chunking mode is enabled.
	ChunkingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig `json:"chunkingConfig,omitempty"`
	// DefaultParsingConfig: Configurations for default Document parser. If not
	// specified, we will configure it as default DigitalParsingConfig, and the
	// default parsing config will be applied to all file types for Document
	// parsing.
	DefaultParsingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig `json:"defaultParsingConfig,omitempty"`
	// Name: The full resource name of the Document Processing Config. Format:
	// `projects/*/locations/*/collections/*/dataStores/*/documentProcessingConfig`.
	Name string `json:"name,omitempty"`
	// ParsingConfigOverrides: Map from file type to override the default parsing
	// configuration based on the file type. Supported keys: * `pdf`: Override
	// parsing config for PDF files, either digital parsing, ocr parsing or layout
	// parsing is supported. * `html`: Override parsing config for HTML files, only
	// digital parsing and layout parsing are supported. * `docx`: Override parsing
	// config for DOCX files, only digital parsing and layout parsing are
	// supported. * `pptx`: Override parsing config for PPTX files, only digital
	// parsing and layout parsing are supported. * `xlsm`: Override parsing config
	// for XLSM files, only digital parsing and layout parsing are supported. *
	// `xlsx`: Override parsing config for XLSX files, only digital parsing and
	// layout parsing are supported.
	ParsingConfigOverrides map[string]GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig `json:"parsingConfigOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig:
// Configuration for chunking config.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig struct {
	// LayoutBasedChunkingConfig: Configuration for the layout based chunking.
	LayoutBasedChunkingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig `json:"layoutBasedChunkingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LayoutBasedChunkingConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LayoutBasedChunkingConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutB
// asedChunkingConfig: Configuration for the layout based chunking.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig struct {
	// ChunkSize: The token size limit for each chunk. Supported values: 100-500
	// (inclusive). Default value: 500.
	ChunkSize int64 `json:"chunkSize,omitempty"`
	// IncludeAncestorHeadings: Whether to include appending different levels of
	// headings to chunks from the middle of the document to prevent context loss.
	// Default value: False.
	IncludeAncestorHeadings bool `json:"includeAncestorHeadings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig:
// Related configurations applied to a specific type of document parser.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig struct {
	// DigitalParsingConfig: Configurations applied to digital parser.
	DigitalParsingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigDigitalParsingConfig `json:"digitalParsingConfig,omitempty"`
	// LayoutParsingConfig: Configurations applied to layout parser.
	LayoutParsingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigLayoutParsingConfig `json:"layoutParsingConfig,omitempty"`
	// OcrParsingConfig: Configurations applied to OCR parser. Currently it only
	// applies to PDFs.
	OcrParsingConfig *GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig `json:"ocrParsingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DigitalParsingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DigitalParsingConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigDigitalP
// arsingConfig: The digital parsing configurations for documents.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigDigitalParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigLayoutPa
// rsingConfig: The layout parsing configurations for documents.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigLayoutParsingConfig struct {
}

// GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsi
// ngConfig: The OCR parsing configurations for documents.
type GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig struct {
	// EnhancedDocumentElements: [DEPRECATED] This field is deprecated. To use the
	// additional enhanced document elements processing, please switch to
	// `layout_parsing_config`.
	EnhancedDocumentElements []string `json:"enhancedDocumentElements,omitempty"`
	// UseNativeText: If true, will use native text instead of OCR text on pages
	// containing native text.
	UseNativeText bool `json:"useNativeText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnhancedDocumentElements")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnhancedDocumentElements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDoubleList: Double list.
type GoogleCloudDiscoveryengineV1betaDoubleList struct {
	// Values: Double values.
	Values []float64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaDoubleList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDoubleList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaDoubleList) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaDoubleList
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1betaEmbeddingConfig: Defines embedding config,
// used for bring your own embeddings feature.
type GoogleCloudDiscoveryengineV1betaEmbeddingConfig struct {
	// FieldPath: Full field path in the schema mapped as embedding field.
	FieldPath string `json:"fieldPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEmbeddingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEmbeddingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchRequest: Request
// message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchRequest struct {
}

// GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchResponse: Response
// message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1betaEngine: Metadata that describes the training
// and serving parameters of an Engine.
type GoogleCloudDiscoveryengineV1betaEngine struct {
	// ChatEngineConfig: Configurations for the Chat Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineConfig *GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig `json:"chatEngineConfig,omitempty"`
	// ChatEngineMetadata: Output only. Additional information of the Chat Engine.
	// Only applicable if solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineMetadata *GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata `json:"chatEngineMetadata,omitempty"`
	// CommonConfig: Common config spec that specifies the metadata of the engine.
	CommonConfig *GoogleCloudDiscoveryengineV1betaEngineCommonConfig `json:"commonConfig,omitempty"`
	// CreateTime: Output only. Timestamp the Recommendation Engine was created at.
	CreateTime string `json:"createTime,omitempty"`
	// DataStoreIds: The data stores associated with this engine. For
	// SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they
	// can only associate with at most one data store. If solution_type is
	// SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be
	// associated here. Note that when used in CreateEngineRequest, one DataStore
	// id must be provided as the system will use it for necessary initializations.
	DataStoreIds []string `json:"dataStoreIds,omitempty"`
	// DisableAnalytics: Optional. Whether to disable analytics for searches
	// performed on this engine.
	DisableAnalytics bool `json:"disableAnalytics,omitempty"`
	// DisplayName: Required. The display name of the engine. Should be human
	// readable. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`
	// IndustryVertical: The industry vertical that the engine registers. The
	// restriction of the Engine industry vertical is based on DataStore: Vertical
	// on Engine has to match vertical of the DataStore linked to the engine.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not specific to
	// any industry vertical.
	//   "MEDIA" - The media industry vertical.
	//   "HEALTHCARE_FHIR" - The healthcare FHIR vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`
	// Name: Immutable. The fully qualified resource name of the engine. This field
	// must be a UTF-8 encoded string with a length limit of 1024 characters.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{en
	// gine}` engine should be 1-63 characters, and valid characters are /a-z0-9*/.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	Name string `json:"name,omitempty"`
	// SearchEngineConfig: Configurations for the Search Engine. Only applicable if
	// solution_type is SOLUTION_TYPE_SEARCH.
	SearchEngineConfig *GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig `json:"searchEngineConfig,omitempty"`
	// SolutionType: Required. The solutions of the engine.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative AI
	// agent.
	//   "SOLUTION_TYPE_GENERATIVE_CHAT" - Used for use cases related to the
	// Generative Chat agent. It's used for Generative chat engine only, the
	// associated data stores must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType string `json:"solutionType,omitempty"`
	// UpdateTime: Output only. Timestamp the Recommendation Engine was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ChatEngineConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChatEngineConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig: Configurations for a
// Chat Engine.
type GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig struct {
	// AgentCreationConfig: The configurationt generate the Dialogflow agent that
	// is associated to this Engine. Note that these configurations are one-time
	// consumed by and passed to Dialogflow service. It means they cannot be
	// retrieved using EngineService.GetEngine or EngineService.ListEngines API
	// after engine creation.
	AgentCreationConfig *GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig `json:"agentCreationConfig,omitempty"`
	// DialogflowAgentToLink: The resource name of an exist Dialogflow agent to
	// link to this Chat Engine. Customers can either provide
	// `agent_creation_config` to create agent or provide an agent name that links
	// the agent with the Chat engine. Format: `projects//locations//agents/`. Note
	// that the `dialogflow_agent_to_link` are one-time consumed by and passed to
	// Dialogflow service. It means they cannot be retrieved using
	// EngineService.GetEngine or EngineService.ListEngines API after engine
	// creation. Use ChatEngineMetadata.dialogflow_agent for actual agent
	// association after Engine is created.
	DialogflowAgentToLink string `json:"dialogflowAgentToLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCreationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCreationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig:
// Configurations for generating a Dialogflow agent. Note that these
// configurations are one-time consumed by and passed to Dialogflow service. It
// means they cannot be retrieved using EngineService.GetEngine or
// EngineService.ListEngines API after engine creation.
type GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig struct {
	// Business: Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `json:"business,omitempty"`
	// DefaultLanguageCode: Required. The default language of the agent as a
	// language tag. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// Location: Agent location for Agent creation, supported values: global/us/eu.
	// If not provided, us Engine will create Agent using us-central-1 by default;
	// eu Engine will create Agent using eu-west-1 by default.
	Location string `json:"location,omitempty"`
	// TimeZone: Required. The time zone of the agent from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Business") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Business") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata: Additional
// information of a Chat Engine. Fields in this message are output only.
type GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata struct {
	// DialogflowAgent: The resource name of a Dialogflow agent, that this Chat
	// Engine refers to. Format: `projects//locations//agents/`.
	DialogflowAgent string `json:"dialogflowAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowAgent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowAgent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineCommonConfig: Common configurations
// for an Engine.
type GoogleCloudDiscoveryengineV1betaEngineCommonConfig struct {
	// CompanyName: The name of the company, business or entity that is associated
	// with the engine. Setting this may help improve LLM related features.
	CompanyName string `json:"companyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompanyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompanyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineCommonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineCommonConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig: Configurations for
// a Search Engine.
type GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig struct {
	// SearchAddOns: The add-on that this search engine enables.
	//
	// Possible values:
	//   "SEARCH_ADD_ON_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_ADD_ON_LLM" - Large language model add-on.
	SearchAddOns []string `json:"searchAddOns,omitempty"`
	// SearchTier: The search feature tier of this engine. Different tiers might
	// have different pricing. To learn more, check the pricing documentation.
	// Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
	//
	// Possible values:
	//   "SEARCH_TIER_UNSPECIFIED" - Default value when the enum is unspecified.
	// This is invalid to use.
	//   "SEARCH_TIER_STANDARD" - Standard tier.
	//   "SEARCH_TIER_ENTERPRISE" - Enterprise tier.
	SearchTier string `json:"searchTier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchAddOns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchAddOns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEvaluation: An evaluation is a single
// execution (or run) of an evaluation process. It encapsulates the state of
// the evaluation and the resulting data.
type GoogleCloudDiscoveryengineV1betaEvaluation struct {
	// CreateTime: Output only. Timestamp the Evaluation was created at.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. Timestamp the Evaluation was completed at.
	EndTime string `json:"endTime,omitempty"`
	// Error: Output only. The error that occurred during evaluation. Only
	// populated when the evaluation's state is FAILED.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// ErrorSamples: Output only. A sample of errors encountered while processing
	// the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// EvaluationSpec: Required. The specification of the evaluation.
	EvaluationSpec *GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpec `json:"evaluationSpec,omitempty"`
	// Name: Identifier. The full resource name of the Evaluation, in the format of
	// `projects/{project}/locations/{location}/evaluations/{evaluation}`. This
	// field must be a UTF-8 encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// QualityMetrics: Output only. The metrics produced by the evaluation,
	// averaged across all SampleQuerys in the SampleQuerySet. Only populated when
	// the evaluation's state is SUCCEEDED.
	QualityMetrics *GoogleCloudDiscoveryengineV1betaQualityMetrics `json:"qualityMetrics,omitempty"`
	// State: Output only. The state of the evaluation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The evaluation is unspecified.
	//   "PENDING" - The service is preparing to run the evaluation.
	//   "RUNNING" - The evaluation is in progress.
	//   "SUCCEEDED" - The evaluation completed successfully.
	//   "FAILED" - The evaluation failed.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEvaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpec: Describes the
// specification of the evaluation.
type GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpec struct {
	// QuerySetSpec: Required. The specification of the query set.
	QuerySetSpec *GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpecQuerySetSpec `json:"querySetSpec,omitempty"`
	// SearchRequest: Required. The search request that is used to perform the
	// evaluation. Only the following fields within SearchRequest are supported; if
	// any other fields are provided, an UNSUPPORTED error will be returned: *
	// SearchRequest.serving_config * SearchRequest.branch *
	// SearchRequest.canonical_filter * SearchRequest.query_expansion_spec *
	// SearchRequest.spell_correction_spec * SearchRequest.content_search_spec *
	// SearchRequest.user_pseudo_id
	SearchRequest *GoogleCloudDiscoveryengineV1betaSearchRequest `json:"searchRequest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuerySetSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuerySetSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpecQuerySetSpec:
// Describes the specification of the query set.
type GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpecQuerySetSpec struct {
	// SampleQuerySet: Required. The full resource name of the SampleQuerySet used
	// for the evaluation, in the format of
	// `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
	SampleQuerySet string `json:"sampleQuerySet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SampleQuerySet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SampleQuerySet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpecQuerySetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpecQuerySetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaFactChunk: Fact Chunk.
type GoogleCloudDiscoveryengineV1betaFactChunk struct {
	// ChunkText: Text content of the fact chunk. Can be at most 10K characters
	// long.
	ChunkText string `json:"chunkText,omitempty"`
	// Index: The index of this chunk. Currently, only used for the streaming mode.
	Index int64 `json:"index,omitempty"`
	// Source: Source from which this fact chunk was retrieved. If it was retrieved
	// from the GroundingFacts provided in the request then this field will contain
	// the index of the specific fact from which this chunk was retrieved.
	Source string `json:"source,omitempty"`
	// SourceMetadata: More fine-grained information for the source reference.
	SourceMetadata map[string]string `json:"sourceMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaFactChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaFactChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaFetchDomainVerificationStatusResponse:
// Response message for SiteSearchEngineService.FetchDomainVerificationStatus
// method.
type GoogleCloudDiscoveryengineV1betaFetchDomainVerificationStatusResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TargetSites: List of TargetSites containing the site verification status.
	TargetSites []*GoogleCloudDiscoveryengineV1betaTargetSite `json:"targetSites,omitempty"`
	// TotalSize: The total number of items matching the request. This will always
	// be populated in the response.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaFetchDomainVerificationStatusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaFetchDomainVerificationStatusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaFetchSitemapsResponse: Response message for
// SiteSearchEngineService.FetchSitemaps method.
type GoogleCloudDiscoveryengineV1betaFetchSitemapsResponse struct {
	// SitemapsMetadata: List of Sitemaps fetched.
	SitemapsMetadata []*GoogleCloudDiscoveryengineV1betaFetchSitemapsResponseSitemapMetadata `json:"sitemapsMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "SitemapsMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SitemapsMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaFetchSitemapsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaFetchSitemapsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaFetchSitemapsResponseSitemapMetadata:
// Contains a Sitemap and its metadata.
type GoogleCloudDiscoveryengineV1betaFetchSitemapsResponseSitemapMetadata struct {
	// Sitemap: The Sitemap.
	Sitemap *GoogleCloudDiscoveryengineV1betaSitemap `json:"sitemap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Sitemap") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Sitemap") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaFetchSitemapsResponseSitemapMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaFetchSitemapsResponseSitemapMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaFhirStoreSource: Cloud FhirStore source
// import data from.
type GoogleCloudDiscoveryengineV1betaFhirStoreSource struct {
	// FhirStore: Required. The full resource name of the FHIR store to import data
	// from, in the format of
	// `projects/{project}/locations/{location}/datasets/{dataset}/fhirStores/{fhir_
	// store}`.
	FhirStore string `json:"fhirStore,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the FhirStore export to a specific Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// ResourceTypes: The FHIR resource types to import. The resource types should
	// be a subset of all supported FHIR resource types
	// (https://cloud.google.com/generative-ai-app-builder/docs/fhir-schema-reference#resource-level-specification).
	// Default to all supported FHIR resource types if empty.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
	// UpdateFromLatestPredefinedSchema: Optional. Whether to update the DataStore
	// schema to the latest predefined schema. If true, the DataStore schema will
	// be updated to include any FHIR fields or resource types that have been added
	// since the last import and corresponding FHIR resources will be imported from
	// the FHIR store. Note this field cannot be used in conjunction with
	// `resource_types`. It should be used after initial import.
	UpdateFromLatestPredefinedSchema bool `json:"updateFromLatestPredefinedSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FhirStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaFhirStoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaFhirStoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaFirestoreSource: Firestore source import
// data from.
type GoogleCloudDiscoveryengineV1betaFirestoreSource struct {
	// CollectionId: Required. The Firestore collection (or entity) to copy the
	// data from with a length limit of 1,500 characters.
	CollectionId string `json:"collectionId,omitempty"`
	// DatabaseId: Required. The Firestore database to copy the data from with a
	// length limit of 256 characters.
	DatabaseId string `json:"databaseId,omitempty"`
	// GcsStagingDir: Intermediate Cloud Storage directory used for the import with
	// a length limit of 2,000 characters. Can be specified if one wants to have
	// the Firestore export to a specific Cloud Storage directory. Ensure that the
	// Firestore service account has the necessary Cloud Storage Admin permissions
	// to access the specified Cloud Storage directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`
	// ProjectId: The project ID that the Cloud SQL source is in with a length
	// limit of 128 characters. If not specified, inherits the project ID from the
	// parent request.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaFirestoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaFirestoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaGcsSource: Cloud Storage location for input
// content.
type GoogleCloudDiscoveryengineV1betaGcsSource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for document imports: * `document` (default): One JSON
	// Document per line. Each document must have a valid Document.id. * `content`:
	// Unstructured data (e.g. PDF, HTML). Each file matched by `input_uris`
	// becomes a document, with the ID set to the first 128 bits of SHA256(URI)
	// encoded as a hex string. * `custom`: One custom data JSON per row in
	// arbitrary format that conforms to the defined Schema of the data store. This
	// can only be used by the GENERIC Data Store vertical. * `csv`: A CSV file
	// with header conforming to the defined Schema of the data store. Each entry
	// after the header is imported as a Document. This can only be used by the
	// GENERIC Data Store vertical. Supported values for user event imports: *
	// `user_event` (default): One JSON UserEvent per line.
	DataSchema string `json:"dataSchema,omitempty"`
	// InputUris: Required. Cloud Storage URIs to input files. Each URI can be up
	// to 2000 characters long. URIs can match the full object path (for example,
	// `gs://bucket/directory/object.json`) or a pattern matching one or more
	// files, such as `gs://bucket/directory/*.json`. A request can contain at most
	// 100 files (or 100,000 files if `data_schema` is `content`). Each file can be
	// up to 2 GB (or 100 MB if `data_schema` is `content`).
	InputUris []string `json:"inputUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaGroundingFact: Grounding Fact.
type GoogleCloudDiscoveryengineV1betaGroundingFact struct {
	// Attributes: Attributes associated with the fact. Common attributes include
	// `source` (indicating where the fact was sourced from), `author` (indicating
	// the author of the fact), and so on.
	Attributes map[string]string `json:"attributes,omitempty"`
	// FactText: Text content of the fact. Can be at most 10K characters long.
	FactText string `json:"factText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaGroundingFact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaGroundingFact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsMetadata:
// Metadata related to the progress of the ImportCompletionSuggestions
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of CompletionSuggestions that failed to be imported.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of CompletionSuggestions successfully imported.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsRequest: Request
// message for CompletionService.ImportCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsRequest struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1betaBigQuerySource `json:"bigquerySource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1betaGcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for suggestion entries.
	InlineSource *GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsRequestInlineSourc
// e: The inline source for CompletionSuggestions.
type GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsRequestInlineSource struct {
	// Suggestions: Required. A list of all denylist entries to import. Max of 1000
	// items.
	Suggestions []*GoogleCloudDiscoveryengineV1betaCompletionSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsResponse:
// Response of the CompletionService.ImportCompletionSuggestions method. If the
// long running operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsResponse struct {
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata: Metadata related to
// the progress of the ImportDocuments operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: Total count of entries that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsRequest: Request message for
// Import methods.
type GoogleCloudDiscoveryengineV1betaImportDocumentsRequest struct {
	// AlloyDbSource: AlloyDB input source.
	AlloyDbSource *GoogleCloudDiscoveryengineV1betaAlloyDbSource `json:"alloyDbSource,omitempty"`
	// AutoGenerateIds: Whether to automatically generate IDs for the documents if
	// absent. If set to `true`, Document.ids are automatically generated based on
	// the hash of the payload, where IDs may not be consistent during multiple
	// imports. In which case ReconciliationMode.FULL is highly recommended to
	// avoid duplicate contents. If unset or set to `false`, Document.ids have to
	// be specified using id_field, otherwise, documents without IDs fail to be
	// imported. Supported data sources: * GcsSource. GcsSource.data_schema must be
	// `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. *
	// BigQuerySource. BigQuerySource.data_schema must be `custom` or `csv`.
	// Otherwise, an INVALID_ARGUMENT error is thrown. * SpannerSource. *
	// CloudSqlSource. * FirestoreSource. * BigtableSource.
	AutoGenerateIds bool `json:"autoGenerateIds,omitempty"`
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1betaBigQuerySource `json:"bigquerySource,omitempty"`
	// BigtableSource: Cloud Bigtable input source.
	BigtableSource *GoogleCloudDiscoveryengineV1betaBigtableSource `json:"bigtableSource,omitempty"`
	// CloudSqlSource: Cloud SQL input source.
	CloudSqlSource *GoogleCloudDiscoveryengineV1betaCloudSqlSource `json:"cloudSqlSource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// FhirStoreSource: FhirStore input source.
	FhirStoreSource *GoogleCloudDiscoveryengineV1betaFhirStoreSource `json:"fhirStoreSource,omitempty"`
	// FirestoreSource: Firestore input source.
	FirestoreSource *GoogleCloudDiscoveryengineV1betaFirestoreSource `json:"firestoreSource,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1betaGcsSource `json:"gcsSource,omitempty"`
	// IdField: The field indicates the ID field or column to be used as unique IDs
	// of the documents. For GcsSource it is the key of the JSON field. For
	// instance, `my_id` for JSON `{"my_id": "some_uuid"}`. For others, it may be
	// the column name of the table where the unique ids are stored. The values of
	// the JSON field or the table column are used as the Document.ids. The JSON
	// field or the table column must be of string type, and the values must be set
	// as valid strings conform to RFC-1034 (https://tools.ietf.org/html/rfc1034)
	// with 1-63 characters. Otherwise, documents without valid IDs fail to be
	// imported. Only set this field when auto_generate_ids is unset or set as
	// `false`. Otherwise, an INVALID_ARGUMENT error is thrown. If it is unset, a
	// default value `_id` is used when importing from the allowed data sources.
	// Supported data sources: * GcsSource. GcsSource.data_schema must be `custom`
	// or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. * BigQuerySource.
	// BigQuerySource.data_schema must be `custom` or `csv`. Otherwise, an
	// INVALID_ARGUMENT error is thrown. * SpannerSource. * CloudSqlSource. *
	// FirestoreSource. * BigtableSource.
	IdField string `json:"idField,omitempty"`
	// InlineSource: The Inline source for the input content for documents.
	InlineSource *GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource `json:"inlineSource,omitempty"`
	// ReconciliationMode: The mode of reconciliation between existing documents
	// and the documents to be imported. Defaults to
	// ReconciliationMode.INCREMENTAL.
	//
	// Possible values:
	//   "RECONCILIATION_MODE_UNSPECIFIED" - Defaults to `INCREMENTAL`.
	//   "INCREMENTAL" - Inserts new documents or updates existing documents.
	//   "FULL" - Calculates diff and replaces the entire document dataset.
	// Existing documents may be deleted if they are not present in the source
	// location.
	ReconciliationMode string `json:"reconciliationMode,omitempty"`
	// SpannerSource: Spanner input source.
	SpannerSource *GoogleCloudDiscoveryengineV1betaSpannerSource `json:"spannerSource,omitempty"`
	// UpdateMask: Indicates which fields in the provided imported documents to
	// update. If not set, the default is to update all fields.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlloyDbSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlloyDbSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource: The
// inline source for the input config for ImportDocuments method.
type GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource struct {
	// Documents: Required. A list of documents to update/create. Each document
	// must have a valid Document.id. Recommended max of 100 items.
	Documents []*GoogleCloudDiscoveryengineV1betaDocument `json:"documents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsResponse: Response of the
// ImportDocumentsRequest. If the long running operation is done, then this
// message is returned by the google.longrunning.Operations.response field if
// the operation was successful.
type GoogleCloudDiscoveryengineV1betaImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the request
	// if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1betaImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors are written to sharded files
	// in this directory, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportErrorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSampleQueriesMetadata: Metadata
// related to the progress of the ImportSampleQueries operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportSampleQueriesMetadata struct {
	// CreateTime: ImportSampleQueries operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of SampleQuerys that failed to be imported.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of SampleQuerys successfully imported.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// TotalCount: Total count of SampleQuerys that were processed.
	TotalCount int64 `json:"totalCount,omitempty,string"`
	// UpdateTime: ImportSampleQueries operation last update time. If the operation
	// is done, this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSampleQueriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSampleQueriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSampleQueriesRequest: Request message
// for SampleQueryService.ImportSampleQueries method.
type GoogleCloudDiscoveryengineV1betaImportSampleQueriesRequest struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1betaBigQuerySource `json:"bigquerySource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1betaGcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for sample query entries.
	InlineSource *GoogleCloudDiscoveryengineV1betaImportSampleQueriesRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSampleQueriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSampleQueriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSampleQueriesRequestInlineSource: The
// inline source for SampleQuerys.
type GoogleCloudDiscoveryengineV1betaImportSampleQueriesRequestInlineSource struct {
	// SampleQueries: Required. A list of SampleQuerys to import. Max of 1000
	// items.
	SampleQueries []*GoogleCloudDiscoveryengineV1betaSampleQuery `json:"sampleQueries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SampleQueries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SampleQueries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSampleQueriesRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSampleQueriesRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSampleQueriesResponse: Response of the
// SampleQueryService.ImportSampleQueries method. If the long running operation
// is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type GoogleCloudDiscoveryengineV1betaImportSampleQueriesResponse struct {
	// ErrorConfig: The desired location of errors incurred during the Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSampleQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSampleQueriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the ImportSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRequest:
// Request message for CompletionService.ImportSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRequest struct {
	// GcsSource: Cloud Storage location for the input content. Only 1 file can be
	// specified that contains all entries to import. Supported values
	// `gcs_source.schema` for autocomplete suggestion deny list entry imports: *
	// `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry] per
	// line.
	GcsSource *GoogleCloudDiscoveryengineV1betaGcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for the input content for suggestion deny
	// list entries.
	InlineSource *GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRequestInlineS
// ource: The inline source for SuggestionDenyListEntry.
type GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRequestInlineSource struct {
	// Entries: Required. A list of all denylist entries to import. Max of 1000
	// items.
	Entries []*GoogleCloudDiscoveryengineV1betaSuggestionDenyListEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse:
// Response message for CompletionService.ImportSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// FailedEntriesCount: Count of deny list entries that failed to be imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`
	// ImportedEntriesCount: Count of deny list entries successfully imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata: Metadata related
// to the progress of the Import operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsRequest: Request message for
// the ImportUserEvents request.
type GoogleCloudDiscoveryengineV1betaImportUserEventsRequest struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1betaBigQuerySource `json:"bigquerySource,omitempty"`
	// ErrorConfig: The desired location of errors incurred during the Import.
	// Cannot be set for inline user event imports.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1betaGcsSource `json:"gcsSource,omitempty"`
	// InlineSource: The Inline source for the input content for UserEvents.
	InlineSource *GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource: The
// inline source for the input config for ImportUserEvents method.
type GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource struct {
	// UserEvents: Required. A list of user events to import. Recommended max of
	// 10k items.
	UserEvents []*GoogleCloudDiscoveryengineV1betaUserEvent `json:"userEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserEvents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserEvents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was successful, then
// this message is returned by the google.longrunning.Operations.response field
// if the operation was successful.
type GoogleCloudDiscoveryengineV1betaImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this field
	// was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// JoinedEventsCount: Count of user events imported with complete existing
	// Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`
	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaInterval: A floating point interval.
type GoogleCloudDiscoveryengineV1betaInterval struct {
	// ExclusiveMaximum: Exclusive upper bound.
	ExclusiveMaximum float64 `json:"exclusiveMaximum,omitempty"`
	// ExclusiveMinimum: Exclusive lower bound.
	ExclusiveMinimum float64 `json:"exclusiveMinimum,omitempty"`
	// Maximum: Inclusive upper bound.
	Maximum float64 `json:"maximum,omitempty"`
	// Minimum: Inclusive lower bound.
	Minimum float64 `json:"minimum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExclusiveMaximum") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExclusiveMaximum") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaInterval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaInterval
	var s1 struct {
		ExclusiveMaximum gensupport.JSONFloat64 `json:"exclusiveMaximum"`
		ExclusiveMinimum gensupport.JSONFloat64 `json:"exclusiveMinimum"`
		Maximum          gensupport.JSONFloat64 `json:"maximum"`
		Minimum          gensupport.JSONFloat64 `json:"minimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExclusiveMaximum = float64(s1.ExclusiveMaximum)
	s.ExclusiveMinimum = float64(s1.ExclusiveMinimum)
	s.Maximum = float64(s1.Maximum)
	s.Minimum = float64(s1.Minimum)
	return nil
}

// GoogleCloudDiscoveryengineV1betaLanguageInfo: Language info for DataStore.
type GoogleCloudDiscoveryengineV1betaLanguageInfo struct {
	// Language: Output only. Language part of normalized_language_code. E.g.:
	// `en-US` -> `en`, `zh-Hans-HK` -> `zh`, `en` -> `en`.
	Language string `json:"language,omitempty"`
	// LanguageCode: The language code for the DataStore.
	LanguageCode string `json:"languageCode,omitempty"`
	// NormalizedLanguageCode: Output only. This is the normalized form of
	// language_code. E.g.: language_code of `en-GB`, `en_GB`, `en-UK` or `en-gb`
	// will have normalized_language_code of `en-GB`.
	NormalizedLanguageCode string `json:"normalizedLanguageCode,omitempty"`
	// Region: Output only. Region part of normalized_language_code, if present.
	// E.g.: `en-US` -> `US`, `zh-Hans-HK` -> `HK`, `en` -> ``.
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Language") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Language") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaLanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaLanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListControlsResponse: Response for
// ListControls method.
type GoogleCloudDiscoveryengineV1betaListControlsResponse struct {
	// Controls: All the Controls for a given data store.
	Controls []*GoogleCloudDiscoveryengineV1betaControl `json:"controls,omitempty"`
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Controls") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Controls") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListControlsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListControlsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListConversationsResponse: Response for
// ListConversations method.
type GoogleCloudDiscoveryengineV1betaListConversationsResponse struct {
	// Conversations: All the Conversations for a given data store.
	Conversations []*GoogleCloudDiscoveryengineV1betaConversation `json:"conversations,omitempty"`
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListCustomModelsResponse: Response message
// for SearchTuningService.ListCustomModels method.
type GoogleCloudDiscoveryengineV1betaListCustomModelsResponse struct {
	// Models: List of custom tuning models.
	Models []*GoogleCloudDiscoveryengineV1betaCustomTuningModel `json:"models,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListCustomModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListCustomModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListDataStoresResponse: Response message for
// DataStoreService.ListDataStores method.
type GoogleCloudDiscoveryengineV1betaListDataStoresResponse struct {
	// DataStores: All the customer's DataStores.
	DataStores []*GoogleCloudDiscoveryengineV1betaDataStore `json:"dataStores,omitempty"`
	// NextPageToken: A token that can be sent as ListDataStoresRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListDataStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListDataStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListDocumentsResponse: Response message for
// DocumentService.ListDocuments method.
type GoogleCloudDiscoveryengineV1betaListDocumentsResponse struct {
	// Documents: The Documents.
	Documents []*GoogleCloudDiscoveryengineV1betaDocument `json:"documents,omitempty"`
	// NextPageToken: A token that can be sent as ListDocumentsRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListEnginesResponse: Response message for
// EngineService.ListEngines method.
type GoogleCloudDiscoveryengineV1betaListEnginesResponse struct {
	// Engines: All the customer's Engines.
	Engines []*GoogleCloudDiscoveryengineV1betaEngine `json:"engines,omitempty"`
	// NextPageToken: Not supported.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Engines") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListEnginesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListEnginesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListEvaluationResultsResponse: Response
// message for EvaluationService.ListEvaluationResults method.
type GoogleCloudDiscoveryengineV1betaListEvaluationResultsResponse struct {
	// EvaluationResults: The EvaluationResults.
	EvaluationResults []*GoogleCloudDiscoveryengineV1betaListEvaluationResultsResponseEvaluationResult `json:"evaluationResults,omitempty"`
	// NextPageToken: A token that can be sent as
	// ListEvaluationResultsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EvaluationResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListEvaluationResultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListEvaluationResultsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListEvaluationResultsResponseEvaluationResult
// : Represents the results of an evaluation for a single SampleQuery.
type GoogleCloudDiscoveryengineV1betaListEvaluationResultsResponseEvaluationResult struct {
	// QualityMetrics: Output only. The metrics produced by the evaluation, for a
	// given SampleQuery.
	QualityMetrics *GoogleCloudDiscoveryengineV1betaQualityMetrics `json:"qualityMetrics,omitempty"`
	// SampleQuery: Output only. The SampleQuery that was evaluated.
	SampleQuery *GoogleCloudDiscoveryengineV1betaSampleQuery `json:"sampleQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QualityMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QualityMetrics") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListEvaluationResultsResponseEvaluationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListEvaluationResultsResponseEvaluationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListEvaluationsResponse: Response message
// for EvaluationService.ListEvaluations method.
type GoogleCloudDiscoveryengineV1betaListEvaluationsResponse struct {
	// Evaluations: The Evaluations.
	Evaluations []*GoogleCloudDiscoveryengineV1betaEvaluation `json:"evaluations,omitempty"`
	// NextPageToken: A token that can be sent as ListEvaluationsRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Evaluations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListEvaluationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListEvaluationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListSampleQueriesResponse: Response message
// for SampleQueryService.ListSampleQueries method.
type GoogleCloudDiscoveryengineV1betaListSampleQueriesResponse struct {
	// NextPageToken: A token that can be sent as
	// ListSampleQueriesRequest.page_token to retrieve the next page. If this field
	// is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SampleQueries: The SampleQuerys.
	SampleQueries []*GoogleCloudDiscoveryengineV1betaSampleQuery `json:"sampleQueries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListSampleQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListSampleQueriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListSampleQuerySetsResponse: Response
// message for SampleQuerySetService.ListSampleQuerySets method.
type GoogleCloudDiscoveryengineV1betaListSampleQuerySetsResponse struct {
	// NextPageToken: A token that can be sent as
	// ListSampleQuerySetsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SampleQuerySets: The SampleQuerySets.
	SampleQuerySets []*GoogleCloudDiscoveryengineV1betaSampleQuerySet `json:"sampleQuerySets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListSampleQuerySetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListSampleQuerySetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListSchemasResponse: Response message for
// SchemaService.ListSchemas method.
type GoogleCloudDiscoveryengineV1betaListSchemasResponse struct {
	// NextPageToken: A token that can be sent as ListSchemasRequest.page_token to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Schemas: The Schemas.
	Schemas []*GoogleCloudDiscoveryengineV1betaSchema `json:"schemas,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListSchemasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListSchemasResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListServingConfigsResponse: Response for
// ListServingConfigs method.
type GoogleCloudDiscoveryengineV1betaListServingConfigsResponse struct {
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ServingConfigs: All the ServingConfigs for a given dataStore.
	ServingConfigs []*GoogleCloudDiscoveryengineV1betaServingConfig `json:"servingConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListServingConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListServingConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListSessionsResponse: Response for
// ListSessions method.
type GoogleCloudDiscoveryengineV1betaListSessionsResponse struct {
	// NextPageToken: Pagination token, if not returned indicates the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Sessions: All the Sessions for a given data store.
	Sessions []*GoogleCloudDiscoveryengineV1betaSession `json:"sessions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListSessionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListSessionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListTargetSitesResponse: Response message
// for SiteSearchEngineService.ListTargetSites method.
type GoogleCloudDiscoveryengineV1betaListTargetSitesResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TargetSites: List of TargetSites.
	TargetSites []*GoogleCloudDiscoveryengineV1betaTargetSite `json:"targetSites,omitempty"`
	// TotalSize: The total number of items matching the request. This will always
	// be populated in the response.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaListTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListTargetSitesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaMediaInfo: Media-specific user event
// information.
type GoogleCloudDiscoveryengineV1betaMediaInfo struct {
	// MediaProgressDuration: The media progress time in seconds, if applicable.
	// For example, if the end user has finished 90 seconds of a playback video,
	// then MediaInfo.media_progress_duration.seconds should be set to 90.
	MediaProgressDuration string `json:"mediaProgressDuration,omitempty"`
	// MediaProgressPercentage: Media progress should be computed using only the
	// media_progress_duration relative to the media total length. This value must
	// be between `[0, 1.0]` inclusive. If this is not a playback or the progress
	// cannot be computed (e.g. ongoing livestream), this field should be unset.
	MediaProgressPercentage float64 `json:"mediaProgressPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaProgressDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaProgressDuration") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaMediaInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaMediaInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaMediaInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaMediaInfo
	var s1 struct {
		MediaProgressPercentage gensupport.JSONFloat64 `json:"mediaProgressPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MediaProgressPercentage = float64(s1.MediaProgressPercentage)
	return nil
}

// GoogleCloudDiscoveryengineV1betaNaturalLanguageQueryUnderstandingConfig:
// Configuration for Natural Language Query Understanding.
type GoogleCloudDiscoveryengineV1betaNaturalLanguageQueryUnderstandingConfig struct {
	// Mode: Mode of Natural Language Query Understanding. If this field is unset,
	// the behavior defaults to
	// NaturalLanguageQueryUnderstandingConfig.Mode.DISABLED.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value.
	//   "DISABLED" - Natural Language Query Understanding is disabled.
	//   "ENABLED" - Natural Language Query Understanding is enabled.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaNaturalLanguageQueryUnderstandingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaNaturalLanguageQueryUnderstandingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPageInfo: Detailed page information.
type GoogleCloudDiscoveryengineV1betaPageInfo struct {
	// PageCategory: The most specific category associated with a category page. To
	// represent full path of category, use '>' sign to separate different
	// hierarchies. If '>' is part of the category name, replace it with other
	// character(s). Category pages include special pages such as sales or
	// promotions. For instance, a special sale page may have the category
	// hierarchy: "pageCategory" : "Sales > 2017 Black Friday Deals". Required
	// for `view-category-page` events. Other event types should not set this
	// field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	PageCategory string `json:"pageCategory,omitempty"`
	// PageviewId: A unique ID of a web page view. This should be kept the same for
	// all user events triggered from the same pageview. For example, an item
	// detail page view could trigger multiple events as the user is browsing the
	// page. The `pageview_id` property should be kept the same for all these
	// events so that they can be grouped together properly. When using the client
	// side event reporting with JavaScript pixel and Google Tag Manager, this
	// value is filled in automatically.
	PageviewId string `json:"pageviewId,omitempty"`
	// ReferrerUri: The referrer URL of the current page. When using the client
	// side event reporting with JavaScript pixel and Google Tag Manager, this
	// value is filled in automatically. However, some browser privacy restrictions
	// may cause this field to be empty.
	ReferrerUri string `json:"referrerUri,omitempty"`
	// Uri: Complete URL (window.location.href) of the user's current page. When
	// using the client side event reporting with JavaScript pixel and Google Tag
	// Manager, this value is filled in automatically. Maximum length 5,000
	// characters.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageCategory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageCategory") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPanelInfo: Detailed panel information
// associated with a user event.
type GoogleCloudDiscoveryengineV1betaPanelInfo struct {
	// DisplayName: The display name of the panel.
	DisplayName string `json:"displayName,omitempty"`
	// Documents: Optional. The document IDs associated with this panel.
	Documents []*GoogleCloudDiscoveryengineV1betaDocumentInfo `json:"documents,omitempty"`
	// PanelId: Required. The panel ID.
	PanelId string `json:"panelId,omitempty"`
	// PanelPosition: The ordered position of the panel, if shown to the user with
	// other panels. If set, then total_panels must also be set.
	PanelPosition int64 `json:"panelPosition,omitempty"`
	// TotalPanels: The total number of panels, including this one, shown to the
	// user. Must be set if panel_position is set.
	TotalPanels int64 `json:"totalPanels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPanelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPanelInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPauseEngineRequest: Request for pausing
// training of an engine.
type GoogleCloudDiscoveryengineV1betaPauseEngineRequest struct {
}

// GoogleCloudDiscoveryengineV1betaProject: Metadata and configurations for a
// Google Cloud project in the service.
type GoogleCloudDiscoveryengineV1betaProject struct {
	// CreateTime: Output only. The timestamp when this project is created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. Full resource name of the project, for example
	// `projects/{project}`. Note that when making requests, project number and
	// project id are both acceptable, but the server will always respond in
	// project number.
	Name string `json:"name,omitempty"`
	// ProvisionCompletionTime: Output only. The timestamp when this project is
	// successfully provisioned. Empty value means this project is still
	// provisioning and is not ready for use.
	ProvisionCompletionTime string `json:"provisionCompletionTime,omitempty"`
	// ServiceTermsMap: Output only. A map of terms of services. The key is the
	// `id` of ServiceTerms.
	ServiceTermsMap map[string]GoogleCloudDiscoveryengineV1betaProjectServiceTerms `json:"serviceTermsMap,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaProject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaProject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaProjectServiceTerms: Metadata about the
// terms of service.
type GoogleCloudDiscoveryengineV1betaProjectServiceTerms struct {
	// AcceptTime: The last time when the project agreed to the terms of service.
	AcceptTime string `json:"acceptTime,omitempty"`
	// DeclineTime: The last time when the project declined or revoked the
	// agreement to terms of service.
	DeclineTime string `json:"declineTime,omitempty"`
	// Id: The unique identifier of this terms of service. Available terms: *
	// `GA_DATA_USE_TERMS`: Terms for data use
	// (https://cloud.google.com/retail/data-use-terms). When using this as `id`,
	// the acceptable version to provide is `2022-11-23`.
	Id string `json:"id,omitempty"`
	// State: Whether the project has accepted/rejected the service terms or it is
	// still pending.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value of the enum. This value is not
	// actually used.
	//   "TERMS_ACCEPTED" - The project has given consent to the terms of service.
	//   "TERMS_PENDING" - The project is pending to review and accept the terms of
	// service.
	//   "TERMS_DECLINED" - The project has declined or revoked the agreement to
	// terms of service.
	State string `json:"state,omitempty"`
	// Version: The version string of the terms of service. For acceptable values,
	// see the comments for id above.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaProjectServiceTerms) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaProjectServiceTerms
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaProvisionProjectMetadata: Metadata
// associated with a project provision operation.
type GoogleCloudDiscoveryengineV1betaProvisionProjectMetadata struct {
}

// GoogleCloudDiscoveryengineV1betaProvisionProjectRequest: Request for
// ProjectService.ProvisionProject method.
type GoogleCloudDiscoveryengineV1betaProvisionProjectRequest struct {
	// AcceptDataUseTerms: Required. Set to `true` to specify that caller has read
	// and would like to give consent to the Terms for data use
	// (https://cloud.google.com/retail/data-use-terms).
	AcceptDataUseTerms bool `json:"acceptDataUseTerms,omitempty"`
	// DataUseTermsVersion: Required. The version of the Terms for data use
	// (https://cloud.google.com/retail/data-use-terms) that caller has read and
	// would like to give consent to. Acceptable version is `2022-11-23`, and this
	// may change over time.
	DataUseTermsVersion string `json:"dataUseTermsVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptDataUseTerms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptDataUseTerms") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaProvisionProjectRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaProvisionProjectRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeCompletionSuggestionsRequest: Request
// message for CompletionService.PurgeCompletionSuggestions method.
type GoogleCloudDiscoveryengineV1betaPurgeCompletionSuggestionsRequest struct {
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata: Metadata related to
// the progress of the PurgeDocuments operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// FailureCount: Count of entries that encountered errors while processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`
	// IgnoredCount: Count of entries that were ignored as entries were not found.
	IgnoredCount int64 `json:"ignoredCount,omitempty,string"`
	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest: Request message for
// DocumentService.PurgeDocuments method.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest struct {
	// ErrorConfig: The desired location of errors incurred during the purge.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaPurgeErrorConfig `json:"errorConfig,omitempty"`
	// Filter: Required. Filter matching documents to purge. Only currently
	// supported value is `*` (all items).
	Filter string `json:"filter,omitempty"`
	// Force: Actually performs the purge. If `force` is set to false, return the
	// expected purge count without deleting any documents.
	Force bool `json:"force,omitempty"`
	// GcsSource: Cloud Storage location for the input content. Supported
	// `data_schema`: * `document_id`: One valid Document.id per line.
	GcsSource *GoogleCloudDiscoveryengineV1betaGcsSource `json:"gcsSource,omitempty"`
	// InlineSource: Inline source for the input content for purge.
	InlineSource *GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequestInlineSource `json:"inlineSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequestInlineSource: The
// inline source for the input config for DocumentService.PurgeDocuments
// method.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequestInlineSource struct {
	// Documents: Required. A list of full resource name of documents to purge. In
	// the format
	// `projects/*/locations/*/collections/*/dataStores/*/branches/*/documents/*`.
	// Recommended max of 100 items.
	Documents []string `json:"documents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequestInlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse: Response message for
// DocumentService.PurgeDocuments method. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// PurgeSample: A sample of document names that will be deleted. Only populated
	// if `force` is set to false. A max of 100 names will be returned and the
	// names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PurgeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeErrorConfig: Configuration of
// destination for Purge related errors.
type GoogleCloudDiscoveryengineV1betaPurgeErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for purge errors. This must be an empty,
	// existing Cloud Storage directory. Purge errors are written to sharded files
	// in this directory, one per line, as a JSON-encoded `google.rpc.Status`
	// message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeErrorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the PurgeSuggestionDenyListEntries
// operation. This is returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`
	// UpdateTime: Operation last update time. If the operation is done, this is
	// also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesRequest:
// Request message for CompletionService.PurgeSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesRequest struct {
}

// GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse:
// Response message for CompletionService.PurgeSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`
	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorSamples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeUserEventsRequest: Request message for
// PurgeUserEvents method.
type GoogleCloudDiscoveryengineV1betaPurgeUserEventsRequest struct {
	// Filter: Required. The filter string to specify the events to be deleted with
	// a length limit of 5,000 characters. The eligible fields for filtering are: *
	// `eventType`: Double quoted UserEvent.event_type string. * `eventTime`: in
	// ISO 8601 "zulu" format. * `userPseudoId`: Double quoted string. Specifying
	// this will delete all events associated with a visitor. * `userId`: Double
	// quoted string. Specifying this will delete all events associated with a
	// user. Note: This API only supports purging a max range of 30 days. Examples:
	// * Deleting all events in a time range: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" *
	// Deleting specific eventType in a time range: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" eventType
	// = "search" * Deleting all events for a specific visitor in a time range:
	// `eventTime > "2012-04-23T18:25:43.511Z" eventTime <
	// "2012-04-23T18:30:43.511Z" userPseudoId = "visitor1024" * Deleting the past
	// 30 days of events inside a DataStore: `*` The filtering fields are assumed
	// to have an implicit AND.
	Filter string `json:"filter,omitempty"`
	// Force: The `force` field is currently not supported. Purge user event
	// requests will permanently delete all purgeable events. Once the development
	// is complete: If `force` is set to false, the method will return the expected
	// purge count without deleting any user events. This field will default to
	// false if not included in the request.
	Force bool `json:"force,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaPurgeUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeUserEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaQualityMetrics: Describes the metrics
// produced by the evaluation.
type GoogleCloudDiscoveryengineV1betaQualityMetrics struct {
	// DocNdcg: Normalized discounted cumulative gain (NDCG) per document, at
	// various top-k cutoff levels. NDCG measures the ranking quality, giving
	// higher relevance to top results. Example (top-3): Suppose SampleQuery with
	// three retrieved documents (D1, D2, D3) and binary relevance judgements (1
	// for relevant, 0 for not relevant): Retrieved: [D3 (0), D1 (1), D2 (1)]
	// Ideal: [D1 (1), D2 (1), D3 (0)] Calculate NDCG@3 for each SampleQuery: *
	// DCG@3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13 * Ideal DCG@3:
	// 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63 * NDCG@3: 1.13/1.63 = 0.693
	DocNdcg *GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics `json:"docNdcg,omitempty"`
	// DocPrecision: Precision per document, at various top-k cutoff levels.
	// Precision is the fraction of retrieved documents that are relevant. Example
	// (top-5): * For a single SampleQuery, If 4 out of 5 retrieved documents in
	// the top-5 are relevant, precision@5 = 4/5 = 0.8
	DocPrecision *GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics `json:"docPrecision,omitempty"`
	// DocRecall: Recall per document, at various top-k cutoff levels. Recall is
	// the fraction of relevant documents retrieved out of all relevant documents.
	// Example (top-5): * For a single SampleQuery, If 3 out of 5 relevant
	// documents are retrieved in the top-5, recall@5 = 3/5 = 0.6
	DocRecall *GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics `json:"docRecall,omitempty"`
	// PageNdcg: Normalized discounted cumulative gain (NDCG) per page, at various
	// top-k cutoff levels. NDCG measures the ranking quality, giving higher
	// relevance to top results. Example (top-3): Suppose SampleQuery with three
	// retrieved pages (P1, P2, P3) and binary relevance judgements (1 for
	// relevant, 0 for not relevant): Retrieved: [P3 (0), P1 (1), P2 (1)] Ideal:
	// [P1 (1), P2 (1), P3 (0)] Calculate NDCG@3 for SampleQuery: * DCG@3:
	// 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13 * Ideal DCG@3: 1/log2(1+1) +
	// 1/log2(2+1) + 0/log2(3+1) = 1.63 * NDCG@3: 1.13/1.63 = 0.693
	PageNdcg *GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics `json:"pageNdcg,omitempty"`
	// PageRecall: Recall per page, at various top-k cutoff levels. Recall is the
	// fraction of relevant pages retrieved out of all relevant pages. Example
	// (top-5): * For a single SampleQuery, if 3 out of 5 relevant pages are
	// retrieved in the top-5, recall@5 = 3/5 = 0.6
	PageRecall *GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics `json:"pageRecall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocNdcg") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocNdcg") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaQualityMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaQualityMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics: Stores the metric
// values at specific top-k levels.
type GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics struct {
	// Top1: The top-1 value.
	Top1 float64 `json:"top1,omitempty"`
	// Top10: The top-10 value.
	Top10 float64 `json:"top10,omitempty"`
	// Top3: The top-3 value.
	Top3 float64 `json:"top3,omitempty"`
	// Top5: The top-5 value.
	Top5 float64 `json:"top5,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Top1") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Top1") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics
	var s1 struct {
		Top1  gensupport.JSONFloat64 `json:"top1"`
		Top10 gensupport.JSONFloat64 `json:"top10"`
		Top3  gensupport.JSONFloat64 `json:"top3"`
		Top5  gensupport.JSONFloat64 `json:"top5"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Top1 = float64(s1.Top1)
	s.Top10 = float64(s1.Top10)
	s.Top3 = float64(s1.Top3)
	s.Top5 = float64(s1.Top5)
	return nil
}

// GoogleCloudDiscoveryengineV1betaQuery: Defines a user inputed query.
type GoogleCloudDiscoveryengineV1betaQuery struct {
	// QueryId: Unique Id for the query.
	QueryId string `json:"queryId,omitempty"`
	// Text: Plain text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaRankRequest: Request message for
// RankService.Rank method.
type GoogleCloudDiscoveryengineV1betaRankRequest struct {
	// IgnoreRecordDetailsInResponse: If true, the response will contain only
	// record ID and score. By default, it is false, the response will contain
	// record details.
	IgnoreRecordDetailsInResponse bool `json:"ignoreRecordDetailsInResponse,omitempty"`
	// Model: The identifier of the model to use. It is one of: *
	// `semantic-ranker-512@latest`: Semantic ranking model with maxiumn input
	// token size 512. It is set to `semantic-ranker-512@latest` by default if
	// unspecified.
	Model string `json:"model,omitempty"`
	// Query: The query to use.
	Query string `json:"query,omitempty"`
	// Records: Required. A list of records to rank. At most 200 records to rank.
	Records []*GoogleCloudDiscoveryengineV1betaRankingRecord `json:"records,omitempty"`
	// TopN: The number of results to return. If this is unset or no bigger than
	// zero, returns all results.
	TopN int64 `json:"topN,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "IgnoreRecordDetailsInResponse") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreRecordDetailsInResponse")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaRankRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRankRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaRankResponse: Response message for
// RankService.Rank method.
type GoogleCloudDiscoveryengineV1betaRankResponse struct {
	// Records: A list of records sorted by descending score.
	Records []*GoogleCloudDiscoveryengineV1betaRankingRecord `json:"records,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Records") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Records") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaRankResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRankResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaRankingRecord: Record message for
// RankService.Rank method.
type GoogleCloudDiscoveryengineV1betaRankingRecord struct {
	// Content: The content of the record. Empty by default. At least one of title
	// or content should be set otherwise an INVALID_ARGUMENT error is thrown.
	Content string `json:"content,omitempty"`
	// Id: The unique ID to represent the record.
	Id string `json:"id,omitempty"`
	// Score: The score of this record based on the given query and selected model.
	// The score will be rounded to 2 decimal places. If the score is close to 0,
	// it will be rounded to 0.0001 to avoid returning unset.
	Score float64 `json:"score,omitempty"`
	// Title: The title of the record. Empty by default. At least one of title or
	// content should be set otherwise an INVALID_ARGUMENT error is thrown.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaRankingRecord) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRankingRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaRankingRecord) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaRankingRecord
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDiscoveryengineV1betaRecommendRequest: Request message for
// Recommend method.
type GoogleCloudDiscoveryengineV1betaRecommendRequest struct {
	// Filter: Filter for restricting recommendation results with a length limit of
	// 5,000 characters. Currently, only filter expressions on the `filter_tags`
	// attribute is supported. Examples: * `(filter_tags: ANY("Red", "Blue") OR
	// filter_tags: ANY("Hot", "Cold"))` * `(filter_tags: ANY("Red", "Blue")) AND
	// NOT (filter_tags: ANY("Green"))` If `attributeFilteringSyntax` is set to
	// true under the `params` field, then attribute-based expressions are expected
	// instead of the above described tag-based syntax. Examples: * (language:
	// ANY("en", "es")) AND NOT (categories: ANY("Movie")) * (available: true) AND
	// (language: ANY("en", "es")) OR (categories: ANY("Movie")) If your filter
	// blocks all results, the API returns generic (unfiltered) popular Documents.
	// If you only want results strictly matching the filters, set
	// `strictFiltering` to `true` in RecommendRequest.params to receive empty
	// results instead. Note that the API never returns Documents with
	// `storageStatus` as `EXPIRED` or `DELETED` regardless of filter choices.
	Filter string `json:"filter,omitempty"`
	// PageSize: Maximum number of results to return. Set this property to the
	// number of recommendation results needed. If zero, the service chooses a
	// reasonable default. The maximum allowed value is 100. Values above 100 are
	// set to 100.
	PageSize int64 `json:"pageSize,omitempty"`
	// Params: Additional domain specific parameters for the recommendations.
	// Allowed values: * `returnDocument`: Boolean. If set to `true`, the
	// associated Document object is returned in
	// RecommendResponse.RecommendationResult.document. * `returnScore`: Boolean.
	// If set to true, the recommendation score corresponding to each returned
	// Document is set in RecommendResponse.RecommendationResult.metadata. The
	// given score indicates the probability of a Document conversion given the
	// user's context and history. * `strictFiltering`: Boolean. True by default.
	// If set to `false`, the service returns generic (unfiltered) popular
	// Documents instead of empty if your filter blocks all recommendation results.
	// * `diversityLevel`: String. Default empty. If set to be non-empty, then it
	// needs to be one of: * `no-diversity` * `low-diversity` * `medium-diversity`
	// * `high-diversity` * `auto-diversity` This gives request-level control and
	// adjusts recommendation results based on Document category. *
	// `attributeFilteringSyntax`: Boolean. False by default. If set to true, the
	// `filter` field is interpreted according to the new, attribute-based syntax.
	Params googleapi.RawMessage `json:"params,omitempty"`
	// UserEvent: Required. Context about the user, what they are looking at and
	// what action they took to trigger the Recommend request. Note that this user
	// event detail won't be ingested to userEvent logs. Thus, a separate userEvent
	// write request is required for event logging. Don't set
	// UserEvent.user_pseudo_id or UserEvent.user_info.user_id to the same fixed ID
	// for different users. If you are trying to receive non-personalized
	// recommendations (not recommended; this can negatively impact model
	// performance), instead set UserEvent.user_pseudo_id to a random unique ID and
	// leave UserEvent.user_info.user_id unset.
	UserEvent *GoogleCloudDiscoveryengineV1betaUserEvent `json:"userEvent,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Requirements for labels
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ValidateOnly: Use validate only mode for this recommendation query. If set
	// to `true`, a fake model is used that returns arbitrary Document IDs. Note
	// that the validate only mode should only be used for testing the API, or if
	// the model is not ready.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaRecommendRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRecommendRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaRecommendResponse: Response message for
// Recommend method.
type GoogleCloudDiscoveryengineV1betaRecommendResponse struct {
	// AttributionToken: A unique attribution token. This should be included in the
	// UserEvent logs resulting from this recommendation, which enables accurate
	// attribution of recommendation model performance.
	AttributionToken string `json:"attributionToken,omitempty"`
	// MissingIds: IDs of documents in the request that were missing from the
	// default Branch associated with the requested ServingConfig.
	MissingIds []string `json:"missingIds,omitempty"`
	// Results: A list of recommended Documents. The order represents the ranking
	// (from the most relevant Document to the least).
	Results []*GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult `json:"results,omitempty"`
	// ValidateOnly: True if RecommendRequest.validate_only was set.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaRecommendResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRecommendResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult:
// RecommendationResult represents a generic recommendation result with
// associated metadata.
type GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult struct {
	// Document: Set if `returnDocument` is set to true in RecommendRequest.params.
	Document *GoogleCloudDiscoveryengineV1betaDocument `json:"document,omitempty"`
	// Id: Resource ID of the recommended Document.
	Id string `json:"id,omitempty"`
	// Metadata: Additional Document metadata or annotations. Possible values: *
	// `score`: Recommendation score in double value. Is set if `returnScore` is
	// set to true in RecommendRequest.params.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaRecrawlUrisRequest: Request message for
// SiteSearchEngineService.RecrawlUris method.
type GoogleCloudDiscoveryengineV1betaRecrawlUrisRequest struct {
	// SiteCredential: Optional. Full resource name of the SiteCredential, such as
	// `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/siteCrede
	// ntials/*`. Only set to crawl private URIs.
	SiteCredential string `json:"siteCredential,omitempty"`
	// Uris: Required. List of URIs to crawl. At most 10K URIs are supported,
	// otherwise an INVALID_ARGUMENT error is thrown. Each URI should match at
	// least one TargetSite in `site_search_engine`.
	Uris []string `json:"uris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SiteCredential") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SiteCredential") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaRecrawlUrisRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRecrawlUrisRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaReply: Defines a reply message to user.
type GoogleCloudDiscoveryengineV1betaReply struct {
	// References: References in the reply.
	References []*GoogleCloudDiscoveryengineV1betaReplyReference `json:"references,omitempty"`
	// Reply: DEPRECATED: use `summary` instead. Text reply.
	Reply string `json:"reply,omitempty"`
	// Summary: Summary based on search results.
	Summary *GoogleCloudDiscoveryengineV1betaSearchResponseSummary `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "References") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "References") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaReply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaReplyReference: Defines reference in reply.
type GoogleCloudDiscoveryengineV1betaReplyReference struct {
	// AnchorText: Anchor text.
	AnchorText string `json:"anchorText,omitempty"`
	// End: Anchor text end index.
	End int64 `json:"end,omitempty"`
	// Start: Anchor text start index.
	Start int64 `json:"start,omitempty"`
	// Uri: URI link reference.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnchorText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnchorText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaReplyReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaReplyReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaResumeEngineRequest: Request for resuming
// training of an engine.
type GoogleCloudDiscoveryengineV1betaResumeEngineRequest struct {
}

// GoogleCloudDiscoveryengineV1betaSampleQuery: Sample Query captures metadata
// to be used for evaluation.
type GoogleCloudDiscoveryengineV1betaSampleQuery struct {
	// CreateTime: Output only. Timestamp the SampleQuery was created at.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The full resource name of the sample query, in the format
	// of
	// `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/s
	// ampleQueries/{sample_query}`. This field must be a UTF-8 encoded string with
	// a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// QueryEntry: The query entry.
	QueryEntry *GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntry `json:"queryEntry,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSampleQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSampleQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntry: Query Entry captures
// metadata to be used for search evaluation.
type GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntry struct {
	// Query: Required. The query.
	Query string `json:"query,omitempty"`
	// Targets: List of targets for the query.
	Targets []*GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntryTarget `json:"targets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntryTarget: Defines the
// parameters of the query's expected outcome.
type GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntryTarget struct {
	// PageNumbers: Expected page numbers of the target. Each page number must be
	// non negative.
	PageNumbers []int64 `json:"pageNumbers,omitempty"`
	// Score: Relevance score of the target.
	Score float64 `json:"score,omitempty"`
	// Uri: Expected uri of the target. This field must be a UTF-8 encoded string
	// with a length limit of 2048 characters. Example of valid uris:
	// `https://example.com/abc`, `gcs://example/example.pdf`.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageNumbers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageNumbers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntryTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntryTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntryTarget) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaSampleQueryQueryEntryTarget
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDiscoveryengineV1betaSampleQuerySet: A SampleQuerySet is the
// parent resource of SampleQuery, and contains the configurations shared by
// all SampleQuery under it.
type GoogleCloudDiscoveryengineV1betaSampleQuerySet struct {
	// CreateTime: Output only. Timestamp the SampleQuerySet was created at.
	CreateTime string `json:"createTime,omitempty"`
	// Description: The description of the SampleQuerySet.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The sample query set display name. This field must be
	// a UTF-8 encoded string with a length limit of 128 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The full resource name of the SampleQuerySet, in the
	// format of
	// `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}`.
	//  This field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSampleQuerySet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSampleQuerySet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSchema: Defines the structure and layout of
// a type of document data.
type GoogleCloudDiscoveryengineV1betaSchema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`
	// Name: Immutable. The full resource name of the schema, in the format of
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/schemas/{schema}`. This field must be a UTF-8 encoded string
	// with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`
	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JsonSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchInfo: Detailed search information.
type GoogleCloudDiscoveryengineV1betaSearchInfo struct {
	// Offset: An integer that specifies the current offset for pagination (the
	// 0-indexed starting location, amongst the products deemed by the API as
	// relevant). See SearchRequest.offset for definition. If this field is
	// negative, an `INVALID_ARGUMENT` is returned. This can only be set for
	// `search` events. Other event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	Offset int64 `json:"offset,omitempty"`
	// OrderBy: The order in which products are returned, if applicable. See
	// SearchRequest.order_by for definition and syntax. The value must be a UTF-8
	// encoded string with a length limit of 1,000 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned. This can only be set for `search`
	// events. Other event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// SearchQuery: The user's search query. See SearchRequest.query for
	// definition. The value must be a UTF-8 encoded string with a length limit of
	// 5,000 characters. Otherwise, an `INVALID_ARGUMENT` error is returned. At
	// least one of search_query or PageInfo.page_category is required for `search`
	// events. Other event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	SearchQuery string `json:"searchQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Offset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Offset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchLinkPromotion: Promotion proto
// includes uri and other helping information to display the promotion.
type GoogleCloudDiscoveryengineV1betaSearchLinkPromotion struct {
	// Description: Optional. The Promotion description. Maximum length: 200
	// characters.
	Description string `json:"description,omitempty"`
	// Enabled: Optional. The enabled promotion will be returned for any serving
	// configs associated with the parent of the control this promotion is attached
	// to. This flag is used for basic site search only.
	Enabled bool `json:"enabled,omitempty"`
	// ImageUri: Optional. The promotion thumbnail image url.
	ImageUri string `json:"imageUri,omitempty"`
	// Title: Required. The title of the promotion. Maximum length: 160 characters.
	Title string `json:"title,omitempty"`
	// Uri: Required. The URL for the page the user wants to promote.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchLinkPromotion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchLinkPromotion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequest: Request message for
// SearchService.Search method.
type GoogleCloudDiscoveryengineV1betaSearchRequest struct {
	// BoostSpec: Boost specification to boost certain documents. For more
	// information on boosting, see Boosting
	// (https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
	BoostSpec *GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// Branch: The branch resource name, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/defaul
	// t_data_store/branches/0`. Use `default_branch` as the branch ID or leave
	// this field empty, to search documents under the default branch.
	Branch string `json:"branch,omitempty"`
	// CanonicalFilter: The default filter that is applied when a user performs a
	// search without checking any filters on the search page. The filter applied
	// to every search request when quality improvement such as query expansion is
	// needed. In the case a query does not have a sufficient amount of results
	// this filter will be used to determine whether or not to enable the query
	// expansion flow. The original filter will still be used for the query
	// expanded search. This field is strongly recommended to achieve high search
	// quality. For more information about filter syntax, see SearchRequest.filter.
	CanonicalFilter string `json:"canonicalFilter,omitempty"`
	// ContentSearchSpec: A specification for configuring the behavior of content
	// search.
	ContentSearchSpec *GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpec `json:"contentSearchSpec,omitempty"`
	// DataStoreSpecs: Specs defining DataStores to filter on in a search call and
	// configurations for those data stores. This is only considered for Engines
	// with multiple data stores. For engines with a single data store, the specs
	// directly under SearchRequest should be used.
	DataStoreSpecs []*GoogleCloudDiscoveryengineV1betaSearchRequestDataStoreSpec `json:"dataStoreSpecs,omitempty"`
	// EmbeddingSpec: Uses the provided embedding to do additional semantic
	// document retrieval. The retrieval is based on the dot product of
	// SearchRequest.EmbeddingSpec.EmbeddingVector.vector and the document
	// embedding that is provided in
	// SearchRequest.EmbeddingSpec.EmbeddingVector.field_path. If
	// SearchRequest.EmbeddingSpec.EmbeddingVector.field_path is not provided, it
	// will use ServingConfig.EmbeddingConfig.field_path.
	EmbeddingSpec *GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpec `json:"embeddingSpec,omitempty"`
	// FacetSpecs: Facet specifications for faceted search. If empty, no facets are
	// returned. A maximum of 100 values are allowed. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	FacetSpecs []*GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpec `json:"facetSpecs,omitempty"`
	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents being
	// filtered. Filter expression is case-sensitive. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI
	// Search is done by mapping the LHS filter key to a key property defined in
	// the Vertex AI Search backend -- this mapping is defined by the customer in
	// their schema. For example a media customer might have a field 'name' in
	// their schema. In this case the filter would look like this: filter -->
	// name:'ANY("king kong")' For more information about filtering including
	// syntax and filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// ImageQuery: Raw image query.
	ImageQuery *GoogleCloudDiscoveryengineV1betaSearchRequestImageQuery `json:"imageQuery,omitempty"`
	// LanguageCode: The BCP-47 language code, such as "en-US" or "sr-Latn". For
	// more information, see Standard fields
	// (https://cloud.google.com/apis/design/standard_fields). This field helps to
	// better interpret the query. If a value isn't specified, the query language
	// code is automatically detected, which may not be accurate.
	LanguageCode string `json:"languageCode,omitempty"`
	// NaturalLanguageQueryUnderstandingSpec: If
	// `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
	// natural language query understanding will be done.
	NaturalLanguageQueryUnderstandingSpec *GoogleCloudDiscoveryengineV1betaSearchRequestNaturalLanguageQueryUnderstandingSpec `json:"naturalLanguageQueryUnderstandingSpec,omitempty"`
	// Offset: A 0-indexed integer that specifies the current offset (that is,
	// starting result location, amongst the Documents deemed by the API as
	// relevant) in search results. This field is only considered if page_token is
	// unset. If this field is negative, an `INVALID_ARGUMENT` is returned.
	Offset int64 `json:"offset,omitempty"`
	// OneBoxPageSize: The maximum number of results to return for OneBox. This
	// applies to each OneBox type individually. Default number is 10.
	OneBoxPageSize int64 `json:"oneBoxPageSize,omitempty"`
	// OrderBy: The order in which documents are returned. Documents can be ordered
	// by a field in an Document object. Leave it unset if ordered by relevance.
	// `order_by` expression is case-sensitive. For more information on ordering
	// the website search results, see Order web search results
	// (https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
	// For more information on ordering the healthcare search results, see Order
	// healthcare search results
	// (https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
	// If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
	OrderBy string `json:"orderBy,omitempty"`
	// PageSize: Maximum number of Documents to return. The maximum allowed value
	// depends on the data type. Values above the maximum value are coerced to the
	// maximum value. * Websites with basic indexing: Default `10`, Maximum `25`. *
	// Websites with advanced indexing: Default `25`, Maximum `50`. * Other:
	// Default `50`, Maximum `100`. If this field is negative, an
	// `INVALID_ARGUMENT` is returned.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token received from a previous SearchService.Search call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to SearchService.Search must match the call that
	// provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
	PageToken string `json:"pageToken,omitempty"`
	// Params: Additional search parameters. For public website search only,
	// supported values are: * `user_country_code`: string. Default empty. If set
	// to non-empty, results are restricted or boosted based on the location
	// provided. For example, `user_country_code: "au" For available codes see
	// Country Codes
	// (https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
	// * `search_type`: double. Default empty. Enables non-webpage searching
	// depending on the value. The only valid non-default value is 1, which enables
	// image searching. For example, `search_type: 1`
	Params googleapi.RawMessage `json:"params,omitempty"`
	// PersonalizationSpec: The specification for personalization. Notice that if
	// both ServingConfig.personalization_spec and
	// SearchRequest.personalization_spec are set,
	// SearchRequest.personalization_spec overrides
	// ServingConfig.personalization_spec.
	PersonalizationSpec *GoogleCloudDiscoveryengineV1betaSearchRequestPersonalizationSpec `json:"personalizationSpec,omitempty"`
	// Query: Raw search query.
	Query string `json:"query,omitempty"`
	// QueryExpansionSpec: The query expansion specification that specifies the
	// conditions under which query expansion occurs.
	QueryExpansionSpec *GoogleCloudDiscoveryengineV1betaSearchRequestQueryExpansionSpec `json:"queryExpansionSpec,omitempty"`
	// RankingExpression: The ranking expression controls the customized ranking on
	// retrieval documents. This overrides ServingConfig.ranking_expression. The
	// ranking expression is a single function or multiple functions that are
	// joined by "+". * ranking_expression = function, { " + ", function };
	// Supported functions: * double * relevance_score * double *
	// dotProduct(embedding_field_path) Function variables: * `relevance_score`:
	// pre-defined keywords, used for measure relevance between query and document.
	// * `embedding_field_path`: the document embedding field used with query
	// embedding vector. * `dotProduct`: embedding function between
	// embedding_field_path and query embedding vector. Example ranking expression:
	// If document has an embedding field doc_embedding, the ranking expression
	// could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
	RankingExpression string `json:"rankingExpression,omitempty"`
	// RegionCode: The Unicode country/region code (CLDR) of a location, such as
	// "US" and "419". For more information, see Standard fields
	// (https://cloud.google.com/apis/design/standard_fields). If set, then results
	// will be boosted based on the region_code provided.
	RegionCode string `json:"regionCode,omitempty"`
	// RelevanceThreshold: The relevance threshold of the search results. Default
	// to Google defined threshold, leveraging a balance of precision and recall to
	// deliver both highly accurate results and comprehensive coverage of relevant
	// information.
	//
	// Possible values:
	//   "RELEVANCE_THRESHOLD_UNSPECIFIED" - Default value. In this case, server
	// behavior defaults to Google defined threshold.
	//   "LOWEST" - Lowest relevance threshold.
	//   "LOW" - Low relevance threshold.
	//   "MEDIUM" - Medium relevance threshold.
	//   "HIGH" - High relevance threshold.
	RelevanceThreshold string `json:"relevanceThreshold,omitempty"`
	// SafeSearch: Whether to turn on safe search. This is only supported for
	// website search.
	SafeSearch bool `json:"safeSearch,omitempty"`
	// SearchAsYouTypeSpec: Search as you type configuration. Only supported for
	// the IndustryVertical.MEDIA vertical.
	SearchAsYouTypeSpec *GoogleCloudDiscoveryengineV1betaSearchRequestSearchAsYouTypeSpec `json:"searchAsYouTypeSpec,omitempty"`
	// ServingConfig: Required. The resource name of the Search serving config,
	// such as
	// `projects/*/locations/global/collections/default_collection/engines/*/serving
	// Configs/default_serving_config`, or
	// `projects/*/locations/global/collections/default_collection/dataStores/defaul
	// t_data_store/servingConfigs/default_serving_config`. This field is used to
	// identify the serving configuration name, set of models used to make the
	// search.
	ServingConfig string `json:"servingConfig,omitempty"`
	// Session: The session resource name. Optional. Session allows users to do
	// multi-turn /search API calls or coordination between /search API calls and
	// /answer API calls. Example #1 (multi-turn /search API calls): 1. Call
	// /search API with the auto-session mode (see below). 2. Call /search API with
	// the session ID generated in the first call. Here, the previous search query
	// gets considered in query standing. I.e., if the first query is "How did
	// Alphabet do in 2022?" and the current query is "How about 2023?", the
	// current query will be interpreted as "How did Alphabet do in 2023?". Example
	// #2 (coordination between /search API calls and /answer API calls): 1. Call
	// /search API with the auto-session mode (see below). 2. Call /answer API with
	// the session ID generated in the first call. Here, the answer generation
	// happens in the context of the search results from the first search call.
	// Auto-session mode: when `projects/.../sessions/-` is used, a new session
	// gets automatically created. Otherwise, users can use the create-session API
	// to create a session manually. Multi-turn Search feature is currently at
	// private GA stage. Please use v1alpha or v1beta version instead before we
	// launch this feature to public GA. Or ask for allowlisting through Google
	// Support team.
	Session string `json:"session,omitempty"`
	// SessionSpec: Session specification. Can be used only when `session` is set.
	SessionSpec *GoogleCloudDiscoveryengineV1betaSearchRequestSessionSpec `json:"sessionSpec,omitempty"`
	// SpellCorrectionSpec: The spell correction specification that specifies the
	// mode under which spell correction takes effect.
	SpellCorrectionSpec *GoogleCloudDiscoveryengineV1betaSearchRequestSpellCorrectionSpec `json:"spellCorrectionSpec,omitempty"`
	// UserInfo: Information about the end user. Highly recommended for analytics.
	// UserInfo.user_agent is used to deduce `device_type` for analytics.
	UserInfo *GoogleCloudDiscoveryengineV1betaUserInfo `json:"userInfo,omitempty"`
	// UserLabels: The user labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a maximum of
	// 64. * Each label must be a key-value pair. * Keys have a minimum length of 1
	// character and a maximum length of 63 characters and cannot be empty. Values
	// can be empty and have a maximum length of 63 characters. * Keys and values
	// can contain only lowercase letters, numeric characters, underscores, and
	// dashes. All characters must use UTF-8 encoding, and international characters
	// are allowed. * The key portion of a label must be unique. However, you can
	// use the same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// UserPseudoId: A unique identifier for tracking visitors. For example, this
	// could be implemented with an HTTP cookie, which should be able to uniquely
	// identify a visitor on a single device. This unique identifier should not
	// change if the visitor logs in or out of the website. This field should NOT
	// have a fixed value such as `unknown_visitor`. This should be the same
	// identifier as UserEvent.user_pseudo_id and
	// CompleteQueryRequest.user_pseudo_id The field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	UserPseudoId string `json:"userPseudoId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec: Boost specification
// to boost certain documents.
type GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec struct {
	// ConditionBoostSpecs: Condition boost specifications. If a document matches
	// multiple conditions in the specifictions, boost scores from these
	// specifications are all applied and combined in a non-linear way. Maximum
	// number of specifications is 20.
	ConditionBoostSpecs []*GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpec:
// Boost applies to documents which match a condition.
type GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpec struct {
	// Boost: Strength of the condition boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0. Setting to 1.0 gives the document a
	// big promotion. However, it does not necessarily mean that the boosted
	// document will be the top result at all times, nor that other documents will
	// be excluded. Results could still be shown even when none of them matches the
	// condition. And results that are significantly more relevant to the search
	// query can still trump your heavily favored but irrelevant documents. Setting
	// to -1.0 gives the document a big demotion. However, results that are deeply
	// relevant might still be shown. The document will have an upstream battle to
	// get a fairly high ranking, but it is not blocked out completely. Setting to
	// 0.0 means no boost applied. The boosting condition is ignored. Only one of
	// the (condition, boost) combination or the boost_control_spec below are set.
	// If both are set then the global boost is ignored and the more fine-grained
	// boost_control_spec is applied.
	Boost float64 `json:"boost,omitempty"`
	// BoostControlSpec: Complex specification for custom ranking based on customer
	// defined attribute value.
	BoostControlSpec *GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec `json:"boostControlSpec,omitempty"`
	// Condition: An expression which specifies a boost condition. The syntax and
	// supported fields are the same as a filter expression. See
	// SearchRequest.filter for detail syntax and limitations. Examples: * To boost
	// documents with document ID "doc_1" or "doc_2", and color "Red" or "Blue":
	// `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoost
// ControlSpec: Specification for custom ranking based on customer specified
// attribute value. It provides more controls for customized ranking than the
// simple (condition, boost) combination above.
type GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec struct {
	// AttributeType: The attribute type to be used to determine the boost amount.
	// The attribute value can be derived from the field value of the specified
	// field_name. In the case of numerical it is straightforward i.e.
	// attribute_value = numerical_field_value. In the case of freshness however,
	// attribute_value = (time.now() - datetime_field_value).
	//
	// Possible values:
	//   "ATTRIBUTE_TYPE_UNSPECIFIED" - Unspecified AttributeType.
	//   "NUMERICAL" - The value of the numerical field will be used to dynamically
	// update the boost amount. In this case, the attribute_value (the x value) of
	// the control point will be the actual value of the numerical field for which
	// the boost_amount is specified.
	//   "FRESHNESS" - For the freshness use case the attribute value will be the
	// duration between the current time and the date in the datetime field
	// specified. The value must be formatted as an XSD `dayTimeDuration` value (a
	// restricted subset of an ISO 8601 duration value). The pattern for this is:
	// `nDnM]`. For example, `5D`, `3DT12H30M`, `T24H`.
	AttributeType string `json:"attributeType,omitempty"`
	// ControlPoints: The control points used to define the curve. The monotonic
	// function (defined through the interpolation_type above) passes through the
	// control points listed here.
	ControlPoints []*GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint `json:"controlPoints,omitempty"`
	// FieldName: The name of the field whose value will be used to determine the
	// boost amount.
	FieldName string `json:"fieldName,omitempty"`
	// InterpolationType: The interpolation type to be applied to connect the
	// control points listed below.
	//
	// Possible values:
	//   "INTERPOLATION_TYPE_UNSPECIFIED" - Interpolation type is unspecified. In
	// this case, it defaults to Linear.
	//   "LINEAR" - Piecewise linear interpolation will be applied.
	InterpolationType string `json:"interpolationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoost
// ControlSpecControlPoint: The control points used to define the curve. The
// curve defined through these control points can only be monotonically
// increasing or decreasing(constant values are acceptable).
type GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint struct {
	// AttributeValue: Can be one of: 1. The numerical field value. 2. The duration
	// spec for freshness: The value must be formatted as an XSD `dayTimeDuration`
	// value (a restricted subset of an ISO 8601 duration value). The pattern for
	// this is: `nDnM]`.
	AttributeValue string `json:"attributeValue,omitempty"`
	// BoostAmount: The value between -1 to 1 by which to boost the score if the
	// attribute_value evaluates to the value specified above.
	BoostAmount float64 `json:"boostAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint
	var s1 struct {
		BoostAmount gensupport.JSONFloat64 `json:"boostAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostAmount = float64(s1.BoostAmount)
	return nil
}

// GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpec: A
// specification for configuring the behavior of content search.
type GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpec struct {
	// ChunkSpec: Specifies the chunk spec to be returned from the search response.
	// Only available if the SearchRequest.ContentSearchSpec.search_result_mode is
	// set to CHUNKS
	ChunkSpec *GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecChunkSpec `json:"chunkSpec,omitempty"`
	// ExtractiveContentSpec: If there is no extractive_content_spec provided,
	// there will be no extractive answer in the search response.
	ExtractiveContentSpec *GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecExtractiveContentSpec `json:"extractiveContentSpec,omitempty"`
	// SearchResultMode: Specifies the search result mode. If unspecified, the
	// search result mode defaults to `DOCUMENTS`.
	//
	// Possible values:
	//   "SEARCH_RESULT_MODE_UNSPECIFIED" - Default value.
	//   "DOCUMENTS" - Returns documents in the search result.
	//   "CHUNKS" - Returns chunks in the search result. Only available if the
	// DocumentProcessingConfig.chunking_config is specified.
	SearchResultMode string `json:"searchResultMode,omitempty"`
	// SnippetSpec: If `snippetSpec` is not specified, snippets are not included in
	// the search response.
	SnippetSpec *GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSnippetSpec `json:"snippetSpec,omitempty"`
	// SummarySpec: If `summarySpec` is not specified, summaries are not included
	// in the search response.
	SummarySpec *GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChunkSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChunkSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecChunkSpec:
// Specifies the chunk spec to be returned from the search response. Only
// available if the SearchRequest.ContentSearchSpec.search_result_mode is set
// to CHUNKS
type GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecChunkSpec struct {
	// NumNextChunks: The number of next chunks to be returned of the current
	// chunk. The maximum allowed value is 3. If not specified, no next chunks will
	// be returned.
	NumNextChunks int64 `json:"numNextChunks,omitempty"`
	// NumPreviousChunks: The number of previous chunks to be returned of the
	// current chunk. The maximum allowed value is 3. If not specified, no previous
	// chunks will be returned.
	NumPreviousChunks int64 `json:"numPreviousChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumNextChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumNextChunks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecChunkSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecChunkSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecExtractiveConte
// ntSpec: A specification for configuring the extractive content in a search
// response.
type GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecExtractiveContentSpec struct {
	// MaxExtractiveAnswerCount: The maximum number of extractive answers returned
	// in each search result. An extractive answer is a verbatim answer extracted
	// from the original document, which provides a precise and contextually
	// relevant answer to the search query. If the number of matching answers is
	// less than the `max_extractive_answer_count`, return all of the answers.
	// Otherwise, return the `max_extractive_answer_count`. At most five answers
	// are returned for each SearchResult.
	MaxExtractiveAnswerCount int64 `json:"maxExtractiveAnswerCount,omitempty"`
	// MaxExtractiveSegmentCount: The max number of extractive segments returned in
	// each search result. Only applied if the DataStore is set to
	// DataStore.ContentConfig.CONTENT_REQUIRED or DataStore.solution_types is
	// SOLUTION_TYPE_CHAT. An extractive segment is a text segment extracted from
	// the original document that is relevant to the search query, and, in general,
	// more verbose than an extractive answer. The segment could then be used as
	// input for LLMs to generate summaries and answers. If the number of matching
	// segments is less than `max_extractive_segment_count`, return all of the
	// segments. Otherwise, return the `max_extractive_segment_count`.
	MaxExtractiveSegmentCount int64 `json:"maxExtractiveSegmentCount,omitempty"`
	// NumNextSegments: Return at most `num_next_segments` segments after each
	// selected segments.
	NumNextSegments int64 `json:"numNextSegments,omitempty"`
	// NumPreviousSegments: Specifies whether to also include the adjacent from
	// each selected segments. Return at most `num_previous_segments` segments
	// before each selected segments.
	NumPreviousSegments int64 `json:"numPreviousSegments,omitempty"`
	// ReturnExtractiveSegmentScore: Specifies whether to return the confidence
	// score from the extractive segments in each search result. This feature is
	// available only for new or allowlisted data stores. To allowlist your data
	// store, contact your Customer Engineer. The default value is `false`.
	ReturnExtractiveSegmentScore bool `json:"returnExtractiveSegmentScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxExtractiveAnswerCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxExtractiveAnswerCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecExtractiveContentSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecExtractiveContentSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSnippetSpec: A
// specification for configuring snippets in a search response.
type GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSnippetSpec struct {
	// MaxSnippetCount: [DEPRECATED] This field is deprecated. To control snippet
	// return, use `return_snippet` field. For backwards compatibility, we will
	// return snippet if max_snippet_count > 0.
	MaxSnippetCount int64 `json:"maxSnippetCount,omitempty"`
	// ReferenceOnly: [DEPRECATED] This field is deprecated and will have no affect
	// on the snippet.
	ReferenceOnly bool `json:"referenceOnly,omitempty"`
	// ReturnSnippet: If `true`, then return snippet. If no snippet can be
	// generated, we return "No snippet is available for this page." A
	// `snippet_status` with `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be
	// returned.
	ReturnSnippet bool `json:"returnSnippet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxSnippetCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxSnippetCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSnippetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSnippetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpec: A
// specification for configuring a summary returned in a search response.
type GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpec struct {
	// IgnoreAdversarialQuery: Specifies whether to filter out adversarial queries.
	// The default value is `false`. Google employs search-query classification to
	// detect adversarial queries. No summary is returned if the search query is
	// classified as an adversarial query. For example, a user might ask a question
	// regarding negative comments about the company or submit a query designed to
	// generate unsafe, policy-violating output. If this field is set to `true`, we
	// skip generating summaries for adversarial queries and return fallback
	// messages instead.
	IgnoreAdversarialQuery bool `json:"ignoreAdversarialQuery,omitempty"`
	// IgnoreJailBreakingQuery: Optional. Specifies whether to filter out
	// jail-breaking queries. The default value is `false`. Google employs
	// search-query classification to detect jail-breaking queries. No summary is
	// returned if the search query is classified as a jail-breaking query. A user
	// might add instructions to the query to change the tone, style, language,
	// content of the answer, or ask the model to act as a different entity, e.g.
	// "Reply in the tone of a competing company's CEO". If this field is set to
	// `true`, we skip generating summaries for jail-breaking queries and return
	// fallback messages instead.
	IgnoreJailBreakingQuery bool `json:"ignoreJailBreakingQuery,omitempty"`
	// IgnoreLowRelevantContent: Specifies whether to filter out queries that have
	// low relevance. The default value is `false`. If this field is set to
	// `false`, all search results are used regardless of relevance to generate
	// answers. If set to `true`, only queries with high relevance search results
	// will generate answers.
	IgnoreLowRelevantContent bool `json:"ignoreLowRelevantContent,omitempty"`
	// IgnoreNonSummarySeekingQuery: Specifies whether to filter out queries that
	// are not summary-seeking. The default value is `false`. Google employs
	// search-query classification to detect summary-seeking queries. No summary is
	// returned if the search query is classified as a non-summary seeking query.
	// For example, `why is the sky blue` and `Who is the best soccer player in the
	// world?` are summary-seeking queries, but `SFO airport` and `world cup 2026`
	// are not. They are most likely navigational queries. If this field is set to
	// `true`, we skip generating summaries for non-summary seeking queries and
	// return fallback messages instead.
	IgnoreNonSummarySeekingQuery bool `json:"ignoreNonSummarySeekingQuery,omitempty"`
	// IncludeCitations: Specifies whether to include citations in the summary. The
	// default value is `false`. When this field is set to `true`, summaries
	// include in-line citation numbers. Example summary including citations:
	// BigQuery is Google Cloud's fully managed and completely serverless
	// enterprise data warehouse [1]. BigQuery supports all data types, works
	// across clouds, and has built-in machine learning and business intelligence,
	// all within a unified platform [2, 3]. The citation numbers refer to the
	// returned search results and are 1-indexed. For example, [1] means that the
	// sentence is attributed to the first search result. [2, 3] means that the
	// sentence is attributed to both the second and third search results.
	IncludeCitations bool `json:"includeCitations,omitempty"`
	// LanguageCode: Language code for Summary. Use language tags defined by BCP47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an
	// experimental feature.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelPromptSpec: If specified, the spec will be used to modify the prompt
	// provided to the LLM.
	ModelPromptSpec *GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelPromptSpec `json:"modelPromptSpec,omitempty"`
	// ModelSpec: If specified, the spec will be used to modify the model
	// specification provided to the LLM.
	ModelSpec *GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelSpec `json:"modelSpec,omitempty"`
	// SummaryResultCount: The number of top results to generate the summary from.
	// If the number of results returned is less than `summaryResultCount`, the
	// summary is generated from all of the results. At most 10 results for
	// documents mode, or 50 for chunks mode, can be used to generate a summary.
	// The chunks mode is used when
	// SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
	SummaryResultCount int64 `json:"summaryResultCount,omitempty"`
	// UseSemanticChunks: If true, answer will be generated from most relevant
	// chunks from top search results. This feature will improve summary quality.
	// Note that with this feature enabled, not all top search results will be
	// referenced and included in the reference list, so the citation source index
	// only points to the search results listed in the reference list.
	UseSemanticChunks bool `json:"useSemanticChunks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreAdversarialQuery") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecMode
// lPromptSpec: Specification of the prompt to use with the model.
type GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelPromptSpec struct {
	// Preamble: Text at the beginning of the prompt that instructs the assistant.
	// Examples are available in the user guide.
	Preamble string `json:"preamble,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Preamble") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Preamble") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelPromptSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelPromptSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecMode
// lSpec: Specification of the model.
type GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelSpec struct {
	// Version: The model version used to generate the summary. Supported values
	// are: * `stable`: string. Default value when no value is specified. Uses a
	// generally available, fine-tuned model. For more information, see Answer
	// generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	// * `preview`: string. (Public preview) Uses a preview model. For more
	// information, see Answer generation model versions and lifecycle
	// (https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestDataStoreSpec: A struct to
// define data stores to filter on in a search call and configurations for
// those data stores. Otherwise, an `INVALID_ARGUMENT` error is returned.
type GoogleCloudDiscoveryengineV1betaSearchRequestDataStoreSpec struct {
	// BoostSpec: Optional. Boost specification to boost certain documents. For
	// more information on boosting, see Boosting
	// (https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
	BoostSpec *GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec `json:"boostSpec,omitempty"`
	// DataStore: Required. Full resource name of DataStore, such as
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStor
	// es/{data_store_id}`.
	DataStore string `json:"dataStore,omitempty"`
	// Filter: Optional. Filter specification to filter documents in the data store
	// specified by data_store field. For more information on filtering, see
	// Filtering
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestDataStoreSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestDataStoreSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpec: The
// specification that uses customized query embedding vector to do semantic
// document retrieval.
type GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpec struct {
	// EmbeddingVectors: The embedding vector used for retrieval. Limit to 1.
	EmbeddingVectors []*GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpecEmbeddingVector `json:"embeddingVectors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmbeddingVectors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmbeddingVectors") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpecEmbeddingVector:
// Embedding vector.
type GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpecEmbeddingVector struct {
	// FieldPath: Embedding field path in schema.
	FieldPath string `json:"fieldPath,omitempty"`
	// Vector: Query embedding vector.
	Vector []float64 `json:"vector,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpecEmbeddingVector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpecEmbeddingVector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpecEmbeddingVector) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpecEmbeddingVector
	var s1 struct {
		Vector []gensupport.JSONFloat64 `json:"vector"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Vector = make([]float64, len(s1.Vector))
	for i := range s1.Vector {
		s.Vector[i] = float64(s1.Vector[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpec: A facet
// specification to perform faceted search.
type GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpec struct {
	// EnableDynamicPosition: Enables dynamic position for this facet. If set to
	// true, the position of this facet among all facets in the response is
	// determined automatically. If dynamic facets are enabled, it is ordered
	// together. If set to false, the position of this facet in the response is the
	// same as in the request, and it is ranked before the facets with dynamic
	// position enable and all dynamic facets. For example, you may always want to
	// have rating facet returned in the response, but it's not necessarily to
	// always display the rating facet at the top. In that case, you can set
	// enable_dynamic_position to true so that the position of rating facet in
	// response is determined automatically. Another example, assuming you have the
	// following facets in the request: * "rating", enable_dynamic_position = true
	// * "price", enable_dynamic_position = false * "brands",
	// enable_dynamic_position = false And also you have a dynamic facets enabled,
	// which generates a facet `gender`. Then the final order of the facets in the
	// response can be ("price", "brands", "rating", "gender") or ("price",
	// "brands", "gender", "rating") depends on how API orders "gender" and
	// "rating" facets. However, notice that "price" and "brands" are always ranked
	// at first and second position because their enable_dynamic_position is false.
	EnableDynamicPosition bool `json:"enableDynamicPosition,omitempty"`
	// ExcludedFilterKeys: List of keys to exclude when faceting. By default,
	// FacetKey.key is not excluded from the filter unless it is listed in this
	// field. Listing a facet key in this field allows its values to appear as
	// facet results, even when they are filtered out of search results. Using this
	// field does not affect what search results are returned. For example, suppose
	// there are 100 documents with the color facet "Red" and 200 documents with
	// the color facet "Blue". A query containing the filter "color:ANY("Red")" and
	// having "color" as FacetKey.key would by default return only "Red" documents
	// in the search results, and also return "Red" with count 100 as the only
	// color facet. Although there are also blue documents available, "Blue" would
	// not be shown as an available facet value. If "color" is listed in
	// "excludedFilterKeys", then the query returns the facet values "Red" with
	// count 100 and "Blue" with count 200, because the "color" key is now excluded
	// from the filter. Because this field doesn't affect search results, the
	// search results are still correctly filtered to return only "Red" documents.
	// A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error
	// is returned.
	ExcludedFilterKeys []string `json:"excludedFilterKeys,omitempty"`
	// FacetKey: Required. The facet key specification.
	FacetKey *GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpecFacetKey `json:"facetKey,omitempty"`
	// Limit: Maximum facet values that are returned for this facet. If
	// unspecified, defaults to 20. The maximum allowed value is 300. Values above
	// 300 are coerced to 300. For aggregation in healthcare search, when the
	// [FacetKey.key] is "healthcare_aggregation_key", the limit will be overridden
	// to 10,000 internally, regardless of the value set here. If this field is
	// negative, an `INVALID_ARGUMENT` is returned.
	Limit int64 `json:"limit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableDynamicPosition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableDynamicPosition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpecFacetKey: Specifies
// how a facet is computed.
type GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpecFacetKey struct {
	// CaseInsensitive: True to make facet keys case insensitive when getting
	// faceting values with prefixes or contains; false otherwise.
	CaseInsensitive bool `json:"caseInsensitive,omitempty"`
	// Contains: Only get facet values that contain the given strings. For example,
	// suppose "category" has three values "Action > 2022", "Action > 2021" and
	// "Sci-Fi > 2022". If set "contains" to "2022", the "category" facet only
	// contains "Action > 2022" and "Sci-Fi > 2022". Only supported on textual
	// fields. Maximum is 10.
	Contains []string `json:"contains,omitempty"`
	// Intervals: Set only if values should be bucketed into intervals. Must be set
	// for facets with numerical values. Must not be set for facet with text
	// values. Maximum number of intervals is 30.
	Intervals []*GoogleCloudDiscoveryengineV1betaInterval `json:"intervals,omitempty"`
	// Key: Required. Supported textual and numerical facet keys in Document
	// object, over which the facet values are computed. Facet key is
	// case-sensitive.
	Key string `json:"key,omitempty"`
	// OrderBy: The order in which documents are returned. Allowed values are: *
	// "count desc", which means order by SearchResponse.Facet.values.count
	// descending. * "value desc", which means order by
	// SearchResponse.Facet.values.value descending. Only applies to textual
	// facets. If not set, textual values are sorted in natural order
	// (https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are
	// sorted in the order given by FacetSpec.FacetKey.intervals.
	OrderBy string `json:"orderBy,omitempty"`
	// Prefixes: Only get facet values that start with the given string prefix. For
	// example, suppose "category" has three values "Action > 2022", "Action >
	// 2021" and "Sci-Fi > 2022". If set "prefixes" to "Action", the "category"
	// facet only contains "Action > 2022" and "Action > 2021". Only supported on
	// textual fields. Maximum is 10.
	Prefixes []string `json:"prefixes,omitempty"`
	// RestrictedValues: Only get facet for the given restricted values. Only
	// supported on textual fields. For example, suppose "category" has three
	// values "Action > 2022", "Action > 2021" and "Sci-Fi > 2022". If set
	// "restricted_values" to "Action > 2022", the "category" facet only contains
	// "Action > 2022". Only supported on textual fields. Maximum is 10.
	RestrictedValues []string `json:"restrictedValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseInsensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseInsensitive") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpecFacetKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpecFacetKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestImageQuery: Specifies the image
// query input.
type GoogleCloudDiscoveryengineV1betaSearchRequestImageQuery struct {
	// ImageBytes: Base64 encoded image bytes. Supported image formats: JPEG, PNG,
	// and BMP.
	ImageBytes string `json:"imageBytes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestImageQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestImageQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestNaturalLanguageQueryUnderstandin
// gSpec: Specification to enable natural language understanding capabilities
// for search requests.
type GoogleCloudDiscoveryengineV1betaSearchRequestNaturalLanguageQueryUnderstandingSpec struct {
	// FilterExtractionCondition: The condition under which filter extraction
	// should occur. Default to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disables NL filter extraction.
	//   "ENABLED" - Enables NL filter extraction.
	FilterExtractionCondition string `json:"filterExtractionCondition,omitempty"`
	// GeoSearchQueryDetectionFieldNames: Field names used for location-based
	// filtering, where geolocation filters are detected in natural language search
	// queries. Only valid when the FilterExtractionCondition is set to `ENABLED`.
	// If this field is set, it overrides the field names set in
	// ServingConfig.geo_search_query_detection_field_names.
	GeoSearchQueryDetectionFieldNames []string `json:"geoSearchQueryDetectionFieldNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilterExtractionCondition")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilterExtractionCondition") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestNaturalLanguageQueryUnderstandingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestNaturalLanguageQueryUnderstandingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestPersonalizationSpec: The
// specification for personalization.
type GoogleCloudDiscoveryengineV1betaSearchRequestPersonalizationSpec struct {
	// Mode: The personalization mode of the search request. Defaults to Mode.AUTO.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value. In this case, server behavior defaults
	// to Mode.AUTO.
	//   "AUTO" - Personalization is enabled if data quality requirements are met.
	//   "DISABLED" - Disable personalization.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDiscoveryengineV1betaSearchRequestPersonalizationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchRequestPersonalizationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchRequestQueryExpansionSpec:
// Specification to determine under which conditions query expansion should
// occur.
type GoogleCloudDiscoveryengineV1betaSearchRequestQueryExpansionSpec struct {
	// Condition: The condition under which query expansion should occur. Default
	// to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Unspecified query