/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.GdbProcess;
import charm.debug.inspect.DataType;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.VariableElement;
import charm.debug.pdata.ChareInfo;
import charm.debug.pdata.EpInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Vector;

public class PythonScript {
    public static final String beginning = "def method(self):";
    private static int seqNumber = 0;
    private GdbProcess info;
    private String code;
    private String parsedString;
    private ChareInfo chare;
    private Vector[] selectedEPs;

    public PythonScript(GdbProcess gdb) {
        this.info = gdb;
        this.chare = null;
        this.code = null;
        this.selectedEPs = new Vector[2];
        this.selectedEPs[0] = new Vector();
        this.selectedEPs[1] = new Vector();
    }

    public String parseCode(String str) throws ParseException {
        this.code = str;
        this.parsedString = str;
        if (!this.parsedString.startsWith(beginning)) {
            throw new ParseException("The code must start with 'def method(self):'", 0);
        }
        this.parsedString = this.parsedString.substring(0, 10) + seqNumber + this.parsedString.substring(10);
        ++seqNumber;
        int first = 0;
        int last = 0;
        while ((first = this.parsedString.indexOf("charm.get", first)) != -1) {
            int typeEnd;
            int startArgs = this.parsedString.indexOf(40, first += 9);
            if (this.parsedString.startsWith("Message", first)) continue;
            if (this.parsedString.startsWith("Static", first)) {
                int splitPoint = this.parsedString.indexOf(")", startArgs);
                String name = this.parsedString.substring(startArgs + 1, splitPoint).trim();
                System.out.println("Static name = " + name);
                String address = this.info.infoCommand("print &" + name + "\n");
                int startAddress = address.indexOf("0x");
                if (startAddress == -1) {
                    throw new ParseException("Static variable " + name + " not found", 0);
                }
                System.out.println("Reply: " + address);
                int retType = 112;
                if (address.indexOf("(int *)") != -1) {
                    retType = 105;
                } else if (address.indexOf("(char *)") != -1) {
                    retType = 98;
                } else if (address.indexOf("(short *)") != -1) {
                    retType = 104;
                } else if (address.indexOf("(long *)") != -1) {
                    retType = 108;
                } else if (address.indexOf("(float *)") != -1) {
                    retType = 102;
                } else if (address.indexOf("(double *)") != -1) {
                    retType = 100;
                } else if (address.indexOf("(char **)") != -1) {
                    retType = 115;
                }
                this.parsedString = this.parsedString.substring(0, startArgs + 1) + address.substring(startAddress).trim() + ",'" + (char)retType + "'" + this.parsedString.substring(splitPoint);
                continue;
            }
            last = typeEnd = this.parsedString.indexOf(44, startArgs);
            String type = this.parsedString.substring(last + 1, this.parsedString.indexOf(44, last + 1)).trim();
            GenericType t = Inspector.getTypeCreate(type);
            System.out.println("get type " + type + " (last=" + last + ")");
            last = this.parsedString.indexOf(44, last + 1);
            int splitPoint = this.parsedString.indexOf(41, last + 1);
            if (this.parsedString.startsWith("Array", first)) {
                int size = t.getSize();
                System.out.println("Array Resulting type: " + t.getName() + ", ptr=" + t.getPointer() + " ,size=" + t.getSize());
                int charType = t.getPointer() == 0 ? (t.getName().equals("int") ? 105 : (t.getName().equals("char") ? 98 : (t.getName().equals("short") ? 104 : (t.getName().equals("long") ? 108 : (t.getName().equals("float") ? 102 : (t.getName().equals("double") ? 100 : (t.getName().equals("bool") ? 105 : 99))))))) : 112;
                this.parsedString = this.parsedString.substring(0, typeEnd + 1) + size + ",'" + (char)charType + "'" + this.parsedString.substring(last);
                continue;
            }
            if (this.parsedString.startsWith("Value", first)) {
                String name = this.parsedString.substring(last + 1, this.parsedString.indexOf(41, last + 1)).trim();
                if (!(t instanceof DataType)) {
                    throw new ParseException("Invalid parameter '" + type + "' to function getValue", 0);
                }
                DataType dt = (DataType)t;
                int offset = dt.getVariableOffset(name);
                if (offset < 0) {
                    throw new ParseException("Invalid variable '" + name + "' in type '" + type + "' to function getValue", 0);
                }
                VariableElement element = dt.getVariable(name);
                GenericType resultType = element.getType();
                System.out.println("Resulting type: " + resultType.getName() + ", ptr=" + resultType.getPointer() + " ,size=" + resultType.getSize());
                int charType = resultType.getPointer() > 0 || element.getPointer() > 0 || element.getArray() > 0 ? 112 : (resultType.getName().equals("int") ? 105 : (resultType.getName().equals("char") ? 98 : (resultType.getName().equals("short") ? 104 : (resultType.getName().equals("long") ? 108 : (resultType.getName().equals("float") ? 102 : (resultType.getName().equals("double") ? 100 : (resultType.getName().equals("bool") ? 105 : 99)))))));
                this.parsedString = this.parsedString.substring(0, typeEnd + 1) + offset + ",'" + (char)charType + "'" + this.parsedString.substring(splitPoint);
                continue;
            }
            if (!this.parsedString.startsWith("Cast", first)) continue;
            String newtype = this.parsedString.substring(last + 1, this.parsedString.indexOf(41, last + 1)).trim();
            GenericType nt = Inspector.getTypeCreate(newtype);
            if (!(t instanceof DataType)) {
                throw new ParseException("Invalid parameter '" + type + "' to function getCast", 0);
            }
            if (!(nt instanceof DataType)) {
                throw new ParseException("Invalid parameter '" + newtype + "' to function getCast", 0);
            }
            DataType dt = (DataType)t;
            DataType ndt = (DataType)nt;
            int offset = 0;
            if (dt.hasSuperclass(ndt)) {
                offset = dt.getSuperclassOffset(ndt);
            } else if (ndt.hasSuperclass(dt)) {
                offset = ndt.getSuperclassOffset(dt);
            } else {
                throw new ParseException("Could not cast between '" + type + "' and '" + newtype + "'", 0);
            }
            this.parsedString = this.parsedString.substring(0, typeEnd + 1) + offset + this.parsedString.substring(splitPoint);
        }
        System.out.println("Final python script: {" + this.parsedString + "}");
        return this.parsedString;
    }

    public String loadPythonCode(File f) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(f));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        return fileData.toString();
    }

    public void savePythonCode(File f, String code) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(f));
        writer.write(code);
        writer.close();
    }

    public String getOriginalCode() {
        return this.code;
    }

    public String getText() {
        return this.parsedString;
    }

    public String getMethod() {
        return this.parsedString.substring(4, this.parsedString.indexOf(40));
    }

    public void setChare(ChareInfo c) {
        this.chare = c;
    }

    public int getChareGroup() {
        return this.chare != null ? this.chare.getGroupID() : 0;
    }

    public ChareInfo getChare() {
        return this.chare;
    }

    public void addEP(int where, EpInfo e) {
        this.selectedEPs[where].add(e);
    }

    public void removeEP(int where, EpInfo e) {
        this.selectedEPs[where].remove(e);
    }

    public Vector[] getSelectedEPs() {
        return this.selectedEPs;
    }
}

