// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package batch

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelJob = "CancelJob"

// CancelJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJob for more information on using the CancelJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelJobRequest method.
//	req, resp := client.CancelJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CancelJob
func (c *Batch) CancelJobRequest(input *CancelJobInput) (req *request.Request, output *CancelJobOutput) {
	op := &request.Operation{
		Name:       opCancelJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/canceljob",
	}

	if input == nil {
		input = &CancelJobInput{}
	}

	output = &CancelJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelJob API operation for AWS Batch.
//
// Cancels a job in an Batch job queue. Jobs that are in the SUBMITTED or PENDING
// are canceled. A job inRUNNABLE remains in RUNNABLE until it reaches the head
// of the job queue. Then the job status is updated to FAILED.
//
// A PENDING job is canceled after all dependency jobs are completed. Therefore,
// it may take longer than expected to cancel a job in PENDING status.
//
// When you try to cancel an array parent job in PENDING, Batch attempts to
// cancel all child jobs. The array parent job is canceled when all child jobs
// are completed.
//
// Jobs that progressed to the STARTING or RUNNING state aren't canceled. However,
// the API operation still succeeds, even if no job is canceled. These jobs
// must be terminated with the TerminateJob operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation CancelJob for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CancelJob
func (c *Batch) CancelJob(input *CancelJobInput) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	return out, req.Send()
}

// CancelJobWithContext is the same as CancelJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) CancelJobWithContext(ctx aws.Context, input *CancelJobInput, opts ...request.Option) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComputeEnvironment = "CreateComputeEnvironment"

// CreateComputeEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateComputeEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComputeEnvironment for more information on using the CreateComputeEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateComputeEnvironmentRequest method.
//	req, resp := client.CreateComputeEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateComputeEnvironment
func (c *Batch) CreateComputeEnvironmentRequest(input *CreateComputeEnvironmentInput) (req *request.Request, output *CreateComputeEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateComputeEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/createcomputeenvironment",
	}

	if input == nil {
		input = &CreateComputeEnvironmentInput{}
	}

	output = &CreateComputeEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateComputeEnvironment API operation for AWS Batch.
//
// Creates an Batch compute environment. You can create MANAGED or UNMANAGED
// compute environments. MANAGED compute environments can use Amazon EC2 or
// Fargate resources. UNMANAGED compute environments can only use EC2 resources.
//
// In a managed compute environment, Batch manages the capacity and instance
// types of the compute resources within the environment. This is based on the
// compute resource specification that you define or the launch template (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html)
// that you specify when you create the compute environment. Either, you can
// choose to use EC2 On-Demand Instances and EC2 Spot Instances. Or, you can
// use Fargate and Fargate Spot capacity in your managed compute environment.
// You can optionally set a maximum price so that Spot Instances only launch
// when the Spot Instance price is less than a specified percentage of the On-Demand
// price.
//
// Multi-node parallel jobs aren't supported on Spot Instances.
//
// In an unmanaged compute environment, you can manage your own EC2 compute
// resources and have flexibility with how you configure your compute resources.
// For example, you can use custom AMIs. However, you must verify that each
// of your AMIs meet the Amazon ECS container instance AMI specification. For
// more information, see container instance AMIs (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html)
// in the Amazon Elastic Container Service Developer Guide. After you created
// your unmanaged compute environment, you can use the DescribeComputeEnvironments
// operation to find the Amazon ECS cluster that's associated with it. Then,
// launch your container instances into that Amazon ECS cluster. For more information,
// see Launching an Amazon ECS container instance (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// To create a compute environment that uses EKS resources, the caller must
// have permissions to call eks:DescribeCluster.
//
// Batch doesn't automatically upgrade the AMIs in a compute environment after
// it's created. For example, it also doesn't update the AMIs in your compute
// environment when a newer version of the Amazon ECS optimized AMI is available.
// You're responsible for the management of the guest operating system. This
// includes any updates and security patches. You're also responsible for any
// additional application software or utilities that you install on the compute
// resources. There are two ways to use a new AMI for your Batch jobs. The original
// method is to complete these steps:
//
// Create a new compute environment with the new AMI.
//
// Add the compute environment to an existing job queue.
//
// Remove the earlier compute environment from your job queue.
//
// Delete the earlier compute environment.
//
// In April 2022, Batch added enhanced support for updating compute environments.
// For more information, see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html).
// To use the enhanced updating of compute environments to update AMIs, follow
// these rules:
//
//   - Either don't set the service role (serviceRole) parameter or set it
//     to the AWSBatchServiceRole service-linked role.
//
//   - Set the allocation strategy (allocationStrategy) parameter to BEST_FIT_PROGRESSIVE,
//     SPOT_CAPACITY_OPTIMIZED, or SPOT_PRICE_CAPACITY_OPTIMIZED.
//
//   - Set the update to latest image version (updateToLatestImageVersion)
//     parameter to true. The updateToLatestImageVersion parameter is used when
//     you update a compute environment. This parameter is ignored when you create
//     a compute environment.
//
//   - Don't specify an AMI ID in imageId, imageIdOverride (in ec2Configuration
//     (https://docs.aws.amazon.com/batch/latest/APIReference/API_Ec2Configuration.html)),
//     or in the launch template (launchTemplate). In that case, Batch selects
//     the latest Amazon ECS optimized AMI that's supported by Batch at the time
//     the infrastructure update is initiated. Alternatively, you can specify
//     the AMI ID in the imageId or imageIdOverride parameters, or the launch
//     template identified by the LaunchTemplate properties. Changing any of
//     these properties starts an infrastructure update. If the AMI ID is specified
//     in the launch template, it can't be replaced by specifying an AMI ID in
//     either the imageId or imageIdOverride parameters. It can only be replaced
//     by specifying a different launch template, or if the launch template version
//     is set to $Default or $Latest, by setting either a new default version
//     for the launch template (if $Default) or by adding a new version to the
//     launch template (if $Latest).
//
// If these rules are followed, any update that starts an infrastructure update
// causes the AMI ID to be re-selected. If the version setting in the launch
// template (launchTemplate) is set to $Latest or $Default, the latest or default
// version of the launch template is evaluated up at the time of the infrastructure
// update, even if the launchTemplate wasn't updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation CreateComputeEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateComputeEnvironment
func (c *Batch) CreateComputeEnvironment(input *CreateComputeEnvironmentInput) (*CreateComputeEnvironmentOutput, error) {
	req, out := c.CreateComputeEnvironmentRequest(input)
	return out, req.Send()
}

// CreateComputeEnvironmentWithContext is the same as CreateComputeEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComputeEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) CreateComputeEnvironmentWithContext(ctx aws.Context, input *CreateComputeEnvironmentInput, opts ...request.Option) (*CreateComputeEnvironmentOutput, error) {
	req, out := c.CreateComputeEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJobQueue = "CreateJobQueue"

// CreateJobQueueRequest generates a "aws/request.Request" representing the
// client's request for the CreateJobQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJobQueue for more information on using the CreateJobQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateJobQueueRequest method.
//	req, resp := client.CreateJobQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateJobQueue
func (c *Batch) CreateJobQueueRequest(input *CreateJobQueueInput) (req *request.Request, output *CreateJobQueueOutput) {
	op := &request.Operation{
		Name:       opCreateJobQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/createjobqueue",
	}

	if input == nil {
		input = &CreateJobQueueInput{}
	}

	output = &CreateJobQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJobQueue API operation for AWS Batch.
//
// Creates an Batch job queue. When you create a job queue, you associate one
// or more compute environments to the queue and assign an order of preference
// for the compute environments.
//
// You also set a priority to the job queue that determines the order that the
// Batch scheduler places jobs onto its associated compute environments. For
// example, if a compute environment is associated with more than one job queue,
// the job queue with a higher priority is given preference for scheduling jobs
// to that compute environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation CreateJobQueue for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateJobQueue
func (c *Batch) CreateJobQueue(input *CreateJobQueueInput) (*CreateJobQueueOutput, error) {
	req, out := c.CreateJobQueueRequest(input)
	return out, req.Send()
}

// CreateJobQueueWithContext is the same as CreateJobQueue with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJobQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) CreateJobQueueWithContext(ctx aws.Context, input *CreateJobQueueInput, opts ...request.Option) (*CreateJobQueueOutput, error) {
	req, out := c.CreateJobQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSchedulingPolicy = "CreateSchedulingPolicy"

// CreateSchedulingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchedulingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchedulingPolicy for more information on using the CreateSchedulingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSchedulingPolicyRequest method.
//	req, resp := client.CreateSchedulingPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateSchedulingPolicy
func (c *Batch) CreateSchedulingPolicyRequest(input *CreateSchedulingPolicyInput) (req *request.Request, output *CreateSchedulingPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateSchedulingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/createschedulingpolicy",
	}

	if input == nil {
		input = &CreateSchedulingPolicyInput{}
	}

	output = &CreateSchedulingPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchedulingPolicy API operation for AWS Batch.
//
// Creates an Batch scheduling policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation CreateSchedulingPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateSchedulingPolicy
func (c *Batch) CreateSchedulingPolicy(input *CreateSchedulingPolicyInput) (*CreateSchedulingPolicyOutput, error) {
	req, out := c.CreateSchedulingPolicyRequest(input)
	return out, req.Send()
}

// CreateSchedulingPolicyWithContext is the same as CreateSchedulingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchedulingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) CreateSchedulingPolicyWithContext(ctx aws.Context, input *CreateSchedulingPolicyInput, opts ...request.Option) (*CreateSchedulingPolicyOutput, error) {
	req, out := c.CreateSchedulingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComputeEnvironment = "DeleteComputeEnvironment"

// DeleteComputeEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComputeEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComputeEnvironment for more information on using the DeleteComputeEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteComputeEnvironmentRequest method.
//	req, resp := client.DeleteComputeEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironment
func (c *Batch) DeleteComputeEnvironmentRequest(input *DeleteComputeEnvironmentInput) (req *request.Request, output *DeleteComputeEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteComputeEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/deletecomputeenvironment",
	}

	if input == nil {
		input = &DeleteComputeEnvironmentInput{}
	}

	output = &DeleteComputeEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteComputeEnvironment API operation for AWS Batch.
//
// Deletes an Batch compute environment.
//
// Before you can delete a compute environment, you must set its state to DISABLED
// with the UpdateComputeEnvironment API operation and disassociate it from
// any job queues with the UpdateJobQueue API operation. Compute environments
// that use Fargate resources must terminate all active jobs on that compute
// environment before deleting the compute environment. If this isn't done,
// the compute environment enters an invalid state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DeleteComputeEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironment
func (c *Batch) DeleteComputeEnvironment(input *DeleteComputeEnvironmentInput) (*DeleteComputeEnvironmentOutput, error) {
	req, out := c.DeleteComputeEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteComputeEnvironmentWithContext is the same as DeleteComputeEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComputeEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DeleteComputeEnvironmentWithContext(ctx aws.Context, input *DeleteComputeEnvironmentInput, opts ...request.Option) (*DeleteComputeEnvironmentOutput, error) {
	req, out := c.DeleteComputeEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJobQueue = "DeleteJobQueue"

// DeleteJobQueueRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJobQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJobQueue for more information on using the DeleteJobQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteJobQueueRequest method.
//	req, resp := client.DeleteJobQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteJobQueue
func (c *Batch) DeleteJobQueueRequest(input *DeleteJobQueueInput) (req *request.Request, output *DeleteJobQueueOutput) {
	op := &request.Operation{
		Name:       opDeleteJobQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/deletejobqueue",
	}

	if input == nil {
		input = &DeleteJobQueueInput{}
	}

	output = &DeleteJobQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteJobQueue API operation for AWS Batch.
//
// Deletes the specified job queue. You must first disable submissions for a
// queue with the UpdateJobQueue operation. All jobs in the queue are eventually
// terminated when you delete a job queue. The jobs are terminated at a rate
// of about 16 jobs each second.
//
// It's not necessary to disassociate compute environments from a queue before
// submitting a DeleteJobQueue request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DeleteJobQueue for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteJobQueue
func (c *Batch) DeleteJobQueue(input *DeleteJobQueueInput) (*DeleteJobQueueOutput, error) {
	req, out := c.DeleteJobQueueRequest(input)
	return out, req.Send()
}

// DeleteJobQueueWithContext is the same as DeleteJobQueue with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJobQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DeleteJobQueueWithContext(ctx aws.Context, input *DeleteJobQueueInput, opts ...request.Option) (*DeleteJobQueueOutput, error) {
	req, out := c.DeleteJobQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchedulingPolicy = "DeleteSchedulingPolicy"

// DeleteSchedulingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchedulingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchedulingPolicy for more information on using the DeleteSchedulingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSchedulingPolicyRequest method.
//	req, resp := client.DeleteSchedulingPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteSchedulingPolicy
func (c *Batch) DeleteSchedulingPolicyRequest(input *DeleteSchedulingPolicyInput) (req *request.Request, output *DeleteSchedulingPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteSchedulingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/deleteschedulingpolicy",
	}

	if input == nil {
		input = &DeleteSchedulingPolicyInput{}
	}

	output = &DeleteSchedulingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSchedulingPolicy API operation for AWS Batch.
//
// Deletes the specified scheduling policy.
//
// You can't delete a scheduling policy that's used in any job queues.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DeleteSchedulingPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteSchedulingPolicy
func (c *Batch) DeleteSchedulingPolicy(input *DeleteSchedulingPolicyInput) (*DeleteSchedulingPolicyOutput, error) {
	req, out := c.DeleteSchedulingPolicyRequest(input)
	return out, req.Send()
}

// DeleteSchedulingPolicyWithContext is the same as DeleteSchedulingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchedulingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DeleteSchedulingPolicyWithContext(ctx aws.Context, input *DeleteSchedulingPolicyInput, opts ...request.Option) (*DeleteSchedulingPolicyOutput, error) {
	req, out := c.DeleteSchedulingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterJobDefinition = "DeregisterJobDefinition"

// DeregisterJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterJobDefinition for more information on using the DeregisterJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterJobDefinitionRequest method.
//	req, resp := client.DeregisterJobDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeregisterJobDefinition
func (c *Batch) DeregisterJobDefinitionRequest(input *DeregisterJobDefinitionInput) (req *request.Request, output *DeregisterJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeregisterJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/deregisterjobdefinition",
	}

	if input == nil {
		input = &DeregisterJobDefinitionInput{}
	}

	output = &DeregisterJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterJobDefinition API operation for AWS Batch.
//
// Deregisters an Batch job definition. Job definitions are permanently deleted
// after 180 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DeregisterJobDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeregisterJobDefinition
func (c *Batch) DeregisterJobDefinition(input *DeregisterJobDefinitionInput) (*DeregisterJobDefinitionOutput, error) {
	req, out := c.DeregisterJobDefinitionRequest(input)
	return out, req.Send()
}

// DeregisterJobDefinitionWithContext is the same as DeregisterJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DeregisterJobDefinitionWithContext(ctx aws.Context, input *DeregisterJobDefinitionInput, opts ...request.Option) (*DeregisterJobDefinitionOutput, error) {
	req, out := c.DeregisterJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComputeEnvironments = "DescribeComputeEnvironments"

// DescribeComputeEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComputeEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComputeEnvironments for more information on using the DescribeComputeEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeComputeEnvironmentsRequest method.
//	req, resp := client.DescribeComputeEnvironmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeComputeEnvironments
func (c *Batch) DescribeComputeEnvironmentsRequest(input *DescribeComputeEnvironmentsInput) (req *request.Request, output *DescribeComputeEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeComputeEnvironments,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/describecomputeenvironments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeComputeEnvironmentsInput{}
	}

	output = &DescribeComputeEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComputeEnvironments API operation for AWS Batch.
//
// Describes one or more of your compute environments.
//
// If you're using an unmanaged compute environment, you can use the DescribeComputeEnvironment
// operation to determine the ecsClusterArn that you launch your Amazon ECS
// container instances into.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DescribeComputeEnvironments for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeComputeEnvironments
func (c *Batch) DescribeComputeEnvironments(input *DescribeComputeEnvironmentsInput) (*DescribeComputeEnvironmentsOutput, error) {
	req, out := c.DescribeComputeEnvironmentsRequest(input)
	return out, req.Send()
}

// DescribeComputeEnvironmentsWithContext is the same as DescribeComputeEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComputeEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeComputeEnvironmentsWithContext(ctx aws.Context, input *DescribeComputeEnvironmentsInput, opts ...request.Option) (*DescribeComputeEnvironmentsOutput, error) {
	req, out := c.DescribeComputeEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeComputeEnvironmentsPages iterates over the pages of a DescribeComputeEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeComputeEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeComputeEnvironments operation.
//	pageNum := 0
//	err := client.DescribeComputeEnvironmentsPages(params,
//	    func(page *batch.DescribeComputeEnvironmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Batch) DescribeComputeEnvironmentsPages(input *DescribeComputeEnvironmentsInput, fn func(*DescribeComputeEnvironmentsOutput, bool) bool) error {
	return c.DescribeComputeEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeComputeEnvironmentsPagesWithContext same as DescribeComputeEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeComputeEnvironmentsPagesWithContext(ctx aws.Context, input *DescribeComputeEnvironmentsInput, fn func(*DescribeComputeEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeComputeEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeComputeEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeComputeEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeJobDefinitions = "DescribeJobDefinitions"

// DescribeJobDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobDefinitions for more information on using the DescribeJobDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJobDefinitionsRequest method.
//	req, resp := client.DescribeJobDefinitionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobDefinitions
func (c *Batch) DescribeJobDefinitionsRequest(input *DescribeJobDefinitionsInput) (req *request.Request, output *DescribeJobDefinitionsOutput) {
	op := &request.Operation{
		Name:       opDescribeJobDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/describejobdefinitions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeJobDefinitionsInput{}
	}

	output = &DescribeJobDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobDefinitions API operation for AWS Batch.
//
// Describes a list of job definitions. You can specify a status (such as ACTIVE)
// to only return job definitions that match that status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DescribeJobDefinitions for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobDefinitions
func (c *Batch) DescribeJobDefinitions(input *DescribeJobDefinitionsInput) (*DescribeJobDefinitionsOutput, error) {
	req, out := c.DescribeJobDefinitionsRequest(input)
	return out, req.Send()
}

// DescribeJobDefinitionsWithContext is the same as DescribeJobDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeJobDefinitionsWithContext(ctx aws.Context, input *DescribeJobDefinitionsInput, opts ...request.Option) (*DescribeJobDefinitionsOutput, error) {
	req, out := c.DescribeJobDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeJobDefinitionsPages iterates over the pages of a DescribeJobDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeJobDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeJobDefinitions operation.
//	pageNum := 0
//	err := client.DescribeJobDefinitionsPages(params,
//	    func(page *batch.DescribeJobDefinitionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Batch) DescribeJobDefinitionsPages(input *DescribeJobDefinitionsInput, fn func(*DescribeJobDefinitionsOutput, bool) bool) error {
	return c.DescribeJobDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeJobDefinitionsPagesWithContext same as DescribeJobDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeJobDefinitionsPagesWithContext(ctx aws.Context, input *DescribeJobDefinitionsInput, fn func(*DescribeJobDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeJobDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeJobDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeJobDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeJobQueues = "DescribeJobQueues"

// DescribeJobQueuesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobQueues for more information on using the DescribeJobQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJobQueuesRequest method.
//	req, resp := client.DescribeJobQueuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobQueues
func (c *Batch) DescribeJobQueuesRequest(input *DescribeJobQueuesInput) (req *request.Request, output *DescribeJobQueuesOutput) {
	op := &request.Operation{
		Name:       opDescribeJobQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/describejobqueues",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeJobQueuesInput{}
	}

	output = &DescribeJobQueuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobQueues API operation for AWS Batch.
//
// Describes one or more of your job queues.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DescribeJobQueues for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobQueues
func (c *Batch) DescribeJobQueues(input *DescribeJobQueuesInput) (*DescribeJobQueuesOutput, error) {
	req, out := c.DescribeJobQueuesRequest(input)
	return out, req.Send()
}

// DescribeJobQueuesWithContext is the same as DescribeJobQueues with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeJobQueuesWithContext(ctx aws.Context, input *DescribeJobQueuesInput, opts ...request.Option) (*DescribeJobQueuesOutput, error) {
	req, out := c.DescribeJobQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeJobQueuesPages iterates over the pages of a DescribeJobQueues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeJobQueues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeJobQueues operation.
//	pageNum := 0
//	err := client.DescribeJobQueuesPages(params,
//	    func(page *batch.DescribeJobQueuesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Batch) DescribeJobQueuesPages(input *DescribeJobQueuesInput, fn func(*DescribeJobQueuesOutput, bool) bool) error {
	return c.DescribeJobQueuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeJobQueuesPagesWithContext same as DescribeJobQueuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeJobQueuesPagesWithContext(ctx aws.Context, input *DescribeJobQueuesInput, fn func(*DescribeJobQueuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeJobQueuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeJobQueuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeJobQueuesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeJobs = "DescribeJobs"

// DescribeJobsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobs for more information on using the DescribeJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJobsRequest method.
//	req, resp := client.DescribeJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobs
func (c *Batch) DescribeJobsRequest(input *DescribeJobsInput) (req *request.Request, output *DescribeJobsOutput) {
	op := &request.Operation{
		Name:       opDescribeJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/describejobs",
	}

	if input == nil {
		input = &DescribeJobsInput{}
	}

	output = &DescribeJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobs API operation for AWS Batch.
//
// Describes a list of Batch jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DescribeJobs for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobs
func (c *Batch) DescribeJobs(input *DescribeJobsInput) (*DescribeJobsOutput, error) {
	req, out := c.DescribeJobsRequest(input)
	return out, req.Send()
}

// DescribeJobsWithContext is the same as DescribeJobs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeJobsWithContext(ctx aws.Context, input *DescribeJobsInput, opts ...request.Option) (*DescribeJobsOutput, error) {
	req, out := c.DescribeJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSchedulingPolicies = "DescribeSchedulingPolicies"

// DescribeSchedulingPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchedulingPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchedulingPolicies for more information on using the DescribeSchedulingPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSchedulingPoliciesRequest method.
//	req, resp := client.DescribeSchedulingPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeSchedulingPolicies
func (c *Batch) DescribeSchedulingPoliciesRequest(input *DescribeSchedulingPoliciesInput) (req *request.Request, output *DescribeSchedulingPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeSchedulingPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/describeschedulingpolicies",
	}

	if input == nil {
		input = &DescribeSchedulingPoliciesInput{}
	}

	output = &DescribeSchedulingPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchedulingPolicies API operation for AWS Batch.
//
// Describes one or more of your scheduling policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DescribeSchedulingPolicies for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeSchedulingPolicies
func (c *Batch) DescribeSchedulingPolicies(input *DescribeSchedulingPoliciesInput) (*DescribeSchedulingPoliciesOutput, error) {
	req, out := c.DescribeSchedulingPoliciesRequest(input)
	return out, req.Send()
}

// DescribeSchedulingPoliciesWithContext is the same as DescribeSchedulingPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchedulingPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeSchedulingPoliciesWithContext(ctx aws.Context, input *DescribeSchedulingPoliciesInput, opts ...request.Option) (*DescribeSchedulingPoliciesOutput, error) {
	req, out := c.DescribeSchedulingPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJobsRequest method.
//	req, resp := client.ListJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListJobs
func (c *Batch) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/listjobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS Batch.
//
// Returns a list of Batch jobs.
//
// You must specify only one of the following items:
//
//   - A job queue ID to return a list of jobs in that job queue
//
//   - A multi-node parallel job ID to return a list of nodes for that job
//
//   - An array job ID to return a list of the children for that job
//
// You can filter the results by job status with the jobStatus parameter. If
// you don't specify a status, only RUNNING jobs are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListJobs
func (c *Batch) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJobs operation.
//	pageNum := 0
//	err := client.ListJobsPages(params,
//	    func(page *batch.ListJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Batch) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchedulingPolicies = "ListSchedulingPolicies"

// ListSchedulingPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListSchedulingPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchedulingPolicies for more information on using the ListSchedulingPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSchedulingPoliciesRequest method.
//	req, resp := client.ListSchedulingPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListSchedulingPolicies
func (c *Batch) ListSchedulingPoliciesRequest(input *ListSchedulingPoliciesInput) (req *request.Request, output *ListSchedulingPoliciesOutput) {
	op := &request.Operation{
		Name:       opListSchedulingPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/listschedulingpolicies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchedulingPoliciesInput{}
	}

	output = &ListSchedulingPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchedulingPolicies API operation for AWS Batch.
//
// Returns a list of Batch scheduling policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation ListSchedulingPolicies for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListSchedulingPolicies
func (c *Batch) ListSchedulingPolicies(input *ListSchedulingPoliciesInput) (*ListSchedulingPoliciesOutput, error) {
	req, out := c.ListSchedulingPoliciesRequest(input)
	return out, req.Send()
}

// ListSchedulingPoliciesWithContext is the same as ListSchedulingPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchedulingPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) ListSchedulingPoliciesWithContext(ctx aws.Context, input *ListSchedulingPoliciesInput, opts ...request.Option) (*ListSchedulingPoliciesOutput, error) {
	req, out := c.ListSchedulingPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchedulingPoliciesPages iterates over the pages of a ListSchedulingPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchedulingPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSchedulingPolicies operation.
//	pageNum := 0
//	err := client.ListSchedulingPoliciesPages(params,
//	    func(page *batch.ListSchedulingPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Batch) ListSchedulingPoliciesPages(input *ListSchedulingPoliciesInput, fn func(*ListSchedulingPoliciesOutput, bool) bool) error {
	return c.ListSchedulingPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchedulingPoliciesPagesWithContext same as ListSchedulingPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) ListSchedulingPoliciesPagesWithContext(ctx aws.Context, input *ListSchedulingPoliciesInput, fn func(*ListSchedulingPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchedulingPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchedulingPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchedulingPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListTagsForResource
func (c *Batch) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Batch.
//
// Lists the tags for an Batch resource. Batch resources that support tags are
// compute environments, jobs, job definitions, job queues, and scheduling policies.
// ARNs for child jobs of array and multi-node parallel (MNP) jobs aren't supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListTagsForResource
func (c *Batch) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterJobDefinition = "RegisterJobDefinition"

// RegisterJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the RegisterJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterJobDefinition for more information on using the RegisterJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterJobDefinitionRequest method.
//	req, resp := client.RegisterJobDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RegisterJobDefinition
func (c *Batch) RegisterJobDefinitionRequest(input *RegisterJobDefinitionInput) (req *request.Request, output *RegisterJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opRegisterJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/registerjobdefinition",
	}

	if input == nil {
		input = &RegisterJobDefinitionInput{}
	}

	output = &RegisterJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterJobDefinition API operation for AWS Batch.
//
// Registers an Batch job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation RegisterJobDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RegisterJobDefinition
func (c *Batch) RegisterJobDefinition(input *RegisterJobDefinitionInput) (*RegisterJobDefinitionOutput, error) {
	req, out := c.RegisterJobDefinitionRequest(input)
	return out, req.Send()
}

// RegisterJobDefinitionWithContext is the same as RegisterJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) RegisterJobDefinitionWithContext(ctx aws.Context, input *RegisterJobDefinitionInput, opts ...request.Option) (*RegisterJobDefinitionOutput, error) {
	req, out := c.RegisterJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubmitJob = "SubmitJob"

// SubmitJobRequest generates a "aws/request.Request" representing the
// client's request for the SubmitJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubmitJob for more information on using the SubmitJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SubmitJobRequest method.
//	req, resp := client.SubmitJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/SubmitJob
func (c *Batch) SubmitJobRequest(input *SubmitJobInput) (req *request.Request, output *SubmitJobOutput) {
	op := &request.Operation{
		Name:       opSubmitJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/submitjob",
	}

	if input == nil {
		input = &SubmitJobInput{}
	}

	output = &SubmitJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SubmitJob API operation for AWS Batch.
//
// Submits an Batch job from a job definition. Parameters that are specified
// during SubmitJob override parameters defined in the job definition. vCPU
// and memory requirements that are specified in the resourceRequirements objects
// in the job definition are the exception. They can't be overridden this way
// using the memory and vcpus parameters. Rather, you must specify updates to
// job definition parameters in a resourceRequirements object that's included
// in the containerOverrides parameter.
//
// Job queues with a scheduling policy are limited to 500 active fair share
// identifiers at a time.
//
// Jobs that run on Fargate resources can't be guaranteed to run for more than
// 14 days. This is because, after 14 days, Fargate resources might become unavailable
// and job might be terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation SubmitJob for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/SubmitJob
func (c *Batch) SubmitJob(input *SubmitJobInput) (*SubmitJobOutput, error) {
	req, out := c.SubmitJobRequest(input)
	return out, req.Send()
}

// SubmitJobWithContext is the same as SubmitJob with the addition of
// the ability to pass a context and additional request options.
//
// See SubmitJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) SubmitJobWithContext(ctx aws.Context, input *SubmitJobInput, opts ...request.Option) (*SubmitJobOutput, error) {
	req, out := c.SubmitJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TagResource
func (c *Batch) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Batch.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource aren't specified in the request parameters,
// they aren't changed. When a resource is deleted, the tags that are associated
// with that resource are deleted as well. Batch resources that support tags
// are compute environments, jobs, job definitions, job queues, and scheduling
// policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs
// aren't supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TagResource
func (c *Batch) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateJob = "TerminateJob"

// TerminateJobRequest generates a "aws/request.Request" representing the
// client's request for the TerminateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateJob for more information on using the TerminateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TerminateJobRequest method.
//	req, resp := client.TerminateJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TerminateJob
func (c *Batch) TerminateJobRequest(input *TerminateJobInput) (req *request.Request, output *TerminateJobOutput) {
	op := &request.Operation{
		Name:       opTerminateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/terminatejob",
	}

	if input == nil {
		input = &TerminateJobInput{}
	}

	output = &TerminateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TerminateJob API operation for AWS Batch.
//
// Terminates a job in a job queue. Jobs that are in the STARTING or RUNNING
// state are terminated, which causes them to transition to FAILED. Jobs that
// have not progressed to the STARTING state are cancelled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation TerminateJob for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TerminateJob
func (c *Batch) TerminateJob(input *TerminateJobInput) (*TerminateJobOutput, error) {
	req, out := c.TerminateJobRequest(input)
	return out, req.Send()
}

// TerminateJobWithContext is the same as TerminateJob with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) TerminateJobWithContext(ctx aws.Context, input *TerminateJobInput, opts ...request.Option) (*TerminateJobOutput, error) {
	req, out := c.TerminateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UntagResource
func (c *Batch) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Batch.
//
// Deletes specified tags from an Batch resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UntagResource
func (c *Batch) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateComputeEnvironment = "UpdateComputeEnvironment"

// UpdateComputeEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComputeEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComputeEnvironment for more information on using the UpdateComputeEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateComputeEnvironmentRequest method.
//	req, resp := client.UpdateComputeEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironment
func (c *Batch) UpdateComputeEnvironmentRequest(input *UpdateComputeEnvironmentInput) (req *request.Request, output *UpdateComputeEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateComputeEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/updatecomputeenvironment",
	}

	if input == nil {
		input = &UpdateComputeEnvironmentInput{}
	}

	output = &UpdateComputeEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateComputeEnvironment API operation for AWS Batch.
//
// Updates an Batch compute environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation UpdateComputeEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironment
func (c *Batch) UpdateComputeEnvironment(input *UpdateComputeEnvironmentInput) (*UpdateComputeEnvironmentOutput, error) {
	req, out := c.UpdateComputeEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateComputeEnvironmentWithContext is the same as UpdateComputeEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComputeEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) UpdateComputeEnvironmentWithContext(ctx aws.Context, input *UpdateComputeEnvironmentInput, opts ...request.Option) (*UpdateComputeEnvironmentOutput, error) {
	req, out := c.UpdateComputeEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJobQueue = "UpdateJobQueue"

// UpdateJobQueueRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJobQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJobQueue for more information on using the UpdateJobQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateJobQueueRequest method.
//	req, resp := client.UpdateJobQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateJobQueue
func (c *Batch) UpdateJobQueueRequest(input *UpdateJobQueueInput) (req *request.Request, output *UpdateJobQueueOutput) {
	op := &request.Operation{
		Name:       opUpdateJobQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/updatejobqueue",
	}

	if input == nil {
		input = &UpdateJobQueueInput{}
	}

	output = &UpdateJobQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateJobQueue API operation for AWS Batch.
//
// Updates a job queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation UpdateJobQueue for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateJobQueue
func (c *Batch) UpdateJobQueue(input *UpdateJobQueueInput) (*UpdateJobQueueOutput, error) {
	req, out := c.UpdateJobQueueRequest(input)
	return out, req.Send()
}

// UpdateJobQueueWithContext is the same as UpdateJobQueue with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJobQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) UpdateJobQueueWithContext(ctx aws.Context, input *UpdateJobQueueInput, opts ...request.Option) (*UpdateJobQueueOutput, error) {
	req, out := c.UpdateJobQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSchedulingPolicy = "UpdateSchedulingPolicy"

// UpdateSchedulingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSchedulingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSchedulingPolicy for more information on using the UpdateSchedulingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSchedulingPolicyRequest method.
//	req, resp := client.UpdateSchedulingPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateSchedulingPolicy
func (c *Batch) UpdateSchedulingPolicyRequest(input *UpdateSchedulingPolicyInput) (req *request.Request, output *UpdateSchedulingPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateSchedulingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/updateschedulingpolicy",
	}

	if input == nil {
		input = &UpdateSchedulingPolicyInput{}
	}

	output = &UpdateSchedulingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSchedulingPolicy API operation for AWS Batch.
//
// Updates a scheduling policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation UpdateSchedulingPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ClientException
//     These errors are usually caused by a client action. One example cause is
//     using an action or resource on behalf of a user that doesn't have permissions
//     to use the action or resource. Another cause is specifying an identifier
//     that's not valid.
//
//   - ServerException
//     These errors are usually caused by a server issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateSchedulingPolicy
func (c *Batch) UpdateSchedulingPolicy(input *UpdateSchedulingPolicyInput) (*UpdateSchedulingPolicyOutput, error) {
	req, out := c.UpdateSchedulingPolicyRequest(input)
	return out, req.Send()
}

// UpdateSchedulingPolicyWithContext is the same as UpdateSchedulingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSchedulingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) UpdateSchedulingPolicyWithContext(ctx aws.Context, input *UpdateSchedulingPolicyInput, opts ...request.Option) (*UpdateSchedulingPolicyOutput, error) {
	req, out := c.UpdateSchedulingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An object that represents an Batch array job.
type ArrayProperties struct {
	_ struct{} `type:"structure"`

	// The size of the array job.
	Size *int64 `locationName:"size" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArrayProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArrayProperties) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *ArrayProperties) SetSize(v int64) *ArrayProperties {
	s.Size = &v
	return s
}

// An object that represents the array properties of a job.
type ArrayPropertiesDetail struct {
	_ struct{} `type:"structure"`

	// The job index within the array that's associated with this job. This parameter
	// is returned for array job children.
	Index *int64 `locationName:"index" type:"integer"`

	// The size of the array job. This parameter is returned for parent array jobs.
	Size *int64 `locationName:"size" type:"integer"`

	// A summary of the number of array job children in each available job status.
	// This parameter is returned for parent array jobs.
	StatusSummary map[string]*int64 `locationName:"statusSummary" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArrayPropertiesDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArrayPropertiesDetail) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *ArrayPropertiesDetail) SetIndex(v int64) *ArrayPropertiesDetail {
	s.Index = &v
	return s
}

// SetSize sets the Size field's value.
func (s *ArrayPropertiesDetail) SetSize(v int64) *ArrayPropertiesDetail {
	s.Size = &v
	return s
}

// SetStatusSummary sets the StatusSummary field's value.
func (s *ArrayPropertiesDetail) SetStatusSummary(v map[string]*int64) *ArrayPropertiesDetail {
	s.StatusSummary = v
	return s
}

// An object that represents the array properties of a job.
type ArrayPropertiesSummary struct {
	_ struct{} `type:"structure"`

	// The job index within the array that's associated with this job. This parameter
	// is returned for children of array jobs.
	Index *int64 `locationName:"index" type:"integer"`

	// The size of the array job. This parameter is returned for parent array jobs.
	Size *int64 `locationName:"size" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArrayPropertiesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArrayPropertiesSummary) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *ArrayPropertiesSummary) SetIndex(v int64) *ArrayPropertiesSummary {
	s.Index = &v
	return s
}

// SetSize sets the Size field's value.
func (s *ArrayPropertiesSummary) SetSize(v int64) *ArrayPropertiesSummary {
	s.Size = &v
	return s
}

// An object that represents the details of a container that's part of a job
// attempt.
type AttemptContainerDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon ECS container instance that
	// hosts the job attempt.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The exit code for the job attempt. A non-zero exit code is considered failed.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The name of the CloudWatch Logs log stream that's associated with the container.
	// The log group for Batch jobs is /aws/batch/job. Each container attempt receives
	// a log stream name when they reach the RUNNING status.
	LogStreamName *string `locationName:"logStreamName" type:"string"`

	// The network interfaces that are associated with the job attempt.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with
	// the job attempt. Each container attempt receives a task ARN when they reach
	// the STARTING status.
	TaskArn *string `locationName:"taskArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttemptContainerDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttemptContainerDetail) GoString() string {
	return s.String()
}

// SetContainerInstanceArn sets the ContainerInstanceArn field's value.
func (s *AttemptContainerDetail) SetContainerInstanceArn(v string) *AttemptContainerDetail {
	s.ContainerInstanceArn = &v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *AttemptContainerDetail) SetExitCode(v int64) *AttemptContainerDetail {
	s.ExitCode = &v
	return s
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *AttemptContainerDetail) SetLogStreamName(v string) *AttemptContainerDetail {
	s.LogStreamName = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *AttemptContainerDetail) SetNetworkInterfaces(v []*NetworkInterface) *AttemptContainerDetail {
	s.NetworkInterfaces = v
	return s
}

// SetReason sets the Reason field's value.
func (s *AttemptContainerDetail) SetReason(v string) *AttemptContainerDetail {
	s.Reason = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *AttemptContainerDetail) SetTaskArn(v string) *AttemptContainerDetail {
	s.TaskArn = &v
	return s
}

// An object that represents a job attempt.
type AttemptDetail struct {
	_ struct{} `type:"structure"`

	// The details for the container in this job attempt.
	Container *AttemptContainerDetail `locationName:"container" type:"structure"`

	// The Unix timestamp (in milliseconds) for when the attempt was started (when
	// the attempt transitioned from the STARTING state to the RUNNING state).
	StartedAt *int64 `locationName:"startedAt" type:"long"`

	// A short, human-readable string to provide additional details for the current
	// status of the job attempt.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The Unix timestamp (in milliseconds) for when the attempt was stopped (when
	// the attempt transitioned from the RUNNING state to a terminal state, such
	// as SUCCEEDED or FAILED).
	StoppedAt *int64 `locationName:"stoppedAt" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttemptDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttemptDetail) GoString() string {
	return s.String()
}

// SetContainer sets the Container field's value.
func (s *AttemptDetail) SetContainer(v *AttemptContainerDetail) *AttemptDetail {
	s.Container = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *AttemptDetail) SetStartedAt(v int64) *AttemptDetail {
	s.StartedAt = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *AttemptDetail) SetStatusReason(v string) *AttemptDetail {
	s.StatusReason = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *AttemptDetail) SetStoppedAt(v int64) *AttemptDetail {
	s.StoppedAt = &v
	return s
}

// Contains the parameters for CancelJob.
type CancelJobInput struct {
	_ struct{} `type:"structure"`

	// The Batch job ID of the job to cancel.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// A message to attach to the job that explains the reason for canceling it.
	// This message is returned by future DescribeJobs operations on the job. This
	// message is also recorded in the Batch activity logs.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelJobInput) SetJobId(v string) *CancelJobInput {
	s.JobId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *CancelJobInput) SetReason(v string) *CancelJobInput {
	s.Reason = &v
	return s
}

type CancelJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobOutput) GoString() string {
	return s.String()
}

// These errors are usually caused by a client action. One example cause is
// using an action or resource on behalf of a user that doesn't have permissions
// to use the action or resource. Another cause is specifying an identifier
// that's not valid.
type ClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) GoString() string {
	return s.String()
}

func newErrorClientException(v protocol.ResponseMetadata) error {
	return &ClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientException) Code() string {
	return "ClientException"
}

// Message returns the exception's message.
func (s *ClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientException) OrigErr() error {
	return nil
}

func (s *ClientException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents an Batch compute environment.
type ComputeEnvironmentDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// ComputeEnvironmentArn is a required field
	ComputeEnvironmentArn *string `locationName:"computeEnvironmentArn" type:"string" required:"true"`

	// The name of the compute environment. It can be up to 128 characters long.
	// It can contain uppercase and lowercase letters, numbers, hyphens (-), and
	// underscores (_).
	//
	// ComputeEnvironmentName is a required field
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string" required:"true"`

	// The compute resources defined for the compute environment. For more information,
	// see Compute environments (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide.
	ComputeResources *ComputeResource `locationName:"computeResources" type:"structure"`

	// The orchestration type of the compute environment. The valid values are ECS
	// (default) or EKS.
	ContainerOrchestrationType *string `locationName:"containerOrchestrationType" type:"string" enum:"OrchestrationType"`

	// The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster that
	// the compute environment uses.
	EcsClusterArn *string `locationName:"ecsClusterArn" type:"string"`

	// The configuration for the Amazon EKS cluster that supports the Batch compute
	// environment. Only specify this parameter if the containerOrchestrationType
	// is EKS.
	EksConfiguration *EksConfiguration `locationName:"eksConfiguration" type:"structure"`

	// The service role that's associated with the compute environment that allows
	// Batch to make calls to Amazon Web Services API operations on your behalf.
	// For more information, see Batch service IAM role (https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html)
	// in the Batch User Guide.
	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The state of the compute environment. The valid values are ENABLED or DISABLED.
	//
	// If the state is ENABLED, then the Batch scheduler can attempt to place jobs
	// from an associated job queue on the compute resources within the environment.
	// If the compute environment is managed, then it can scale its instances out
	// or in automatically based on the job queue demand.
	//
	// If the state is DISABLED, then the Batch scheduler doesn't attempt to place
	// jobs within the environment. Jobs in a STARTING or RUNNING state continue
	// to progress normally. Managed compute environments in the DISABLED state
	// don't scale out.
	//
	// Compute environments in a DISABLED state may continue to incur billing charges.
	// To prevent additional charges, turn off and then delete the compute environment.
	// For more information, see State (https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state)
	// in the Batch User Guide.
	//
	// When an instance is idle, the instance scales down to the minvCpus value.
	// However, the instance size doesn't change. For example, consider a c5.8xlarge
	// instance with a minvCpus value of 4 and a desiredvCpus value of 36. This
	// instance doesn't scale down to a c5.large instance.
	State *string `locationName:"state" type:"string" enum:"CEState"`

	// The current status of the compute environment (for example, CREATING or VALID).
	Status *string `locationName:"status" type:"string" enum:"CEStatus"`

	// A short, human-readable string to provide additional details for the current
	// status of the compute environment.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The tags applied to the compute environment.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The type of the compute environment: MANAGED or UNMANAGED. For more information,
	// see Compute environments (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide.
	Type *string `locationName:"type" type:"string" enum:"CEType"`

	// The maximum number of VCPUs expected to be used for an unmanaged compute
	// environment.
	UnmanagedvCpus *int64 `locationName:"unmanagedvCpus" type:"integer"`

	// Specifies the infrastructure update policy for the compute environment. For
	// more information about infrastructure updates, see Updating compute environments
	// (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	UpdatePolicy *UpdatePolicy `locationName:"updatePolicy" type:"structure"`

	// Unique identifier for the compute environment.
	Uuid *string `locationName:"uuid" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeEnvironmentDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeEnvironmentDetail) GoString() string {
	return s.String()
}

// SetComputeEnvironmentArn sets the ComputeEnvironmentArn field's value.
func (s *ComputeEnvironmentDetail) SetComputeEnvironmentArn(v string) *ComputeEnvironmentDetail {
	s.ComputeEnvironmentArn = &v
	return s
}

// SetComputeEnvironmentName sets the ComputeEnvironmentName field's value.
func (s *ComputeEnvironmentDetail) SetComputeEnvironmentName(v string) *ComputeEnvironmentDetail {
	s.ComputeEnvironmentName = &v
	return s
}

// SetComputeResources sets the ComputeResources field's value.
func (s *ComputeEnvironmentDetail) SetComputeResources(v *ComputeResource) *ComputeEnvironmentDetail {
	s.ComputeResources = v
	return s
}

// SetContainerOrchestrationType sets the ContainerOrchestrationType field's value.
func (s *ComputeEnvironmentDetail) SetContainerOrchestrationType(v string) *ComputeEnvironmentDetail {
	s.ContainerOrchestrationType = &v
	return s
}

// SetEcsClusterArn sets the EcsClusterArn field's value.
func (s *ComputeEnvironmentDetail) SetEcsClusterArn(v string) *ComputeEnvironmentDetail {
	s.EcsClusterArn = &v
	return s
}

// SetEksConfiguration sets the EksConfiguration field's value.
func (s *ComputeEnvironmentDetail) SetEksConfiguration(v *EksConfiguration) *ComputeEnvironmentDetail {
	s.EksConfiguration = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *ComputeEnvironmentDetail) SetServiceRole(v string) *ComputeEnvironmentDetail {
	s.ServiceRole = &v
	return s
}

// SetState sets the State field's value.
func (s *ComputeEnvironmentDetail) SetState(v string) *ComputeEnvironmentDetail {
	s.State = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ComputeEnvironmentDetail) SetStatus(v string) *ComputeEnvironmentDetail {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ComputeEnvironmentDetail) SetStatusReason(v string) *ComputeEnvironmentDetail {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ComputeEnvironmentDetail) SetTags(v map[string]*string) *ComputeEnvironmentDetail {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ComputeEnvironmentDetail) SetType(v string) *ComputeEnvironmentDetail {
	s.Type = &v
	return s
}

// SetUnmanagedvCpus sets the UnmanagedvCpus field's value.
func (s *ComputeEnvironmentDetail) SetUnmanagedvCpus(v int64) *ComputeEnvironmentDetail {
	s.UnmanagedvCpus = &v
	return s
}

// SetUpdatePolicy sets the UpdatePolicy field's value.
func (s *ComputeEnvironmentDetail) SetUpdatePolicy(v *UpdatePolicy) *ComputeEnvironmentDetail {
	s.UpdatePolicy = v
	return s
}

// SetUuid sets the Uuid field's value.
func (s *ComputeEnvironmentDetail) SetUuid(v string) *ComputeEnvironmentDetail {
	s.Uuid = &v
	return s
}

// The order that compute environments are tried in for job placement within
// a queue. Compute environments are tried in ascending order. For example,
// if two compute environments are associated with a job queue, the compute
// environment with a lower order integer value is tried for job placement first.
// Compute environments must be in the VALID state before you can associate
// them with a job queue. All of the compute environments must be either EC2
// (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT); Amazon EC2 and Fargate
// compute environments can't be mixed.
//
// All compute environments that are associated with a job queue must share
// the same architecture. Batch doesn't support mixing compute environment architecture
// types in a single job queue.
type ComputeEnvironmentOrder struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// ComputeEnvironment is a required field
	ComputeEnvironment *string `locationName:"computeEnvironment" type:"string" required:"true"`

	// The order of the compute environment. Compute environments are tried in ascending
	// order. For example, if two compute environments are associated with a job
	// queue, the compute environment with a lower order integer value is tried
	// for job placement first.
	//
	// Order is a required field
	Order *int64 `locationName:"order" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeEnvironmentOrder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeEnvironmentOrder) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeEnvironmentOrder) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputeEnvironmentOrder"}
	if s.ComputeEnvironment == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironment"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironment sets the ComputeEnvironment field's value.
func (s *ComputeEnvironmentOrder) SetComputeEnvironment(v string) *ComputeEnvironmentOrder {
	s.ComputeEnvironment = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *ComputeEnvironmentOrder) SetOrder(v int64) *ComputeEnvironmentOrder {
	s.Order = &v
	return s
}

// An object that represents an Batch compute resource. For more information,
// see Compute environments (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
// in the Batch User Guide.
type ComputeResource struct {
	_ struct{} `type:"structure"`

	// The allocation strategy to use for the compute resource if not enough instances
	// of the best fitting instance type can be allocated. This might be because
	// of availability of the instance type in the Region or Amazon EC2 service
	// limits (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html).
	// For more information, see Allocation strategies (https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// BEST_FIT (default)
	//
	// Batch selects an instance type that best fits the needs of the jobs with
	// a preference for the lowest-cost instance type. If additional instances of
	// the selected instance type aren't available, Batch waits for the additional
	// instances to be available. If there aren't enough instances available or
	// the user is reaching Amazon EC2 service limits (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html),
	// additional jobs aren't run until the currently running jobs are completed.
	// This allocation strategy keeps costs lower but can limit scaling. If you're
	// using Spot Fleets with BEST_FIT, the Spot Fleet IAM Role must be specified.
	// Compute resources that use a BEST_FIT allocation strategy don't support infrastructure
	// updates and can't update some parameters. For more information, see Updating
	// compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// BEST_FIT_PROGRESSIVE
	//
	// Batch selects additional instance types that are large enough to meet the
	// requirements of the jobs in the queue. Its preference is for instance types
	// with lower cost vCPUs. If additional instances of the previously selected
	// instance types aren't available, Batch selects new instance types.
	//
	// SPOT_CAPACITY_OPTIMIZED
	//
	// Batch selects one or more instance types that are large enough to meet the
	// requirements of the jobs in the queue. Its preference is for instance types
	// that are less likely to be interrupted. This allocation strategy is only
	// available for Spot Instance compute resources.
	//
	// SPOT_PRICE_CAPACITY_OPTIMIZED
	//
	// The price and capacity optimized allocation strategy looks at both price
	// and capacity to select the Spot Instance pools that are the least likely
	// to be interrupted and have the lowest possible price. This allocation strategy
	// is only available for Spot Instance compute resources.
	//
	// With BEST_FIT_PROGRESSIVE,SPOT_CAPACITY_OPTIMIZED and SPOT_PRICE_CAPACITY_OPTIMIZED
	// (recommended) strategies using On-Demand or Spot Instances, and the BEST_FIT
	// strategy using Spot Instances, Batch might need to exceed maxvCpus to meet
	// your capacity requirements. In this event, Batch never exceeds maxvCpus by
	// more than a single instance.
	AllocationStrategy *string `locationName:"allocationStrategy" type:"string" enum:"CRAllocationStrategy"`

	// The maximum percentage that a Spot Instance price can be when compared with
	// the On-Demand price for that instance type before instances are launched.
	// For example, if your maximum percentage is 20%, then the Spot price must
	// be less than 20% of the current On-Demand price for that Amazon EC2 instance.
	// You always pay the lowest (market) price and never more than your maximum
	// percentage. If you leave this field empty, the default value is 100% of the
	// On-Demand price. For most use cases, we recommend leaving this field empty.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	BidPercentage *int64 `locationName:"bidPercentage" type:"integer"`

	// The desired number of vCPUS in the compute environment. Batch modifies this
	// value between the minimum and maximum values based on job queue demand.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	DesiredvCpus *int64 `locationName:"desiredvCpus" type:"integer"`

	// Provides information that's used to select Amazon Machine Images (AMIs) for
	// Amazon EC2 instances in the compute environment. If Ec2Configuration isn't
	// specified, the default is ECS_AL2.
	//
	// One or two values can be provided.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	Ec2Configuration []*Ec2Configuration `locationName:"ec2Configuration" type:"list"`

	// The Amazon EC2 key pair that's used for instances launched in the compute
	// environment. You can use this key pair to log in to your instances with SSH.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	Ec2KeyPair *string `locationName:"ec2KeyPair" type:"string"`

	// The Amazon Machine Image (AMI) ID used for instances launched in the compute
	// environment. This parameter is overridden by the imageIdOverride member of
	// the Ec2Configuration structure.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// The AMI that you choose for a compute environment must match the architecture
	// of the instance types that you intend to use for that compute environment.
	// For example, if your compute environment uses A1 instance types, the compute
	// resource AMI that you choose must support ARM instances. Amazon ECS vends
	// both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI.
	// For more information, see Amazon ECS-optimized Amazon Linux 2 AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// Deprecated: This field is deprecated, use ec2Configuration[].imageIdOverride instead.
	ImageId *string `locationName:"imageId" deprecated:"true" type:"string"`

	// The Amazon ECS instance profile applied to Amazon EC2 instances in a compute
	// environment. This parameter is required for Amazon EC2 instances types. You
	// can specify the short name or full Amazon Resource Name (ARN) of an instance
	// profile. For example, ecsInstanceRole or arn:aws:iam::<aws_account_id>:instance-profile/ecsInstanceRole
	// . For more information, see Amazon ECS instance role (https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	InstanceRole *string `locationName:"instanceRole" type:"string"`

	// The instances types that can be launched. You can specify instance families
	// to launch any instance type within those families (for example, c5 or p3),
	// or you can specify specific sizes within a family (such as c5.8xlarge). You
	// can also choose optimal to select instance types (from the C4, M4, and R4
	// instance families) that match the demand of your job queues.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// When you create a compute environment, the instance types that you select
	// for the compute environment must share the same architecture. For example,
	// you can't mix x86 and ARM instances in the same compute environment.
	//
	// Currently, optimal uses instance types from the C4, M4, and R4 instance families.
	// In Regions that don't have instance types from those instance families, instance
	// types from the C5, M5, and R5 instance families are used.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The launch template to use for your compute resources. Any other compute
	// resource parameters that you specify in a CreateComputeEnvironment (https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html)
	// API operation override the same parameters in the launch template. You must
	// specify either the launch template ID or launch template name in the request,
	// but not both. For more information, see Launch template support (https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The maximum number of vCPUs that a compute environment can support.
	//
	// With BEST_FIT_PROGRESSIVE,SPOT_CAPACITY_OPTIMIZED and SPOT_PRICE_CAPACITY_OPTIMIZED
	// (recommended) strategies using On-Demand or Spot Instances, and the BEST_FIT
	// strategy using Spot Instances, Batch might need to exceed maxvCpus to meet
	// your capacity requirements. In this event, Batch never exceeds maxvCpus by
	// more than a single instance.
	//
	// MaxvCpus is a required field
	MaxvCpus *int64 `locationName:"maxvCpus" type:"integer" required:"true"`

	// The minimum number of vCPUs that a compute environment should maintain (even
	// if the compute environment is DISABLED).
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	MinvCpus *int64 `locationName:"minvCpus" type:"integer"`

	// The Amazon EC2 placement group to associate with your compute resources.
	// If you intend to submit multi-node parallel jobs to your compute environment,
	// you should consider creating a cluster placement group and associate it with
	// your compute resources. This keeps your multi-node parallel job on a logical
	// grouping of instances within a single Availability Zone with high network
	// flow potential. For more information, see Placement groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	PlacementGroup *string `locationName:"placementGroup" type:"string"`

	// The Amazon EC2 security groups that are associated with instances launched
	// in the compute environment. One or more security groups must be specified,
	// either in securityGroupIds or using a launch template referenced in launchTemplate.
	// This parameter is required for jobs that are running on Fargate resources
	// and must contain at least one security group. Fargate doesn't support launch
	// templates. If security groups are specified using both securityGroupIds and
	// launchTemplate, the values in securityGroupIds are used.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied
	// to a SPOT compute environment. This role is required if the allocation strategy
	// set to BEST_FIT or if the allocation strategy isn't specified. For more information,
	// see Amazon EC2 spot fleet role (https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// To tag your Spot Instances on creation, the Spot Fleet IAM role specified
	// here must use the newer AmazonEC2SpotFleetTaggingRole managed policy. The
	// previously recommended AmazonEC2SpotFleetRole managed policy doesn't have
	// the required permissions to tag Spot Instances. For more information, see
	// Spot instances not tagged on creation (https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag)
	// in the Batch User Guide.
	SpotIamFleetRole *string `locationName:"spotIamFleetRole" type:"string"`

	// The VPC subnets where the compute resources are launched. These subnets must
	// be within the same VPC. Fargate compute resources can contain up to 16 subnets.
	// For more information, see VPCs and subnets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
	// in the Amazon VPC User Guide.
	//
	// Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more
	// information, see Local Zones (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones)
	// in the Amazon EC2 User Guide for Linux Instances, Amazon EKS and Amazon Web
	// Services Local Zones (https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html)
	// in the Amazon EKS User Guide and Amazon ECS clusters in Local Zones, Wavelength
	// Zones, and Amazon Web Services Outposts (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones)
	// in the Amazon ECS Developer Guide.
	//
	// Batch on Fargate doesn't currently support Local Zones.
	//
	// Subnets is a required field
	Subnets []*string `locationName:"subnets" type:"list" required:"true"`

	// Key-value pair tags to be applied to Amazon EC2 resources that are launched
	// in the compute environment. For Batch, these take the form of "String1":
	// "String2", where String1 is the tag key and String2 is the tag value-for
	// example, { "Name": "Batch Instance - C4OnDemand" }. This is helpful for recognizing
	// your Batch instances in the Amazon EC2 console. Updating these tags requires
	// an infrastructure update to the compute environment. For more information,
	// see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide. These tags aren't seen when using the Batch ListTagsForResource
	// API operation.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of compute environment: EC2, SPOT, FARGATE, or FARGATE_SPOT. For
	// more information, see Compute environments (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide.
	//
	// If you choose SPOT, you must also specify an Amazon EC2 Spot Fleet role with
	// the spotIamFleetRole parameter. For more information, see Amazon EC2 spot
	// fleet role (https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html)
	// in the Batch User Guide.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CRType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputeResource"}
	if s.MaxvCpus == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxvCpus"))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Ec2Configuration != nil {
		for i, v := range s.Ec2Configuration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ec2Configuration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocationStrategy sets the AllocationStrategy field's value.
func (s *ComputeResource) SetAllocationStrategy(v string) *ComputeResource {
	s.AllocationStrategy = &v
	return s
}

// SetBidPercentage sets the BidPercentage field's value.
func (s *ComputeResource) SetBidPercentage(v int64) *ComputeResource {
	s.BidPercentage = &v
	return s
}

// SetDesiredvCpus sets the DesiredvCpus field's value.
func (s *ComputeResource) SetDesiredvCpus(v int64) *ComputeResource {
	s.DesiredvCpus = &v
	return s
}

// SetEc2Configuration sets the Ec2Configuration field's value.
func (s *ComputeResource) SetEc2Configuration(v []*Ec2Configuration) *ComputeResource {
	s.Ec2Configuration = v
	return s
}

// SetEc2KeyPair sets the Ec2KeyPair field's value.
func (s *ComputeResource) SetEc2KeyPair(v string) *ComputeResource {
	s.Ec2KeyPair = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *ComputeResource) SetImageId(v string) *ComputeResource {
	s.ImageId = &v
	return s
}

// SetInstanceRole sets the InstanceRole field's value.
func (s *ComputeResource) SetInstanceRole(v string) *ComputeResource {
	s.InstanceRole = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *ComputeResource) SetInstanceTypes(v []*string) *ComputeResource {
	s.InstanceTypes = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *ComputeResource) SetLaunchTemplate(v *LaunchTemplateSpecification) *ComputeResource {
	s.LaunchTemplate = v
	return s
}

// SetMaxvCpus sets the MaxvCpus field's value.
func (s *ComputeResource) SetMaxvCpus(v int64) *ComputeResource {
	s.MaxvCpus = &v
	return s
}

// SetMinvCpus sets the MinvCpus field's value.
func (s *ComputeResource) SetMinvCpus(v int64) *ComputeResource {
	s.MinvCpus = &v
	return s
}

// SetPlacementGroup sets the PlacementGroup field's value.
func (s *ComputeResource) SetPlacementGroup(v string) *ComputeResource {
	s.PlacementGroup = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *ComputeResource) SetSecurityGroupIds(v []*string) *ComputeResource {
	s.SecurityGroupIds = v
	return s
}

// SetSpotIamFleetRole sets the SpotIamFleetRole field's value.
func (s *ComputeResource) SetSpotIamFleetRole(v string) *ComputeResource {
	s.SpotIamFleetRole = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *ComputeResource) SetSubnets(v []*string) *ComputeResource {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ComputeResource) SetTags(v map[string]*string) *ComputeResource {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ComputeResource) SetType(v string) *ComputeResource {
	s.Type = &v
	return s
}

// An object that represents the attributes of a compute environment that can
// be updated. For more information, see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
// in the Batch User Guide.
type ComputeResourceUpdate struct {
	_ struct{} `type:"structure"`

	// The allocation strategy to use for the compute resource if there's not enough
	// instances of the best fitting instance type that can be allocated. This might
	// be because of availability of the instance type in the Region or Amazon EC2
	// service limits (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html).
	// For more information, see Allocation strategies (https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html)
	// in the Batch User Guide.
	//
	// When updating a compute environment, changing the allocation strategy requires
	// an infrastructure update of the compute environment. For more information,
	// see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide. BEST_FIT isn't supported when updating a compute
	// environment.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// BEST_FIT_PROGRESSIVE
	//
	// Batch selects additional instance types that are large enough to meet the
	// requirements of the jobs in the queue. Its preference is for instance types
	// with lower cost vCPUs. If additional instances of the previously selected
	// instance types aren't available, Batch selects new instance types.
	//
	// SPOT_CAPACITY_OPTIMIZED
	//
	// Batch selects one or more instance types that are large enough to meet the
	// requirements of the jobs in the queue. Its preference is for instance types
	// that are less likely to be interrupted. This allocation strategy is only
	// available for Spot Instance compute resources.
	//
	// SPOT_PRICE_CAPACITY_OPTIMIZED
	//
	// The price and capacity optimized allocation strategy looks at both price
	// and capacity to select the Spot Instance pools that are the least likely
	// to be interrupted and have the lowest possible price. This allocation strategy
	// is only available for Spot Instance compute resources.
	//
	// With BEST_FIT_PROGRESSIVE,SPOT_CAPACITY_OPTIMIZED and SPOT_PRICE_CAPACITY_OPTIMIZED
	// (recommended) strategies using On-Demand or Spot Instances, and the BEST_FIT
	// strategy using Spot Instances, Batch might need to exceed maxvCpus to meet
	// your capacity requirements. In this event, Batch never exceeds maxvCpus by
	// more than a single instance.
	AllocationStrategy *string `locationName:"allocationStrategy" type:"string" enum:"CRUpdateAllocationStrategy"`

	// The maximum percentage that a Spot Instance price can be when compared with
	// the On-Demand price for that instance type before instances are launched.
	// For example, if your maximum percentage is 20%, the Spot price must be less
	// than 20% of the current On-Demand price for that Amazon EC2 instance. You
	// always pay the lowest (market) price and never more than your maximum percentage.
	// For most use cases, we recommend leaving this field empty.
	//
	// When updating a compute environment, changing the bid percentage requires
	// an infrastructure update of the compute environment. For more information,
	// see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	BidPercentage *int64 `locationName:"bidPercentage" type:"integer"`

	// The desired number of vCPUS in the compute environment. Batch modifies this
	// value between the minimum and maximum values based on job queue demand.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// Batch doesn't support changing the desired number of vCPUs of an existing
	// compute environment. Don't specify this parameter for compute environments
	// using Amazon EKS clusters.
	//
	// When you update the desiredvCpus setting, the value must be between the minvCpus
	// and maxvCpus values.
	//
	// Additionally, the updated desiredvCpus value must be greater than or equal
	// to the current desiredvCpus value. For more information, see Troubleshooting
	// Batch (https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update)
	// in the Batch User Guide.
	DesiredvCpus *int64 `locationName:"desiredvCpus" type:"integer"`

	// Provides information used to select Amazon Machine Images (AMIs) for Amazon
	// EC2 instances in the compute environment. If Ec2Configuration isn't specified,
	// the default is ECS_AL2.
	//
	// When updating a compute environment, changing this setting requires an infrastructure
	// update of the compute environment. For more information, see Updating compute
	// environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide. To remove the Amazon EC2 configuration and any custom
	// AMI ID specified in imageIdOverride, set this value to an empty string.
	//
	// One or two values can be provided.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	Ec2Configuration []*Ec2Configuration `locationName:"ec2Configuration" type:"list"`

	// The Amazon EC2 key pair that's used for instances launched in the compute
	// environment. You can use this key pair to log in to your instances with SSH.
	// To remove the Amazon EC2 key pair, set this value to an empty string.
	//
	// When updating a compute environment, changing the Amazon EC2 key pair requires
	// an infrastructure update of the compute environment. For more information,
	// see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	Ec2KeyPair *string `locationName:"ec2KeyPair" type:"string"`

	// The Amazon Machine Image (AMI) ID used for instances launched in the compute
	// environment. This parameter is overridden by the imageIdOverride member of
	// the Ec2Configuration structure. To remove the custom AMI ID and use the default
	// AMI ID, set this value to an empty string.
	//
	// When updating a compute environment, changing the AMI ID requires an infrastructure
	// update of the compute environment. For more information, see Updating compute
	// environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// The AMI that you choose for a compute environment must match the architecture
	// of the instance types that you intend to use for that compute environment.
	// For example, if your compute environment uses A1 instance types, the compute
	// resource AMI that you choose must support ARM instances. Amazon ECS vends
	// both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI.
	// For more information, see Amazon ECS-optimized Amazon Linux 2 AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ImageId *string `locationName:"imageId" type:"string"`

	// The Amazon ECS instance profile applied to Amazon EC2 instances in a compute
	// environment. Required for Amazon EC2 instances. You can specify the short
	// name or full Amazon Resource Name (ARN) of an instance profile. For example,
	// ecsInstanceRole or arn:aws:iam::<aws_account_id>:instance-profile/ecsInstanceRole
	// . For more information, see Amazon ECS instance role (https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html)
	// in the Batch User Guide.
	//
	// When updating a compute environment, changing this setting requires an infrastructure
	// update of the compute environment. For more information, see Updating compute
	// environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	InstanceRole *string `locationName:"instanceRole" type:"string"`

	// The instances types that can be launched. You can specify instance families
	// to launch any instance type within those families (for example, c5 or p3),
	// or you can specify specific sizes within a family (such as c5.8xlarge). You
	// can also choose optimal to select instance types (from the C4, M4, and R4
	// instance families) that match the demand of your job queues.
	//
	// When updating a compute environment, changing this setting requires an infrastructure
	// update of the compute environment. For more information, see Updating compute
	// environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// When you create a compute environment, the instance types that you select
	// for the compute environment must share the same architecture. For example,
	// you can't mix x86 and ARM instances in the same compute environment.
	//
	// Currently, optimal uses instance types from the C4, M4, and R4 instance families.
	// In Regions that don't have instance types from those instance families, instance
	// types from the C5, M5, and R5 instance families are used.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The updated launch template to use for your compute resources. You must specify
	// either the launch template ID or launch template name in the request, but
	// not both. For more information, see Launch template support (https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html)
	// in the Batch User Guide. To remove the custom launch template and use the
	// default launch template, set launchTemplateId or launchTemplateName member
	// of the launch template specification to an empty string. Removing the launch
	// template from a compute environment will not remove the AMI specified in
	// the launch template. In order to update the AMI specified in a launch template,
	// the updateToLatestImageVersion parameter must be set to true.
	//
	// When updating a compute environment, changing the launch template requires
	// an infrastructure update of the compute environment. For more information,
	// see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The maximum number of Amazon EC2 vCPUs that an environment can reach.
	//
	// With BEST_FIT_PROGRESSIVE,SPOT_CAPACITY_OPTIMIZED and SPOT_PRICE_CAPACITY_OPTIMIZED
	// (recommended) strategies using On-Demand or Spot Instances, and the BEST_FIT
	// strategy using Spot Instances, Batch might need to exceed maxvCpus to meet
	// your capacity requirements. In this event, Batch never exceeds maxvCpus by
	// more than a single instance.
	MaxvCpus *int64 `locationName:"maxvCpus" type:"integer"`

	// The minimum number of vCPUs that an environment should maintain (even if
	// the compute environment is DISABLED).
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	MinvCpus *int64 `locationName:"minvCpus" type:"integer"`

	// The Amazon EC2 placement group to associate with your compute resources.
	// If you intend to submit multi-node parallel jobs to your compute environment,
	// you should consider creating a cluster placement group and associate it with
	// your compute resources. This keeps your multi-node parallel job on a logical
	// grouping of instances within a single Availability Zone with high network
	// flow potential. For more information, see Placement groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// When updating a compute environment, changing the placement group requires
	// an infrastructure update of the compute environment. For more information,
	// see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	PlacementGroup *string `locationName:"placementGroup" type:"string"`

	// The Amazon EC2 security groups that are associated with instances launched
	// in the compute environment. This parameter is required for Fargate compute
	// resources, where it can contain up to 5 security groups. For Fargate compute
	// resources, providing an empty list is handled as if this parameter wasn't
	// specified and no change is made. For Amazon EC2 compute resources, providing
	// an empty list removes the security groups from the compute resource.
	//
	// When updating a compute environment, changing the Amazon EC2 security groups
	// requires an infrastructure update of the compute environment. For more information,
	// see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The VPC subnets where the compute resources are launched. Fargate compute
	// resources can contain up to 16 subnets. For Fargate compute resources, providing
	// an empty list will be handled as if this parameter wasn't specified and no
	// change is made. For Amazon EC2 compute resources, providing an empty list
	// removes the VPC subnets from the compute resource. For more information,
	// see VPCs and subnets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
	// in the Amazon VPC User Guide.
	//
	// When updating a compute environment, changing the VPC subnets requires an
	// infrastructure update of the compute environment. For more information, see
	// Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more
	// information, see Local Zones (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones)
	// in the Amazon EC2 User Guide for Linux Instances, Amazon EKS and Amazon Web
	// Services Local Zones (https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html)
	// in the Amazon EKS User Guide and Amazon ECS clusters in Local Zones, Wavelength
	// Zones, and Amazon Web Services Outposts (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones)
	// in the Amazon ECS Developer Guide.
	//
	// Batch on Fargate doesn't currently support Local Zones.
	Subnets []*string `locationName:"subnets" type:"list"`

	// Key-value pair tags to be applied to Amazon EC2 resources that are launched
	// in the compute environment. For Batch, these take the form of "String1":
	// "String2", where String1 is the tag key and String2 is the tag value-for
	// example, { "Name": "Batch Instance - C4OnDemand" }. This is helpful for recognizing
	// your Batch instances in the Amazon EC2 console. These tags aren't seen when
	// using the Batch ListTagsForResource API operation.
	//
	// When updating a compute environment, changing this setting requires an infrastructure
	// update of the compute environment. For more information, see Updating compute
	// environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of compute environment: EC2, SPOT, FARGATE, or FARGATE_SPOT. For
	// more information, see Compute environments (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide.
	//
	// If you choose SPOT, you must also specify an Amazon EC2 Spot Fleet role with
	// the spotIamFleetRole parameter. For more information, see Amazon EC2 spot
	// fleet role (https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html)
	// in the Batch User Guide.
	//
	// When updating a compute environment, changing the type of a compute environment
	// requires an infrastructure update of the compute environment. For more information,
	// see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	Type *string `locationName:"type" type:"string" enum:"CRType"`

	// Specifies whether the AMI ID is updated to the latest one that's supported
	// by Batch when the compute environment has an infrastructure update. The default
	// value is false.
	//
	// An AMI ID can either be specified in the imageId or imageIdOverride parameters
	// or be determined by the launch template that's specified in the launchTemplate
	// parameter. If an AMI ID is specified any of these ways, this parameter is
	// ignored. For more information about to update AMI IDs during an infrastructure
	// update, see Updating the AMI ID (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami)
	// in the Batch User Guide.
	//
	// When updating a compute environment, changing this setting requires an infrastructure
	// update of the compute environment. For more information, see Updating compute
	// environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	UpdateToLatestImageVersion *bool `locationName:"updateToLatestImageVersion" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeResourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeResourceUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeResourceUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputeResourceUpdate"}
	if s.Ec2Configuration != nil {
		for i, v := range s.Ec2Configuration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ec2Configuration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocationStrategy sets the AllocationStrategy field's value.
func (s *ComputeResourceUpdate) SetAllocationStrategy(v string) *ComputeResourceUpdate {
	s.AllocationStrategy = &v
	return s
}

// SetBidPercentage sets the BidPercentage field's value.
func (s *ComputeResourceUpdate) SetBidPercentage(v int64) *ComputeResourceUpdate {
	s.BidPercentage = &v
	return s
}

// SetDesiredvCpus sets the DesiredvCpus field's value.
func (s *ComputeResourceUpdate) SetDesiredvCpus(v int64) *ComputeResourceUpdate {
	s.DesiredvCpus = &v
	return s
}

// SetEc2Configuration sets the Ec2Configuration field's value.
func (s *ComputeResourceUpdate) SetEc2Configuration(v []*Ec2Configuration) *ComputeResourceUpdate {
	s.Ec2Configuration = v
	return s
}

// SetEc2KeyPair sets the Ec2KeyPair field's value.
func (s *ComputeResourceUpdate) SetEc2KeyPair(v string) *ComputeResourceUpdate {
	s.Ec2KeyPair = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *ComputeResourceUpdate) SetImageId(v string) *ComputeResourceUpdate {
	s.ImageId = &v
	return s
}

// SetInstanceRole sets the InstanceRole field's value.
func (s *ComputeResourceUpdate) SetInstanceRole(v string) *ComputeResourceUpdate {
	s.InstanceRole = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *ComputeResourceUpdate) SetInstanceTypes(v []*string) *ComputeResourceUpdate {
	s.InstanceTypes = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *ComputeResourceUpdate) SetLaunchTemplate(v *LaunchTemplateSpecification) *ComputeResourceUpdate {
	s.LaunchTemplate = v
	return s
}

// SetMaxvCpus sets the MaxvCpus field's value.
func (s *ComputeResourceUpdate) SetMaxvCpus(v int64) *ComputeResourceUpdate {
	s.MaxvCpus = &v
	return s
}

// SetMinvCpus sets the MinvCpus field's value.
func (s *ComputeResourceUpdate) SetMinvCpus(v int64) *ComputeResourceUpdate {
	s.MinvCpus = &v
	return s
}

// SetPlacementGroup sets the PlacementGroup field's value.
func (s *ComputeResourceUpdate) SetPlacementGroup(v string) *ComputeResourceUpdate {
	s.PlacementGroup = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *ComputeResourceUpdate) SetSecurityGroupIds(v []*string) *ComputeResourceUpdate {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *ComputeResourceUpdate) SetSubnets(v []*string) *ComputeResourceUpdate {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ComputeResourceUpdate) SetTags(v map[string]*string) *ComputeResourceUpdate {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ComputeResourceUpdate) SetType(v string) *ComputeResourceUpdate {
	s.Type = &v
	return s
}

// SetUpdateToLatestImageVersion sets the UpdateToLatestImageVersion field's value.
func (s *ComputeResourceUpdate) SetUpdateToLatestImageVersion(v bool) *ComputeResourceUpdate {
	s.UpdateToLatestImageVersion = &v
	return s
}

// An object that represents the details of a container that's part of a job.
type ContainerDetail struct {
	_ struct{} `type:"structure"`

	// The command that's passed to the container.
	Command []*string `locationName:"command" type:"list"`

	// The Amazon Resource Name (ARN) of the container instance that the container
	// is running on.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The environment variables to pass to a container.
	//
	// Environment variables cannot start with "AWS_BATCH". This naming convention
	// is reserved for variables that Batch sets.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// The amount of ephemeral storage allocated for the task. This parameter is
	// used to expand the total amount of ephemeral storage available, beyond the
	// default amount, for tasks hosted on Fargate.
	EphemeralStorage *EphemeralStorage `locationName:"ephemeralStorage" type:"structure"`

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume.
	// For more information, see Batch execution IAM role (https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html)
	// in the Batch User Guide.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// The exit code returned upon completion.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The platform configuration for jobs that are running on Fargate resources.
	// Jobs that are running on Amazon EC2 resources must not specify this parameter.
	FargatePlatformConfiguration *FargatePlatformConfiguration `locationName:"fargatePlatformConfiguration" type:"structure"`

	// The image used to start the container.
	Image *string `locationName:"image" type:"string"`

	// The instance type of the underlying host infrastructure of a multi-node parallel
	// job.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The Amazon Resource Name (ARN) that's associated with the job when run.
	JobRoleArn *string `locationName:"jobRoleArn" type:"string"`

	// Linux-specific modifications that are applied to the container, such as details
	// for device mappings.
	LinuxParameters *LinuxParameters `locationName:"linuxParameters" type:"structure"`

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --log-driver option to docker run (https://docs.docker.com/engine/reference/run/).
	// By default, containers use the same logging driver that the Docker daemon
	// uses. However, the container might use a different logging driver than the
	// Docker daemon by specifying a log driver with this parameter in the container
	// definition. To use a different logging driver for a container, the log system
	// must be configured properly on the container instance. Or, alternatively,
	// it must be configured on a different log server for remote logging options.
	// For more information on the options for different supported log drivers,
	// see Configure logging drivers (https://docs.docker.com/engine/admin/logging/overview/)
	// in the Docker documentation.
	//
	// Batch currently supports a subset of the logging drivers available to the
	// Docker daemon (shown in the LogConfiguration (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html)
	// data type). Additional log drivers might be available in future releases
	// of the Amazon ECS container agent.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version | grep "Server API version"
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the ECS_AVAILABLE_LOGGING_DRIVERS
	// environment variable before containers placed on that instance can use these
	// log configuration options. For more information, see Amazon ECS container
	// agent configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LogConfiguration *LogConfiguration `locationName:"logConfiguration" type:"structure"`

	// The name of the Amazon CloudWatch Logs log stream that's associated with
	// the container. The log group for Batch jobs is /aws/batch/job. Each container
	// attempt receives a log stream name when they reach the RUNNING status.
	LogStreamName *string `locationName:"logStreamName" type:"string"`

	// For jobs running on Amazon EC2 resources that didn't specify memory requirements
	// using resourceRequirements, the number of MiB of memory reserved for the
	// job. For other jobs, including all run on Fargate resources, see resourceRequirements.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The mount points for data volumes in your container.
	MountPoints []*MountPoint `locationName:"mountPoints" type:"list"`

	// The network configuration for jobs that are running on Fargate resources.
	// Jobs that are running on Amazon EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The network interfaces that are associated with the job.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// When this parameter is true, the container is given elevated permissions
	// on the host container instance (similar to the root user). The default value
	// is false.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided, or specified as false.
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of
	// the Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --read-only option to docker run (https://docs.docker.com/engine/reference/commandline/run/).
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials `locationName:"repositoryCredentials" type:"structure"`

	// The type and amount of resources to assign to a container. The supported
	// resources include GPU, MEMORY, and VCPU.
	ResourceRequirements []*ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// An object that represents the compute environment architecture for Batch
	// jobs on Fargate.
	RuntimePlatform *RuntimePlatform `locationName:"runtimePlatform" type:"structure"`

	// The secrets to pass to the container. For more information, see Specifying
	// sensitive data (https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
	// in the Batch User Guide.
	Secrets []*Secret `locationName:"secrets" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with
	// the container job. Each container attempt receives a task ARN when they reach
	// the STARTING status.
	TaskArn *string `locationName:"taskArn" type:"string"`

	// A list of ulimit values to set in the container. This parameter maps to Ulimits
	// in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --ulimit option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	Ulimits []*Ulimit `locationName:"ulimits" type:"list"`

	// The user name to use inside the container. This parameter maps to User in
	// the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --user option to docker run (https://docs.docker.com/engine/reference/run/).
	User *string `locationName:"user" type:"string"`

	// The number of vCPUs reserved for the container. For jobs that run on Amazon
	// EC2 resources, you can specify the vCPU requirement for the job using resourceRequirements,
	// but you can't specify the vCPU requirements in both the vcpus and resourceRequirements
	// object. This parameter maps to CpuShares in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --cpu-shares option to docker run (https://docs.docker.com/engine/reference/run/).
	// Each vCPU is equivalent to 1,024 CPU shares. You must specify at least one
	// vCPU. This is required but can be specified in several places. It must be
	// specified for each node at least once.
	//
	// This parameter isn't applicable to jobs that run on Fargate resources. For
	// jobs that run on Fargate resources, you must specify the vCPU requirement
	// for the job using resourceRequirements.
	Vcpus *int64 `locationName:"vcpus" type:"integer"`

	// A list of volumes that are associated with the job.
	Volumes []*Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerDetail) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *ContainerDetail) SetCommand(v []*string) *ContainerDetail {
	s.Command = v
	return s
}

// SetContainerInstanceArn sets the ContainerInstanceArn field's value.
func (s *ContainerDetail) SetContainerInstanceArn(v string) *ContainerDetail {
	s.ContainerInstanceArn = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerDetail) SetEnvironment(v []*KeyValuePair) *ContainerDetail {
	s.Environment = v
	return s
}

// SetEphemeralStorage sets the EphemeralStorage field's value.
func (s *ContainerDetail) SetEphemeralStorage(v *EphemeralStorage) *ContainerDetail {
	s.EphemeralStorage = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *ContainerDetail) SetExecutionRoleArn(v string) *ContainerDetail {
	s.ExecutionRoleArn = &v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *ContainerDetail) SetExitCode(v int64) *ContainerDetail {
	s.ExitCode = &v
	return s
}

// SetFargatePlatformConfiguration sets the FargatePlatformConfiguration field's value.
func (s *ContainerDetail) SetFargatePlatformConfiguration(v *FargatePlatformConfiguration) *ContainerDetail {
	s.FargatePlatformConfiguration = v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerDetail) SetImage(v string) *ContainerDetail {
	s.Image = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ContainerDetail) SetInstanceType(v string) *ContainerDetail {
	s.InstanceType = &v
	return s
}

// SetJobRoleArn sets the JobRoleArn field's value.
func (s *ContainerDetail) SetJobRoleArn(v string) *ContainerDetail {
	s.JobRoleArn = &v
	return s
}

// SetLinuxParameters sets the LinuxParameters field's value.
func (s *ContainerDetail) SetLinuxParameters(v *LinuxParameters) *ContainerDetail {
	s.LinuxParameters = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *ContainerDetail) SetLogConfiguration(v *LogConfiguration) *ContainerDetail {
	s.LogConfiguration = v
	return s
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *ContainerDetail) SetLogStreamName(v string) *ContainerDetail {
	s.LogStreamName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ContainerDetail) SetMemory(v int64) *ContainerDetail {
	s.Memory = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *ContainerDetail) SetMountPoints(v []*MountPoint) *ContainerDetail {
	s.MountPoints = v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *ContainerDetail) SetNetworkConfiguration(v *NetworkConfiguration) *ContainerDetail {
	s.NetworkConfiguration = v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *ContainerDetail) SetNetworkInterfaces(v []*NetworkInterface) *ContainerDetail {
	s.NetworkInterfaces = v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *ContainerDetail) SetPrivileged(v bool) *ContainerDetail {
	s.Privileged = &v
	return s
}

// SetReadonlyRootFilesystem sets the ReadonlyRootFilesystem field's value.
func (s *ContainerDetail) SetReadonlyRootFilesystem(v bool) *ContainerDetail {
	s.ReadonlyRootFilesystem = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ContainerDetail) SetReason(v string) *ContainerDetail {
	s.Reason = &v
	return s
}

// SetRepositoryCredentials sets the RepositoryCredentials field's value.
func (s *ContainerDetail) SetRepositoryCredentials(v *RepositoryCredentials) *ContainerDetail {
	s.RepositoryCredentials = v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *ContainerDetail) SetResourceRequirements(v []*ResourceRequirement) *ContainerDetail {
	s.ResourceRequirements = v
	return s
}

// SetRuntimePlatform sets the RuntimePlatform field's value.
func (s *ContainerDetail) SetRuntimePlatform(v *RuntimePlatform) *ContainerDetail {
	s.RuntimePlatform = v
	return s
}

// SetSecrets sets the Secrets field's value.
func (s *ContainerDetail) SetSecrets(v []*Secret) *ContainerDetail {
	s.Secrets = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *ContainerDetail) SetTaskArn(v string) *ContainerDetail {
	s.TaskArn = &v
	return s
}

// SetUlimits sets the Ulimits field's value.
func (s *ContainerDetail) SetUlimits(v []*Ulimit) *ContainerDetail {
	s.Ulimits = v
	return s
}

// SetUser sets the User field's value.
func (s *ContainerDetail) SetUser(v string) *ContainerDetail {
	s.User = &v
	return s
}

// SetVcpus sets the Vcpus field's value.
func (s *ContainerDetail) SetVcpus(v int64) *ContainerDetail {
	s.Vcpus = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *ContainerDetail) SetVolumes(v []*Volume) *ContainerDetail {
	s.Volumes = v
	return s
}

// The overrides that should be sent to a container.
//
// For information about using Batch overrides when you connect event sources
// to targets, see BatchContainerOverrides (https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_BatchContainerOverrides.html).
type ContainerOverrides struct {
	_ struct{} `type:"structure"`

	// The command to send to the container that overrides the default command from
	// the Docker image or the job definition.
	//
	// This parameter can't contain an empty string.
	Command []*string `locationName:"command" type:"list"`

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override
	// the existing environment variables from the Docker image or the job definition.
	//
	// Environment variables cannot start with "AWS_BATCH". This naming convention
	// is reserved for variables that Batch sets.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// The instance type to use for a multi-node parallel job.
	//
	// This parameter isn't applicable to single-node container jobs or jobs that
	// run on Fargate resources, and shouldn't be provided.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// This parameter is deprecated, use resourceRequirements to override the memory
	// requirements specified in the job definition. It's not supported for jobs
	// running on Fargate resources. For jobs that run on Amazon EC2 resources,
	// it overrides the memory parameter set in the job definition, but doesn't
	// override any memory requirement that's specified in the resourceRequirements
	// structure in the job definition. To override memory requirements that are
	// specified in the resourceRequirements structure in the job definition, resourceRequirements
	// must be specified in the SubmitJob request, with type set to MEMORY and value
	// set to the new value. For more information, see Can't override job definition
	// resource requirements (https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements)
	// in the Batch User Guide.
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Memory *int64 `locationName:"memory" deprecated:"true" type:"integer"`

	// The type and amount of resources to assign to a container. This overrides
	// the settings in the job definition. The supported resources include GPU,
	// MEMORY, and VCPU.
	ResourceRequirements []*ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// This parameter is deprecated, use resourceRequirements to override the vcpus
	// parameter that's set in the job definition. It's not supported for jobs running
	// on Fargate resources. For jobs that run on Amazon EC2 resources, it overrides
	// the vcpus parameter set in the job definition, but doesn't override any vCPU
	// requirement specified in the resourceRequirements structure in the job definition.
	// To override vCPU requirements that are specified in the resourceRequirements
	// structure in the job definition, resourceRequirements must be specified in
	// the SubmitJob request, with type set to VCPU and value set to the new value.
	// For more information, see Can't override job definition resource requirements
	// (https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements)
	// in the Batch User Guide.
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Vcpus *int64 `locationName:"vcpus" deprecated:"true" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerOverrides) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerOverrides) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerOverrides"}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *ContainerOverrides) SetCommand(v []*string) *ContainerOverrides {
	s.Command = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerOverrides) SetEnvironment(v []*KeyValuePair) *ContainerOverrides {
	s.Environment = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ContainerOverrides) SetInstanceType(v string) *ContainerOverrides {
	s.InstanceType = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ContainerOverrides) SetMemory(v int64) *ContainerOverrides {
	s.Memory = &v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *ContainerOverrides) SetResourceRequirements(v []*ResourceRequirement) *ContainerOverrides {
	s.ResourceRequirements = v
	return s
}

// SetVcpus sets the Vcpus field's value.
func (s *ContainerOverrides) SetVcpus(v int64) *ContainerOverrides {
	s.Vcpus = &v
	return s
}

// Container properties are used for Amazon ECS based job definitions. These
// properties to describe the container that's launched as part of a job.
type ContainerProperties struct {
	_ struct{} `type:"structure"`

	// The command that's passed to the container. This parameter maps to Cmd in
	// the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the COMMAND parameter to docker run (https://docs.docker.com/engine/reference/run/).
	// For more information, see https://docs.docker.com/engine/reference/builder/#cmd
	// (https://docs.docker.com/engine/reference/builder/#cmd).
	Command []*string `locationName:"command" type:"list"`

	// The environment variables to pass to a container. This parameter maps to
	// Env in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --env option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// We don't recommend using plaintext environment variables for sensitive information,
	// such as credential data.
	//
	// Environment variables cannot start with "AWS_BATCH". This naming convention
	// is reserved for variables that Batch sets.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// The amount of ephemeral storage to allocate for the task. This parameter
	// is used to expand the total amount of ephemeral storage available, beyond
	// the default amount, for tasks hosted on Fargate.
	EphemeralStorage *EphemeralStorage `locationName:"ephemeralStorage" type:"structure"`

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume.
	// For jobs that run on Fargate resources, you must provide an execution role.
	// For more information, see Batch execution IAM role (https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html)
	// in the Batch User Guide.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// The platform configuration for jobs that are running on Fargate resources.
	// Jobs that are running on Amazon EC2 resources must not specify this parameter.
	FargatePlatformConfiguration *FargatePlatformConfiguration `locationName:"fargatePlatformConfiguration" type:"structure"`

	// Required. The image used to start a container. This string is passed directly
	// to the Docker daemon. Images in the Docker Hub registry are available by
	// default. Other repositories are specified with repository-url/image:tag .
	// It can be 255 characters long. It can contain uppercase and lowercase letters,
	// numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes
	// (/), and number signs (#). This parameter maps to Image in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of
	// the Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// IMAGE parameter of docker run (https://docs.docker.com/engine/reference/run/).
	//
	// Docker image architecture must match the processor architecture of the compute
	// resources that they're scheduled on. For example, ARM-based Docker images
	// can only run on ARM-based compute resources.
	//
	//    * Images in Amazon ECR Public repositories use the full registry/repository[:tag]
	//    or registry/repository[@digest] naming conventions. For example, public.ecr.aws/registry_alias/my-web-app:latest .
	//
	//    * Images in Amazon ECR repositories use the full registry and repository
	//    URI (for example, 123456789012.dkr.ecr.<region-name>.amazonaws.com/<repository-name>).
	//
	//    * Images in official repositories on Docker Hub use a single name (for
	//    example, ubuntu or mongo).
	//
	//    * Images in other repositories on Docker Hub are qualified with an organization
	//    name (for example, amazon/amazon-ecs-agent).
	//
	//    * Images in other online repositories are qualified further by a domain
	//    name (for example, quay.io/assemblyline/ubuntu).
	Image *string `locationName:"image" type:"string"`

	// The instance type to use for a multi-node parallel job. All node groups in
	// a multi-node parallel job must use the same instance type.
	//
	// This parameter isn't applicable to single-node container jobs or jobs that
	// run on Fargate resources, and shouldn't be provided.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that the container can assume
	// for Amazon Web Services permissions. For more information, see IAM roles
	// for tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	JobRoleArn *string `locationName:"jobRoleArn" type:"string"`

	// Linux-specific modifications that are applied to the container, such as details
	// for device mappings.
	LinuxParameters *LinuxParameters `locationName:"linuxParameters" type:"structure"`

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --log-driver option to docker run (https://docs.docker.com/engine/reference/run/).
	// By default, containers use the same logging driver that the Docker daemon
	// uses. However the container might use a different logging driver than the
	// Docker daemon by specifying a log driver with this parameter in the container
	// definition. To use a different logging driver for a container, the log system
	// must be configured properly on the container instance (or on a different
	// log server for remote logging options). For more information on the options
	// for different supported log drivers, see Configure logging drivers (https://docs.docker.com/engine/admin/logging/overview/)
	// in the Docker documentation.
	//
	// Batch currently supports a subset of the logging drivers available to the
	// Docker daemon (shown in the LogConfiguration (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html)
	// data type).
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version | grep "Server API version"
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the ECS_AVAILABLE_LOGGING_DRIVERS
	// environment variable before containers placed on that instance can use these
	// log configuration options. For more information, see Amazon ECS container
	// agent configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LogConfiguration *LogConfiguration `locationName:"logConfiguration" type:"structure"`

	// This parameter is deprecated, use resourceRequirements to specify the memory
	// requirements for the job definition. It's not supported for jobs running
	// on Fargate resources. For jobs that run on Amazon EC2 resources, it specifies
	// the memory hard limit (in MiB) for a container. If your container attempts
	// to exceed the specified number, it's terminated. You must specify at least
	// 4 MiB of memory for a job using this parameter. The memory hard limit can
	// be specified in several places. It must be specified for each node at least
	// once.
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Memory *int64 `locationName:"memory" deprecated:"true" type:"integer"`

	// The mount points for data volumes in your container. This parameter maps
	// to Volumes in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --volume option to docker run (https://docs.docker.com/engine/reference/run/).
	MountPoints []*MountPoint `locationName:"mountPoints" type:"list"`

	// The network configuration for jobs that are running on Fargate resources.
	// Jobs that are running on Amazon EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// When this parameter is true, the container is given elevated permissions
	// on the host container instance (similar to the root user). This parameter
	// maps to Privileged in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --privileged option to docker run (https://docs.docker.com/engine/reference/run/).
	// The default value is false.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided, or specified as false.
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of
	// the Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --read-only option to docker run.
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials `locationName:"repositoryCredentials" type:"structure"`

	// The type and amount of resources to assign to a container. The supported
	// resources include GPU, MEMORY, and VCPU.
	ResourceRequirements []*ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// An object that represents the compute environment architecture for Batch
	// jobs on Fargate.
	RuntimePlatform *RuntimePlatform `locationName:"runtimePlatform" type:"structure"`

	// The secrets for the container. For more information, see Specifying sensitive
	// data (https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
	// in the Batch User Guide.
	Secrets []*Secret `locationName:"secrets" type:"list"`

	// A list of ulimits to set in the container. This parameter maps to Ulimits
	// in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --ulimit option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided.
	Ulimits []*Ulimit `locationName:"ulimits" type:"list"`

	// The user name to use inside the container. This parameter maps to User in
	// the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --user option to docker run (https://docs.docker.com/engine/reference/run/).
	User *string `locationName:"user" type:"string"`

	// This parameter is deprecated, use resourceRequirements to specify the vCPU
	// requirements for the job definition. It's not supported for jobs running
	// on Fargate resources. For jobs running on Amazon EC2 resources, it specifies
	// the number of vCPUs reserved for the job.
	//
	// Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to CpuShares
	// in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --cpu-shares option to docker run (https://docs.docker.com/engine/reference/run/).
	// The number of vCPUs must be specified but can be specified in several places.
	// You must specify it at least once for each node.
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Vcpus *int64 `locationName:"vcpus" deprecated:"true" type:"integer"`

	// A list of data volumes used in a job.
	Volumes []*Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerProperties"}
	if s.EphemeralStorage != nil {
		if err := s.EphemeralStorage.Validate(); err != nil {
			invalidParams.AddNested("EphemeralStorage", err.(request.ErrInvalidParams))
		}
	}
	if s.LinuxParameters != nil {
		if err := s.LinuxParameters.Validate(); err != nil {
			invalidParams.AddNested("LinuxParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.LogConfiguration != nil {
		if err := s.LogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RepositoryCredentials != nil {
		if err := s.RepositoryCredentials.Validate(); err != nil {
			invalidParams.AddNested("RepositoryCredentials", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Secrets != nil {
		for i, v := range s.Secrets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Secrets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ulimits != nil {
		for i, v := range s.Ulimits {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ulimits", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Volumes != nil {
		for i, v := range s.Volumes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Volumes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *ContainerProperties) SetCommand(v []*string) *ContainerProperties {
	s.Command = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerProperties) SetEnvironment(v []*KeyValuePair) *ContainerProperties {
	s.Environment = v
	return s
}

// SetEphemeralStorage sets the EphemeralStorage field's value.
func (s *ContainerProperties) SetEphemeralStorage(v *EphemeralStorage) *ContainerProperties {
	s.EphemeralStorage = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *ContainerProperties) SetExecutionRoleArn(v string) *ContainerProperties {
	s.ExecutionRoleArn = &v
	return s
}

// SetFargatePlatformConfiguration sets the FargatePlatformConfiguration field's value.
func (s *ContainerProperties) SetFargatePlatformConfiguration(v *FargatePlatformConfiguration) *ContainerProperties {
	s.FargatePlatformConfiguration = v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerProperties) SetImage(v string) *ContainerProperties {
	s.Image = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ContainerProperties) SetInstanceType(v string) *ContainerProperties {
	s.InstanceType = &v
	return s
}

// SetJobRoleArn sets the JobRoleArn field's value.
func (s *ContainerProperties) SetJobRoleArn(v string) *ContainerProperties {
	s.JobRoleArn = &v
	return s
}

// SetLinuxParameters sets the LinuxParameters field's value.
func (s *ContainerProperties) SetLinuxParameters(v *LinuxParameters) *ContainerProperties {
	s.LinuxParameters = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *ContainerProperties) SetLogConfiguration(v *LogConfiguration) *ContainerProperties {
	s.LogConfiguration = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ContainerProperties) SetMemory(v int64) *ContainerProperties {
	s.Memory = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *ContainerProperties) SetMountPoints(v []*MountPoint) *ContainerProperties {
	s.MountPoints = v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *ContainerProperties) SetNetworkConfiguration(v *NetworkConfiguration) *ContainerProperties {
	s.NetworkConfiguration = v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *ContainerProperties) SetPrivileged(v bool) *ContainerProperties {
	s.Privileged = &v
	return s
}

// SetReadonlyRootFilesystem sets the ReadonlyRootFilesystem field's value.
func (s *ContainerProperties) SetReadonlyRootFilesystem(v bool) *ContainerProperties {
	s.ReadonlyRootFilesystem = &v
	return s
}

// SetRepositoryCredentials sets the RepositoryCredentials field's value.
func (s *ContainerProperties) SetRepositoryCredentials(v *RepositoryCredentials) *ContainerProperties {
	s.RepositoryCredentials = v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *ContainerProperties) SetResourceRequirements(v []*ResourceRequirement) *ContainerProperties {
	s.ResourceRequirements = v
	return s
}

// SetRuntimePlatform sets the RuntimePlatform field's value.
func (s *ContainerProperties) SetRuntimePlatform(v *RuntimePlatform) *ContainerProperties {
	s.RuntimePlatform = v
	return s
}

// SetSecrets sets the Secrets field's value.
func (s *ContainerProperties) SetSecrets(v []*Secret) *ContainerProperties {
	s.Secrets = v
	return s
}

// SetUlimits sets the Ulimits field's value.
func (s *ContainerProperties) SetUlimits(v []*Ulimit) *ContainerProperties {
	s.Ulimits = v
	return s
}

// SetUser sets the User field's value.
func (s *ContainerProperties) SetUser(v string) *ContainerProperties {
	s.User = &v
	return s
}

// SetVcpus sets the Vcpus field's value.
func (s *ContainerProperties) SetVcpus(v int64) *ContainerProperties {
	s.Vcpus = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *ContainerProperties) SetVolumes(v []*Volume) *ContainerProperties {
	s.Volumes = v
	return s
}

// An object that represents summary details of a container within a job.
type ContainerSummary struct {
	_ struct{} `type:"structure"`

	// The exit code to return upon completion.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerSummary) GoString() string {
	return s.String()
}

// SetExitCode sets the ExitCode field's value.
func (s *ContainerSummary) SetExitCode(v int64) *ContainerSummary {
	s.ExitCode = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ContainerSummary) SetReason(v string) *ContainerSummary {
	s.Reason = &v
	return s
}

// Contains the parameters for CreateComputeEnvironment.
type CreateComputeEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name for your compute environment. It can be up to 128 characters long.
	// It can contain uppercase and lowercase letters, numbers, hyphens (-), and
	// underscores (_).
	//
	// ComputeEnvironmentName is a required field
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string" required:"true"`

	// Details about the compute resources managed by the compute environment. This
	// parameter is required for managed compute environments. For more information,
	// see Compute Environments (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide.
	ComputeResources *ComputeResource `locationName:"computeResources" type:"structure"`

	// The details for the Amazon EKS cluster that supports the compute environment.
	EksConfiguration *EksConfiguration `locationName:"eksConfiguration" type:"structure"`

	// The full Amazon Resource Name (ARN) of the IAM role that allows Batch to
	// make calls to other Amazon Web Services services on your behalf. For more
	// information, see Batch service IAM role (https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html)
	// in the Batch User Guide.
	//
	// If your account already created the Batch service-linked role, that role
	// is used by default for your compute environment unless you specify a different
	// role here. If the Batch service-linked role doesn't exist in your account,
	// and no role is specified here, the service attempts to create the Batch service-linked
	// role in your account.
	//
	// If your specified role has a path other than /, then you must specify either
	// the full role ARN (recommended) or prefix the role name with the path. For
	// example, if a role with the name bar has a path of /foo/, specify /foo/bar
	// as the role name. For more information, see Friendly names and paths (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names)
	// in the IAM User Guide.
	//
	// Depending on how you created your Batch service role, its ARN might contain
	// the service-role path prefix. When you only specify the name of the service
	// role, Batch assumes that your ARN doesn't use the service-role path prefix.
	// Because of this, we recommend that you specify the full ARN of your service
	// role when you create compute environments.
	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The state of the compute environment. If the state is ENABLED, then the compute
	// environment accepts jobs from a queue and can scale out automatically based
	// on queues.
	//
	// If the state is ENABLED, then the Batch scheduler can attempt to place jobs
	// from an associated job queue on the compute resources within the environment.
	// If the compute environment is managed, then it can scale its instances out
	// or in automatically, based on the job queue demand.
	//
	// If the state is DISABLED, then the Batch scheduler doesn't attempt to place
	// jobs within the environment. Jobs in a STARTING or RUNNING state continue
	// to progress normally. Managed compute environments in the DISABLED state
	// don't scale out.
	//
	// Compute environments in a DISABLED state may continue to incur billing charges.
	// To prevent additional charges, turn off and then delete the compute environment.
	// For more information, see State (https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state)
	// in the Batch User Guide.
	//
	// When an instance is idle, the instance scales down to the minvCpus value.
	// However, the instance size doesn't change. For example, consider a c5.8xlarge
	// instance with a minvCpus value of 4 and a desiredvCpus value of 36. This
	// instance doesn't scale down to a c5.large instance.
	State *string `locationName:"state" type:"string" enum:"CEState"`

	// The tags that you apply to the compute environment to help you categorize
	// and organize your resources. Each tag consists of a key and an optional value.
	// For more information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in Amazon Web Services General Reference.
	//
	// These tags can be updated or removed using the TagResource (https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html)
	// and UntagResource (https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html)
	// API operations. These tags don't propagate to the underlying compute resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The type of the compute environment: MANAGED or UNMANAGED. For more information,
	// see Compute Environments (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CEType"`

	// The maximum number of vCPUs for an unmanaged compute environment. This parameter
	// is only used for fair share scheduling to reserve vCPU capacity for new share
	// identifiers. If this parameter isn't provided for a fair share job queue,
	// no vCPU capacity is reserved.
	//
	// This parameter is only supported when the type parameter is set to UNMANAGED.
	UnmanagedvCpus *int64 `locationName:"unmanagedvCpus" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComputeEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComputeEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComputeEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComputeEnvironmentInput"}
	if s.ComputeEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironmentName"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ComputeResources != nil {
		if err := s.ComputeResources.Validate(); err != nil {
			invalidParams.AddNested("ComputeResources", err.(request.ErrInvalidParams))
		}
	}
	if s.EksConfiguration != nil {
		if err := s.EksConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EksConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironmentName sets the ComputeEnvironmentName field's value.
func (s *CreateComputeEnvironmentInput) SetComputeEnvironmentName(v string) *CreateComputeEnvironmentInput {
	s.ComputeEnvironmentName = &v
	return s
}

// SetComputeResources sets the ComputeResources field's value.
func (s *CreateComputeEnvironmentInput) SetComputeResources(v *ComputeResource) *CreateComputeEnvironmentInput {
	s.ComputeResources = v
	return s
}

// SetEksConfiguration sets the EksConfiguration field's value.
func (s *CreateComputeEnvironmentInput) SetEksConfiguration(v *EksConfiguration) *CreateComputeEnvironmentInput {
	s.EksConfiguration = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *CreateComputeEnvironmentInput) SetServiceRole(v string) *CreateComputeEnvironmentInput {
	s.ServiceRole = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateComputeEnvironmentInput) SetState(v string) *CreateComputeEnvironmentInput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateComputeEnvironmentInput) SetTags(v map[string]*string) *CreateComputeEnvironmentInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateComputeEnvironmentInput) SetType(v string) *CreateComputeEnvironmentInput {
	s.Type = &v
	return s
}

// SetUnmanagedvCpus sets the UnmanagedvCpus field's value.
func (s *CreateComputeEnvironmentInput) SetUnmanagedvCpus(v int64) *CreateComputeEnvironmentInput {
	s.UnmanagedvCpus = &v
	return s
}

type CreateComputeEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	ComputeEnvironmentArn *string `locationName:"computeEnvironmentArn" type:"string"`

	// The name of the compute environment. It can be up to 128 characters long.
	// It can contain uppercase and lowercase letters, numbers, hyphens (-), and
	// underscores (_).
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComputeEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComputeEnvironmentOutput) GoString() string {
	return s.String()
}

// SetComputeEnvironmentArn sets the ComputeEnvironmentArn field's value.
func (s *CreateComputeEnvironmentOutput) SetComputeEnvironmentArn(v string) *CreateComputeEnvironmentOutput {
	s.ComputeEnvironmentArn = &v
	return s
}

// SetComputeEnvironmentName sets the ComputeEnvironmentName field's value.
func (s *CreateComputeEnvironmentOutput) SetComputeEnvironmentName(v string) *CreateComputeEnvironmentOutput {
	s.ComputeEnvironmentName = &v
	return s
}

// Contains the parameters for CreateJobQueue.
type CreateJobQueueInput struct {
	_ struct{} `type:"structure"`

	// The set of compute environments mapped to a job queue and their order relative
	// to each other. The job scheduler uses this parameter to determine which compute
	// environment runs a specific job. Compute environments must be in the VALID
	// state before you can associate them with a job queue. You can associate up
	// to three compute environments with a job queue. All of the compute environments
	// must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT); EC2
	// and Fargate compute environments can't be mixed.
	//
	// All compute environments that are associated with a job queue must share
	// the same architecture. Batch doesn't support mixing compute environment architecture
	// types in a single job queue.
	//
	// ComputeEnvironmentOrder is a required field
	ComputeEnvironmentOrder []*ComputeEnvironmentOrder `locationName:"computeEnvironmentOrder" type:"list" required:"true"`

	// The name of the job queue. It can be up to 128 letters long. It can contain
	// uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
	//
	// JobQueueName is a required field
	JobQueueName *string `locationName:"jobQueueName" type:"string" required:"true"`

	// The priority of the job queue. Job queues with a higher priority (or a higher
	// integer value for the priority parameter) are evaluated first when associated
	// with the same compute environment. Priority is determined in descending order.
	// For example, a job queue with a priority value of 10 is given scheduling
	// preference over a job queue with a priority value of 1. All of the compute
	// environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT);
	// EC2 and Fargate compute environments can't be mixed.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the fair share scheduling policy. If this
	// parameter is specified, the job queue uses a fair share scheduling policy.
	// If this parameter isn't specified, the job queue uses a first in, first out
	// (FIFO) scheduling policy. After a job queue is created, you can replace but
	// can't remove the fair share scheduling policy. The format is aws:Partition:batch:Region:Account:scheduling-policy/Name
	// . An example is aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy.
	SchedulingPolicyArn *string `locationName:"schedulingPolicyArn" type:"string"`

	// The state of the job queue. If the job queue state is ENABLED, it is able
	// to accept jobs. If the job queue state is DISABLED, new jobs can't be added
	// to the queue, but jobs already in the queue can finish.
	State *string `locationName:"state" type:"string" enum:"JQState"`

	// The tags that you apply to the job queue to help you categorize and organize
	// your resources. Each tag consists of a key and an optional value. For more
	// information, see Tagging your Batch resources (https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html)
	// in Batch User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobQueueInput"}
	if s.ComputeEnvironmentOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironmentOrder"))
	}
	if s.JobQueueName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobQueueName"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ComputeEnvironmentOrder != nil {
		for i, v := range s.ComputeEnvironmentOrder {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComputeEnvironmentOrder", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironmentOrder sets the ComputeEnvironmentOrder field's value.
func (s *CreateJobQueueInput) SetComputeEnvironmentOrder(v []*ComputeEnvironmentOrder) *CreateJobQueueInput {
	s.ComputeEnvironmentOrder = v
	return s
}

// SetJobQueueName sets the JobQueueName field's value.
func (s *CreateJobQueueInput) SetJobQueueName(v string) *CreateJobQueueInput {
	s.JobQueueName = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateJobQueueInput) SetPriority(v int64) *CreateJobQueueInput {
	s.Priority = &v
	return s
}

// SetSchedulingPolicyArn sets the SchedulingPolicyArn field's value.
func (s *CreateJobQueueInput) SetSchedulingPolicyArn(v string) *CreateJobQueueInput {
	s.SchedulingPolicyArn = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateJobQueueInput) SetState(v string) *CreateJobQueueInput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateJobQueueInput) SetTags(v map[string]*string) *CreateJobQueueInput {
	s.Tags = v
	return s
}

type CreateJobQueueOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the job queue.
	//
	// JobQueueArn is a required field
	JobQueueArn *string `locationName:"jobQueueArn" type:"string" required:"true"`

	// The name of the job queue.
	//
	// JobQueueName is a required field
	JobQueueName *string `locationName:"jobQueueName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobQueueOutput) GoString() string {
	return s.String()
}

// SetJobQueueArn sets the JobQueueArn field's value.
func (s *CreateJobQueueOutput) SetJobQueueArn(v string) *CreateJobQueueOutput {
	s.JobQueueArn = &v
	return s
}

// SetJobQueueName sets the JobQueueName field's value.
func (s *CreateJobQueueOutput) SetJobQueueName(v string) *CreateJobQueueOutput {
	s.JobQueueName = &v
	return s
}

// Contains the parameters for CreateSchedulingPolicy.
type CreateSchedulingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The fair share policy of the scheduling policy.
	FairsharePolicy *FairsharePolicy `locationName:"fairsharePolicy" type:"structure"`

	// The name of the scheduling policy. It can be up to 128 letters long. It can
	// contain uppercase and lowercase letters, numbers, hyphens (-), and underscores
	// (_).
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The tags that you apply to the scheduling policy to help you categorize and
	// organize your resources. Each tag consists of a key and an optional value.
	// For more information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in Amazon Web Services General Reference.
	//
	// These tags can be updated or removed using the TagResource (https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html)
	// and UntagResource (https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html)
	// API operations.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchedulingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchedulingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSchedulingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSchedulingPolicyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.FairsharePolicy != nil {
		if err := s.FairsharePolicy.Validate(); err != nil {
			invalidParams.AddNested("FairsharePolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFairsharePolicy sets the FairsharePolicy field's value.
func (s *CreateSchedulingPolicyInput) SetFairsharePolicy(v *FairsharePolicy) *CreateSchedulingPolicyInput {
	s.FairsharePolicy = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSchedulingPolicyInput) SetName(v string) *CreateSchedulingPolicyInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSchedulingPolicyInput) SetTags(v map[string]*string) *CreateSchedulingPolicyInput {
	s.Tags = v
	return s
}

type CreateSchedulingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the scheduling policy. The format is aws:Partition:batch:Region:Account:scheduling-policy/Name
	// . For example, aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the scheduling policy.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchedulingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchedulingPolicyOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSchedulingPolicyOutput) SetArn(v string) *CreateSchedulingPolicyOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSchedulingPolicyOutput) SetName(v string) *CreateSchedulingPolicyOutput {
	s.Name = &v
	return s
}

// Contains the parameters for DeleteComputeEnvironment.
type DeleteComputeEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the compute environment to delete.
	//
	// ComputeEnvironment is a required field
	ComputeEnvironment *string `locationName:"computeEnvironment" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComputeEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComputeEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComputeEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteComputeEnvironmentInput"}
	if s.ComputeEnvironment == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironment sets the ComputeEnvironment field's value.
func (s *DeleteComputeEnvironmentInput) SetComputeEnvironment(v string) *DeleteComputeEnvironmentInput {
	s.ComputeEnvironment = &v
	return s
}

type DeleteComputeEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComputeEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComputeEnvironmentOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteJobQueue.
type DeleteJobQueueInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the queue to delete.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobQueueInput"}
	if s.JobQueue == nil {
		invalidParams.Add(request.NewErrParamRequired("JobQueue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobQueue sets the JobQueue field's value.
func (s *DeleteJobQueueInput) SetJobQueue(v string) *DeleteJobQueueInput {
	s.JobQueue = &v
	return s
}

type DeleteJobQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobQueueOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteSchedulingPolicy.
type DeleteSchedulingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the scheduling policy to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchedulingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchedulingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSchedulingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSchedulingPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteSchedulingPolicyInput) SetArn(v string) *DeleteSchedulingPolicyInput {
	s.Arn = &v
	return s
}

type DeleteSchedulingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchedulingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchedulingPolicyOutput) GoString() string {
	return s.String()
}

type DeregisterJobDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The name and revision (name:revision) or full Amazon Resource Name (ARN)
	// of the job definition to deregister.
	//
	// JobDefinition is a required field
	JobDefinition *string `locationName:"jobDefinition" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterJobDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterJobDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterJobDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterJobDefinitionInput"}
	if s.JobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDefinition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *DeregisterJobDefinitionInput) SetJobDefinition(v string) *DeregisterJobDefinitionInput {
	s.JobDefinition = &v
	return s
}

type DeregisterJobDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterJobDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterJobDefinitionOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeComputeEnvironments.
type DescribeComputeEnvironmentsInput struct {
	_ struct{} `type:"structure"`

	// A list of up to 100 compute environment names or full Amazon Resource Name
	// (ARN) entries.
	ComputeEnvironments []*string `locationName:"computeEnvironments" type:"list"`

	// The maximum number of cluster results returned by DescribeComputeEnvironments
	// in paginated output. When this parameter is used, DescribeComputeEnvironments
	// only returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another DescribeComputeEnvironments request with the returned nextToken value.
	// This value can be between 1 and 100. If this parameter isn't used, then DescribeComputeEnvironments
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeComputeEnvironments
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	// Treat this token as an opaque identifier that's only used to retrieve the
	// next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComputeEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComputeEnvironmentsInput) GoString() string {
	return s.String()
}

// SetComputeEnvironments sets the ComputeEnvironments field's value.
func (s *DescribeComputeEnvironmentsInput) SetComputeEnvironments(v []*string) *DescribeComputeEnvironmentsInput {
	s.ComputeEnvironments = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeComputeEnvironmentsInput) SetMaxResults(v int64) *DescribeComputeEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComputeEnvironmentsInput) SetNextToken(v string) *DescribeComputeEnvironmentsInput {
	s.NextToken = &v
	return s
}

type DescribeComputeEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of compute environments.
	ComputeEnvironments []*ComputeEnvironmentDetail `locationName:"computeEnvironments" type:"list"`

	// The nextToken value to include in a future DescribeComputeEnvironments request.
	// When the results of a DescribeComputeEnvironments request exceed maxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComputeEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComputeEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetComputeEnvironments sets the ComputeEnvironments field's value.
func (s *DescribeComputeEnvironmentsOutput) SetComputeEnvironments(v []*ComputeEnvironmentDetail) *DescribeComputeEnvironmentsOutput {
	s.ComputeEnvironments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComputeEnvironmentsOutput) SetNextToken(v string) *DescribeComputeEnvironmentsOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for DescribeJobDefinitions.
type DescribeJobDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the job definition to describe.
	JobDefinitionName *string `locationName:"jobDefinitionName" type:"string"`

	// A list of up to 100 job definitions. Each entry in the list can either be
	// an ARN in the format arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}
	// or a short version using the form ${JobDefinitionName}:${Revision}. This
	// parameter can't be used with other parameters.
	JobDefinitions []*string `locationName:"jobDefinitions" type:"list"`

	// The maximum number of results returned by DescribeJobDefinitions in paginated
	// output. When this parameter is used, DescribeJobDefinitions only returns
	// maxResults results in a single page and a nextToken response element. The
	// remaining results of the initial request can be seen by sending another DescribeJobDefinitions
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter isn't used, then DescribeJobDefinitions returns up
	// to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeJobDefinitions
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	// Treat this token as an opaque identifier that's only used to retrieve the
	// next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The status used to filter job definitions.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobDefinitionsInput) GoString() string {
	return s.String()
}

// SetJobDefinitionName sets the JobDefinitionName field's value.
func (s *DescribeJobDefinitionsInput) SetJobDefinitionName(v string) *DescribeJobDefinitionsInput {
	s.JobDefinitionName = &v
	return s
}

// SetJobDefinitions sets the JobDefinitions field's value.
func (s *DescribeJobDefinitionsInput) SetJobDefinitions(v []*string) *DescribeJobDefinitionsInput {
	s.JobDefinitions = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeJobDefinitionsInput) SetMaxResults(v int64) *DescribeJobDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobDefinitionsInput) SetNextToken(v string) *DescribeJobDefinitionsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeJobDefinitionsInput) SetStatus(v string) *DescribeJobDefinitionsInput {
	s.Status = &v
	return s
}

type DescribeJobDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of job definitions.
	JobDefinitions []*JobDefinition `locationName:"jobDefinitions" type:"list"`

	// The nextToken value to include in a future DescribeJobDefinitions request.
	// When the results of a DescribeJobDefinitions request exceed maxResults, this
	// value can be used to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobDefinitionsOutput) GoString() string {
	return s.String()
}

// SetJobDefinitions sets the JobDefinitions field's value.
func (s *DescribeJobDefinitionsOutput) SetJobDefinitions(v []*JobDefinition) *DescribeJobDefinitionsOutput {
	s.JobDefinitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobDefinitionsOutput) SetNextToken(v string) *DescribeJobDefinitionsOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for DescribeJobQueues.
type DescribeJobQueuesInput struct {
	_ struct{} `type:"structure"`

	// A list of up to 100 queue names or full queue Amazon Resource Name (ARN)
	// entries.
	JobQueues []*string `locationName:"jobQueues" type:"list"`

	// The maximum number of results returned by DescribeJobQueues in paginated
	// output. When this parameter is used, DescribeJobQueues only returns maxResults
	// results in a single page and a nextToken response element. The remaining
	// results of the initial request can be seen by sending another DescribeJobQueues
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter isn't used, then DescribeJobQueues returns up to 100
	// results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeJobQueues
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	// Treat this token as an opaque identifier that's only used to retrieve the
	// next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobQueuesInput) GoString() string {
	return s.String()
}

// SetJobQueues sets the JobQueues field's value.
func (s *DescribeJobQueuesInput) SetJobQueues(v []*string) *DescribeJobQueuesInput {
	s.JobQueues = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeJobQueuesInput) SetMaxResults(v int64) *DescribeJobQueuesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobQueuesInput) SetNextToken(v string) *DescribeJobQueuesInput {
	s.NextToken = &v
	return s
}

type DescribeJobQueuesOutput struct {
	_ struct{} `type:"structure"`

	// The list of job queues.
	JobQueues []*JobQueueDetail `locationName:"jobQueues" type:"list"`

	// The nextToken value to include in a future DescribeJobQueues request. When
	// the results of a DescribeJobQueues request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobQueuesOutput) GoString() string {
	return s.String()
}

// SetJobQueues sets the JobQueues field's value.
func (s *DescribeJobQueuesOutput) SetJobQueues(v []*JobQueueDetail) *DescribeJobQueuesOutput {
	s.JobQueues = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobQueuesOutput) SetNextToken(v string) *DescribeJobQueuesOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for DescribeJobs.
type DescribeJobsInput struct {
	_ struct{} `type:"structure"`

	// A list of up to 100 job IDs.
	//
	// Jobs is a required field
	Jobs []*string `locationName:"jobs" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobsInput"}
	if s.Jobs == nil {
		invalidParams.Add(request.NewErrParamRequired("Jobs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobs sets the Jobs field's value.
func (s *DescribeJobsInput) SetJobs(v []*string) *DescribeJobsInput {
	s.Jobs = v
	return s
}

type DescribeJobsOutput struct {
	_ struct{} `type:"structure"`

	// The list of jobs.
	Jobs []*JobDetail `locationName:"jobs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *DescribeJobsOutput) SetJobs(v []*JobDetail) *DescribeJobsOutput {
	s.Jobs = v
	return s
}

// Contains the parameters for DescribeSchedulingPolicies.
type DescribeSchedulingPoliciesInput struct {
	_ struct{} `type:"structure"`

	// A list of up to 100 scheduling policy Amazon Resource Name (ARN) entries.
	//
	// Arns is a required field
	Arns []*string `locationName:"arns" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchedulingPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchedulingPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSchedulingPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSchedulingPoliciesInput"}
	if s.Arns == nil {
		invalidParams.Add(request.NewErrParamRequired("Arns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *DescribeSchedulingPoliciesInput) SetArns(v []*string) *DescribeSchedulingPoliciesInput {
	s.Arns = v
	return s
}

type DescribeSchedulingPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The list of scheduling policies.
	SchedulingPolicies []*SchedulingPolicyDetail `locationName:"schedulingPolicies" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchedulingPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchedulingPoliciesOutput) GoString() string {
	return s.String()
}

// SetSchedulingPolicies sets the SchedulingPolicies field's value.
func (s *DescribeSchedulingPoliciesOutput) SetSchedulingPolicies(v []*SchedulingPolicyDetail) *DescribeSchedulingPoliciesOutput {
	s.SchedulingPolicies = v
	return s
}

// An object that represents a container instance host device.
//
// This object isn't applicable to jobs that are running on Fargate resources
// and shouldn't be provided.
type Device struct {
	_ struct{} `type:"structure"`

	// The path inside the container that's used to expose the host device. By default,
	// the hostPath value is used.
	ContainerPath *string `locationName:"containerPath" type:"string"`

	// The path for the device on the host container instance.
	//
	// HostPath is a required field
	HostPath *string `locationName:"hostPath" type:"string" required:"true"`

	// The explicit permissions to provide to the container for the device. By default,
	// the container has permissions for read, write, and mknod for the device.
	Permissions []*string `locationName:"permissions" type:"list" enum:"DeviceCgroupPermission"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Device) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Device"}
	if s.HostPath == nil {
		invalidParams.Add(request.NewErrParamRequired("HostPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerPath sets the ContainerPath field's value.
func (s *Device) SetContainerPath(v string) *Device {
	s.ContainerPath = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *Device) SetHostPath(v string) *Device {
	s.HostPath = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *Device) SetPermissions(v []*string) *Device {
	s.Permissions = v
	return s
}

// The authorization configuration details for the Amazon EFS file system.
type EFSAuthorizationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon EFS access point ID to use. If an access point is specified, the
	// root directory value specified in the EFSVolumeConfiguration must either
	// be omitted or set to / which enforces the path set on the EFS access point.
	// If an access point is used, transit encryption must be enabled in the EFSVolumeConfiguration.
	// For more information, see Working with Amazon EFS access points (https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html)
	// in the Amazon Elastic File System User Guide.
	AccessPointId *string `locationName:"accessPointId" type:"string"`

	// Whether or not to use the Batch job IAM role defined in a job definition
	// when mounting the Amazon EFS file system. If enabled, transit encryption
	// must be enabled in the EFSVolumeConfiguration. If this parameter is omitted,
	// the default value of DISABLED is used. For more information, see Using Amazon
	// EFS access points (https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints)
	// in the Batch User Guide. EFS IAM authorization requires that TransitEncryption
	// be ENABLED and that a JobRoleArn is specified.
	Iam *string `locationName:"iam" type:"string" enum:"EFSAuthorizationConfigIAM"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EFSAuthorizationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EFSAuthorizationConfig) GoString() string {
	return s.String()
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *EFSAuthorizationConfig) SetAccessPointId(v string) *EFSAuthorizationConfig {
	s.AccessPointId = &v
	return s
}

// SetIam sets the Iam field's value.
func (s *EFSAuthorizationConfig) SetIam(v string) *EFSAuthorizationConfig {
	s.Iam = &v
	return s
}

// This is used when you're using an Amazon Elastic File System file system
// for job storage. For more information, see Amazon EFS Volumes (https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html)
// in the Batch User Guide.
type EFSVolumeConfiguration struct {
	_ struct{} `type:"structure"`

	// The authorization configuration details for the Amazon EFS file system.
	AuthorizationConfig *EFSAuthorizationConfig `locationName:"authorizationConfig" type:"structure"`

	// The Amazon EFS file system ID to use.
	//
	// FileSystemId is a required field
	FileSystemId *string `locationName:"fileSystemId" type:"string" required:"true"`

	// The directory within the Amazon EFS file system to mount as the root directory
	// inside the host. If this parameter is omitted, the root of the Amazon EFS
	// volume is used instead. Specifying / has the same effect as omitting this
	// parameter. The maximum length is 4,096 characters.
	//
	// If an EFS access point is specified in the authorizationConfig, the root
	// directory parameter must either be omitted or set to /, which enforces the
	// path set on the Amazon EFS access point.
	RootDirectory *string `locationName:"rootDirectory" type:"string"`

	// Determines whether to enable encryption for Amazon EFS data in transit between
	// the Amazon ECS host and the Amazon EFS server. Transit encryption must be
	// enabled if Amazon EFS IAM authorization is used. If this parameter is omitted,
	// the default value of DISABLED is used. For more information, see Encrypting
	// data in transit (https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html)
	// in the Amazon Elastic File System User Guide.
	TransitEncryption *string `locationName:"transitEncryption" type:"string" enum:"EFSTransitEncryption"`

	// The port to use when sending encrypted data between the Amazon ECS host and
	// the Amazon EFS server. If you don't specify a transit encryption port, it
	// uses the port selection strategy that the Amazon EFS mount helper uses. The
	// value must be between 0 and 65,535. For more information, see EFS mount helper
	// (https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the
	// Amazon Elastic File System User Guide.
	TransitEncryptionPort *int64 `locationName:"transitEncryptionPort" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EFSVolumeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EFSVolumeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EFSVolumeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EFSVolumeConfiguration"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationConfig sets the AuthorizationConfig field's value.
func (s *EFSVolumeConfiguration) SetAuthorizationConfig(v *EFSAuthorizationConfig) *EFSVolumeConfiguration {
	s.AuthorizationConfig = v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *EFSVolumeConfiguration) SetFileSystemId(v string) *EFSVolumeConfiguration {
	s.FileSystemId = &v
	return s
}

// SetRootDirectory sets the RootDirectory field's value.
func (s *EFSVolumeConfiguration) SetRootDirectory(v string) *EFSVolumeConfiguration {
	s.RootDirectory = &v
	return s
}

// SetTransitEncryption sets the TransitEncryption field's value.
func (s *EFSVolumeConfiguration) SetTransitEncryption(v string) *EFSVolumeConfiguration {
	s.TransitEncryption = &v
	return s
}

// SetTransitEncryptionPort sets the TransitEncryptionPort field's value.
func (s *EFSVolumeConfiguration) SetTransitEncryptionPort(v int64) *EFSVolumeConfiguration {
	s.TransitEncryptionPort = &v
	return s
}

// Provides information used to select Amazon Machine Images (AMIs) for instances
// in the compute environment. If Ec2Configuration isn't specified, the default
// is ECS_AL2 (Amazon Linux 2 (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami)).
//
// This object isn't applicable to jobs that are running on Fargate resources.
type Ec2Configuration struct {
	_ struct{} `type:"structure"`

	// The AMI ID used for instances launched in the compute environment that match
	// the image type. This setting overrides the imageId set in the computeResource
	// object.
	//
	// The AMI that you choose for a compute environment must match the architecture
	// of the instance types that you intend to use for that compute environment.
	// For example, if your compute environment uses A1 instance types, the compute
	// resource AMI that you choose must support ARM instances. Amazon ECS vends
	// both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI.
	// For more information, see Amazon ECS-optimized Amazon Linux 2 AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ImageIdOverride *string `locationName:"imageIdOverride" min:"1" type:"string"`

	// The Kubernetes version for the compute environment. If you don't specify
	// a value, the latest version that Batch supports is used.
	ImageKubernetesVersion *string `locationName:"imageKubernetesVersion" min:"1" type:"string"`

	// The image type to match with the instance type to select an AMI. The supported
	// values are different for ECS and EKS resources.
	//
	// ECS
	//
	// If the imageIdOverride parameter isn't specified, then a recent Amazon ECS-optimized
	// Amazon Linux 2 AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami)
	// (ECS_AL2) is used. If a new image type is specified in an update, but neither
	// an imageId nor a imageIdOverride parameter is specified, then the latest
	// Amazon ECS optimized AMI for that image type that's supported by Batch is
	// used.
	//
	// ECS_AL2
	//
	// Amazon Linux 2 (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami):
	// Default for all non-GPU instance families.
	//
	// ECS_AL2_NVIDIA
	//
	// Amazon Linux 2 (GPU) (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami):
	// Default for all GPU instance families (for example P4 and G4) and can be
	// used for all non Amazon Web Services Graviton-based instance types.
	//
	// ECS_AL2023
	//
	// Amazon Linux 2023 (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html):
	// Batch supports Amazon Linux 2023.
	//
	// Amazon Linux 2023 does not support A1 instances.
	//
	// ECS_AL1
	//
	// Amazon Linux (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami).
	// Amazon Linux has reached the end-of-life of standard support. For more information,
	// see Amazon Linux AMI (http://aws.amazon.com/amazon-linux-ami/).
	//
	// EKS
	//
	// If the imageIdOverride parameter isn't specified, then a recent Amazon EKS-optimized
	// Amazon Linux AMI (https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html)
	// (EKS_AL2) is used. If a new image type is specified in an update, but neither
	// an imageId nor a imageIdOverride parameter is specified, then the latest
	// Amazon EKS optimized AMI for that image type that Batch supports is used.
	//
	// EKS_AL2
	//
	// Amazon Linux 2 (https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html):
	// Default for all non-GPU instance families.
	//
	// EKS_AL2_NVIDIA
	//
	// Amazon Linux 2 (accelerated) (https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html):
	// Default for all GPU instance families (for example, P4 and G4) and can be
	// used for all non Amazon Web Services Graviton-based instance types.
	//
	// ImageType is a required field
	ImageType *string `locationName:"imageType" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ec2Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ec2Configuration"}
	if s.ImageIdOverride != nil && len(*s.ImageIdOverride) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIdOverride", 1))
	}
	if s.ImageKubernetesVersion != nil && len(*s.ImageKubernetesVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageKubernetesVersion", 1))
	}
	if s.ImageType == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageType"))
	}
	if s.ImageType != nil && len(*s.ImageType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageIdOverride sets the ImageIdOverride field's value.
func (s *Ec2Configuration) SetImageIdOverride(v string) *Ec2Configuration {
	s.ImageIdOverride = &v
	return s
}

// SetImageKubernetesVersion sets the ImageKubernetesVersion field's value.
func (s *Ec2Configuration) SetImageKubernetesVersion(v string) *Ec2Configuration {
	s.ImageKubernetesVersion = &v
	return s
}

// SetImageType sets the ImageType field's value.
func (s *Ec2Configuration) SetImageType(v string) *Ec2Configuration {
	s.ImageType = &v
	return s
}

// An object that contains the properties for the Amazon ECS resources of a
// job.
type EcsProperties struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties for the Amazon ECS task definition
	// of a job.
	//
	// This object is currently limited to one element.
	//
	// TaskProperties is a required field
	TaskProperties []*EcsTaskProperties `locationName:"taskProperties" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsProperties"}
	if s.TaskProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskProperties"))
	}
	if s.TaskProperties != nil {
		for i, v := range s.TaskProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TaskProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskProperties sets the TaskProperties field's value.
func (s *EcsProperties) SetTaskProperties(v []*EcsTaskProperties) *EcsProperties {
	s.TaskProperties = v
	return s
}

// An object that contains the details for the Amazon ECS resources of a job.
type EcsPropertiesDetail struct {
	_ struct{} `type:"structure"`

	// The properties for the Amazon ECS task definition of a job.
	TaskProperties []*EcsTaskDetails `locationName:"taskProperties" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsPropertiesDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsPropertiesDetail) GoString() string {
	return s.String()
}

// SetTaskProperties sets the TaskProperties field's value.
func (s *EcsPropertiesDetail) SetTaskProperties(v []*EcsTaskDetails) *EcsPropertiesDetail {
	s.TaskProperties = v
	return s
}

// An object that contains overrides for the Amazon ECS task definition of a
// job.
type EcsPropertiesOverride struct {
	_ struct{} `type:"structure"`

	// The overrides for the Amazon ECS task definition of a job.
	//
	// This object is currently limited to one element.
	TaskProperties []*TaskPropertiesOverride `locationName:"taskProperties" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsPropertiesOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsPropertiesOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsPropertiesOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsPropertiesOverride"}
	if s.TaskProperties != nil {
		for i, v := range s.TaskProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TaskProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskProperties sets the TaskProperties field's value.
func (s *EcsPropertiesOverride) SetTaskProperties(v []*TaskPropertiesOverride) *EcsPropertiesOverride {
	s.TaskProperties = v
	return s
}

// The details of a task definition that describes the container and volume
// definitions of an Amazon ECS task.
type EcsTaskDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container instance that hosts the task.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// A list of containers that are included in the taskProperties list.
	Containers []*TaskContainerDetails `locationName:"containers" type:"list"`

	// The amount of ephemeral storage allocated for the task.
	EphemeralStorage *EphemeralStorage `locationName:"ephemeralStorage" type:"structure"`

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume.
	// For more information, see Batch execution IAM role (https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html)
	// in the Batch User Guide.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// The IPC resource namespace to use for the containers in the task.
	IpcMode *string `locationName:"ipcMode" type:"string"`

	// The network configuration for jobs that are running on Fargate resources.
	// Jobs that are running on Amazon EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The process namespace to use for the containers in the task.
	PidMode *string `locationName:"pidMode" type:"string"`

	// The Fargate platform version where the jobs are running.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// An object that represents the compute environment architecture for Batch
	// jobs on Fargate.
	RuntimePlatform *RuntimePlatform `locationName:"runtimePlatform" type:"structure"`

	// The ARN of the Amazon ECS task.
	TaskArn *string `locationName:"taskArn" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that the container can assume
	// for Amazon Web Services permissions. For more information, see IAM roles
	// for tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// This is object is comparable to ContainerProperties:jobRoleArn (https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html).
	TaskRoleArn *string `locationName:"taskRoleArn" type:"string"`

	// A list of data volumes used in a job.
	Volumes []*Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsTaskDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsTaskDetails) GoString() string {
	return s.String()
}

// SetContainerInstanceArn sets the ContainerInstanceArn field's value.
func (s *EcsTaskDetails) SetContainerInstanceArn(v string) *EcsTaskDetails {
	s.ContainerInstanceArn = &v
	return s
}

// SetContainers sets the Containers field's value.
func (s *EcsTaskDetails) SetContainers(v []*TaskContainerDetails) *EcsTaskDetails {
	s.Containers = v
	return s
}

// SetEphemeralStorage sets the EphemeralStorage field's value.
func (s *EcsTaskDetails) SetEphemeralStorage(v *EphemeralStorage) *EcsTaskDetails {
	s.EphemeralStorage = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *EcsTaskDetails) SetExecutionRoleArn(v string) *EcsTaskDetails {
	s.ExecutionRoleArn = &v
	return s
}

// SetIpcMode sets the IpcMode field's value.
func (s *EcsTaskDetails) SetIpcMode(v string) *EcsTaskDetails {
	s.IpcMode = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *EcsTaskDetails) SetNetworkConfiguration(v *NetworkConfiguration) *EcsTaskDetails {
	s.NetworkConfiguration = v
	return s
}

// SetPidMode sets the PidMode field's value.
func (s *EcsTaskDetails) SetPidMode(v string) *EcsTaskDetails {
	s.PidMode = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *EcsTaskDetails) SetPlatformVersion(v string) *EcsTaskDetails {
	s.PlatformVersion = &v
	return s
}

// SetRuntimePlatform sets the RuntimePlatform field's value.
func (s *EcsTaskDetails) SetRuntimePlatform(v *RuntimePlatform) *EcsTaskDetails {
	s.RuntimePlatform = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *EcsTaskDetails) SetTaskArn(v string) *EcsTaskDetails {
	s.TaskArn = &v
	return s
}

// SetTaskRoleArn sets the TaskRoleArn field's value.
func (s *EcsTaskDetails) SetTaskRoleArn(v string) *EcsTaskDetails {
	s.TaskRoleArn = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *EcsTaskDetails) SetVolumes(v []*Volume) *EcsTaskDetails {
	s.Volumes = v
	return s
}

// The properties for a task definition that describes the container and volume
// definitions of an Amazon ECS task. You can specify which Docker images to
// use, the required resources, and other configurations related to launching
// the task definition through an Amazon ECS service or task.
type EcsTaskProperties struct {
	_ struct{} `type:"structure"`

	// This object is a list of containers.
	//
	// Containers is a required field
	Containers []*TaskContainerProperties `locationName:"containers" type:"list" required:"true"`

	// The amount of ephemeral storage to allocate for the task. This parameter
	// is used to expand the total amount of ephemeral storage available, beyond
	// the default amount, for tasks hosted on Fargate.
	EphemeralStorage *EphemeralStorage `locationName:"ephemeralStorage" type:"structure"`

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume.
	// For jobs that run on Fargate resources, you must provide an execution role.
	// For more information, see Batch execution IAM role (https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html)
	// in the Batch User Guide.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// The IPC resource namespace to use for the containers in the task. The valid
	// values are host, task, or none.
	//
	// If host is specified, all containers within the tasks that specified the
	// host IPC mode on the same container instance share the same IPC resources
	// with the host Amazon EC2 instance.
	//
	// If task is specified, all containers within the specified task share the
	// same IPC resources.
	//
	// If none is specified, the IPC resources within the containers of a task are
	// private, and are not shared with other containers in a task or on the container
	// instance.
	//
	// If no value is specified, then the IPC resource namespace sharing depends
	// on the Docker daemon setting on the container instance. For more information,
	// see IPC settings (https://docs.docker.com/engine/reference/run/#ipc-settings---ipc)
	// in the Docker run reference.
	IpcMode *string `locationName:"ipcMode" type:"string"`

	// The network configuration for jobs that are running on Fargate resources.
	// Jobs that are running on Amazon EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The process namespace to use for the containers in the task. The valid values
	// are host or task. For example, monitoring sidecars might need pidMode to
	// access information about other containers running in the same task.
	//
	// If host is specified, all containers within the tasks that specified the
	// host PID mode on the same container instance share the process namespace
	// with the host Amazon EC2 instance.
	//
	// If task is specified, all containers within the specified task share the
	// same process namespace.
	//
	// If no value is specified, the default is a private namespace for each container.
	// For more information, see PID settings (https://docs.docker.com/engine/reference/run/#pid-settings---pid)
	// in the Docker run reference.
	PidMode *string `locationName:"pidMode" type:"string"`

	// The Fargate platform version where the jobs are running. A platform version
	// is specified only for jobs that are running on Fargate resources. If one
	// isn't specified, the LATEST platform version is used by default. This uses
	// a recent, approved version of the Fargate platform for compute resources.
	// For more information, see Fargate platform versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// An object that represents the compute environment architecture for Batch
	// jobs on Fargate.
	RuntimePlatform *RuntimePlatform `locationName:"runtimePlatform" type:"structure"`

	// The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
	//
	// This is object is comparable to ContainerProperties:jobRoleArn (https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html).
	TaskRoleArn *string `locationName:"taskRoleArn" type:"string"`

	// A list of volumes that are associated with the job.
	Volumes []*Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsTaskProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsTaskProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsTaskProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsTaskProperties"}
	if s.Containers == nil {
		invalidParams.Add(request.NewErrParamRequired("Containers"))
	}
	if s.Containers != nil {
		for i, v := range s.Containers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Containers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EphemeralStorage != nil {
		if err := s.EphemeralStorage.Validate(); err != nil {
			invalidParams.AddNested("EphemeralStorage", err.(request.ErrInvalidParams))
		}
	}
	if s.Volumes != nil {
		for i, v := range s.Volumes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Volumes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainers sets the Containers field's value.
func (s *EcsTaskProperties) SetContainers(v []*TaskContainerProperties) *EcsTaskProperties {
	s.Containers = v
	return s
}

// SetEphemeralStorage sets the EphemeralStorage field's value.
func (s *EcsTaskProperties) SetEphemeralStorage(v *EphemeralStorage) *EcsTaskProperties {
	s.EphemeralStorage = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *EcsTaskProperties) SetExecutionRoleArn(v string) *EcsTaskProperties {
	s.ExecutionRoleArn = &v
	return s
}

// SetIpcMode sets the IpcMode field's value.
func (s *EcsTaskProperties) SetIpcMode(v string) *EcsTaskProperties {
	s.IpcMode = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *EcsTaskProperties) SetNetworkConfiguration(v *NetworkConfiguration) *EcsTaskProperties {
	s.NetworkConfiguration = v
	return s
}

// SetPidMode sets the PidMode field's value.
func (s *EcsTaskProperties) SetPidMode(v string) *EcsTaskProperties {
	s.PidMode = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *EcsTaskProperties) SetPlatformVersion(v string) *EcsTaskProperties {
	s.PlatformVersion = &v
	return s
}

// SetRuntimePlatform sets the RuntimePlatform field's value.
func (s *EcsTaskProperties) SetRuntimePlatform(v *RuntimePlatform) *EcsTaskProperties {
	s.RuntimePlatform = v
	return s
}

// SetTaskRoleArn sets the TaskRoleArn field's value.
func (s *EcsTaskProperties) SetTaskRoleArn(v string) *EcsTaskProperties {
	s.TaskRoleArn = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *EcsTaskProperties) SetVolumes(v []*Volume) *EcsTaskProperties {
	s.Volumes = v
	return s
}

// An object that represents the details for an attempt for a job attempt that
// an Amazon EKS container runs.
type EksAttemptContainerDetail struct {
	_ struct{} `type:"structure"`

	// The exit code returned for the job attempt. A non-zero exit code is considered
	// failed.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksAttemptContainerDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksAttemptContainerDetail) GoString() string {
	return s.String()
}

// SetExitCode sets the ExitCode field's value.
func (s *EksAttemptContainerDetail) SetExitCode(v int64) *EksAttemptContainerDetail {
	s.ExitCode = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *EksAttemptContainerDetail) SetReason(v string) *EksAttemptContainerDetail {
	s.Reason = &v
	return s
}

// An object that represents the details of a job attempt for a job attempt
// by an Amazon EKS container.
type EksAttemptDetail struct {
	_ struct{} `type:"structure"`

	// The details for the final status of the containers for this job attempt.
	Containers []*EksAttemptContainerDetail `locationName:"containers" type:"list"`

	// The details for the init containers.
	InitContainers []*EksAttemptContainerDetail `locationName:"initContainers" type:"list"`

	// The name of the node for this job attempt.
	NodeName *string `locationName:"nodeName" type:"string"`

	// The name of the pod for this job attempt.
	PodName *string `locationName:"podName" type:"string"`

	// The Unix timestamp (in milliseconds) for when the attempt was started (when
	// the attempt transitioned from the STARTING state to the RUNNING state).
	StartedAt *int64 `locationName:"startedAt" type:"long"`

	// A short, human-readable string to provide additional details for the current
	// status of the job attempt.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The Unix timestamp (in milliseconds) for when the attempt was stopped. This
	// happens when the attempt transitioned from the RUNNING state to a terminal
	// state, such as SUCCEEDED or FAILED.
	StoppedAt *int64 `locationName:"stoppedAt" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksAttemptDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksAttemptDetail) GoString() string {
	return s.String()
}

// SetContainers sets the Containers field's value.
func (s *EksAttemptDetail) SetContainers(v []*EksAttemptContainerDetail) *EksAttemptDetail {
	s.Containers = v
	return s
}

// SetInitContainers sets the InitContainers field's value.
func (s *EksAttemptDetail) SetInitContainers(v []*EksAttemptContainerDetail) *EksAttemptDetail {
	s.InitContainers = v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *EksAttemptDetail) SetNodeName(v string) *EksAttemptDetail {
	s.NodeName = &v
	return s
}

// SetPodName sets the PodName field's value.
func (s *EksAttemptDetail) SetPodName(v string) *EksAttemptDetail {
	s.PodName = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *EksAttemptDetail) SetStartedAt(v int64) *EksAttemptDetail {
	s.StartedAt = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *EksAttemptDetail) SetStatusReason(v string) *EksAttemptDetail {
	s.StatusReason = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *EksAttemptDetail) SetStoppedAt(v int64) *EksAttemptDetail {
	s.StoppedAt = &v
	return s
}

// Configuration for the Amazon EKS cluster that supports the Batch compute
// environment. The cluster must exist before the compute environment can be
// created.
type EksConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is arn:aws:eks:us-east-1:123456789012:cluster/ClusterForBatch .
	//
	// EksClusterArn is a required field
	EksClusterArn *string `locationName:"eksClusterArn" type:"string" required:"true"`

	// The namespace of the Amazon EKS cluster. Batch manages pods in this namespace.
	// The value can't left empty or null. It must be fewer than 64 characters long,
	// can't be set to default, can't start with "kube-," and must match this regular
	// expression: ^[a-z0-9]([-a-z0-9]*[a-z0-9])?$. For more information, see Namespaces
	// (https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/)
	// in the Kubernetes documentation.
	//
	// KubernetesNamespace is a required field
	KubernetesNamespace *string `locationName:"kubernetesNamespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksConfiguration"}
	if s.EksClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EksClusterArn"))
	}
	if s.KubernetesNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("KubernetesNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEksClusterArn sets the EksClusterArn field's value.
func (s *EksConfiguration) SetEksClusterArn(v string) *EksConfiguration {
	s.EksClusterArn = &v
	return s
}

// SetKubernetesNamespace sets the KubernetesNamespace field's value.
func (s *EksConfiguration) SetKubernetesNamespace(v string) *EksConfiguration {
	s.KubernetesNamespace = &v
	return s
}

// EKS container properties are used in job definitions for Amazon EKS based
// job definitions to describe the properties for a container node in the pod
// that's launched as part of a job. This can't be specified for Amazon ECS
// based job definitions.
type EksContainer struct {
	_ struct{} `type:"structure"`

	// An array of arguments to the entrypoint. If this isn't specified, the CMD
	// of the container image is used. This corresponds to the args member in the
	// Entrypoint (https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint)
	// portion of the Pod (https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/)
	// in Kubernetes. Environment variable references are expanded using the container's
	// environment.
	//
	// If the referenced environment variable doesn't exist, the reference in the
	// command isn't changed. For example, if the reference is to "$(NAME1)" and
	// the NAME1 environment variable doesn't exist, the command string will remain
	// "$(NAME1)." $$ is replaced with $, and the resulting string isn't expanded.
	// For example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME
	// environment variable exists. For more information, see Dockerfile reference:
	// CMD (https://docs.docker.com/engine/reference/builder/#cmd) and Define a
	// command and arguments for a pod (https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/)
	// in the Kubernetes documentation.
	Args []*string `locationName:"args" type:"list"`

	// The entrypoint for the container. This isn't run within a shell. If this
	// isn't specified, the ENTRYPOINT of the container image is used. Environment
	// variable references are expanded using the container's environment.
	//
	// If the referenced environment variable doesn't exist, the reference in the
	// command isn't changed. For example, if the reference is to "$(NAME1)" and
	// the NAME1 environment variable doesn't exist, the command string will remain
	// "$(NAME1)." $$ is replaced with $ and the resulting string isn't expanded.
	// For example, $$(VAR_NAME) will be passed as $(VAR_NAME) whether or not the
	// VAR_NAME environment variable exists. The entrypoint can't be updated. For
	// more information, see ENTRYPOINT (https://docs.docker.com/engine/reference/builder/#entrypoint)
	// in the Dockerfile reference and Define a command and arguments for a container
	// (https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/)
	// and Entrypoint (https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint)
	// in the Kubernetes documentation.
	Command []*string `locationName:"command" type:"list"`

	// The environment variables to pass to a container.
	//
	// Environment variables cannot start with "AWS_BATCH". This naming convention
	// is reserved for variables that Batch sets.
	Env []*EksContainerEnvironmentVariable `locationName:"env" type:"list"`

	// The Docker image used to start the container.
	//
	// Image is a required field
	Image *string `locationName:"image" type:"string" required:"true"`

	// The image pull policy for the container. Supported values are Always, IfNotPresent,
	// and Never. This parameter defaults to IfNotPresent. However, if the :latest
	// tag is specified, it defaults to Always. For more information, see Updating
	// images (https://kubernetes.io/docs/concepts/containers/images/#updating-images)
	// in the Kubernetes documentation.
	ImagePullPolicy *string `locationName:"imagePullPolicy" type:"string"`

	// The name of the container. If the name isn't specified, the default name
	// "Default" is used. Each container in a pod must have a unique name.
	Name *string `locationName:"name" type:"string"`

	// The type and amount of resources to assign to a container. The supported
	// resources include memory, cpu, and nvidia.com/gpu. For more information,
	// see Resource management for pods and containers (https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/)
	// in the Kubernetes documentation.
	Resources *EksContainerResourceRequirements `locationName:"resources" type:"structure"`

	// The security context for a job. For more information, see Configure a security
	// context for a pod or container (https://kubernetes.io/docs/tasks/configure-pod-container/security-context/)
	// in the Kubernetes documentation.
	SecurityContext *EksContainerSecurityContext `locationName:"securityContext" type:"structure"`

	// The volume mounts for the container. Batch supports emptyDir, hostPath, and
	// secret volume types. For more information about volumes and volume mounts
	// in Kubernetes, see Volumes (https://kubernetes.io/docs/concepts/storage/volumes/)
	// in the Kubernetes documentation.
	VolumeMounts []*EksContainerVolumeMount `locationName:"volumeMounts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksContainer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksContainer"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Env != nil {
		for i, v := range s.Env {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Env", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArgs sets the Args field's value.
func (s *EksContainer) SetArgs(v []*string) *EksContainer {
	s.Args = v
	return s
}

// SetCommand sets the Command field's value.
func (s *EksContainer) SetCommand(v []*string) *EksContainer {
	s.Command = v
	return s
}

// SetEnv sets the Env field's value.
func (s *EksContainer) SetEnv(v []*EksContainerEnvironmentVariable) *EksContainer {
	s.Env = v
	return s
}

// SetImage sets the Image field's value.
func (s *EksContainer) SetImage(v string) *EksContainer {
	s.Image = &v
	return s
}

// SetImagePullPolicy sets the ImagePullPolicy field's value.
func (s *EksContainer) SetImagePullPolicy(v string) *EksContainer {
	s.ImagePullPolicy = &v
	return s
}

// SetName sets the Name field's value.
func (s *EksContainer) SetName(v string) *EksContainer {
	s.Name = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *EksContainer) SetResources(v *EksContainerResourceRequirements) *EksContainer {
	s.Resources = v
	return s
}

// SetSecurityContext sets the SecurityContext field's value.
func (s *EksContainer) SetSecurityContext(v *EksContainerSecurityContext) *EksContainer {
	s.SecurityContext = v
	return s
}

// SetVolumeMounts sets the VolumeMounts field's value.
func (s *EksContainer) SetVolumeMounts(v []*EksContainerVolumeMount) *EksContainer {
	s.VolumeMounts = v
	return s
}

// The details for container properties that are returned by DescribeJobs for
// jobs that use Amazon EKS.
type EksContainerDetail struct {
	_ struct{} `type:"structure"`

	// An array of arguments to the entrypoint. If this isn't specified, the CMD
	// of the container image is used. This corresponds to the args member in the
	// Entrypoint (https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint)
	// portion of the Pod (https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/)
	// in Kubernetes. Environment variable references are expanded using the container's
	// environment.
	//
	// If the referenced environment variable doesn't exist, the reference in the
	// command isn't changed. For example, if the reference is to "$(NAME1)" and
	// the NAME1 environment variable doesn't exist, the command string will remain
	// "$(NAME1)". $$ is replaced with $ and the resulting string isn't expanded.
	// For example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME
	// environment variable exists. For more information, see Dockerfile reference:
	// CMD (https://docs.docker.com/engine/reference/builder/#cmd) and Define a
	// command and arguments for a pod (https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/)
	// in the Kubernetes documentation.
	Args []*string `locationName:"args" type:"list"`

	// The entrypoint for the container. For more information, see Entrypoint (https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint)
	// in the Kubernetes documentation.
	Command []*string `locationName:"command" type:"list"`

	// The environment variables to pass to a container.
	//
	// Environment variables cannot start with "AWS_BATCH". This naming convention
	// is reserved for variables that Batch sets.
	Env []*EksContainerEnvironmentVariable `locationName:"env" type:"list"`

	// The exit code returned for the job attempt. A non-zero exit code is considered
	// failed.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The Docker image used to start the container.
	Image *string `locationName:"image" type:"string"`

	// The image pull policy for the container. Supported values are Always, IfNotPresent,
	// and Never. This parameter defaults to Always if the :latest tag is specified,
	// IfNotPresent otherwise. For more information, see Updating images (https://kubernetes.io/docs/concepts/containers/images/#updating-images)
	// in the Kubernetes documentation.
	ImagePullPolicy *string `locationName:"imagePullPolicy" type:"string"`

	// The name of the container. If the name isn't specified, the default name
	// "Default" is used. Each container in a pod must have a unique name.
	Name *string `locationName:"name" type:"string"`

	// A short human-readable string to provide additional details for a running
	// or stopped container. It can be up to 255 characters long.
	Reason *string `locationName:"reason" type:"string"`

	// The type and amount of resources to assign to a container. The supported
	// resources include memory, cpu, and nvidia.com/gpu. For more information,
	// see Resource management for pods and containers (https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/)
	// in the Kubernetes documentation.
	Resources *EksContainerResourceRequirements `locationName:"resources" type:"structure"`

	// The security context for a job. For more information, see Configure a security
	// context for a pod or container (https://kubernetes.io/docs/tasks/configure-pod-container/security-context/)
	// in the Kubernetes documentation.
	SecurityContext *EksContainerSecurityContext `locationName:"securityContext" type:"structure"`

	// The volume mounts for the container. Batch supports emptyDir, hostPath, and
	// secret volume types. For more information about volumes and volume mounts
	// in Kubernetes, see Volumes (https://kubernetes.io/docs/concepts/storage/volumes/)
	// in the Kubernetes documentation.
	VolumeMounts []*EksContainerVolumeMount `locationName:"volumeMounts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerDetail) GoString() string {
	return s.String()
}

// SetArgs sets the Args field's value.
func (s *EksContainerDetail) SetArgs(v []*string) *EksContainerDetail {
	s.Args = v
	return s
}

// SetCommand sets the Command field's value.
func (s *EksContainerDetail) SetCommand(v []*string) *EksContainerDetail {
	s.Command = v
	return s
}

// SetEnv sets the Env field's value.
func (s *EksContainerDetail) SetEnv(v []*EksContainerEnvironmentVariable) *EksContainerDetail {
	s.Env = v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *EksContainerDetail) SetExitCode(v int64) *EksContainerDetail {
	s.ExitCode = &v
	return s
}

// SetImage sets the Image field's value.
func (s *EksContainerDetail) SetImage(v string) *EksContainerDetail {
	s.Image = &v
	return s
}

// SetImagePullPolicy sets the ImagePullPolicy field's value.
func (s *EksContainerDetail) SetImagePullPolicy(v string) *EksContainerDetail {
	s.ImagePullPolicy = &v
	return s
}

// SetName sets the Name field's value.
func (s *EksContainerDetail) SetName(v string) *EksContainerDetail {
	s.Name = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *EksContainerDetail) SetReason(v string) *EksContainerDetail {
	s.Reason = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *EksContainerDetail) SetResources(v *EksContainerResourceRequirements) *EksContainerDetail {
	s.Resources = v
	return s
}

// SetSecurityContext sets the SecurityContext field's value.
func (s *EksContainerDetail) SetSecurityContext(v *EksContainerSecurityContext) *EksContainerDetail {
	s.SecurityContext = v
	return s
}

// SetVolumeMounts sets the VolumeMounts field's value.
func (s *EksContainerDetail) SetVolumeMounts(v []*EksContainerVolumeMount) *EksContainerDetail {
	s.VolumeMounts = v
	return s
}

// An environment variable.
type EksContainerEnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// The name of the environment variable.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The value of the environment variable.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerEnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerEnvironmentVariable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksContainerEnvironmentVariable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksContainerEnvironmentVariable"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *EksContainerEnvironmentVariable) SetName(v string) *EksContainerEnvironmentVariable {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EksContainerEnvironmentVariable) SetValue(v string) *EksContainerEnvironmentVariable {
	s.Value = &v
	return s
}

// Object representing any Kubernetes overrides to a job definition that's used
// in a SubmitJob (https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html)
// API operation.
type EksContainerOverride struct {
	_ struct{} `type:"structure"`

	// The arguments to the entrypoint to send to the container that overrides the
	// default arguments from the Docker image or the job definition. For more information,
	// see Dockerfile reference: CMD (https://docs.docker.com/engine/reference/builder/#cmd)
	// and Define a command an arguments for a pod (https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/)
	// in the Kubernetes documentation.
	Args []*string `locationName:"args" type:"list"`

	// The command to send to the container that overrides the default command from
	// the Docker image or the job definition.
	Command []*string `locationName:"command" type:"list"`

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch. Or, you can override
	// the existing environment variables from the Docker image or the job definition.
	//
	// Environment variables cannot start with "AWS_BATCH". This naming convention
	// is reserved for variables that Batch sets.
	Env []*EksContainerEnvironmentVariable `locationName:"env" type:"list"`

	// The override of the Docker image that's used to start the container.
	Image *string `locationName:"image" type:"string"`

	// A pointer to the container that you want to override. The name must match
	// a unique container name that you wish to override.
	Name *string `locationName:"name" type:"string"`

	// The type and amount of resources to assign to a container. These override
	// the settings in the job definition. The supported resources include memory,
	// cpu, and nvidia.com/gpu. For more information, see Resource management for
	// pods and containers (https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/)
	// in the Kubernetes documentation.
	Resources *EksContainerResourceRequirements `locationName:"resources" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksContainerOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksContainerOverride"}
	if s.Env != nil {
		for i, v := range s.Env {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Env", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArgs sets the Args field's value.
func (s *EksContainerOverride) SetArgs(v []*string) *EksContainerOverride {
	s.Args = v
	return s
}

// SetCommand sets the Command field's value.
func (s *EksContainerOverride) SetCommand(v []*string) *EksContainerOverride {
	s.Command = v
	return s
}

// SetEnv sets the Env field's value.
func (s *EksContainerOverride) SetEnv(v []*EksContainerEnvironmentVariable) *EksContainerOverride {
	s.Env = v
	return s
}

// SetImage sets the Image field's value.
func (s *EksContainerOverride) SetImage(v string) *EksContainerOverride {
	s.Image = &v
	return s
}

// SetName sets the Name field's value.
func (s *EksContainerOverride) SetName(v string) *EksContainerOverride {
	s.Name = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *EksContainerOverride) SetResources(v *EksContainerResourceRequirements) *EksContainerOverride {
	s.Resources = v
	return s
}

// The type and amount of resources to assign to a container. The supported
// resources include memory, cpu, and nvidia.com/gpu. For more information,
// see Resource management for pods and containers (https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/)
// in the Kubernetes documentation.
type EksContainerResourceRequirements struct {
	_ struct{} `type:"structure"`

	// The type and quantity of the resources to reserve for the container. The
	// values vary based on the name that's specified. Resources can be requested
	// using either the limits or the requests objects.
	//
	// memory
	//
	// The memory hard limit (in MiB) for the container, using whole integers, with
	// a "Mi" suffix. If your container attempts to exceed the memory specified,
	// the container is terminated. You must specify at least 4 MiB of memory for
	// a job. memory can be specified in limits, requests, or both. If memory is
	// specified in both places, then the value that's specified in limits must
	// be equal to the value that's specified in requests.
	//
	// To maximize your resource utilization, provide your jobs with as much memory
	// as possible for the specific instance type that you are using. To learn how,
	// see Memory management (https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html)
	// in the Batch User Guide.
	//
	// cpu
	//
	// The number of CPUs that's reserved for the container. Values must be an even
	// multiple of 0.25. cpu can be specified in limits, requests, or both. If cpu
	// is specified in both places, then the value that's specified in limits must
	// be at least as large as the value that's specified in requests.
	//
	// nvidia.com/gpu
	//
	// The number of GPUs that's reserved for the container. Values must be a whole
	// integer. memory can be specified in limits, requests, or both. If memory
	// is specified in both places, then the value that's specified in limits must
	// be equal to the value that's specified in requests.
	Limits map[string]*string `locationName:"limits" type:"map"`

	// The type and quantity of the resources to request for the container. The
	// values vary based on the name that's specified. Resources can be requested
	// by using either the limits or the requests objects.
	//
	// memory
	//
	// The memory hard limit (in MiB) for the container, using whole integers, with
	// a "Mi" suffix. If your container attempts to exceed the memory specified,
	// the container is terminated. You must specify at least 4 MiB of memory for
	// a job. memory can be specified in limits, requests, or both. If memory is
	// specified in both, then the value that's specified in limits must be equal
	// to the value that's specified in requests.
	//
	// If you're trying to maximize your resource utilization by providing your
	// jobs as much memory as possible for a particular instance type, see Memory
	// management (https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html)
	// in the Batch User Guide.
	//
	// cpu
	//
	// The number of CPUs that are reserved for the container. Values must be an
	// even multiple of 0.25. cpu can be specified in limits, requests, or both.
	// If cpu is specified in both, then the value that's specified in limits must
	// be at least as large as the value that's specified in requests.
	//
	// nvidia.com/gpu
	//
	// The number of GPUs that are reserved for the container. Values must be a
	// whole integer. nvidia.com/gpu can be specified in limits, requests, or both.
	// If nvidia.com/gpu is specified in both, then the value that's specified in
	// limits must be equal to the value that's specified in requests.
	Requests map[string]*string `locationName:"requests" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerResourceRequirements) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerResourceRequirements) GoString() string {
	return s.String()
}

// SetLimits sets the Limits field's value.
func (s *EksContainerResourceRequirements) SetLimits(v map[string]*string) *EksContainerResourceRequirements {
	s.Limits = v
	return s
}

// SetRequests sets the Requests field's value.
func (s *EksContainerResourceRequirements) SetRequests(v map[string]*string) *EksContainerResourceRequirements {
	s.Requests = v
	return s
}

// The security context for a job. For more information, see Configure a security
// context for a pod or container (https://kubernetes.io/docs/tasks/configure-pod-container/security-context/)
// in the Kubernetes documentation.
type EksContainerSecurityContext struct {
	_ struct{} `type:"structure"`

	// When this parameter is true, the container is given elevated permissions
	// on the host container instance. The level of permissions are similar to the
	// root user permissions. The default value is false. This parameter maps to
	// privileged policy in the Privileged pod security policies (https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged)
	// in the Kubernetes documentation.
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system. The default value is false. This parameter maps to ReadOnlyRootFilesystem
	// policy in the Volumes and file systems pod security policies (https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems)
	// in the Kubernetes documentation.
	ReadOnlyRootFilesystem *bool `locationName:"readOnlyRootFilesystem" type:"boolean"`

	// When this parameter is specified, the container is run as the specified group
	// ID (gid). If this parameter isn't specified, the default is the group that's
	// specified in the image metadata. This parameter maps to RunAsGroup and MustRunAs
	// policy in the Users and groups pod security policies (https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups)
	// in the Kubernetes documentation.
	RunAsGroup *int64 `locationName:"runAsGroup" type:"long"`

	// When this parameter is specified, the container is run as a user with a uid
	// other than 0. If this parameter isn't specified, so such rule is enforced.
	// This parameter maps to RunAsUser and MustRunAsNonRoot policy in the Users
	// and groups pod security policies (https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups)
	// in the Kubernetes documentation.
	RunAsNonRoot *bool `locationName:"runAsNonRoot" type:"boolean"`

	// When this parameter is specified, the container is run as the specified user
	// ID (uid). If this parameter isn't specified, the default is the user that's
	// specified in the image metadata. This parameter maps to RunAsUser and MustRanAs
	// policy in the Users and groups pod security policies (https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups)
	// in the Kubernetes documentation.
	RunAsUser *int64 `locationName:"runAsUser" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerSecurityContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerSecurityContext) GoString() string {
	return s.String()
}

// SetPrivileged sets the Privileged field's value.
func (s *EksContainerSecurityContext) SetPrivileged(v bool) *EksContainerSecurityContext {
	s.Privileged = &v
	return s
}

// SetReadOnlyRootFilesystem sets the ReadOnlyRootFilesystem field's value.
func (s *EksContainerSecurityContext) SetReadOnlyRootFilesystem(v bool) *EksContainerSecurityContext {
	s.ReadOnlyRootFilesystem = &v
	return s
}

// SetRunAsGroup sets the RunAsGroup field's value.
func (s *EksContainerSecurityContext) SetRunAsGroup(v int64) *EksContainerSecurityContext {
	s.RunAsGroup = &v
	return s
}

// SetRunAsNonRoot sets the RunAsNonRoot field's value.
func (s *EksContainerSecurityContext) SetRunAsNonRoot(v bool) *EksContainerSecurityContext {
	s.RunAsNonRoot = &v
	return s
}

// SetRunAsUser sets the RunAsUser field's value.
func (s *EksContainerSecurityContext) SetRunAsUser(v int64) *EksContainerSecurityContext {
	s.RunAsUser = &v
	return s
}

// The volume mounts for a container for an Amazon EKS job. For more information
// about volumes and volume mounts in Kubernetes, see Volumes (https://kubernetes.io/docs/concepts/storage/volumes/)
// in the Kubernetes documentation.
type EksContainerVolumeMount struct {
	_ struct{} `type:"structure"`

	// The path on the container where the volume is mounted.
	MountPath *string `locationName:"mountPath" type:"string"`

	// The name the volume mount. This must match the name of one of the volumes
	// in the pod.
	Name *string `locationName:"name" type:"string"`

	// If this value is true, the container has read-only access to the volume.
	// Otherwise, the container can write to the volume. The default value is false.
	ReadOnly *bool `locationName:"readOnly" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerVolumeMount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksContainerVolumeMount) GoString() string {
	return s.String()
}

// SetMountPath sets the MountPath field's value.
func (s *EksContainerVolumeMount) SetMountPath(v string) *EksContainerVolumeMount {
	s.MountPath = &v
	return s
}

// SetName sets the Name field's value.
func (s *EksContainerVolumeMount) SetName(v string) *EksContainerVolumeMount {
	s.Name = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *EksContainerVolumeMount) SetReadOnly(v bool) *EksContainerVolumeMount {
	s.ReadOnly = &v
	return s
}

// Specifies the configuration of a Kubernetes emptyDir volume. An emptyDir
// volume is first created when a pod is assigned to a node. It exists as long
// as that pod is running on that node. The emptyDir volume is initially empty.
// All containers in the pod can read and write the files in the emptyDir volume.
// However, the emptyDir volume can be mounted at the same or different paths
// in each container. When a pod is removed from a node for any reason, the
// data in the emptyDir is deleted permanently. For more information, see emptyDir
// (https://kubernetes.io/docs/concepts/storage/volumes/#emptydir) in the Kubernetes
// documentation.
type EksEmptyDir struct {
	_ struct{} `type:"structure"`

	// The medium to store the volume. The default value is an empty string, which
	// uses the storage of the node.
	//
	// ""
	//
	// (Default) Use the disk storage of the node.
	//
	// "Memory"
	//
	// Use the tmpfs volume that's backed by the RAM of the node. Contents of the
	// volume are lost when the node reboots, and any storage on the volume counts
	// against the container's memory limit.
	Medium *string `locationName:"medium" type:"string"`

	// The maximum size of the volume. By default, there's no maximum size defined.
	SizeLimit *string `locationName:"sizeLimit" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksEmptyDir) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksEmptyDir) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksEmptyDir) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksEmptyDir"}
	if s.SizeLimit != nil && len(*s.SizeLimit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SizeLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMedium sets the Medium field's value.
func (s *EksEmptyDir) SetMedium(v string) *EksEmptyDir {
	s.Medium = &v
	return s
}

// SetSizeLimit sets the SizeLimit field's value.
func (s *EksEmptyDir) SetSizeLimit(v string) *EksEmptyDir {
	s.SizeLimit = &v
	return s
}

// Specifies the configuration of a Kubernetes hostPath volume. A hostPath volume
// mounts an existing file or directory from the host node's filesystem into
// your pod. For more information, see hostPath (https://kubernetes.io/docs/concepts/storage/volumes/#hostpath)
// in the Kubernetes documentation.
type EksHostPath struct {
	_ struct{} `type:"structure"`

	// The path of the file or directory on the host to mount into containers on
	// the pod.
	Path *string `locationName:"path" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksHostPath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksHostPath) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *EksHostPath) SetPath(v string) *EksHostPath {
	s.Path = &v
	return s
}

// Describes and uniquely identifies Kubernetes resources. For example, the
// compute environment that a pod runs in or the jobID for a job running in
// the pod. For more information, see Understanding Kubernetes Objects (https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/)
// in the Kubernetes documentation.
type EksMetadata struct {
	_ struct{} `type:"structure"`

	// Key-value pairs used to identify, sort, and organize cube resources. Can
	// contain up to 63 uppercase letters, lowercase letters, numbers, hyphens (-),
	// and underscores (_). Labels can be added or modified at any time. Each resource
	// can have multiple labels, but each key must be unique for a given object.
	Labels map[string]*string `locationName:"labels" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksMetadata) GoString() string {
	return s.String()
}

// SetLabels sets the Labels field's value.
func (s *EksMetadata) SetLabels(v map[string]*string) *EksMetadata {
	s.Labels = v
	return s
}

// The properties for the pod.
type EksPodProperties struct {
	_ struct{} `type:"structure"`

	// The properties of the container that's used on the Amazon EKS pod.
	Containers []*EksContainer `locationName:"containers" type:"list"`

	// The DNS policy for the pod. The default value is ClusterFirst. If the hostNetwork
	// parameter is not specified, the default is ClusterFirstWithHostNet. ClusterFirst
	// indicates that any DNS query that does not match the configured cluster domain
	// suffix is forwarded to the upstream nameserver inherited from the node. For
	// more information, see Pod's DNS policy (https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy)
	// in the Kubernetes documentation.
	//
	// Valid values: Default | ClusterFirst | ClusterFirstWithHostNet
	DnsPolicy *string `locationName:"dnsPolicy" type:"string"`

	// Indicates if the pod uses the hosts' network IP address. The default value
	// is true. Setting this to false enables the Kubernetes pod networking model.
	// Most Batch workloads are egress-only and don't require the overhead of IP
	// allocation for each pod for incoming connections. For more information, see
	// Host namespaces (https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces)
	// and Pod networking (https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking)
	// in the Kubernetes documentation.
	HostNetwork *bool `locationName:"hostNetwork" type:"boolean"`

	// These containers run before application containers, always runs to completion,
	// and must complete successfully before the next container starts. These containers
	// are registered with the Amazon EKS Connector agent and persists the registration
	// information in the Kubernetes backend data store. For more information, see
	// Init Containers (https://kubernetes.io/docs/concepts/workloads/pods/init-containers/)
	// in the Kubernetes documentation.
	//
	// This object is limited to 10 elements
	InitContainers []*EksContainer `locationName:"initContainers" type:"list"`

	// Metadata about the Kubernetes pod. For more information, see Understanding
	// Kubernetes Objects (https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/)
	// in the Kubernetes documentation.
	Metadata *EksMetadata `locationName:"metadata" type:"structure"`

	// The name of the service account that's used to run the pod. For more information,
	// see Kubernetes service accounts (https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html)
	// and Configure a Kubernetes service account to assume an IAM role (https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html)
	// in the Amazon EKS User Guide and Configure service accounts for pods (https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/)
	// in the Kubernetes documentation.
	ServiceAccountName *string `locationName:"serviceAccountName" type:"string"`

	// Indicates if the processes in a container are shared, or visible, to other
	// containers in the same pod. For more information, see Share Process Namespace
	// between Containers in a Pod (https://kubernetes.io/docs/tasks/configure-pod-container/share-process-namespace/).
	ShareProcessNamespace *bool `locationName:"shareProcessNamespace" type:"boolean"`

	// Specifies the volumes for a job definition that uses Amazon EKS resources.
	Volumes []*EksVolume `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPodProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPodProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksPodProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksPodProperties"}
	if s.Containers != nil {
		for i, v := range s.Containers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Containers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InitContainers != nil {
		for i, v := range s.InitContainers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InitContainers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Volumes != nil {
		for i, v := range s.Volumes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Volumes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainers sets the Containers field's value.
func (s *EksPodProperties) SetContainers(v []*EksContainer) *EksPodProperties {
	s.Containers = v
	return s
}

// SetDnsPolicy sets the DnsPolicy field's value.
func (s *EksPodProperties) SetDnsPolicy(v string) *EksPodProperties {
	s.DnsPolicy = &v
	return s
}

// SetHostNetwork sets the HostNetwork field's value.
func (s *EksPodProperties) SetHostNetwork(v bool) *EksPodProperties {
	s.HostNetwork = &v
	return s
}

// SetInitContainers sets the InitContainers field's value.
func (s *EksPodProperties) SetInitContainers(v []*EksContainer) *EksPodProperties {
	s.InitContainers = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *EksPodProperties) SetMetadata(v *EksMetadata) *EksPodProperties {
	s.Metadata = v
	return s
}

// SetServiceAccountName sets the ServiceAccountName field's value.
func (s *EksPodProperties) SetServiceAccountName(v string) *EksPodProperties {
	s.ServiceAccountName = &v
	return s
}

// SetShareProcessNamespace sets the ShareProcessNamespace field's value.
func (s *EksPodProperties) SetShareProcessNamespace(v bool) *EksPodProperties {
	s.ShareProcessNamespace = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *EksPodProperties) SetVolumes(v []*EksVolume) *EksPodProperties {
	s.Volumes = v
	return s
}

// The details for the pod.
type EksPodPropertiesDetail struct {
	_ struct{} `type:"structure"`

	// The properties of the container that's used on the Amazon EKS pod.
	Containers []*EksContainerDetail `locationName:"containers" type:"list"`

	// The DNS policy for the pod. The default value is ClusterFirst. If the hostNetwork
	// parameter is not specified, the default is ClusterFirstWithHostNet. ClusterFirst
	// indicates that any DNS query that does not match the configured cluster domain
	// suffix is forwarded to the upstream nameserver inherited from the node. If
	// no value was specified for dnsPolicy in the RegisterJobDefinition (https://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html)
	// API operation, then no value will be returned for dnsPolicy by either of
	// DescribeJobDefinitions (https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobDefinitions.html)
	// or DescribeJobs (https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobs.html)
	// API operations. The pod spec setting will contain either ClusterFirst or
	// ClusterFirstWithHostNet, depending on the value of the hostNetwork parameter.
	// For more information, see Pod's DNS policy (https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy)
	// in the Kubernetes documentation.
	//
	// Valid values: Default | ClusterFirst | ClusterFirstWithHostNet
	DnsPolicy *string `locationName:"dnsPolicy" type:"string"`

	// Indicates if the pod uses the hosts' network IP address. The default value
	// is true. Setting this to false enables the Kubernetes pod networking model.
	// Most Batch workloads are egress-only and don't require the overhead of IP
	// allocation for each pod for incoming connections. For more information, see
	// Host namespaces (https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces)
	// and Pod networking (https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking)
	// in the Kubernetes documentation.
	HostNetwork *bool `locationName:"hostNetwork" type:"boolean"`

	// The container registered with the Amazon EKS Connector agent and persists
	// the registration information in the Kubernetes backend data store.
	InitContainers []*EksContainerDetail `locationName:"initContainers" type:"list"`

	// Describes and uniquely identifies Kubernetes resources. For example, the
	// compute environment that a pod runs in or the jobID for a job running in
	// the pod. For more information, see Understanding Kubernetes Objects (https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/)
	// in the Kubernetes documentation.
	Metadata *EksMetadata `locationName:"metadata" type:"structure"`

	// The name of the node for this job.
	NodeName *string `locationName:"nodeName" type:"string"`

	// The name of the pod for this job.
	PodName *string `locationName:"podName" type:"string"`

	// The name of the service account that's used to run the pod. For more information,
	// see Kubernetes service accounts (https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html)
	// and Configure a Kubernetes service account to assume an IAM role (https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html)
	// in the Amazon EKS User Guide and Configure service accounts for pods (https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/)
	// in the Kubernetes documentation.
	ServiceAccountName *string `locationName:"serviceAccountName" type:"string"`

	// Indicates if the processes in a container are shared, or visible, to other
	// containers in the same pod. For more information, see Share Process Namespace
	// between Containers in a Pod (https://kubernetes.io/docs/tasks/configure-pod-container/share-process-namespace/).
	ShareProcessNamespace *bool `locationName:"shareProcessNamespace" type:"boolean"`

	// Specifies the volumes for a job definition using Amazon EKS resources.
	Volumes []*EksVolume `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPodPropertiesDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPodPropertiesDetail) GoString() string {
	return s.String()
}

// SetContainers sets the Containers field's value.
func (s *EksPodPropertiesDetail) SetContainers(v []*EksContainerDetail) *EksPodPropertiesDetail {
	s.Containers = v
	return s
}

// SetDnsPolicy sets the DnsPolicy field's value.
func (s *EksPodPropertiesDetail) SetDnsPolicy(v string) *EksPodPropertiesDetail {
	s.DnsPolicy = &v
	return s
}

// SetHostNetwork sets the HostNetwork field's value.
func (s *EksPodPropertiesDetail) SetHostNetwork(v bool) *EksPodPropertiesDetail {
	s.HostNetwork = &v
	return s
}

// SetInitContainers sets the InitContainers field's value.
func (s *EksPodPropertiesDetail) SetInitContainers(v []*EksContainerDetail) *EksPodPropertiesDetail {
	s.InitContainers = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *EksPodPropertiesDetail) SetMetadata(v *EksMetadata) *EksPodPropertiesDetail {
	s.Metadata = v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *EksPodPropertiesDetail) SetNodeName(v string) *EksPodPropertiesDetail {
	s.NodeName = &v
	return s
}

// SetPodName sets the PodName field's value.
func (s *EksPodPropertiesDetail) SetPodName(v string) *EksPodPropertiesDetail {
	s.PodName = &v
	return s
}

// SetServiceAccountName sets the ServiceAccountName field's value.
func (s *EksPodPropertiesDetail) SetServiceAccountName(v string) *EksPodPropertiesDetail {
	s.ServiceAccountName = &v
	return s
}

// SetShareProcessNamespace sets the ShareProcessNamespace field's value.
func (s *EksPodPropertiesDetail) SetShareProcessNamespace(v bool) *EksPodPropertiesDetail {
	s.ShareProcessNamespace = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *EksPodPropertiesDetail) SetVolumes(v []*EksVolume) *EksPodPropertiesDetail {
	s.Volumes = v
	return s
}

// An object that contains overrides for the Kubernetes pod properties of a
// job.
type EksPodPropertiesOverride struct {
	_ struct{} `type:"structure"`

	// The overrides for the container that's used on the Amazon EKS pod.
	Containers []*EksContainerOverride `locationName:"containers" type:"list"`

	// The overrides for the conatainers defined in the Amazon EKS pod. These containers
	// run before application containers, always runs to completion, and must complete
	// successfully before the next container starts. These containers are registered
	// with the Amazon EKS Connector agent and persists the registration information
	// in the Kubernetes backend data store. For more information, see Init Containers
	// (https://kubernetes.io/docs/concepts/workloads/pods/init-containers/) in
	// the Kubernetes documentation.
	//
	// This object is limited to 10 elements
	InitContainers []*EksContainerOverride `locationName:"initContainers" type:"list"`

	// Metadata about the overrides for the container that's used on the Amazon
	// EKS pod.
	Metadata *EksMetadata `locationName:"metadata" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPodPropertiesOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPodPropertiesOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksPodPropertiesOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksPodPropertiesOverride"}
	if s.Containers != nil {
		for i, v := range s.Containers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Containers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InitContainers != nil {
		for i, v := range s.InitContainers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InitContainers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainers sets the Containers field's value.
func (s *EksPodPropertiesOverride) SetContainers(v []*EksContainerOverride) *EksPodPropertiesOverride {
	s.Containers = v
	return s
}

// SetInitContainers sets the InitContainers field's value.
func (s *EksPodPropertiesOverride) SetInitContainers(v []*EksContainerOverride) *EksPodPropertiesOverride {
	s.InitContainers = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *EksPodPropertiesOverride) SetMetadata(v *EksMetadata) *EksPodPropertiesOverride {
	s.Metadata = v
	return s
}

// An object that contains the properties for the Kubernetes resources of a
// job.
type EksProperties struct {
	_ struct{} `type:"structure"`

	// The properties for the Kubernetes pod resources of a job.
	PodProperties *EksPodProperties `locationName:"podProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksProperties"}
	if s.PodProperties != nil {
		if err := s.PodProperties.Validate(); err != nil {
			invalidParams.AddNested("PodProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPodProperties sets the PodProperties field's value.
func (s *EksProperties) SetPodProperties(v *EksPodProperties) *EksProperties {
	s.PodProperties = v
	return s
}

// An object that contains the details for the Kubernetes resources of a job.
type EksPropertiesDetail struct {
	_ struct{} `type:"structure"`

	// The properties for the Kubernetes pod resources of a job.
	PodProperties *EksPodPropertiesDetail `locationName:"podProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPropertiesDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPropertiesDetail) GoString() string {
	return s.String()
}

// SetPodProperties sets the PodProperties field's value.
func (s *EksPropertiesDetail) SetPodProperties(v *EksPodPropertiesDetail) *EksPropertiesDetail {
	s.PodProperties = v
	return s
}

// An object that contains overrides for the Kubernetes resources of a job.
type EksPropertiesOverride struct {
	_ struct{} `type:"structure"`

	// The overrides for the Kubernetes pod resources of a job.
	PodProperties *EksPodPropertiesOverride `locationName:"podProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPropertiesOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksPropertiesOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksPropertiesOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksPropertiesOverride"}
	if s.PodProperties != nil {
		if err := s.PodProperties.Validate(); err != nil {
			invalidParams.AddNested("PodProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPodProperties sets the PodProperties field's value.
func (s *EksPropertiesOverride) SetPodProperties(v *EksPodPropertiesOverride) *EksPropertiesOverride {
	s.PodProperties = v
	return s
}

// Specifies the configuration of a Kubernetes secret volume. For more information,
// see secret (https://kubernetes.io/docs/concepts/storage/volumes/#secret)
// in the Kubernetes documentation.
type EksSecret struct {
	_ struct{} `type:"structure"`

	// Specifies whether the secret or the secret's keys must be defined.
	Optional *bool `locationName:"optional" type:"boolean"`

	// The name of the secret. The name must be allowed as a DNS subdomain name.
	// For more information, see DNS subdomain names (https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names)
	// in the Kubernetes documentation.
	//
	// SecretName is a required field
	SecretName *string `locationName:"secretName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksSecret) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksSecret) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksSecret) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksSecret"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptional sets the Optional field's value.
func (s *EksSecret) SetOptional(v bool) *EksSecret {
	s.Optional = &v
	return s
}

// SetSecretName sets the SecretName field's value.
func (s *EksSecret) SetSecretName(v string) *EksSecret {
	s.SecretName = &v
	return s
}

// Specifies an Amazon EKS volume for a job definition.
type EksVolume struct {
	_ struct{} `type:"structure"`

	// Specifies the configuration of a Kubernetes emptyDir volume. For more information,
	// see emptyDir (https://kubernetes.io/docs/concepts/storage/volumes/#emptydir)
	// in the Kubernetes documentation.
	EmptyDir *EksEmptyDir `locationName:"emptyDir" type:"structure"`

	// Specifies the configuration of a Kubernetes hostPath volume. For more information,
	// see hostPath (https://kubernetes.io/docs/concepts/storage/volumes/#hostpath)
	// in the Kubernetes documentation.
	HostPath *EksHostPath `locationName:"hostPath" type:"structure"`

	// The name of the volume. The name must be allowed as a DNS subdomain name.
	// For more information, see DNS subdomain names (https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names)
	// in the Kubernetes documentation.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Specifies the configuration of a Kubernetes secret volume. For more information,
	// see secret (https://kubernetes.io/docs/concepts/storage/volumes/#secret)
	// in the Kubernetes documentation.
	Secret *EksSecret `locationName:"secret" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksVolume) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EksVolume) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EksVolume"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.EmptyDir != nil {
		if err := s.EmptyDir.Validate(); err != nil {
			invalidParams.AddNested("EmptyDir", err.(request.ErrInvalidParams))
		}
	}
	if s.Secret != nil {
		if err := s.Secret.Validate(); err != nil {
			invalidParams.AddNested("Secret", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmptyDir sets the EmptyDir field's value.
func (s *EksVolume) SetEmptyDir(v *EksEmptyDir) *EksVolume {
	s.EmptyDir = v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *EksVolume) SetHostPath(v *EksHostPath) *EksVolume {
	s.HostPath = v
	return s
}

// SetName sets the Name field's value.
func (s *EksVolume) SetName(v string) *EksVolume {
	s.Name = &v
	return s
}

// SetSecret sets the Secret field's value.
func (s *EksVolume) SetSecret(v *EksSecret) *EksVolume {
	s.Secret = v
	return s
}

// The amount of ephemeral storage to allocate for the task. This parameter
// is used to expand the total amount of ephemeral storage available, beyond
// the default amount, for tasks hosted on Fargate.
type EphemeralStorage struct {
	_ struct{} `type:"structure"`

	// The total amount, in GiB, of ephemeral storage to set for the task. The minimum
	// supported value is 21 GiB and the maximum supported value is 200 GiB.
	//
	// SizeInGiB is a required field
	SizeInGiB *int64 `locationName:"sizeInGiB" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EphemeralStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EphemeralStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EphemeralStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EphemeralStorage"}
	if s.SizeInGiB == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeInGiB"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSizeInGiB sets the SizeInGiB field's value.
func (s *EphemeralStorage) SetSizeInGiB(v int64) *EphemeralStorage {
	s.SizeInGiB = &v
	return s
}

// Specifies an array of up to 5 conditions to be met, and an action to take
// (RETRY or EXIT) if all conditions are met. If none of the EvaluateOnExit
// conditions in a RetryStrategy match, then the job is retried.
type EvaluateOnExit struct {
	_ struct{} `type:"structure"`

	// Specifies the action to take if all of the specified conditions (onStatusReason,
	// onReason, and onExitCode) are met. The values aren't case sensitive.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"RetryAction"`

	// Contains a glob pattern to match against the decimal representation of the
	// ExitCode returned for a job. The pattern can be up to 512 characters long.
	// It can contain only numbers, and can end with an asterisk (*) so that only
	// the start of the string needs to be an exact match.
	//
	// The string can contain up to 512 characters.
	OnExitCode *string `locationName:"onExitCode" type:"string"`

	// Contains a glob pattern to match against the Reason returned for a job. The
	// pattern can contain up to 512 characters. It can contain letters, numbers,
	// periods (.), colons (:), and white space (including spaces and tabs). It
	// can optionally end with an asterisk (*) so that only the start of the string
	// needs to be an exact match.
	OnReason *string `locationName:"onReason" type:"string"`

	// Contains a glob pattern to match against the StatusReason returned for a
	// job. The pattern can contain up to 512 characters. It can contain letters,
	// numbers, periods (.), colons (:), and white spaces (including spaces or tabs).
	// It can optionally end with an asterisk (*) so that only the start of the
	// string needs to be an exact match.
	OnStatusReason *string `locationName:"onStatusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateOnExit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateOnExit) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluateOnExit) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluateOnExit"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *EvaluateOnExit) SetAction(v string) *EvaluateOnExit {
	s.Action = &v
	return s
}

// SetOnExitCode sets the OnExitCode field's value.
func (s *EvaluateOnExit) SetOnExitCode(v string) *EvaluateOnExit {
	s.OnExitCode = &v
	return s
}

// SetOnReason sets the OnReason field's value.
func (s *EvaluateOnExit) SetOnReason(v string) *EvaluateOnExit {
	s.OnReason = &v
	return s
}

// SetOnStatusReason sets the OnStatusReason field's value.
func (s *EvaluateOnExit) SetOnStatusReason(v string) *EvaluateOnExit {
	s.OnStatusReason = &v
	return s
}

// The fair share policy for a scheduling policy.
type FairsharePolicy struct {
	_ struct{} `type:"structure"`

	// A value used to reserve some of the available maximum vCPU for fair share
	// identifiers that aren't already used.
	//
	// The reserved ratio is (computeReservation/100)^ActiveFairShares where ActiveFairShares
	// is the number of active fair share identifiers.
	//
	// For example, a computeReservation value of 50 indicates that Batch reserves
	// 50% of the maximum available vCPU if there's only one fair share identifier.
	// It reserves 25% if there are two fair share identifiers. It reserves 12.5%
	// if there are three fair share identifiers. A computeReservation value of
	// 25 indicates that Batch should reserve 25% of the maximum available vCPU
	// if there's only one fair share identifier, 6.25% if there are two fair share
	// identifiers, and 1.56% if there are three fair share identifiers.
	//
	// The minimum value is 0 and the maximum value is 99.
	ComputeReservation *int64 `locationName:"computeReservation" type:"integer"`

	// The amount of time (in seconds) to use to calculate a fair share percentage
	// for each fair share identifier in use. A value of zero (0) indicates that
	// only current usage is measured. The decay allows for more recently run jobs
	// to have more weight than jobs that ran earlier. The maximum supported value
	// is 604800 (1 week).
	ShareDecaySeconds *int64 `locationName:"shareDecaySeconds" type:"integer"`

	// An array of SharedIdentifier objects that contain the weights for the fair
	// share identifiers for the fair share policy. Fair share identifiers that
	// aren't included have a default weight of 1.0.
	ShareDistribution []*ShareAttributes `locationName:"shareDistribution" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FairsharePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FairsharePolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FairsharePolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FairsharePolicy"}
	if s.ShareDistribution != nil {
		for i, v := range s.ShareDistribution {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ShareDistribution", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeReservation sets the ComputeReservation field's value.
func (s *FairsharePolicy) SetComputeReservation(v int64) *FairsharePolicy {
	s.ComputeReservation = &v
	return s
}

// SetShareDecaySeconds sets the ShareDecaySeconds field's value.
func (s *FairsharePolicy) SetShareDecaySeconds(v int64) *FairsharePolicy {
	s.ShareDecaySeconds = &v
	return s
}

// SetShareDistribution sets the ShareDistribution field's value.
func (s *FairsharePolicy) SetShareDistribution(v []*ShareAttributes) *FairsharePolicy {
	s.ShareDistribution = v
	return s
}

// The platform configuration for jobs that are running on Fargate resources.
// Jobs that run on Amazon EC2 resources must not specify this parameter.
type FargatePlatformConfiguration struct {
	_ struct{} `type:"structure"`

	// The Fargate platform version where the jobs are running. A platform version
	// is specified only for jobs that are running on Fargate resources. If one
	// isn't specified, the LATEST platform version is used by default. This uses
	// a recent, approved version of the Fargate platform for compute resources.
	// For more information, see Fargate platform versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargatePlatformConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargatePlatformConfiguration) GoString() string {
	return s.String()
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *FargatePlatformConfiguration) SetPlatformVersion(v string) *FargatePlatformConfiguration {
	s.PlatformVersion = &v
	return s
}

// Determine whether your data volume persists on the host container instance
// and where it's stored. If this parameter is empty, then the Docker daemon
// assigns a host path for your data volume. However, the data isn't guaranteed
// to persist after the containers that are associated with it stop running.
type Host struct {
	_ struct{} `type:"structure"`

	// The path on the host container instance that's presented to the container.
	// If this parameter is empty, then the Docker daemon has assigned a host path
	// for you. If this parameter contains a file location, then the data volume
	// persists at the specified location on the host container instance until you
	// delete it manually. If the source path location doesn't exist on the host
	// container instance, the Docker daemon creates it. If the location does exist,
	// the contents of the source path folder are exported.
	//
	// This parameter isn't applicable to jobs that run on Fargate resources. Don't
	// provide this for these jobs.
	SourcePath *string `locationName:"sourcePath" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Host) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Host) GoString() string {
	return s.String()
}

// SetSourcePath sets the SourcePath field's value.
func (s *Host) SetSourcePath(v string) *Host {
	s.SourcePath = &v
	return s
}

// An object that represents an Batch job definition.
type JobDefinition struct {
	_ struct{} `type:"structure"`

	// The orchestration type of the compute environment. The valid values are ECS
	// (default) or EKS.
	ContainerOrchestrationType *string `locationName:"containerOrchestrationType" type:"string" enum:"OrchestrationType"`

	// An object with properties specific to Amazon ECS-based jobs. When containerProperties
	// is used in the job definition, it can't be used in addition to eksProperties,
	// ecsProperties, or nodeProperties.
	ContainerProperties *ContainerProperties `locationName:"containerProperties" type:"structure"`

	// An object that contains the properties for the Amazon ECS resources of a
	// job.When ecsProperties is used in the job definition, it can't be used in
	// addition to containerProperties, eksProperties, or nodeProperties.
	EcsProperties *EcsProperties `locationName:"ecsProperties" type:"structure"`

	// An object with properties that are specific to Amazon EKS-based jobs. When
	// eksProperties is used in the job definition, it can't be used in addition
	// to containerProperties, ecsProperties, or nodeProperties.
	EksProperties *EksProperties `locationName:"eksProperties" type:"structure"`

	// The Amazon Resource Name (ARN) for the job definition.
	//
	// JobDefinitionArn is a required field
	JobDefinitionArn *string `locationName:"jobDefinitionArn" type:"string" required:"true"`

	// The name of the job definition.
	//
	// JobDefinitionName is a required field
	JobDefinitionName *string `locationName:"jobDefinitionName" type:"string" required:"true"`

	// An object with properties that are specific to multi-node parallel jobs.
	// When nodeProperties is used in the job definition, it can't be used in addition
	// to containerProperties, ecsProperties, or eksProperties.
	//
	// If the job runs on Fargate resources, don't specify nodeProperties. Use containerProperties
	// instead.
	NodeProperties *NodeProperties `locationName:"nodeProperties" type:"structure"`

	// Default parameters or parameter substitution placeholders that are set in
	// the job definition. Parameters are specified as a key-value pair mapping.
	// Parameters in a SubmitJob request override any corresponding parameter defaults
	// from the job definition. For more information about specifying parameters,
	// see Job definition parameters (https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html)
	// in the Batch User Guide.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The platform capabilities required by the job definition. If no value is
	// specified, it defaults to EC2. Jobs run on Fargate resources specify FARGATE.
	PlatformCapabilities []*string `locationName:"platformCapabilities" type:"list" enum:"PlatformCapability"`

	// Specifies whether to propagate the tags from the job or job definition to
	// the corresponding Amazon ECS task. If no value is specified, the tags aren't
	// propagated. Tags can only be propagated to the tasks when the tasks are created.
	// For tags with the same name, job tags are given priority over job definitions
	// tags. If the total number of combined tags from the job and job definition
	// is over 50, the job is moved to the FAILED state.
	PropagateTags *bool `locationName:"propagateTags" type:"boolean"`

	// The retry strategy to use for failed jobs that are submitted with this job
	// definition.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`

	// The revision of the job definition.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"integer" required:"true"`

	// The scheduling priority of the job definition. This only affects jobs in
	// job queues with a fair share policy. Jobs with a higher scheduling priority
	// are scheduled before jobs with a lower scheduling priority.
	SchedulingPriority *int64 `locationName:"schedulingPriority" type:"integer"`

	// The status of the job definition.
	Status *string `locationName:"status" type:"string"`

	// The tags that are applied to the job definition.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The timeout time for jobs that are submitted with this job definition. After
	// the amount of time you specify passes, Batch terminates your jobs if they
	// aren't finished.
	Timeout *JobTimeout `locationName:"timeout" type:"structure"`

	// The type of job definition. It's either container or multinode. If the job
	// is run on Fargate resources, then multinode isn't supported. For more information
	// about multi-node parallel jobs, see Creating a multi-node parallel job definition
	// (https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html)
	// in the Batch User Guide.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDefinition) GoString() string {
	return s.String()
}

// SetContainerOrchestrationType sets the ContainerOrchestrationType field's value.
func (s *JobDefinition) SetContainerOrchestrationType(v string) *JobDefinition {
	s.ContainerOrchestrationType = &v
	return s
}

// SetContainerProperties sets the ContainerProperties field's value.
func (s *JobDefinition) SetContainerProperties(v *ContainerProperties) *JobDefinition {
	s.ContainerProperties = v
	return s
}

// SetEcsProperties sets the EcsProperties field's value.
func (s *JobDefinition) SetEcsProperties(v *EcsProperties) *JobDefinition {
	s.EcsProperties = v
	return s
}

// SetEksProperties sets the EksProperties field's value.
func (s *JobDefinition) SetEksProperties(v *EksProperties) *JobDefinition {
	s.EksProperties = v
	return s
}

// SetJobDefinitionArn sets the JobDefinitionArn field's value.
func (s *JobDefinition) SetJobDefinitionArn(v string) *JobDefinition {
	s.JobDefinitionArn = &v
	return s
}

// SetJobDefinitionName sets the JobDefinitionName field's value.
func (s *JobDefinition) SetJobDefinitionName(v string) *JobDefinition {
	s.JobDefinitionName = &v
	return s
}

// SetNodeProperties sets the NodeProperties field's value.
func (s *JobDefinition) SetNodeProperties(v *NodeProperties) *JobDefinition {
	s.NodeProperties = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *JobDefinition) SetParameters(v map[string]*string) *JobDefinition {
	s.Parameters = v
	return s
}

// SetPlatformCapabilities sets the PlatformCapabilities field's value.
func (s *JobDefinition) SetPlatformCapabilities(v []*string) *JobDefinition {
	s.PlatformCapabilities = v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *JobDefinition) SetPropagateTags(v bool) *JobDefinition {
	s.PropagateTags = &v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *JobDefinition) SetRetryStrategy(v *RetryStrategy) *JobDefinition {
	s.RetryStrategy = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *JobDefinition) SetRevision(v int64) *JobDefinition {
	s.Revision = &v
	return s
}

// SetSchedulingPriority sets the SchedulingPriority field's value.
func (s *JobDefinition) SetSchedulingPriority(v int64) *JobDefinition {
	s.SchedulingPriority = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobDefinition) SetStatus(v string) *JobDefinition {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *JobDefinition) SetTags(v map[string]*string) *JobDefinition {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *JobDefinition) SetTimeout(v *JobTimeout) *JobDefinition {
	s.Timeout = v
	return s
}

// SetType sets the Type field's value.
func (s *JobDefinition) SetType(v string) *JobDefinition {
	s.Type = &v
	return s
}

// An object that represents an Batch job dependency.
type JobDependency struct {
	_ struct{} `type:"structure"`

	// The job ID of the Batch job that's associated with this dependency.
	JobId *string `locationName:"jobId" type:"string"`

	// The type of the job dependency.
	Type *string `locationName:"type" type:"string" enum:"ArrayJobDependency"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDependency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDependency) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *JobDependency) SetJobId(v string) *JobDependency {
	s.JobId = &v
	return s
}

// SetType sets the Type field's value.
func (s *JobDependency) SetType(v string) *JobDependency {
	s.Type = &v
	return s
}

// An object that represents an Batch job.
type JobDetail struct {
	_ struct{} `type:"structure"`

	// The array properties of the job, if it's an array job.
	ArrayProperties *ArrayPropertiesDetail `locationName:"arrayProperties" type:"structure"`

	// A list of job attempts that are associated with this job.
	Attempts []*AttemptDetail `locationName:"attempts" type:"list"`

	// An object that represents the details for the container that's associated
	// with the job. If the details are for a multiple-container job, this object
	// will be empty.
	Container *ContainerDetail `locationName:"container" type:"structure"`

	// The Unix timestamp (in milliseconds) for when the job was created. For non-array
	// jobs and parent array jobs, this is when the job entered the SUBMITTED state.
	// This is specifically at the time SubmitJob (https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html)
	// was called. For array child jobs, this is when the child job was spawned
	// by its parent and entered the PENDING state.
	CreatedAt *int64 `locationName:"createdAt" type:"long"`

	// A list of job IDs that this job depends on.
	DependsOn []*JobDependency `locationName:"dependsOn" type:"list"`

	// An object with properties that are specific to Amazon ECS-based jobs.
	EcsProperties *EcsPropertiesDetail `locationName:"ecsProperties" type:"structure"`

	// A list of job attempts that are associated with this job.
	EksAttempts []*EksAttemptDetail `locationName:"eksAttempts" type:"list"`

	// An object with various properties that are specific to Amazon EKS based jobs.
	EksProperties *EksPropertiesDetail `locationName:"eksProperties" type:"structure"`

	// Indicates whether the job is canceled.
	IsCancelled *bool `locationName:"isCancelled" type:"boolean"`

	// Indicates whether the job is terminated.
	IsTerminated *bool `locationName:"isTerminated" type:"boolean"`

	// The Amazon Resource Name (ARN) of the job.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The Amazon Resource Name (ARN) of the job definition that this job uses.
	//
	// JobDefinition is a required field
	JobDefinition *string `locationName:"jobDefinition" type:"string" required:"true"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The job name.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the job queue that the job is associated
	// with.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`

	// An object that represents the details of a node that's associated with a
	// multi-node parallel job.
	NodeDetails *NodeDetails `locationName:"nodeDetails" type:"structure"`

	// An object that represents the node properties of a multi-node parallel job.
	//
	// This isn't applicable to jobs that are running on Fargate resources.
	NodeProperties *NodeProperties `locationName:"nodeProperties" type:"structure"`

	// Additional parameters that are passed to the job that replace parameter substitution
	// placeholders or override any corresponding parameter defaults from the job
	// definition.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The platform capabilities required by the job definition. If no value is
	// specified, it defaults to EC2. Jobs run on Fargate resources specify FARGATE.
	PlatformCapabilities []*string `locationName:"platformCapabilities" type:"list" enum:"PlatformCapability"`

	// Specifies whether to propagate the tags from the job or job definition to
	// the corresponding Amazon ECS task. If no value is specified, the tags aren't
	// propagated. Tags can only be propagated to the tasks when the tasks are created.
	// For tags with the same name, job tags are given priority over job definitions
	// tags. If the total number of combined tags from the job and job definition
	// is over 50, the job is moved to the FAILED state.
	PropagateTags *bool `locationName:"propagateTags" type:"boolean"`

	// The retry strategy to use for this job if an attempt fails.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`

	// The scheduling policy of the job definition. This only affects jobs in job
	// queues with a fair share policy. Jobs with a higher scheduling priority are
	// scheduled before jobs with a lower scheduling priority.
	SchedulingPriority *int64 `locationName:"schedulingPriority" type:"integer"`

	// The share identifier for the job.
	ShareIdentifier *string `locationName:"shareIdentifier" type:"string"`

	// The Unix timestamp (in milliseconds) for when the job was started. More specifically,
	// it's when the job transitioned from the STARTING state to the RUNNING state.
	//
	// StartedAt is a required field
	StartedAt *int64 `locationName:"startedAt" type:"long" required:"true"`

	// The current status for the job.
	//
	// If your jobs don't progress to STARTING, see Jobs stuck in RUNNABLE status
	// (https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable)
	// in the troubleshooting section of the Batch User Guide.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`

	// A short, human-readable string to provide more details for the current status
	// of the job.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The Unix timestamp (in milliseconds) for when the job was stopped. More specifically,
	// it's when the job transitioned from the RUNNING state to a terminal state,
	// such as SUCCEEDED or FAILED.
	StoppedAt *int64 `locationName:"stoppedAt" type:"long"`

	// The tags that are applied to the job.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The timeout configuration for the job.
	Timeout *JobTimeout `locationName:"timeout" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetail) GoString() string {
	return s.String()
}

// SetArrayProperties sets the ArrayProperties field's value.
func (s *JobDetail) SetArrayProperties(v *ArrayPropertiesDetail) *JobDetail {
	s.ArrayProperties = v
	return s
}

// SetAttempts sets the Attempts field's value.
func (s *JobDetail) SetAttempts(v []*AttemptDetail) *JobDetail {
	s.Attempts = v
	return s
}

// SetContainer sets the Container field's value.
func (s *JobDetail) SetContainer(v *ContainerDetail) *JobDetail {
	s.Container = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobDetail) SetCreatedAt(v int64) *JobDetail {
	s.CreatedAt = &v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *JobDetail) SetDependsOn(v []*JobDependency) *JobDetail {
	s.DependsOn = v
	return s
}

// SetEcsProperties sets the EcsProperties field's value.
func (s *JobDetail) SetEcsProperties(v *EcsPropertiesDetail) *JobDetail {
	s.EcsProperties = v
	return s
}

// SetEksAttempts sets the EksAttempts field's value.
func (s *JobDetail) SetEksAttempts(v []*EksAttemptDetail) *JobDetail {
	s.EksAttempts = v
	return s
}

// SetEksProperties sets the EksProperties field's value.
func (s *JobDetail) SetEksProperties(v *EksPropertiesDetail) *JobDetail {
	s.EksProperties = v
	return s
}

// SetIsCancelled sets the IsCancelled field's value.
func (s *JobDetail) SetIsCancelled(v bool) *JobDetail {
	s.IsCancelled = &v
	return s
}

// SetIsTerminated sets the IsTerminated field's value.
func (s *JobDetail) SetIsTerminated(v bool) *JobDetail {
	s.IsTerminated = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *JobDetail) SetJobArn(v string) *JobDetail {
	s.JobArn = &v
	return s
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *JobDetail) SetJobDefinition(v string) *JobDetail {
	s.JobDefinition = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobDetail) SetJobId(v string) *JobDetail {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *JobDetail) SetJobName(v string) *JobDetail {
	s.JobName = &v
	return s
}

// SetJobQueue sets the JobQueue field's value.
func (s *JobDetail) SetJobQueue(v string) *JobDetail {
	s.JobQueue = &v
	return s
}

// SetNodeDetails sets the NodeDetails field's value.
func (s *JobDetail) SetNodeDetails(v *NodeDetails) *JobDetail {
	s.NodeDetails = v
	return s
}

// SetNodeProperties sets the NodeProperties field's value.
func (s *JobDetail) SetNodeProperties(v *NodeProperties) *JobDetail {
	s.NodeProperties = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *JobDetail) SetParameters(v map[string]*string) *JobDetail {
	s.Parameters = v
	return s
}

// SetPlatformCapabilities sets the PlatformCapabilities field's value.
func (s *JobDetail) SetPlatformCapabilities(v []*string) *JobDetail {
	s.PlatformCapabilities = v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *JobDetail) SetPropagateTags(v bool) *JobDetail {
	s.PropagateTags = &v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *JobDetail) SetRetryStrategy(v *RetryStrategy) *JobDetail {
	s.RetryStrategy = v
	return s
}

// SetSchedulingPriority sets the SchedulingPriority field's value.
func (s *JobDetail) SetSchedulingPriority(v int64) *JobDetail {
	s.SchedulingPriority = &v
	return s
}

// SetShareIdentifier sets the ShareIdentifier field's value.
func (s *JobDetail) SetShareIdentifier(v string) *JobDetail {
	s.ShareIdentifier = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *JobDetail) SetStartedAt(v int64) *JobDetail {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobDetail) SetStatus(v string) *JobDetail {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *JobDetail) SetStatusReason(v string) *JobDetail {
	s.StatusReason = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *JobDetail) SetStoppedAt(v int64) *JobDetail {
	s.StoppedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *JobDetail) SetTags(v map[string]*string) *JobDetail {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *JobDetail) SetTimeout(v *JobTimeout) *JobDetail {
	s.Timeout = v
	return s
}

// An object that represents the details for an Batch job queue.
type JobQueueDetail struct {
	_ struct{} `type:"structure"`

	// The compute environments that are attached to the job queue and the order
	// that job placement is preferred. Compute environments are selected for job
	// placement in ascending order.
	//
	// ComputeEnvironmentOrder is a required field
	ComputeEnvironmentOrder []*ComputeEnvironmentOrder `locationName:"computeEnvironmentOrder" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the job queue.
	//
	// JobQueueArn is a required field
	JobQueueArn *string `locationName:"jobQueueArn" type:"string" required:"true"`

	// The job queue name.
	//
	// JobQueueName is a required field
	JobQueueName *string `locationName:"jobQueueName" type:"string" required:"true"`

	// The priority of the job queue. Job queues with a higher priority (or a higher
	// integer value for the priority parameter) are evaluated first when associated
	// with the same compute environment. Priority is determined in descending order.
	// For example, a job queue with a priority value of 10 is given scheduling
	// preference over a job queue with a priority value of 1. All of the compute
	// environments must be either Amazon EC2 (EC2 or SPOT) or Fargate (FARGATE
	// or FARGATE_SPOT). Amazon EC2 and Fargate compute environments can't be mixed.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the scheduling policy. The format is aws:Partition:batch:Region:Account:scheduling-policy/Name
	// . For example, aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy.
	SchedulingPolicyArn *string `locationName:"schedulingPolicyArn" type:"string"`

	// Describes the ability of the queue to accept new jobs. If the job queue state
	// is ENABLED, it can accept jobs. If the job queue state is DISABLED, new jobs
	// can't be added to the queue, but jobs already in the queue can finish.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"JQState"`

	// The status of the job queue (for example, CREATING or VALID).
	Status *string `locationName:"status" type:"string" enum:"JQStatus"`

	// A short, human-readable string to provide additional details for the current
	// status of the job queue.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The tags that are applied to the job queue. For more information, see Tagging
	// your Batch resources (https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html)
	// in Batch User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobQueueDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobQueueDetail) GoString() string {
	return s.String()
}

// SetComputeEnvironmentOrder sets the ComputeEnvironmentOrder field's value.
func (s *JobQueueDetail) SetComputeEnvironmentOrder(v []*ComputeEnvironmentOrder) *JobQueueDetail {
	s.ComputeEnvironmentOrder = v
	return s
}

// SetJobQueueArn sets the JobQueueArn field's value.
func (s *JobQueueDetail) SetJobQueueArn(v string) *JobQueueDetail {
	s.JobQueueArn = &v
	return s
}

// SetJobQueueName sets the JobQueueName field's value.
func (s *JobQueueDetail) SetJobQueueName(v string) *JobQueueDetail {
	s.JobQueueName = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobQueueDetail) SetPriority(v int64) *JobQueueDetail {
	s.Priority = &v
	return s
}

// SetSchedulingPolicyArn sets the SchedulingPolicyArn field's value.
func (s *JobQueueDetail) SetSchedulingPolicyArn(v string) *JobQueueDetail {
	s.SchedulingPolicyArn = &v
	return s
}

// SetState sets the State field's value.
func (s *JobQueueDetail) SetState(v string) *JobQueueDetail {
	s.State = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobQueueDetail) SetStatus(v string) *JobQueueDetail {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *JobQueueDetail) SetStatusReason(v string) *JobQueueDetail {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *JobQueueDetail) SetTags(v map[string]*string) *JobQueueDetail {
	s.Tags = v
	return s
}

// An object that represents summary details of a job.
type JobSummary struct {
	_ struct{} `type:"structure"`

	// The array properties of the job, if it's an array job.
	ArrayProperties *ArrayPropertiesSummary `locationName:"arrayProperties" type:"structure"`

	// An object that represents the details of the container that's associated
	// with the job.
	Container *ContainerSummary `locationName:"container" type:"structure"`

	// The Unix timestamp (in milliseconds) for when the job was created. For non-array
	// jobs and parent array jobs, this is when the job entered the SUBMITTED state
	// (at the time SubmitJob (https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html)
	// was called). For array child jobs, this is when the child job was spawned
	// by its parent and entered the PENDING state.
	CreatedAt *int64 `locationName:"createdAt" type:"long"`

	// The Amazon Resource Name (ARN) of the job.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The Amazon Resource Name (ARN) of the job definition.
	JobDefinition *string `locationName:"jobDefinition" type:"string"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The job name.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`

	// The node properties for a single node in a job summary list.
	//
	// This isn't applicable to jobs that are running on Fargate resources.
	NodeProperties *NodePropertiesSummary `locationName:"nodeProperties" type:"structure"`

	// The Unix timestamp for when the job was started. More specifically, it's
	// when the job transitioned from the STARTING state to the RUNNING state.
	StartedAt *int64 `locationName:"startedAt" type:"long"`

	// The current status for the job.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`

	// A short, human-readable string to provide more details for the current status
	// of the job.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The Unix timestamp for when the job was stopped. More specifically, it's
	// when the job transitioned from the RUNNING state to a terminal state, such
	// as SUCCEEDED or FAILED.
	StoppedAt *int64 `locationName:"stoppedAt" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSummary) GoString() string {
	return s.String()
}

// SetArrayProperties sets the ArrayProperties field's value.
func (s *JobSummary) SetArrayProperties(v *ArrayPropertiesSummary) *JobSummary {
	s.ArrayProperties = v
	return s
}

// SetContainer sets the Container field's value.
func (s *JobSummary) SetContainer(v *ContainerSummary) *JobSummary {
	s.Container = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobSummary) SetCreatedAt(v int64) *JobSummary {
	s.CreatedAt = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *JobSummary) SetJobArn(v string) *JobSummary {
	s.JobArn = &v
	return s
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *JobSummary) SetJobDefinition(v string) *JobSummary {
	s.JobDefinition = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobSummary) SetJobId(v string) *JobSummary {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *JobSummary) SetJobName(v string) *JobSummary {
	s.JobName = &v
	return s
}

// SetNodeProperties sets the NodeProperties field's value.
func (s *JobSummary) SetNodeProperties(v *NodePropertiesSummary) *JobSummary {
	s.NodeProperties = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *JobSummary) SetStartedAt(v int64) *JobSummary {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobSummary) SetStatus(v string) *JobSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *JobSummary) SetStatusReason(v string) *JobSummary {
	s.StatusReason = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *JobSummary) SetStoppedAt(v int64) *JobSummary {
	s.StoppedAt = &v
	return s
}

// An object that represents a job timeout configuration.
type JobTimeout struct {
	_ struct{} `type:"structure"`

	// The job timeout time (in seconds) that's measured from the job attempt's
	// startedAt timestamp. After this time passes, Batch terminates your jobs if
	// they aren't finished. The minimum value for the timeout is 60 seconds.
	//
	// For array jobs, the timeout applies to the child jobs, not to the parent
	// array job.
	//
	// For multi-node parallel (MNP) jobs, the timeout applies to the whole job,
	// not to the individual nodes.
	AttemptDurationSeconds *int64 `locationName:"attemptDurationSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobTimeout) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobTimeout) GoString() string {
	return s.String()
}

// SetAttemptDurationSeconds sets the AttemptDurationSeconds field's value.
func (s *JobTimeout) SetAttemptDurationSeconds(v int64) *JobTimeout {
	s.AttemptDurationSeconds = &v
	return s
}

// A key-value pair object.
type KeyValuePair struct {
	_ struct{} `type:"structure"`

	// The name of the key-value pair. For environment variables, this is the name
	// of the environment variable.
	Name *string `locationName:"name" type:"string"`

	// The value of the key-value pair. For environment variables, this is the value
	// of the environment variable.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValuePair) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *KeyValuePair) SetName(v string) *KeyValuePair {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *KeyValuePair) SetValue(v string) *KeyValuePair {
	s.Value = &v
	return s
}

// A filter name and value pair that's used to return a more specific list of
// results from a ListJobs API operation.
type KeyValuesPair struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case sensitive.
	Name *string `locationName:"name" type:"string"`

	// The filter values.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValuesPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValuesPair) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *KeyValuesPair) SetName(v string) *KeyValuesPair {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *KeyValuesPair) SetValues(v []*string) *KeyValuesPair {
	s.Values = v
	return s
}

// An object that represents a launch template that's associated with a compute
// resource. You must specify either the launch template ID or launch template
// name in the request, but not both.
//
// If security groups are specified using both the securityGroupIds parameter
// of CreateComputeEnvironment and the launch template, the values in the securityGroupIds
// parameter of CreateComputeEnvironment will be used.
//
// This object isn't applicable to jobs that are running on Fargate resources.
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	LaunchTemplateId *string `locationName:"launchTemplateId" type:"string"`

	// The name of the launch template.
	LaunchTemplateName *string `locationName:"launchTemplateName" type:"string"`

	// The version number of the launch template, $Latest, or $Default.
	//
	// If the value is $Latest, the latest version of the launch template is used.
	// If the value is $Default, the default version of the launch template is used.
	//
	// If the AMI ID that's used in a compute environment is from the launch template,
	// the AMI isn't changed when the compute environment is updated. It's only
	// changed if the updateToLatestImageVersion parameter for the compute environment
	// is set to true. During an infrastructure update, if either $Latest or $Default
	// is specified, Batch re-evaluates the launch template version, and it might
	// use a different version of the launch template. This is the case even if
	// the launch template isn't specified in the update. When updating a compute
	// environment, changing the launch template requires an infrastructure update
	// of the compute environment. For more information, see Updating compute environments
	// (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// Default: $Default.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) GoString() string {
	return s.String()
}

// SetLaunchTemplateId sets the LaunchTemplateId field's value.
func (s *LaunchTemplateSpecification) SetLaunchTemplateId(v string) *LaunchTemplateSpecification {
	s.LaunchTemplateId = &v
	return s
}

// SetLaunchTemplateName sets the LaunchTemplateName field's value.
func (s *LaunchTemplateSpecification) SetLaunchTemplateName(v string) *LaunchTemplateSpecification {
	s.LaunchTemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *LaunchTemplateSpecification) SetVersion(v string) *LaunchTemplateSpecification {
	s.Version = &v
	return s
}

// Linux-specific modifications that are applied to the container, such as details
// for device mappings.
type LinuxParameters struct {
	_ struct{} `type:"structure"`

	// Any of the host devices to expose to the container. This parameter maps to
	// Devices in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --device option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide it for these jobs.
	Devices []*Device `locationName:"devices" type:"list"`

	// If true, run an init process inside the container that forwards signals and
	// reaps processes. This parameter maps to the --init option to docker run (https://docs.docker.com/engine/reference/run/).
	// This parameter requires version 1.25 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version | grep "Server API version"
	InitProcessEnabled *bool `locationName:"initProcessEnabled" type:"boolean"`

	// The total amount of swap memory (in MiB) a container can use. This parameter
	// is translated to the --memory-swap option to docker run (https://docs.docker.com/engine/reference/run/)
	// where the value is the sum of the container memory plus the maxSwap value.
	// For more information, see --memory-swap details (https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details)
	// in the Docker documentation.
	//
	// If a maxSwap value of 0 is specified, the container doesn't use swap. Accepted
	// values are 0 or any positive integer. If the maxSwap parameter is omitted,
	// the container doesn't use the swap configuration for the container instance
	// that it's running on. A maxSwap value must be set for the swappiness parameter
	// to be used.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide it for these jobs.
	MaxSwap *int64 `locationName:"maxSwap" type:"integer"`

	// The value for the size (in MiB) of the /dev/shm volume. This parameter maps
	// to the --shm-size option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide it for these jobs.
	SharedMemorySize *int64 `locationName:"sharedMemorySize" type:"integer"`

	// You can use this parameter to tune a container's memory swappiness behavior.
	// A swappiness value of 0 causes swapping to not occur unless absolutely necessary.
	// A swappiness value of 100 causes pages to be swapped aggressively. Valid
	// values are whole numbers between 0 and 100. If the swappiness parameter isn't
	// specified, a default value of 60 is used. If a value isn't specified for
	// maxSwap, then this parameter is ignored. If maxSwap is set to 0, the container
	// doesn't use swap. This parameter maps to the --memory-swappiness option to
	// docker run (https://docs.docker.com/engine/reference/run/).
	//
	// Consider the following when you use a per-container swap configuration.
	//
	//    * Swap space must be enabled and allocated on the container instance for
	//    the containers to use. By default, the Amazon ECS optimized AMIs don't
	//    have swap enabled. You must enable swap on the instance to use this feature.
	//    For more information, see Instance store swap volumes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html)
	//    in the Amazon EC2 User Guide for Linux Instances or How do I allocate
	//    memory to work as swap space in an Amazon EC2 instance by using a swap
	//    file? (http://aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/)
	//
	//    * The swap space parameters are only supported for job definitions using
	//    EC2 resources.
	//
	//    * If the maxSwap and swappiness parameters are omitted from a job definition,
	//    each container has a default swappiness value of 60. Moreover, the total
	//    swap usage is limited to two times the memory reservation of the container.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide it for these jobs.
	Swappiness *int64 `locationName:"swappiness" type:"integer"`

	// The container path, mount options, and size (in MiB) of the tmpfs mount.
	// This parameter maps to the --tmpfs option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide this parameter for this resource type.
	Tmpfs []*Tmpfs `locationName:"tmpfs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LinuxParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LinuxParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LinuxParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LinuxParameters"}
	if s.Devices != nil {
		for i, v := range s.Devices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Devices", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tmpfs != nil {
		for i, v := range s.Tmpfs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tmpfs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevices sets the Devices field's value.
func (s *LinuxParameters) SetDevices(v []*Device) *LinuxParameters {
	s.Devices = v
	return s
}

// SetInitProcessEnabled sets the InitProcessEnabled field's value.
func (s *LinuxParameters) SetInitProcessEnabled(v bool) *LinuxParameters {
	s.InitProcessEnabled = &v
	return s
}

// SetMaxSwap sets the MaxSwap field's value.
func (s *LinuxParameters) SetMaxSwap(v int64) *LinuxParameters {
	s.MaxSwap = &v
	return s
}

// SetSharedMemorySize sets the SharedMemorySize field's value.
func (s *LinuxParameters) SetSharedMemorySize(v int64) *LinuxParameters {
	s.SharedMemorySize = &v
	return s
}

// SetSwappiness sets the Swappiness field's value.
func (s *LinuxParameters) SetSwappiness(v int64) *LinuxParameters {
	s.Swappiness = &v
	return s
}

// SetTmpfs sets the Tmpfs field's value.
func (s *LinuxParameters) SetTmpfs(v []*Tmpfs) *LinuxParameters {
	s.Tmpfs = v
	return s
}

// Contains the parameters for ListJobs.
type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// The job ID for an array job. Specifying an array job ID with this parameter
	// lists all child jobs from within the specified array.
	ArrayJobId *string `locationName:"arrayJobId" type:"string"`

	// The filter to apply to the query. Only one filter can be used at a time.
	// When the filter is used, jobStatus is ignored. The filter doesn't apply to
	// child jobs in an array or multi-node parallel (MNP) jobs. The results are
	// sorted by the createdAt field, with the most recent jobs being first.
	//
	// JOB_NAME
	//
	// The value of the filter is a case-insensitive match for the job name. If
	// the value ends with an asterisk (*), the filter matches any job name that
	// begins with the string before the '*'. This corresponds to the jobName value.
	// For example, test1 matches both Test1 and test1, and test1* matches both
	// test1 and Test10. When the JOB_NAME filter is used, the results are grouped
	// by the job name and version.
	//
	// JOB_DEFINITION
	//
	// The value for the filter is the name or Amazon Resource Name (ARN) of the
	// job definition. This corresponds to the jobDefinition value. The value is
	// case sensitive. When the value for the filter is the job definition name,
	// the results include all the jobs that used any revision of that job definition
	// name. If the value ends with an asterisk (*), the filter matches any job
	// definition name that begins with the string before the '*'. For example,
	// jd1 matches only jd1, and jd1* matches both jd1 and jd1A. The version of
	// the job definition that's used doesn't affect the sort order. When the JOB_DEFINITION
	// filter is used and the ARN is used (which is in the form arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}),
	// the results include jobs that used the specified revision of the job definition.
	// Asterisk (*) isn't supported when the ARN is used.
	//
	// BEFORE_CREATED_AT
	//
	// The value for the filter is the time that's before the job was created. This
	// corresponds to the createdAt value. The value is a string representation
	// of the number of milliseconds since 00:00:00 UTC (midnight) on January 1,
	// 1970.
	//
	// AFTER_CREATED_AT
	//
	// The value for the filter is the time that's after the job was created. This
	// corresponds to the createdAt value. The value is a string representation
	// of the number of milliseconds since 00:00:00 UTC (midnight) on January 1,
	// 1970.
	Filters []*KeyValuesPair `locationName:"filters" type:"list"`

	// The name or full Amazon Resource Name (ARN) of the job queue used to list
	// jobs.
	JobQueue *string `locationName:"jobQueue" type:"string"`

	// The job status used to filter jobs in the specified queue. If the filters
	// parameter is specified, the jobStatus parameter is ignored and jobs with
	// any status are returned. If you don't specify a status, only RUNNING jobs
	// are returned.
	JobStatus *string `locationName:"jobStatus" type:"string" enum:"JobStatus"`

	// The maximum number of results returned by ListJobs in paginated output. When
	// this parameter is used, ListJobs only returns maxResults results in a single
	// page and a nextToken response element. The remaining results of the initial
	// request can be seen by sending another ListJobs request with the returned
	// nextToken value. This value can be between 1 and 100. If this parameter isn't
	// used, then ListJobs returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The job ID for a multi-node parallel job. Specifying a multi-node parallel
	// job ID with this parameter lists all nodes that are associated with the specified
	// job.
	MultiNodeJobId *string `locationName:"multiNodeJobId" type:"string"`

	// The nextToken value returned from a previous paginated ListJobs request where
	// maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value. This value is null when there are no more results to return.
	//
	// Treat this token as an opaque identifier that's only used to retrieve the
	// next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) GoString() string {
	return s.String()
}

// SetArrayJobId sets the ArrayJobId field's value.
func (s *ListJobsInput) SetArrayJobId(v string) *ListJobsInput {
	s.ArrayJobId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListJobsInput) SetFilters(v []*KeyValuesPair) *ListJobsInput {
	s.Filters = v
	return s
}

// SetJobQueue sets the JobQueue field's value.
func (s *ListJobsInput) SetJobQueue(v string) *ListJobsInput {
	s.JobQueue = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ListJobsInput) SetJobStatus(v string) *ListJobsInput {
	s.JobStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetMultiNodeJobId sets the MultiNodeJobId field's value.
func (s *ListJobsInput) SetMultiNodeJobId(v string) *ListJobsInput {
	s.MultiNodeJobId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job summaries that match the request.
	//
	// JobSummaryList is a required field
	JobSummaryList []*JobSummary `locationName:"jobSummaryList" type:"list" required:"true"`

	// The nextToken value to include in a future ListJobs request. When the results
	// of a ListJobs request exceed maxResults, this value can be used to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobSummaryList sets the JobSummaryList field's value.
func (s *ListJobsOutput) SetJobSummaryList(v []*JobSummary) *ListJobsOutput {
	s.JobSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for ListSchedulingPolicies.
type ListSchedulingPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that's returned by ListSchedulingPolicies in
	// paginated output. When this parameter is used, ListSchedulingPolicies only
	// returns maxResults results in a single page and a nextToken response element.
	// You can see the remaining results of the initial request by sending another
	// ListSchedulingPolicies request with the returned nextToken value. This value
	// can be between 1 and 100. If this parameter isn't used, ListSchedulingPolicies
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value that's returned from a previous paginated ListSchedulingPolicies
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	// Treat this token as an opaque identifier that's only used to retrieve the
	// next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulingPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulingPoliciesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSchedulingPoliciesInput) SetMaxResults(v int64) *ListSchedulingPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchedulingPoliciesInput) SetNextToken(v string) *ListSchedulingPoliciesInput {
	s.NextToken = &v
	return s
}

type ListSchedulingPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListSchedulingPolicies request.
	// When the results of a ListSchedulingPolicies request exceed maxResults, this
	// value can be used to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of scheduling policies that match the request.
	SchedulingPolicies []*SchedulingPolicyListingDetail `locationName:"schedulingPolicies" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulingPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulingPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchedulingPoliciesOutput) SetNextToken(v string) *ListSchedulingPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetSchedulingPolicies sets the SchedulingPolicies field's value.
func (s *ListSchedulingPoliciesOutput) SetSchedulingPolicies(v []*SchedulingPolicyListingDetail) *ListSchedulingPoliciesOutput {
	s.SchedulingPolicies = v
	return s
}

// Contains the parameters for ListTagsForResource.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that identifies the resource that tags are
	// listed for. Batch resources that support tags are compute environments, jobs,
	// job definitions, job queues, and scheduling policies. ARNs for child jobs
	// of array and multi-node parallel (MNP) jobs aren't supported.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Log configuration options to send to a custom log driver for the container.
type LogConfiguration struct {
	_ struct{} `type:"structure"`

	// The log driver to use for the container. The valid values that are listed
	// for this parameter are log drivers that the Amazon ECS container agent can
	// communicate with by default.
	//
	// The supported log drivers are awslogs, fluentd, gelf, json-file, journald,
	// logentries, syslog, and splunk.
	//
	// Jobs that are running on Fargate resources are restricted to the awslogs
	// and splunk log drivers.
	//
	// awslogs
	//
	// Specifies the Amazon CloudWatch Logs logging driver. For more information,
	// see Using the awslogs log driver (https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html)
	// in the Batch User Guide and Amazon CloudWatch Logs logging driver (https://docs.docker.com/config/containers/logging/awslogs/)
	// in the Docker documentation.
	//
	// fluentd
	//
	// Specifies the Fluentd logging driver. For more information including usage
	// and options, see Fluentd logging driver (https://docs.docker.com/config/containers/logging/fluentd/)
	// in the Docker documentation.
	//
	// gelf
	//
	// Specifies the Graylog Extended Format (GELF) logging driver. For more information
	// including usage and options, see Graylog Extended Format logging driver (https://docs.docker.com/config/containers/logging/gelf/)
	// in the Docker documentation.
	//
	// journald
	//
	// Specifies the journald logging driver. For more information including usage
	// and options, see Journald logging driver (https://docs.docker.com/config/containers/logging/journald/)
	// in the Docker documentation.
	//
	// json-file
	//
	// Specifies the JSON file logging driver. For more information including usage
	// and options, see JSON File logging driver (https://docs.docker.com/config/containers/logging/json-file/)
	// in the Docker documentation.
	//
	// splunk
	//
	// Specifies the Splunk logging driver. For more information including usage
	// and options, see Splunk logging driver (https://docs.docker.com/config/containers/logging/splunk/)
	// in the Docker documentation.
	//
	// syslog
	//
	// Specifies the syslog logging driver. For more information including usage
	// and options, see Syslog logging driver (https://docs.docker.com/config/containers/logging/syslog/)
	// in the Docker documentation.
	//
	// If you have a custom driver that's not listed earlier that you want to work
	// with the Amazon ECS container agent, you can fork the Amazon ECS container
	// agent project that's available on GitHub (https://github.com/aws/amazon-ecs-agent)
	// and customize it to work with that driver. We encourage you to submit pull
	// requests for changes that you want to have included. However, Amazon Web
	// Services doesn't currently support running modified copies of this software.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version | grep "Server API version"
	//
	// LogDriver is a required field
	LogDriver *string `locationName:"logDriver" type:"string" required:"true" enum:"LogDriver"`

	// The configuration options to send to the log driver. This parameter requires
	// version 1.19 of the Docker Remote API or greater on your container instance.
	// To check the Docker Remote API version on your container instance, log in
	// to your container instance and run the following command: sudo docker version
	// | grep "Server API version"
	Options map[string]*string `locationName:"options" type:"map"`

	// The secrets to pass to the log configuration. For more information, see Specifying
	// sensitive data (https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
	// in the Batch User Guide.
	SecretOptions []*Secret `locationName:"secretOptions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogConfiguration"}
	if s.LogDriver == nil {
		invalidParams.Add(request.NewErrParamRequired("LogDriver"))
	}
	if s.SecretOptions != nil {
		for i, v := range s.SecretOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecretOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogDriver sets the LogDriver field's value.
func (s *LogConfiguration) SetLogDriver(v string) *LogConfiguration {
	s.LogDriver = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *LogConfiguration) SetOptions(v map[string]*string) *LogConfiguration {
	s.Options = v
	return s
}

// SetSecretOptions sets the SecretOptions field's value.
func (s *LogConfiguration) SetSecretOptions(v []*Secret) *LogConfiguration {
	s.SecretOptions = v
	return s
}

// Details for a Docker volume mount point that's used in a job's container
// properties. This parameter maps to Volumes in the Create a container (https://docs.docker.com/engine/api/v1.43/#tag/Container/operation/ContainerCreate)
// section of the Docker Remote API and the --volume option to docker run.
type MountPoint struct {
	_ struct{} `type:"structure"`

	// The path on the container where the host volume is mounted.
	ContainerPath *string `locationName:"containerPath" type:"string"`

	// If this value is true, the container has read-only access to the volume.
	// Otherwise, the container can write to the volume. The default value is false.
	ReadOnly *bool `locationName:"readOnly" type:"boolean"`

	// The name of the volume to mount.
	SourceVolume *string `locationName:"sourceVolume" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountPoint) GoString() string {
	return s.String()
}

// SetContainerPath sets the ContainerPath field's value.
func (s *MountPoint) SetContainerPath(v string) *MountPoint {
	s.ContainerPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *MountPoint) SetReadOnly(v bool) *MountPoint {
	s.ReadOnly = &v
	return s
}

// SetSourceVolume sets the SourceVolume field's value.
func (s *MountPoint) SetSourceVolume(v string) *MountPoint {
	s.SourceVolume = &v
	return s
}

// The network configuration for jobs that are running on Fargate resources.
// Jobs that are running on Amazon EC2 resources must not specify this parameter.
type NetworkConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether the job has a public IP address. For a job that's running
	// on Fargate resources in a private subnet to send outbound traffic to the
	// internet (for example, to pull container images), the private subnet requires
	// a NAT gateway be attached to route requests to the internet. For more information,
	// see Amazon ECS task networking (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
	// in the Amazon Elastic Container Service Developer Guide. The default value
	// is "DISABLED".
	AssignPublicIp *string `locationName:"assignPublicIp" type:"string" enum:"AssignPublicIp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) GoString() string {
	return s.String()
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *NetworkConfiguration) SetAssignPublicIp(v string) *NetworkConfiguration {
	s.AssignPublicIp = &v
	return s
}

// An object that represents the elastic network interface for a multi-node
// parallel job node.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The attachment ID for the network interface.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// The private IPv6 address for the network interface.
	Ipv6Address *string `locationName:"ipv6Address" type:"string"`

	// The private IPv4 address for the network interface.
	PrivateIpv4Address *string `locationName:"privateIpv4Address" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *NetworkInterface) SetAttachmentId(v string) *NetworkInterface {
	s.AttachmentId = &v
	return s
}

// SetIpv6Address sets the Ipv6Address field's value.
func (s *NetworkInterface) SetIpv6Address(v string) *NetworkInterface {
	s.Ipv6Address = &v
	return s
}

// SetPrivateIpv4Address sets the PrivateIpv4Address field's value.
func (s *NetworkInterface) SetPrivateIpv4Address(v string) *NetworkInterface {
	s.PrivateIpv4Address = &v
	return s
}

// An object that represents the details of a multi-node parallel job node.
type NodeDetails struct {
	_ struct{} `type:"structure"`

	// Specifies whether the current node is the main node for a multi-node parallel
	// job.
	IsMainNode *bool `locationName:"isMainNode" type:"boolean"`

	// The node index for the node. Node index numbering starts at zero. This index
	// is also available on the node with the AWS_BATCH_JOB_NODE_INDEX environment
	// variable.
	NodeIndex *int64 `locationName:"nodeIndex" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeDetails) GoString() string {
	return s.String()
}

// SetIsMainNode sets the IsMainNode field's value.
func (s *NodeDetails) SetIsMainNode(v bool) *NodeDetails {
	s.IsMainNode = &v
	return s
}

// SetNodeIndex sets the NodeIndex field's value.
func (s *NodeDetails) SetNodeIndex(v int64) *NodeDetails {
	s.NodeIndex = &v
	return s
}

// An object that represents any node overrides to a job definition that's used
// in a SubmitJob (https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html)
// API operation.
//
// This parameter isn't applicable to jobs that are running on Fargate resources.
// Don't provide it for these jobs. Rather, use containerOverrides instead.
type NodeOverrides struct {
	_ struct{} `type:"structure"`

	// The node property overrides for the job.
	NodePropertyOverrides []*NodePropertyOverride `locationName:"nodePropertyOverrides" type:"list"`

	// The number of nodes to use with a multi-node parallel job. This value overrides
	// the number of nodes that are specified in the job definition. To use this
	// override, you must meet the following conditions:
	//
	//    * There must be at least one node range in your job definition that has
	//    an open upper boundary, such as : or n:.
	//
	//    * The lower boundary of the node range that's specified in the job definition
	//    must be fewer than the number of nodes specified in the override.
	//
	//    * The main node index that's specified in the job definition must be fewer
	//    than the number of nodes specified in the override.
	NumNodes *int64 `locationName:"numNodes" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeOverrides) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeOverrides) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodeOverrides"}
	if s.NodePropertyOverrides != nil {
		for i, v := range s.NodePropertyOverrides {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NodePropertyOverrides", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNodePropertyOverrides sets the NodePropertyOverrides field's value.
func (s *NodeOverrides) SetNodePropertyOverrides(v []*NodePropertyOverride) *NodeOverrides {
	s.NodePropertyOverrides = v
	return s
}

// SetNumNodes sets the NumNodes field's value.
func (s *NodeOverrides) SetNumNodes(v int64) *NodeOverrides {
	s.NumNodes = &v
	return s
}

// An object that represents the node properties of a multi-node parallel job.
//
// Node properties can't be specified for Amazon EKS based job definitions.
type NodeProperties struct {
	_ struct{} `type:"structure"`

	// Specifies the node index for the main node of a multi-node parallel job.
	// This node index value must be fewer than the number of nodes.
	//
	// MainNode is a required field
	MainNode *int64 `locationName:"mainNode" type:"integer" required:"true"`

	// A list of node ranges and their properties that are associated with a multi-node
	// parallel job.
	//
	// NodeRangeProperties is a required field
	NodeRangeProperties []*NodeRangeProperty `locationName:"nodeRangeProperties" type:"list" required:"true"`

	// The number of nodes that are associated with a multi-node parallel job.
	//
	// NumNodes is a required field
	NumNodes *int64 `locationName:"numNodes" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodeProperties"}
	if s.MainNode == nil {
		invalidParams.Add(request.NewErrParamRequired("MainNode"))
	}
	if s.NodeRangeProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeRangeProperties"))
	}
	if s.NumNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("NumNodes"))
	}
	if s.NodeRangeProperties != nil {
		for i, v := range s.NodeRangeProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NodeRangeProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMainNode sets the MainNode field's value.
func (s *NodeProperties) SetMainNode(v int64) *NodeProperties {
	s.MainNode = &v
	return s
}

// SetNodeRangeProperties sets the NodeRangeProperties field's value.
func (s *NodeProperties) SetNodeRangeProperties(v []*NodeRangeProperty) *NodeProperties {
	s.NodeRangeProperties = v
	return s
}

// SetNumNodes sets the NumNodes field's value.
func (s *NodeProperties) SetNumNodes(v int64) *NodeProperties {
	s.NumNodes = &v
	return s
}

// An object that represents the properties of a node that's associated with
// a multi-node parallel job.
type NodePropertiesSummary struct {
	_ struct{} `type:"structure"`

	// Specifies whether the current node is the main node for a multi-node parallel
	// job.
	IsMainNode *bool `locationName:"isMainNode" type:"boolean"`

	// The node index for the node. Node index numbering begins at zero. This index
	// is also available on the node with the AWS_BATCH_JOB_NODE_INDEX environment
	// variable.
	NodeIndex *int64 `locationName:"nodeIndex" type:"integer"`

	// The number of nodes that are associated with a multi-node parallel job.
	NumNodes *int64 `locationName:"numNodes" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodePropertiesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodePropertiesSummary) GoString() string {
	return s.String()
}

// SetIsMainNode sets the IsMainNode field's value.
func (s *NodePropertiesSummary) SetIsMainNode(v bool) *NodePropertiesSummary {
	s.IsMainNode = &v
	return s
}

// SetNodeIndex sets the NodeIndex field's value.
func (s *NodePropertiesSummary) SetNodeIndex(v int64) *NodePropertiesSummary {
	s.NodeIndex = &v
	return s
}

// SetNumNodes sets the NumNodes field's value.
func (s *NodePropertiesSummary) SetNumNodes(v int64) *NodePropertiesSummary {
	s.NumNodes = &v
	return s
}

// The object that represents any node overrides to a job definition that's
// used in a SubmitJob (https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html)
// API operation.
type NodePropertyOverride struct {
	_ struct{} `type:"structure"`

	// The overrides that are sent to a node range.
	ContainerOverrides *ContainerOverrides `locationName:"containerOverrides" type:"structure"`

	// An object that contains the properties that you want to replace for the existing
	// Amazon ECS resources of a job.
	EcsPropertiesOverride *EcsPropertiesOverride `locationName:"ecsPropertiesOverride" type:"structure"`

	// An object that contains the instance types that you want to replace for the
	// existing resources of a job.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The range of nodes, using node index values, that's used to override. A range
	// of 0:3 indicates nodes with index values of 0 through 3. If the starting
	// range value is omitted (:n), then 0 is used to start the range. If the ending
	// range value is omitted (n:), then the highest possible node index is used
	// to end the range.
	//
	// TargetNodes is a required field
	TargetNodes *string `locationName:"targetNodes" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodePropertyOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodePropertyOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodePropertyOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodePropertyOverride"}
	if s.TargetNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetNodes"))
	}
	if s.ContainerOverrides != nil {
		if err := s.ContainerOverrides.Validate(); err != nil {
			invalidParams.AddNested("ContainerOverrides", err.(request.ErrInvalidParams))
		}
	}
	if s.EcsPropertiesOverride != nil {
		if err := s.EcsPropertiesOverride.Validate(); err != nil {
			invalidParams.AddNested("EcsPropertiesOverride", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerOverrides sets the ContainerOverrides field's value.
func (s *NodePropertyOverride) SetContainerOverrides(v *ContainerOverrides) *NodePropertyOverride {
	s.ContainerOverrides = v
	return s
}

// SetEcsPropertiesOverride sets the EcsPropertiesOverride field's value.
func (s *NodePropertyOverride) SetEcsPropertiesOverride(v *EcsPropertiesOverride) *NodePropertyOverride {
	s.EcsPropertiesOverride = v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *NodePropertyOverride) SetInstanceTypes(v []*string) *NodePropertyOverride {
	s.InstanceTypes = v
	return s
}

// SetTargetNodes sets the TargetNodes field's value.
func (s *NodePropertyOverride) SetTargetNodes(v string) *NodePropertyOverride {
	s.TargetNodes = &v
	return s
}

// This is an object that represents the properties of the node range for a
// multi-node parallel job.
type NodeRangeProperty struct {
	_ struct{} `type:"structure"`

	// The container details for the node range.
	Container *ContainerProperties `locationName:"container" type:"structure"`

	// This is an object that represents the properties of the node range for a
	// multi-node parallel job.
	EcsProperties *EcsProperties `locationName:"ecsProperties" type:"structure"`

	// The instance types of the underlying host infrastructure of a multi-node
	// parallel job.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	//
	// In addition, this list object is currently limited to one element.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The range of nodes, using node index values. A range of 0:3 indicates nodes
	// with index values of 0 through 3. If the starting range value is omitted
	// (:n), then 0 is used to start the range. If the ending range value is omitted
	// (n:), then the highest possible node index is used to end the range. Your
	// accumulative node ranges must account for all nodes (0:n). You can nest node
	// ranges (for example, 0:10 and 4:5). In this case, the 4:5 range properties
	// override the 0:10 properties.
	//
	// TargetNodes is a required field
	TargetNodes *string `locationName:"targetNodes" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeRangeProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeRangeProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeRangeProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodeRangeProperty"}
	if s.TargetNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetNodes"))
	}
	if s.Container != nil {
		if err := s.Container.Validate(); err != nil {
			invalidParams.AddNested("Container", err.(request.ErrInvalidParams))
		}
	}
	if s.EcsProperties != nil {
		if err := s.EcsProperties.Validate(); err != nil {
			invalidParams.AddNested("EcsProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainer sets the Container field's value.
func (s *NodeRangeProperty) SetContainer(v *ContainerProperties) *NodeRangeProperty {
	s.Container = v
	return s
}

// SetEcsProperties sets the EcsProperties field's value.
func (s *NodeRangeProperty) SetEcsProperties(v *EcsProperties) *NodeRangeProperty {
	s.EcsProperties = v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *NodeRangeProperty) SetInstanceTypes(v []*string) *NodeRangeProperty {
	s.InstanceTypes = v
	return s
}

// SetTargetNodes sets the TargetNodes field's value.
func (s *NodeRangeProperty) SetTargetNodes(v string) *NodeRangeProperty {
	s.TargetNodes = &v
	return s
}

// Contains the parameters for RegisterJobDefinition.
type RegisterJobDefinitionInput struct {
	_ struct{} `type:"structure"`

	// An object with properties specific to Amazon ECS-based single-node container-based
	// jobs. If the job definition's type parameter is container, then you must
	// specify either containerProperties or nodeProperties. This must not be specified
	// for Amazon EKS-based job definitions.
	//
	// If the job runs on Fargate resources, then you must not specify nodeProperties;
	// use only containerProperties.
	ContainerProperties *ContainerProperties `locationName:"containerProperties" type:"structure"`

	// An object with properties that are specific to Amazon ECS-based jobs. This
	// must not be specified for Amazon EKS-based job definitions.
	EcsProperties *EcsProperties `locationName:"ecsProperties" type:"structure"`

	// An object with properties that are specific to Amazon EKS-based jobs. This
	// must not be specified for Amazon ECS based job definitions.
	EksProperties *EksProperties `locationName:"eksProperties" type:"structure"`

	// The name of the job definition to register. It can be up to 128 letters long.
	// It can contain uppercase and lowercase letters, numbers, hyphens (-), and
	// underscores (_).
	//
	// JobDefinitionName is a required field
	JobDefinitionName *string `locationName:"jobDefinitionName" type:"string" required:"true"`

	// An object with properties specific to multi-node parallel jobs. If you specify
	// node properties for a job, it becomes a multi-node parallel job. For more
	// information, see Multi-node Parallel Jobs (https://docs.aws.amazon.com/batch/latest/userguide/multi-node-parallel-jobs.html)
	// in the Batch User Guide.
	//
	// If the job runs on Fargate resources, then you must not specify nodeProperties;
	// use containerProperties instead.
	//
	// If the job runs on Amazon EKS resources, then you must not specify nodeProperties.
	NodeProperties *NodeProperties `locationName:"nodeProperties" type:"structure"`

	// Default parameter substitution placeholders to set in the job definition.
	// Parameters are specified as a key-value pair mapping. Parameters in a SubmitJob
	// request override any corresponding parameter defaults from the job definition.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The platform capabilities required by the job definition. If no value is
	// specified, it defaults to EC2. To run the job on Fargate resources, specify
	// FARGATE.
	//
	// If the job runs on Amazon EKS resources, then you must not specify platformCapabilities.
	PlatformCapabilities []*string `locationName:"platformCapabilities" type:"list" enum:"PlatformCapability"`

	// Specifies whether to propagate the tags from the job or job definition to
	// the corresponding Amazon ECS task. If no value is specified, the tags are
	// not propagated. Tags can only be propagated to the tasks during task creation.
	// For tags with the same name, job tags are given priority over job definitions
	// tags. If the total number of combined tags from the job and job definition
	// is over 50, the job is moved to the FAILED state.
	//
	// If the job runs on Amazon EKS resources, then you must not specify propagateTags.
	PropagateTags *bool `locationName:"propagateTags" type:"boolean"`

	// The retry strategy to use for failed jobs that are submitted with this job
	// definition. Any retry strategy that's specified during a SubmitJob operation
	// overrides the retry strategy defined here. If a job is terminated due to
	// a timeout, it isn't retried.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`

	// The scheduling priority for jobs that are submitted with this job definition.
	// This only affects jobs in job queues with a fair share policy. Jobs with
	// a higher scheduling priority are scheduled before jobs with a lower scheduling
	// priority.
	//
	// The minimum supported value is 0 and the maximum supported value is 9999.
	SchedulingPriority *int64 `locationName:"schedulingPriority" type:"integer"`

	// The tags that you apply to the job definition to help you categorize and
	// organize your resources. Each tag consists of a key and an optional value.
	// For more information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html)
	// in Batch User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The timeout configuration for jobs that are submitted with this job definition,
	// after which Batch terminates your jobs if they have not finished. If a job
	// is terminated due to a timeout, it isn't retried. The minimum value for the
	// timeout is 60 seconds. Any timeout configuration that's specified during
	// a SubmitJob operation overrides the timeout configuration defined here. For
	// more information, see Job Timeouts (https://docs.aws.amazon.com/batch/latest/userguide/job_timeouts.html)
	// in the Batch User Guide.
	Timeout *JobTimeout `locationName:"timeout" type:"structure"`

	// The type of job definition. For more information about multi-node parallel
	// jobs, see Creating a multi-node parallel job definition (https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html)
	// in the Batch User Guide.
	//
	//    * If the value is container, then one of the following is required: containerProperties,
	//    ecsProperties, or eksProperties.
	//
	//    * If the value is multinode, then nodeProperties is required.
	//
	// If the job is run on Fargate resources, then multinode isn't supported.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"JobDefinitionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterJobDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterJobDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterJobDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterJobDefinitionInput"}
	if s.JobDefinitionName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDefinitionName"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ContainerProperties != nil {
		if err := s.ContainerProperties.Validate(); err != nil {
			invalidParams.AddNested("ContainerProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.EcsProperties != nil {
		if err := s.EcsProperties.Validate(); err != nil {
			invalidParams.AddNested("EcsProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.EksProperties != nil {
		if err := s.EksProperties.Validate(); err != nil {
			invalidParams.AddNested("EksProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.NodeProperties != nil {
		if err := s.NodeProperties.Validate(); err != nil {
			invalidParams.AddNested("NodeProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.RetryStrategy != nil {
		if err := s.RetryStrategy.Validate(); err != nil {
			invalidParams.AddNested("RetryStrategy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerProperties sets the ContainerProperties field's value.
func (s *RegisterJobDefinitionInput) SetContainerProperties(v *ContainerProperties) *RegisterJobDefinitionInput {
	s.ContainerProperties = v
	return s
}

// SetEcsProperties sets the EcsProperties field's value.
func (s *RegisterJobDefinitionInput) SetEcsProperties(v *EcsProperties) *RegisterJobDefinitionInput {
	s.EcsProperties = v
	return s
}

// SetEksProperties sets the EksProperties field's value.
func (s *RegisterJobDefinitionInput) SetEksProperties(v *EksProperties) *RegisterJobDefinitionInput {
	s.EksProperties = v
	return s
}

// SetJobDefinitionName sets the JobDefinitionName field's value.
func (s *RegisterJobDefinitionInput) SetJobDefinitionName(v string) *RegisterJobDefinitionInput {
	s.JobDefinitionName = &v
	return s
}

// SetNodeProperties sets the NodeProperties field's value.
func (s *RegisterJobDefinitionInput) SetNodeProperties(v *NodeProperties) *RegisterJobDefinitionInput {
	s.NodeProperties = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *RegisterJobDefinitionInput) SetParameters(v map[string]*string) *RegisterJobDefinitionInput {
	s.Parameters = v
	return s
}

// SetPlatformCapabilities sets the PlatformCapabilities field's value.
func (s *RegisterJobDefinitionInput) SetPlatformCapabilities(v []*string) *RegisterJobDefinitionInput {
	s.PlatformCapabilities = v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *RegisterJobDefinitionInput) SetPropagateTags(v bool) *RegisterJobDefinitionInput {
	s.PropagateTags = &v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *RegisterJobDefinitionInput) SetRetryStrategy(v *RetryStrategy) *RegisterJobDefinitionInput {
	s.RetryStrategy = v
	return s
}

// SetSchedulingPriority sets the SchedulingPriority field's value.
func (s *RegisterJobDefinitionInput) SetSchedulingPriority(v int64) *RegisterJobDefinitionInput {
	s.SchedulingPriority = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterJobDefinitionInput) SetTags(v map[string]*string) *RegisterJobDefinitionInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *RegisterJobDefinitionInput) SetTimeout(v *JobTimeout) *RegisterJobDefinitionInput {
	s.Timeout = v
	return s
}

// SetType sets the Type field's value.
func (s *RegisterJobDefinitionInput) SetType(v string) *RegisterJobDefinitionInput {
	s.Type = &v
	return s
}

type RegisterJobDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the job definition.
	//
	// JobDefinitionArn is a required field
	JobDefinitionArn *string `locationName:"jobDefinitionArn" type:"string" required:"true"`

	// The name of the job definition.
	//
	// JobDefinitionName is a required field
	JobDefinitionName *string `locationName:"jobDefinitionName" type:"string" required:"true"`

	// The revision of the job definition.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterJobDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterJobDefinitionOutput) GoString() string {
	return s.String()
}

// SetJobDefinitionArn sets the JobDefinitionArn field's value.
func (s *RegisterJobDefinitionOutput) SetJobDefinitionArn(v string) *RegisterJobDefinitionOutput {
	s.JobDefinitionArn = &v
	return s
}

// SetJobDefinitionName sets the JobDefinitionName field's value.
func (s *RegisterJobDefinitionOutput) SetJobDefinitionName(v string) *RegisterJobDefinitionOutput {
	s.JobDefinitionName = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *RegisterJobDefinitionOutput) SetRevision(v int64) *RegisterJobDefinitionOutput {
	s.Revision = &v
	return s
}

// The repository credentials for private registry authentication.
type RepositoryCredentials struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret containing the private repository
	// credentials.
	//
	// CredentialsParameter is a required field
	CredentialsParameter *string `locationName:"credentialsParameter" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RepositoryCredentials"}
	if s.CredentialsParameter == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsParameter"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialsParameter sets the CredentialsParameter field's value.
func (s *RepositoryCredentials) SetCredentialsParameter(v string) *RepositoryCredentials {
	s.CredentialsParameter = &v
	return s
}

// The type and amount of a resource to assign to a container. The supported
// resources include GPU, MEMORY, and VCPU.
type ResourceRequirement struct {
	_ struct{} `type:"structure"`

	// The type of resource to assign to a container. The supported resources include
	// GPU, MEMORY, and VCPU.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ResourceType"`

	// The quantity of the specified resource to reserve for the container. The
	// values vary based on the type specified.
	//
	// type="GPU"
	//
	// The number of physical GPUs to reserve for the container. Make sure that
	// the number of GPUs reserved for all containers in a job doesn't exceed the
	// number of available GPUs on the compute resource that the job is launched
	// on.
	//
	// GPUs aren't available for jobs that are running on Fargate resources.
	//
	// type="MEMORY"
	//
	// The memory hard limit (in MiB) present to the container. This parameter is
	// supported for jobs that are running on Amazon EC2 resources. If your container
	// attempts to exceed the memory specified, the container is terminated. This
	// parameter maps to Memory in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --memory option to docker run (https://docs.docker.com/engine/reference/run/).
	// You must specify at least 4 MiB of memory for a job. This is required but
	// can be specified in several places for multi-node parallel (MNP) jobs. It
	// must be specified for each node at least once. This parameter maps to Memory
	// in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --memory option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// If you're trying to maximize your resource utilization by providing your
	// jobs as much memory as possible for a particular instance type, see Memory
	// management (https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html)
	// in the Batch User Guide.
	//
	// For jobs that are running on Fargate resources, then value is the hard limit
	// (in MiB), and must match one of the supported values and the VCPU values
	// must be one of the values supported for that memory value.
	//
	// value = 512
	//
	// VCPU = 0.25
	//
	// value = 1024
	//
	// VCPU = 0.25 or 0.5
	//
	// value = 2048
	//
	// VCPU = 0.25, 0.5, or 1
	//
	// value = 3072
	//
	// VCPU = 0.5, or 1
	//
	// value = 4096
	//
	// VCPU = 0.5, 1, or 2
	//
	// value = 5120, 6144, or 7168
	//
	// VCPU = 1 or 2
	//
	// value = 8192
	//
	// VCPU = 1, 2, or 4
	//
	// value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360
	//
	// VCPU = 2 or 4
	//
	// value = 16384
	//
	// VCPU = 2, 4, or 8
	//
	// value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696,
	// or 30720
	//
	// VCPU = 4
	//
	// value = 20480, 24576, or 28672
	//
	// VCPU = 4 or 8
	//
	// value = 36864, 45056, 53248, or 61440
	//
	// VCPU = 8
	//
	// value = 32768, 40960, 49152, or 57344
	//
	// VCPU = 8 or 16
	//
	// value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880
	//
	// VCPU = 16
	//
	// type="VCPU"
	//
	// The number of vCPUs reserved for the container. This parameter maps to CpuShares
	// in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --cpu-shares option to docker run (https://docs.docker.com/engine/reference/run/).
	// Each vCPU is equivalent to 1,024 CPU shares. For Amazon EC2 resources, you
	// must specify at least one vCPU. This is required but can be specified in
	// several places; it must be specified for each node at least once.
	//
	// The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs.
	// For more information about Fargate quotas, see Fargate quotas (https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate)
	// in the Amazon Web Services General Reference.
	//
	// For jobs that are running on Fargate resources, then value must match one
	// of the supported values and the MEMORY values must be one of the values supported
	// for that VCPU value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and
	// 16
	//
	// value = 0.25
	//
	// MEMORY = 512, 1024, or 2048
	//
	// value = 0.5
	//
	// MEMORY = 1024, 2048, 3072, or 4096
	//
	// value = 1
	//
	// MEMORY = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
	//
	// value = 2
	//
	// MEMORY = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312,
	// 14336, 15360, or 16384
	//
	// value = 4
	//
	// MEMORY = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408,
	// 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672,
	// 29696, or 30720
	//
	// value = 8
	//
	// MEMORY = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248,
	// 57344, or 61440
	//
	// value = 16
	//
	// MEMORY = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496,
	// 114688, or 122880
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceRequirement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceRequirement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRequirement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceRequirement"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *ResourceRequirement) SetType(v string) *ResourceRequirement {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceRequirement) SetValue(v string) *ResourceRequirement {
	s.Value = &v
	return s
}

// The retry strategy that's associated with a job. For more information, see
// Automated job retries (https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html)
// in the Batch User Guide.
type RetryStrategy struct {
	_ struct{} `type:"structure"`

	// The number of times to move a job to the RUNNABLE status. You can specify
	// between 1 and 10 attempts. If the value of attempts is greater than one,
	// the job is retried on failure the same number of attempts as the value.
	Attempts *int64 `locationName:"attempts" type:"integer"`

	// Array of up to 5 objects that specify the conditions where jobs are retried
	// or failed. If this parameter is specified, then the attempts parameter must
	// also be specified. If none of the listed conditions match, then the job is
	// retried.
	EvaluateOnExit []*EvaluateOnExit `locationName:"evaluateOnExit" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryStrategy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetryStrategy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetryStrategy"}
	if s.EvaluateOnExit != nil {
		for i, v := range s.EvaluateOnExit {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EvaluateOnExit", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttempts sets the Attempts field's value.
func (s *RetryStrategy) SetAttempts(v int64) *RetryStrategy {
	s.Attempts = &v
	return s
}

// SetEvaluateOnExit sets the EvaluateOnExit field's value.
func (s *RetryStrategy) SetEvaluateOnExit(v []*EvaluateOnExit) *RetryStrategy {
	s.EvaluateOnExit = v
	return s
}

// An object that represents the compute environment architecture for Batch
// jobs on Fargate.
type RuntimePlatform struct {
	_ struct{} `type:"structure"`

	// The vCPU architecture. The default value is X86_64. Valid values are X86_64
	// and ARM64.
	//
	// This parameter must be set to X86_64 for Windows containers.
	//
	// Fargate Spot is not supported for ARM64 and Windows-based containers on Fargate.
	// A job queue will be blocked if a Fargate ARM64 or Windows job is submitted
	// to a job queue with only Fargate Spot compute environments. However, you
	// can attach both FARGATE and FARGATE_SPOT compute environments to the same
	// job queue.
	CpuArchitecture *string `locationName:"cpuArchitecture" type:"string"`

	// The operating system for the compute environment. Valid values are: LINUX
	// (default), WINDOWS_SERVER_2019_CORE, WINDOWS_SERVER_2019_FULL, WINDOWS_SERVER_2022_CORE,
	// and WINDOWS_SERVER_2022_FULL.
	//
	// The following parameters can’t be set for Windows containers: linuxParameters,
	// privileged, user, ulimits, readonlyRootFilesystem, and efsVolumeConfiguration.
	//
	// The Batch Scheduler checks the compute environments that are attached to
	// the job queue before registering a task definition with Fargate. In this
	// scenario, the job queue is where the job is submitted. If the job requires
	// a Windows container and the first compute environment is LINUX, the compute
	// environment is skipped and the next compute environment is checked until
	// a Windows-based compute environment is found.
	//
	// Fargate Spot is not supported for ARM64 and Windows-based containers on Fargate.
	// A job queue will be blocked if a Fargate ARM64 or Windows job is submitted
	// to a job queue with only Fargate Spot compute environments. However, you
	// can attach both FARGATE and FARGATE_SPOT compute environments to the same
	// job queue.
	OperatingSystemFamily *string `locationName:"operatingSystemFamily" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuntimePlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuntimePlatform) GoString() string {
	return s.String()
}

// SetCpuArchitecture sets the CpuArchitecture field's value.
func (s *RuntimePlatform) SetCpuArchitecture(v string) *RuntimePlatform {
	s.CpuArchitecture = &v
	return s
}

// SetOperatingSystemFamily sets the OperatingSystemFamily field's value.
func (s *RuntimePlatform) SetOperatingSystemFamily(v string) *RuntimePlatform {
	s.OperatingSystemFamily = &v
	return s
}

// An object that represents a scheduling policy.
type SchedulingPolicyDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the scheduling policy. An example is arn:aws:batch:us-east-1:123456789012:scheduling-policy/HighPriority .
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The fair share policy for the scheduling policy.
	FairsharePolicy *FairsharePolicy `locationName:"fairsharePolicy" type:"structure"`

	// The name of the scheduling policy.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The tags that you apply to the scheduling policy to categorize and organize
	// your resources. Each tag consists of a key and an optional value. For more
	// information, see Tagging Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in Amazon Web Services General Reference.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchedulingPolicyDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchedulingPolicyDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SchedulingPolicyDetail) SetArn(v string) *SchedulingPolicyDetail {
	s.Arn = &v
	return s
}

// SetFairsharePolicy sets the FairsharePolicy field's value.
func (s *SchedulingPolicyDetail) SetFairsharePolicy(v *FairsharePolicy) *SchedulingPolicyDetail {
	s.FairsharePolicy = v
	return s
}

// SetName sets the Name field's value.
func (s *SchedulingPolicyDetail) SetName(v string) *SchedulingPolicyDetail {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SchedulingPolicyDetail) SetTags(v map[string]*string) *SchedulingPolicyDetail {
	s.Tags = v
	return s
}

// An object that contains the details of a scheduling policy that's returned
// in a ListSchedulingPolicy action.
type SchedulingPolicyListingDetail struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the scheduling policy.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchedulingPolicyListingDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchedulingPolicyListingDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SchedulingPolicyListingDetail) SetArn(v string) *SchedulingPolicyListingDetail {
	s.Arn = &v
	return s
}

// An object that represents the secret to expose to your container. Secrets
// can be exposed to a container in the following ways:
//
//   - To inject sensitive data into your containers as environment variables,
//     use the secrets container definition parameter.
//
//   - To reference sensitive information in the log configuration of a container,
//     use the secretOptions container definition parameter.
//
// For more information, see Specifying sensitive data (https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
// in the Batch User Guide.
type Secret struct {
	_ struct{} `type:"structure"`

	// The name of the secret.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The secret to expose to the container. The supported values are either the
	// full Amazon Resource Name (ARN) of the Secrets Manager secret or the full
	// ARN of the parameter in the Amazon Web Services Systems Manager Parameter
	// Store.
	//
	// If the Amazon Web Services Systems Manager Parameter Store parameter exists
	// in the same Region as the job you're launching, then you can use either the
	// full Amazon Resource Name (ARN) or name of the parameter. If the parameter
	// exists in a different Region, then the full ARN must be specified.
	//
	// ValueFrom is a required field
	ValueFrom *string `locationName:"valueFrom" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Secret) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Secret) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Secret) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Secret"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ValueFrom == nil {
		invalidParams.Add(request.NewErrParamRequired("ValueFrom"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Secret) SetName(v string) *Secret {
	s.Name = &v
	return s
}

// SetValueFrom sets the ValueFrom field's value.
func (s *Secret) SetValueFrom(v string) *Secret {
	s.ValueFrom = &v
	return s
}

// These errors are usually caused by a server issue.
type ServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) GoString() string {
	return s.String()
}

func newErrorServerException(v protocol.ResponseMetadata) error {
	return &ServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerException) Code() string {
	return "ServerException"
}

// Message returns the exception's message.
func (s *ServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerException) OrigErr() error {
	return nil
}

func (s *ServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the weights for the fair share identifiers for the fair share policy.
// Fair share identifiers that aren't included have a default weight of 1.0.
type ShareAttributes struct {
	_ struct{} `type:"structure"`

	// A fair share identifier or fair share identifier prefix. If the string ends
	// with an asterisk (*), this entry specifies the weight factor to use for fair
	// share identifiers that start with that prefix. The list of fair share identifiers
	// in a fair share policy can't overlap. For example, you can't have one that
	// specifies a shareIdentifier of UserA* and another that specifies a shareIdentifier
	// of UserA-1.
	//
	// There can be no more than 500 fair share identifiers active in a job queue.
	//
	// The string is limited to 255 alphanumeric characters, and can be followed
	// by an asterisk (*).
	//
	// ShareIdentifier is a required field
	ShareIdentifier *string `locationName:"shareIdentifier" type:"string" required:"true"`

	// The weight factor for the fair share identifier. The default value is 1.0.
	// A lower value has a higher priority for compute resources. For example, jobs
	// that use a share identifier with a weight factor of 0.125 (1/8) get 8 times
	// the compute resources of jobs that use a share identifier with a weight factor
	// of 1.
	//
	// The smallest supported value is 0.0001, and the largest supported value is
	// 999.9999.
	WeightFactor *float64 `locationName:"weightFactor" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShareAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ShareAttributes"}
	if s.ShareIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShareIdentifier sets the ShareIdentifier field's value.
func (s *ShareAttributes) SetShareIdentifier(v string) *ShareAttributes {
	s.ShareIdentifier = &v
	return s
}

// SetWeightFactor sets the WeightFactor field's value.
func (s *ShareAttributes) SetWeightFactor(v float64) *ShareAttributes {
	s.WeightFactor = &v
	return s
}

// Contains the parameters for SubmitJob.
type SubmitJobInput struct {
	_ struct{} `type:"structure"`

	// The array properties for the submitted job, such as the size of the array.
	// The array size can be between 2 and 10,000. If you specify array properties
	// for a job, it becomes an array job. For more information, see Array Jobs
	// (https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html) in the
	// Batch User Guide.
	ArrayProperties *ArrayProperties `locationName:"arrayProperties" type:"structure"`

	// An object with properties that override the defaults for the job definition
	// that specify the name of a container in the specified job definition and
	// the overrides it should receive. You can override the default command for
	// a container, which is specified in the job definition or the Docker image,
	// with a command override. You can also override existing environment variables
	// on a container or add new environment variables to it with an environment
	// override.
	ContainerOverrides *ContainerOverrides `locationName:"containerOverrides" type:"structure"`

	// A list of dependencies for the job. A job can depend upon a maximum of 20
	// jobs. You can specify a SEQUENTIAL type dependency without specifying a job
	// ID for array jobs so that each child array job completes sequentially, starting
	// at index 0. You can also specify an N_TO_N type dependency with a job ID
	// for array jobs. In that case, each index child of this job must wait for
	// the corresponding index child of each dependency to complete before it can
	// begin.
	DependsOn []*JobDependency `locationName:"dependsOn" type:"list"`

	// An object, with properties that override defaults for the job definition,
	// can only be specified for jobs that are run on Amazon ECS resources.
	EcsPropertiesOverride *EcsPropertiesOverride `locationName:"ecsPropertiesOverride" type:"structure"`

	// An object, with properties that override defaults for the job definition,
	// can only be specified for jobs that are run on Amazon EKS resources.
	EksPropertiesOverride *EksPropertiesOverride `locationName:"eksPropertiesOverride" type:"structure"`

	// The job definition used by this job. This value can be one of definition-name,
	// definition-name:revision, or the Amazon Resource Name (ARN) for the job definition,
	// with or without the revision (arn:aws:batch:region:account:job-definition/definition-name:revision
	// , or arn:aws:batch:region:account:job-definition/definition-name ).
	//
	// If the revision is not specified, then the latest active revision is used.
	//
	// JobDefinition is a required field
	JobDefinition *string `locationName:"jobDefinition" type:"string" required:"true"`

	// The name of the job. It can be up to 128 letters long. The first character
	// must be alphanumeric, can contain uppercase and lowercase letters, numbers,
	// hyphens (-), and underscores (_).
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`

	// The job queue where the job is submitted. You can specify either the name
	// or the Amazon Resource Name (ARN) of the queue.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`

	// A list of node overrides in JSON format that specify the node range to target
	// and the container overrides for that node range.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources;
	// use containerOverrides instead.
	NodeOverrides *NodeOverrides `locationName:"nodeOverrides" type:"structure"`

	// Additional parameters passed to the job that replace parameter substitution
	// placeholders that are set in the job definition. Parameters are specified
	// as a key and value pair mapping. Parameters in a SubmitJob request override
	// any corresponding parameter defaults from the job definition.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// Specifies whether to propagate the tags from the job or job definition to
	// the corresponding Amazon ECS task. If no value is specified, the tags aren't
	// propagated. Tags can only be propagated to the tasks during task creation.
	// For tags with the same name, job tags are given priority over job definitions
	// tags. If the total number of combined tags from the job and job definition
	// is over 50, the job is moved to the FAILED state. When specified, this overrides
	// the tag propagation setting in the job definition.
	PropagateTags *bool `locationName:"propagateTags" type:"boolean"`

	// The retry strategy to use for failed jobs from this SubmitJob operation.
	// When a retry strategy is specified here, it overrides the retry strategy
	// defined in the job definition.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`

	// The scheduling priority for the job. This only affects jobs in job queues
	// with a fair share policy. Jobs with a higher scheduling priority are scheduled
	// before jobs with a lower scheduling priority. This overrides any scheduling
	// priority in the job definition and works only within a single share identifier.
	//
	// The minimum supported value is 0 and the maximum supported value is 9999.
	SchedulingPriorityOverride *int64 `locationName:"schedulingPriorityOverride" type:"integer"`

	// The share identifier for the job. Don't specify this parameter if the job
	// queue doesn't have a scheduling policy. If the job queue has a scheduling
	// policy, then this parameter must be specified.
	//
	// This string is limited to 255 alphanumeric characters, and can be followed
	// by an asterisk (*).
	ShareIdentifier *string `locationName:"shareIdentifier" type:"string"`

	// The tags that you apply to the job request to help you categorize and organize
	// your resources. Each tag consists of a key and an optional value. For more
	// information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in Amazon Web Services General Reference.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The timeout configuration for this SubmitJob operation. You can specify a
	// timeout duration after which Batch terminates your jobs if they haven't finished.
	// If a job is terminated due to a timeout, it isn't retried. The minimum value
	// for the timeout is 60 seconds. This configuration overrides any timeout configuration
	// specified in the job definition. For array jobs, child jobs have the same
	// timeout configuration as the parent job. For more information, see Job Timeouts
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Timeout *JobTimeout `locationName:"timeout" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubmitJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubmitJobInput"}
	if s.JobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDefinition"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobQueue == nil {
		invalidParams.Add(request.NewErrParamRequired("JobQueue"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ContainerOverrides != nil {
		if err := s.ContainerOverrides.Validate(); err != nil {
			invalidParams.AddNested("ContainerOverrides", err.(request.ErrInvalidParams))
		}
	}
	if s.EcsPropertiesOverride != nil {
		if err := s.EcsPropertiesOverride.Validate(); err != nil {
			invalidParams.AddNested("EcsPropertiesOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.EksPropertiesOverride != nil {
		if err := s.EksPropertiesOverride.Validate(); err != nil {
			invalidParams.AddNested("EksPropertiesOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.NodeOverrides != nil {
		if err := s.NodeOverrides.Validate(); err != nil {
			invalidParams.AddNested("NodeOverrides", err.(request.ErrInvalidParams))
		}
	}
	if s.RetryStrategy != nil {
		if err := s.RetryStrategy.Validate(); err != nil {
			invalidParams.AddNested("RetryStrategy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArrayProperties sets the ArrayProperties field's value.
func (s *SubmitJobInput) SetArrayProperties(v *ArrayProperties) *SubmitJobInput {
	s.ArrayProperties = v
	return s
}

// SetContainerOverrides sets the ContainerOverrides field's value.
func (s *SubmitJobInput) SetContainerOverrides(v *ContainerOverrides) *SubmitJobInput {
	s.ContainerOverrides = v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *SubmitJobInput) SetDependsOn(v []*JobDependency) *SubmitJobInput {
	s.DependsOn = v
	return s
}

// SetEcsPropertiesOverride sets the EcsPropertiesOverride field's value.
func (s *SubmitJobInput) SetEcsPropertiesOverride(v *EcsPropertiesOverride) *SubmitJobInput {
	s.EcsPropertiesOverride = v
	return s
}

// SetEksPropertiesOverride sets the EksPropertiesOverride field's value.
func (s *SubmitJobInput) SetEksPropertiesOverride(v *EksPropertiesOverride) *SubmitJobInput {
	s.EksPropertiesOverride = v
	return s
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *SubmitJobInput) SetJobDefinition(v string) *SubmitJobInput {
	s.JobDefinition = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *SubmitJobInput) SetJobName(v string) *SubmitJobInput {
	s.JobName = &v
	return s
}

// SetJobQueue sets the JobQueue field's value.
func (s *SubmitJobInput) SetJobQueue(v string) *SubmitJobInput {
	s.JobQueue = &v
	return s
}

// SetNodeOverrides sets the NodeOverrides field's value.
func (s *SubmitJobInput) SetNodeOverrides(v *NodeOverrides) *SubmitJobInput {
	s.NodeOverrides = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *SubmitJobInput) SetParameters(v map[string]*string) *SubmitJobInput {
	s.Parameters = v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *SubmitJobInput) SetPropagateTags(v bool) *SubmitJobInput {
	s.PropagateTags = &v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *SubmitJobInput) SetRetryStrategy(v *RetryStrategy) *SubmitJobInput {
	s.RetryStrategy = v
	return s
}

// SetSchedulingPriorityOverride sets the SchedulingPriorityOverride field's value.
func (s *SubmitJobInput) SetSchedulingPriorityOverride(v int64) *SubmitJobInput {
	s.SchedulingPriorityOverride = &v
	return s
}

// SetShareIdentifier sets the ShareIdentifier field's value.
func (s *SubmitJobInput) SetShareIdentifier(v string) *SubmitJobInput {
	s.ShareIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SubmitJobInput) SetTags(v map[string]*string) *SubmitJobInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *SubmitJobInput) SetTimeout(v *JobTimeout) *SubmitJobInput {
	s.Timeout = v
	return s
}

type SubmitJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the job.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The unique identifier for the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The name of the job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubmitJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *SubmitJobOutput) SetJobArn(v string) *SubmitJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *SubmitJobOutput) SetJobId(v string) *SubmitJobOutput {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *SubmitJobOutput) SetJobName(v string) *SubmitJobOutput {
	s.JobName = &v
	return s
}

// Contains the parameters for TagResource.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that tags are added to. Batch
	// resources that support tags are compute environments, jobs, job definitions,
	// job queues, and scheduling policies. ARNs for child jobs of array and multi-node
	// parallel (MNP) jobs aren't supported.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags that you apply to the resource to help you categorize and organize
	// your resources. Each tag consists of a key and an optional value. For more
	// information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in Amazon Web Services General Reference.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A list of containers that this task depends on.
type TaskContainerDependency struct {
	_ struct{} `type:"structure"`

	// The dependency condition of the container. The following are the available
	// conditions and their behavior:
	//
	//    * START - This condition emulates the behavior of links and volumes today.
	//    It validates that a dependent container is started before permitting other
	//    containers to start.
	//
	//    * COMPLETE - This condition validates that a dependent container runs
	//    to completion (exits) before permitting other containers to start. This
	//    can be useful for nonessential containers that run a script and then exit.
	//    This condition can't be set on an essential container.
	//
	//    * SUCCESS - This condition is the same as COMPLETE, but it also requires
	//    that the container exits with a zero status. This condition can't be set
	//    on an essential container.
	Condition *string `locationName:"condition" type:"string"`

	// A unique identifier for the container.
	ContainerName *string `locationName:"containerName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskContainerDependency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskContainerDependency) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *TaskContainerDependency) SetCondition(v string) *TaskContainerDependency {
	s.Condition = &v
	return s
}

// SetContainerName sets the ContainerName field's value.
func (s *TaskContainerDependency) SetContainerName(v string) *TaskContainerDependency {
	s.ContainerName = &v
	return s
}

// The details for the container in this task attempt.
type TaskContainerDetails struct {
	_ struct{} `type:"structure"`

	// The command that's passed to the container. This parameter maps to Cmd in
	// the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the COMMAND parameter to docker run (https://docs.docker.com/engine/reference/run/).
	// For more information, see https://docs.docker.com/engine/reference/builder/#cmd
	// (https://docs.docker.com/engine/reference/builder/#cmd).
	Command []*string `locationName:"command" type:"list"`

	// A list of containers that this container depends on.
	DependsOn []*TaskContainerDependency `locationName:"dependsOn" type:"list"`

	// The environment variables to pass to a container. This parameter maps to
	// Env in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --env option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// We don't recommend using plaintext environment variables for sensitive information,
	// such as credential data.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// If the essential parameter of a container is marked as true, and that container
	// fails or stops for any reason, all other containers that are part of the
	// task are stopped. If the essential parameter of a container is marked as
	// false, its failure doesn't affect the rest of the containers in a task. If
	// this parameter is omitted, a container is assumed to be essential.
	//
	// All tasks must have at least one essential container. If you have an application
	// that's composed of multiple containers, group containers that are used for
	// a common purpose into components, and separate the different components into
	// multiple task definitions. For more information, see Application Architecture
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Essential *bool `locationName:"essential" type:"boolean"`

	// The exit code returned upon completion.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The image used to start a container. This string is passed directly to the
	// Docker daemon. By default, images in the Docker Hub registry are available.
	// Other repositories are specified with either repository-url/image:tag or
	// repository-url/image@digest. Up to 255 letters (uppercase and lowercase),
	// numbers, hyphens, underscores, colons, periods, forward slashes, and number
	// signs are allowed. This parameter maps to Image in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the IMAGE parameter of the docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	Image *string `locationName:"image" type:"string"`

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities. For more information, see KernelCapabilities (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html).
	//
	// This parameter is not supported for Windows containers.
	LinuxParameters *LinuxParameters `locationName:"linuxParameters" type:"structure"`

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --log-driver option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// By default, containers use the same logging driver that the Docker daemon
	// uses. However the container can use a different logging driver than the Docker
	// daemon by specifying a log driver with this parameter in the container definition.
	// To use a different logging driver for a container, the log system must be
	// configured properly on the container instance (or on a different log server
	// for remote logging options). For more information about the options for different
	// supported log drivers, see Configure logging drivers (https://docs.docker.com/engine/admin/logging/overview/)
	// in the Docker documentation.
	//
	// Amazon ECS currently supports a subset of the logging drivers available to
	// the Docker daemon (shown in the LogConfiguration data type). Additional log
	// drivers may be available in future releases of the Amazon ECS container agent.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the ECS_AVAILABLE_LOGGING_DRIVERS
	// environment variable before containers placed on that instance can use these
	// log configuration options. For more information, see Amazon ECS container
	// agent configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LogConfiguration *LogConfiguration `locationName:"logConfiguration" type:"structure"`

	// The name of the CloudWatch Logs log stream that's associated with the container.
	// The log group for Batch jobs is /aws/batch/job. Each container attempt receives
	// a log stream name when they reach the RUNNING status.
	LogStreamName *string `locationName:"logStreamName" type:"string"`

	// The mount points for data volumes in your container.
	//
	// This parameter maps to Volumes in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --volume option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// Windows containers can mount whole directories on the same drive as $env:ProgramData.
	// Windows containers can't mount directories on a different drive, and mount
	// point can't be across drives.
	MountPoints []*MountPoint `locationName:"mountPoints" type:"list"`

	// The name of a container.
	Name *string `locationName:"name" type:"string"`

	// The network interfaces that are associated with the job.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// When this parameter is true, the container is given elevated privileges on
	// the host container instance (similar to the root user). This parameter maps
	// to Privileged in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --privileged option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter is not supported for Windows containers or tasks run on Fargate.
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the --read-only option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter is not supported for Windows containers.
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials `locationName:"repositoryCredentials" type:"structure"`

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []*ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// The secrets to pass to the container. For more information, see Specifying
	// Sensitive Data (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Secrets []*Secret `locationName:"secrets" type:"list"`

	// A list of ulimits to set in the container. If a ulimit value is specified
	// in a task definition, it overrides the default values set by Docker. This
	// parameter maps to Ulimits in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --ulimit option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// Amazon ECS tasks hosted on Fargate use the default resource limit values
	// set by the operating system with the exception of the nofile resource limit
	// parameter which Fargate overrides. The nofile resource limit sets a restriction
	// on the number of open files that a container can use. The default nofile
	// soft limit is 1024 and the default hard limit is 65535.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// This parameter is not supported for Windows containers.
	Ulimits []*Ulimit `locationName:"ulimits" type:"list"`

	// The user to use inside the container. This parameter maps to User in the
	// Create a container section of the Docker Remote API and the --user option
	// to docker run.
	//
	// When running tasks using the host network mode, don't run containers using
	// the root user (UID 0). We recommend using a non-root user for better security.
	//
	// You can specify the user using the following formats. If specifying a UID
	// or GID, you must specify it as a positive integer.
	//
	//    * user
	//
	//    * user:group
	//
	//    * uid
	//
	//    * uid:gid
	//
	//    * user:gi
	//
	//    * uid:group
	//
	//    *
	//
	// This parameter is not supported for Windows containers.
	User *string `locationName:"user" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskContainerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskContainerDetails) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *TaskContainerDetails) SetCommand(v []*string) *TaskContainerDetails {
	s.Command = v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *TaskContainerDetails) SetDependsOn(v []*TaskContainerDependency) *TaskContainerDetails {
	s.DependsOn = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *TaskContainerDetails) SetEnvironment(v []*KeyValuePair) *TaskContainerDetails {
	s.Environment = v
	return s
}

// SetEssential sets the Essential field's value.
func (s *TaskContainerDetails) SetEssential(v bool) *TaskContainerDetails {
	s.Essential = &v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *TaskContainerDetails) SetExitCode(v int64) *TaskContainerDetails {
	s.ExitCode = &v
	return s
}

// SetImage sets the Image field's value.
func (s *TaskContainerDetails) SetImage(v string) *TaskContainerDetails {
	s.Image = &v
	return s
}

// SetLinuxParameters sets the LinuxParameters field's value.
func (s *TaskContainerDetails) SetLinuxParameters(v *LinuxParameters) *TaskContainerDetails {
	s.LinuxParameters = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *TaskContainerDetails) SetLogConfiguration(v *LogConfiguration) *TaskContainerDetails {
	s.LogConfiguration = v
	return s
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *TaskContainerDetails) SetLogStreamName(v string) *TaskContainerDetails {
	s.LogStreamName = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *TaskContainerDetails) SetMountPoints(v []*MountPoint) *TaskContainerDetails {
	s.MountPoints = v
	return s
}

// SetName sets the Name field's value.
func (s *TaskContainerDetails) SetName(v string) *TaskContainerDetails {
	s.Name = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *TaskContainerDetails) SetNetworkInterfaces(v []*NetworkInterface) *TaskContainerDetails {
	s.NetworkInterfaces = v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *TaskContainerDetails) SetPrivileged(v bool) *TaskContainerDetails {
	s.Privileged = &v
	return s
}

// SetReadonlyRootFilesystem sets the ReadonlyRootFilesystem field's value.
func (s *TaskContainerDetails) SetReadonlyRootFilesystem(v bool) *TaskContainerDetails {
	s.ReadonlyRootFilesystem = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *TaskContainerDetails) SetReason(v string) *TaskContainerDetails {
	s.Reason = &v
	return s
}

// SetRepositoryCredentials sets the RepositoryCredentials field's value.
func (s *TaskContainerDetails) SetRepositoryCredentials(v *RepositoryCredentials) *TaskContainerDetails {
	s.RepositoryCredentials = v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *TaskContainerDetails) SetResourceRequirements(v []*ResourceRequirement) *TaskContainerDetails {
	s.ResourceRequirements = v
	return s
}

// SetSecrets sets the Secrets field's value.
func (s *TaskContainerDetails) SetSecrets(v []*Secret) *TaskContainerDetails {
	s.Secrets = v
	return s
}

// SetUlimits sets the Ulimits field's value.
func (s *TaskContainerDetails) SetUlimits(v []*Ulimit) *TaskContainerDetails {
	s.Ulimits = v
	return s
}

// SetUser sets the User field's value.
func (s *TaskContainerDetails) SetUser(v string) *TaskContainerDetails {
	s.User = &v
	return s
}

// The overrides that should be sent to a container.
//
// For information about using Batch overrides when you connect event sources
// to targets, see BatchContainerOverrides (https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_BatchContainerOverrides.html).
type TaskContainerOverrides struct {
	_ struct{} `type:"structure"`

	// The command to send to the container that overrides the default command from
	// the Docker image or the job definition.
	//
	// This parameter can't contain an empty string.
	Command []*string `locationName:"command" type:"list"`

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override
	// the existing environment variables from the Docker image or the job definition.
	//
	// Environment variables cannot start with AWS_BATCH. This naming convention
	// is reserved for variables that Batch sets.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// A pointer to the container that you want to override. The container's name
	// provides a unique identifier for the container being used.
	Name *string `locationName:"name" type:"string"`

	// The type and amount of resources to assign to a container. This overrides
	// the settings in the job definition. The supported resources include GPU,
	// MEMORY, and VCPU.
	ResourceRequirements []*ResourceRequirement `locationName:"resourceRequirements" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskContainerOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskContainerOverrides) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskContainerOverrides) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaskContainerOverrides"}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *TaskContainerOverrides) SetCommand(v []*string) *TaskContainerOverrides {
	s.Command = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *TaskContainerOverrides) SetEnvironment(v []*KeyValuePair) *TaskContainerOverrides {
	s.Environment = v
	return s
}

// SetName sets the Name field's value.
func (s *TaskContainerOverrides) SetName(v string) *TaskContainerOverrides {
	s.Name = &v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *TaskContainerOverrides) SetResourceRequirements(v []*ResourceRequirement) *TaskContainerOverrides {
	s.ResourceRequirements = v
	return s
}

// Container properties are used for Amazon ECS-based job definitions. These
// properties to describe the container that's launched as part of a job.
type TaskContainerProperties struct {
	_ struct{} `type:"structure"`

	// The command that's passed to the container. This parameter maps to Cmd in
	// the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the COMMAND parameter to docker run (https://docs.docker.com/engine/reference/run/).
	// For more information, see Dockerfile reference: CMD (https://docs.docker.com/engine/reference/builder/#cmd).
	Command []*string `locationName:"command" type:"list"`

	// A list of containers that this container depends on.
	DependsOn []*TaskContainerDependency `locationName:"dependsOn" type:"list"`

	// The environment variables to pass to a container. This parameter maps to
	// Env inthe Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --env parameter to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// We don't recommend using plaintext environment variables for sensitive information,
	// such as credential data.
	//
	// Environment variables cannot start with AWS_BATCH. This naming convention
	// is reserved for variables that Batch sets.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// If the essential parameter of a container is marked as true, and that container
	// fails or stops for any reason, all other containers that are part of the
	// task are stopped. If the essential parameter of a container is marked as
	// false, its failure doesn't affect the rest of the containers in a task. If
	// this parameter is omitted, a container is assumed to be essential.
	//
	// All tasks must have at least one essential container. If you have an application
	// that's composed of multiple containers, group containers that are used for
	// a common purpose into components, and separate the different components into
	// multiple task definitions. For more information, see Application Architecture
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Essential *bool `locationName:"essential" type:"boolean"`

	// The image used to start a container. This string is passed directly to the
	// Docker daemon. By default, images in the Docker Hub registry are available.
	// Other repositories are specified with either repository-url/image:tag or
	// repository-url/image@digest. Up to 255 letters (uppercase and lowercase),
	// numbers, hyphens, underscores, colons, periods, forward slashes, and number
	// signs are allowed. This parameter maps to Image in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the IMAGE parameter of the docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// Image is a required field
	Image *string `locationName:"image" type:"string" required:"true"`

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities. For more information, see KernelCapabilities (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html).
	LinuxParameters *LinuxParameters `locationName:"linuxParameters" type:"structure"`

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --log-driver option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// By default, containers use the same logging driver that the Docker daemon
	// uses. However the container can use a different logging driver than the Docker
	// daemon by specifying a log driver with this parameter in the container definition.
	// To use a different logging driver for a container, the log system must be
	// configured properly on the container instance (or on a different log server
	// for remote logging options). For more information about the options for different
	// supported log drivers, see Configure logging drivers (https://docs.docker.com/engine/admin/logging/overview/)
	// in the Docker documentation.
	//
	// Amazon ECS currently supports a subset of the logging drivers available to
	// the Docker daemon (shown in the LogConfiguration data type). Additional log
	// drivers may be available in future releases of the Amazon ECS container agent.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the ECS_AVAILABLE_LOGGING_DRIVERS
	// environment variable before containers placed on that instance can use these
	// log configuration options. For more information, see Amazon ECS container
	// agent configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LogConfiguration *LogConfiguration `locationName:"logConfiguration" type:"structure"`

	// The mount points for data volumes in your container.
	//
	// This parameter maps to Volumes in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --volume option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// Windows containers can mount whole directories on the same drive as $env:ProgramData.
	// Windows containers can't mount directories on a different drive, and mount
	// point can't be across drives.
	MountPoints []*MountPoint `locationName:"mountPoints" type:"list"`

	// The name of a container. The name can be used as a unique identifier to target
	// your dependsOn and Overrides objects.
	Name *string `locationName:"name" type:"string"`

	// When this parameter is true, the container is given elevated privileges on
	// the host container instance (similar to the root user). This parameter maps
	// to Privileged in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --privileged option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter is not supported for Windows containers or tasks run on Fargate.
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the --read-only option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// This parameter is not supported for Windows containers.
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials `locationName:"repositoryCredentials" type:"structure"`

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []*ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// The secrets to pass to the container. For more information, see Specifying
	// Sensitive Data (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Secrets []*Secret `locationName:"secrets" type:"list"`

	// A list of ulimits to set in the container. If a ulimit value is specified
	// in a task definition, it overrides the default values set by Docker. This
	// parameter maps to Ulimits in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --ulimit option to docker run (https://docs.docker.com/engine/reference/run/#security-configuration).
	//
	// Amazon ECS tasks hosted on Fargate use the default resource limit values
	// set by the operating system with the exception of the nofile resource limit
	// parameter which Fargate overrides. The nofile resource limit sets a restriction
	// on the number of open files that a container can use. The default nofile
	// soft limit is 1024 and the default hard limit is 65535.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// This parameter is not supported for Windows containers.
	Ulimits []*Ulimit `locationName:"ulimits" type:"list"`

	// The user to use inside the container. This parameter maps to User in the
	// Create a container section of the Docker Remote API and the --user option
	// to docker run.
	//
	// When running tasks using the host network mode, don't run containers using
	// the root user (UID 0). We recommend using a non-root user for better security.
	//
	// You can specify the user using the following formats. If specifying a UID
	// or GID, you must specify it as a positive integer.
	//
	//    * user
	//
	//    * user:group
	//
	//    * uid
	//
	//    * uid:gid
	//
	//    * user:gi
	//
	//    * uid:group
	//
	// This parameter is not supported for Windows containers.
	User *string `locationName:"user" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskContainerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskContainerProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskContainerProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaskContainerProperties"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.LinuxParameters != nil {
		if err := s.LinuxParameters.Validate(); err != nil {
			invalidParams.AddNested("LinuxParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.LogConfiguration != nil {
		if err := s.LogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RepositoryCredentials != nil {
		if err := s.RepositoryCredentials.Validate(); err != nil {
			invalidParams.AddNested("RepositoryCredentials", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Secrets != nil {
		for i, v := range s.Secrets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Secrets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ulimits != nil {
		for i, v := range s.Ulimits {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ulimits", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *TaskContainerProperties) SetCommand(v []*string) *TaskContainerProperties {
	s.Command = v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *TaskContainerProperties) SetDependsOn(v []*TaskContainerDependency) *TaskContainerProperties {
	s.DependsOn = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *TaskContainerProperties) SetEnvironment(v []*KeyValuePair) *TaskContainerProperties {
	s.Environment = v
	return s
}

// SetEssential sets the Essential field's value.
func (s *TaskContainerProperties) SetEssential(v bool) *TaskContainerProperties {
	s.Essential = &v
	return s
}

// SetImage sets the Image field's value.
func (s *TaskContainerProperties) SetImage(v string) *TaskContainerProperties {
	s.Image = &v
	return s
}

// SetLinuxParameters sets the LinuxParameters field's value.
func (s *TaskContainerProperties) SetLinuxParameters(v *LinuxParameters) *TaskContainerProperties {
	s.LinuxParameters = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *TaskContainerProperties) SetLogConfiguration(v *LogConfiguration) *TaskContainerProperties {
	s.LogConfiguration = v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *TaskContainerProperties) SetMountPoints(v []*MountPoint) *TaskContainerProperties {
	s.MountPoints = v
	return s
}

// SetName sets the Name field's value.
func (s *TaskContainerProperties) SetName(v string) *TaskContainerProperties {
	s.Name = &v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *TaskContainerProperties) SetPrivileged(v bool) *TaskContainerProperties {
	s.Privileged = &v
	return s
}

// SetReadonlyRootFilesystem sets the ReadonlyRootFilesystem field's value.
func (s *TaskContainerProperties) SetReadonlyRootFilesystem(v bool) *TaskContainerProperties {
	s.ReadonlyRootFilesystem = &v
	return s
}

// SetRepositoryCredentials sets the RepositoryCredentials field's value.
func (s *TaskContainerProperties) SetRepositoryCredentials(v *RepositoryCredentials) *TaskContainerProperties {
	s.RepositoryCredentials = v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *TaskContainerProperties) SetResourceRequirements(v []*ResourceRequirement) *TaskContainerProperties {
	s.ResourceRequirements = v
	return s
}

// SetSecrets sets the Secrets field's value.
func (s *TaskContainerProperties) SetSecrets(v []*Secret) *TaskContainerProperties {
	s.Secrets = v
	return s
}

// SetUlimits sets the Ulimits field's value.
func (s *TaskContainerProperties) SetUlimits(v []*Ulimit) *TaskContainerProperties {
	s.Ulimits = v
	return s
}

// SetUser sets the User field's value.
func (s *TaskContainerProperties) SetUser(v string) *TaskContainerProperties {
	s.User = &v
	return s
}

// An object that contains overrides for the task definition of a job.
type TaskPropertiesOverride struct {
	_ struct{} `type:"structure"`

	// The overrides for the container definition of a job.
	Containers []*TaskContainerOverrides `locationName:"containers" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskPropertiesOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaskPropertiesOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskPropertiesOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaskPropertiesOverride"}
	if s.Containers != nil {
		for i, v := range s.Containers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Containers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainers sets the Containers field's value.
func (s *TaskPropertiesOverride) SetContainers(v []*TaskContainerOverrides) *TaskPropertiesOverride {
	s.Containers = v
	return s
}

// Contains the parameters for TerminateJob.
type TerminateJobInput struct {
	_ struct{} `type:"structure"`

	// The Batch job ID of the job to terminate.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// A message to attach to the job that explains the reason for canceling it.
	// This message is returned by future DescribeJobs operations on the job. This
	// message is also recorded in the Batch activity logs.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *TerminateJobInput) SetJobId(v string) *TerminateJobInput {
	s.JobId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *TerminateJobInput) SetReason(v string) *TerminateJobInput {
	s.Reason = &v
	return s
}

type TerminateJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateJobOutput) GoString() string {
	return s.String()
}

// The container path, mount options, and size of the tmpfs mount.
//
// This object isn't applicable to jobs that are running on Fargate resources.
type Tmpfs struct {
	_ struct{} `type:"structure"`

	// The absolute file path in the container where the tmpfs volume is mounted.
	//
	// ContainerPath is a required field
	ContainerPath *string `locationName:"containerPath" type:"string" required:"true"`

	// The list of tmpfs volume mount options.
	//
	// Valid values: "defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev"
	// | "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" |
	// "nomand" | "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind"
	// | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared"
	// | "slave" | "rslave" | "relatime" | "norelatime" | "strictatime" | "nostrictatime"
	// | "mode" | "uid" | "gid" | "nr_inodes" | "nr_blocks" | "mpol"
	MountOptions []*string `locationName:"mountOptions" type:"list"`

	// The size (in MiB) of the tmpfs volume.
	//
	// Size is a required field
	Size *int64 `locationName:"size" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tmpfs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tmpfs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tmpfs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tmpfs"}
	if s.ContainerPath == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerPath"))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerPath sets the ContainerPath field's value.
func (s *Tmpfs) SetContainerPath(v string) *Tmpfs {
	s.ContainerPath = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *Tmpfs) SetMountOptions(v []*string) *Tmpfs {
	s.MountOptions = v
	return s
}

// SetSize sets the Size field's value.
func (s *Tmpfs) SetSize(v int64) *Tmpfs {
	s.Size = &v
	return s
}

// The ulimit settings to pass to the container. For more information, see Ulimit
// (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Ulimit.html).
//
// This object isn't applicable to jobs that are running on Fargate resources.
type Ulimit struct {
	_ struct{} `type:"structure"`

	// The hard limit for the ulimit type.
	//
	// HardLimit is a required field
	HardLimit *int64 `locationName:"hardLimit" type:"integer" required:"true"`

	// The type of the ulimit. Valid values are: core | cpu | data | fsize | locks
	// | memlock | msgqueue | nice | nofile | nproc | rss | rtprio | rttime | sigpending
	// | stack.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The soft limit for the ulimit type.
	//
	// SoftLimit is a required field
	SoftLimit *int64 `locationName:"softLimit" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ulimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ulimit) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ulimit) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ulimit"}
	if s.HardLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("HardLimit"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SoftLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("SoftLimit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHardLimit sets the HardLimit field's value.
func (s *Ulimit) SetHardLimit(v int64) *Ulimit {
	s.HardLimit = &v
	return s
}

// SetName sets the Name field's value.
func (s *Ulimit) SetName(v string) *Ulimit {
	s.Name = &v
	return s
}

// SetSoftLimit sets the SoftLimit field's value.
func (s *Ulimit) SetSoftLimit(v int64) *Ulimit {
	s.SoftLimit = &v
	return s
}

// Contains the parameters for UntagResource.
type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource from which to delete tags.
	// Batch resources that support tags are compute environments, jobs, job definitions,
	// job queues, and scheduling policies. ARNs for child jobs of array and multi-node
	// parallel (MNP) jobs aren't supported.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Contains the parameters for UpdateComputeEnvironment.
type UpdateComputeEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name or full Amazon Resource Name (ARN) of the compute environment to
	// update.
	//
	// ComputeEnvironment is a required field
	ComputeEnvironment *string `locationName:"computeEnvironment" type:"string" required:"true"`

	// Details of the compute resources managed by the compute environment. Required
	// for a managed compute environment. For more information, see Compute Environments
	// (https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
	// in the Batch User Guide.
	ComputeResources *ComputeResourceUpdate `locationName:"computeResources" type:"structure"`

	// The full Amazon Resource Name (ARN) of the IAM role that allows Batch to
	// make calls to other Amazon Web Services services on your behalf. For more
	// information, see Batch service IAM role (https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html)
	// in the Batch User Guide.
	//
	// If the compute environment has a service-linked role, it can't be changed
	// to use a regular IAM role. Likewise, if the compute environment has a regular
	// IAM role, it can't be changed to use a service-linked role. To update the
	// parameters for the compute environment that require an infrastructure update
	// to change, the AWSServiceRoleForBatch service-linked role must be used. For
	// more information, see Updating compute environments (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	//
	// If your specified role has a path other than /, then you must either specify
	// the full role ARN (recommended) or prefix the role name with the path.
	//
	// Depending on how you created your Batch service role, its ARN might contain
	// the service-role path prefix. When you only specify the name of the service
	// role, Batch assumes that your ARN doesn't use the service-role path prefix.
	// Because of this, we recommend that you specify the full ARN of your service
	// role when you create compute environments.
	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The state of the compute environment. Compute environments in the ENABLED
	// state can accept jobs from a queue and scale in or out automatically based
	// on the workload demand of its associated queues.
	//
	// If the state is ENABLED, then the Batch scheduler can attempt to place jobs
	// from an associated job queue on the compute resources within the environment.
	// If the compute environment is managed, then it can scale its instances out
	// or in automatically, based on the job queue demand.
	//
	// If the state is DISABLED, then the Batch scheduler doesn't attempt to place
	// jobs within the environment. Jobs in a STARTING or RUNNING state continue
	// to progress normally. Managed compute environments in the DISABLED state
	// don't scale out.
	//
	// Compute environments in a DISABLED state may continue to incur billing charges.
	// To prevent additional charges, turn off and then delete the compute environment.
	// For more information, see State (https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state)
	// in the Batch User Guide.
	//
	// When an instance is idle, the instance scales down to the minvCpus value.
	// However, the instance size doesn't change. For example, consider a c5.8xlarge
	// instance with a minvCpus value of 4 and a desiredvCpus value of 36. This
	// instance doesn't scale down to a c5.large instance.
	State *string `locationName:"state" type:"string" enum:"CEState"`

	// The maximum number of vCPUs expected to be used for an unmanaged compute
	// environment. Don't specify this parameter for a managed compute environment.
	// This parameter is only used for fair share scheduling to reserve vCPU capacity
	// for new share identifiers. If this parameter isn't provided for a fair share
	// job queue, no vCPU capacity is reserved.
	UnmanagedvCpus *int64 `locationName:"unmanagedvCpus" type:"integer"`

	// Specifies the updated infrastructure update policy for the compute environment.
	// For more information about infrastructure updates, see Updating compute environments
	// (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
	// in the Batch User Guide.
	UpdatePolicy *UpdatePolicy `locationName:"updatePolicy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComputeEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComputeEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComputeEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComputeEnvironmentInput"}
	if s.ComputeEnvironment == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironment"))
	}
	if s.ComputeResources != nil {
		if err := s.ComputeResources.Validate(); err != nil {
			invalidParams.AddNested("ComputeResources", err.(request.ErrInvalidParams))
		}
	}
	if s.UpdatePolicy != nil {
		if err := s.UpdatePolicy.Validate(); err != nil {
			invalidParams.AddNested("UpdatePolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironment sets the ComputeEnvironment field's value.
func (s *UpdateComputeEnvironmentInput) SetComputeEnvironment(v string) *UpdateComputeEnvironmentInput {
	s.ComputeEnvironment = &v
	return s
}

// SetComputeResources sets the ComputeResources field's value.
func (s *UpdateComputeEnvironmentInput) SetComputeResources(v *ComputeResourceUpdate) *UpdateComputeEnvironmentInput {
	s.ComputeResources = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *UpdateComputeEnvironmentInput) SetServiceRole(v string) *UpdateComputeEnvironmentInput {
	s.ServiceRole = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateComputeEnvironmentInput) SetState(v string) *UpdateComputeEnvironmentInput {
	s.State = &v
	return s
}

// SetUnmanagedvCpus sets the UnmanagedvCpus field's value.
func (s *UpdateComputeEnvironmentInput) SetUnmanagedvCpus(v int64) *UpdateComputeEnvironmentInput {
	s.UnmanagedvCpus = &v
	return s
}

// SetUpdatePolicy sets the UpdatePolicy field's value.
func (s *UpdateComputeEnvironmentInput) SetUpdatePolicy(v *UpdatePolicy) *UpdateComputeEnvironmentInput {
	s.UpdatePolicy = v
	return s
}

type UpdateComputeEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	ComputeEnvironmentArn *string `locationName:"computeEnvironmentArn" type:"string"`

	// The name of the compute environment. It can be up to 128 characters long.
	// It can contain uppercase and lowercase letters, numbers, hyphens (-), and
	// underscores (_).
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComputeEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComputeEnvironmentOutput) GoString() string {
	return s.String()
}

// SetComputeEnvironmentArn sets the ComputeEnvironmentArn field's value.
func (s *UpdateComputeEnvironmentOutput) SetComputeEnvironmentArn(v string) *UpdateComputeEnvironmentOutput {
	s.ComputeEnvironmentArn = &v
	return s
}

// SetComputeEnvironmentName sets the ComputeEnvironmentName field's value.
func (s *UpdateComputeEnvironmentOutput) SetComputeEnvironmentName(v string) *UpdateComputeEnvironmentOutput {
	s.ComputeEnvironmentName = &v
	return s
}

// Contains the parameters for UpdateJobQueue.
type UpdateJobQueueInput struct {
	_ struct{} `type:"structure"`

	// Details the set of compute environments mapped to a job queue and their order
	// relative to each other. This is one of the parameters used by the job scheduler
	// to determine which compute environment runs a given job. Compute environments
	// must be in the VALID state before you can associate them with a job queue.
	// All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate
	// (FARGATE or FARGATE_SPOT). EC2 and Fargate compute environments can't be
	// mixed.
	//
	// All compute environments that are associated with a job queue must share
	// the same architecture. Batch doesn't support mixing compute environment architecture
	// types in a single job queue.
	ComputeEnvironmentOrder []*ComputeEnvironmentOrder `locationName:"computeEnvironmentOrder" type:"list"`

	// The name or the Amazon Resource Name (ARN) of the job queue.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`

	// The priority of the job queue. Job queues with a higher priority (or a higher
	// integer value for the priority parameter) are evaluated first when associated
	// with the same compute environment. Priority is determined in descending order.
	// For example, a job queue with a priority value of 10 is given scheduling
	// preference over a job queue with a priority value of 1. All of the compute
	// environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT).
	// EC2 and Fargate compute environments can't be mixed.
	Priority *int64 `locationName:"priority" type:"integer"`

	// Amazon Resource Name (ARN) of the fair share scheduling policy. Once a job
	// queue is created, the fair share scheduling policy can be replaced but not
	// removed. The format is aws:Partition:batch:Region:Account:scheduling-policy/Name
	// . For example, aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy.
	SchedulingPolicyArn *string `locationName:"schedulingPolicyArn" type:"string"`

	// Describes the queue's ability to accept new jobs. If the job queue state
	// is ENABLED, it can accept jobs. If the job queue state is DISABLED, new jobs
	// can't be added to the queue, but jobs already in the queue can finish.
	State *string `locationName:"state" type:"string" enum:"JQState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobQueueInput"}
	if s.JobQueue == nil {
		invalidParams.Add(request.NewErrParamRequired("JobQueue"))
	}
	if s.ComputeEnvironmentOrder != nil {
		for i, v := range s.ComputeEnvironmentOrder {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComputeEnvironmentOrder", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironmentOrder sets the ComputeEnvironmentOrder field's value.
func (s *UpdateJobQueueInput) SetComputeEnvironmentOrder(v []*ComputeEnvironmentOrder) *UpdateJobQueueInput {
	s.ComputeEnvironmentOrder = v
	return s
}

// SetJobQueue sets the JobQueue field's value.
func (s *UpdateJobQueueInput) SetJobQueue(v string) *UpdateJobQueueInput {
	s.JobQueue = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateJobQueueInput) SetPriority(v int64) *UpdateJobQueueInput {
	s.Priority = &v
	return s
}

// SetSchedulingPolicyArn sets the SchedulingPolicyArn field's value.
func (s *UpdateJobQueueInput) SetSchedulingPolicyArn(v string) *UpdateJobQueueInput {
	s.SchedulingPolicyArn = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateJobQueueInput) SetState(v string) *UpdateJobQueueInput {
	s.State = &v
	return s
}

type UpdateJobQueueOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the job queue.
	JobQueueArn *string `locationName:"jobQueueArn" type:"string"`

	// The name of the job queue.
	JobQueueName *string `locationName:"jobQueueName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateJobQueueOutput) GoString() string {
	return s.String()
}

// SetJobQueueArn sets the JobQueueArn field's value.
func (s *UpdateJobQueueOutput) SetJobQueueArn(v string) *UpdateJobQueueOutput {
	s.JobQueueArn = &v
	return s
}

// SetJobQueueName sets the JobQueueName field's value.
func (s *UpdateJobQueueOutput) SetJobQueueName(v string) *UpdateJobQueueOutput {
	s.JobQueueName = &v
	return s
}

// Specifies the infrastructure update policy for the compute environment. For
// more information about infrastructure updates, see Updating compute environments
// (https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html)
// in the Batch User Guide.
type UpdatePolicy struct {
	_ struct{} `type:"structure"`

	// Specifies the job timeout (in minutes) when the compute environment infrastructure
	// is updated. The default value is 30.
	JobExecutionTimeoutMinutes *int64 `locationName:"jobExecutionTimeoutMinutes" min:"1" type:"long"`

	// Specifies whether jobs are automatically terminated when the computer environment
	// infrastructure is updated. The default value is false.
	TerminateJobsOnUpdate *bool `locationName:"terminateJobsOnUpdate" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePolicy"}
	if s.JobExecutionTimeoutMinutes != nil && *s.JobExecutionTimeoutMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("JobExecutionTimeoutMinutes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobExecutionTimeoutMinutes sets the JobExecutionTimeoutMinutes field's value.
func (s *UpdatePolicy) SetJobExecutionTimeoutMinutes(v int64) *UpdatePolicy {
	s.JobExecutionTimeoutMinutes = &v
	return s
}

// SetTerminateJobsOnUpdate sets the TerminateJobsOnUpdate field's value.
func (s *UpdatePolicy) SetTerminateJobsOnUpdate(v bool) *UpdatePolicy {
	s.TerminateJobsOnUpdate = &v
	return s
}

// Contains the parameters for UpdateSchedulingPolicy.
type UpdateSchedulingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the scheduling policy to update.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The fair share policy.
	FairsharePolicy *FairsharePolicy `locationName:"fairsharePolicy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchedulingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchedulingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSchedulingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSchedulingPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.FairsharePolicy != nil {
		if err := s.FairsharePolicy.Validate(); err != nil {
			invalidParams.AddNested("FairsharePolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateSchedulingPolicyInput) SetArn(v string) *UpdateSchedulingPolicyInput {
	s.Arn = &v
	return s
}

// SetFairsharePolicy sets the FairsharePolicy field's value.
func (s *UpdateSchedulingPolicyInput) SetFairsharePolicy(v *FairsharePolicy) *UpdateSchedulingPolicyInput {
	s.FairsharePolicy = v
	return s
}

type UpdateSchedulingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchedulingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchedulingPolicyOutput) GoString() string {
	return s.String()
}

// A data volume that's used in a job's container properties.
type Volume struct {
	_ struct{} `type:"structure"`

	// This parameter is specified when you're using an Amazon Elastic File System
	// file system for job storage. Jobs that are running on Fargate resources must
	// specify a platformVersion of at least 1.4.0.
	EfsVolumeConfiguration *EFSVolumeConfiguration `locationName:"efsVolumeConfiguration" type:"structure"`

	// The contents of the host parameter determine whether your data volume persists
	// on the host container instance and where it's stored. If the host parameter
	// is empty, then the Docker daemon assigns a host path for your data volume.
	// However, the data isn't guaranteed to persist after the containers that are
	// associated with it stop running.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided.
	Host *Host `locationName:"host" type:"structure"`

	// The name of the volume. It can be up to 255 characters long. It can contain
	// uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
	// This name is referenced in the sourceVolume parameter of container definition
	// mountPoints.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Volume) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Volume) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Volume"}
	if s.EfsVolumeConfiguration != nil {
		if err := s.EfsVolumeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EfsVolumeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEfsVolumeConfiguration sets the EfsVolumeConfiguration field's value.
func (s *Volume) SetEfsVolumeConfiguration(v *EFSVolumeConfiguration) *Volume {
	s.EfsVolumeConfiguration = v
	return s
}

// SetHost sets the Host field's value.
func (s *Volume) SetHost(v *Host) *Volume {
	s.Host = v
	return s
}

// SetName sets the Name field's value.
func (s *Volume) SetName(v string) *Volume {
	s.Name = &v
	return s
}

const (
	// ArrayJobDependencyNToN is a ArrayJobDependency enum value
	ArrayJobDependencyNToN = "N_TO_N"

	// ArrayJobDependencySequential is a ArrayJobDependency enum value
	ArrayJobDependencySequential = "SEQUENTIAL"
)

// ArrayJobDependency_Values returns all elements of the ArrayJobDependency enum
func ArrayJobDependency_Values() []string {
	return []string{
		ArrayJobDependencyNToN,
		ArrayJobDependencySequential,
	}
}

const (
	// AssignPublicIpEnabled is a AssignPublicIp enum value
	AssignPublicIpEnabled = "ENABLED"

	// AssignPublicIpDisabled is a AssignPublicIp enum value
	AssignPublicIpDisabled = "DISABLED"
)

// AssignPublicIp_Values returns all elements of the AssignPublicIp enum
func AssignPublicIp_Values() []string {
	return []string{
		AssignPublicIpEnabled,
		AssignPublicIpDisabled,
	}
}

const (
	// CEStateEnabled is a CEState enum value
	CEStateEnabled = "ENABLED"

	// CEStateDisabled is a CEState enum value
	CEStateDisabled = "DISABLED"
)

// CEState_Values returns all elements of the CEState enum
func CEState_Values() []string {
	return []string{
		CEStateEnabled,
		CEStateDisabled,
	}
}

const (
	// CEStatusCreating is a CEStatus enum value
	CEStatusCreating = "CREATING"

	// CEStatusUpdating is a CEStatus enum value
	CEStatusUpdating = "UPDATING"

	// CEStatusDeleting is a CEStatus enum value
	CEStatusDeleting = "DELETING"

	// CEStatusDeleted is a CEStatus enum value
	CEStatusDeleted = "DELETED"

	// CEStatusValid is a CEStatus enum value
	CEStatusValid = "VALID"

	// CEStatusInvalid is a CEStatus enum value
	CEStatusInvalid = "INVALID"
)

// CEStatus_Values returns all elements of the CEStatus enum
func CEStatus_Values() []string {
	return []string{
		CEStatusCreating,
		CEStatusUpdating,
		CEStatusDeleting,
		CEStatusDeleted,
		CEStatusValid,
		CEStatusInvalid,
	}
}

const (
	// CETypeManaged is a CEType enum value
	CETypeManaged = "MANAGED"

	// CETypeUnmanaged is a CEType enum value
	CETypeUnmanaged = "UNMANAGED"
)

// CEType_Values returns all elements of the CEType enum
func CEType_Values() []string {
	return []string{
		CETypeManaged,
		CETypeUnmanaged,
	}
}

const (
	// CRAllocationStrategyBestFit is a CRAllocationStrategy enum value
	CRAllocationStrategyBestFit = "BEST_FIT"

	// CRAllocationStrategyBestFitProgressive is a CRAllocationStrategy enum value
	CRAllocationStrategyBestFitProgressive = "BEST_FIT_PROGRESSIVE"

	// CRAllocationStrategySpotCapacityOptimized is a CRAllocationStrategy enum value
	CRAllocationStrategySpotCapacityOptimized = "SPOT_CAPACITY_OPTIMIZED"

	// CRAllocationStrategySpotPriceCapacityOptimized is a CRAllocationStrategy enum value
	CRAllocationStrategySpotPriceCapacityOptimized = "SPOT_PRICE_CAPACITY_OPTIMIZED"
)

// CRAllocationStrategy_Values returns all elements of the CRAllocationStrategy enum
func CRAllocationStrategy_Values() []string {
	return []string{
		CRAllocationStrategyBestFit,
		CRAllocationStrategyBestFitProgressive,
		CRAllocationStrategySpotCapacityOptimized,
		CRAllocationStrategySpotPriceCapacityOptimized,
	}
}

const (
	// CRTypeEc2 is a CRType enum value
	CRTypeEc2 = "EC2"

	// CRTypeSpot is a CRType enum value
	CRTypeSpot = "SPOT"

	// CRTypeFargate is a CRType enum value
	CRTypeFargate = "FARGATE"

	// CRTypeFargateSpot is a CRType enum value
	CRTypeFargateSpot = "FARGATE_SPOT"
)

// CRType_Values returns all elements of the CRType enum
func CRType_Values() []string {
	return []string{
		CRTypeEc2,
		CRTypeSpot,
		CRTypeFargate,
		CRTypeFargateSpot,
	}
}

const (
	// CRUpdateAllocationStrategyBestFitProgressive is a CRUpdateAllocationStrategy enum value
	CRUpdateAllocationStrategyBestFitProgressive = "BEST_FIT_PROGRESSIVE"

	// CRUpdateAllocationStrategySpotCapacityOptimized is a CRUpdateAllocationStrategy enum value
	CRUpdateAllocationStrategySpotCapacityOptimized = "SPOT_CAPACITY_OPTIMIZED"

	// CRUpdateAllocationStrategySpotPriceCapacityOptimized is a CRUpdateAllocationStrategy enum value
	CRUpdateAllocationStrategySpotPriceCapacityOptimized = "SPOT_PRICE_CAPACITY_OPTIMIZED"
)

// CRUpdateAllocationStrategy_Values returns all elements of the CRUpdateAllocationStrategy enum
func CRUpdateAllocationStrategy_Values() []string {
	return []string{
		CRUpdateAllocationStrategyBestFitProgressive,
		CRUpdateAllocationStrategySpotCapacityOptimized,
		CRUpdateAllocationStrategySpotPriceCapacityOptimized,
	}
}

const (
	// DeviceCgroupPermissionRead is a DeviceCgroupPermission enum value
	DeviceCgroupPermissionRead = "READ"

	// DeviceCgroupPermissionWrite is a DeviceCgroupPermission enum value
	DeviceCgroupPermissionWrite = "WRITE"

	// DeviceCgroupPermissionMknod is a DeviceCgroupPermission enum value
	DeviceCgroupPermissionMknod = "MKNOD"
)

// DeviceCgroupPermission_Values returns all elements of the DeviceCgroupPermission enum
func DeviceCgroupPermission_Values() []string {
	return []string{
		DeviceCgroupPermissionRead,
		DeviceCgroupPermissionWrite,
		DeviceCgroupPermissionMknod,
	}
}

const (
	// EFSAuthorizationConfigIAMEnabled is a EFSAuthorizationConfigIAM enum value
	EFSAuthorizationConfigIAMEnabled = "ENABLED"

	// EFSAuthorizationConfigIAMDisabled is a EFSAuthorizationConfigIAM enum value
	EFSAuthorizationConfigIAMDisabled = "DISABLED"
)

// EFSAuthorizationConfigIAM_Values returns all elements of the EFSAuthorizationConfigIAM enum
func EFSAuthorizationConfigIAM_Values() []string {
	return []string{
		EFSAuthorizationConfigIAMEnabled,
		EFSAuthorizationConfigIAMDisabled,
	}
}

const (
	// EFSTransitEncryptionEnabled is a EFSTransitEncryption enum value
	EFSTransitEncryptionEnabled = "ENABLED"

	// EFSTransitEncryptionDisabled is a EFSTransitEncryption enum value
	EFSTransitEncryptionDisabled = "DISABLED"
)

// EFSTransitEncryption_Values returns all elements of the EFSTransitEncryption enum
func EFSTransitEncryption_Values() []string {
	return []string{
		EFSTransitEncryptionEnabled,
		EFSTransitEncryptionDisabled,
	}
}

const (
	// JQStateEnabled is a JQState enum value
	JQStateEnabled = "ENABLED"

	// JQStateDisabled is a JQState enum value
	JQStateDisabled = "DISABLED"
)

// JQState_Values returns all elements of the JQState enum
func JQState_Values() []string {
	return []string{
		JQStateEnabled,
		JQStateDisabled,
	}
}

const (
	// JQStatusCreating is a JQStatus enum value
	JQStatusCreating = "CREATING"

	// JQStatusUpdating is a JQStatus enum value
	JQStatusUpdating = "UPDATING"

	// JQStatusDeleting is a JQStatus enum value
	JQStatusDeleting = "DELETING"

	// JQStatusDeleted is a JQStatus enum value
	JQStatusDeleted = "DELETED"

	// JQStatusValid is a JQStatus enum value
	JQStatusValid = "VALID"

	// JQStatusInvalid is a JQStatus enum value
	JQStatusInvalid = "INVALID"
)

// JQStatus_Values returns all elements of the JQStatus enum
func JQStatus_Values() []string {
	return []string{
		JQStatusCreating,
		JQStatusUpdating,
		JQStatusDeleting,
		JQStatusDeleted,
		JQStatusValid,
		JQStatusInvalid,
	}
}

const (
	// JobDefinitionTypeContainer is a JobDefinitionType enum value
	JobDefinitionTypeContainer = "container"

	// JobDefinitionTypeMultinode is a JobDefinitionType enum value
	JobDefinitionTypeMultinode = "multinode"
)

// JobDefinitionType_Values returns all elements of the JobDefinitionType enum
func JobDefinitionType_Values() []string {
	return []string{
		JobDefinitionTypeContainer,
		JobDefinitionTypeMultinode,
	}
}

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusPending is a JobStatus enum value
	JobStatusPending = "PENDING"

	// JobStatusRunnable is a JobStatus enum value
	JobStatusRunnable = "RUNNABLE"

	// JobStatusStarting is a JobStatus enum value
	JobStatusStarting = "STARTING"

	// JobStatusRunning is a JobStatus enum value
	JobStatusRunning = "RUNNING"

	// JobStatusSucceeded is a JobStatus enum value
	JobStatusSucceeded = "SUCCEEDED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusSubmitted,
		JobStatusPending,
		JobStatusRunnable,
		JobStatusStarting,
		JobStatusRunning,
		JobStatusSucceeded,
		JobStatusFailed,
	}
}

const (
	// LogDriverJsonFile is a LogDriver enum value
	LogDriverJsonFile = "json-file"

	// LogDriverSyslog is a LogDriver enum value
	LogDriverSyslog = "syslog"

	// LogDriverJournald is a LogDriver enum value
	LogDriverJournald = "journald"

	// LogDriverGelf is a LogDriver enum value
	LogDriverGelf = "gelf"

	// LogDriverFluentd is a LogDriver enum value
	LogDriverFluentd = "fluentd"

	// LogDriverAwslogs is a LogDriver enum value
	LogDriverAwslogs = "awslogs"

	// LogDriverSplunk is a LogDriver enum value
	LogDriverSplunk = "splunk"
)

// LogDriver_Values returns all elements of the LogDriver enum
func LogDriver_Values() []string {
	return []string{
		LogDriverJsonFile,
		LogDriverSyslog,
		LogDriverJournald,
		LogDriverGelf,
		LogDriverFluentd,
		LogDriverAwslogs,
		LogDriverSplunk,
	}
}

const (
	// OrchestrationTypeEcs is a OrchestrationType enum value
	OrchestrationTypeEcs = "ECS"

	// OrchestrationTypeEks is a OrchestrationType enum value
	OrchestrationTypeEks = "EKS"
)

// OrchestrationType_Values returns all elements of the OrchestrationType enum
func OrchestrationType_Values() []string {
	return []string{
		OrchestrationTypeEcs,
		OrchestrationTypeEks,
	}
}

const (
	// PlatformCapabilityEc2 is a PlatformCapability enum value
	PlatformCapabilityEc2 = "EC2"

	// PlatformCapabilityFargate is a PlatformCapability enum value
	PlatformCapabilityFargate = "FARGATE"
)

// PlatformCapability_Values returns all elements of the PlatformCapability enum
func PlatformCapability_Values() []string {
	return []string{
		PlatformCapabilityEc2,
		PlatformCapabilityFargate,
	}
}

const (
	// ResourceTypeGpu is a ResourceType enum value
	ResourceTypeGpu = "GPU"

	// ResourceTypeVcpu is a ResourceType enum value
	ResourceTypeVcpu = "VCPU"

	// ResourceTypeMemory is a ResourceType enum value
	ResourceTypeMemory = "MEMORY"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeGpu,
		ResourceTypeVcpu,
		ResourceTypeMemory,
	}
}

const (
	// RetryActionRetry is a RetryAction enum value
	RetryActionRetry = "RETRY"

	// RetryActionExit is a RetryAction enum value
	RetryActionExit = "EXIT"
)

// RetryAction_Values returns all elements of the RetryAction enum
func RetryAction_Values() []string {
	return []string{
		RetryActionRetry,
		RetryActionExit,
	}
}
