//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// Values for the different cookie accept policies
///
///
///
/// only from the main document domain
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nshttpcookieacceptpolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSHTTPCookieAcceptPolicy(pub NSUInteger);
impl NSHTTPCookieAcceptPolicy {
    #[doc(alias = "NSHTTPCookieAcceptPolicyAlways")]
    pub const Always: Self = Self(0);
    #[doc(alias = "NSHTTPCookieAcceptPolicyNever")]
    pub const Never: Self = Self(1);
    #[doc(alias = "NSHTTPCookieAcceptPolicyOnlyFromMainDocumentDomain")]
    pub const OnlyFromMainDocumentDomain: Self = Self(2);
}

unsafe impl Encode for NSHTTPCookieAcceptPolicy {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSHTTPCookieAcceptPolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// NSHTTPCookieStorage implements a singleton object (shared
    /// instance) which manages the shared cookie store.  It has methods
    /// to allow clients to set and remove cookies, and get the current
    /// set of cookies.  It also has convenience methods to parse and
    /// generate cookie-related HTTP header fields.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nshttpcookiestorage?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSHTTPCookieStorage;
);

unsafe impl Send for NSHTTPCookieStorage {}

unsafe impl Sync for NSHTTPCookieStorage {}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSHTTPCookieStorage {}
);

impl NSHTTPCookieStorage {
    extern_methods!(
        /// Get the shared cookie storage in the default location.
        ///
        /// Returns: The shared cookie storage
        ///
        /// Starting in OS X 10.11, each app has its own sharedHTTPCookieStorage singleton,
        /// which will not be shared with other applications.
        #[unsafe(method(sharedHTTPCookieStorage))]
        #[unsafe(method_family = none)]
        pub fn sharedHTTPCookieStorage() -> Retained<NSHTTPCookieStorage>;

        #[cfg(feature = "NSString")]
        /// Get the cookie storage for the container associated with the specified application group identifier
        ///
        /// Parameter `identifier`: The application group identifier
        ///
        /// Returns: A cookie storage with a persistent store in the application group container
        ///
        /// By default, applications and associated app extensions have different data containers, which means
        /// that the sharedHTTPCookieStorage singleton will refer to different persistent cookie stores in an application and
        /// any app extensions that it contains. This method allows clients to create a persistent cookie storage that can be
        /// shared among all applications and extensions with access to the same application group. Subsequent calls to this
        /// method with the same identifier will return the same cookie storage instance.
        #[unsafe(method(sharedCookieStorageForGroupContainerIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn sharedCookieStorageForGroupContainerIdentifier(
            identifier: &NSString,
        ) -> Retained<NSHTTPCookieStorage>;

        #[cfg(all(feature = "NSArray", feature = "NSHTTPCookie"))]
        /// Get all the cookies
        ///
        /// Returns: An NSArray of NSHTTPCookies
        #[unsafe(method(cookies))]
        #[unsafe(method_family = none)]
        pub fn cookies(&self) -> Option<Retained<NSArray<NSHTTPCookie>>>;

        #[cfg(feature = "NSHTTPCookie")]
        /// Set a cookie
        ///
        /// The cookie will override an existing cookie with the
        /// same name, domain and path, if any.
        #[unsafe(method(setCookie:))]
        #[unsafe(method_family = none)]
        pub fn setCookie(&self, cookie: &NSHTTPCookie);

        #[cfg(feature = "NSHTTPCookie")]
        /// Delete the specified cookie
        #[unsafe(method(deleteCookie:))]
        #[unsafe(method_family = none)]
        pub fn deleteCookie(&self, cookie: &NSHTTPCookie);

        #[cfg(feature = "NSDate")]
        /// Delete all cookies from the cookie storage since the provided date.
        #[unsafe(method(removeCookiesSinceDate:))]
        #[unsafe(method_family = none)]
        pub fn removeCookiesSinceDate(&self, date: &NSDate);

        #[cfg(all(feature = "NSArray", feature = "NSHTTPCookie", feature = "NSURL"))]
        /// Returns an array of cookies to send to the given URL.
        ///
        /// Parameter `URL`: The URL for which to get cookies.
        ///
        /// Returns: an NSArray of NSHTTPCookie objects.
        ///
        /// The cookie manager examines the cookies it stores and
        /// includes those which should be sent to the given URL. You can use
        /// <tt>
        /// +[NSCookie requestHeaderFieldsWithCookies:]
        /// </tt>
        /// to turn this array
        /// into a set of header fields to add to a request.
        #[unsafe(method(cookiesForURL:))]
        #[unsafe(method_family = none)]
        pub fn cookiesForURL(&self, url: &NSURL) -> Option<Retained<NSArray<NSHTTPCookie>>>;

        #[cfg(all(feature = "NSArray", feature = "NSHTTPCookie", feature = "NSURL"))]
        /// Adds an array cookies to the cookie store, following the
        /// cookie accept policy.
        ///
        /// Parameter `cookies`: The cookies to set.
        ///
        /// Parameter `URL`: The URL from which the cookies were sent.
        ///
        /// Parameter `mainDocumentURL`: The main document URL to be used as a base for the "same
        /// domain as main document" policy.
        ///
        /// For mainDocumentURL, the caller should pass the URL for
        /// an appropriate main document, if known. For example, when loading
        /// a web page, the URL of the main html document for the top-level
        /// frame should be passed. To save cookies based on a set of response
        /// headers, you can use
        /// <tt>
        /// +[NSCookie
        /// cookiesWithResponseHeaderFields:forURL:]
        /// </tt>
        /// on a header field
        /// dictionary and then use this method to store the resulting cookies
        /// in accordance with policy settings.
        #[unsafe(method(setCookies:forURL:mainDocumentURL:))]
        #[unsafe(method_family = none)]
        pub fn setCookies_forURL_mainDocumentURL(
            &self,
            cookies: &NSArray<NSHTTPCookie>,
            url: Option<&NSURL>,
            main_document_url: Option<&NSURL>,
        );

        /// The cookie accept policy preference of the
        /// receiver.
        #[unsafe(method(cookieAcceptPolicy))]
        #[unsafe(method_family = none)]
        pub fn cookieAcceptPolicy(&self) -> NSHTTPCookieAcceptPolicy;

        /// Setter for [`cookieAcceptPolicy`][Self::cookieAcceptPolicy].
        #[unsafe(method(setCookieAcceptPolicy:))]
        #[unsafe(method_family = none)]
        pub fn setCookieAcceptPolicy(&self, cookie_accept_policy: NSHTTPCookieAcceptPolicy);

        #[cfg(all(
            feature = "NSArray",
            feature = "NSHTTPCookie",
            feature = "NSSortDescriptor"
        ))]
        /// Returns an array of all cookies in the store, sorted according to the key value and sorting direction of the NSSortDescriptors specified in the parameter.
        ///
        /// Parameter `sortOrder`: an array of NSSortDescriptors which represent the preferred sort order of the resulting array.
        ///
        /// proper sorting of cookies may require extensive string conversion, which can be avoided by allowing the system to perform the sorting.  This API is to be preferred over the more generic -[NSHTTPCookieStorage cookies] API, if sorting is going to be performed.
        #[unsafe(method(sortedCookiesUsingDescriptors:))]
        #[unsafe(method_family = none)]
        pub fn sortedCookiesUsingDescriptors(
            &self,
            sort_order: &NSArray<NSSortDescriptor>,
        ) -> Retained<NSArray<NSHTTPCookie>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSHTTPCookieStorage {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSHTTPCookieStorage {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSURLSessionTaskAdditions.
impl NSHTTPCookieStorage {
    extern_methods!(
        #[cfg(all(
            feature = "NSArray",
            feature = "NSHTTPCookie",
            feature = "NSURLSession"
        ))]
        #[unsafe(method(storeCookies:forTask:))]
        #[unsafe(method_family = none)]
        pub fn storeCookies_forTask(
            &self,
            cookies: &NSArray<NSHTTPCookie>,
            task: &NSURLSessionTask,
        );

        #[cfg(all(
            feature = "NSArray",
            feature = "NSHTTPCookie",
            feature = "NSURLSession",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(getCookiesForTask:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCookiesForTask_completionHandler(
            &self,
            task: &NSURLSessionTask,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSArray<NSHTTPCookie>)>,
        );
    );
}

extern "C" {
    /// Name of notification that should be posted to the
    /// distributed notification center whenever the accept cookies
    /// preference is changed
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nshttpcookiemanageracceptpolicychangednotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    #[deprecated = "Notification is never posted"]
    pub static NSHTTPCookieManagerAcceptPolicyChangedNotification: &'static NSNotificationName;
}

extern "C" {
    /// Notification sent when the set of cookies changes
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nshttpcookiemanagercookieschangednotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    pub static NSHTTPCookieManagerCookiesChangedNotification: &'static NSNotificationName;
}
