# How to contribute

dopewars is open-source software, meaning that it is free for anybody to
use. However, this also means that the quality of the software is dependent
in part on **you** the user. You **don't** have to be a programmer to
help out - in fact, dopewars currently needs people to produce sounds and
graphics rather than to write code.

 - **Sounds** are needed. dopewars-1.5.7 and later support sounds, but
   don't contain sounds for every game event. If **you** can provide
   copyright-free sounds, then short files are needed for various effects
   in the game. For example, gunshots, bullet hits, ricochets and subway
   trains are obvious candidates for sound effects, although pretty much
   any event in the game that you can think of can conceivably have a sound
   (e.g. when players join or leave the game). These sounds should be in WAV
   format, and should probably be no more than a second or two in length.
   Later versions of dopewars may also be able to play longer repeating
   sounds (i.e. music) if you're interested in contributing this. Please
   open a [pull request](https://github.com/benmwebb/dopewars/pulls)
   to add sound files to dopewars.

 - **Suggestions** for future improvements are always welcomed at the
   [issue tracker](https://github.com/benmwebb/dopewars/issues).
   These can be anything from "the game interface is confusing" through
   "more game locations are needed" to "what about a hospital". (I can't
   guarantee that such suggestions will ever make it into dopewars, but
   it's a lot easier if I know they exist! Also, it's far more likely
   to happen if you write the code - see the
   [tips for developers](https://dopewars.sourceforge.io/docs/developer.html)
   page.)

 - **Bug reports** are always useful. Register them with the
   [issue tracker](https://github.com/benmwebb/dopewars/issues).
   If I don't know the problem exists, I can't fix it...
   The more information you can give here, the better. In particular, I need
   to know your operating system - e.g. Linux or Windows. For Linux, gdb stack
   traces of the core file are most useful.

 - **Configuration files** can be included in future distributions. If
   you run a customised game, and think others might want to play with your
   configuration, or at least use it as an example, then post it in the
   [issue tracker](https://github.com/benmwebb/dopewars/issues).

 - **Translation** of dopewars into your language will enable you to
   play the game in your native tongue, and will also help others that speak
   the same language. It's pretty easy, too - all you have to do is edit a
   simple text file! See the
   [i18n pages](https://dopewars.sourceforge.io/docs/developer.html).
