"use strict";(self.webpackChunkinfluxdb_ui=self.webpackChunkinfluxdb_ui||[]).push([[102],{4452:e=>{e.exports='# Retrieve data from MODBUS slave devices\n[[inputs.modbus]]\n  ## Connection Configuration\n  ##\n  ## The plugin supports connections to PLCs via MODBUS/TCP, RTU over TCP, ASCII over TCP or\n  ## via serial line communication in binary (RTU) or readable (ASCII) encoding\n  ##\n  ## Device name\n  name = "Device"\n\n  ## Slave ID - addresses a MODBUS device on the bus\n  ## Range: 0 - 255 [0 = broadcast; 248 - 255 = reserved]\n  slave_id = 1\n\n  ## Timeout for each request\n  timeout = "1s"\n\n  ## Maximum number of retries and the time to wait between retries\n  ## when a slave-device is busy.\n  # busy_retries = 0\n  # busy_retries_wait = "100ms"\n\n  # TCP - connect via Modbus/TCP\n  controller = "tcp://localhost:502"\n\n  ## Serial (RS485; RS232)\n  # controller = "file:///dev/ttyUSB0"\n  # baud_rate = 9600\n  # data_bits = 8\n  # parity = "N"\n  # stop_bits = 1\n\n  ## For Modbus over TCP you can choose between "TCP", "RTUoverTCP" and "ASCIIoverTCP"\n  ## default behaviour is "TCP" if the controller is TCP\n  ## For Serial you can choose between "RTU" and "ASCII"\n  # transmission_mode = "RTU"\n\n  ## Trace the connection to the modbus device as debug messages\n  ## Note: You have to enable telegraf\'s debug mode to see those messages!\n  # debug_connection = false\n\n  ## Define the configuration schema\n  ##  |---register -- define fields per register type in the original style (only supports one slave ID)\n  ##  |---request  -- define fields on a requests base\n  configuration_type = "register"\n\n  ## --- "register" configuration style ---\n\n  ## Measurements\n  ##\n\n  ## Digital Variables, Discrete Inputs and Coils\n  ## measurement - the (optional) measurement name, defaults to "modbus"\n  ## name        - the variable name\n  ## address     - variable address\n\n  discrete_inputs = [\n    { name = "start",          address = [0]},\n    { name = "stop",           address = [1]},\n    { name = "reset",          address = [2]},\n    { name = "emergency_stop", address = [3]},\n  ]\n  coils = [\n    { name = "motor1_run",     address = [0]},\n    { name = "motor1_jog",     address = [1]},\n    { name = "motor1_stop",    address = [2]},\n  ]\n\n  ## Analog Variables, Input Registers and Holding Registers\n  ## measurement - the (optional) measurement name, defaults to "modbus"\n  ## name        - the variable name\n  ## byte_order  - the ordering of bytes\n  ##  |---AB, ABCD   - Big Endian\n  ##  |---BA, DCBA   - Little Endian\n  ##  |---BADC       - Mid-Big Endian\n  ##  |---CDAB       - Mid-Little Endian\n  ## data_type   - INT16, UINT16, INT32, UINT32, INT64, UINT64,\n  ##               FLOAT32-IEEE, FLOAT64-IEEE (the IEEE 754 binary representation)\n  ##               FLOAT32, FIXED, UFIXED (fixed-point representation on input)\n  ## scale       - the final numeric variable representation\n  ## address     - variable address\n\n  holding_registers = [\n    { name = "power_factor", byte_order = "AB",   data_type = "FIXED", scale=0.01,  address = [8]},\n    { name = "voltage",      byte_order = "AB",   data_type = "FIXED", scale=0.1,   address = [0]},\n    { name = "energy",       byte_order = "ABCD", data_type = "FIXED", scale=0.001, address = [5,6]},\n    { name = "current",      byte_order = "ABCD", data_type = "FIXED", scale=0.001, address = [1,2]},\n    { name = "frequency",    byte_order = "AB",   data_type = "UFIXED", scale=0.1,  address = [7]},\n    { name = "power",        byte_order = "ABCD", data_type = "UFIXED", scale=0.1,  address = [3,4]},\n  ]\n  input_registers = [\n    { name = "tank_level",   byte_order = "AB",   data_type = "INT16",   scale=1.0,     address = [0]},\n    { name = "tank_ph",      byte_order = "AB",   data_type = "INT16",   scale=1.0,     address = [1]},\n    { name = "pump1_speed",  byte_order = "ABCD", data_type = "INT32",   scale=1.0,     address = [3,4]},\n  ]\n\n\n  ## --- "request" configuration style ---\n\n  ## Per request definition\n  ##\n\n  ## Define a request sent to the device\n  ## Multiple of those requests can be defined. Data will be collated into metrics at the end of data collection.\n  [[inputs.modbus.request]]\n    ## ID of the modbus slave device to query.\n    ## If you need to query multiple slave-devices, create several "request" definitions.\n    slave_id = 1\n\n    ## Byte order of the data.\n    ##  |---ABCD -- Big Endian (Motorola)\n    ##  |---DCBA -- Little Endian (Intel)\n    ##  |---BADC -- Big Endian with byte swap\n    ##  |---CDAB -- Little Endian with byte swap\n    byte_order = "ABCD"\n\n    ## Type of the register for the request\n    ## Can be "coil", "discrete", "holding" or "input"\n    register = "coil"\n\n    ## Name of the measurement.\n    ## Can be overriden by the individual field definitions. Defaults to "modbus"\n    # measurement = "modbus"\n\n    ## Field definitions\n    ## Analog Variables, Input Registers and Holding Registers\n    ## address        - address of the register to query. For coil and discrete inputs this is the bit address.\n    ## name *1        - field name\n    ## type *1,2      - type of the modbus field, can be INT16, UINT16, INT32, UINT32, INT64, UINT64 and\n    ##                  FLOAT32, FLOAT64 (IEEE 754 binary representation)\n    ## scale *1,2     - (optional) factor to scale the variable with\n    ## output *1,2    - (optional) type of resulting field, can be INT64, UINT64 or FLOAT64. Defaults to FLOAT64 if\n    ##                  "scale" is provided and to the input "type" class otherwise (i.e. INT* -> INT64, etc).\n    ## measurement *1 - (optional) measurement name, defaults to the setting of the request\n    ## omit           - (optional) omit this field. Useful to leave out single values when querying many registers\n    ##                  with a single request. Defaults to "false".\n    ##\n    ## *1: Those fields are ignored if field is omitted ("omit"=true)\n    ##\n    ## *2: Thise fields are ignored for both "coil" and "discrete"-input type of registers. For those register types\n    ##     the fields are output as zero or one in UINT64 format by default.\n\n    ## Coil / discrete input example\n    fields = [\n      { address=0, name="motor1_run"},\n      { address=1, name="jog", measurement="motor"},\n      { address=2, name="motor1_stop", omit=true},\n      { address=3, name="motor1_overheating"},\n    ]\n\n    [[inputs.modbus.request.tags]]\n      machine = "impresser"\n      location = "main building"\n\n  [[inputs.modbus.request]]\n    ## Holding example\n    ## All of those examples will result in FLOAT64 field outputs\n    slave_id = 1\n    byte_order = "DCBA"\n    register = "holding"\n    fields = [\n      { address=0, name="voltage",      type="INT16",   scale=0.1   },\n      { address=1, name="current",      type="INT32",   scale=0.001 },\n      { address=3, name="power",        type="UINT32",  omit=true   },\n      { address=5, name="energy",       type="FLOAT32", scale=0.001, measurement="W" },\n      { address=7, name="frequency",    type="UINT32",  scale=0.1   },\n      { address=8, name="power_factor", type="INT64",   scale=0.01  },\n    ]\n\n    [[inputs.modbus.request.tags]]\n      machine = "impresser"\n      location = "main building"\n\n  [[inputs.modbus.request]]\n    ## Input example with type conversions\n    slave_id = 1\n    byte_order = "ABCD"\n    register = "input"\n    fields = [\n      { address=0, name="rpm",         type="INT16"                   },  # will result in INT64 field\n      { address=1, name="temperature", type="INT16", scale=0.1        },  # will result in FLOAT64 field\n      { address=2, name="force",       type="INT32", output="FLOAT64" },  # will result in FLOAT64 field\n      { address=4, name="hours",       type="UINT32"                  },  # will result in UIN64 field\n    ]\n\n    [[inputs.modbus.request.tags]]\n      machine = "impresser"\n      location = "main building"\n\n\n\n  ## Enable workarounds required by some devices to work correctly\n  # [inputs.modbus.workarounds]\n    ## Pause between read requests sent to the device. This might be necessary for (slow) serial devices.\n    # pause_between_requests = "0ms"\n    ## Close the connection after every gather cycle. Usually the plugin closes the connection after a certain\n    ## idle-timeout, however, if you query a device with limited simultaneous connectivity (e.g. serial devices)\n    ## from multiple instances you might want to only stay connected during gather and disconnect afterwards.\n    # close_connection_after_gather = false\n'}}]);