// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2/audio_config.proto

package dialogflow // import "google.golang.org/genproto/googleapis/cloud/dialogflow/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Gender of the voice as described in
// [SSML voice element](https://www.w3.org/TR/speech-synthesis11/#edef_voice).
type SsmlVoiceGender int32

const (
	// An unspecified gender, which means that the client doesn't care which
	// gender the selected voice will have.
	SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED SsmlVoiceGender = 0
	// A male voice.
	SsmlVoiceGender_SSML_VOICE_GENDER_MALE SsmlVoiceGender = 1
	// A female voice.
	SsmlVoiceGender_SSML_VOICE_GENDER_FEMALE SsmlVoiceGender = 2
	// A gender-neutral voice.
	SsmlVoiceGender_SSML_VOICE_GENDER_NEUTRAL SsmlVoiceGender = 3
)

var SsmlVoiceGender_name = map[int32]string{
	0: "SSML_VOICE_GENDER_UNSPECIFIED",
	1: "SSML_VOICE_GENDER_MALE",
	2: "SSML_VOICE_GENDER_FEMALE",
	3: "SSML_VOICE_GENDER_NEUTRAL",
}
var SsmlVoiceGender_value = map[string]int32{
	"SSML_VOICE_GENDER_UNSPECIFIED": 0,
	"SSML_VOICE_GENDER_MALE":        1,
	"SSML_VOICE_GENDER_FEMALE":      2,
	"SSML_VOICE_GENDER_NEUTRAL":     3,
}

func (x SsmlVoiceGender) String() string {
	return proto.EnumName(SsmlVoiceGender_name, int32(x))
}
func (SsmlVoiceGender) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_audio_config_10e5d4ebe984100d, []int{0}
}

// Audio encoding of the output audio format in Text-To-Speech.
type OutputAudioEncoding int32

const (
	// Not specified.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_UNSPECIFIED OutputAudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// Audio content returned as LINEAR16 also contains a WAV header.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_LINEAR_16 OutputAudioEncoding = 1
	// MP3 audio.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MP3 OutputAudioEncoding = 2
	// Opus encoded audio wrapped in an ogg container. The result will be a
	// file which can be played natively on Android, and in browsers (at least
	// Chrome and Firefox). The quality of the encoding is considerably higher
	// than MP3 while using approximately the same bitrate.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_OGG_OPUS OutputAudioEncoding = 3
)

var OutputAudioEncoding_name = map[int32]string{
	0: "OUTPUT_AUDIO_ENCODING_UNSPECIFIED",
	1: "OUTPUT_AUDIO_ENCODING_LINEAR_16",
	2: "OUTPUT_AUDIO_ENCODING_MP3",
	3: "OUTPUT_AUDIO_ENCODING_OGG_OPUS",
}
var OutputAudioEncoding_value = map[string]int32{
	"OUTPUT_AUDIO_ENCODING_UNSPECIFIED": 0,
	"OUTPUT_AUDIO_ENCODING_LINEAR_16":   1,
	"OUTPUT_AUDIO_ENCODING_MP3":         2,
	"OUTPUT_AUDIO_ENCODING_OGG_OPUS":    3,
}

func (x OutputAudioEncoding) String() string {
	return proto.EnumName(OutputAudioEncoding_name, int32(x))
}
func (OutputAudioEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_audio_config_10e5d4ebe984100d, []int{1}
}

// Description of which voice to use for speech synthesis.
type VoiceSelectionParams struct {
	// Optional. The name of the voice. If not set, the service will choose a
	// voice based on the other parameters such as language_code and gender.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The preferred gender of the voice. If not set, the service will
	// choose a voice based on the other parameters such as language_code and
	// name. Note that this is only a preference, not requirement. If a
	// voice of the appropriate gender is not available, the synthesizer should
	// substitute a voice with a different gender rather than failing the request.
	SsmlGender           SsmlVoiceGender `protobuf:"varint,2,opt,name=ssml_gender,json=ssmlGender,proto3,enum=google.cloud.dialogflow.v2.SsmlVoiceGender" json:"ssml_gender,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *VoiceSelectionParams) Reset()         { *m = VoiceSelectionParams{} }
func (m *VoiceSelectionParams) String() string { return proto.CompactTextString(m) }
func (*VoiceSelectionParams) ProtoMessage()    {}
func (*VoiceSelectionParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_audio_config_10e5d4ebe984100d, []int{0}
}
func (m *VoiceSelectionParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VoiceSelectionParams.Unmarshal(m, b)
}
func (m *VoiceSelectionParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VoiceSelectionParams.Marshal(b, m, deterministic)
}
func (dst *VoiceSelectionParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoiceSelectionParams.Merge(dst, src)
}
func (m *VoiceSelectionParams) XXX_Size() int {
	return xxx_messageInfo_VoiceSelectionParams.Size(m)
}
func (m *VoiceSelectionParams) XXX_DiscardUnknown() {
	xxx_messageInfo_VoiceSelectionParams.DiscardUnknown(m)
}

var xxx_messageInfo_VoiceSelectionParams proto.InternalMessageInfo

func (m *VoiceSelectionParams) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VoiceSelectionParams) GetSsmlGender() SsmlVoiceGender {
	if m != nil {
		return m.SsmlGender
	}
	return SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED
}

// Configuration of how speech should be synthesized.
type SynthesizeSpeechConfig struct {
	// Optional. Speaking rate/speed, in the range [0.25, 4.0]. 1.0 is the normal
	// native speed supported by the specific voice. 2.0 is twice as fast, and
	// 0.5 is half as fast. If unset(0.0), defaults to the native 1.0 speed. Any
	// other values < 0.25 or > 4.0 will return an error.
	SpeakingRate float64 `protobuf:"fixed64,1,opt,name=speaking_rate,json=speakingRate,proto3" json:"speaking_rate,omitempty"`
	// Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means increase 20
	// semitones from the original pitch. -20 means decrease 20 semitones from the
	// original pitch.
	Pitch float64 `protobuf:"fixed64,2,opt,name=pitch,proto3" json:"pitch,omitempty"`
	// Optional. Volume gain (in dB) of the normal native volume supported by the
	// specific voice, in the range [-96.0, 16.0]. If unset, or set to a value of
	// 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
	// will play at approximately half the amplitude of the normal native signal
	// amplitude. A value of +6.0 (dB) will play at approximately twice the
	// amplitude of the normal native signal amplitude. We strongly recommend not
	// to exceed +10 (dB) as there's usually no effective increase in loudness for
	// any value greater than that.
	VolumeGainDb float64 `protobuf:"fixed64,3,opt,name=volume_gain_db,json=volumeGainDb,proto3" json:"volume_gain_db,omitempty"`
	// Optional. An identifier which selects 'audio effects' profiles that are
	// applied on (post synthesized) text to speech. Effects are applied on top of
	// each other in the order they are given.
	EffectsProfileId []string `protobuf:"bytes,5,rep,name=effects_profile_id,json=effectsProfileId,proto3" json:"effects_profile_id,omitempty"`
	// Optional. The desired voice of the synthesized audio.
	Voice                *VoiceSelectionParams `protobuf:"bytes,4,opt,name=voice,proto3" json:"voice,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SynthesizeSpeechConfig) Reset()         { *m = SynthesizeSpeechConfig{} }
func (m *SynthesizeSpeechConfig) String() string { return proto.CompactTextString(m) }
func (*SynthesizeSpeechConfig) ProtoMessage()    {}
func (*SynthesizeSpeechConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_audio_config_10e5d4ebe984100d, []int{1}
}
func (m *SynthesizeSpeechConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SynthesizeSpeechConfig.Unmarshal(m, b)
}
func (m *SynthesizeSpeechConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SynthesizeSpeechConfig.Marshal(b, m, deterministic)
}
func (dst *SynthesizeSpeechConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SynthesizeSpeechConfig.Merge(dst, src)
}
func (m *SynthesizeSpeechConfig) XXX_Size() int {
	return xxx_messageInfo_SynthesizeSpeechConfig.Size(m)
}
func (m *SynthesizeSpeechConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SynthesizeSpeechConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SynthesizeSpeechConfig proto.InternalMessageInfo

func (m *SynthesizeSpeechConfig) GetSpeakingRate() float64 {
	if m != nil {
		return m.SpeakingRate
	}
	return 0
}

func (m *SynthesizeSpeechConfig) GetPitch() float64 {
	if m != nil {
		return m.Pitch
	}
	return 0
}

func (m *SynthesizeSpeechConfig) GetVolumeGainDb() float64 {
	if m != nil {
		return m.VolumeGainDb
	}
	return 0
}

func (m *SynthesizeSpeechConfig) GetEffectsProfileId() []string {
	if m != nil {
		return m.EffectsProfileId
	}
	return nil
}

func (m *SynthesizeSpeechConfig) GetVoice() *VoiceSelectionParams {
	if m != nil {
		return m.Voice
	}
	return nil
}

// Instructs the speech synthesizer how to generate the output audio content.
type OutputAudioConfig struct {
	// Required. Audio encoding of the synthesized audio content.
	AudioEncoding OutputAudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.dialogflow.v2.OutputAudioEncoding" json:"audio_encoding,omitempty"`
	// Optional. The synthesis sample rate (in hertz) for this audio. If not
	// provided, then the synthesizer will use the default sample rate based on
	// the audio encoding. If this is different from the voice's natural sample
	// rate, then the synthesizer will honor this request by converting to the
	// desired sample rate (which might result in worse audio quality).
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Optional. Configuration of how speech should be synthesized.
	SynthesizeSpeechConfig *SynthesizeSpeechConfig `protobuf:"bytes,3,opt,name=synthesize_speech_config,json=synthesizeSpeechConfig,proto3" json:"synthesize_speech_config,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}                `json:"-"`
	XXX_unrecognized       []byte                  `json:"-"`
	XXX_sizecache          int32                   `json:"-"`
}

func (m *OutputAudioConfig) Reset()         { *m = OutputAudioConfig{} }
func (m *OutputAudioConfig) String() string { return proto.CompactTextString(m) }
func (*OutputAudioConfig) ProtoMessage()    {}
func (*OutputAudioConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_audio_config_10e5d4ebe984100d, []int{2}
}
func (m *OutputAudioConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputAudioConfig.Unmarshal(m, b)
}
func (m *OutputAudioConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputAudioConfig.Marshal(b, m, deterministic)
}
func (dst *OutputAudioConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputAudioConfig.Merge(dst, src)
}
func (m *OutputAudioConfig) XXX_Size() int {
	return xxx_messageInfo_OutputAudioConfig.Size(m)
}
func (m *OutputAudioConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputAudioConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputAudioConfig proto.InternalMessageInfo

func (m *OutputAudioConfig) GetAudioEncoding() OutputAudioEncoding {
	if m != nil {
		return m.AudioEncoding
	}
	return OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_UNSPECIFIED
}

func (m *OutputAudioConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func (m *OutputAudioConfig) GetSynthesizeSpeechConfig() *SynthesizeSpeechConfig {
	if m != nil {
		return m.SynthesizeSpeechConfig
	}
	return nil
}

func init() {
	proto.RegisterType((*VoiceSelectionParams)(nil), "google.cloud.dialogflow.v2.VoiceSelectionParams")
	proto.RegisterType((*SynthesizeSpeechConfig)(nil), "google.cloud.dialogflow.v2.SynthesizeSpeechConfig")
	proto.RegisterType((*OutputAudioConfig)(nil), "google.cloud.dialogflow.v2.OutputAudioConfig")
	proto.RegisterEnum("google.cloud.dialogflow.v2.SsmlVoiceGender", SsmlVoiceGender_name, SsmlVoiceGender_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2.OutputAudioEncoding", OutputAudioEncoding_name, OutputAudioEncoding_value)
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2/audio_config.proto", fileDescriptor_audio_config_10e5d4ebe984100d)
}

var fileDescriptor_audio_config_10e5d4ebe984100d = []byte{
	// 635 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x54, 0xcf, 0x6f, 0xd3, 0x3e,
	0x1c, 0xfd, 0xba, 0x5d, 0xbf, 0xd2, 0x3c, 0xd6, 0x65, 0x66, 0x9a, 0x4a, 0xb5, 0x8d, 0xae, 0x03,
	0xa9, 0x1a, 0xd0, 0x40, 0x26, 0x71, 0xe1, 0xd4, 0x35, 0x69, 0x89, 0xd4, 0x35, 0x51, 0xb2, 0xf6,
	0xc0, 0xc5, 0xf2, 0x12, 0x37, 0xb5, 0x48, 0xec, 0x28, 0x49, 0x0b, 0xec, 0xce, 0x91, 0xbf, 0x01,
	0x09, 0x71, 0xe2, 0x9f, 0xe3, 0xca, 0x11, 0xc5, 0x29, 0x6c, 0xda, 0x42, 0x6f, 0xf1, 0xe7, 0xbd,
	0xcf, 0xaf, 0xf7, 0xec, 0xc0, 0x17, 0x81, 0x10, 0x41, 0x48, 0x55, 0x2f, 0x14, 0x0b, 0x5f, 0xf5,
	0x19, 0x09, 0x45, 0x30, 0x0b, 0xc5, 0x07, 0x75, 0xa9, 0xa9, 0x64, 0xe1, 0x33, 0x81, 0x3d, 0xc1,
	0x67, 0x2c, 0xe8, 0xc6, 0x89, 0xc8, 0x04, 0x6a, 0x16, 0xf4, 0xae, 0xa4, 0x77, 0x6f, 0xe8, 0xdd,
	0xa5, 0xd6, 0x3c, 0x58, 0x95, 0x22, 0x31, 0x53, 0x09, 0xe7, 0x22, 0x23, 0x19, 0x13, 0x3c, 0x2d,
	0x32, 0xdb, 0x1f, 0xe1, 0xde, 0x54, 0x30, 0x8f, 0xba, 0x34, 0xa4, 0x5e, 0x0e, 0xd8, 0x24, 0x21,
	0x51, 0x8a, 0x10, 0xdc, 0xe0, 0x24, 0xa2, 0x0d, 0xd0, 0x02, 0x9d, 0x4d, 0x47, 0x7e, 0xa3, 0x11,
	0xdc, 0x4a, 0xd3, 0x28, 0xc4, 0x01, 0xe5, 0x3e, 0x4d, 0x1a, 0x95, 0x16, 0xe8, 0xd4, 0xb5, 0x67,
	0xdd, 0x7f, 0xf7, 0xee, 0xba, 0x69, 0x14, 0xca, 0xf2, 0x43, 0x99, 0xe2, 0xc0, 0x3c, 0xbf, 0xf8,
	0x6e, 0xff, 0x04, 0x70, 0xdf, 0xfd, 0xc4, 0xb3, 0x39, 0x4d, 0xd9, 0x35, 0x75, 0x63, 0x4a, 0xbd,
	0x79, 0x5f, 0x2e, 0x85, 0x4e, 0xe0, 0x76, 0x1a, 0x53, 0xf2, 0x9e, 0xf1, 0x00, 0x27, 0x24, 0x2b,
	0xa6, 0x00, 0xce, 0x83, 0x3f, 0x41, 0x87, 0x64, 0x14, 0xed, 0xc1, 0x5a, 0xcc, 0x32, 0x6f, 0x2e,
	0xe7, 0x00, 0x4e, 0x71, 0x40, 0x4f, 0x60, 0x7d, 0x29, 0xc2, 0x45, 0x44, 0x71, 0x40, 0x18, 0xc7,
	0xfe, 0x55, 0xa3, 0x5a, 0xe4, 0x16, 0xd1, 0x21, 0x61, 0x5c, 0xbf, 0x42, 0xcf, 0x21, 0xa2, 0xb3,
	0x19, 0xf5, 0xb2, 0x14, 0xc7, 0x89, 0x98, 0xb1, 0x90, 0x62, 0xe6, 0x37, 0x6a, 0xad, 0x6a, 0x67,
	0xd3, 0x51, 0x56, 0x88, 0x5d, 0x00, 0xa6, 0x8f, 0x06, 0xb0, 0xb6, 0xcc, 0x97, 0x68, 0x6c, 0xb4,
	0x40, 0x67, 0x4b, 0x7b, 0xb9, 0x6e, 0xe3, 0x32, 0x31, 0x9d, 0x22, 0xbd, 0xfd, 0xb9, 0x02, 0x77,
	0xad, 0x45, 0x16, 0x2f, 0xb2, 0x5e, 0x6e, 0xe1, 0x6a, 0xd9, 0x29, 0xac, 0x17, 0x8e, 0x52, 0xee,
	0x09, 0x9f, 0xf1, 0x40, 0x6e, 0x5b, 0xd7, 0xd4, 0x75, 0x6d, 0x6e, 0x95, 0x31, 0x56, 0x69, 0xce,
	0x36, 0xb9, 0x7d, 0x44, 0xa7, 0x70, 0x37, 0x25, 0x51, 0x1c, 0x52, 0x29, 0x21, 0x9e, 0xd3, 0x24,
	0xbb, 0x96, 0x5a, 0xd5, 0x9c, 0x9d, 0x02, 0xc8, 0x65, 0x7c, 0x9b, 0x87, 0x51, 0x08, 0x1b, 0xe9,
	0x5f, 0x2b, 0x70, 0x2a, 0xbd, 0x58, 0xdd, 0x30, 0xa9, 0xdf, 0x96, 0xa6, 0xad, 0xb5, 0xb9, 0xd4,
	0x46, 0x67, 0x3f, 0x2d, 0x8d, 0x9f, 0x7e, 0x01, 0x70, 0xe7, 0xce, 0xcd, 0x40, 0xc7, 0xf0, 0xd0,
	0x75, 0x2f, 0x46, 0x78, 0x6a, 0x99, 0x7d, 0x03, 0x0f, 0x8d, 0xb1, 0x6e, 0x38, 0x78, 0x32, 0x76,
	0x6d, 0xa3, 0x6f, 0x0e, 0x4c, 0x43, 0x57, 0xfe, 0x43, 0x4d, 0xb8, 0x7f, 0x9f, 0x72, 0xd1, 0x1b,
	0x19, 0x0a, 0x40, 0x07, 0xb0, 0x71, 0x1f, 0x1b, 0x18, 0x12, 0xad, 0xa0, 0x43, 0xf8, 0xe8, 0x3e,
	0x3a, 0x36, 0x26, 0x97, 0x4e, 0x6f, 0xa4, 0x54, 0x4f, 0xbf, 0x03, 0xf8, 0xb0, 0x44, 0x50, 0xf4,
	0x14, 0x1e, 0x5b, 0x93, 0x4b, 0x7b, 0x72, 0x89, 0x7b, 0x13, 0xdd, 0xb4, 0xb0, 0x31, 0xee, 0x5b,
	0xba, 0x39, 0x1e, 0xde, 0x99, 0xeb, 0x04, 0x3e, 0x2e, 0xa7, 0x8d, 0xcc, 0xb1, 0xd1, 0x73, 0xf0,
	0xab, 0xd7, 0x0a, 0xc8, 0x47, 0x28, 0x27, 0x5d, 0xd8, 0x67, 0x4a, 0x05, 0xb5, 0xe1, 0x51, 0x39,
	0x6c, 0x0d, 0x87, 0xd8, 0xb2, 0x27, 0xae, 0x52, 0x3d, 0xff, 0x0a, 0xe0, 0x91, 0x27, 0xa2, 0x35,
	0x46, 0x9c, 0x2b, 0xb7, 0x2e, 0x96, 0x9d, 0xbf, 0x6f, 0x1b, 0xbc, 0xd3, 0x57, 0xfc, 0x40, 0x84,
	0x84, 0x07, 0x5d, 0x91, 0x04, 0x6a, 0x40, 0xb9, 0x7c, 0xfd, 0x6a, 0x01, 0x91, 0x98, 0xa5, 0x65,
	0x7f, 0x9a, 0x37, 0x37, 0xa7, 0x5f, 0x00, 0x7c, 0xab, 0x54, 0xf4, 0xc1, 0x8f, 0x4a, 0x73, 0x58,
	0x94, 0xeb, 0xcb, 0xf6, 0xfa, 0x4d, 0xfb, 0xa9, 0x76, 0xf5, 0xbf, 0xac, 0x7a, 0xf6, 0x3b, 0x00,
	0x00, 0xff, 0xff, 0x00, 0x0b, 0x69, 0x1b, 0xbe, 0x04, 0x00, 0x00,
}
