/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsICancelable;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.internal.mozilla.nsIWebProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class Download_1_8 {
    XPCOMObject supports;
    XPCOMObject download;
    XPCOMObject progressDialog;
    XPCOMObject webProgressListener;
    nsICancelable cancelable;
    int refCount = 0;
    Shell shell;
    Label status;
    Button cancel;
    static final boolean is32 = C.PTR_SIZEOF == 4;

    Download_1_8() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            @Override
            public int method0(int[] args) {
                return Download_1_8.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public int method1(int[] args) {
                return Download_1_8.this.AddRef();
            }

            @Override
            public int method2(int[] args) {
                return Download_1_8.this.Release();
            }
        };
        this.download = new XPCOMObject(new int[]{2, 0, 0, 4, 6, 3, 4, 3, is32 ? 10 : 6, is32 ? 8 : 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}){

            @Override
            public int method0(int[] args) {
                return Download_1_8.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public int method1(int[] args) {
                return Download_1_8.this.AddRef();
            }

            @Override
            public int method2(int[] args) {
                return Download_1_8.this.Release();
            }

            @Override
            public int method3(int[] args) {
                return Download_1_8.this.OnStateChange(args[0], args[1], args[2], args[3]);
            }

            @Override
            public int method4(int[] args) {
                return Download_1_8.this.OnProgressChange(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            @Override
            public int method5(int[] args) {
                return Download_1_8.this.OnLocationChange(args[0], args[1], args[2]);
            }

            @Override
            public int method6(int[] args) {
                return Download_1_8.this.OnStatusChange(args[0], args[1], args[2], args[3]);
            }

            @Override
            public int method7(int[] args) {
                return Download_1_8.this.OnSecurityChange(args[0], args[1], args[2]);
            }

            @Override
            public int method8(int[] args) {
                if (args.length == 10) {
                    return Download_1_8.this.OnProgressChange64_32(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
                }
                return Download_1_8.this.OnProgressChange64(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            @Override
            public int method9(int[] args) {
                if (args.length == 8) {
                    return Download_1_8.this.Init_32(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
                }
                return Download_1_8.this.Init(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            @Override
            public int method10(int[] args) {
                return Download_1_8.this.GetTargetFile(args[0]);
            }

            @Override
            public int method11(int[] args) {
                return Download_1_8.this.GetPercentComplete(args[0]);
            }

            @Override
            public int method12(int[] args) {
                return Download_1_8.this.GetAmountTransferred(args[0]);
            }

            @Override
            public int method13(int[] args) {
                return Download_1_8.this.GetSize(args[0]);
            }

            @Override
            public int method14(int[] args) {
                return Download_1_8.this.GetSource(args[0]);
            }

            @Override
            public int method15(int[] args) {
                return Download_1_8.this.GetTarget(args[0]);
            }

            @Override
            public int method16(int[] args) {
                return Download_1_8.this.GetCancelable(args[0]);
            }

            @Override
            public int method17(int[] args) {
                return Download_1_8.this.GetDisplayName(args[0]);
            }

            @Override
            public int method18(int[] args) {
                return Download_1_8.this.GetStartTime(args[0]);
            }

            @Override
            public int method19(int[] args) {
                return Download_1_8.this.GetMIMEInfo(args[0]);
            }
        };
        this.progressDialog = new XPCOMObject(new int[]{2, 0, 0, 4, 6, 3, 4, 3, is32 ? 10 : 6, is32 ? 8 : 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}){

            @Override
            public int method0(int[] args) {
                return Download_1_8.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public int method1(int[] args) {
                return Download_1_8.this.AddRef();
            }

            @Override
            public int method2(int[] args) {
                return Download_1_8.this.Release();
            }

            @Override
            public int method3(int[] args) {
                return Download_1_8.this.OnStateChange(args[0], args[1], args[2], args[3]);
            }

            @Override
            public int method4(int[] args) {
                return Download_1_8.this.OnProgressChange(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            @Override
            public int method5(int[] args) {
                return Download_1_8.this.OnLocationChange(args[0], args[1], args[2]);
            }

            @Override
            public int method6(int[] args) {
                return Download_1_8.this.OnStatusChange(args[0], args[1], args[2], args[3]);
            }

            @Override
            public int method7(int[] args) {
                return Download_1_8.this.OnSecurityChange(args[0], args[1], args[2]);
            }

            @Override
            public int method8(int[] args) {
                if (args.length == 10) {
                    return Download_1_8.this.OnProgressChange64_32(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
                }
                return Download_1_8.this.OnProgressChange64(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            @Override
            public int method9(int[] args) {
                if (args.length == 8) {
                    return Download_1_8.this.Init_32(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
                }
                return Download_1_8.this.Init(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            @Override
            public int method10(int[] args) {
                return Download_1_8.this.GetTargetFile(args[0]);
            }

            @Override
            public int method11(int[] args) {
                return Download_1_8.this.GetPercentComplete(args[0]);
            }

            @Override
            public int method12(int[] args) {
                return Download_1_8.this.GetAmountTransferred(args[0]);
            }

            @Override
            public int method13(int[] args) {
                return Download_1_8.this.GetSize(args[0]);
            }

            @Override
            public int method14(int[] args) {
                return Download_1_8.this.GetSource(args[0]);
            }

            @Override
            public int method15(int[] args) {
                return Download_1_8.this.GetTarget(args[0]);
            }

            @Override
            public int method16(int[] args) {
                return Download_1_8.this.GetCancelable(args[0]);
            }

            @Override
            public int method17(int[] args) {
                return Download_1_8.this.GetDisplayName(args[0]);
            }

            @Override
            public int method18(int[] args) {
                return Download_1_8.this.GetStartTime(args[0]);
            }

            @Override
            public int method19(int[] args) {
                return Download_1_8.this.GetMIMEInfo(args[0]);
            }

            @Override
            public int method20(int[] args) {
                return Download_1_8.this.Open(args[0]);
            }

            @Override
            public int method21(int[] args) {
                return Download_1_8.this.GetCancelDownloadOnClose(args[0]);
            }

            @Override
            public int method22(int[] args) {
                return Download_1_8.this.SetCancelDownloadOnClose(args[0]);
            }

            @Override
            public int method23(int[] args) {
                return Download_1_8.this.GetObserver(args[0]);
            }

            @Override
            public int method24(int[] args) {
                return Download_1_8.this.SetObserver(args[0]);
            }

            @Override
            public int method25(int[] args) {
                return Download_1_8.this.GetDialog(args[0]);
            }

            @Override
            public int method26(int[] args) {
                return Download_1_8.this.SetDialog(args[0]);
            }
        };
        this.webProgressListener = new XPCOMObject(new int[]{2, 0, 0, 4, 6, 3, 4, 3}){

            @Override
            public int method0(int[] args) {
                return Download_1_8.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public int method1(int[] args) {
                return Download_1_8.this.AddRef();
            }

            @Override
            public int method2(int[] args) {
                return Download_1_8.this.Release();
            }

            @Override
            public int method3(int[] args) {
                return Download_1_8.this.OnStateChange(args[0], args[1], args[2], args[3]);
            }

            @Override
            public int method4(int[] args) {
                return Download_1_8.this.OnProgressChange(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            @Override
            public int method5(int[] args) {
                return Download_1_8.this.OnLocationChange(args[0], args[1], args[2]);
            }

            @Override
            public int method6(int[] args) {
                return Download_1_8.this.OnStatusChange(args[0], args[1], args[2], args[3]);
            }

            @Override
            public int method7(int[] args) {
                return Download_1_8.this.OnSecurityChange(args[0], args[1], args[2]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.download != null) {
            this.download.dispose();
            this.download = null;
        }
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
            this.progressDialog = null;
        }
        if (this.webProgressListener != null) {
            this.webProgressListener.dispose();
            this.webProgressListener = null;
        }
    }

    int getAddress() {
        return this.progressDialog.getAddress();
    }

    int QueryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(XPCOM.NS_IDOWNLOAD_1_8_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.download.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(XPCOM.NS_IPROGRESSDIALOG_1_8_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.progressDialog.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(IIDStore.GetIID(nsIWebProgressListener.class))) {
            XPCOM.memmove(ppvObject, new int[]{this.webProgressListener.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(ppvObject, new int[]{0}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int Init_32(int aSource, int aTarget, int aDisplayName, int aMIMEInfo, int startTime1, int startTime2, int aTempFile, int aCancelable) {
        long startTime = (startTime2 << 32) + startTime1;
        return this.Init(aSource, aTarget, aDisplayName, aMIMEInfo, startTime, aTempFile, aCancelable);
    }

    int Init(int aSource, int aTarget, int aDisplayName, int aMIMEInfo, long startTime, int aTempFile, int aCancelable) {
        this.cancelable = new nsICancelable(aCancelable);
        nsIURI source = new nsIURI(aSource);
        int aSpec = XPCOM.nsEmbedCString_new();
        int rc = source.GetHost(aSpec);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        int length = XPCOM.nsEmbedCString_Length(aSpec);
        int buffer = XPCOM.nsEmbedCString_get(aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aSpec);
        String url = new String(dest);
        nsIURI target = new nsIURI(aTarget);
        int aPath = XPCOM.nsEmbedCString_new();
        rc = target.GetPath(aPath);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        length = XPCOM.nsEmbedCString_Length(aPath);
        buffer = XPCOM.nsEmbedCString_get(aPath);
        dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aPath);
        String filename = new String(dest);
        int separator = filename.lastIndexOf(System.getProperty("file.separator"));
        filename = filename.substring(separator + 1);
        Listener listener = event -> {
            int rc1;
            if (event.widget == this.cancel) {
                this.shell.close();
            }
            if (this.cancelable != null && (rc1 = this.cancelable.Cancel(-2142568446)) != 0) {
                Mozilla.error(rc1);
            }
            this.shell = null;
            this.cancelable = null;
        };
        this.shell = new Shell(2144);
        String msg = Compatibility.getMessage("SWT_Download_File", new Object[]{filename});
        this.shell.setText(msg);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        this.shell.setLayout(gridLayout);
        msg = Compatibility.getMessage("SWT_Download_Location", new Object[]{filename, url});
        new Label(this.shell, 64).setText(msg);
        this.status = new Label(this.shell, 64);
        msg = Compatibility.getMessage("SWT_Download_Started");
        this.status.setText(msg);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.status.setLayoutData(data);
        this.cancel = new Button(this.shell, 8);
        this.cancel.setText(SWT.getMessage("SWT_Cancel"));
        data = new GridData();
        data.horizontalAlignment = 2;
        this.cancel.setLayoutData(data);
        this.cancel.addListener(13, listener);
        this.shell.addListener(21, listener);
        this.shell.pack();
        this.shell.open();
        return 0;
    }

    int GetAmountTransferred(int arg0) {
        return -2147467263;
    }

    int GetCancelable(int arg0) {
        return -2147467263;
    }

    int GetDisplayName(int aDisplayName) {
        return -2147467263;
    }

    int GetMIMEInfo(int aMIMEInfo) {
        return -2147467263;
    }

    int GetPercentComplete(int aPercentComplete) {
        return -2147467263;
    }

    int GetSize(int arg0) {
        return -2147467263;
    }

    int GetSource(int aSource) {
        return -2147467263;
    }

    int GetStartTime(int aStartTime) {
        return -2147467263;
    }

    int GetTarget(int aTarget) {
        return -2147467263;
    }

    int GetTargetFile(int arg0) {
        return -2147467263;
    }

    int GetCancelDownloadOnClose(int aCancelDownloadOnClose) {
        return -2147467263;
    }

    int GetDialog(int aDialog) {
        return -2147467263;
    }

    int GetObserver(int aObserver) {
        return -2147467263;
    }

    int Open(int aParent) {
        return -2147467263;
    }

    int SetCancelDownloadOnClose(int aCancelDownloadOnClose) {
        return -2147467263;
    }

    int SetDialog(int aDialog) {
        return -2147467263;
    }

    int SetObserver(int aObserver) {
        return -2147467263;
    }

    int OnLocationChange(int aWebProgress, int aRequest, int aLocation) {
        return 0;
    }

    int OnProgressChange(int aWebProgress, int aRequest, int aCurSelfProgress, int aMaxSelfProgress, int aCurTotalProgress, int aMaxTotalProgress) {
        return this.OnProgressChange64(aWebProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress);
    }

    int OnProgressChange64_32(int aWebProgress, int aRequest, int aCurSelfProgress1, int aCurSelfProgress2, int aMaxSelfProgress1, int aMaxSelfProgress2, int aCurTotalProgress1, int aCurTotalProgress2, int aMaxTotalProgress1, int aMaxTotalProgress2) {
        long aCurSelfProgress = (aCurSelfProgress2 << 32) + aCurSelfProgress1;
        long aMaxSelfProgress = (aMaxSelfProgress2 << 32) + aMaxSelfProgress1;
        long aCurTotalProgress = (aCurTotalProgress2 << 32) + aCurTotalProgress1;
        long aMaxTotalProgress = (aMaxTotalProgress2 << 32) + aMaxTotalProgress1;
        return this.OnProgressChange64(aWebProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress);
    }

    int OnProgressChange64(int aWebProgress, int aRequest, long aCurSelfProgress, long aMaxSelfProgress, long aCurTotalProgress, long aMaxTotalProgress) {
        long currentKBytes = aCurTotalProgress / 1024L;
        long totalKBytes = aMaxTotalProgress / 1024L;
        if (this.shell != null && !this.shell.isDisposed()) {
            Object[] arguments = new Object[]{new Long(currentKBytes), new Long(totalKBytes)};
            String statusMsg = Compatibility.getMessage("SWT_Download_Status", arguments);
            this.status.setText(statusMsg);
            this.shell.layout(true);
            this.shell.getDisplay().update();
        }
        return 0;
    }

    int OnSecurityChange(int aWebProgress, int aRequest, int state) {
        return 0;
    }

    int OnStateChange(int aWebProgress, int aRequest, int aStateFlags, int aStatus) {
        if ((aStateFlags & 0x10) != 0) {
            this.cancelable = null;
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.dispose();
            }
            this.shell = null;
        }
        return 0;
    }

    int OnStatusChange(int aWebProgress, int aRequest, int aStatus, int aMessage) {
        return 0;
    }
}

