/***************************************************************************
 *                                                                         *
 *   aminom.cpp  (begin: Feb 20 2003)                                      *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "aminom.h"
#include "constant.h"
#include "dayhoff.h"
#include "jttm.h"
#include "vt.h"
#include "mtrev24.h"
#include "blosum62.h"
#include "wag.h"
#include "rtrev.h"
#include "ali.h"
#include "model.h"
#include "aminocustom.h"

AminoM::AminoM () {}

/**
	initialize
*/
void AminoM::init () {
	switch (modelType_) {
	case JTT:
		JTTM jttM_;
		jttM_.getData (unitRateMat_, stateFrqArr_);
		break;

	case Dayhoff:
		DayhoffM dayhoffM_;
		dayhoffM_.getData (unitRateMat_, stateFrqArr_);
		break;

	case VT:
		VTM vtM_;
		vtM_.getData (unitRateMat_, stateFrqArr_);
		break;

	case MtREV24:
		MtREV24M mtREV24M_;
		mtREV24M_.getData (unitRateMat_, stateFrqArr_);
		break;

	case rtREV:
		RtREV rtREVM_;
		rtREVM_.getData (unitRateMat_, stateFrqArr_);
		break;

	case Blosum62:
		Blosum62M blosum62M_;
		blosum62M_.getData (unitRateMat_, stateFrqArr_);
		break;

	case AA_USER:
		AminoCustom amino_custom;
		amino_custom.getData ((char*)(mymodel.rate_file.c_str()), unitRateMat_, stateFrqArr_);
		break;

	default:
		WAGM wagM_;
		wagM_.getData (unitRateMat_, stateFrqArr_);
	}

	for (int count0_ = 0; count0_ < NUM_AMINO; count0_ ++) {
		for (int count1_ = count0_ + 1; count1_ < NUM_AMINO; count1_ ++)
			unitRateMat_[count1_][count0_] = unitRateMat_[count0_][count1_];
		unitRateMat_[count0_][count0_] = 0.0;
	}
	if (mymodel.getBaseFrqType () == ESTIMATE) {
		if (isMasterProc())
			std::cout << "Estimating the amino acid frequecies from the data set..." << endl;
		alignment.estimateStateFrq (stateFrqArr_);
	}
	convfreq (stateFrqArr_);
	
	
	tranprobmat (NUM_AMINO);
}

/* make all frequencies a little different */
void AminoM::convfreq(DVec20 &freqemp) {
	int i, j, maxi=0;
	double freq, maxfreq, sum;

	sum = 0.0;
	maxfreq = 0.0;
	for (i = 0; i < NUM_AMINO; i++) {
		freq = freqemp[i];
		if (freq < MIN_FRQ) freqemp[i] = MIN_FRQ;
		if (freq > maxfreq) {
			maxfreq = freq;
			maxi = i;
		}

		sum += freqemp[i];
	}
	freqemp[maxi] += 1.0 - sum;

	for (i = 0; i < NUM_AMINO - 1; i++) {
		for (j = i + 1; j < NUM_AMINO; j++) {
			if (freqemp[i] == freqemp[j]) {
				freqemp[i] += MIN_FRQ_DIF/2.0;
				freqemp[j] -= MIN_FRQ_DIF/2.0;
			}
		}
	}
} /* convfreq */


AminoM::~AminoM () {}


