/***************************************************************************
 *                                                                         *
 *   cluster.cpp    (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cluster.h"
#include "ali.h"

Cluster::Cluster () {
	totalSeqNo_ = 0;
	nObj_ = 0;
	brLen_  = -1.0;
	id_ = -1;
	nSup_ = 1;
}

void Cluster::add (Vec<int> &exNdNoLs, double brLen) {
	int nSeq_ = alignment.getNSeq ();
	int* markArr_ = new int[nSeq_];
	int seqNo_;
	for (seqNo_ = 0; seqNo_ < nSeq_; seqNo_ ++)
		markArr_[seqNo_] = 0;

	for (int count_ = 0; count_ < exNdNoLs.getSize (); count_ ++)
		markArr_[ exNdNoLs[count_] ] = 1;

	seqNoArr_.set (nSeq_, 0);
	nObj_ = 0;
	totalSeqNo_ = 0;
	for (seqNo_ = 0; seqNo_ < nSeq_; seqNo_ ++)
		if (markArr_[seqNo_] == markArr_[0]) {
			totalSeqNo_ += seqNo_;
			seqNoArr_ += seqNo_;
			nObj_ ++;
		}
	brLen_ = brLen;
	delete markArr_;
}

int Cluster::operator == (Cluster &cluster2) {
	if (cluster2.nObj_ != nObj_  || cluster2.totalSeqNo_ != totalSeqNo_)
		return 0;
	for (int count_ = 0; count_ < nObj_; count_ ++)
		if (seqNoArr_[count_] != cluster2.seqNoArr_[count_])
			return 0;
	return 1;
}

int Cluster::operator [] (int index) {
	return seqNoArr_[index];
}

void Cluster::setId (int id) {
	id_ = id;
}

Cluster::~Cluster () {}
