/***************************************************************************
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "codongtr.h"
#include <assert.h>
#include "opturtree.h"


CodonGTR::CodonGTR() : CodonYN98() 
{
	//tvGT_ = 0.1;
}

/**
		calculate the rate parameters (not rate matrix)
*/
void CodonGTR::calcRateParameters() {

	/*
	double sumGenPam_ = tsAG_ + tsCT_ + tvAC_ + tvAT_ + tvCG_ + tvGT_;
	tsAG_ /=  sumGenPam_;
	tsCT_ /=  sumGenPam_;
	tvAC_ /=  sumGenPam_;
	tvAT_ /=  sumGenPam_;
	tvCG_ /=  sumGenPam_;
	tvGT_ /=  sumGenPam_;
	*/
	
	for (int i = 0; i < NUM_CODON; i++)
		for (int j = i+1; j < NUM_CODON; j++) {
			if (codon_trans[i][j].source == 0) { // more than 2 different codon positions
				continue;
			}
			//unitRateMat_[i][j]
			double rate_val = 0.0;
			switch (codon_trans[i][j].source) {
			case 'T':
				switch (codon_trans[i][j].dest) {
					case 'C': rate_val = tsCT_; break;
					case 'A':rate_val = tvAT_; break;
					case 'G': rate_val = tvGT_; break;
				}
				break;
			case 'C':
				switch (codon_trans[i][j].dest) {
					case 'T': rate_val = tsCT_; break;
					case 'A': rate_val = tvAC_; break;
					case 'G': rate_val = tvCG_; break;
				}
				break;
			case 'A':
				switch (codon_trans[i][j].dest) {
					case 'T': rate_val = tvAT_; break;
					case 'C': rate_val = tvAC_; break;
					case 'G': rate_val = tsAG_; break;
				}
				break;
			case 'G':
				switch (codon_trans[i][j].dest) {
					case 'T': rate_val = tvGT_; break;
					case 'C': rate_val = tvCG_; break;
					case 'A': rate_val = tsAG_; break;
				}
				break;
			}
			
			if (!codon_trans[i][j].is_synonymous)
				rate_val *= nsSyRatio;
				
			unitRateMat_[i][j] = rate_val;
			unitRateMat_[j][i] = rate_val;
		}
}

double CodonGTR::cmpNegLogLi (double value) {
	if (isActPam_ == TS_AG)
		tsAG_ = value;
	else if (isActPam_ == TS_CT)
		tsCT_ = value;
	else if (isActPam_ == TV_AC)
		tvAC_ = value;
	else if (isActPam_ == TV_AT)
		tvAT_ = value;
	else if (isActPam_ == TV_CG)
		tvCG_ = value;
	else if (isActPam_ == NS_SY_RATIO)
		nsSyRatio = value;

	reInit ();

	opt_urtree.cmpLiNd ();
	//opt_urtree.opt (MAX_IT_UR_BR_PAM_OPT);
	double logLi_ = opt_urtree.getLogLi ();
	return -logLi_;
}


bool CodonGTR::optPam () {
	double fx_, error_;
	double oriTsAG_ = tsAG_;
	double oriTsCT_ = tsCT_;
	double oriTvAC_ = tvAC_;
	double oriTvAT_ = tvAT_;
	double oriTvCG_ = tvCG_;
	//double oriTvGT_ = tvGT_;
	double oriNsSyRatio = nsSyRatio;

	//  double logLi_ = opt_urtree.getLogLi ();
	if (isMasterProc())
		std::cout <<"Optimizing GTR codon-based model parameters ..." << endl;
	Brent::turnOnOptedPam ();
	double logLi_ = opt_urtree.cmpLogLi ();
	//  std::cout <<"Log likelihood: " << logLi_ << endl;


	isActPam_ = TV_AC;
	if (isMasterProc())
		std::cout <<"   1. Optimizing transversion rate from A to C ..." << endl;
	tvAC_= optOneDim (MIN_GEN_PAM, tvAC_, MAX_GEN_PAM,
	                  EPS_MODEL_PAM_ERROR, &fx_, &error_);
	reInit ();

	//------------------------------/------------------------------/------------------------------/------------------------------/------------------------------/------------------------------
	isActPam_ = TS_AG;
	if (isMasterProc())
		std::cout <<"   2. Optimizing transition   rate from A to G ..." << endl;
	tsAG_= optOneDim (MIN_GEN_PAM, tsAG_, MAX_GEN_PAM,
	                  EPS_MODEL_PAM_ERROR, &fx_, &error_);
	reInit ();

	//------------------------------/------------------------------/------------------------------/------------------------------/------------------------------/------------------------------
	isActPam_ = TV_AT;
	if (isMasterProc())
		std::cout <<"   3. Optimizing transversion rate from A to T ..." << endl;
	tvAT_= optOneDim (MIN_GEN_PAM, tvAT_, MAX_GEN_PAM,
	                  EPS_MODEL_PAM_ERROR, &fx_, &error_);
	reInit ();

	//------------------------------/------------------------------/------------------------------/------------------------------/------------------------------/------------------------------
	isActPam_ = TV_CG;
	if (isMasterProc())
		std::cout <<"   4. Optimizing transversion rate from C to G ..." << endl;
	tvCG_= optOneDim (MIN_GEN_PAM, tvCG_, MAX_GEN_PAM,
	                  EPS_MODEL_PAM_ERROR, &fx_, &error_);
	reInit ();

	//------------------------------/------------------------------/------------------------------/------------------------------/------------------------------/------------------------------

	isActPam_ = TS_CT;

	if (isMasterProc())
		std::cout <<"   5. Optimizing transition   rate from C to T ..." << endl;
	tsCT_= optOneDim (MIN_GEN_PAM, tsCT_, MAX_GEN_PAM,
	                  EPS_MODEL_PAM_ERROR, &fx_, &error_);

	reInit ();


	//      logLi_ = opt_urtree.cmpLogLi ();
	//     std::cout <<"Log likelihood: " << logLi_ << endl;
	//------------------------------/------------------------------/

	if (true) {
		isActPam_ = NS_SY_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing nonsynonymous/synonymous ratio..." << endl;
		nsSyRatio = Brent::optOneDim (MIN_NS_SY_RATIO, nsSyRatio, MAX_NS_SY_RATIO,
		                           EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();

	}




	opt_urtree.cmpLiNd ();
	logLi_ = opt_urtree.getLogLi ();

	std::cout.precision (10);
	//  std::cout << "Log likelihood: " << logLi_ << endl;

	if (isMasterProc()) {

		std::cout.precision (5);
		std::cout <<
		"    1. Transversion rate from A to C =  " << tvAC_ << endl <<
		"    2. Transition   rate from A to G =  " << tsAG_ << endl <<
		"    3. Transversion rate from A to T =  " << tvAT_ << endl <<
		"    4. Transversion rate from C to G =  " << tvCG_ << endl <<
		"    5. Transition   rate from C to T =  " << tsCT_ << endl <<
		"    6. Transversion rate from G to T =  " << tvGT_ << endl;
		std::cout << "Nonsynonymous/synonymous ratio =  " << nsSyRatio << endl;
	}

	Brent::turnOffOptedPam ();
	return ( fabs (tsAG_ - oriTsAG_) > EPS_MODEL_PAM_ERROR ||
	         fabs (tsCT_ - oriTsCT_) > EPS_MODEL_PAM_ERROR ||
	         fabs (tvAC_ - oriTvAC_) > EPS_MODEL_PAM_ERROR ||
	         fabs (tvAT_ - oriTvAT_) > EPS_MODEL_PAM_ERROR ||
	         fabs (tvCG_ - oriTvCG_) > EPS_MODEL_PAM_ERROR ||
	         //fabs (tvGT_ - oriTvGT_) > EPS_MODEL_PAM_ERROR ||
	         fabs (nsSyRatio - oriNsSyRatio) > EPS_MODEL_PAM_ERROR );
}


CodonGTR::~CodonGTR()
{
}


