/***************************************************************************
 *                                                                         *
 *   exnd.cpp       (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <iostream>
#include <stdlib.h>
#include "exnd.h"

using namespace std;


//constructor function for all intializing before using object
ExNd::ExNd () {
	id_ = -1;
	inNdNo_ = -1;
	brNo_ = -1;
}

//clean all content of this external node
void ExNd::clean () {
	id_ = -1;
}

//--------------------------------------------------------------------
//set the indentical number for this ex nd
void ExNd::setId (const int id) {
	id_ = id;
}

//--------------------------------------------------------------------
//set the internal nd of this nd
void ExNd::setInNd (const int inNdNo) {
	inNdNo_ = inNdNo;
}

//--------------------------------------------------------------------
//set the br contacting this nd and the internal nd
void ExNd::setBr (const int brNo) {
	brNo_ = brNo;
}

//--------------------------------------------------------------------
//set all information for this ex nd
void ExNd::set (const int id, const int inNdNo, const int brNo) {
	this->id_ = id;
	this->inNdNo_ = inNdNo;
	this->brNo_ = brNo;
}

//--------------------------------------------------------------------
//get the indentical number of this ex nd
int ExNd::getId () {
	return id_;
}

//--------------------------------------------------------------------
//get the internal nd of this nd
int ExNd::getInNd () {
	return inNdNo_;
}

//--------------------------------------------------------------------
//get the brNo contacting this nd and the internal nd
int ExNd::getBr () {
	return brNo_;
}

//--------------------------------------------------------------------
//copy the ex nd into the ex nd
void ExNd::copy (ExNd &exNd) {
	this->id_ = exNd.getId ();
	this->inNdNo_ = exNd.getInNd ();
	this->brNo_ = exNd.getBr ();
}

//--------------------------------------------------------------------
//copy an external nd into this external nd
void ExNd::operator = (ExNd &exNd) {
	copy (exNd);
}

//--------------------------------------------------------------------
//change the internal of this external node
void ExNd::changeInNd (const int newInNdNo) {
	inNdNo_ = newInNdNo;
}

//--------------------------------------------------------------------
//change the branch no of this external node
void ExNd::changeBr (const int newBrNo) {
	brNo_ = newBrNo;
}

//--------------------------------------------------------------------
//release all memory of this class
void ExNd::release () {}

//--------------------------------------------------------------------
//destructor function for all releasing before deleting object
ExNd::~ExNd () {
	release ();
	//  std::cout << "the destructor of ExNd class " << endl;
}
