/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          prediction.cpp  -  description
                             -------------------
    begin                : Fri Nov 28 2003
    copyright            : (C) 2003 by Le Sy Vinh & Arndt von Haeseler
    email                : vinh@cs.uni-duesseldorf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "prediction.h"
#include "vec.h"
#include "outstream.h"

void Prediction::cmpInvMat (Mat<double> &oriMat, Mat<double> &invMat, int size) {
	invMat.setLimit (size, size);
	double eps = 1.0e-20; /* ! */
	int i, j, k, l, maxi=0, idx, ix, jx;
	double sum, tmp, maxb, aw;
	Vec<int> index (size, size);
	double *wk;
	Mat<double> omtrx (size, size);



	/* copy oriMat to omtrx */
	for (i = 0; i < size; i++)
		for (j = 0; j < size; j++)
			omtrx[i][j] = oriMat[i][j];

	wk = (double *) calloc((size_t)size, sizeof(double));
	aw = 1.0;
	for (i = 0; i < size; i++) {
		maxb = 0.0;
		for (j = 0; j < size; j++) {
			if (fabs(omtrx[i][j]) > maxb)
				maxb = fabs(omtrx[i][j]);
		}
		if (maxb == 0.0) {
			/* Singular matrix */
			std::cout << "\n\n\nHALT: PLEASE REPORT ERROR D TO DEVELOPERS\n\n\n";
			//OutStream::write(oriMat, cout);
			exit(1);
		}
		wk[i] = 1.0 / maxb;
	}
	for (j = 0; j < size; j++) {
		for (i = 0; i < j; i++) {
			sum = omtrx[i][j];
			for (k = 0; k < i; k++)
				sum -= omtrx[i][k] * omtrx[k][j];
			omtrx[i][j] = sum;
		}
		maxb = 0.0;
		for (i = j; i < size; i++) {
			sum = omtrx[i][j];
			for (k = 0; k < j; k++)
				sum -= omtrx[i][k] * omtrx[k][j];
			omtrx[i][j] = sum;
			tmp = wk[i] * fabs(sum);
			if (tmp >= maxb) {
				maxb = tmp;
				maxi = i;
			}
		}
		if (j != maxi) {
			for (k = 0; k < size; k++) {
				tmp = omtrx[maxi][k];
				omtrx[maxi][k] = omtrx[j][k];
				omtrx[j][k] = tmp;
			}
			aw = -aw;
			wk[maxi] = wk[j];
		}
		index[j] = maxi;
		if (omtrx[j][j] == 0.0)
			omtrx[j][j] = eps;
		if (j != size - 1) {
			tmp = 1.0 / omtrx[j][j];
			for (i = j + 1; i < size; i++)
				omtrx[i][j] *= tmp;
		}
	}
	for (jx = 0; jx < size; jx++) {
		for (ix = 0; ix < size; ix++)
			wk[ix] = 0.0;
		wk[jx] = 1.0;
		l = -1;
		for (i = 0; i < size; i++) {
			idx = index[i];
			sum = wk[idx];
			wk[idx] = wk[i];
			if (l != -1) {
				for (j = l; j < i; j++)
					sum -= omtrx[i][j] * wk[j];
			} else if (sum != 0.0)
				l = i;
			wk[i] = sum;
		}
		for (i = size - 1; i >= 0; i--) {
			sum = wk[i];
			for (j = i + 1; j < size; j++)
				sum -= omtrx[i][j] * wk[j];
			wk[i] = sum / omtrx[i][i];
		}
		for (ix = 0; ix < size; ix++)
			invMat[ix][jx] = wk[ix];
	}
	free((char *)wk);
	wk = NULL;
} /* luinverse */

void Prediction::readMat (char *fileName, Mat<double> &oriMat, int &size) {
	std::ifstream inFile_;
	inFile_.open(fileName);
	inFile_ >> size;
	oriMat.setLimit (size, size);
	for (int row_ = 0; row_ < size; row_ ++)
		for (int col_ = 0; col_ < size; col_ ++)
			inFile_ >> oriMat[row_][col_];
	inFile_.close ();

}

void Prediction::multiple (Mat<double> &mat1, Mat<double> &mat2, Mat<double> &proMat) {
	int row_, col_;
	proMat.setLimit (mat1.getNRow (), mat2.getNCol ());
	for (row_ = 0; row_ < mat1.getNRow (); row_ ++)
		for (col_ = 0; col_ < mat2.getNCol (); col_ ++) {
			proMat[row_][col_] = 0.0;
			for (int count_ = 0; count_ < mat1.getNCol (); count_ ++) {
				proMat[row_][col_] += mat1[row_][count_] * mat2[count_][col_];
				//         std::cout << mat1[row_][count_] << " --> " << mat2[count_][col_] << endl;
			}
		}
}

void Prediction::multiple (Mat<double> &mat1, Vec<double> &vec2, Vec<double> &proVec) {
	int row_, col_;
	proVec.set (mat1.getNRow (), mat1.getNRow ());
	for (row_ = 0; row_ < mat1.getNRow (); row_ ++) {
		proVec[row_] = 0.0;
		for (col_ = 0; col_ < mat1.getNCol (); col_ ++)
			proVec[row_] += mat1[row_][col_] * vec2[col_];
	}
}

void Prediction::multiple (Vec<double> &vec1, Mat<double> &mat2, Vec<double> &proVec) {
	int row_, col_;
	proVec.set (mat2.getNCol(), mat2.getNCol ());
	for (col_ = 0; col_ < mat2.getNCol (); col_ ++) {
		proVec[col_] = 0.0;
		for (row_ = 0; row_ < mat2.getNRow (); row_ ++)
			proVec[col_] += vec1[row_] * mat2[row_][col_];
	}
}

void Prediction::multiple (Vec<double> &vec1, Vec<double> &vec2, Mat<double> &proMat) {
	int row_, col_;
	proMat.setLimit (vec1.getSize (), vec2.getSize ());
	for (row_ = 0; row_ < vec1.getSize (); row_ ++)
		for (col_ = 0; col_ < vec2.getSize (); col_ ++)
			proMat[row_][col_] = vec1[row_] * vec2[col_];
}

double Prediction::multiple (Vec<double> &vec1, Vec<double> &vec2) {
	double sum_ = 0.0;
	for (int count_ = 0; count_ < vec1.getSize (); count_ ++)
		sum_ += vec1[count_] * vec2[count_];
	return sum_;
}

/* THE FOLLOWING CODE COMES FROM tools.c in Yang's PAML package */
//----------------------------------------------------------------------------------------
double Prediction::cmpLnGamma (double alpha) {
	/* returns ln(gamma(alpha)) for alpha>0, accurate to 10 decimal places.
	   Stirling's formula is used for the central polynomial part of the procedure.
	   Pike MC & Hill ID (1966) Algorithm 291: Logarithm of the gamma function.
	   Communications of the Association for Computing Machinery, 9:684
	*/
	double x=alpha, f=0, z;

	if (x<7) {
		f=1;  z=x-1;
		while (++z<7)  f*=z;
		x=z;   f=-log(f);
	}
	z = 1/(x*x);
	return  f + (x-0.5)*log(x) - x + .918938533204673
	        + (((-.000595238095238*z+.000793650793651)*z-.002777777777778)*z
	           +.083333333333333)/x;
} //end of function cmpLnGamma



void Prediction::readFile (const char *fileName) {
	std::ifstream inFile_;
	inFile_.open (fileName);

	nTime_ = 0;


	Vec<double> tmpTimeVec_;// (MAX_ITERATION, MAX_ITERATION);
	
	double old_time = -1.0;
	while (inFile_.eof () == 0) {
		double tmpTime_ = -1.0;
		inFile_ >> tmpTime_;
		if (tmpTime_ > old_time) {
			tmpTimeVec_.add(tmpTime_);
			nTime_ ++;
			old_time = tmpTime_;
		}
	}
	inFile_.close ();

	timeVec_.set (nTime_, nTime_);
	for (int count_ = 0; count_ < nTime_; count_ ++)
		timeVec_[count_] = tmpTimeVec_[nTime_ - count_ - 1];
}

double Prediction::cmpMuy (int k) {
	double sum_ = 0.0;

	for (int i = 0; i < k - 2; i ++)
		sum_ += log ( (timeVec_[0] - timeVec_[ k - 1]) / (timeVec_[0] - timeVec_[i + 1]) );

	double lamda_;
	lamda_ = (1.0 / (k - 1.0) ) * sum_;
	return lamda_;
}


void Prediction::cmpLamdaMat (int k, Mat<double> &lamdaMat) {
	lamdaMat.setLimit (k, k);
	double muy_ = cmpMuy (k);
	for (int i = 0; i < k; i ++)
		for (int j = 0; j <= i; j ++) {
			/*
			lamdaMat[i][j] = (cmpGamma (2*muy_ + i + 1) * cmpGamma (muy_ + j + 1) ) /
			                 ( cmpGamma (muy_ + i + 1) * cmpGamma (j + 1) );*/

			// to fix divide by zero PROBLEM!
			lamdaMat[i][j] = cmpLnGamma (2*muy_ + i + 1) + cmpLnGamma (muy_ + j + 1) -
			                 cmpLnGamma (muy_ + i + 1) - cmpLnGamma (j + 1);

			//if (i == 98 && j == 97)
			 //     std::cout << i << "," << j << " -> " << lamdaMat[i][j] << endl;
			lamdaMat[i][j] = exp(lamdaMat[i][j]);
			lamdaMat[j][i] = lamdaMat[i][j];
		}
}

void Prediction::cmpVecA (int k, Vec<double> &aVec) {
	Vec<double> eVec_ (k, k);
	int count_;
	for (count_ = 0; count_ < k; count_ ++)
		eVec_[count_] = 1.0;

	Mat<double> lamdaMat_;
	cmpLamdaMat (k, lamdaMat_);
	 // OutStream::write (lamdaMat_, std::cout);

	Mat<double> invLamdaMat_;
	cmpInvMat (lamdaMat_, invLamdaMat_, k);

	//  OutStream::write (invLamdaMat_, std::cout);

	Mat<double> proMat_;
	multiple (lamdaMat_, invLamdaMat_, proMat_);
	//OutStream::write (proMat_, std::cout);


	Vec<double> tmp1Vec_;
	multiple (eVec_, invLamdaMat_, tmp1Vec_);
	//OutStream::write (tmp1Vec_, std::cout);
	double tmp2_ = multiple (tmp1Vec_, eVec_);
	double invTmp2_ = 1.0 / tmp2_;

	for (int row_ = 0; row_ < k; row_ ++)
		for (int col_ = 0; col_ < k; col_ ++)
			invLamdaMat_[row_][col_] *= invTmp2_;


	Vec<double> tmp3Vec_;
	multiple (invLamdaMat_, eVec_, aVec);
}

double Prediction::cmpExtinctTime (int k) {
	Vec<double> a;
	cmpVecA (k, a);
	double extinctTime_ = 0.0;
	for (int count_ = 0; count_ < k; count_ ++)
		extinctTime_ += a[count_] * timeVec_[count_];
	return extinctTime_;
}



double Prediction::cmpUpperTime (int k, double alpha) {
	double muy_ = cmpMuy (k);
	double priSu_ = -log (alpha) / k ;
	double su_ = pow (priSu_, -muy_);
	return timeVec_[0] + (timeVec_[0] - timeVec_[k - 1]) / (su_ - 1.0);
}

double Prediction::predict (const char *fileName, double confidentVal, double &upperTime) {
	readFile (fileName);
	// OutStream::write (timeVec_, std::cout) << endl;
	double predictedTime_ = cmpExtinctTime (nTime_);
	//  std::cout.precision (10);
	//std::cout << predictedTime_ << endl;

	// double lowerTime_ = cmpLowerTime (time, 1.0 - 0.95);
	// std::cout << lowerTime_ << endl;


	upperTime = cmpUpperTime (nTime_, 1.0 - confidentVal);
	//std::cout << upperTime << endl;

	return predictedTime_;
}
