import { useCallback, useMemo } from "react";
import useQueryParams from "./useQueryParams";
const useQueryParam = (name, paramConfig, options) => {
  const paramConfigMap = useMemo(
    () => ({ [name]: paramConfig != null ? paramConfig : "inherit" }),
    [name, paramConfig]
  );
  const [query, setQuery] = useQueryParams(paramConfigMap, options);
  const decodedValue = query[name];
  const setValue = useCallback(
    (newValue, updateType) => {
      if (typeof newValue === "function") {
        return setQuery((latestValues) => {
          const newValueFromLatest = newValue(latestValues[name]);
          return { [name]: newValueFromLatest };
        }, updateType);
      }
      return setQuery({ [name]: newValue }, updateType);
    },
    [name, setQuery]
  );
  return [decodedValue, setValue];
};
export {
  useQueryParam
};
//# sourceMappingURL=useQueryParam.js.map
