"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = createMountWrapper;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _RootFinder = _interopRequireDefault(require("./RootFinder"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var stringOrFunction = _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].string]);
var makeValidElementType = function makeValidElementType(adapter) {
  if (!adapter) {
    return stringOrFunction;
  }
  function validElementTypeRequired(props, propName) {
    if (!adapter.isValidElementType) {
      for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        args[_key - 2] = arguments[_key];
      }
      return stringOrFunction.isRequired.apply(stringOrFunction, [props, propName].concat(args));
    }
    var propValue = props[propName];
    if (adapter.isValidElementType(propValue)) {
      return null;
    }
    return new TypeError("".concat(propName, " must be a valid element type!"));
  }
  function validElementType(props, propName) {
    var propValue = props[propName];
    if (propValue == null) {
      return null;
    }
    for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
      args[_key2 - 2] = arguments[_key2];
    }
    return validElementTypeRequired.apply(void 0, [props, propName].concat(args));
  }
  validElementType.isRequired = validElementTypeRequired;
  return validElementType;
};

/**
 * This is a utility component to wrap around the nodes we are
 * passing in to `mount()`. Theoretically, you could do everything
 * we are doing without this, but this makes it easier since
 * `renderIntoDocument()` doesn't really pass back a reference to
 * the DOM node it rendered to, so we can't really "re-render" to
 * pass new props in.
 */
function createMountWrapper(node) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var adapter = options.adapter,
    WrappingComponent = options.wrappingComponent;
  var WrapperComponent = /*#__PURE__*/function (_React$Component) {
    _inherits(WrapperComponent, _React$Component);
    var _super = _createSuper(WrapperComponent);
    function WrapperComponent() {
      var _this;
      _classCallCheck(this, WrapperComponent);
      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }
      _this = _super.call.apply(_super, [this].concat(args));
      var _this$props = _this.props,
        props = _this$props.props,
        wrappingComponentProps = _this$props.wrappingComponentProps,
        context = _this$props.context;
      _this.state = {
        mount: true,
        props: props,
        wrappingComponentProps: wrappingComponentProps,
        context: context
      };
      return _this;
    }
    _createClass(WrapperComponent, [{
      key: "setChildProps",
      value: function setChildProps(newProps, newContext) {
        var callback = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : undefined;
        var _this$state = this.state,
          oldProps = _this$state.props,
          oldContext = _this$state.context;
        var props = _objectSpread(_objectSpread({}, oldProps), newProps);
        var context = _objectSpread(_objectSpread({}, oldContext), newContext);
        this.setState({
          props: props,
          context: context
        }, callback);
      }
    }, {
      key: "setWrappingComponentProps",
      value: function setWrappingComponentProps(props) {
        var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;
        this.setState({
          wrappingComponentProps: props
        }, callback);
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props2 = this.props,
          Component = _this$props2.Component,
          refProp = _this$props2.refProp;
        var _this$state2 = this.state,
          mount = _this$state2.mount,
          props = _this$state2.props,
          wrappingComponentProps = _this$state2.wrappingComponentProps;
        if (!mount) return null;
        var component = /*#__PURE__*/_react["default"].createElement(Component, _extends({
          ref: refProp
        }, props));
        if (WrappingComponent) {
          return /*#__PURE__*/_react["default"].createElement(WrappingComponent, wrappingComponentProps, /*#__PURE__*/_react["default"].createElement(_RootFinder["default"], null, component));
        }
        return component;
      }
    }]);
    return WrapperComponent;
  }(_react["default"].Component);
  WrapperComponent.propTypes = {
    Component: makeValidElementType(adapter).isRequired,
    context: _propTypes["default"].object,
    props: _propTypes["default"].object.isRequired,
    refProp: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].func, _propTypes["default"].shape({
      current: _propTypes["default"].any
    })]),
    wrappingComponentProps: _propTypes["default"].object
  };
  WrapperComponent.defaultProps = {
    refProp: null,
    context: null,
    wrappingComponentProps: null
  };
  if (options.context && (node.type.contextTypes || options.childContextTypes)) {
    // For full rendering, we are using this wrapper component to provide context if it is
    // specified in both the options AND the child component defines `contextTypes` statically
    // OR the merged context types for all children (the node component or deeper children) are
    // specified in options parameter under childContextTypes.
    // In that case, we define both a `getChildContext()` function and a `childContextTypes` prop.
    var childContextTypes = _objectSpread(_objectSpread({}, node.type.contextTypes), options.childContextTypes);
    WrapperComponent.prototype.getChildContext = function getChildContext() {
      return this.state.context;
    };
    WrapperComponent.childContextTypes = childContextTypes;
  }
  return WrapperComponent;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJzdHJpbmdPckZ1bmN0aW9uIiwiUHJvcFR5cGVzIiwib25lT2ZUeXBlIiwiZnVuYyIsInN0cmluZyIsIm1ha2VWYWxpZEVsZW1lbnRUeXBlIiwiYWRhcHRlciIsInZhbGlkRWxlbWVudFR5cGVSZXF1aXJlZCIsInByb3BzIiwicHJvcE5hbWUiLCJpc1ZhbGlkRWxlbWVudFR5cGUiLCJhcmdzIiwiaXNSZXF1aXJlZCIsInByb3BWYWx1ZSIsIlR5cGVFcnJvciIsInZhbGlkRWxlbWVudFR5cGUiLCJjcmVhdGVNb3VudFdyYXBwZXIiLCJub2RlIiwib3B0aW9ucyIsIldyYXBwaW5nQ29tcG9uZW50Iiwid3JhcHBpbmdDb21wb25lbnQiLCJXcmFwcGVyQ29tcG9uZW50Iiwid3JhcHBpbmdDb21wb25lbnRQcm9wcyIsImNvbnRleHQiLCJzdGF0ZSIsIm1vdW50IiwibmV3UHJvcHMiLCJuZXdDb250ZXh0IiwiY2FsbGJhY2siLCJ1bmRlZmluZWQiLCJvbGRQcm9wcyIsIm9sZENvbnRleHQiLCJzZXRTdGF0ZSIsIkNvbXBvbmVudCIsInJlZlByb3AiLCJjb21wb25lbnQiLCJSZWFjdCIsInByb3BUeXBlcyIsIm9iamVjdCIsInNoYXBlIiwiY3VycmVudCIsImFueSIsImRlZmF1bHRQcm9wcyIsInR5cGUiLCJjb250ZXh0VHlwZXMiLCJjaGlsZENvbnRleHRUeXBlcyIsInByb3RvdHlwZSIsImdldENoaWxkQ29udGV4dCJdLCJzb3VyY2VzIjpbIi4uL3NyYy9jcmVhdGVNb3VudFdyYXBwZXIuanN4Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IFJvb3RGaW5kZXIgZnJvbSAnLi9Sb290RmluZGVyJztcblxuY29uc3Qgc3RyaW5nT3JGdW5jdGlvbiA9IFByb3BUeXBlcy5vbmVPZlR5cGUoW1Byb3BUeXBlcy5mdW5jLCBQcm9wVHlwZXMuc3RyaW5nXSk7XG5jb25zdCBtYWtlVmFsaWRFbGVtZW50VHlwZSA9IChhZGFwdGVyKSA9PiB7XG4gIGlmICghYWRhcHRlcikge1xuICAgIHJldHVybiBzdHJpbmdPckZ1bmN0aW9uO1xuICB9XG5cbiAgZnVuY3Rpb24gdmFsaWRFbGVtZW50VHlwZVJlcXVpcmVkKHByb3BzLCBwcm9wTmFtZSwgLi4uYXJncykge1xuICAgIGlmICghYWRhcHRlci5pc1ZhbGlkRWxlbWVudFR5cGUpIHtcbiAgICAgIHJldHVybiBzdHJpbmdPckZ1bmN0aW9uLmlzUmVxdWlyZWQocHJvcHMsIHByb3BOYW1lLCAuLi5hcmdzKTtcbiAgICB9XG4gICAgY29uc3QgcHJvcFZhbHVlID0gcHJvcHNbcHJvcE5hbWVdO1xuICAgIGlmIChhZGFwdGVyLmlzVmFsaWRFbGVtZW50VHlwZShwcm9wVmFsdWUpKSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG4gICAgcmV0dXJuIG5ldyBUeXBlRXJyb3IoYCR7cHJvcE5hbWV9IG11c3QgYmUgYSB2YWxpZCBlbGVtZW50IHR5cGUhYCk7XG4gIH1cblxuICBmdW5jdGlvbiB2YWxpZEVsZW1lbnRUeXBlKHByb3BzLCBwcm9wTmFtZSwgLi4uYXJncykge1xuICAgIGNvbnN0IHByb3BWYWx1ZSA9IHByb3BzW3Byb3BOYW1lXTtcbiAgICBpZiAocHJvcFZhbHVlID09IG51bGwpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cbiAgICByZXR1cm4gdmFsaWRFbGVtZW50VHlwZVJlcXVpcmVkKHByb3BzLCBwcm9wTmFtZSwgLi4uYXJncyk7XG4gIH1cbiAgdmFsaWRFbGVtZW50VHlwZS5pc1JlcXVpcmVkID0gdmFsaWRFbGVtZW50VHlwZVJlcXVpcmVkO1xuXG4gIHJldHVybiB2YWxpZEVsZW1lbnRUeXBlO1xufTtcblxuLyoqXG4gKiBUaGlzIGlzIGEgdXRpbGl0eSBjb21wb25lbnQgdG8gd3JhcCBhcm91bmQgdGhlIG5vZGVzIHdlIGFyZVxuICogcGFzc2luZyBpbiB0byBgbW91bnQoKWAuIFRoZW9yZXRpY2FsbHksIHlvdSBjb3VsZCBkbyBldmVyeXRoaW5nXG4gKiB3ZSBhcmUgZG9pbmcgd2l0aG91dCB0aGlzLCBidXQgdGhpcyBtYWtlcyBpdCBlYXNpZXIgc2luY2VcbiAqIGByZW5kZXJJbnRvRG9jdW1lbnQoKWAgZG9lc24ndCByZWFsbHkgcGFzcyBiYWNrIGEgcmVmZXJlbmNlIHRvXG4gKiB0aGUgRE9NIG5vZGUgaXQgcmVuZGVyZWQgdG8sIHNvIHdlIGNhbid0IHJlYWxseSBcInJlLXJlbmRlclwiIHRvXG4gKiBwYXNzIG5ldyBwcm9wcyBpbi5cbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gY3JlYXRlTW91bnRXcmFwcGVyKG5vZGUsIG9wdGlvbnMgPSB7fSkge1xuICBjb25zdCB7IGFkYXB0ZXIsIHdyYXBwaW5nQ29tcG9uZW50OiBXcmFwcGluZ0NvbXBvbmVudCB9ID0gb3B0aW9ucztcblxuICBjbGFzcyBXcmFwcGVyQ29tcG9uZW50IGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgICBjb25zdHJ1Y3RvciguLi5hcmdzKSB7XG4gICAgICBzdXBlciguLi5hcmdzKTtcbiAgICAgIGNvbnN0IHsgcHJvcHMsIHdyYXBwaW5nQ29tcG9uZW50UHJvcHMsIGNvbnRleHQgfSA9IHRoaXMucHJvcHM7XG4gICAgICB0aGlzLnN0YXRlID0ge1xuICAgICAgICBtb3VudDogdHJ1ZSxcbiAgICAgICAgcHJvcHMsXG4gICAgICAgIHdyYXBwaW5nQ29tcG9uZW50UHJvcHMsXG4gICAgICAgIGNvbnRleHQsXG4gICAgICB9O1xuICAgIH1cblxuICAgIHNldENoaWxkUHJvcHMobmV3UHJvcHMsIG5ld0NvbnRleHQsIGNhbGxiYWNrID0gdW5kZWZpbmVkKSB7XG4gICAgICBjb25zdCB7IHByb3BzOiBvbGRQcm9wcywgY29udGV4dDogb2xkQ29udGV4dCB9ID0gdGhpcy5zdGF0ZTtcbiAgICAgIGNvbnN0IHByb3BzID0geyAuLi5vbGRQcm9wcywgLi4ubmV3UHJvcHMgfTtcbiAgICAgIGNvbnN0IGNvbnRleHQgPSB7IC4uLm9sZENvbnRleHQsIC4uLm5ld0NvbnRleHQgfTtcbiAgICAgIHRoaXMuc2V0U3RhdGUoeyBwcm9wcywgY29udGV4dCB9LCBjYWxsYmFjayk7XG4gICAgfVxuXG4gICAgc2V0V3JhcHBpbmdDb21wb25lbnRQcm9wcyhwcm9wcywgY2FsbGJhY2sgPSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuc2V0U3RhdGUoeyB3cmFwcGluZ0NvbXBvbmVudFByb3BzOiBwcm9wcyB9LCBjYWxsYmFjayk7XG4gICAgfVxuXG4gICAgcmVuZGVyKCkge1xuICAgICAgY29uc3QgeyBDb21wb25lbnQsIHJlZlByb3AgfSA9IHRoaXMucHJvcHM7XG4gICAgICBjb25zdCB7IG1vdW50LCBwcm9wcywgd3JhcHBpbmdDb21wb25lbnRQcm9wcyB9ID0gdGhpcy5zdGF0ZTtcbiAgICAgIGlmICghbW91bnQpIHJldHVybiBudWxsO1xuICAgICAgY29uc3QgY29tcG9uZW50ID0gPENvbXBvbmVudCByZWY9e3JlZlByb3B9IHsuLi5wcm9wc30gLz47XG4gICAgICBpZiAoV3JhcHBpbmdDb21wb25lbnQpIHtcbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICA8V3JhcHBpbmdDb21wb25lbnQgey4uLndyYXBwaW5nQ29tcG9uZW50UHJvcHN9PlxuICAgICAgICAgICAgPFJvb3RGaW5kZXI+e2NvbXBvbmVudH08L1Jvb3RGaW5kZXI+XG4gICAgICAgICAgPC9XcmFwcGluZ0NvbXBvbmVudD5cbiAgICAgICAgKTtcbiAgICAgIH1cbiAgICAgIHJldHVybiBjb21wb25lbnQ7XG4gICAgfVxuICB9XG4gIFdyYXBwZXJDb21wb25lbnQucHJvcFR5cGVzID0ge1xuICAgIENvbXBvbmVudDogbWFrZVZhbGlkRWxlbWVudFR5cGUoYWRhcHRlcikuaXNSZXF1aXJlZCxcbiAgICBjb250ZXh0OiBQcm9wVHlwZXMub2JqZWN0LFxuICAgIHByb3BzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgcmVmUHJvcDogUHJvcFR5cGVzLm9uZU9mVHlwZShbXG4gICAgICBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgUHJvcFR5cGVzLmZ1bmMsXG4gICAgICBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICBjdXJyZW50OiBQcm9wVHlwZXMuYW55LFxuICAgICAgfSksXG4gICAgXSksXG4gICAgd3JhcHBpbmdDb21wb25lbnRQcm9wczogUHJvcFR5cGVzLm9iamVjdCxcbiAgfTtcbiAgV3JhcHBlckNvbXBvbmVudC5kZWZhdWx0UHJvcHMgPSB7XG4gICAgcmVmUHJvcDogbnVsbCxcbiAgICBjb250ZXh0OiBudWxsLFxuICAgIHdyYXBwaW5nQ29tcG9uZW50UHJvcHM6IG51bGwsXG4gIH07XG5cbiAgaWYgKG9wdGlvbnMuY29udGV4dCAmJiAobm9kZS50eXBlLmNvbnRleHRUeXBlcyB8fCBvcHRpb25zLmNoaWxkQ29udGV4dFR5cGVzKSkge1xuICAgIC8vIEZvciBmdWxsIHJlbmRlcmluZywgd2UgYXJlIHVzaW5nIHRoaXMgd3JhcHBlciBjb21wb25lbnQgdG8gcHJvdmlkZSBjb250ZXh0IGlmIGl0IGlzXG4gICAgLy8gc3BlY2lmaWVkIGluIGJvdGggdGhlIG9wdGlvbnMgQU5EIHRoZSBjaGlsZCBjb21wb25lbnQgZGVmaW5lcyBgY29udGV4dFR5cGVzYCBzdGF0aWNhbGx5XG4gICAgLy8gT1IgdGhlIG1lcmdlZCBjb250ZXh0IHR5cGVzIGZvciBhbGwgY2hpbGRyZW4gKHRoZSBub2RlIGNvbXBvbmVudCBvciBkZWVwZXIgY2hpbGRyZW4pIGFyZVxuICAgIC8vIHNwZWNpZmllZCBpbiBvcHRpb25zIHBhcmFtZXRlciB1bmRlciBjaGlsZENvbnRleHRUeXBlcy5cbiAgICAvLyBJbiB0aGF0IGNhc2UsIHdlIGRlZmluZSBib3RoIGEgYGdldENoaWxkQ29udGV4dCgpYCBmdW5jdGlvbiBhbmQgYSBgY2hpbGRDb250ZXh0VHlwZXNgIHByb3AuXG4gICAgY29uc3QgY2hpbGRDb250ZXh0VHlwZXMgPSB7XG4gICAgICAuLi5ub2RlLnR5cGUuY29udGV4dFR5cGVzLFxuICAgICAgLi4ub3B0aW9ucy5jaGlsZENvbnRleHRUeXBlcyxcbiAgICB9O1xuXG4gICAgV3JhcHBlckNvbXBvbmVudC5wcm90b3R5cGUuZ2V0Q2hpbGRDb250ZXh0ID0gZnVuY3Rpb24gZ2V0Q2hpbGRDb250ZXh0KCkge1xuICAgICAgcmV0dXJuIHRoaXMuc3RhdGUuY29udGV4dDtcbiAgICB9O1xuICAgIFdyYXBwZXJDb21wb25lbnQuY2hpbGRDb250ZXh0VHlwZXMgPSBjaGlsZENvbnRleHRUeXBlcztcbiAgfVxuICByZXR1cm4gV3JhcHBlckNvbXBvbmVudDtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUFzQztBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFFdEMsSUFBTUEsZ0JBQWdCLEdBQUdDLHFCQUFTLENBQUNDLFNBQVMsQ0FBQyxDQUFDRCxxQkFBUyxDQUFDRSxJQUFJLEVBQUVGLHFCQUFTLENBQUNHLE1BQU0sQ0FBQyxDQUFDO0FBQ2hGLElBQU1DLG9CQUFvQixHQUFHLFNBQXZCQSxvQkFBb0IsQ0FBSUMsT0FBTyxFQUFLO0VBQ3hDLElBQUksQ0FBQ0EsT0FBTyxFQUFFO0lBQ1osT0FBT04sZ0JBQWdCO0VBQ3pCO0VBRUEsU0FBU08sd0JBQXdCLENBQUNDLEtBQUssRUFBRUMsUUFBUSxFQUFXO0lBQzFELElBQUksQ0FBQ0gsT0FBTyxDQUFDSSxrQkFBa0IsRUFBRTtNQUFBLGtDQURtQkMsSUFBSTtRQUFKQSxJQUFJO01BQUE7TUFFdEQsT0FBT1gsZ0JBQWdCLENBQUNZLFVBQVUsT0FBM0JaLGdCQUFnQixHQUFZUSxLQUFLLEVBQUVDLFFBQVEsU0FBS0UsSUFBSSxFQUFDO0lBQzlEO0lBQ0EsSUFBTUUsU0FBUyxHQUFHTCxLQUFLLENBQUNDLFFBQVEsQ0FBQztJQUNqQyxJQUFJSCxPQUFPLENBQUNJLGtCQUFrQixDQUFDRyxTQUFTLENBQUMsRUFBRTtNQUN6QyxPQUFPLElBQUk7SUFDYjtJQUNBLE9BQU8sSUFBSUMsU0FBUyxXQUFJTCxRQUFRLG9DQUFpQztFQUNuRTtFQUVBLFNBQVNNLGdCQUFnQixDQUFDUCxLQUFLLEVBQUVDLFFBQVEsRUFBVztJQUNsRCxJQUFNSSxTQUFTLEdBQUdMLEtBQUssQ0FBQ0MsUUFBUSxDQUFDO0lBQ2pDLElBQUlJLFNBQVMsSUFBSSxJQUFJLEVBQUU7TUFDckIsT0FBTyxJQUFJO0lBQ2I7SUFBQyxtQ0FKMkNGLElBQUk7TUFBSkEsSUFBSTtJQUFBO0lBS2hELE9BQU9KLHdCQUF3QixnQkFBQ0MsS0FBSyxFQUFFQyxRQUFRLFNBQUtFLElBQUksRUFBQztFQUMzRDtFQUNBSSxnQkFBZ0IsQ0FBQ0gsVUFBVSxHQUFHTCx3QkFBd0I7RUFFdEQsT0FBT1EsZ0JBQWdCO0FBQ3pCLENBQUM7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNlLFNBQVNDLGtCQUFrQixDQUFDQyxJQUFJLEVBQWdCO0VBQUEsSUFBZEMsT0FBTyx1RUFBRyxDQUFDLENBQUM7RUFDM0QsSUFBUVosT0FBTyxHQUEyQ1ksT0FBTyxDQUF6RFosT0FBTztJQUFxQmEsaUJBQWlCLEdBQUtELE9BQU8sQ0FBaERFLGlCQUFpQjtFQUFnQyxJQUU1REMsZ0JBQWdCO0lBQUE7SUFBQTtJQUNwQiw0QkFBcUI7TUFBQTtNQUFBO01BQUEsbUNBQU5WLElBQUk7UUFBSkEsSUFBSTtNQUFBO01BQ2pCLGdEQUFTQSxJQUFJO01BQ2Isa0JBQW1ELE1BQUtILEtBQUs7UUFBckRBLEtBQUssZUFBTEEsS0FBSztRQUFFYyxzQkFBc0IsZUFBdEJBLHNCQUFzQjtRQUFFQyxPQUFPLGVBQVBBLE9BQU87TUFDOUMsTUFBS0MsS0FBSyxHQUFHO1FBQ1hDLEtBQUssRUFBRSxJQUFJO1FBQ1hqQixLQUFLLEVBQUxBLEtBQUs7UUFDTGMsc0JBQXNCLEVBQXRCQSxzQkFBc0I7UUFDdEJDLE9BQU8sRUFBUEE7TUFDRixDQUFDO01BQUM7SUFDSjtJQUFDO01BQUE7TUFBQSxPQUVELHVCQUFjRyxRQUFRLEVBQUVDLFVBQVUsRUFBd0I7UUFBQSxJQUF0QkMsUUFBUSx1RUFBR0MsU0FBUztRQUN0RCxrQkFBaUQsSUFBSSxDQUFDTCxLQUFLO1VBQTVDTSxRQUFRLGVBQWZ0QixLQUFLO1VBQXFCdUIsVUFBVSxlQUFuQlIsT0FBTztRQUNoQyxJQUFNZixLQUFLLG1DQUFRc0IsUUFBUSxHQUFLSixRQUFRLENBQUU7UUFDMUMsSUFBTUgsT0FBTyxtQ0FBUVEsVUFBVSxHQUFLSixVQUFVLENBQUU7UUFDaEQsSUFBSSxDQUFDSyxRQUFRLENBQUM7VUFBRXhCLEtBQUssRUFBTEEsS0FBSztVQUFFZSxPQUFPLEVBQVBBO1FBQVEsQ0FBQyxFQUFFSyxRQUFRLENBQUM7TUFDN0M7SUFBQztNQUFBO01BQUEsT0FFRCxtQ0FBMEJwQixLQUFLLEVBQXdCO1FBQUEsSUFBdEJvQixRQUFRLHVFQUFHQyxTQUFTO1FBQ25ELElBQUksQ0FBQ0csUUFBUSxDQUFDO1VBQUVWLHNCQUFzQixFQUFFZDtRQUFNLENBQUMsRUFBRW9CLFFBQVEsQ0FBQztNQUM1RDtJQUFDO01BQUE7TUFBQSxPQUVELGtCQUFTO1FBQ1AsbUJBQStCLElBQUksQ0FBQ3BCLEtBQUs7VUFBakN5QixTQUFTLGdCQUFUQSxTQUFTO1VBQUVDLE9BQU8sZ0JBQVBBLE9BQU87UUFDMUIsbUJBQWlELElBQUksQ0FBQ1YsS0FBSztVQUFuREMsS0FBSyxnQkFBTEEsS0FBSztVQUFFakIsS0FBSyxnQkFBTEEsS0FBSztVQUFFYyxzQkFBc0IsZ0JBQXRCQSxzQkFBc0I7UUFDNUMsSUFBSSxDQUFDRyxLQUFLLEVBQUUsT0FBTyxJQUFJO1FBQ3ZCLElBQU1VLFNBQVMsZ0JBQUcsZ0NBQUMsU0FBUztVQUFDLEdBQUcsRUFBRUQ7UUFBUSxHQUFLMUIsS0FBSyxFQUFJO1FBQ3hELElBQUlXLGlCQUFpQixFQUFFO1VBQ3JCLG9CQUNFLGdDQUFDLGlCQUFpQixFQUFLRyxzQkFBc0IsZUFDM0MsZ0NBQUMsc0JBQVUsUUFBRWEsU0FBUyxDQUFjLENBQ2xCO1FBRXhCO1FBQ0EsT0FBT0EsU0FBUztNQUNsQjtJQUFDO0lBQUE7RUFBQSxFQXBDNEJDLGlCQUFLLENBQUNILFNBQVM7RUFzQzlDWixnQkFBZ0IsQ0FBQ2dCLFNBQVMsR0FBRztJQUMzQkosU0FBUyxFQUFFNUIsb0JBQW9CLENBQUNDLE9BQU8sQ0FBQyxDQUFDTSxVQUFVO0lBQ25EVyxPQUFPLEVBQUV0QixxQkFBUyxDQUFDcUMsTUFBTTtJQUN6QjlCLEtBQUssRUFBRVAscUJBQVMsQ0FBQ3FDLE1BQU0sQ0FBQzFCLFVBQVU7SUFDbENzQixPQUFPLEVBQUVqQyxxQkFBUyxDQUFDQyxTQUFTLENBQUMsQ0FDM0JELHFCQUFTLENBQUNHLE1BQU0sRUFDaEJILHFCQUFTLENBQUNFLElBQUksRUFDZEYscUJBQVMsQ0FBQ3NDLEtBQUssQ0FBQztNQUNkQyxPQUFPLEVBQUV2QyxxQkFBUyxDQUFDd0M7SUFDckIsQ0FBQyxDQUFDLENBQ0gsQ0FBQztJQUNGbkIsc0JBQXNCLEVBQUVyQixxQkFBUyxDQUFDcUM7RUFDcEMsQ0FBQztFQUNEakIsZ0JBQWdCLENBQUNxQixZQUFZLEdBQUc7SUFDOUJSLE9BQU8sRUFBRSxJQUFJO0lBQ2JYLE9BQU8sRUFBRSxJQUFJO0lBQ2JELHNCQUFzQixFQUFFO0VBQzFCLENBQUM7RUFFRCxJQUFJSixPQUFPLENBQUNLLE9BQU8sS0FBS04sSUFBSSxDQUFDMEIsSUFBSSxDQUFDQyxZQUFZLElBQUkxQixPQUFPLENBQUMyQixpQkFBaUIsQ0FBQyxFQUFFO0lBQzVFO0lBQ0E7SUFDQTtJQUNBO0lBQ0E7SUFDQSxJQUFNQSxpQkFBaUIsbUNBQ2xCNUIsSUFBSSxDQUFDMEIsSUFBSSxDQUFDQyxZQUFZLEdBQ3RCMUIsT0FBTyxDQUFDMkIsaUJBQWlCLENBQzdCO0lBRUR4QixnQkFBZ0IsQ0FBQ3lCLFNBQVMsQ0FBQ0MsZUFBZSxHQUFHLFNBQVNBLGVBQWUsR0FBRztNQUN0RSxPQUFPLElBQUksQ0FBQ3ZCLEtBQUssQ0FBQ0QsT0FBTztJQUMzQixDQUFDO0lBQ0RGLGdCQUFnQixDQUFDd0IsaUJBQWlCLEdBQUdBLGlCQUFpQjtFQUN4RDtFQUNBLE9BQU94QixnQkFBZ0I7QUFDekIifQ==
//# sourceMappingURL=createMountWrapper.js.map