/* $Id: jpeg.c,v 1.1.1.1 2003/01/30 12:22:26 hito Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jpeglib.h>
#include <setjmp.h>
#include "stimg.h"

struct ImLib_JPEG_error_mgr
{
   struct jpeg_error_mgr pub;
   sigjmp_buf setjmp_buffer;
};
typedef struct ImLib_JPEG_error_mgr *emptr;

void _JPEGFatalErrorHandler(j_common_ptr cinfo);
void _JPEGErrorHandler(j_common_ptr cinfo);
void _JPEGErrorHandler2(j_common_ptr cinfo, int msg_level);

void
_JPEGFatalErrorHandler(j_common_ptr cinfo)
{
   emptr errmgr;

   errmgr = (emptr) cinfo->err;
/*   cinfo->err->output_message(cinfo);*/
   siglongjmp(errmgr->setjmp_buffer, 1);
   return;
}

void
_JPEGErrorHandler(j_common_ptr cinfo)
{
   emptr errmgr;

   errmgr = (emptr) cinfo->err;
/*   cinfo->err->output_message(cinfo);*/
/*   siglongjmp(errmgr->setjmp_buffer, 1);*/
   return;
}

void
_JPEGErrorHandler2(j_common_ptr cinfo, int msg_level)
{
   emptr errmgr;

   errmgr = (emptr) cinfo->err;
/*   cinfo->err->output_message(cinfo);*/
/*   siglongjmp(errmgr->setjmp_buffer, 1);*/
   return;
   msg_level = 0;
}

STIMG *
load_jpeg(char *file, int check)
{
   int w, h;
   struct jpeg_decompress_struct cinfo;
   struct ImLib_JPEG_error_mgr jerr;
   FILE *f;
   unsigned char *ptr, *line[16], *data, *ptr2;
   int x, y, l, i, j, scans, count, prevy;
   STIMG *image;

   if (file == NULL)
      return NULL;

   f = fopen(file, "rb");
   if (!f)
      return NULL;

   cinfo.err = jpeg_std_error(&(jerr.pub));
   jerr.pub.error_exit = _JPEGFatalErrorHandler;
   jerr.pub.emit_message = _JPEGErrorHandler2;
   jerr.pub.output_message = _JPEGErrorHandler;
   if (sigsetjmp(jerr.setjmp_buffer, 1))
   {
      jpeg_destroy_decompress(&cinfo);
      fclose(f);
      return NULL;
   }
   jpeg_create_decompress(&cinfo);
   jpeg_stdio_src(&cinfo, f);
   jpeg_read_header(&cinfo, TRUE);
   cinfo.do_fancy_upsampling = FALSE;
   cinfo.do_block_smoothing = FALSE;
   jpeg_start_decompress(&cinfo);

   w = cinfo.output_width;
   h = cinfo.output_height;

   if (cinfo.rec_outbuf_height > 16) {
     jpeg_destroy_decompress(&cinfo);
     fclose(f);
     return NULL;
   }

   data = malloc(w * 16 * 3);
   if (!data) {
     jpeg_destroy_decompress(&cinfo);
     fclose(f);
     return NULL;
   }

   image = stimg_new(w, h, 0);

   if (image == NULL || check) {
     free(data);
     jpeg_destroy_decompress(&cinfo);
     fclose(f);
     return image;
   }

   ptr2 = stimg_get_data(image);
   count = 0;
   prevy = 0;
   if (cinfo.output_components == 3) {
     for (i = 0; i < cinfo.rec_outbuf_height; i++)
       line[i] = data + (i * w * 3);
     for (l = 0; l < h; l += cinfo.rec_outbuf_height) {
       jpeg_read_scanlines(&cinfo, line, cinfo.rec_outbuf_height);
       scans = cinfo.rec_outbuf_height;
       if ((h - l) < scans)
	 scans = h - l;
       ptr = data;
       for (y = 0; y < scans; y++) {
	 memcpy(ptr2, ptr, w * 3);
	 ptr += w * 3;
	 ptr2 += w * 3;
       }
     }
   } else if (cinfo.output_components == 1) {
     for (i = 0; i < cinfo.rec_outbuf_height; i++)
       line[i] = data + (i * w);
     for (l = 0; l < h; l += cinfo.rec_outbuf_height) {
       jpeg_read_scanlines(&cinfo, line, cinfo.rec_outbuf_height);
       scans = cinfo.rec_outbuf_height;
       if ((h - l) < scans)
	 scans = h - l;
       ptr = data;
       for (y = 0; y < scans; y++) {
	 for (x = 0; x < w; x++) {
	   for (j = 0; j < 3; j++) {
	     *ptr2++ = *ptr;
	   }
	   ptr++;
	 }
       }
     }
   }
   free(data);
   jpeg_finish_decompress(&cinfo);
   jpeg_destroy_decompress(&cinfo);
   fclose(f);
   return image;
}

STIMG_ANIMATION *
load_animation_jpeg(char *file, int check)
{
  STIMG_ANIMATION *animation;
  STIMG *image;

  image = load_jpeg(file, check);
  if (image == NULL)
    return NULL;

  animation = stimg_animation_new();
  if (animation == NULL) {
    stimg_delete(image);
    return NULL;
  }

  stimg_animation_add_frame(animation, image, 0, 0, 0, 0);
  return animation;
}

